/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGCheckBox;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGComboBox;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGAxisPanel;
import jp.riken.brain.ni.samuraigraph.figure.SGIAxisConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIAxisPanelObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIAxisDialogObserver;

public class SGAxisDialog
extends SGPropertyDialog
implements SGIAxisConstants {
    private static final long serialVersionUID = 7038049338687502580L;
    public static final String TITLE = "Axis Properties";
    private int[] mAxisLocationArray = null;
    private JPanel mAxisCommonPanel;
    private JLabel mAxisLineLeftSpaceLabel;
    private JPanel mAxisLinePanel;
    private JLabel mAxisLineRightSpaceLabel;
    private JSeparator mAxisLineSeparator;
    private SGSpinner mAxisLineWidthSpinner;
    private JLabel mAxisWidthLabel1;
    private JLabel mAxisWidthLabel2;
    private JPanel mButtonPanel;
    private SGButton mCancelButton;
    private SGColorSelectionButton mFontColorButton;
    private JLabel mFontColorLabel;
    private JLabel mFontFamilyLabel;
    private JLabel mFontLabel;
    private SGComboBox mFontNameComboBox;
    private JSeparator mFontSeparator;
    private JLabel mFontSizeLabel;
    private SGSpinner mFontSizeSpinner;
    private JLabel mFontStyleLabel;
    private SGComboBox mFontTypeComboBox;
    private SGColorSelectionButton mFrameColorButton;
    private JLabel mFrameLabel;
    private JLabel mFrameLineColorLabel;
    private JLabel mFrameLineWidthLabel;
    private SGSpinner mFrameLineWidthSpinner;
    private SGCheckBox mFrameVisibleCheckBox;
    private SGColorSelectionButton mLineColorButton;
    private JLabel mLineColorLabel;
    private SGButton mOKButton;
    private SGButton mPreviewButton;
    private JLabel mScaleLengthLabel1;
    private JLabel mScaleLengthLabel2;
    private SGSpinner mScaleLineLengthSpinner;
    private SGSpinner mScaleLineWidthSpinner;
    private JLabel mScaleWidthLabel1;
    private JLabel mScaleWidthLabel2;
    private JTabbedPane mTabbedPane;

    public SGAxisDialog(Frame frame, boolean bl, int[] nArray) {
        super(frame, bl);
        this.initComponents();
        if (nArray == null) {
            throw new IllegalArgumentException("location == null");
        }
        this.mAxisLocationArray = (int[])nArray.clone();
        for (int i = 0; i < nArray.length; ++i) {
            String string = SGIFigureElementAxis.AXIS_LOCATION_TABLE[nArray[i]];
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.add(new SGAxisPanel(nArray[i]));
            this.mTabbedPane.addTab(string, jPanel);
        }
        this.initProperty();
        this.initialize();
    }

    private void initComponents() {
        this.mTabbedPane = new JTabbedPane();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new SGButton();
        this.mCancelButton = new SGButton();
        this.mPreviewButton = new SGButton();
        this.mAxisCommonPanel = new JPanel();
        this.mAxisLinePanel = new JPanel();
        this.mAxisLineSeparator = new JSeparator();
        this.mAxisWidthLabel1 = new JLabel();
        this.mAxisWidthLabel2 = new JLabel();
        this.mScaleWidthLabel1 = new JLabel();
        this.mScaleWidthLabel2 = new JLabel();
        this.mScaleLengthLabel1 = new JLabel();
        this.mScaleLengthLabel2 = new JLabel();
        this.mLineColorLabel = new JLabel();
        this.mAxisLineWidthSpinner = new SGSpinner();
        this.mScaleLineWidthSpinner = new SGSpinner();
        this.mScaleLineLengthSpinner = new SGSpinner();
        this.mLineColorButton = new SGColorSelectionButton();
        this.mAxisLineLeftSpaceLabel = new JLabel();
        this.mAxisLineRightSpaceLabel = new JLabel();
        this.mFontSeparator = new JSeparator();
        this.mFontLabel = new JLabel();
        this.mFontFamilyLabel = new JLabel();
        this.mFontSizeLabel = new JLabel();
        this.mFontColorLabel = new JLabel();
        this.mFontTypeComboBox = new SGComboBox();
        this.mFontSizeSpinner = new SGSpinner();
        this.mFontNameComboBox = new SGComboBox();
        this.mFontColorButton = new SGColorSelectionButton();
        this.mFrameLabel = new JLabel();
        this.mFrameVisibleCheckBox = new SGCheckBox();
        this.mFrameLineWidthLabel = new JLabel();
        this.mFrameLineColorLabel = new JLabel();
        this.mFrameLineWidthSpinner = new SGSpinner();
        this.mFrameColorButton = new SGColorSelectionButton();
        this.mFontStyleLabel = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mTabbedPane.setFont(new Font("Dialog", 1, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.mTabbedPane, gridBagConstraints);
        this.mOKButton.setText("OK");
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setText("Preview");
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mAxisCommonPanel.setLayout(new GridBagLayout());
        this.mAxisLinePanel.setBorder(BorderFactory.createBevelBorder(0));
        this.mAxisLinePanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mAxisLineSeparator, gridBagConstraints);
        this.mAxisWidthLabel1.setFont(new Font("Dialog", 0, 12));
        this.mAxisWidthLabel1.setText("Axis Line");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.mAxisLinePanel.add((Component)this.mAxisWidthLabel1, gridBagConstraints);
        this.mAxisWidthLabel2.setFont(new Font("Dialog", 0, 12));
        this.mAxisWidthLabel2.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 15, 10, 0);
        this.mAxisLinePanel.add((Component)this.mAxisWidthLabel2, gridBagConstraints);
        this.mScaleWidthLabel1.setFont(new Font("Dialog", 0, 12));
        this.mScaleWidthLabel1.setText("Tick Mark");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        this.mAxisLinePanel.add((Component)this.mScaleWidthLabel1, gridBagConstraints);
        this.mScaleWidthLabel2.setFont(new Font("Dialog", 0, 12));
        this.mScaleWidthLabel2.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 10, 5);
        this.mAxisLinePanel.add((Component)this.mScaleWidthLabel2, gridBagConstraints);
        this.mScaleLengthLabel1.setFont(new Font("Dialog", 0, 12));
        this.mScaleLengthLabel1.setText("Tick Mark");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        this.mAxisLinePanel.add((Component)this.mScaleLengthLabel1, gridBagConstraints);
        this.mScaleLengthLabel2.setFont(new Font("Dialog", 0, 12));
        this.mScaleLengthLabel2.setText("Length");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 10, 5);
        this.mAxisLinePanel.add((Component)this.mScaleLengthLabel2, gridBagConstraints);
        this.mLineColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mAxisLinePanel.add((Component)this.mLineColorLabel, gridBagConstraints);
        this.mAxisLineWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mAxisLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mAxisLinePanel.add((Component)this.mAxisLineWidthSpinner, gridBagConstraints);
        this.mScaleLineWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mScaleLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mAxisLinePanel.add((Component)this.mScaleLineWidthSpinner, gridBagConstraints);
        this.mScaleLineLengthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mScaleLineLengthSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mAxisLinePanel.add((Component)this.mScaleLineLengthSpinner, gridBagConstraints);
        this.mLineColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mAxisLinePanel.add((Component)this.mLineColorButton, gridBagConstraints);
        this.mAxisLineLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mAxisLinePanel.add((Component)this.mAxisLineLeftSpaceLabel, gridBagConstraints);
        this.mAxisLineRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        this.mAxisLinePanel.add((Component)this.mAxisLineRightSpaceLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 50, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontSeparator, gridBagConstraints);
        this.mFontLabel.setFont(new Font("Dialog", 3, 12));
        this.mFontLabel.setText("Font");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontLabel, gridBagConstraints);
        this.mFontFamilyLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontFamilyLabel.setText("Family");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontFamilyLabel, gridBagConstraints);
        this.mFontSizeLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontSizeLabel, gridBagConstraints);
        this.mFontColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontColorLabel, gridBagConstraints);
        this.mFontTypeComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontTypeComboBox, gridBagConstraints);
        this.mFontSizeSpinner.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontSizeSpinner, gridBagConstraints);
        this.mFontNameComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontNameComboBox, gridBagConstraints);
        this.mFontColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontColorButton, gridBagConstraints);
        this.mFrameLabel.setFont(new Font("Dialog", 3, 12));
        this.mFrameLabel.setText("Frame");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFrameLabel, gridBagConstraints);
        this.mFrameVisibleCheckBox.setText("Visible");
        this.mFrameVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFrameVisibleCheckBox, gridBagConstraints);
        this.mFrameLineWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mFrameLineWidthLabel.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFrameLineWidthLabel, gridBagConstraints);
        this.mFrameLineColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mFrameLineColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFrameLineColorLabel, gridBagConstraints);
        this.mFrameLineWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mFrameLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFrameLineWidthSpinner, gridBagConstraints);
        this.mFrameColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFrameColorButton, gridBagConstraints);
        this.mFontStyleLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontStyleLabel.setText("Style");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontStyleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.mAxisCommonPanel.add((Component)this.mAxisLinePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.mAxisCommonPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        int n;
        this.setTitle(TITLE);
        this.mAxisLineWidthSpinner.initProperties(SGAxisDialog.getLineWidthSpinnerNumberModel(), "pt", 1, 2);
        this.mScaleLineWidthSpinner.initProperties(SGAxisDialog.getLineWidthSpinnerNumberModel(), "pt", 1, 2);
        this.mScaleLineLengthSpinner.initProperties(new SpinnerNumberModel(0.1, 0.0, 0.5, 0.05), "cm", 1, 2);
        this.mFontSizeSpinner.initProperties(SGAxisDialog.getFontSizeSpinnerNumberModel(), "pt", 1, 2);
        this.mFrameLineWidthSpinner.initProperties(SGAxisDialog.getLineWidthSpinnerNumberModel(), "pt", 1, 2);
        String[] stringArray = SGUtility.getAvailableFontFamilyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.mFontNameComboBox.addItem(stringArray[i]);
        }
        String[] stringArray2 = new String[]{"Plain", "Italic", "Bold", "Bold Italic"};
        for (n = 0; n < stringArray2.length; ++n) {
            this.mFontTypeComboBox.addItem(stringArray2[n]);
        }
        this.pack();
        this.mFrameVisibleCheckBox.addActionListener(this);
        this.mFontNameComboBox.addActionListener(this);
        this.mFontTypeComboBox.addActionListener(this);
        for (n = 0; n < this.mAxisLocationArray.length; ++n) {
            SGAxisPanel sGAxisPanel = this.getAxisPanel(this.mAxisLocationArray[n]);
            sGAxisPanel.addActionListener(this);
        }
        this.mFontSizeSpinner.setDescription("Font-> Size");
        this.mFrameLineWidthSpinner.setDescription("Frame-> Width");
        this.mAxisLineWidthSpinner.setDescription("Axis Line Width");
        this.mScaleLineWidthSpinner.setDescription("Tick Mark Width");
        this.mScaleLineLengthSpinner.setDescription("Tick Mark Length");
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.mFrameVisibleCheckBox)) {
            this.setFrameLineComponentsEnabled(this.mFrameVisibleCheckBox.isSelected());
        }
    }

    private JPanel getAxisParentPanel(int n) {
        Component[] componentArray = this.mTabbedPane.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JPanel jPanel;
            SGAxisPanel sGAxisPanel;
            int n2;
            if (!(componentArray[i] instanceof JPanel) || (n2 = (sGAxisPanel = (SGAxisPanel)(jPanel = (JPanel)componentArray[i]).getComponent(0)).getConfiguration()) != n) continue;
            return jPanel;
        }
        return null;
    }

    private SGAxisPanel getAxisPanel(int n) {
        JPanel jPanel = this.getAxisParentPanel(n);
        return (SGAxisPanel)jPanel.getComponent(0);
    }

    private boolean setFrameLineComponentsEnabled(boolean bl) {
        this.mFrameLineWidthLabel.setEnabled(bl);
        this.mFrameLineWidthSpinner.setEnabled(bl);
        this.mFrameLineColorLabel.setEnabled(bl);
        this.mFrameColorButton.setEnabled(bl);
        return true;
    }

    public Number getAxisLineWidth() {
        return this.mAxisLineWidthSpinner.getNumber();
    }

    public Number getScaleLineWidth() {
        return this.mScaleLineWidthSpinner.getNumber();
    }

    public Number getScaleLineLength() {
        return this.mScaleLineLengthSpinner.getNumber();
    }

    public Color getLineColor() {
        return this.mLineColorButton.getColor();
    }

    public String getTitleFontName() {
        return this.mFontNameComboBox.getSelectedItem().toString();
    }

    public Number getTitleFontSize() {
        return this.mFontSizeSpinner.getNumber();
    }

    public Integer getTitleFontStyle() {
        String string = (String)this.mFontTypeComboBox.getSelectedItem();
        return SGUtilityText.getFontStyle(string);
    }

    public Color getStringColor() {
        return this.mFontColorButton.getColor();
    }

    public Boolean isFrameLinesVisible() {
        return this.mFrameVisibleCheckBox.getSelected();
    }

    public Number getFrameLineWidth() {
        return this.mFrameLineWidthSpinner.getNumber();
    }

    public Color getFrameLineColor() {
        return this.mFrameColorButton.getColor();
    }

    public boolean setAxisLineWidth(Object object) {
        return this.setValue(this.mAxisLineWidthSpinner, object);
    }

    public boolean setScaleLineWidth(Object object) {
        return this.setValue(this.mScaleLineWidthSpinner, object);
    }

    public boolean setScaleLineLength(Object object) {
        return this.setValue(this.mScaleLineLengthSpinner, object);
    }

    public boolean setLineColor(Color color) {
        this.mLineColorButton.setColor(color);
        return true;
    }

    public boolean setTitleFontName(String string) {
        String string2 = SGUtility.findFontFamilyName(string);
        this.mFontNameComboBox.setSelectedItem(string2);
        return true;
    }

    public boolean setTitleFontSize(Object object) {
        return this.setValue(this.mFontSizeSpinner, object);
    }

    public boolean setStringColor(Color color) {
        this.mFontColorButton.setColor(color);
        return true;
    }

    public boolean setTitleFontStyle(Integer n) {
        String string = null;
        if (n != null) {
            string = SGUtilityText.getFontStyleName(n);
        }
        this.mFontTypeComboBox.setSelectedItem(string);
        return true;
    }

    public void setFrameVisible(Boolean bl) {
        this.mFrameVisibleCheckBox.setSelected(bl);
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        this.setFrameLineComponentsEnabled(bl2);
    }

    public boolean setFrameLineWidth(Object object) {
        return this.setValue(this.mFrameLineWidthSpinner, object);
    }

    public boolean setFrameLineColor(Color color) {
        this.mFrameColorButton.setColor(color);
        return true;
    }

    public List getColorSelectionButtonsList() {
        ArrayList<SGColorSelectionButton> arrayList = new ArrayList<SGColorSelectionButton>();
        arrayList.add(this.mLineColorButton);
        arrayList.add(this.mFontColorButton);
        arrayList.add(this.mFrameColorButton);
        return arrayList;
    }

    public List getTextFieldComponentsList() {
        List list = this.getFormattedTextFieldsListFromSpinners();
        for (int i = 0; i < this.mAxisLocationArray.length; ++i) {
            SGAxisPanel sGAxisPanel = this.getAxisPanel(this.mAxisLocationArray[i]);
            list.addAll(sGAxisPanel.getTextFieldComponentsList());
        }
        return list;
    }

    public List getNumberTextFieldList() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.mAxisLocationArray.length; ++i) {
            SGAxisPanel sGAxisPanel = this.getAxisPanel(this.mAxisLocationArray[i]);
            arrayList.addAll(sGAxisPanel.getNumberTextFieldList());
        }
        return arrayList;
    }

    public List getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mAxisLineWidthSpinner);
        arrayList.add(this.mScaleLineWidthSpinner);
        arrayList.add(this.mScaleLineLengthSpinner);
        arrayList.add(this.mFontSizeSpinner);
        arrayList.add(this.mFrameLineWidthSpinner);
        for (int i = 0; i < this.mAxisLocationArray.length; ++i) {
            SGAxisPanel sGAxisPanel = this.getAxisPanel(this.mAxisLocationArray[i]);
            arrayList.addAll(sGAxisPanel.getSpinnerList());
        }
        return arrayList;
    }

    public boolean setSelectedPanel(SGAxisPanel sGAxisPanel) {
        Component[] componentArray = this.mTabbedPane.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JPanel jPanel = (JPanel)componentArray[i];
            Component component = jPanel.getComponent(0);
            if (!component.equals(sGAxisPanel)) continue;
            this.mTabbedPane.setSelectedComponent(jPanel);
            break;
        }
        return true;
    }

    public boolean setDialogProperty() {
        Object object;
        int n;
        List list = this.mPropertyDialogObserverList;
        SGIAxisDialogObserver sGIAxisDialogObserver = (SGIAxisDialogObserver)list.get(0);
        String string = sGIAxisDialogObserver.getTitleFontName();
        float f = sGIAxisDialogObserver.getTitleFontSize("pt");
        int n2 = sGIAxisDialogObserver.getTitleFontStyle();
        Color color = sGIAxisDialogObserver.getStringColor();
        float f2 = sGIAxisDialogObserver.getFrameLineWidth("pt");
        Color color2 = sGIAxisDialogObserver.getFrameLineColor();
        boolean bl = sGIAxisDialogObserver.isFrameLineVisible();
        float f3 = sGIAxisDialogObserver.getAxisLineWidth("pt");
        float f4 = sGIAxisDialogObserver.getTickMarkWidth("pt");
        float f5 = sGIAxisDialogObserver.getTickMarkLength("cm");
        Color color3 = sGIAxisDialogObserver.getLineColor();
        String string2 = string;
        Float f6 = Float.valueOf(f);
        Integer n3 = n2;
        Color color4 = color;
        Float f7 = Float.valueOf(f2);
        Color color5 = color2;
        Boolean bl2 = bl;
        Float f8 = Float.valueOf(f3);
        Float f9 = Float.valueOf(f4);
        Float f10 = Float.valueOf(f5);
        Color color6 = color3;
        if (list.size() > 1) {
            Object object2;
            for (n = 1; n < list.size(); ++n) {
                object = (SGIAxisDialogObserver)list.get(n);
                object2 = object.getTitleFontName();
                if (string.equals(object2)) continue;
                string2 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                object = (SGIAxisDialogObserver)list.get(n);
                float f11 = object.getTitleFontSize("pt");
                if (f == f11) continue;
                f6 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                object = (SGIAxisDialogObserver)list.get(n);
                int n4 = object.getTitleFontStyle();
                if (n2 == n4) continue;
                n3 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                object = (SGIAxisDialogObserver)list.get(n);
                object2 = object.getStringColor();
                if (color4.equals(object2)) continue;
                color4 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                object = (SGIAxisDialogObserver)list.get(n);
                boolean bl3 = object.isFrameLineVisible();
                if (bl == bl3) continue;
                bl2 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                object = (SGIAxisDialogObserver)list.get(n);
                float f12 = object.getFrameLineWidth("pt");
                if (f2 == f12) continue;
                f7 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                object = (SGIAxisDialogObserver)list.get(n);
                Color color7 = object.getFrameLineColor();
                if (color5.equals(color7)) continue;
                color5 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                object = (SGIAxisDialogObserver)list.get(n);
                float f13 = object.getAxisLineWidth("pt");
                if (f3 == f13) continue;
                f8 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                object = (SGIAxisDialogObserver)list.get(n);
                float f14 = object.getTickMarkWidth("pt");
                if (f4 == f14) continue;
                f9 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                object = (SGIAxisDialogObserver)list.get(n);
                float f15 = object.getTickMarkLength("cm");
                if (f5 == f15) continue;
                f10 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                object = (SGIAxisDialogObserver)list.get(n);
                Color color8 = object.getLineColor();
                if (color6.equals(color8)) continue;
                color6 = null;
                break;
            }
        }
        this.setTitleFontName(string2);
        this.setTitleFontSize(f6);
        this.setTitleFontStyle(n3);
        this.setStringColor(color4);
        this.setFrameVisible(bl2);
        this.setFrameLineWidth(f7);
        this.setFrameLineColor(color5);
        this.setAxisLineWidth(f8);
        this.setScaleLineWidth(f9);
        this.setScaleLineLength(f10);
        this.setLineColor(color6);
        for (n = 0; n < this.mAxisLocationArray.length; ++n) {
            object = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                SGIAxisDialogObserver sGIAxisDialogObserver2 = (SGIAxisDialogObserver)list.get(i);
                SGIAxisPanelObserver sGIAxisPanelObserver = sGIAxisDialogObserver2.getAxisPanelObserverInPlane(this.mAxisLocationArray[n]);
                if (sGIAxisPanelObserver == null) continue;
                ((ArrayList)object).add(sGIAxisPanelObserver);
            }
            if (((ArrayList)object).size() == 0) continue;
            SGAxisPanel sGAxisPanel = this.getAxisPanel(this.mAxisLocationArray[n]);
            sGAxisPanel.setComponentsProperty((ArrayList)object);
        }
        n = -1;
        for (int i = 0; i < list.size(); ++i) {
            SGIAxisDialogObserver sGIAxisDialogObserver3 = (SGIAxisDialogObserver)list.get(i);
            int n5 = sGIAxisDialogObserver3.getAxisLocationForSelectedTab();
            if (n5 == -1) continue;
            n = n5;
            break;
        }
        if (n == -1) {
            n = 0;
        }
        JPanel jPanel = this.getAxisParentPanel(n);
        this.mTabbedPane.setSelectedComponent(jPanel);
        return true;
    }

    public boolean setPropertiesToListeners(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        Color color;
        Number number;
        Number number2;
        Number number3;
        Color color2;
        Number number4;
        Boolean bl;
        Color color3;
        Number number5;
        Integer n;
        SGIAxisDialogObserver sGIAxisDialogObserver = (SGIAxisDialogObserver)sGIPropertyDialogObserver;
        String string = this.getTitleFontName();
        if (string != null) {
            sGIAxisDialogObserver.setTitleFontName(string);
        }
        if ((n = this.getTitleFontStyle()) != null) {
            sGIAxisDialogObserver.setTitleFontStyle(n);
        }
        if ((number5 = this.getTitleFontSize()) != null) {
            sGIAxisDialogObserver.setTitleFontSize(number5.floatValue());
        }
        if ((color3 = this.getStringColor()) != null) {
            sGIAxisDialogObserver.setFontColor(color3);
        }
        if ((bl = this.isFrameLinesVisible()) != null) {
            sGIAxisDialogObserver.setFrameVisible(bl);
        }
        if ((number4 = this.getFrameLineWidth()) != null) {
            sGIAxisDialogObserver.setFrameLineWidth(number4.floatValue(), "pt");
        }
        if ((color2 = this.getFrameLineColor()) != null) {
            sGIAxisDialogObserver.setFrameLineColor(color2);
        }
        if ((number3 = this.getAxisLineWidth()) != null) {
            sGIAxisDialogObserver.setAxisLineWidth(number3.floatValue(), "pt");
        }
        if ((number2 = this.getScaleLineWidth()) != null) {
            sGIAxisDialogObserver.setTickMarkWidth(number2.floatValue(), "pt");
        }
        if ((number = this.getScaleLineLength()) != null) {
            sGIAxisDialogObserver.setTickMarkLength(number.floatValue(), "cm");
        }
        if ((color = this.getLineColor()) != null) {
            sGIAxisDialogObserver.setLineColor(color);
        }
        for (int i = 0; i < this.mAxisLocationArray.length; ++i) {
            SGAxisPanel sGAxisPanel = this.getAxisPanel(this.mAxisLocationArray[i]);
            SGIAxisPanelObserver sGIAxisPanelObserver = sGIAxisDialogObserver.getAxisPanelObserverInPlane(this.mAxisLocationArray[i]);
            if (this.setPropertiesToListeners(sGIAxisPanelObserver, sGAxisPanel)) continue;
            return false;
        }
        return true;
    }

    private boolean setPropertiesToListeners(SGIAxisPanelObserver sGIAxisPanelObserver, SGAxisPanel sGAxisPanel) {
        if (!sGAxisPanel.setPropertiesToListeners(sGIAxisPanelObserver)) {
            String string = sGAxisPanel.getInputErrorMessage();
            if (string != null) {
                this.setInputErrorMessage(string);
            }
            return false;
        }
        return true;
    }

    protected boolean hasValidInputValues() {
        boolean bl = true;
        if (!super.hasValidInputValues()) {
            bl = false;
        }
        for (int i = 0; i < this.mAxisLocationArray.length; ++i) {
            SGAxisPanel sGAxisPanel = this.getAxisPanel(this.mAxisLocationArray[i]);
            ArrayList arrayList = sGAxisPanel.getNumberTextFieldList();
            for (int j = 0; j < arrayList.size(); ++j) {
                SGTextField sGTextField = (SGTextField)arrayList.get(j);
                if (this.hasValidNumber(sGTextField, null, null)) continue;
                bl = false;
            }
            SGTextField sGTextField = sGAxisPanel.getTitleTextField();
            if (sGTextField.hasValidText()) continue;
            this.addInputErrorDescription(sGTextField.getDescription());
            bl = false;
        }
        return bl;
    }

    protected JButton getOKButton() {
        return this.mOKButton;
    }

    protected JButton getCancelButton() {
        return this.mCancelButton;
    }

    protected JButton getPreviewButton() {
        return this.mPreviewButton;
    }

    public void setAxisPanelEnabled(int n, boolean bl) {
        Component[] componentArray = this.mTabbedPane.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JPanel jPanel;
            SGAxisPanel sGAxisPanel;
            int n2;
            if (!(componentArray[i] instanceof JPanel) || (n2 = (sGAxisPanel = (SGAxisPanel)(jPanel = (JPanel)componentArray[i]).getComponent(0)).getConfiguration()) != n) continue;
            this.mTabbedPane.setEnabledAt(i, bl);
            break;
        }
    }
}

