/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGFillPaint;
import jp.riken.brain.ni.samuraigraph.base.SGGradationPaint;
import jp.riken.brain.ni.samuraigraph.base.SGIPaint;
import jp.riken.brain.ni.samuraigraph.base.SGPatternPaint;
import jp.riken.brain.ni.samuraigraph.base.SGSelectablePaint;
import jp.riken.brain.ni.samuraigraph.base.SGTransparentPaint;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import org.w3c.dom.Element;

public class SGPaintUtility {
    public static final String KEY_PAINT_STYLE = "PaintStyle";
    public static final String KEY_TRANSPARENT = "Transparent";
    public static final String KEY_FILL_COLOR = "FillColor";
    public static final String KEY_PATTERN_COLOR = "PatternColor";
    public static final String KEY_PATTERN_TYPE = "PatternType";
    public static final String KEY_GRADATION_COLOR1 = "GradationColor1";
    public static final String KEY_GRADATION_COLOR2 = "GradationColor2";
    public static final String KEY_GRADATION_DIRECTION = "GradationDirection";
    public static final String KEY_GRADATION_ORDER = "GradationOrder";
    public static final String TRANSPARENCY_UNIT = "%";

    public static boolean writeProperty(Element element, SGIPaint sGIPaint) {
        element.setAttribute(KEY_TRANSPARENT, Integer.toString(((SGTransparentPaint)sGIPaint).getTransparencyPercent()) + TRANSPARENCY_UNIT);
        if (sGIPaint instanceof SGFillPaint) {
            return SGPaintUtility.writePropertyFillPaint(element, (SGFillPaint)sGIPaint);
        }
        if (sGIPaint instanceof SGPatternPaint) {
            return SGPaintUtility.writePropertyPatternPaint(element, (SGPatternPaint)sGIPaint);
        }
        if (sGIPaint instanceof SGGradationPaint) {
            return SGPaintUtility.writePropertyGradationPaint(element, (SGGradationPaint)sGIPaint);
        }
        if (sGIPaint instanceof SGSelectablePaint) {
            return SGPaintUtility.writePropertySelectablePaint(element, (SGSelectablePaint)sGIPaint);
        }
        return false;
    }

    public static boolean writePropertyFillPaint(Element element, SGFillPaint sGFillPaint) {
        element.setAttribute(KEY_FILL_COLOR, SGUtilityText.getColorString((Color)sGFillPaint.getPaint(null)));
        return true;
    }

    public static boolean writePropertyPatternPaint(Element element, SGPatternPaint sGPatternPaint) {
        element.setAttribute(KEY_PATTERN_COLOR, SGUtilityText.getColorString(sGPatternPaint.getColor()));
        element.setAttribute(KEY_PATTERN_TYPE, SGPatternPaint.getTypeName(sGPatternPaint.getTypeIndex()));
        return true;
    }

    public static boolean writePropertyGradationPaint(Element element, SGGradationPaint sGGradationPaint) {
        Color[] colorArray = sGGradationPaint.getColors();
        if (colorArray.length != 2) {
            return false;
        }
        element.setAttribute(KEY_GRADATION_COLOR1, SGUtilityText.getColorString(colorArray[0]));
        element.setAttribute(KEY_GRADATION_COLOR2, SGUtilityText.getColorString(colorArray[1]));
        element.setAttribute(KEY_GRADATION_DIRECTION, SGGradationPaint.getDirectionName(sGGradationPaint.getDirectionIndex()));
        element.setAttribute(KEY_GRADATION_ORDER, SGGradationPaint.getOrderName(sGGradationPaint.getOrderIndex()));
        return true;
    }

    public static boolean writePropertySelectablePaint(Element element, SGSelectablePaint sGSelectablePaint) {
        element.setAttribute(KEY_PAINT_STYLE, SGSelectablePaint.getStyleName(sGSelectablePaint.getSelectedStyle()));
        element.setAttribute(KEY_FILL_COLOR, SGUtilityText.getColorString(sGSelectablePaint.getFillColor()));
        element.setAttribute(KEY_PATTERN_COLOR, SGUtilityText.getColorString(sGSelectablePaint.getPatternColor()));
        element.setAttribute(KEY_PATTERN_TYPE, SGPatternPaint.getTypeName(sGSelectablePaint.getPatternIndex()));
        return SGPaintUtility.writePropertyGradationPaint(element, sGSelectablePaint.getGradationPaint());
    }

    public static SGIPaint readProperty(Element element) {
        Integer n = null;
        Boolean bl = null;
        String string = null;
        Color color = null;
        Color color2 = null;
        String string2 = null;
        Color color3 = null;
        Color color4 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        string = element.getAttribute(KEY_TRANSPARENT);
        if (string.length() != 0) {
            n = SGUtilityText.getInteger(string, TRANSPARENCY_UNIT);
            bl = SGUtilityText.getBoolean(string);
        }
        if ((string = element.getAttribute(KEY_FILL_COLOR)).length() != 0) {
            color = SGUtilityText.parseColor(string);
        }
        if ((string = element.getAttribute(KEY_PATTERN_COLOR)).length() != 0) {
            color2 = SGUtilityText.parseColor(string);
        }
        if ((string = element.getAttribute(KEY_PATTERN_TYPE)).length() != 0) {
            string2 = string.trim();
        }
        if ((string = element.getAttribute(KEY_GRADATION_COLOR1)).length() != 0) {
            color3 = SGUtilityText.parseColor(string);
        }
        if ((string = element.getAttribute(KEY_GRADATION_COLOR2)).length() != 0) {
            color4 = SGUtilityText.parseColor(string);
        }
        if ((string = element.getAttribute(KEY_GRADATION_DIRECTION)).length() != 0) {
            string3 = string.trim();
        }
        if ((string = element.getAttribute(KEY_GRADATION_ORDER)).length() != 0) {
            string4 = string.trim();
        }
        if ((string = element.getAttribute(KEY_PAINT_STYLE)).length() != 0) {
            string5 = string.trim();
        }
        if (null != string5) {
            Integer n2;
            Object object;
            SGSelectablePaint sGSelectablePaint = new SGSelectablePaint();
            if (null != bl) {
                if (!bl.booleanValue()) {
                    sGSelectablePaint.setTransparency(0);
                } else {
                    sGSelectablePaint.setTransparency(100);
                }
            } else if (null != n) {
                sGSelectablePaint.setTransparency(n);
            }
            if (null != color) {
                sGSelectablePaint.setFillColor(color);
            }
            if (null != string2) {
                if (null != color2) {
                    sGSelectablePaint.setPatternColor(color2);
                }
                if (null != (object = SGPatternPaint.getTypeFromName(string2))) {
                    sGSelectablePaint.setPatternIndex((Integer)object);
                }
            }
            object = new SGGradationPaint();
            if (null != color3 && null != color4) {
                ((SGGradationPaint)object).setColors(new Color[]{color3, color4});
            }
            if (null != string3 && null != (n2 = SGGradationPaint.getDirectionIndex(string3))) {
                ((SGGradationPaint)object).setDirection(n2);
            }
            if (null != string4 && null != (n2 = SGGradationPaint.getOrderIndex(string4))) {
                ((SGGradationPaint)object).setOrder(n2);
            }
            sGSelectablePaint.setGradationPaint((SGGradationPaint)object);
            n2 = SGSelectablePaint.getStyleIndex(string5);
            if (null != n2) {
                sGSelectablePaint.setSelectedPaintStyle(n2);
                return sGSelectablePaint;
            }
        } else if (null != color) {
            SGFillPaint sGFillPaint = new SGFillPaint();
            if (null != n) {
                sGFillPaint.setTransparency(n);
            }
            if (!sGFillPaint.setColor(color)) {
                return sGFillPaint;
            }
        } else if (null != string2) {
            Integer n3;
            SGPatternPaint sGPatternPaint = new SGPatternPaint();
            if (null != n) {
                sGPatternPaint.setTransparency(n);
            }
            if (null != color2) {
                sGPatternPaint.setColor(color2);
            }
            if (null != (n3 = SGPatternPaint.getTypeFromName(string2))) {
                sGPatternPaint.setTypeIndex(n3);
                return sGPatternPaint;
            }
        } else if (null != color3 && null != color4 && null != string3 && null != string4) {
            Integer n4;
            SGGradationPaint sGGradationPaint = new SGGradationPaint();
            if (null != n) {
                sGGradationPaint.setTransparency(n);
            }
            sGGradationPaint.setColors(new Color[]{color3, color4});
            Integer n5 = SGGradationPaint.getDirectionIndex(string3);
            if (null != n5) {
                sGGradationPaint.setDirection(n5);
            }
            if (null != (n4 = SGGradationPaint.getOrderIndex(string4))) {
                sGGradationPaint.setOrder(n4);
            }
            return sGGradationPaint;
        }
        return null;
    }
}

