/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIChildObject;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIMovable;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGIVisible;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyMap;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyResults;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUndoManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroupSet;
import jp.riken.brain.ni.samuraigraph.figure.SGIFigureElementConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInFigureElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SGFigureElement
implements SGIFigureElement,
SGIFigureElementConstants {
    private int mMode = 1;
    protected List<SGIChildObject> mChildList = new ArrayList<SGIChildObject>();
    private JComponent mComponent = null;
    protected float mGraphRectX;
    protected float mGraphRectY;
    protected float mGraphRectWidth;
    protected float mGraphRectHeight;
    protected float mMagnification = 1.0f;
    protected Rectangle2D mViewBounds = null;
    protected List<SGData> mDataList = new ArrayList<SGData>();
    protected List mActionListenerList = new ArrayList();
    private Cursor mCursor = null;
    protected Frame mDialogOwner = null;
    protected Point mPressedPoint = null;
    protected boolean mDraggableFlag = false;
    private boolean mDisposed = false;
    protected SGUndoManager mUndoManager = new SGUndoManager(this);
    protected boolean mSymbolsVisibleFlagAroundFocusedObjects = true;
    protected boolean mSymbolsVisibleFlagAroundAllObjects = false;
    public static final int OFFSET_DUPLICATED_OBJECT_X = 10;
    public static final int OFFSET_DUPLICATED_OBJECT_Y = 10;
    protected static final int DISPLACEMENT_SMALL = 1;
    protected static final int DISPLACEMENT_LARGE = 10;

    @Override
    public void setMode(int n) {
        this.mMode = n;
    }

    public int getMode() {
        return this.mMode;
    }

    @Override
    public JComponent getComponent() {
        return this.mComponent;
    }

    @Override
    public void setComponent(JComponent jComponent) {
        this.mComponent = jComponent;
    }

    public void repaint() {
        if (this.mComponent != null) {
            this.mComponent.repaint();
        }
    }

    @Override
    public void dispose() {
        this.mDisposed = true;
        this.mComponent = null;
        this.mActionListenerList.clear();
        this.mActionListenerList = null;
        this.mDataList.clear();
        this.mDataList = null;
        List<SGIChildObject> list = this.mChildList;
        for (int i = 0; i < list.size(); ++i) {
            SGIChildObject sGIChildObject = list.get(i);
            if (!(sGIChildObject instanceof SGIDisposable)) continue;
            SGIDisposable sGIDisposable = (SGIDisposable)((Object)sGIChildObject);
            sGIDisposable.dispose();
        }
        this.mChildList.clear();
        this.mChildList = null;
        this.mUndoManager.dispose();
        this.mUndoManager = null;
        this.mDialogOwner = null;
        this.mViewBounds = null;
        this.mPressedPoint = null;
        this.mCursor = null;
    }

    @Override
    public boolean isDisposed() {
        return this.mDisposed;
    }

    protected int assignChildId() {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List<SGIChildObject> list = this.getVisibleChildList();
        for (n = 0; n < list.size(); ++n) {
            SGIChildObject sGIChildObject = list.get(n);
            arrayList.add(sGIChildObject.getID());
        }
        n = SGUtility.assignIdNumber(arrayList);
        return n;
    }

    @Override
    public boolean addData(SGData sGData, String string) {
        if (sGData == null) {
            throw new Error("data == null");
        }
        this.mDataList.add(sGData);
        return true;
    }

    public boolean addData(SGData sGData, String string, Map<String, Object> map) {
        return this.addData(sGData, string);
    }

    @Override
    public boolean addData(SGData sGData, String string, int n, Map<String, Object> map) {
        return this.addData(sGData, string, map);
    }

    @Override
    public boolean addData(SGData[] sGDataArray, String[] stringArray, Map<String, Object> map) {
        if (sGDataArray.length != stringArray.length) {
            return false;
        }
        for (int i = 0; i < sGDataArray.length; ++i) {
            if (this.addData(sGDataArray[i], stringArray[i], map)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addData(SGData[] sGDataArray, String[] stringArray, int[] nArray, Map<String, Object> map) {
        if (sGDataArray.length != stringArray.length) {
            return false;
        }
        if (sGDataArray.length != nArray.length) {
            return false;
        }
        for (int i = 0; i < sGDataArray.length; ++i) {
            if (this.addData(sGDataArray[i], stringArray[i], nArray[i], map)) continue;
            return false;
        }
        return true;
    }

    protected boolean addToList(SGIChildObject sGIChildObject) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < this.mChildList.size(); ++n) {
            SGIChildObject sGIChildObject2 = this.mChildList.get(n);
            arrayList.add(sGIChildObject2.getID());
        }
        n = SGUtility.assignIdNumber(arrayList);
        sGIChildObject.setID(n);
        this.mChildList.add(sGIChildObject);
        return true;
    }

    protected boolean addToList(int n, SGIChildObject sGIChildObject) {
        if (n <= 0) {
            throw new IllegalArgumentException("id <= 0");
        }
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = 0; i < list.size(); ++i) {
            SGIChildObject sGIChildObject2 = list.get(i);
            int n2 = sGIChildObject2.getID();
            if (n2 != n) continue;
            return false;
        }
        this.mChildList.add(sGIChildObject);
        sGIChildObject.setID(n);
        return true;
    }

    protected SGIChildObject getVisibleChild(int n) {
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = 0; i < list.size(); ++i) {
            SGIChildObject sGIChildObject = list.get(i);
            if (sGIChildObject.getID() != n) continue;
            return sGIChildObject;
        }
        return null;
    }

    protected boolean removeChild(Object object) {
        if (object instanceof SGIDisposable) {
            SGIDisposable sGIDisposable = (SGIDisposable)object;
            sGIDisposable.dispose();
        }
        return this.mChildList.remove(object);
    }

    @Override
    public boolean removeData(SGData sGData) {
        List<SGData> list = this.mDataList;
        for (int i = list.size() - 1; i >= 0; --i) {
            SGData sGData2 = list.get(i);
            if (!sGData2.equals(sGData)) continue;
            list.remove(i);
        }
        return true;
    }

    @Override
    public List<SGData> getUselessDataList() {
        ArrayList<SGData> arrayList = new ArrayList<SGData>();
        return arrayList;
    }

    @Override
    public List<SGData> getDataList() {
        return new ArrayList<SGData>(this.mDataList);
    }

    @Override
    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        if (sGTuple2f == null || sGTuple2f2 == null) {
            return false;
        }
        sGTuple2f.clear();
        sGTuple2f2.clear();
        return true;
    }

    @Override
    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        this.setGraphRectLocation(f, f2);
        this.setGraphRectSize(f3, f4);
        return true;
    }

    @Override
    public boolean setGraphRect(Rectangle2D rectangle2D) {
        return this.setGraphRect((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
    }

    @Override
    public boolean setGraphRectLocation(float f, float f2) {
        this.mGraphRectX = f;
        this.mGraphRectY = f2;
        return true;
    }

    @Override
    public boolean setGraphRectSize(float f, float f2) {
        if ((double)f < 0.0 || (double)f2 < 0.0) {
            throw new IllegalArgumentException("width<0.0 || height<0.0");
        }
        this.mGraphRectWidth = f;
        this.mGraphRectHeight = f2;
        return true;
    }

    @Override
    public Rectangle2D getGraphRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.mGraphRectX, this.mGraphRectY, this.mGraphRectWidth, this.mGraphRectHeight);
        return float_;
    }

    public boolean isInsideGraphArea(SGTuple2f sGTuple2f) {
        float f = sGTuple2f.x;
        float f2 = sGTuple2f.y;
        float f3 = this.mGraphRectX;
        float f4 = this.mGraphRectY;
        float f5 = this.mGraphRectWidth;
        float f6 = this.mGraphRectHeight;
        if (f < f3 || f > f3 + f5) {
            return false;
        }
        return !(f2 < f4) && !(f2 > f4 + f6);
    }

    public boolean isInsideGraphArea(Point2D point2D) {
        return this.isInsideGraphArea((int)point2D.getX(), (int)point2D.getY());
    }

    public boolean isInsideGraphArea(int n, int n2) {
        SGTuple2f sGTuple2f = new SGTuple2f(n, n2);
        return this.isInsideGraphArea(sGTuple2f);
    }

    @Override
    public boolean setDialogOwner(Frame frame) {
        this.mDialogOwner = frame;
        return true;
    }

    @Override
    public float getMagnification() {
        return this.mMagnification;
    }

    @Override
    public boolean setMagnification(float f) {
        if ((double)f <= 0.0) {
            throw new IllegalArgumentException("mag <= 0.0");
        }
        this.mMagnification = f;
        for (int i = 0; i < this.mChildList.size(); ++i) {
            SGIChildObject sGIChildObject = this.mChildList.get(i);
            if (sGIChildObject.setMagnification(f)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Cursor getFigureElementCursor() {
        return this.mCursor;
    }

    protected void setMouseCursor(int n) {
        this.mCursor = Cursor.getPredefinedCursor(n);
        this.notifyChangeCursor();
    }

    protected void setMouseCursor(Cursor cursor) {
        this.mCursor = cursor;
        this.notifyChangeCursor();
    }

    public void notifyChangeCursor() {
        this.notifyToListener("Notify the change of cursor");
    }

    @Override
    public boolean setViewBounds(Rectangle2D rectangle2D) {
        this.mViewBounds = rectangle2D;
        return true;
    }

    public Rectangle2D getViewBounds() {
        return this.mViewBounds;
    }

    @Override
    public boolean createDataObject(Element element, SGData sGData, boolean bl) {
        if (element == null || sGData == null) {
            throw new IllegalArgumentException();
        }
        this.mDataList.add(sGData);
        return true;
    }

    protected boolean updateFocusedObjectsList(SGISelectable sGISelectable, int n) {
        ArrayList arrayList = this.getFocusedObjectsList();
        if ((n & 2) == 0 && (n & 1) == 0) {
            if (!arrayList.contains(sGISelectable)) {
                this.notifyToListener("Clear focused objects");
                sGISelectable.setSelected(true);
            }
        } else {
            sGISelectable.setSelected(!sGISelectable.isSelected());
        }
        return true;
    }

    public boolean updateFocusedObjectsList(SGISelectable sGISelectable, MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        return this.updateFocusedObjectsList(sGISelectable, n);
    }

    @Override
    public void translateFocusedObjects(int n, int n2) {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof SGIMovable)) continue;
            SGIMovable sGIMovable = (SGIMovable)e;
            sGIMovable.translate(n, n2);
        }
    }

    @Override
    public boolean clearFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGISelectable sGISelectable = (SGISelectable)arrayList.get(i);
            sGISelectable.setSelected(false);
        }
        return true;
    }

    @Override
    public boolean clearFocusedObjects(SGIFigureElement sGIFigureElement) {
        if (!this.getClass().equals(sGIFigureElement.getClass())) {
            return this.clearFocusedObjects();
        }
        return true;
    }

    protected boolean hideSelectedData() {
        ArrayList arrayList = this.getFocusedObjectsList();
        if (arrayList.size() == 0) {
            return true;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof SGElementGroupSet)) continue;
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)arrayList.get(i);
            sGElementGroupSet.setVisible(false);
        }
        this.clearFocusedObjects();
        this.setChanged(true);
        return true;
    }

    @Override
    public boolean hideData(int[] nArray) {
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            SGIChildObject sGIChildObject = this.getVisibleChild(nArray[i]);
            if (null == sGIChildObject || !(sGIChildObject instanceof SGElementGroupSetInFigureElement)) continue;
            SGElementGroupSetInFigureElement sGElementGroupSetInFigureElement = (SGElementGroupSetInFigureElement)sGIChildObject;
            sGElementGroupSetInFigureElement.setVisible(false);
            bl = true;
        }
        if (bl) {
            this.setChanged(true);
        }
        return true;
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        for (int i = 0; i < this.mActionListenerList.size(); ++i) {
            ActionListener actionListener2 = (ActionListener)this.mActionListenerList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            return;
        }
        this.mActionListenerList.add(actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        for (int i = this.mActionListenerList.size() - 1; i >= 0; --i) {
            ActionListener actionListener2 = (ActionListener)this.mActionListenerList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            this.mActionListenerList.remove(actionListener);
        }
    }

    public void notifyChange() {
        this.notifyToListener("Notify the change");
    }

    public void notifyChangeOnUndo() {
        this.notifyToListener("Notify the change on undo");
    }

    public void notifyChangeOnCommit() {
        this.notifyToListener("Notify the change on commit");
    }

    public boolean setPropertiesOfSelectedObjects() {
        this.notifyToListener("Set properties of selected objects");
        return true;
    }

    public void notifyToListener(String string) {
        for (int i = 0; i < this.mActionListenerList.size(); ++i) {
            ActionListener actionListener = (ActionListener)this.mActionListenerList.get(i);
            actionListener.actionPerformed(this.getActionEvent(string));
        }
    }

    private ActionEvent getActionEvent(String string) {
        return new ActionEvent(this, 0, string);
    }

    public void notifyToListener(String string, Object object) {
        for (int i = 0; i < this.mActionListenerList.size(); ++i) {
            ActionListener actionListener = (ActionListener)this.mActionListenerList.get(i);
            actionListener.actionPerformed(new ActionEvent(object, 0, string));
        }
    }

    @Override
    public float getGraphRectX() {
        return this.mGraphRectX;
    }

    @Override
    public float getGraphRectY() {
        return this.mGraphRectY;
    }

    @Override
    public float getGraphRectWidth() {
        return this.mGraphRectWidth;
    }

    @Override
    public float getGraphRectHeight() {
        return this.mGraphRectHeight;
    }

    public float calcLocation(double d, SGAxis sGAxis, boolean bl) {
        SGTuple2d sGTuple2d = sGAxis.getRange();
        double d2 = sGTuple2d.x;
        double d3 = sGTuple2d.y;
        int n = sGAxis.getScaleType();
        boolean bl2 = sGAxis.isInvertCoordinates();
        float f = 0.0f;
        if (n == 0) {
            f = bl2 ? (float)((d3 - d) / (d3 - d2)) : (float)((d - d2) / (d3 - d2));
        } else if (n == 1) {
            if (d <= 0.0) {
                return Float.NaN;
            }
            double d4 = Math.log(d2);
            double d5 = Math.log(d3);
            double d6 = Math.log(d);
            f = bl2 ? (float)((d5 - d6) / (d5 - d4)) : (float)((d6 - d4) / (d5 - d4));
        }
        float f2 = 0.0f;
        f2 = bl ? this.mGraphRectX + f * this.mGraphRectWidth : this.mGraphRectY + (1.0f - f) * this.mGraphRectHeight;
        return f2;
    }

    public double calcValue(float f, SGAxis sGAxis, boolean bl) {
        SGTuple2d sGTuple2d = sGAxis.getRange();
        double d = sGTuple2d.x;
        double d2 = sGTuple2d.y;
        if (d >= d2) {
            throw new IllegalArgumentException("min>=max");
        }
        int n = sGAxis.getScaleType();
        boolean bl2 = sGAxis.isInvertCoordinates();
        float f2 = bl ? (bl2 ? 1.0f - (f - this.mGraphRectX) / this.mGraphRectWidth : (f - this.mGraphRectX) / this.mGraphRectWidth) : (bl2 ? (f - this.mGraphRectY) / this.mGraphRectHeight : 1.0f - (f - this.mGraphRectY) / this.mGraphRectHeight);
        double d3 = 0.0;
        if (n == 0) {
            d3 = d + (double)f2 * (d2 - d);
        } else if (n == 1) {
            if (d >= 0.0 && d2 >= 0.0) {
                double d4 = Math.log(d);
                double d5 = Math.log(d2);
                d3 = Math.exp(d4 + (double)f2 * (d5 - d4));
            } else {
                d3 = Double.NaN;
            }
        }
        return d3;
    }

    protected boolean showPopupMenu(JPopupMenu jPopupMenu, int n, int n2) {
        jPopupMenu.show(this.getComponent(), n, n2);
        return true;
    }

    public abstract SGProperties getProperties();

    @Override
    public boolean initCompatibleProperty() {
        return true;
    }

    public abstract boolean setProperties(SGProperties var1);

    @Override
    public SGProperties getMemento() {
        return this.getProperties();
    }

    @Override
    public boolean setMemento(SGProperties sGProperties) {
        return this.setProperties(sGProperties);
    }

    @Override
    public boolean isUndoable() {
        return this.mUndoManager.isUndoable();
    }

    @Override
    public boolean isRedoable() {
        return this.mUndoManager.isRedoable();
    }

    @Override
    public boolean initPropertiesHistory() {
        return this.mUndoManager.initPropertiesHistory();
    }

    protected boolean updateHistory(ArrayList arrayList) {
        return this.mUndoManager.updateHistory(arrayList);
    }

    @Override
    public boolean undo() {
        return this.mUndoManager.undo();
    }

    @Override
    public boolean redo() {
        return this.mUndoManager.redo();
    }

    @Override
    public boolean setMementoBackward() {
        return this.mUndoManager.setMementoBackward();
    }

    @Override
    public boolean setMementoForward() {
        return this.mUndoManager.setMementoForward();
    }

    protected List getMementoList() {
        return this.mUndoManager.getMementoList();
    }

    @Override
    public void notifyToRoot() {
        this.notifyToListener("Notify the change to root");
    }

    @Override
    public void setChanged(boolean bl) {
        this.mUndoManager.setChanged(bl);
    }

    @Override
    public void clearChanged() {
        this.setChanged(false);
        List<SGIUndoable> list = this.getUndoableChildList();
        for (int i = 0; i < list.size(); ++i) {
            SGIUndoable sGIUndoable = list.get(i);
            sGIUndoable.clearChanged();
        }
    }

    protected boolean setVisibleList(List list, List list2) {
        return SGUtility.setVisibleList(list, list2);
    }

    protected boolean hideObject(SGDrawingElement sGDrawingElement) {
        sGDrawingElement.setVisible(false);
        this.notifyChange();
        this.setChanged(true);
        this.notifyToRoot();
        return true;
    }

    @Override
    public boolean hideSelectedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGISelectable sGISelectable = (SGISelectable)arrayList.get(i);
            if (this.hideSelectedObject(sGISelectable)) continue;
            return false;
        }
        if (arrayList.size() != 0) {
            this.setChanged(true);
        }
        return true;
    }

    public abstract String getTagName();

    public abstract boolean writeProperty(Element var1);

    protected Element createThisElement(Document document) {
        Element element = document.createElement(this.getTagName());
        if (!this.writeProperty(element)) {
            return null;
        }
        return element;
    }

    public boolean isSymbolsVisibleAroundFocusedObjects() {
        return this.mSymbolsVisibleFlagAroundFocusedObjects;
    }

    @Override
    public void setSymbolsVisibleAroundFocusedObjects(boolean bl) {
        this.mSymbolsVisibleFlagAroundFocusedObjects = bl;
    }

    public boolean isSymbolsVisibleAroundAllObjects() {
        return this.mSymbolsVisibleFlagAroundAllObjects;
    }

    @Override
    public void setSymbolsAroundAllObjectsVisible(boolean bl) {
        this.mSymbolsVisibleFlagAroundAllObjects = bl;
    }

    protected double getNumberInRangeOrder(double d, SGAxis sGAxis, int n) {
        return SGUtilityNumber.getNumberInRangeOrder(d, sGAxis, 4, n);
    }

    protected double getNumberInRangeOrder(double d, SGAxis sGAxis) {
        return this.getNumberInRangeOrder(d, sGAxis, 4);
    }

    protected List<SGICopiable> getCopyList(List<SGICopiable> list) {
        ArrayList<SGICopiable> arrayList = new ArrayList<SGICopiable>();
        for (int i = 0; i < list.size(); ++i) {
            SGICopiable sGICopiable = list.get(i);
            arrayList.add((SGICopiable)sGICopiable.copy());
        }
        return arrayList;
    }

    @Override
    public ArrayList getFocusedObjectsList() {
        ArrayList<SGISelectable> arrayList = new ArrayList<SGISelectable>();
        this.getFocusedObjectsList(arrayList);
        return arrayList;
    }

    protected List<SGICopiable> getCopiableFocusedObjectsList() {
        ArrayList<SGICopiable> arrayList = new ArrayList<SGICopiable>();
        ArrayList arrayList2 = this.getFocusedObjectsList();
        for (int i = arrayList2.size() - 1; i >= 0; --i) {
            Object e = arrayList2.get(i);
            if (!(e instanceof SGICopiable)) continue;
            SGICopiable sGICopiable = (SGICopiable)e;
            arrayList.add(sGICopiable);
        }
        return arrayList;
    }

    @Override
    public boolean duplicateFocusedObjects() {
        return true;
    }

    protected List<SGICopiable> duplicateObjects() {
        List<SGICopiable> list = this.getCopiableFocusedObjectsList();
        List<SGICopiable> list2 = this.getCopyList(list);
        this.clearFocusedObjects();
        return list2;
    }

    @Override
    public List<SGICopiable> getCopiedObjectsList() {
        List<SGICopiable> list = this.getCopiableFocusedObjectsList();
        return this.getCopyList(list);
    }

    @Override
    public boolean paste(List<SGICopiable> list) {
        return true;
    }

    @Override
    public List<SGICopiable> cutFocusedObjects() {
        List<SGICopiable> list = this.getCopiedObjectsList();
        this.hideSelectedObjects();
        return list;
    }

    @Override
    public SGProperties getDataProperties(SGData sGData) {
        return null;
    }

    @Override
    public boolean addData(SGData sGData, String string, SGProperties sGProperties) {
        return this.addData(sGData, string);
    }

    protected double calcStepValue(SGAxis sGAxis) {
        SGTuple2d sGTuple2d = sGAxis.getRange();
        double d = sGTuple2d.x;
        double d2 = sGTuple2d.y;
        double d3 = d2 - d;
        int n = SGUtilityNumber.getOrder(d3);
        double d4 = SGUtilityNumber.getPowersOfTen(n);
        double d5 = d3 - 0.1 * d4;
        int n2 = SGUtilityNumber.getOrder(d5);
        double d6 = SGUtilityNumber.getPowersOfTen(n2);
        double d7 = d5 / d6;
        double d8 = 0.0;
        if (d7 <= 1.1) {
            d8 = 0.2 * d6;
        } else if (1.1 < d7 && d7 <= 2.0) {
            d8 = 0.5 * d6;
        } else if (2.0 < d7 && d7 <= 6.0) {
            d8 = 1.0 * d6;
        } else if (6.0 < d7) {
            d8 = 2.0 * d6;
        }
        d8 = this.getNumberInRangeOrder(d8, sGAxis);
        return d8;
    }

    @Override
    public ArrayList getPropertyDialogObserverList() {
        return new ArrayList();
    }

    @Override
    public String getInstanceDescription() {
        return this.getClassDescription();
    }

    protected float getXFromGraphRectValue(float f) {
        float f2 = this.getMagnification() * f + this.mGraphRectX;
        return f2;
    }

    protected float getYFromGraphRectValue(float f) {
        float f2 = this.getMagnification() * f + this.mGraphRectY;
        return f2;
    }

    protected float getGraphRectValueX(float f) {
        float f2 = (f - this.mGraphRectX) / this.getMagnification();
        return f2;
    }

    protected float getGraphRectValueY(float f) {
        float f2 = (f - this.mGraphRectY) / this.getMagnification();
        return f2;
    }

    protected abstract void paintGraphics(Graphics var1, boolean var2);

    @Override
    public void paint(Graphics graphics, boolean bl) {
        this.paintGraphics(graphics, bl);
    }

    @Override
    public List<SGIChildObject> getVisibleChildList() {
        ArrayList<SGIChildObject> arrayList = new ArrayList<SGIChildObject>();
        ArrayList<SGIChildObject> arrayList2 = new ArrayList<SGIChildObject>(this.mChildList);
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGIChildObject sGIChildObject = (SGIChildObject)arrayList2.get(i);
            if (!sGIChildObject.isVisible()) continue;
            arrayList.add(sGIChildObject);
        }
        return arrayList;
    }

    protected List<SGIUndoable> getUndoableChildList() {
        ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = 0; i < list.size(); ++i) {
            SGIChildObject sGIChildObject = list.get(i);
            if (!(sGIChildObject instanceof SGIUndoable)) continue;
            SGIUndoable sGIUndoable = (SGIUndoable)((Object)sGIChildObject);
            arrayList.add(sGIUndoable);
        }
        return arrayList;
    }

    protected boolean setVisibleChildList(List<SGIChildObject> list) {
        return this.setVisibleList(this.mChildList, list);
    }

    public boolean getFocusedObjectsList(List<SGISelectable> list) {
        List<SGIChildObject> list2 = this.getVisibleChildList();
        for (int i = 0; i < list2.size(); ++i) {
            SGISelectable sGISelectable;
            SGIChildObject sGIChildObject = list2.get(i);
            if (!(sGIChildObject instanceof SGISelectable) || !(sGISelectable = (SGISelectable)((Object)sGIChildObject)).isSelected()) continue;
            list.add(sGISelectable);
        }
        return true;
    }

    @Override
    public boolean isFocusedObjectsChanged() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable;
            SGISelectable sGISelectable = (SGISelectable)arrayList.get(i);
            if (!(sGISelectable instanceof SGIUndoable) || !(sGIUndoable = (SGIUndoable)((Object)sGISelectable)).isChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean hideSelectedObject(SGISelectable sGISelectable) {
        SGIVisible sGIVisible = (SGIVisible)((Object)sGISelectable);
        sGIVisible.setVisible(false);
        return true;
    }

    @Override
    public boolean moveFocusedObjects(boolean bl) {
        return this.moveFocusedObjects(bl, this.mChildList);
    }

    @Override
    public boolean moveFocusedObjects(int n) {
        return this.moveFocusedObjects(n, this.mChildList);
    }

    @Override
    public boolean moveChildToEnd(int n, boolean bl) {
        boolean bl2;
        SGIChildObject sGIChildObject = this.getVisibleChild(n);
        if (sGIChildObject == null) {
            return false;
        }
        ArrayList<SGIChildObject> arrayList = new ArrayList<SGIChildObject>(this.mChildList);
        if (bl) {
            SGUtility.moveObjectToTail(sGIChildObject, this.mChildList);
        } else {
            SGUtility.moveObjectToHead(sGIChildObject, this.mChildList);
        }
        boolean bl3 = bl2 = !((Object)this.mChildList).equals(arrayList);
        if (bl2) {
            this.setChanged(true);
            this.notifyChange();
            this.notifyToRoot();
            this.repaint();
        }
        return true;
    }

    @Override
    public boolean moveChild(int n, boolean bl) {
        boolean bl2;
        SGIChildObject sGIChildObject = this.getVisibleChild(n);
        if (sGIChildObject == null) {
            return false;
        }
        ArrayList<SGIChildObject> arrayList = new ArrayList<SGIChildObject>(this.mChildList);
        if (bl) {
            SGUtility.moveObjectToNext(sGIChildObject, this.mChildList);
        } else {
            SGUtility.moveObjectToPrevious(sGIChildObject, this.mChildList);
        }
        boolean bl3 = bl2 = !((Object)this.mChildList).equals(arrayList);
        if (bl2) {
            this.setChanged(true);
            this.notifyChange();
            this.notifyToRoot();
            this.repaint();
        }
        return true;
    }

    protected boolean moveFocusedObjects(boolean bl, List list) {
        ArrayList arrayList = this.getFocusedObjectsList();
        if (arrayList.size() == 0) {
            return true;
        }
        ArrayList arrayList2 = new ArrayList(list);
        if (bl) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Object e = arrayList.get(i);
                SGUtility.moveObjectToTail(e, list);
            }
        } else {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Object e = arrayList.get(i);
                SGUtility.moveObjectToHead(e, list);
            }
        }
        if (!((Object)list).equals(arrayList2)) {
            this.notifyChange();
            this.setChanged(true);
        }
        return true;
    }

    protected boolean moveFocusedObjects(int n, List list) {
        ArrayList arrayList = this.getFocusedObjectsList();
        if (arrayList.size() == 0) {
            return true;
        }
        ArrayList arrayList2 = new ArrayList(list);
        if (!SGUtility.moveObject(arrayList, list, n)) {
            return false;
        }
        if (!((Object)list).equals(arrayList2)) {
            this.notifyChange();
            this.setChanged(true);
        }
        return true;
    }

    @Override
    public ArrayList getChildNodes() {
        return new ArrayList<SGIChildObject>(this.getVisibleChildList());
    }

    @Override
    public boolean isChanged() {
        return this.mUndoManager.isChanged();
    }

    @Override
    public boolean isChangedRoot() {
        if (this.isChanged()) {
            return true;
        }
        List<SGIUndoable> list = this.getUndoableChildList();
        for (int i = 0; i < list.size(); ++i) {
            SGIUndoable sGIUndoable;
            SGIUndoable sGIUndoable2 = list.get(i);
            if (!(sGIUndoable2 instanceof SGIUndoable) || !(sGIUndoable = sGIUndoable2).isChangedRoot()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean updateHistory() {
        return this.updateHistory(new ArrayList<SGIUndoable>(this.getUndoableChildList()));
    }

    protected boolean deleteUselessChild() {
        Set set = this.getAvailableChildSet();
        ArrayList<SGIChildObject> arrayList = new ArrayList<SGIChildObject>(this.mChildList);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Object e = arrayList.get(i);
            if (!set.contains(e)) {
                this.removeChild(e);
            }
            e = null;
        }
        return true;
    }

    protected Set getAvailableChildSet() {
        return new HashSet();
    }

    @Override
    public void initUndoBuffer() {
        List<SGIUndoable> list = this.getUndoableChildList();
        for (int i = 0; i < list.size(); ++i) {
            SGIUndoable sGIUndoable = list.get(i);
            if (!(sGIUndoable instanceof SGIUndoable)) continue;
            SGIUndoable sGIUndoable2 = sGIUndoable;
            sGIUndoable2.initUndoBuffer();
        }
        this.mUndoManager.initUndoBuffer();
        if (!this.deleteUselessChild()) {
            throw new Error("Failed to initialize undo buffer.");
        }
    }

    @Override
    public boolean deleteForwardHistory() {
        List<SGIUndoable> list = this.getUndoableChildList();
        for (int i = 0; i < list.size(); ++i) {
            SGIUndoable sGIUndoable = list.get(i);
            if (sGIUndoable.deleteForwardHistory()) continue;
            return false;
        }
        if (!this.mUndoManager.deleteForwardHistory()) {
            return false;
        }
        return this.deleteUselessChild();
    }

    @Override
    public boolean hideChildObject(int n) {
        SGIChildObject sGIChildObject = this.getVisibleChild(n);
        if (sGIChildObject == null) {
            return false;
        }
        sGIChildObject.setVisible(false);
        this.clearFocusedObjects();
        this.setChanged(true);
        this.notifyChange();
        this.notifyToRoot();
        this.repaint();
        return true;
    }

    @Override
    public boolean onKeyPressed(KeyEvent keyEvent) {
        boolean bl = false;
        SGTuple2f sGTuple2f = this.getDisplacement(keyEvent);
        if (!sGTuple2f.isZero()) {
            List<SGIChildObject> list = this.getVisibleChildList();
            for (int i = list.size() - 1; i >= 0; --i) {
                IMovableChild iMovableChild;
                SGIChildObject sGIChildObject = list.get(i);
                if (!(sGIChildObject instanceof IMovableChild) || !(iMovableChild = (IMovableChild)sGIChildObject).isSelected()) continue;
                if (!iMovableChild.prepare()) {
                    return false;
                }
                iMovableChild.translate(sGTuple2f.x, sGTuple2f.y);
                if (!iMovableChild.commit()) {
                    return false;
                }
                this.notifyToRoot();
                this.notifyChange();
                this.repaint();
                bl = true;
            }
        }
        return bl;
    }

    protected SGTuple2f getDisplacement(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiersEx();
        boolean bl = (n2 & 0x40) != 0;
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 38: {
                if (bl) {
                    n4 = -1;
                    break;
                }
                n4 = -10;
                break;
            }
            case 40: {
                if (bl) {
                    n4 = 1;
                    break;
                }
                n4 = 10;
                break;
            }
            case 37: {
                if (bl) {
                    n3 = -1;
                    break;
                }
                n3 = -10;
                break;
            }
            case 39: {
                n3 = bl ? 1 : 10;
            }
        }
        return new SGTuple2f(n3, n4);
    }

    public void notifyDataSelection() {
        this.notifyToListener("Notify the selection of data");
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public boolean duplicateFocusedData(SGData sGData, String string) {
        return true;
    }

    @Override
    public SGProperties synchronizeDataProperties(SGProperties sGProperties, SGProperties sGProperties2) {
        return null;
    }

    @Override
    public void onMenuSelected() {
    }

    protected Set<Number> calcAxisValues(SGAxis sGAxis, double d, double d2) {
        double d3 = sGAxis.getMinValue();
        double d4 = sGAxis.getMaxValue();
        return SGUtilityNumber.calcStepValue(d3, d4, d, d2, 4);
    }

    @Override
    public SGPropertyResults setProperties(SGPropertyMap sGPropertyMap) {
        return null;
    }

    @Override
    public SGPropertyResults setChildProperties(int n, SGPropertyMap sGPropertyMap) {
        return null;
    }

    @Override
    public SGIChildObject getChild(int n) {
        for (int i = 0; i < this.mChildList.size(); ++i) {
            SGIChildObject sGIChildObject = this.mChildList.get(i);
            if (sGIChildObject.getID() != n) continue;
            return sGIChildObject;
        }
        return null;
    }

    @Override
    public boolean closeTextField() {
        return true;
    }

    protected static interface IMovableChild
    extends SGIChildObject,
    SGIMovable,
    SGISelectable,
    SGIPropertyDialogObserver {
    }
}

