/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIVisible;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SGElementGroup
implements SGIElementGroupConstants,
SGIDrawingElementConstants,
SGIVisible,
SGIDisposable {
    protected SGDrawingElement[] mDrawingElementArray = null;
    protected float mMagnification = 1.0f;
    protected boolean mVisibleFlag = true;
    private boolean mDisposed = false;

    public void dispose() {
        this.mDisposed = true;
        if (this.mDrawingElementArray != null) {
            SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                sGDrawingElementArray[i].dispose();
            }
            this.mDrawingElementArray = null;
        }
    }

    public boolean isDisposed() {
        return this.mDisposed;
    }

    public boolean initDrawingElement(int n) {
        SGDrawingElement[] sGDrawingElementArray = new SGDrawingElement[n];
        for (int i = 0; i < n; ++i) {
            sGDrawingElementArray[i] = this.createDrawingElementInstance(i);
        }
        this.mDrawingElementArray = sGDrawingElementArray;
        return true;
    }

    protected abstract SGDrawingElement createDrawingElementInstance(int var1);

    public SGDrawingElement[] getDrawingElementArray() {
        return this.mDrawingElementArray;
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public boolean setMagnification(float f) {
        if ((double)f <= 0.0) {
            throw new IllegalArgumentException("mag <= 0.0");
        }
        this.mMagnification = f;
        return true;
    }

    public void setVisible(boolean bl) {
        this.mVisibleFlag = bl;
    }

    public boolean isVisible() {
        return this.mVisibleFlag;
    }

    public boolean contains(int n, int n2) {
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                if (!this.mDrawingElementArray[i].isVisible() || !this.mDrawingElementArray[i].contains(n, n2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean paintElement(Graphics2D graphics2D) {
        return this.paintElement(graphics2D, null);
    }

    public abstract boolean paintElement(Graphics2D var1, Rectangle2D var2);

    public abstract String getTagName();

    public Element createElement(Document document) {
        Element element = document.createElement(this.getTagName());
        if (!this.writeProperty(element)) {
            return null;
        }
        return element;
    }

    public abstract boolean writeProperty(Element var1);

    public abstract boolean readProperty(Element var1);

    public SGProperties getProperties() {
        ElementGroupProperties elementGroupProperties = new ElementGroupProperties();
        if (!this.getProperties(elementGroupProperties)) {
            return null;
        }
        return elementGroupProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof ElementGroupProperties)) {
            return false;
        }
        ElementGroupProperties elementGroupProperties = (ElementGroupProperties)sGProperties;
        elementGroupProperties.setVisible(this.isVisible());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ElementGroupProperties)) {
            return false;
        }
        ElementGroupProperties elementGroupProperties = (ElementGroupProperties)sGProperties;
        Boolean bl = elementGroupProperties.isVisible();
        if (bl == null) {
            return false;
        }
        this.setVisible(bl);
        return true;
    }

    public static class ElementGroupProperties
    extends SGProperties {
        private boolean mVisible;

        public Object copy() {
            Object object = super.copy();
            ElementGroupProperties elementGroupProperties = (ElementGroupProperties)object;
            return elementGroupProperties;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ElementGroupProperties)) {
                return false;
            }
            ElementGroupProperties elementGroupProperties = (ElementGroupProperties)object;
            return this.mVisible == elementGroupProperties.mVisible;
        }

        public Boolean isVisible() {
            return this.mVisible;
        }

        public void setVisible(boolean bl) {
            this.mVisible = bl;
        }
    }
}

