/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;
import org.w3c.dom.Element;

public abstract class SGDrawingElementString
extends SGDrawingElement
implements SGIStringConstants,
SGIDrawingElementConstants {
    protected float mMagnification = 1.0f;
    protected Color mColor = null;
    private String mString = null;
    private Font mFont = null;
    private String mFontName = "Serif";
    private int mFontStyle = 0;
    private float mFontSize = 16.0f;
    private float mAngle = 0.0f;
    private float mX = 0.0f;
    private float mY = 0.0f;

    public SGDrawingElementString() {
        this.mString = "";
        this.mColor = DEFAULT_STRING_FONT_COLOR;
        this.updateFont();
    }

    public SGDrawingElementString(String string) {
        this.mString = string;
        this.mColor = DEFAULT_STRING_FONT_COLOR;
        this.updateFont();
    }

    public SGDrawingElementString(SGDrawingElementString sGDrawingElementString) {
        this.mString = sGDrawingElementString.mString;
        this.mX = sGDrawingElementString.mX;
        this.mY = sGDrawingElementString.mY;
        this.mFontName = sGDrawingElementString.getFontName();
        this.mFontStyle = sGDrawingElementString.getFontStyle();
        this.mFontSize = sGDrawingElementString.getFontSize();
        this.mAngle = sGDrawingElementString.mAngle;
        this.updateFont();
    }

    public SGDrawingElementString(String string, String string2, int n, float f, Color color, float f2, float f3) {
        this.mString = string;
        this.mFontName = string2;
        this.mFontStyle = n;
        this.mFontSize = f;
        this.mAngle = f3;
        this.mColor = color;
        this.mMagnification = f2;
        this.updateFont();
    }

    public void dispose() {
        super.dispose();
        this.mString = null;
        this.mFont = null;
        this.mFontName = null;
    }

    public final String toString() {
        return this.getString();
    }

    public boolean setString(String string) {
        this.mString = string;
        return true;
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public boolean setMagnification(float f) {
        if ((double)f <= 0.0) {
            throw new IllegalArgumentException("mag <= 0.0");
        }
        this.mMagnification = f;
        this.updateFont();
        return true;
    }

    public final boolean setFontName(String string) {
        return this.setFont(string, this.mFontStyle, this.mFontSize);
    }

    public final boolean setFontStyle(int n) {
        if (!SGUtilityText.isValidFontStyle(n)) {
            return false;
        }
        return this.setFont(this.mFontName, n, this.mFontSize);
    }

    public final boolean setFontSize(float f) {
        return this.setFont(this.mFontName, this.mFontStyle, f);
    }

    public final boolean setFontSize(float f, String string) {
        Float f2 = SGUtility.getFontSize(f, string);
        if (f2 == null) {
            return false;
        }
        return this.setFontSize(f2.floatValue());
    }

    public boolean setFont(String string, int n, float f) {
        this.mFontName = string;
        this.mFontStyle = n;
        this.mFontSize = f;
        this.updateFont();
        return true;
    }

    private boolean updateFont() {
        this.mFont = new Font(this.mFontName, this.mFontStyle, (int)(this.getMagnification() * this.mFontSize));
        return true;
    }

    public final boolean setLocation(SGTuple2f sGTuple2f) {
        if (sGTuple2f == null) {
            throw new IllegalArgumentException("pos==null");
        }
        this.setLocation(sGTuple2f.x, sGTuple2f.y);
        return true;
    }

    public final boolean setLocation(float f, float f2) {
        this.setX(f);
        this.setY(f2);
        return true;
    }

    public final void translate(float f, float f2) {
        this.setLocation(this.getX() + f, this.getY() + f2);
    }

    public boolean setX(float f) {
        this.mX = f;
        return true;
    }

    public boolean setY(float f) {
        this.mY = f;
        return true;
    }

    public boolean setAngle(float f) {
        Float f2 = SGUtility.calcPropertyValue(f, null, null, -180.0, 180.0, -2);
        if (f2 == null) {
            return false;
        }
        this.mAngle = f2.floatValue();
        return true;
    }

    public final String getString() {
        return this.mString;
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public final SGTuple2f getLocation() {
        return new SGTuple2f(this.getX(), this.getY());
    }

    public final Font getFont() {
        return this.mFont;
    }

    public final String getFontName() {
        return this.mFontName;
    }

    public final float getFontSize() {
        return this.mFontSize;
    }

    public final int getFontStyle() {
        return this.mFontStyle;
    }

    public final float getAngle() {
        return this.mAngle;
    }

    public Color getColor() {
        return this.mColor;
    }

    public boolean setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color == null");
        }
        this.mColor = color;
        return true;
    }

    public SGProperties getProperties() {
        StringProperties stringProperties = new StringProperties();
        this.getProperties(stringProperties);
        return stringProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof StringProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        StringProperties stringProperties = (StringProperties)sGProperties;
        stringProperties.setFontName(this.mFontName);
        stringProperties.setFontSize(this.mFontSize);
        stringProperties.setFontStyle(this.mFontStyle);
        stringProperties.setAngle(this.mAngle);
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof StringProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        StringProperties stringProperties = (StringProperties)sGProperties;
        this.setFont(stringProperties.getFontName(), stringProperties.getFontStyle(), stringProperties.getFontSize().floatValue());
        this.setAngle(stringProperties.getAngle().floatValue());
        this.setColor(stringProperties.getColor());
        return true;
    }

    public boolean writeProperty(Element element) {
        float f = (float)SGUtilityNumber.roundOffNumber(this.mFontSize, -3);
        float f2 = (float)SGUtilityNumber.roundOffNumber(this.mAngle, -3);
        ArrayList<Color> arrayList = new ArrayList<Color>();
        arrayList.add(this.mColor);
        element.setAttribute("Text", this.mString);
        element.setAttribute("FontName", this.mFontName);
        element.setAttribute("FontSize", Float.toString(f) + "pt");
        element.setAttribute("FontStyle", SGUtilityText.getFontStyleName(this.mFontStyle));
        element.setAttribute("StringColor", SGUtilityText.getColorListString(arrayList));
        element.setAttribute("Angle", Float.toString(f2));
        return true;
    }

    public boolean readProperty(Element element) {
        Object object;
        String string = null;
        Number number = null;
        List<Color> list = null;
        string = element.getAttribute("Text");
        if (string.length() != 0 && !this.setString((String)(object = string))) {
            return false;
        }
        string = element.getAttribute("FontName");
        if (string.length() != 0 && !this.setFontName((String)(object = string))) {
            return false;
        }
        string = element.getAttribute("FontSize");
        if (string.length() != 0) {
            object = new StringBuffer();
            number = SGUtilityText.getNumber(string, (StringBuffer)object);
            if (number == null) {
                return false;
            }
            float f = number.floatValue();
            if (!this.setFontSize(f, ((StringBuffer)object).toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("FontStyle")).length() != 0) {
            object = SGUtilityText.getFontStyle(string);
            if (object == null) {
                return false;
            }
            if (!this.setFontStyle((Integer)object)) {
                return false;
            }
        }
        if ((string = element.getAttribute("StringColor")).length() != 0) {
            list = SGUtilityText.getColorList(string);
            if (list == null) {
                return false;
            }
            if (list.size() < 1) {
                return false;
            }
            object = list.get(0);
            if (!this.setColor((Color)object)) {
                return false;
            }
        }
        if ((string = element.getAttribute("Angle")).length() != 0) {
            number = SGUtilityText.getFloat(string, SGIConstants.degree);
            if (number == null) {
                return false;
            }
            float f = number.floatValue();
            if (!this.setAngle(f)) {
                return false;
            }
        }
        return true;
    }

    public static class StringProperties
    extends SGDrawingElement.DrawingElementProperties {
        private float mFontSize = 0.0f;
        private int mFontStyle = -1;
        private String mFontName = null;
        private float mAngle = 0.0f;
        private Color mColor = null;

        public boolean equals(Object object) {
            if (!(object instanceof StringProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            StringProperties stringProperties = (StringProperties)object;
            if (this.mFontSize != stringProperties.mFontSize) {
                return false;
            }
            if (this.mFontStyle != stringProperties.mFontStyle) {
                return false;
            }
            if (!this.mFontName.equals(stringProperties.mFontName)) {
                return false;
            }
            if (this.mAngle != stringProperties.mAngle) {
                return false;
            }
            return SGUtility.equals(this.mColor, stringProperties.mColor);
        }

        public String getFontName() {
            return this.mFontName;
        }

        public Float getFontSize() {
            return Float.valueOf(this.mFontSize);
        }

        public Integer getFontStyle() {
            return this.mFontStyle;
        }

        public Float getAngle() {
            return Float.valueOf(this.mAngle);
        }

        public Color getColor() {
            return this.mColor;
        }

        public boolean setFontName(String string) {
            this.mFontName = string;
            return true;
        }

        public boolean setFontSize(float f) {
            this.mFontSize = f;
            return true;
        }

        public boolean setFontStyle(int n) {
            this.mFontStyle = n;
            return true;
        }

        public boolean setAngle(float f) {
            this.mAngle = f;
            return true;
        }

        public boolean setColor(Color color) {
            this.mColor = color;
            return true;
        }
    }
}

