/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGIArrowConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIErrorBarConstants;

public abstract class SGDrawingElementErrorBar
extends SGDrawingElement
implements SGIArrowConstants,
SGIErrorBarConstants {
    protected SGDrawingElementArrow mLowerArrowElement;
    protected SGDrawingElementArrow mUpperArrowElement;

    protected abstract SGDrawingElementArrow createArrowInstance(int var1);

    protected final SGDrawingElementArrow getLowerArrow() {
        return this.mLowerArrowElement;
    }

    protected final SGDrawingElementArrow getUpperArrow() {
        return this.mUpperArrowElement;
    }

    public void dispose() {
        super.dispose();
        this.mLowerArrowElement.dispose();
        this.mLowerArrowElement = null;
        this.mUpperArrowElement.dispose();
        this.mUpperArrowElement = null;
    }

    public static boolean isValidErrorBarStyle(int n) {
        int[] nArray = new int[]{1, 2, 3};
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public static Integer getErrorBarStyleFromName(String string) {
        int n;
        if (string == null) {
            return null;
        }
        if (SGUtilityText.isEqualString("Bothsides", string)) {
            n = 1;
        } else if (SGUtilityText.isEqualString("Upside", string)) {
            n = 2;
        } else if (SGUtilityText.isEqualString("Downside", string)) {
            n = 3;
        } else {
            return null;
        }
        return n;
    }

    public static String getErrorBarStyleName(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "Bothsides";
                break;
            }
            case 2: {
                string = "Upside";
                break;
            }
            case 3: {
                string = "Downside";
                break;
            }
        }
        return string;
    }

    public static boolean isValidErrorBarPosition(int n) {
        int[] nArray = new int[]{1, 2};
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public static Integer getErrorBarPositionFromName(String string) {
        int n;
        if (string == null) {
            return null;
        }
        if (SGUtilityText.isEqualString("Line", string)) {
            n = 1;
        } else if (SGUtilityText.isEqualString("Bar", string)) {
            n = 2;
        } else {
            return null;
        }
        return n;
    }

    public static String getErrorBarPositionName(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "Line";
                break;
            }
            case 2: {
                string = "Bar";
                break;
            }
        }
        return string;
    }

    public static boolean isValidHeadType(int n) {
        int[] nArray = new int[]{1, 8, -1};
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public static Integer getHeadTypeFromName(String string) {
        int n;
        if (string == null) {
            return null;
        }
        if (SGUtilityText.isEqualString("Circle", string)) {
            n = 1;
        } else if (SGUtilityText.isEqualString("Transverse Line", string)) {
            n = 8;
        } else if (SGUtilityText.isEqualString("No Symbol", string)) {
            n = -1;
        } else {
            return null;
        }
        return n;
    }

    public static String getHeadTypeName(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "Circle";
                break;
            }
            case 8: {
                string = "Transverse Line";
                break;
            }
            case -1: {
                string = "No Symbol";
                break;
            }
        }
        return string;
    }

    public boolean setLocation(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2, SGTuple2f sGTuple2f3) {
        this.mLowerArrowElement.setLocation(sGTuple2f, sGTuple2f2);
        this.mUpperArrowElement.setLocation(sGTuple2f, sGTuple2f3);
        return true;
    }

    public abstract Color getColor();

    public abstract boolean setColor(Color var1);

    public abstract float getLineWidth();

    public abstract boolean setLineWidth(float var1);

    public abstract float getHeadSize();

    public abstract boolean setHeadSize(float var1);

    public abstract int getErrorBarStyle();

    public abstract boolean setErrorBarStyle(int var1);

    public abstract int getHeadType();

    public abstract boolean setHeadType(int var1);

    public SGProperties getProperties() {
        ErrorBarProperties errorBarProperties = new ErrorBarProperties();
        if (!this.getProperties(errorBarProperties)) {
            return null;
        }
        return errorBarProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof ErrorBarProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        ErrorBarProperties errorBarProperties = (ErrorBarProperties)sGProperties;
        errorBarProperties.setLineWidth(this.getLineWidth());
        errorBarProperties.setHeadSize(this.getHeadSize());
        errorBarProperties.setHeadType(this.getHeadType());
        errorBarProperties.setErrorBarStyle(this.getErrorBarStyle());
        errorBarProperties.setColor(this.getColor());
        return true;
    }

    public void setLowerVisible(boolean bl) {
        this.mLowerArrowElement.setVisible(bl);
    }

    public void setUpperVisible(boolean bl) {
        this.mUpperArrowElement.setVisible(bl);
    }

    public boolean isLowerVisible() {
        return this.mLowerArrowElement.isVisible();
    }

    public boolean isUpperVisible() {
        return this.mUpperArrowElement.isVisible();
    }

    public static class ErrorBarProperties
    extends SGDrawingElement.DrawingElementProperties {
        private SGDrawingElementArrow.ArrowProperties mArrowProperties = new SGDrawingElementArrow.ArrowProperties();
        private int mErrorBarStyle = 1;
        private int mHeadType;
        private boolean mVerticalFlag;

        public ErrorBarProperties() {
            this.mArrowProperties.setLineType(1);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ErrorBarProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ErrorBarProperties errorBarProperties = (ErrorBarProperties)object;
            if (!this.mArrowProperties.equals(errorBarProperties.mArrowProperties)) {
                return false;
            }
            if (this.mErrorBarStyle != errorBarProperties.mErrorBarStyle) {
                return false;
            }
            if (this.mHeadType != errorBarProperties.mHeadType) {
                return false;
            }
            if (!SGUtility.equals(this.getColor(), errorBarProperties.getColor())) {
                return false;
            }
            return this.mVerticalFlag == errorBarProperties.mVerticalFlag;
        }

        public Float getLineWidth() {
            return this.mArrowProperties.getLineWidth();
        }

        public Float getHeadSize() {
            return this.mArrowProperties.getHeadSize();
        }

        public Integer getHeadType() {
            return this.mHeadType;
        }

        public Integer getErrorBarStyle() {
            return this.mErrorBarStyle;
        }

        public Color getColor() {
            return this.mArrowProperties.getColor();
        }

        public Boolean isVertical() {
            return this.mVerticalFlag;
        }

        public void setLineWidth(float f) {
            this.mArrowProperties.setLineWidth(f);
        }

        public void setHeadType(int n) {
            this.mHeadType = n;
        }

        public void setHeadSize(float f) {
            this.mArrowProperties.setHeadSize(f);
        }

        public void setErrorBarStyle(int n) {
            this.mErrorBarStyle = n;
        }

        public boolean setColor(Color color) {
            return this.mArrowProperties.setColor(color);
        }

        public void setVertical(boolean bl) {
            this.mVerticalFlag = bl;
        }
    }
}

