/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.riken.brain.ni.samuraigraph.base.SGColorBarModel;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

public class SGColorBarStyleManager {
    public static final String COLOR_BAR_NAME_COLORS = "Colors";
    public static final String COLOR_BAR_NAME_GRADIENT_COLORS = "Gradient Colors";
    public static final String COLOR_BAR_NAME_BLACK_AND_WHITE = "Black and White";
    public static final String COLOR_BAR_NAME_GRAY_SCALE = "Gray Scale";
    public static final String COLOR_BAR_NAME_REPEATED_GRAY_SCALE = "Gray Scale Saw";
    public static final String COLOR_BAR_NAME_COLORS_SCALE_WHITE = "Colors Scale White";
    public static final String COLOR_BAR_NAME_COLORS_SCALE_BLACK = "Colors Scale Black";
    public static final String COLOR_BAR_NAME_REPEATED_GRADIENT_COLORS = "Gradient Colors Saw";
    public static final String[] DEFAULT_COLOR_BAR_NAMES = new String[]{"Colors", "Gradient Colors", "Black and White", "Gray Scale", "Gray Scale Saw", "Colors Scale White", "Colors Scale Black", "Gradient Colors Saw"};
    private static final SGColorBarModel[] DEFAULT_COLOR_BAR_MODELS;
    private Map<String, SGColorBarModel> mColorBarModelMap = new HashMap<String, SGColorBarModel>();
    private boolean mReversedOrderFlag = false;

    public SGColorBarStyleManager() {
        for (int i = 0; i < DEFAULT_COLOR_BAR_NAMES.length; ++i) {
            this.mColorBarModelMap.put(DEFAULT_COLOR_BAR_NAMES[i], (SGColorBarModel)DEFAULT_COLOR_BAR_MODELS[i].clone());
        }
    }

    public SGColorBarModel getColorBarModel(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name == null");
        }
        Set<String> set = this.mColorBarModelMap.keySet();
        for (String string2 : set) {
            if (!SGUtilityText.isEqualString(string2, string)) continue;
            return this.mColorBarModelMap.get(string2);
        }
        return null;
    }

    public boolean addColorBarModel(String string, SGColorBarModel sGColorBarModel) {
        if (string == null || sGColorBarModel == null) {
            throw new IllegalArgumentException("name == null || model == null");
        }
        for (int i = 0; i < DEFAULT_COLOR_BAR_NAMES.length; ++i) {
            if (!DEFAULT_COLOR_BAR_NAMES[i].equals(string)) continue;
            return false;
        }
        this.mColorBarModelMap.put(string, sGColorBarModel);
        return true;
    }

    public String getColorBarName(SGColorBarModel sGColorBarModel) {
        String string = null;
        Set<String> set = this.mColorBarModelMap.keySet();
        for (String string2 : set) {
            SGColorBarModel sGColorBarModel2 = this.mColorBarModelMap.get(string2);
            if (!sGColorBarModel2.equals(sGColorBarModel)) continue;
            string = string2;
            break;
        }
        return string;
    }

    public boolean isReversedOrder() {
        return this.mReversedOrderFlag;
    }

    public void setReversedOrder(boolean bl) {
        this.mReversedOrderFlag = bl;
        Iterator<SGColorBarModel> iterator = this.mColorBarModelMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().setReversedOrder(bl);
        }
    }

    public static void main(String[] stringArray) {
        HueColorBarModel hueColorBarModel = new HueColorBarModel();
        Color color = hueColorBarModel.eval(0.5);
        System.out.println(color);
    }

    static {
        Color[] colorArray = new Color[]{Color.BLUE, Color.CYAN, new Color(0, 255, 0), Color.YELLOW, Color.RED};
        Color[] colorArray2 = new Color[]{Color.BLACK, Color.WHITE};
        Color[][] colorArray3 = new Color[][]{{Color.BLUE, Color.WHITE}, {Color.CYAN, Color.WHITE}, {new Color(0, 255, 0), Color.WHITE}, {Color.YELLOW, Color.WHITE}, {Color.RED, Color.WHITE}};
        Color[][] colorArray4 = new Color[][]{{Color.BLUE, Color.BLACK}, {Color.CYAN, Color.BLACK}, {new Color(0, 255, 0), Color.BLACK}, {Color.YELLOW, Color.BLACK}, {Color.RED, Color.BLACK}};
        DEFAULT_COLOR_BAR_MODELS = new SGColorBarModel[DEFAULT_COLOR_BAR_NAMES.length];
        SGColorBarStyleManager.DEFAULT_COLOR_BAR_MODELS[0] = new DiscreteColorBarModel(colorArray);
        SGColorBarStyleManager.DEFAULT_COLOR_BAR_MODELS[1] = new HueColorBarModel();
        SGColorBarStyleManager.DEFAULT_COLOR_BAR_MODELS[2] = new DiscreteColorBarModel(colorArray2);
        SGColorBarStyleManager.DEFAULT_COLOR_BAR_MODELS[3] = new GradationalColorBarModel(colorArray2);
        SGColorBarStyleManager.DEFAULT_COLOR_BAR_MODELS[4] = new RepeatedGradationalColorBarModel(colorArray2, 3);
        SGColorBarStyleManager.DEFAULT_COLOR_BAR_MODELS[5] = new MultipleGradationalColorBarModel(colorArray3);
        SGColorBarStyleManager.DEFAULT_COLOR_BAR_MODELS[6] = new MultipleGradationalColorBarModel(colorArray4);
        SGColorBarStyleManager.DEFAULT_COLOR_BAR_MODELS[7] = new RepeatedHueColorBarModel(3);
    }

    public static class RepeatedDiscreteColorBarModel
    extends RepeatedColorBarModel {
        public RepeatedDiscreteColorBarModel(Color[] colorArray, int n) {
            super(colorArray, n);
        }

        protected SGColorBarModel createInstance(Color[] colorArray) {
            return new DiscreteColorBarModel(colorArray);
        }
    }

    public static class RepeatedHueColorBarModel
    extends RepeatedColorBarModel {
        public RepeatedHueColorBarModel(int n) {
            super(null, n);
        }

        protected SGColorBarModel createInstance(Color[] colorArray) {
            return new HueColorBarModel();
        }
    }

    public static class MultipleGradationalColorBarModel
    extends MultipleColorBarModel {
        public MultipleGradationalColorBarModel(Color[][] colorArray) {
            super(colorArray);
        }

        protected SGColorBarModel createInstance(Color[] colorArray) {
            return new GradationalColorBarModel(colorArray);
        }
    }

    public static abstract class MultipleColorBarModel
    extends SGColorBarModel {
        protected SGColorBarModel[] mModel;

        public MultipleColorBarModel(Color[] colorArray, int n) {
            this.mModel = new SGColorBarModel[n];
            for (int i = 0; i < n; ++i) {
                this.mModel[i] = this.createInstance(colorArray);
            }
        }

        public MultipleColorBarModel(Color[][] colorArray) {
            this.mModel = new SGColorBarModel[colorArray.length];
            for (int i = 0; i < colorArray.length; ++i) {
                this.mModel[i] = this.createInstance(colorArray[i]);
            }
        }

        public Color eval(double d) {
            if (d <= 0.0) {
                if (!this.isReversedOrder()) {
                    return this.mModel[0].eval(0.0);
                }
                return this.mModel[this.mModel.length - 1].eval(0.0);
            }
            if (d >= 1.0) {
                if (!this.isReversedOrder()) {
                    return this.mModel[this.mModel.length - 1].eval(1.0);
                }
                return this.mModel[0].eval(1.0);
            }
            int n = (int)d;
            double d2 = d - (double)n;
            int n2 = (int)(d2 * (double)this.mModel.length);
            double d3 = d2 * (double)this.mModel.length - (double)n2;
            if (!this.isReversedOrder()) {
                return this.mModel[n2].eval(d3);
            }
            return this.mModel[this.mModel.length - 1 - n2].eval(d3);
        }

        public void setReversedOrder(boolean bl) {
            super.setReversedOrder(bl);
            for (int i = 0; i < this.mModel.length; ++i) {
                this.mModel[i].setReversedOrder(bl);
            }
        }

        protected abstract SGColorBarModel createInstance(Color[] var1);
    }

    public static class RepeatedGradationalColorBarModel
    extends RepeatedColorBarModel {
        public RepeatedGradationalColorBarModel(Color[] colorArray, int n) {
            super(colorArray, n);
        }

        protected SGColorBarModel createInstance(Color[] colorArray) {
            return new GradationalColorBarModel(colorArray);
        }
    }

    public static abstract class RepeatedColorBarModel
    extends SGColorBarModel {
        protected int mRepeateNum;
        protected SGColorBarModel mModel;

        public RepeatedColorBarModel(Color[] colorArray, int n) {
            this.mRepeateNum = n;
            this.mModel = this.createInstance(colorArray);
        }

        public Color eval(double d) {
            int n = (int)d;
            float f = (float)(d - (double)n);
            int n2 = (int)(f * (float)this.mRepeateNum);
            float f2 = f * (float)this.mRepeateNum - (float)n2;
            return this.mModel.eval(f2);
        }

        public void setReversedOrder(boolean bl) {
            super.setReversedOrder(bl);
            this.mModel.setReversedOrder(bl);
        }

        protected abstract SGColorBarModel createInstance(Color[] var1);
    }

    public static class HueColorBarModel
    extends SGColorBarModel {
        public Color eval(double d) {
            double d2 = d <= 0.0 ? 0.0 : (d >= 1.0 ? 1.0 : d);
            double d3 = this.mReversedOrderFlag ? d2 : 1.0 - d2;
            float f = (float)(0.6666666666666666 * d3);
            Color color = new Color(Color.HSBtoRGB(f, 1.0f, 1.0f));
            return color;
        }
    }

    public static class GradationalColorBarModel
    extends SGColorBarModel {
        public GradationalColorBarModel(Color[] colorArray) {
            super(colorArray);
        }

        public Color eval(double d) {
            double d2;
            int n;
            int n2;
            if (d <= 0.0) {
                return this.getColor(0);
            }
            if (d >= 1.0) {
                return this.getColor(this.mColors.length - 1);
            }
            double d3 = d * (double)(this.mColors.length - 1) + 0.5;
            int n3 = (int)d3;
            double d4 = d3 - (double)n3;
            if (n3 == 0 && d4 < 0.5) {
                return this.getColor(0);
            }
            if (n3 == this.mColors.length - 1 && d4 >= 0.5) {
                return this.getColor(this.mColors.length - 1);
            }
            if (d4 < 0.5) {
                n2 = n3 - 1;
                n = n3;
                d2 = 0.5 + d4;
            } else {
                n2 = n3;
                n = n3 + 1;
                d2 = d4 - 0.5;
            }
            Color color = this.getColor(n2);
            Color color2 = this.getColor(n);
            double d5 = 1.0 - d2;
            double d6 = d2;
            double d7 = d5 * (double)color.getRed() + d6 * (double)color2.getRed();
            double d8 = d5 * (double)color.getGreen() + d6 * (double)color2.getGreen();
            double d9 = d5 * (double)color.getBlue() + d6 * (double)color2.getBlue();
            double d10 = d5 * (double)color.getAlpha() + d6 * (double)color2.getAlpha();
            Color color3 = new Color((int)d7, (int)d8, (int)d9, (int)d10);
            return color3;
        }
    }

    public static class DiscreteColorBarModel
    extends SGColorBarModel {
        public DiscreteColorBarModel(Color[] colorArray) {
            super(colorArray);
        }

        public Color eval(double d) {
            if (d <= 0.0) {
                return this.getColor(0);
            }
            if (d >= 1.0) {
                return this.getColor(this.mColors.length - 1);
            }
            double d2 = d * (double)(this.mColors.length - 1) + 0.5;
            int n = (int)d2;
            return this.getColor(n);
        }
    }
}

