/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

public class SGVXYDataUtility {
    static double[] getXComponentArray(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = Double.isNaN(dArray[i]) || Double.isNaN(dArray2[i]) || dArray[i] < 0.0 ? Double.NaN : dArray[i] * Math.cos(dArray2[i]);
        }
        return dArray3;
    }

    static double[] getYComponentArray(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = Double.isNaN(dArray[i]) || Double.isNaN(dArray2[i]) || dArray[i] < 0.0 ? Double.NaN : dArray[i] * Math.sin(dArray2[i]);
        }
        return dArray3;
    }

    static double[] getMagnitudeArray(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = dArray[i];
            double d2 = dArray2[i];
            dArray3[i] = Math.sqrt(d * d + d2 * d2);
        }
        return dArray3;
    }

    static double[] getAngleArray(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = dArray[i];
            if (d == 0.0) {
                dArray3[i] = 1.5707963267948966;
                continue;
            }
            double d2 = dArray2[i];
            dArray3[i] = Math.atan(d2 / d);
        }
        return dArray3;
    }
}

