/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGNumberDataColumn;

public class SGSamplingDataColumn
extends SGNumberDataColumn {
    private double mSamplingRate;
    private int mLength;

    public SGSamplingDataColumn(double d, int n) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("samplingRate <= 0.0: " + d);
        }
        if (n < 0) {
            throw new IllegalArgumentException("length < 0 :" + n);
        }
        this.mSamplingRate = d;
        this.mLength = n;
        this.mTitle = SGDataUtility.createSamplingRateTitle(d);
    }

    public int getLength() {
        return this.mLength;
    }

    public String getValueType() {
        return "Sampling Rate";
    }

    public Object getValue(int n) {
        return this.calcValue(n);
    }

    private double calcValue(int n) {
        return (double)n / this.mSamplingRate;
    }

    protected Object getExportedValue(int n) {
        return this.getValue(n);
    }

    public double getSamplingRate() {
        return this.mSamplingRate;
    }

    public double[] getNumberArray() {
        double[] dArray = new double[this.mLength];
        for (int i = 0; i < this.mLength; ++i) {
            dArray[i] = this.calcValue(i);
        }
        return dArray;
    }
}

