/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.base.SGValueRange;
import jp.riken.brain.ni.samuraigraph.data.SGDataSourceObserver;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGDateVariable;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnNameConstants;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFFile;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleDimensionNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleVariableNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGTextVariable;
import jp.riken.brain.ni.samuraigraph.data.SGVariable;
import ucar.ma2.Array;
import ucar.nc2.Dimension;

public class SGSXYNetCDFData
extends SGNetCDFData
implements SGISXYTypeData,
SGIDataColumnTypeConstants,
SGIDataColumnNameConstants {
    protected SGVariable mXVariable = null;
    protected SGVariable mYVariable = null;
    protected SGVariable mLowerErrorVariable = null;
    protected SGVariable mUpperErrorVariable = null;
    protected SGVariable mErrorBarHolderVariable = null;
    protected SGVariable mTickLabelVariable = null;
    protected SGVariable mTickLabelHolderVariable = null;
    protected int mDecimalPlaces = 0;
    protected int mExponent = 0;

    public SGSXYNetCDFData() {
    }

    public SGSXYNetCDFData(SGNetCDFFile sGNetCDFFile, SGDataSourceObserver sGDataSourceObserver, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        super(sGNetCDFFile, sGDataSourceObserver, string8, string9);
        Object object;
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("xName == null || yName == null");
        }
        if (!(string3 == null && string4 == null || string3 != null && string4 != null)) {
            throw new IllegalArgumentException("lName = " + string3 + ", uName = " + string4);
        }
        if (string3 != null && string5 == null) {
            throw new IllegalArgumentException("Error bar holder name is null.");
        }
        if (string6 != null && string7 == null) {
            throw new IllegalArgumentException("Tick label holder name is null.");
        }
        SGVariable sGVariable = this.getVariable(sGNetCDFFile, string);
        SGVariable sGVariable2 = this.getVariable(sGNetCDFFile, string2);
        SGVariable sGVariable3 = this.getVariable(sGNetCDFFile, string3);
        SGVariable sGVariable4 = this.getVariable(sGNetCDFFile, string4);
        SGVariable sGVariable5 = this.getVariable(sGNetCDFFile, string5);
        SGVariable sGVariable6 = this.getVariable(sGNetCDFFile, string6);
        SGVariable sGVariable7 = this.getVariable(sGNetCDFFile, string7);
        ArrayList<Dimension> arrayList = new ArrayList<Dimension>();
        if (this.mTimeVariable != null) {
            object = this.mTimeVariable.getDimension(0);
            arrayList.add((Dimension)object);
        }
        if (this.isSerialNumberAvailable()) {
            if (sGVariable.isCoordinateVariable() || sGVariable2.isCoordinateVariable()) {
                throw new IllegalArgumentException("Both of x and y variables must not be coordinate variables.");
            }
            object = this.mSerialNumberVariable.getDimension(0);
            arrayList.add((Dimension)object);
            this.checkNotCoordinateVariable(sGVariable, arrayList);
            this.checkNotCoordinateVariable(sGVariable2, arrayList);
        } else {
            Dimension dimension;
            if (sGVariable.isCoordinateVariable() && sGVariable2.isCoordinateVariable() || !sGVariable.isCoordinateVariable() && !sGVariable2.isCoordinateVariable()) {
                throw new IllegalArgumentException("Either of x and y variables must be a coordinate variable.");
            }
            object = null;
            SGVariable sGVariable8 = null;
            if (sGVariable.isCoordinateVariable()) {
                object = sGVariable;
                sGVariable8 = sGVariable2;
            } else {
                object = sGVariable2;
                sGVariable8 = sGVariable;
            }
            Dimension dimension2 = ((SGVariable)object).getDimension(0);
            arrayList.add(dimension2);
            if (this.mTimeVariable != null && dimension2.equals((Object)(dimension = this.mTimeVariable.getDimension(0)))) {
                throw new IllegalArgumentException("The dimension of a coordinate variable is equal to the dimension for time.");
            }
            this.checkNotCoordinateVariable(sGVariable8, arrayList);
        }
        this.checkNotCoordinateVariable(sGVariable3, arrayList);
        this.checkNotCoordinateVariable(sGVariable4, arrayList);
        this.checkNotCoordinateVariable(sGVariable5, arrayList);
        this.checkNotCoordinateVariable(sGVariable6, arrayList);
        this.checkNotCoordinateVariable(sGVariable7, arrayList);
        this.mXVariable = sGVariable;
        this.mYVariable = sGVariable2;
        this.mLowerErrorVariable = sGVariable3;
        this.mUpperErrorVariable = sGVariable4;
        this.mErrorBarHolderVariable = sGVariable5;
        this.mTickLabelVariable = sGVariable6;
        this.mTickLabelHolderVariable = sGVariable7;
    }

    public void dispose() {
        super.dispose();
        this.mXVariable = null;
        this.mYVariable = null;
        this.mLowerErrorVariable = null;
        this.mUpperErrorVariable = null;
        this.mErrorBarHolderVariable = null;
        this.mTickLabelVariable = null;
        this.mTickLabelHolderVariable = null;
    }

    private SGVariable getCoordinateVariable() {
        if (this.isSerialNumberAvailable()) {
            return this.mSerialNumberVariable;
        }
        if (this.mXVariable.isCoordinateVariable()) {
            return this.mXVariable;
        }
        return this.mYVariable;
    }

    public SGProperties getProperties() {
        SXYNetCDFDataProperties sXYNetCDFDataProperties = new SXYNetCDFDataProperties();
        if (!this.getProperties(sXYNetCDFDataProperties)) {
            return null;
        }
        return sXYNetCDFDataProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SXYNetCDFDataProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        SXYNetCDFDataProperties sXYNetCDFDataProperties = (SXYNetCDFDataProperties)sGProperties;
        sXYNetCDFDataProperties.xName = this.getName(this.mXVariable);
        sXYNetCDFDataProperties.yName = this.getName(this.mYVariable);
        sXYNetCDFDataProperties.lName = this.getName(this.mLowerErrorVariable);
        sXYNetCDFDataProperties.uName = this.getName(this.mUpperErrorVariable);
        sXYNetCDFDataProperties.ehName = this.getName(this.mErrorBarHolderVariable);
        sXYNetCDFDataProperties.tName = this.getName(this.mTickLabelVariable);
        sXYNetCDFDataProperties.thName = this.getName(this.mTickLabelHolderVariable);
        return true;
    }

    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGSXYNetCDFData)) {
            throw new IllegalArgumentException("Given data is not the instance of SGSXYNetCDFData class.");
        }
        if (!super.setData(sGData)) {
            return false;
        }
        SGSXYNetCDFData sGSXYNetCDFData = (SGSXYNetCDFData)sGData;
        this.mXVariable = sGSXYNetCDFData.mXVariable;
        this.mYVariable = sGSXYNetCDFData.mYVariable;
        this.mLowerErrorVariable = sGSXYNetCDFData.mLowerErrorVariable;
        this.mUpperErrorVariable = sGSXYNetCDFData.mUpperErrorVariable;
        this.mErrorBarHolderVariable = sGSXYNetCDFData.mErrorBarHolderVariable;
        this.mTickLabelVariable = sGSXYNetCDFData.mTickLabelVariable;
        this.mTickLabelHolderVariable = sGSXYNetCDFData.mTickLabelHolderVariable;
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SXYNetCDFDataProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        SXYNetCDFDataProperties sXYNetCDFDataProperties = (SXYNetCDFDataProperties)sGProperties;
        this.mXVariable = this.findVariable(sXYNetCDFDataProperties.xName);
        this.mYVariable = this.findVariable(sXYNetCDFDataProperties.yName);
        this.mLowerErrorVariable = this.findVariable(sXYNetCDFDataProperties.lName);
        this.mUpperErrorVariable = this.findVariable(sXYNetCDFDataProperties.uName);
        this.mErrorBarHolderVariable = this.findVariable(sXYNetCDFDataProperties.ehName);
        this.mTickLabelVariable = this.findVariable(sXYNetCDFDataProperties.tName);
        this.mTickLabelHolderVariable = this.findVariable(sXYNetCDFDataProperties.thName);
        return true;
    }

    protected double[][] getDataSetValues() {
        double[] dArray = this.getXValueArray();
        double[] dArray2 = this.getYValueArray();
        double[] dArray3 = this.getLowerErrorValueArray();
        double[] dArray4 = this.getUpperErrorValueArray();
        int n = dArray.length;
        boolean bl = dArray3 != null && dArray4 != null;
        int n2 = bl ? 4 : 2;
        Object object = null;
        object = bl ? (Object)new double[][]{dArray, dArray2, dArray3, dArray4} : (Object)new double[][]{dArray, dArray2};
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = new double[n2];
            for (int j = 0; j < n2; ++j) {
                dArrayArray[i][j] = object[j][i];
            }
        }
        return dArrayArray;
    }

    public String getDataType() {
        return "SXY_NETCDF";
    }

    public Double getLowerErrorValue(int n) {
        double[] dArray = this.getLowerErrorValueArray();
        if (dArray == null) {
            return null;
        }
        return dArray[n];
    }

    public double[] getLowerErrorValueArray() {
        if (this.isErrorBarAvailable()) {
            double[] dArray = SGUtility.copyDoubleArray(this.getValueArray(this.mLowerErrorVariable, new SGVariable[]{this.getCoordinateVariable()}));
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = -Math.abs(dArray[i]);
            }
            return dArray;
        }
        return null;
    }

    public int getPointsNumber() {
        SGVariable sGVariable = this.getCoordinateVariable();
        Dimension dimension = sGVariable.getDimension(0);
        return dimension.getLength();
    }

    public String getString(int n) {
        int n2 = this.getPointsNumber();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("given index is out of bounds: " + n);
        }
        if (this.isTickLabelAvailable()) {
            String[] stringArray = this.getTextArray();
            if (stringArray == null) {
                return "";
            }
            return stringArray[n];
        }
        return "";
    }

    protected String[] getTextArray() {
        if (this.isTickLabelAvailable()) {
            if (this.mTickLabelVariable instanceof SGTextVariable) {
                return ((SGTextVariable)this.mTickLabelVariable).getStringArray();
            }
            if (this.mTickLabelVariable instanceof SGDateVariable) {
                return ((SGDateVariable)this.mTickLabelVariable).getStringArray();
            }
            if (this.mTickLabelVariable.getVariable() != null) {
                if (this.mTickLabelVariable.getVariable().getDataType().isString()) {
                    return null;
                }
                double[] dArray = this.getValueArray(this.mTickLabelVariable, new SGVariable[]{this.getCoordinateVariable()});
                String[] stringArray = SGUtilityNumber.getStringArray(dArray, this.mDecimalPlaces, this.mExponent);
                return stringArray;
            }
        }
        return null;
    }

    public String[] getStringArray() {
        return this.getTextArray();
    }

    public Double getUpperErrorValue(int n) {
        double[] dArray = this.getUpperErrorValueArray();
        if (dArray == null) {
            return null;
        }
        return dArray[n];
    }

    public double[] getUpperErrorValueArray() {
        if (this.isErrorBarAvailable()) {
            double[] dArray = SGUtility.copyDoubleArray(this.getValueArray(this.mUpperErrorVariable, new SGVariable[]{this.getCoordinateVariable()}));
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = Math.abs(dArray[i]);
            }
            return dArray;
        }
        return null;
    }

    public Double getXValue(int n) {
        double[] dArray = this.getXValueArray();
        if (dArray == null) {
            return null;
        }
        return dArray[n];
    }

    public double[] getXValueArray() {
        if (this.isSerialNumberAvailable()) {
            return this.getValueArray(this.mXVariable, new SGVariable[]{this.mSerialNumberVariable});
        }
        if (this.mXVariable.isCoordinateVariable()) {
            return this.getCoordinateValueArray(this.mXVariable);
        }
        return this.getValueArray(this.mXVariable, new SGVariable[]{this.mYVariable});
    }

    public Double getYValue(int n) {
        double[] dArray = this.getYValueArray();
        if (dArray == null) {
            return null;
        }
        return dArray[n];
    }

    public double[] getYValueArray() {
        if (this.isSerialNumberAvailable()) {
            return this.getValueArray(this.mYVariable, new SGVariable[]{this.mSerialNumberVariable});
        }
        if (this.mYVariable.isCoordinateVariable()) {
            return this.getCoordinateValueArray(this.mYVariable);
        }
        return this.getValueArray(this.mYVariable, new SGVariable[]{this.mXVariable});
    }

    public boolean isErrorBarAvailable() {
        return this.mLowerErrorVariable != null && this.mUpperErrorVariable != null;
    }

    public boolean isTickLabelAvailable() {
        return this.mTickLabelVariable != null;
    }

    public boolean hasEqualTickLabelResource(SGISXYTypeData sGISXYTypeData) {
        if (!(sGISXYTypeData instanceof SGSXYNetCDFData)) {
            return false;
        }
        SGSXYNetCDFData sGSXYNetCDFData = (SGSXYNetCDFData)sGISXYTypeData;
        if (this.mTickLabelVariable == null) {
            return sGSXYNetCDFData.mTickLabelVariable == null;
        }
        return this.mTickLabelVariable.equals(sGSXYNetCDFData.mTickLabelVariable);
    }

    public SGValueRange getBoundsX() {
        return SGDataUtility.getBoundsX(this);
    }

    public SGValueRange getBoundsY() {
        return SGDataUtility.getBoundsY(this);
    }

    public String getTitleX() {
        return this.getNameWithUnit(this.mXVariable);
    }

    public String getTitleY() {
        return this.getNameWithUnit(this.mYVariable);
    }

    public String[] getCurrentColumnType() {
        List<SGVariable> list = this.mNCFile.getVariables();
        int n = list.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            SGVariable sGVariable = list.get(i);
            if (sGVariable.equals(this.mXVariable)) {
                stringArray[i] = "X";
                continue;
            }
            if (sGVariable.equals(this.mYVariable)) {
                stringArray[i] = "Y";
                continue;
            }
            if (sGVariable.equals(this.mLowerErrorVariable) || sGVariable.equals(this.mUpperErrorVariable)) {
                String string = null;
                if (this.mLowerErrorVariable.equals(this.mUpperErrorVariable)) {
                    string = "Lower / Upper Error";
                } else if (sGVariable.equals(this.mLowerErrorVariable)) {
                    string = "Lower Error";
                } else if (sGVariable.equals(this.mUpperErrorVariable)) {
                    string = "Upper Error";
                }
                if (string == null) {
                    return null;
                }
                int n2 = this.mNCFile.getVariableIndex(this.mErrorBarHolderVariable.getName());
                if (n2 == -1) {
                    return null;
                }
                stringArray[i] = SGDataUtility.appendColumnTitle(string, this.mErrorBarHolderVariable.getName());
                continue;
            }
            if (sGVariable.equals(this.mTickLabelVariable)) {
                int n3 = this.mNCFile.getVariableIndex(this.mTickLabelHolderVariable.getName());
                if (n3 == -1) {
                    return null;
                }
                stringArray[i] = SGDataUtility.appendColumnTitle("Tick Label", this.mTickLabelHolderVariable.getName());
                continue;
            }
            stringArray[i] = sGVariable.equals(this.mTimeVariable) ? "Time" : (sGVariable.equals(this.mSerialNumberVariable) ? "SerialNumbers" : "");
        }
        return stringArray;
    }

    public boolean setColumnType(String[] stringArray) {
        Integer n;
        Object object;
        SGVariable sGVariable = null;
        SGVariable sGVariable2 = null;
        Object object2 = null;
        Object object3 = null;
        Object object4 = null;
        Object object5 = null;
        Object object6 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        List<SGVariable> list = this.mNCFile.getVariables();
        for (int i = 0; i < stringArray.length; ++i) {
            object = list.get(i);
            if (SGUtilityText.isEqualString("X", stringArray[i])) {
                sGVariable = object;
                continue;
            }
            if (SGUtilityText.isEqualString("Y", stringArray[i])) {
                sGVariable2 = object;
                continue;
            }
            if (SGUtilityText.startsWith(stringArray[i], "Lower Error")) {
                object2 = object;
                string = stringArray[i];
                continue;
            }
            if (SGUtilityText.startsWith(stringArray[i], "Upper Error")) {
                object3 = object;
                string2 = stringArray[i];
                continue;
            }
            if (SGUtilityText.startsWith(stringArray[i], "Lower / Upper Error")) {
                object2 = object;
                object3 = object;
                string = stringArray[i];
                string2 = stringArray[i];
                continue;
            }
            if (SGUtilityText.startsWith(stringArray[i], "Tick Label")) {
                object4 = object;
                string3 = stringArray[i];
                continue;
            }
            if (SGUtilityText.isEqualString(stringArray[i], "Time")) {
                object5 = object;
                continue;
            }
            if (SGUtilityText.isEqualString(stringArray[i], "SerialNumbers")) {
                object6 = object;
                continue;
            }
            if ("".equals(stringArray[i])) continue;
            return false;
        }
        if (sGVariable == null || sGVariable2 == null) {
            return false;
        }
        if (!(object2 != null && object3 != null || object2 == null && object3 == null)) {
            return false;
        }
        SGVariable sGVariable3 = null;
        if (string != null && string2 != null) {
            object = SGDataUtility.getColumnIndexOfNetCDFAppendedColumnTitle(string, this.mNCFile);
            n = SGDataUtility.getColumnIndexOfNetCDFAppendedColumnTitle(string2, this.mNCFile);
            if (object == null || n == null || !((Integer)object).equals(n)) {
                return false;
            }
            sGVariable3 = list.get((Integer)object);
        }
        object = null;
        if (string3 != null) {
            n = SGDataUtility.getColumnIndexOfNetCDFAppendedColumnTitle(string3, this.mNCFile);
            if (n == null) {
                return false;
            }
            object = list.get(n);
        }
        this.mXVariable = sGVariable;
        this.mYVariable = sGVariable2;
        this.mLowerErrorVariable = object2;
        this.mUpperErrorVariable = object3;
        this.mErrorBarHolderVariable = sGVariable3;
        this.mTickLabelVariable = object4;
        this.mTickLabelHolderVariable = object;
        this.mTimeVariable = object5;
        this.mSerialNumberVariable = object6;
        return true;
    }

    protected String getDataTypeForDataSet() {
        return "SXY";
    }

    public SGVariable[] getVariables() {
        ArrayList<SGVariable> arrayList = new ArrayList<SGVariable>();
        arrayList.add(this.mXVariable);
        arrayList.add(this.mYVariable);
        boolean bl = this.isErrorBarAvailable();
        boolean bl2 = this.isTickLabelAvailable();
        if (bl && bl2) {
            arrayList.add(this.mLowerErrorVariable);
            arrayList.add(this.mUpperErrorVariable);
            arrayList.add(this.mTickLabelVariable);
        } else if (bl && !bl2) {
            arrayList.add(this.mLowerErrorVariable);
            arrayList.add(this.mUpperErrorVariable);
        } else if (!bl && bl2) {
            arrayList.add(this.mTickLabelVariable);
        }
        if (this.mTimeVariable != null) {
            arrayList.add(this.mTimeVariable);
        }
        if (this.mSerialNumberVariable != null) {
            arrayList.add(this.mSerialNumberVariable);
        }
        SGVariable[] sGVariableArray = new SGVariable[arrayList.size()];
        return arrayList.toArray(sGVariableArray);
    }

    public SGVariable getXVariable() {
        return this.mXVariable;
    }

    public SGVariable getYVariable() {
        return this.mYVariable;
    }

    public SGVariable getLowerErrorVariable() {
        return this.mLowerErrorVariable;
    }

    public SGVariable getUpperErrorVariable() {
        return this.mUpperErrorVariable;
    }

    public SGVariable getErrorHolderVariable() {
        return this.mErrorBarHolderVariable;
    }

    public SGVariable getTickLabelVariable() {
        return this.mTickLabelVariable;
    }

    public SGVariable getTickLabelHolderVariable() {
        return this.mTickLabelHolderVariable;
    }

    public void setDecimalPlaces(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Decimal places must not be negative: " + n);
        }
        this.mDecimalPlaces = n;
    }

    public void setExponent(int n) {
        this.mExponent = n;
    }

    public int getDecimalPlaces() {
        return this.mDecimalPlaces;
    }

    public int getExponent() {
        return this.mExponent;
    }

    protected Double[] arrangeValueArray(Array array, SGVariable sGVariable, SGVariable[] sGVariableArray) {
        return this.arrange1Dim(array);
    }

    public Boolean isErrorBarVertical() {
        if (this.isErrorBarAvailable()) {
            return this.mErrorBarHolderVariable.equals(this.mYVariable);
        }
        return null;
    }

    public Boolean isTickLabelHorizontal() {
        if (this.isTickLabelAvailable()) {
            return this.mTickLabelHolderVariable.equals(this.mYVariable);
        }
        return null;
    }

    public boolean isXVariableCoordinate() {
        return this.getXVariable().isCoordinateVariable();
    }

    public SGISXYTypeMultipleData toMultiple() {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        String[] stringArray4;
        String[] stringArray5;
        String[] stringArray6;
        String[] stringArray7;
        String[] stringArray8;
        String[] stringArray9;
        boolean bl = this.isErrorBarAvailable();
        boolean bl2 = this.isTickLabelAvailable();
        String[] stringArray10 = new String[]{this.mXVariable.getName()};
        String[] stringArray11 = new String[]{this.mYVariable.getName()};
        if (bl) {
            String[] stringArray12 = new String[1];
            stringArray9 = stringArray12;
            stringArray12[0] = this.mLowerErrorVariable.getName();
        } else {
            stringArray9 = stringArray8 = null;
        }
        if (bl) {
            String[] stringArray13 = new String[1];
            stringArray7 = stringArray13;
            stringArray13[0] = this.mUpperErrorVariable.getName();
        } else {
            stringArray7 = stringArray6 = null;
        }
        if (bl) {
            String[] stringArray14 = new String[1];
            stringArray5 = stringArray14;
            stringArray14[0] = this.mErrorBarHolderVariable.getName();
        } else {
            stringArray5 = stringArray4 = null;
        }
        if (bl2) {
            String[] stringArray15 = new String[1];
            stringArray3 = stringArray15;
            stringArray15[0] = this.mTickLabelVariable.getName();
        } else {
            stringArray3 = stringArray2 = null;
        }
        if (bl2) {
            String[] stringArray16 = new String[1];
            stringArray = stringArray16;
            stringArray16[0] = this.mTickLabelHolderVariable.getName();
        } else {
            stringArray = null;
        }
        String[] stringArray17 = stringArray;
        String string = this.mTimeVariable != null ? this.mTimeVariable.getName() : null;
        String string2 = this.isSerialNumberAvailable() ? this.mSerialNumberVariable.getName() : null;
        SGSXYMultipleVariableNetCDFData sGSXYMultipleVariableNetCDFData = new SGSXYMultipleVariableNetCDFData(this.mNCFile, this.mObserver, stringArray10, stringArray11, stringArray8, stringArray6, stringArray4, stringArray2, stringArray17, string, string2);
        sGSXYMultipleVariableNetCDFData.mOriginMap = new HashMap(this.mOriginMap);
        sGSXYMultipleVariableNetCDFData.setDecimalPlaces(this.mDecimalPlaces);
        sGSXYMultipleVariableNetCDFData.setExponent(this.mExponent);
        sGSXYMultipleVariableNetCDFData.mVariableCache = new HashMap(this.mVariableCache);
        return sGSXYMultipleVariableNetCDFData;
    }

    public SGISXYTypeMultipleData toMultiple(Dimension dimension, int n) {
        boolean bl = this.isErrorBarAvailable();
        boolean bl2 = this.isTickLabelAvailable();
        String string = bl ? this.mLowerErrorVariable.getName() : null;
        String string2 = bl ? this.mUpperErrorVariable.getName() : null;
        String string3 = bl2 ? this.mTickLabelVariable.getName() : null;
        String string4 = this.mTimeVariable != null ? this.mTimeVariable.getName() : null;
        String string5 = this.isSerialNumberAvailable() ? this.mSerialNumberVariable.getName() : null;
        SGSXYMultipleDimensionNetCDFData sGSXYMultipleDimensionNetCDFData = new SGSXYMultipleDimensionNetCDFData(this.mNCFile, this.mObserver, this.mXVariable.getName(), this.mYVariable.getName(), string, string2, string3, dimension.getName(), n, n, 0, string4, string5);
        sGSXYMultipleDimensionNetCDFData.mVariableCache = new HashMap(this.mVariableCache);
        return sGSXYMultipleDimensionNetCDFData;
    }

    public static class SXYNetCDFDataProperties
    extends SGNetCDFData.NetCDFDataProperties {
        protected String xName = null;
        protected String yName = null;
        protected String lName = null;
        protected String uName = null;
        protected String ehName = null;
        protected String tName = null;
        protected String thName = null;

        public void dispose() {
            super.dispose();
            this.xName = null;
            this.yName = null;
            this.lName = null;
            this.uName = null;
            this.ehName = null;
            this.tName = null;
            this.thName = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SXYNetCDFDataProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            SXYNetCDFDataProperties sXYNetCDFDataProperties = (SXYNetCDFDataProperties)object;
            if (!SGUtility.equals(this.xName, sXYNetCDFDataProperties.xName)) {
                return false;
            }
            if (!SGUtility.equals(this.yName, sXYNetCDFDataProperties.yName)) {
                return false;
            }
            if (!SGUtility.equals(this.lName, sXYNetCDFDataProperties.lName)) {
                return false;
            }
            if (!SGUtility.equals(this.uName, sXYNetCDFDataProperties.uName)) {
                return false;
            }
            if (!SGUtility.equals(this.ehName, sXYNetCDFDataProperties.ehName)) {
                return false;
            }
            if (!SGUtility.equals(this.tName, sXYNetCDFDataProperties.tName)) {
                return false;
            }
            return SGUtility.equals(this.thName, sXYNetCDFDataProperties.thName);
        }
    }
}

