/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGValueRange;
import jp.riken.brain.ni.samuraigraph.data.SGDataSourceObserver;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnNameConstants;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFFile;
import jp.riken.brain.ni.samuraigraph.data.SGVariable;
import ucar.ma2.Array;
import ucar.nc2.Dimension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SGSXYMultipleNetCDFData
extends SGNetCDFData
implements SGISXYTypeMultipleData,
SGIDataColumnTypeConstants,
SGIDataColumnNameConstants {
    protected Integer mDimensionStart = null;
    protected Integer mDimensionEnd = null;
    protected Integer mDimensionStep = null;
    protected int mDecimalPlaces = 0;
    protected int mExponent = 0;

    public SGSXYMultipleNetCDFData() {
    }

    public SGSXYMultipleNetCDFData(SGNetCDFFile sGNetCDFFile, SGDataSourceObserver sGDataSourceObserver, String string, String string2) {
        super(sGNetCDFFile, sGDataSourceObserver, string, string2);
    }

    @Override
    public int getPointsNumber() {
        SGVariable sGVariable = this.getCoordinateVariable();
        Dimension dimension = sGVariable.getDimension(0);
        return dimension.getLength();
    }

    @Override
    public SGValueRange getBoundsX() {
        return SGDataUtility.getBoundsX(this);
    }

    @Override
    public SGValueRange getBoundsY() {
        return SGDataUtility.getBoundsY(this);
    }

    protected SGVariable[] getVariables(String[] stringArray, SGNetCDFFile sGNetCDFFile, List<Dimension> list) {
        SGVariable[] sGVariableArray = null;
        if (stringArray != null) {
            sGVariableArray = new SGVariable[stringArray.length];
            for (int i = 0; i < sGVariableArray.length; ++i) {
                SGVariable sGVariable = sGNetCDFFile.findVariable(stringArray[i]);
                this.checkNotCoordinateVariable(sGVariable, list);
                sGVariableArray[i] = sGVariable;
            }
        }
        return sGVariableArray;
    }

    protected abstract boolean hasMultipleYValues();

    public abstract SGVariable getSingleVariable();

    @Override
    protected Double[] arrangeValueArray(Array array, SGVariable sGVariable, SGVariable[] sGVariableArray) {
        return this.arrange1Dim(array);
    }

    protected int find(SGVariable sGVariable, SGVariable[] sGVariableArray) {
        if (sGVariableArray == null) {
            return -1;
        }
        for (int i = 0; i < sGVariableArray.length; ++i) {
            if (!sGVariableArray[i].equals(sGVariable)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGSXYMultipleNetCDFData)) {
            throw new IllegalArgumentException("Given data is not the instance of SGSXYMultipleNetCDFData class.");
        }
        if (!super.setData(sGData)) {
            return false;
        }
        SGSXYMultipleNetCDFData sGSXYMultipleNetCDFData = (SGSXYMultipleNetCDFData)sGData;
        this.mDimensionStart = sGSXYMultipleNetCDFData.mDimensionStart;
        this.mDimensionEnd = sGSXYMultipleNetCDFData.mDimensionEnd;
        this.mDimensionStep = sGSXYMultipleNetCDFData.mDimensionStep;
        return true;
    }

    @Override
    public void setDecimalPlaces(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Decimal places must not be negative: " + n);
        }
        this.mDecimalPlaces = n;
    }

    @Override
    public void setExponent(int n) {
        this.mExponent = n;
    }

    @Override
    public int getDecimalPlaces() {
        return this.mDecimalPlaces;
    }

    @Override
    public int getExponent() {
        return this.mExponent;
    }

    @Override
    public Double getXValue(int n, int n2) {
        return this.getXValueArray()[n][n2];
    }

    @Override
    public Double getYValue(int n, int n2) {
        return this.getYValueArray()[n][n2];
    }

    protected SGVariable getCoordinateVariable() {
        if (this.isSerialNumberAvailable()) {
            return this.mSerialNumberVariable;
        }
        return this.getSingleVariable();
    }

    protected double[][] getSingleVariableValueArray() {
        if (this.isSerialNumberAvailable()) {
            return new double[][]{this.getValueArray(this.getSingleVariable(), new SGVariable[]{this.mSerialNumberVariable})};
        }
        return new double[][]{this.getCoordinateValueArray(this.getSingleVariable())};
    }

    protected abstract double[][] getMultipleVariableValueArray();

    @Override
    public double[][] getXValueArray() {
        if (this.hasMultipleYValues()) {
            return this.getSingleVariableValueArray();
        }
        return this.getMultipleVariableValueArray();
    }

    @Override
    public double[][] getYValueArray() {
        if (this.hasMultipleYValues()) {
            return this.getMultipleVariableValueArray();
        }
        return this.getSingleVariableValueArray();
    }

    public int getDimensionStart() {
        if (null != this.mDimensionStart) {
            return this.mDimensionStart;
        }
        return -1;
    }

    public int getDimensionEnd() {
        if (null != this.mDimensionEnd) {
            return this.mDimensionEnd;
        }
        return -1;
    }

    public int getDimensionStep() {
        if (null != this.mDimensionStep) {
            return this.mDimensionStep;
        }
        return -1;
    }

    public boolean setDimensionStart(int n) {
        this.mDimensionStart = n;
        return true;
    }

    public boolean setDimensionEnd(int n) {
        this.mDimensionEnd = n;
        return true;
    }

    public boolean setDimensionStep(int n) {
        this.mDimensionStep = n;
        return true;
    }

    public abstract boolean isXVariableCoordinate();

    @Override
    public boolean setColumnInfo(SGDataColumnInfo[] sGDataColumnInfoArray) {
        return super.setColumnInfo(sGDataColumnInfoArray);
    }

    @Override
    public void setCurrentTimeValueIndex(int n) {
        super.setCurrentTimeValueIndex(n);
    }

    @Override
    public boolean setProperties(SGProperties sGProperties) {
        return super.setProperties(sGProperties);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mVariableCache.clear();
    }
}

