/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.base.SGValueRange;
import jp.riken.brain.ni.samuraigraph.data.SGArrayData;
import jp.riken.brain.ni.samuraigraph.data.SGDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGDataSourceObserver;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGDateDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnNameConstants;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGINumberDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGNumberDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGSXYData;
import jp.riken.brain.ni.samuraigraph.data.SGSamplingDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGTextDataFile;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGSXYMultipleData
extends SGArrayData
implements SGISXYTypeMultipleData,
SGIDataColumnTypeConstants,
SGIDataColumnNameConstants {
    protected Integer[] mXIndices = null;
    protected Integer[] mYIndices = null;
    protected Integer[] mLowerErrorIndices = null;
    protected Integer[] mUpperErrorIndices = null;
    protected Integer[] mErrorBarHolderIndices = null;
    protected Integer[] mTickLabelIndices = null;
    protected Integer[] mTickLabelHolderIndices = null;
    protected int mDecimalPlaces = 0;
    protected int mExponent = 0;

    public SGSXYMultipleData() {
    }

    protected SGSXYMultipleData(SGTextDataFile sGTextDataFile, SGDataSourceObserver sGDataSourceObserver) {
        super(sGTextDataFile, sGDataSourceObserver);
    }

    public SGSXYMultipleData(SGTextDataFile sGTextDataFile, SGDataSourceObserver sGDataSourceObserver, Integer[] integerArray, Integer[] integerArray2) {
        super(sGTextDataFile, sGDataSourceObserver);
        if (!this.isValidXYValueIndices(integerArray, integerArray2)) {
            throw new IllegalArgumentException("Column indices for x or y values are invalid.");
        }
        this.mXIndices = (Integer[])integerArray.clone();
        this.mYIndices = (Integer[])integerArray2.clone();
    }

    public SGSXYMultipleData(SGTextDataFile sGTextDataFile, SGDataSourceObserver sGDataSourceObserver, Integer[] integerArray, Integer[] integerArray2, Integer[] integerArray3, Integer[] integerArray4, Integer[] integerArray5, Integer[] integerArray6, Integer[] integerArray7) {
        this(sGTextDataFile, sGDataSourceObserver, integerArray, integerArray2);
        Integer[] integerArray8;
        Integer[] integerArray9 = integerArray8 = integerArray.length == 1 ? integerArray2 : integerArray;
        if (!this.isValidErrorBarIndices(integerArray8, integerArray3, integerArray4, integerArray5)) {
            throw new IllegalArgumentException("Column indices for the error bars are invalid.");
        }
        if (!this.isValidTickLabelIndices(integerArray8, integerArray6, integerArray7)) {
            throw new IllegalArgumentException("Column indices for the tick labels are invalid.");
        }
        if (integerArray3 != null && integerArray3.length != 0) {
            this.mLowerErrorIndices = (Integer[])integerArray3.clone();
        }
        if (integerArray4 != null && integerArray4.length != 0) {
            this.mUpperErrorIndices = (Integer[])integerArray4.clone();
        }
        if (integerArray5 != null && integerArray5.length != 0) {
            this.mErrorBarHolderIndices = (Integer[])integerArray5.clone();
        }
        if (integerArray6 != null && integerArray6.length != 0) {
            this.mTickLabelIndices = (Integer[])integerArray6.clone();
        }
        if (integerArray7 != null && integerArray7.length != 0) {
            this.mTickLabelHolderIndices = (Integer[])integerArray7.clone();
        }
        if (integerArray6 == null || integerArray6.length == 0) {
            this.updateDateTickLabelColumns();
        }
    }

    private void updateDateTickLabelColumns() {
        block3: {
            SGDataColumn sGDataColumn;
            block2: {
                SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
                SGDataColumn sGDataColumn2 = sGDataColumnArray[this.mXIndices[0]];
                sGDataColumn = sGDataColumnArray[this.mYIndices[0]];
                if (!(sGDataColumn2 instanceof SGDateDataColumn)) break block2;
                this.mTickLabelHolderIndices = this.mYIndices;
                this.mTickLabelIndices = new Integer[this.mYIndices.length];
                for (int i = 0; i < this.mTickLabelIndices.length; ++i) {
                    this.mTickLabelIndices[i] = this.mXIndices[0];
                }
                break block3;
            }
            if (!(sGDataColumn instanceof SGDateDataColumn)) break block3;
            this.mTickLabelHolderIndices = this.mXIndices;
            this.mTickLabelIndices = new Integer[this.mXIndices.length];
            for (int i = 0; i < this.mTickLabelIndices.length; ++i) {
                this.mTickLabelIndices[i] = this.mYIndices[0];
            }
        }
    }

    protected boolean isValidIndices(Integer[] integerArray) {
        if (integerArray == null) {
            return false;
        }
        for (int i = 0; i < integerArray.length; ++i) {
            if (integerArray[i] == null) {
                return false;
            }
            if (this.checkColumnIndexRange(integerArray[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isValidXYValueIndices(Integer[] integerArray, Integer[] integerArray2) {
        if (integerArray == null || integerArray2 == null) {
            return false;
        }
        if (integerArray.length == 0 || integerArray2.length == 0) {
            return false;
        }
        if (integerArray.length != 1 && integerArray2.length != 1) {
            return false;
        }
        if (!this.isValidIndices(integerArray)) {
            return false;
        }
        return this.isValidIndices(integerArray2);
    }

    protected boolean isValidErrorBarIndices(Integer[] integerArray, Integer[] integerArray2, Integer[] integerArray3, Integer[] integerArray4) {
        if (integerArray2 != null && integerArray3 != null) {
            if (!this.isValidIndices(integerArray2)) {
                return false;
            }
            if (!this.isValidIndices(integerArray3)) {
                return false;
            }
            if (integerArray2.length != integerArray3.length) {
                return false;
            }
            if (integerArray4 != null) {
                if (!this.isValidIndices(integerArray4)) {
                    return false;
                }
                if (integerArray4.length != integerArray2.length) {
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean isValidTickLabelIndices(Integer[] integerArray, Integer[] integerArray2, Integer[] integerArray3) {
        if (integerArray2 != null) {
            if (!this.isValidIndices(integerArray2)) {
                return false;
            }
            if (integerArray3 != null) {
                if (!this.isValidIndices(integerArray3)) {
                    return false;
                }
                if (integerArray3.length != integerArray2.length) {
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean hasMultipleYValues() {
        if (this.hasPairOfXYValues()) {
            if (this.isErrorBarAvailable()) {
                return SGUtility.contains((Object[])this.mErrorBarHolderIndices, this.mYIndices);
            }
            if (this.isTickLabelAvailable()) {
                return SGUtility.contains((Object[])this.mTickLabelHolderIndices, this.mYIndices);
            }
            return true;
        }
        return this.mXIndices.length == 1;
    }

    protected boolean hasPairOfXYValues() {
        return this.mXIndices.length == 1 && this.mYIndices.length == 1;
    }

    protected double[][] getMultipleValues() {
        return this.hasMultipleYValues() ? this.getYArray() : this.getXArray();
    }

    @Override
    public int getPointsNumber() {
        return this.getXArray()[0].length;
    }

    @Override
    public String getDataType() {
        return "SXY_MULTIPLE";
    }

    @Override
    public Double getXValue(int n, int n2) {
        int n3 = this.getPointsNumber();
        if (n2 < 0 || n2 >= n3) {
            throw new IllegalArgumentException("given index is out of bounds: " + n2);
        }
        if (n < 0 || n >= this.mXIndices.length) {
            throw new IllegalArgumentException("given index is out of bounds: " + n);
        }
        return this.getXArray(n)[n2];
    }

    @Override
    public Double getYValue(int n, int n2) {
        int n3 = this.getPointsNumber();
        if (n2 < 0 || n2 >= n3) {
            throw new IllegalArgumentException("given index is out of bounds: " + n2);
        }
        if (n < 0 || n >= this.mYIndices.length) {
            throw new IllegalArgumentException("given index is out of bounds: " + n);
        }
        return this.getYArray(n)[n2];
    }

    @Override
    public SGISXYTypeData[] getSXYDataArray() {
        boolean bl;
        int n;
        int n2;
        boolean bl2 = this.hasMultipleYValues();
        boolean bl3 = this.isErrorBarAvailable();
        boolean bl4 = this.isTickLabelAvailable();
        int n3 = bl2 ? this.getYNumber() : this.getXNumber();
        SGISXYTypeData[] sGISXYTypeDataArray = new SGISXYTypeData[n3];
        Integer n4 = null;
        Integer n5 = null;
        Integer[] integerArray = null;
        Integer[] integerArray2 = null;
        Integer[] integerArray3 = null;
        Integer[] integerArray4 = null;
        Integer[] integerArray5 = null;
        if (bl2) {
            n4 = this.mXIndices[0];
        } else {
            n5 = this.mYIndices[0];
        }
        if (bl3) {
            integerArray = new Integer[n3];
            integerArray2 = new Integer[n3];
            integerArray3 = new Integer[n3];
            block0: for (n2 = 0; n2 < sGISXYTypeDataArray.length; ++n2) {
                integerArray[n2] = null;
                integerArray2[n2] = null;
                integerArray3[n2] = null;
                for (n = 0; n < this.mErrorBarHolderIndices.length; ++n) {
                    boolean bl5 = bl = bl2 ? this.mErrorBarHolderIndices[n].equals(this.mYIndices[n2]) : this.mErrorBarHolderIndices[n].equals(this.mXIndices[n2]);
                    if (!bl) continue;
                    integerArray[n2] = this.mLowerErrorIndices[n];
                    integerArray2[n2] = this.mUpperErrorIndices[n];
                    integerArray3[n2] = this.mErrorBarHolderIndices[n];
                    continue block0;
                }
            }
        }
        if (bl4) {
            integerArray4 = new Integer[n3];
            integerArray5 = new Integer[n3];
            block2: for (n2 = 0; n2 < sGISXYTypeDataArray.length; ++n2) {
                integerArray4[n2] = null;
                integerArray5[n2] = null;
                for (n = 0; n < this.mTickLabelHolderIndices.length; ++n) {
                    boolean bl6 = bl = bl2 ? this.mTickLabelHolderIndices[n].equals(this.mYIndices[n2]) : this.mTickLabelHolderIndices[n].equals(this.mXIndices[n2]);
                    if (!bl) continue;
                    integerArray4[n2] = this.mTickLabelIndices[n];
                    integerArray5[n2] = this.mTickLabelHolderIndices[n];
                    continue block2;
                }
            }
        }
        for (n2 = 0; n2 < sGISXYTypeDataArray.length; ++n2) {
            Integer n6 = bl2 ? n4 : this.mXIndices[n2];
            Integer n7 = bl2 ? this.mYIndices[n2] : n5;
            Integer n8 = bl3 ? integerArray[n2] : null;
            Integer n9 = bl3 ? integerArray2[n2] : null;
            Integer n10 = bl3 ? integerArray3[n2] : null;
            Integer n11 = bl4 ? integerArray4[n2] : null;
            Integer n12 = bl4 ? integerArray5[n2] : null;
            sGISXYTypeDataArray[n2] = new SGSXYData(this.mDataFile, this.mObserver, n6, n7, n8, n9, n10, n11, n12);
        }
        for (n2 = 0; n2 < sGISXYTypeDataArray.length; ++n2) {
            sGISXYTypeDataArray[n2].setDecimalPlaces(this.mDecimalPlaces);
            sGISXYTypeDataArray[n2].setExponent(this.mExponent);
        }
        return sGISXYTypeDataArray;
    }

    @Override
    public SGISXYTypeMultipleData[] getSXYTypeMultipleDataArray() {
        SGISXYTypeData[] sGISXYTypeDataArray = this.getSXYDataArray();
        SGISXYTypeMultipleData[] sGISXYTypeMultipleDataArray = new SGISXYTypeMultipleData[sGISXYTypeDataArray.length];
        for (int i = 0; i < sGISXYTypeDataArray.length; ++i) {
            SGSXYData sGSXYData = (SGSXYData)sGISXYTypeDataArray[i];
            sGISXYTypeMultipleDataArray[i] = sGSXYData.toMultiple();
            sGSXYData.dispose();
        }
        return sGISXYTypeMultipleDataArray;
    }

    @Override
    public double[][] getXValueArray() {
        return this.getXArray();
    }

    @Override
    public double[][] getYValueArray() {
        return this.getYArray();
    }

    @Override
    public SGValueRange getBoundsX() {
        return SGDataUtility.getBoundsX(this);
    }

    @Override
    public SGValueRange getBoundsY() {
        return SGDataUtility.getBoundsY(this);
    }

    @Override
    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGSXYMultipleData)) {
            return false;
        }
        if (!super.setData(sGData)) {
            return false;
        }
        SGSXYMultipleData sGSXYMultipleData = (SGSXYMultipleData)sGData;
        if (sGSXYMultipleData.mXIndices != null) {
            this.mXIndices = SGUtility.copyIntegerArray(sGSXYMultipleData.mXIndices);
        }
        if (sGSXYMultipleData.mYIndices != null) {
            this.mYIndices = SGUtility.copyIntegerArray(sGSXYMultipleData.mYIndices);
        }
        if (sGSXYMultipleData.mLowerErrorIndices != null) {
            this.mLowerErrorIndices = SGUtility.copyIntegerArray(sGSXYMultipleData.mLowerErrorIndices);
        }
        if (sGSXYMultipleData.mUpperErrorIndices != null) {
            this.mUpperErrorIndices = SGUtility.copyIntegerArray(sGSXYMultipleData.mUpperErrorIndices);
        }
        if (sGSXYMultipleData.mErrorBarHolderIndices != null) {
            this.mErrorBarHolderIndices = SGUtility.copyIntegerArray(sGSXYMultipleData.mErrorBarHolderIndices);
        }
        if (sGSXYMultipleData.mTickLabelIndices != null) {
            this.mTickLabelIndices = SGUtility.copyIntegerArray(sGSXYMultipleData.mTickLabelIndices);
        }
        if (sGSXYMultipleData.mTickLabelHolderIndices != null) {
            this.mTickLabelHolderIndices = SGUtility.copyIntegerArray(sGSXYMultipleData.mTickLabelHolderIndices);
        }
        return true;
    }

    @Override
    public Object copy() {
        SGSXYMultipleData sGSXYMultipleData = (SGSXYMultipleData)super.copy();
        if (this.mXIndices != null) {
            sGSXYMultipleData.mXIndices = SGUtility.copyIntegerArray(this.mXIndices);
        }
        if (this.mYIndices != null) {
            sGSXYMultipleData.mYIndices = SGUtility.copyIntegerArray(this.mYIndices);
        }
        if (this.mLowerErrorIndices != null) {
            sGSXYMultipleData.mLowerErrorIndices = SGUtility.copyIntegerArray(this.mLowerErrorIndices);
        }
        if (this.mUpperErrorIndices != null) {
            sGSXYMultipleData.mUpperErrorIndices = SGUtility.copyIntegerArray(this.mUpperErrorIndices);
        }
        if (this.mErrorBarHolderIndices != null) {
            sGSXYMultipleData.mErrorBarHolderIndices = SGUtility.copyIntegerArray(this.mErrorBarHolderIndices);
        }
        if (this.mTickLabelIndices != null) {
            sGSXYMultipleData.mTickLabelIndices = SGUtility.copyIntegerArray(this.mTickLabelIndices);
        }
        if (this.mTickLabelHolderIndices != null) {
            sGSXYMultipleData.mTickLabelHolderIndices = SGUtility.copyIntegerArray(this.mTickLabelHolderIndices);
        }
        return sGSXYMultipleData;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mXIndices = null;
        this.mYIndices = null;
        this.mLowerErrorIndices = null;
        this.mUpperErrorIndices = null;
        this.mErrorBarHolderIndices = null;
        this.mTickLabelIndices = null;
        this.mTickLabelHolderIndices = null;
    }

    protected double[][] getXArray() {
        return this.getValueArray(this.mXIndices);
    }

    protected double[][] getYArray() {
        return this.getValueArray(this.mYIndices);
    }

    protected double[][] getValueArray(Integer[] integerArray) {
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        double[][] dArrayArray = new double[integerArray.length][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            SGINumberDataColumn sGINumberDataColumn = (SGINumberDataColumn)((Object)sGDataColumnArray[integerArray[i]]);
            dArrayArray[i] = sGINumberDataColumn.getNumberArray();
        }
        return dArrayArray;
    }

    protected double[] getXArray(int n) {
        if (n < 0 || n >= this.mXIndices.length) {
            throw new IllegalArgumentException(n + ": m < 0 || m >= this.mXIndices.length");
        }
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        SGINumberDataColumn sGINumberDataColumn = (SGINumberDataColumn)((Object)sGDataColumnArray[this.mXIndices[n]]);
        return sGINumberDataColumn.getNumberArray();
    }

    protected double[] getYArray(int n) {
        if (n < 0 || n >= this.mYIndices.length) {
            throw new IllegalArgumentException(n + ": m < 0 || m >= this.mYIndices.length");
        }
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        SGINumberDataColumn sGINumberDataColumn = (SGINumberDataColumn)((Object)sGDataColumnArray[this.mYIndices[n]]);
        return sGINumberDataColumn.getNumberArray();
    }

    public int getXNumber() {
        return this.mXIndices.length;
    }

    public int getYNumber() {
        return this.mYIndices.length;
    }

    @Override
    protected boolean writeAttributeColumnIndices(Element element) {
        if (!this.writeAttributeColumnIndicesSub(element, "XValueIndices", this.mXIndices)) {
            return false;
        }
        if (!this.writeAttributeColumnIndicesSub(element, "YValueIndices", this.mYIndices)) {
            return false;
        }
        if (this.mLowerErrorIndices != null && this.mUpperErrorIndices != null && this.mErrorBarHolderIndices != null) {
            if (!this.writeAttributeColumnIndicesSub(element, "LowerErrorBarIndices", this.mLowerErrorIndices)) {
                return false;
            }
            if (!this.writeAttributeColumnIndicesSub(element, "UpperErrorBarIndices", this.mUpperErrorIndices)) {
                return false;
            }
            if (!this.writeAttributeColumnIndicesSub(element, "ErrorBarHolderIndices", this.mErrorBarHolderIndices)) {
                return false;
            }
        }
        if (this.mTickLabelIndices != null && this.mTickLabelHolderIndices != null) {
            SGDataColumn[] sGDataColumnArray = this.mDataFile.getDataColumns();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (int i = 0; i < this.mTickLabelIndices.length; ++i) {
                if (sGDataColumnArray[this.mTickLabelIndices[i]] instanceof SGDateDataColumn) continue;
                arrayList.add(this.mTickLabelIndices[i]);
                arrayList2.add(this.mTickLabelHolderIndices[i]);
            }
            if (arrayList.size() != 0) {
                Integer[] integerArray = new Integer[arrayList.size()];
                arrayList.toArray(integerArray);
                Integer[] integerArray2 = new Integer[arrayList2.size()];
                arrayList2.toArray(integerArray2);
                if (!this.writeAttributeColumnIndicesSub(element, "TickLabelIndices", integerArray)) {
                    return false;
                }
                if (!this.writeAttributeColumnIndicesSub(element, "TickLabelHolderIndices", integerArray2)) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean writeAttributeColumnIndicesSub(Element element, String string, Integer[] integerArray) {
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        return this.writeAttributeColumnIndicesSub(element, string, nArray);
    }

    private boolean writeAttributeColumnIndicesSub(Element element, String string, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            if (i == nArray.length - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append('}');
        element.setAttribute(string, stringBuffer.toString());
        return true;
    }

    @Override
    protected boolean writeSequentialColumnIndices(Element element) {
        int[] nArray;
        int[] nArray2;
        int n;
        int[] nArray3;
        int[] nArray4;
        if (this.hasMultipleYValues()) {
            nArray4 = new int[]{0};
            nArray3 = new int[this.mYIndices.length];
            for (n = 0; n < nArray3.length; ++n) {
                nArray3[n] = n + 1;
            }
            nArray2 = nArray3;
        } else {
            nArray4 = new int[this.mXIndices.length];
            for (n = 0; n < nArray4.length; ++n) {
                nArray4[n] = n;
            }
            nArray3 = new int[]{nArray4.length};
            nArray2 = nArray4;
        }
        if (!this.writeAttributeColumnIndicesSub(element, "XValueIndices", nArray4)) {
            return false;
        }
        if (!this.writeAttributeColumnIndicesSub(element, "YValueIndices", nArray3)) {
            return false;
        }
        n = nArray4.length + nArray3.length;
        if (this.isErrorBarAvailable()) {
            nArray = new int[this.mLowerErrorIndices.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i + n;
            }
            if (!this.writeAttributeColumnIndicesSub(element, "LowerErrorBarIndices", nArray)) {
                return false;
            }
            n += nArray.length;
            int[] nArray5 = new int[this.mUpperErrorIndices.length];
            for (int i = 0; i < nArray5.length; ++i) {
                nArray5[i] = i + n;
            }
            if (!this.writeAttributeColumnIndicesSub(element, "UpperErrorBarIndices", nArray5)) {
                return false;
            }
            n += nArray5.length;
            int[] nArray6 = new int[this.mErrorBarHolderIndices.length];
            for (int i = 0; i < nArray6.length; ++i) {
                nArray6[i] = nArray2[i];
            }
            if (!this.writeAttributeColumnIndicesSub(element, "ErrorBarHolderIndices", nArray6)) {
                return false;
            }
        }
        if (this.isTickLabelAvailable() && !this.isTickLabelFromDataColumn()) {
            nArray = new int[this.mTickLabelIndices.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i + n;
            }
            if (!this.writeAttributeColumnIndicesSub(element, "TickLabelIndices", nArray)) {
                return false;
            }
            int[] nArray7 = new int[this.mTickLabelHolderIndices.length];
            for (int i = 0; i < nArray7.length; ++i) {
                nArray7[i] = nArray2[i];
            }
            if (!this.writeAttributeColumnIndicesSub(element, "TickLabelHolderIndices", nArray7)) {
                return false;
            }
        }
        return true;
    }

    private boolean writeAttributeColumnNameSub(Element element, String string, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(this.getSequentialColumnName(nArray[i]));
            if (i == nArray.length - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append('}');
        element.setAttribute(string, stringBuffer.toString());
        return true;
    }

    @Override
    protected boolean writeSequentialColumnName(Element element) {
        int[] nArray;
        int[] nArray2;
        int n;
        int[] nArray3;
        int[] nArray4;
        if (this.hasMultipleYValues()) {
            nArray4 = new int[]{0};
            nArray3 = new int[this.mYIndices.length];
            for (n = 0; n < nArray3.length; ++n) {
                nArray3[n] = n + 1;
            }
            nArray2 = nArray3;
        } else {
            nArray4 = new int[this.mXIndices.length];
            for (n = 0; n < nArray4.length; ++n) {
                nArray4[n] = n;
            }
            nArray3 = new int[]{nArray4.length};
            nArray2 = nArray4;
        }
        if (!this.writeAttributeColumnNameSub(element, "XValueIndices", nArray4)) {
            return false;
        }
        if (!this.writeAttributeColumnNameSub(element, "YValueIndices", nArray3)) {
            return false;
        }
        n = nArray4.length + nArray3.length;
        if (this.isErrorBarAvailable()) {
            nArray = new int[this.mLowerErrorIndices.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i + n;
            }
            if (!this.writeAttributeColumnNameSub(element, "LowerErrorBarIndices", nArray)) {
                return false;
            }
            n += nArray.length;
            int[] nArray5 = new int[this.mUpperErrorIndices.length];
            for (int i = 0; i < nArray5.length; ++i) {
                nArray5[i] = i + n;
            }
            if (!this.writeAttributeColumnNameSub(element, "UpperErrorBarIndices", nArray5)) {
                return false;
            }
            n += nArray5.length;
            int[] nArray6 = new int[this.mErrorBarHolderIndices.length];
            for (int i = 0; i < nArray6.length; ++i) {
                nArray6[i] = nArray2[i];
            }
            if (!this.writeAttributeColumnNameSub(element, "ErrorBarHolderIndices", nArray6)) {
                return false;
            }
        }
        if (this.isTickLabelAvailable() && !this.isTickLabelFromDataColumn()) {
            nArray = new int[this.mTickLabelIndices.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i + n;
            }
            if (!this.writeAttributeColumnNameSub(element, "TickLabelIndices", nArray)) {
                return false;
            }
            int[] nArray7 = new int[this.mTickLabelHolderIndices.length];
            for (int i = 0; i < nArray7.length; ++i) {
                nArray7[i] = nArray2[i];
            }
            if (!this.writeAttributeColumnNameSub(element, "TickLabelHolderIndices", nArray7)) {
                return false;
            }
        }
        element.setAttribute("SerialNumberVariableName", "SerialNumbers");
        return true;
    }

    public boolean writeSamplingRateToProperty(Element element) {
        SGDataColumn[] sGDataColumnArray = this.getDataSetColumnsClone();
        for (int i = 0; i < sGDataColumnArray.length; ++i) {
            if (!"Sampling Rate".equals(sGDataColumnArray[i].getValueType())) continue;
            SGSamplingDataColumn sGSamplingDataColumn = (SGSamplingDataColumn)sGDataColumnArray[i];
            element.setAttribute("SamplingRate", Double.toString(sGSamplingDataColumn.getSamplingRate()));
            break;
        }
        return true;
    }

    @Override
    public boolean readProperty(Element element) {
        Integer[] integerArray;
        int n;
        int n2;
        Integer[] integerArray2 = null;
        Integer[] integerArray3 = null;
        Integer[] integerArray4 = null;
        integerArray2 = this.readIndices(element, "XValueIndices");
        if (integerArray2 != null) {
            if (integerArray2.length != 0) {
                integerArray3 = new Integer[integerArray2.length];
                for (n2 = 0; n2 < integerArray2.length; ++n2) {
                    if (!this.checkColumnIndexRange(integerArray2[n2])) {
                        return false;
                    }
                    integerArray3[n2] = integerArray2[n2];
                }
            }
        } else {
            return false;
        }
        integerArray2 = this.readIndices(element, "YValueIndices");
        if (integerArray2 != null) {
            if (integerArray2.length != 0) {
                integerArray4 = new Integer[integerArray2.length];
                for (n2 = 0; n2 < integerArray2.length; ++n2) {
                    if (!this.checkColumnIndexRange(integerArray2[n2])) {
                        return false;
                    }
                    integerArray4[n2] = integerArray2[n2];
                }
            }
        } else {
            return false;
        }
        if (!this.isValidXYValueIndices(integerArray3, integerArray4)) {
            return false;
        }
        Integer[] integerArray5 = null;
        Integer[] integerArray6 = null;
        Integer[] integerArray7 = null;
        Integer[] integerArray8 = null;
        Integer[] integerArray9 = null;
        integerArray2 = this.readIndices(element, "LowerErrorBarIndices");
        if (integerArray2 != null && integerArray2.length != 0) {
            integerArray5 = new Integer[integerArray2.length];
            for (n = 0; n < integerArray2.length; ++n) {
                if (!this.checkColumnIndexRange(integerArray2[n])) {
                    return false;
                }
                integerArray5[n] = integerArray2[n];
            }
        }
        if ((integerArray2 = this.readIndices(element, "UpperErrorBarIndices")) != null && integerArray2.length != 0) {
            integerArray6 = new Integer[integerArray2.length];
            for (n = 0; n < integerArray2.length; ++n) {
                if (!this.checkColumnIndexRange(integerArray2[n])) {
                    return false;
                }
                integerArray6[n] = integerArray2[n];
            }
        }
        if ((integerArray2 = this.readIndices(element, "ErrorBarHolderIndices")) != null && integerArray2.length != 0) {
            integerArray7 = new Integer[integerArray2.length];
            for (n = 0; n < integerArray2.length; ++n) {
                if (!this.checkColumnIndexRange(integerArray2[n])) {
                    return false;
                }
                integerArray7[n] = integerArray2[n];
            }
        }
        if ((integerArray2 = this.readIndices(element, "TickLabelIndices")) != null && integerArray2.length != 0) {
            integerArray8 = new Integer[integerArray2.length];
            for (n = 0; n < integerArray2.length; ++n) {
                if (!this.checkColumnIndexRange(integerArray2[n])) {
                    return false;
                }
                integerArray8[n] = integerArray2[n];
            }
        }
        if ((integerArray2 = this.readIndices(element, "TickLabelHolderIndices")) != null && integerArray2.length != 0) {
            integerArray9 = new Integer[integerArray2.length];
            for (n = 0; n < integerArray2.length; ++n) {
                if (!this.checkColumnIndexRange(integerArray2[n])) {
                    return false;
                }
                integerArray9[n] = integerArray2[n];
            }
        }
        Integer[] integerArray10 = integerArray = integerArray3.length == 1 ? integerArray4 : integerArray3;
        if (!this.isValidErrorBarIndices(integerArray, integerArray5, integerArray6, integerArray7)) {
            return false;
        }
        if (!this.isValidTickLabelIndices(integerArray, integerArray8, integerArray9)) {
            return false;
        }
        this.mXIndices = integerArray3;
        this.mYIndices = integerArray4;
        this.mLowerErrorIndices = integerArray5;
        this.mUpperErrorIndices = integerArray6;
        this.mErrorBarHolderIndices = integerArray7;
        this.mTickLabelIndices = integerArray8;
        this.mTickLabelHolderIndices = integerArray9;
        return true;
    }

    @Override
    public String getTitleX() {
        if (this.hasMultipleYValues() || this.hasPairOfXYValues()) {
            SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
            return sGDataColumnArray[this.mXIndices[0]].getTitle();
        }
        return "";
    }

    @Override
    public String getTitleY() {
        if (!this.hasMultipleYValues() || this.hasPairOfXYValues()) {
            SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
            return sGDataColumnArray[this.mYIndices[0]].getTitle();
        }
        return "";
    }

    public Integer[] getXIndices() {
        if (this.mXIndices == null) {
            return null;
        }
        return (Integer[])this.mXIndices.clone();
    }

    public void setXIndices(Integer[] integerArray) {
        if (integerArray == null) {
            this.mXIndices = null;
        } else {
            if (!this.isValidIndices(integerArray)) {
                throw new IllegalArgumentException("Column indices for x values are invalid.");
            }
            this.mXIndices = (Integer[])integerArray.clone();
        }
    }

    public Integer[] getYIndices() {
        if (this.mYIndices == null) {
            return null;
        }
        return (Integer[])this.mYIndices.clone();
    }

    public void setYIndices(Integer[] integerArray) {
        if (integerArray == null) {
            this.mYIndices = null;
        } else {
            if (!this.isValidIndices(integerArray)) {
                throw new IllegalArgumentException("Column indices for y values are invalid.");
            }
            this.mYIndices = (Integer[])integerArray.clone();
        }
    }

    public Integer[] getLowerErrorIndices() {
        if (this.mLowerErrorIndices == null) {
            return null;
        }
        return (Integer[])this.mLowerErrorIndices.clone();
    }

    public void setLowerErrorIndices(Integer[] integerArray) {
        if (integerArray == null) {
            this.mLowerErrorIndices = null;
        } else {
            for (int i = 0; i < integerArray.length; ++i) {
                Integer n = integerArray[i];
                if (this.checkColumnIndexRange(n)) continue;
                throw new IllegalArgumentException("Index out of bounds: " + n);
            }
            this.mLowerErrorIndices = (Integer[])integerArray.clone();
        }
    }

    public Integer[] getUpperErrorIndices() {
        if (this.mUpperErrorIndices == null) {
            return null;
        }
        return (Integer[])this.mUpperErrorIndices.clone();
    }

    public void setUpperErrorIndices(Integer[] integerArray) {
        if (integerArray == null) {
            this.mUpperErrorIndices = null;
        } else {
            for (int i = 0; i < integerArray.length; ++i) {
                Integer n = integerArray[i];
                if (this.checkColumnIndexRange(n)) continue;
                throw new IllegalArgumentException("Index out of bounds: " + n);
            }
            this.mUpperErrorIndices = (Integer[])integerArray.clone();
        }
    }

    public Integer[] getErrorBarHolderIndices() {
        if (this.mErrorBarHolderIndices == null) {
            return null;
        }
        return (Integer[])this.mErrorBarHolderIndices.clone();
    }

    public void setErrorBarHolderIndices(Integer[] integerArray) {
        if (integerArray == null) {
            this.mErrorBarHolderIndices = null;
        } else {
            for (int i = 0; i < integerArray.length; ++i) {
                Integer n = integerArray[i];
                if (this.checkColumnIndexRange(n)) continue;
                throw new IllegalArgumentException("Index out of bounds: " + n);
            }
            this.mErrorBarHolderIndices = (Integer[])integerArray.clone();
        }
    }

    public Integer[] getTickLabelIndices() {
        if (this.mTickLabelIndices == null) {
            return null;
        }
        return (Integer[])this.mTickLabelIndices.clone();
    }

    public void setTickLabelIndices(Integer[] integerArray) {
        if (integerArray == null) {
            this.mTickLabelIndices = null;
        } else {
            for (int i = 0; i < integerArray.length; ++i) {
                Integer n = integerArray[i];
                if (this.checkColumnIndexRange(n)) continue;
                throw new IllegalArgumentException("Index out of bounds: " + n);
            }
            this.mTickLabelIndices = (Integer[])integerArray.clone();
        }
    }

    public Integer[] getTickLabelHolderIndices() {
        if (this.mTickLabelHolderIndices == null) {
            return null;
        }
        return (Integer[])this.mTickLabelHolderIndices.clone();
    }

    public void setTickLabelHolderIndices(Integer[] integerArray) {
        if (integerArray == null) {
            this.mTickLabelHolderIndices = null;
        } else {
            for (int i = 0; i < integerArray.length; ++i) {
                Integer n = integerArray[i];
                if (this.checkColumnIndexRange(n)) continue;
                throw new IllegalArgumentException("Index out of bounds: " + n);
            }
            this.mTickLabelHolderIndices = (Integer[])integerArray.clone();
        }
    }

    @Override
    public SGProperties getProperties() {
        SXYMultipleDataProperties sXYMultipleDataProperties = new SXYMultipleDataProperties();
        if (!this.getProperties(sXYMultipleDataProperties)) {
            return null;
        }
        return sXYMultipleDataProperties;
    }

    @Override
    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SXYMultipleDataProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        SXYMultipleDataProperties sXYMultipleDataProperties = (SXYMultipleDataProperties)sGProperties;
        sXYMultipleDataProperties.mXIndices = this.getXIndices();
        sXYMultipleDataProperties.mYIndices = this.getYIndices();
        sXYMultipleDataProperties.mLowerErrorIndices = this.getLowerErrorIndices();
        sXYMultipleDataProperties.mUpperErrorIndices = this.getUpperErrorIndices();
        sXYMultipleDataProperties.mErrorBarHolderIndices = this.getErrorBarHolderIndices();
        sXYMultipleDataProperties.mTickLabelIndices = this.getTickLabelIndices();
        sXYMultipleDataProperties.mTickLabelHolderIndices = this.getTickLabelHolderIndices();
        return true;
    }

    @Override
    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SXYMultipleDataProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        SXYMultipleDataProperties sXYMultipleDataProperties = (SXYMultipleDataProperties)sGProperties;
        this.setXIndices(sXYMultipleDataProperties.mXIndices);
        this.setYIndices(sXYMultipleDataProperties.mYIndices);
        this.setLowerErrorIndices(sXYMultipleDataProperties.mLowerErrorIndices);
        this.setUpperErrorIndices(sXYMultipleDataProperties.mUpperErrorIndices);
        this.setErrorBarHolderIndices(sXYMultipleDataProperties.mErrorBarHolderIndices);
        this.setTickLabelIndices(sXYMultipleDataProperties.mTickLabelIndices);
        this.setTickLabelHolderIndices(sXYMultipleDataProperties.mTickLabelHolderIndices);
        return true;
    }

    @Override
    public boolean setColumnType(String[] stringArray) {
        Object object;
        Integer[] integerArray;
        if (stringArray == null) {
            throw new IllegalArgumentException("columns == null");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (SGUtilityText.isEqualString("X", stringArray[i])) {
                arrayList.add(i);
                continue;
            }
            if (SGUtilityText.isEqualString("Y", stringArray[i])) {
                arrayList2.add(i);
                continue;
            }
            if (SGUtilityText.startsWith(stringArray[i], "Lower Error")) {
                arrayList3.add(i);
                continue;
            }
            if (SGUtilityText.startsWith(stringArray[i], "Upper Error")) {
                arrayList4.add(i);
                continue;
            }
            if (SGUtilityText.startsWith(stringArray[i], "Lower / Upper Error")) {
                arrayList3.add(i);
                arrayList4.add(i);
                continue;
            }
            if (SGUtilityText.startsWith(stringArray[i], "Tick Label")) {
                arrayList5.add(i);
                continue;
            }
            if ("".equals(stringArray[i])) continue;
            return false;
        }
        if (arrayList.size() == 0 || arrayList2.size() == 0) {
            return false;
        }
        if (arrayList.size() != 1 && arrayList2.size() != 1) {
            return false;
        }
        if (arrayList3.size() != arrayList4.size()) {
            return false;
        }
        String[] stringArray2 = this.mDataFile.getTitles();
        Integer[] integerArray2 = arrayList.toArray(new Integer[arrayList.size()]);
        Integer[] integerArray3 = arrayList2.toArray(new Integer[arrayList2.size()]);
        Integer[] integerArray4 = null;
        if (arrayList3.size() != 0) {
            integerArray4 = arrayList3.toArray(new Integer[arrayList3.size()]);
        }
        Integer[] integerArray5 = null;
        if (arrayList4.size() != 0) {
            integerArray5 = arrayList4.toArray(new Integer[arrayList4.size()]);
        }
        Integer[] integerArray6 = null;
        if (arrayList3.size() != 0) {
            String string;
            int n;
            integerArray6 = new Integer[arrayList3.size()];
            integerArray = new ArrayList();
            for (n = 0; n < integerArray6.length; ++n) {
                string = stringArray[integerArray5[n]];
                object = SGDataUtility.getAppendedColumnIndex(string, stringArray2);
                if (object == null) {
                    return false;
                }
                integerArray.add(object);
            }
            for (n = 0; n < integerArray6.length; ++n) {
                string = stringArray[integerArray4[n]];
                object = SGDataUtility.getAppendedColumnIndex(string, stringArray2);
                if (object == null) {
                    return false;
                }
                if (!integerArray.contains(object)) {
                    return false;
                }
                integerArray6[n] = object;
            }
        }
        integerArray = null;
        if (arrayList5.size() != 0) {
            integerArray = arrayList5.toArray(new Integer[arrayList5.size()]);
        }
        Integer[] integerArray7 = null;
        if (arrayList5.size() != 0) {
            integerArray7 = new Integer[arrayList5.size()];
            for (int i = 0; i < integerArray7.length; ++i) {
                object = stringArray[integerArray[i]];
                Integer n = SGDataUtility.getAppendedColumnIndex((String)object, stringArray2);
                if (n == null) {
                    return false;
                }
                integerArray7[i] = n;
            }
        }
        this.mXIndices = integerArray2;
        this.mYIndices = integerArray3;
        this.mLowerErrorIndices = integerArray4;
        this.mUpperErrorIndices = integerArray5;
        this.mErrorBarHolderIndices = integerArray6;
        this.mTickLabelIndices = integerArray;
        this.mTickLabelHolderIndices = integerArray7;
        if (integerArray == null) {
            this.updateDateTickLabelColumns();
        }
        return true;
    }

    @Override
    public String[] getCurrentColumnType() {
        int n;
        int n2;
        int n3 = this.getColNum();
        String[] stringArray = new String[n3];
        for (n2 = 0; n2 < this.mXIndices.length; ++n2) {
            stringArray[this.mXIndices[n2].intValue()] = "X";
        }
        for (n2 = 0; n2 < this.mYIndices.length; ++n2) {
            stringArray[this.mYIndices[n2].intValue()] = "Y";
        }
        if (this.isErrorBarAvailable()) {
            for (n2 = 0; n2 < this.mLowerErrorIndices.length; ++n2) {
                n = this.mErrorBarHolderIndices[n2];
                if (this.mLowerErrorIndices[n2].equals(this.mUpperErrorIndices[n2])) {
                    stringArray[this.mLowerErrorIndices[n2].intValue()] = SGDataUtility.appendColumnNoOrTitle("Lower / Upper Error", n, this.mDataFile.isEmptyTitle(n) || this.mDataFile.isRepeatedTitle(n), this.getTitle(n));
                    continue;
                }
                stringArray[this.mLowerErrorIndices[n2].intValue()] = SGDataUtility.appendColumnNoOrTitle("Lower Error", n, this.mDataFile.isEmptyTitle(n) || this.mDataFile.isRepeatedTitle(n), this.getTitle(n));
                stringArray[this.mUpperErrorIndices[n2].intValue()] = SGDataUtility.appendColumnNoOrTitle("Upper Error", n, this.mDataFile.isEmptyTitle(n) || this.mDataFile.isRepeatedTitle(n), this.getTitle(n));
            }
        }
        if (this.isTickLabelAvailable() && !this.isTickLabelFromDataColumn()) {
            for (n2 = 0; n2 < this.mTickLabelIndices.length; ++n2) {
                n = this.mTickLabelHolderIndices[n2];
                stringArray[this.mTickLabelIndices[n2].intValue()] = SGDataUtility.appendColumnNoOrTitle("Tick Label", n, this.mDataFile.isEmptyTitle(n) || this.mDataFile.isRepeatedTitle(n), this.getTitle(n));
            }
        }
        return stringArray;
    }

    private boolean isTickLabelFromDataColumn() {
        if (this.isTickLabelAvailable()) {
            SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
            for (int i = 0; i < this.mTickLabelIndices.length; ++i) {
                SGDataColumn sGDataColumn = sGDataColumnArray[this.mTickLabelIndices[i]];
                if (!(sGDataColumn instanceof SGDateDataColumn)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getSXYDataNumMax() {
        int n = this.getColNum(SGNumberDataColumn.class) - 1;
        int n2 = this.getColNum(SGSamplingDataColumn.class);
        if (n2 != 0) {
            ++n;
        }
        return n;
    }

    public boolean isDateColumnUsed() {
        if (this.getDateColumnIndex(this.mXIndices) != -1) {
            return true;
        }
        return this.getDateColumnIndex(this.mYIndices) != -1;
    }

    private int getDateColumnIndex(Integer[] integerArray) {
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        for (int i = 0; i < integerArray.length; ++i) {
            SGDataColumn sGDataColumn = sGDataColumnArray[integerArray[i]];
            if (!(sGDataColumn instanceof SGDateDataColumn)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected SGDataColumn[] getDataSetColumns() {
        int n;
        boolean bl = this.isErrorBarAvailable();
        boolean bl2 = this.isTickLabelAvailable() && !this.isTickLabelFromDataColumn();
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        int n2 = this.mXIndices.length + this.mYIndices.length;
        if (bl) {
            n2 += this.mLowerErrorIndices.length + this.mUpperErrorIndices.length;
        }
        if (bl2) {
            n2 += this.mTickLabelIndices.length;
        }
        int n3 = 0;
        SGDataColumn[] sGDataColumnArray2 = new SGDataColumn[n2];
        for (n = 0; n < this.mXIndices.length; ++n) {
            sGDataColumnArray2[n] = sGDataColumnArray[this.mXIndices[n]];
        }
        n3 += this.mXIndices.length;
        for (n = 0; n < this.mYIndices.length; ++n) {
            sGDataColumnArray2[n + n3] = sGDataColumnArray[this.mYIndices[n]];
        }
        n3 += this.mYIndices.length;
        if (bl) {
            for (n = 0; n < this.mLowerErrorIndices.length; ++n) {
                sGDataColumnArray2[n + n3] = sGDataColumnArray[this.mLowerErrorIndices[n]];
            }
            n3 += this.mLowerErrorIndices.length;
            for (n = 0; n < this.mUpperErrorIndices.length; ++n) {
                sGDataColumnArray2[n + n3] = sGDataColumnArray[this.mUpperErrorIndices[n]];
            }
            n3 += this.mUpperErrorIndices.length;
        }
        if (bl2) {
            for (n = 0; n < this.mTickLabelIndices.length; ++n) {
                sGDataColumnArray2[n + n3] = sGDataColumnArray[this.mTickLabelIndices[n]];
            }
        }
        return sGDataColumnArray2;
    }

    @Override
    public SGDataColumn[] getUsedDataColumnsClone() {
        SGDataColumn sGDataColumn;
        int n;
        int n2;
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        String[] stringArray = this.getCurrentColumnType();
        ArrayList<SGDataColumn> arrayList = new ArrayList<SGDataColumn>();
        for (n2 = 0; n2 < this.mXIndices.length; ++n2) {
            n = this.mXIndices[n2];
            sGDataColumn = (SGDataColumn)sGDataColumnArray[n].clone();
            sGDataColumn.setColumnType(stringArray[n]);
            arrayList.add(sGDataColumn);
        }
        for (n2 = 0; n2 < this.mYIndices.length; ++n2) {
            n = this.mYIndices[n2];
            sGDataColumn = (SGDataColumn)sGDataColumnArray[n].clone();
            sGDataColumn.setColumnType(stringArray[n]);
            arrayList.add(sGDataColumn);
        }
        if (this.isErrorBarAvailable()) {
            for (n2 = 0; n2 < this.mLowerErrorIndices.length; ++n2) {
                SGDataColumn sGDataColumn2;
                int n3;
                n = this.mLowerErrorIndices[n2];
                if (n == (n3 = this.mUpperErrorIndices[n2].intValue())) {
                    sGDataColumn2 = (SGDataColumn)sGDataColumnArray[n].clone();
                    sGDataColumn2.setColumnType(stringArray[n]);
                    arrayList.add(sGDataColumn2);
                    continue;
                }
                sGDataColumn2 = (SGDataColumn)sGDataColumnArray[n].clone();
                sGDataColumn2.setColumnType(stringArray[n]);
                arrayList.add(sGDataColumn2);
                sGDataColumn2 = (SGDataColumn)sGDataColumnArray[n3].clone();
                sGDataColumn2.setColumnType(stringArray[n3]);
                arrayList.add(sGDataColumn2);
            }
        }
        if (this.isTickLabelAvailable()) {
            for (n2 = 0; n2 < this.mTickLabelIndices.length; ++n2) {
                n = this.mTickLabelIndices[n2];
                SGDataColumn sGDataColumn3 = (SGDataColumn)sGDataColumnArray[n].clone();
                sGDataColumn3.setColumnType(stringArray[n]);
                arrayList.add(sGDataColumn3);
            }
        }
        return arrayList.toArray(new SGDataColumn[arrayList.size()]);
    }

    @Override
    public boolean isErrorBarAvailable() {
        return this.mLowerErrorIndices != null && this.mUpperErrorIndices != null;
    }

    @Override
    public boolean isTickLabelAvailable() {
        return this.mTickLabelIndices != null;
    }

    @Override
    public int getDecimalPlaces() {
        return this.mDecimalPlaces;
    }

    @Override
    public int getExponent() {
        return this.mExponent;
    }

    @Override
    public void setDecimalPlaces(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Decimal places must not be negative: " + n);
        }
        this.mDecimalPlaces = n;
    }

    @Override
    public void setExponent(int n) {
        this.mExponent = n;
    }

    @Override
    public Boolean isErrorBarVertical() {
        if (this.isErrorBarAvailable()) {
            if (SGUtility.contains((Object[])this.mYIndices, this.mErrorBarHolderIndices[0])) {
                return Boolean.TRUE;
            }
            if (SGUtility.contains((Object[])this.mXIndices, this.mErrorBarHolderIndices[0])) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public Boolean isTickLabelHorizontal() {
        if (this.isTickLabelAvailable()) {
            if (SGUtility.contains((Object[])this.mYIndices, this.mTickLabelHolderIndices[0])) {
                return Boolean.TRUE;
            }
            if (SGUtility.contains((Object[])this.mXIndices, this.mTickLabelHolderIndices[0])) {
                return Boolean.FALSE;
            }
        } else {
            if (this.getDateColumnIndex(this.mXIndices) != -1) {
                return Boolean.TRUE;
            }
            if (this.getDateColumnIndex(this.mYIndices) != -1) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public SGDataColumn[] getXColumns() {
        return this.getColumns(this.mXIndices);
    }

    public SGDataColumn[] getYColumns() {
        return this.getColumns(this.mYIndices);
    }

    public SGDataColumn[] getLowerErrorColumns() {
        return this.getColumns(this.mLowerErrorIndices);
    }

    public SGDataColumn[] getUpperErrorColumns() {
        return this.getColumns(this.mUpperErrorIndices);
    }

    public SGDataColumn[] getErrorBarHolderColumns() {
        return this.getColumns(this.mErrorBarHolderIndices);
    }

    public SGDataColumn[] getTickLableColumns() {
        return this.getColumns(this.mTickLabelIndices);
    }

    public SGDataColumn[] getTickLabelHolderColumns() {
        return this.getColumns(this.mTickLabelHolderIndices);
    }

    public SGDataColumn[] getMultipleColumns() {
        if (this.hasMultipleYValues()) {
            return this.getYColumns();
        }
        return this.getXColumns();
    }

    @Override
    public Map<String, Object> getInfoMap() {
        Map<String, Object> map = super.getInfoMap();
        map.put("Multiple", Boolean.TRUE);
        return map;
    }

    @Override
    public boolean isSplitEnabled() {
        int n;
        boolean bl = this.hasMultipleYValues();
        int n2 = n = bl ? this.getYNumber() : this.getXNumber();
        return n > 1;
    }

    public static SGISXYTypeMultipleData merge(List<SGData> list) {
        Object object;
        Integer[] integerArray;
        Integer[] integerArray2;
        Integer[] integerArray3;
        Integer[] integerArray4;
        Integer[] integerArray5;
        Cloneable cloneable22;
        if (list.size() == 0) {
            return null;
        }
        for (Cloneable cloneable22 : list) {
            if (cloneable22 instanceof SGSXYMultipleData) continue;
            return null;
        }
        SGSXYMultipleData sGSXYMultipleData = (SGSXYMultipleData)list.get(0);
        cloneable22 = sGSXYMultipleData.getDataFile();
        SGDataSourceObserver sGDataSourceObserver = sGSXYMultipleData.mObserver;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
        TreeSet<Integer> treeSet3 = new TreeSet<Integer>();
        TreeSet<Integer> treeSet4 = new TreeSet<Integer>();
        TreeSet<Integer> treeSet5 = new TreeSet<Integer>();
        TreeSet<Integer> treeSet6 = new TreeSet<Integer>();
        TreeSet<Integer> treeSet7 = new TreeSet<Integer>();
        for (SGData integerArray62 : list) {
            int n;
            integerArray5 = (Integer[])integerArray62;
            integerArray4 = integerArray5.getXIndices();
            integerArray3 = integerArray5.getYIndices();
            integerArray2 = integerArray5.getLowerErrorIndices();
            integerArray = integerArray5.getUpperErrorIndices();
            object = integerArray5.getErrorBarHolderIndices();
            Integer[] integerArray6 = integerArray5.getTickLabelIndices();
            Integer[] integerArray7 = integerArray5.getTickLabelHolderIndices();
            if (null != integerArray4) {
                for (n = 0; n < integerArray4.length; ++n) {
                    treeSet.add(integerArray4[n]);
                }
            }
            if (null != integerArray3) {
                for (n = 0; n < integerArray3.length; ++n) {
                    treeSet2.add(integerArray3[n]);
                }
            }
            if (null != integerArray2) {
                for (n = 0; n < integerArray2.length; ++n) {
                    treeSet3.add(integerArray2[n]);
                }
            }
            if (null != integerArray) {
                for (n = 0; n < integerArray.length; ++n) {
                    treeSet4.add(integerArray[n]);
                }
            }
            if (null != object) {
                for (n = 0; n < ((Integer[])object).length; ++n) {
                    treeSet5.add(object[n]);
                }
            }
            if (null != integerArray6) {
                for (n = 0; n < integerArray6.length; ++n) {
                    treeSet6.add(integerArray6[n]);
                }
            }
            if (null == integerArray7) continue;
            for (n = 0; n < integerArray7.length; ++n) {
                treeSet7.add(integerArray7[n]);
            }
        }
        Integer[] integerArray9 = new Integer[treeSet.size()];
        Integer[] integerArray8 = new Integer[treeSet2.size()];
        integerArray5 = new Integer[treeSet3.size()];
        integerArray4 = new Integer[treeSet4.size()];
        integerArray3 = new Integer[treeSet5.size()];
        integerArray2 = new Integer[treeSet6.size()];
        integerArray = new Integer[treeSet7.size()];
        treeSet.toArray(integerArray9);
        treeSet2.toArray(integerArray8);
        treeSet3.toArray(integerArray5);
        treeSet4.toArray(integerArray4);
        treeSet5.toArray(integerArray3);
        treeSet6.toArray(integerArray2);
        treeSet7.toArray(integerArray);
        object = new SGSXYMultipleData((SGTextDataFile)cloneable22, sGDataSourceObserver, integerArray9, integerArray8, integerArray5, integerArray4, integerArray3, integerArray2, integerArray);
        ((SGSXYMultipleData)object).setDecimalPlaces(sGSXYMultipleData.getDecimalPlaces());
        ((SGSXYMultipleData)object).setExponent(sGSXYMultipleData.getExponent());
        return object;
    }

    public static class SXYMultipleDataProperties
    extends SGArrayData.ArrayDataProperties {
        Integer[] mXIndices = null;
        Integer[] mYIndices = null;
        Integer[] mLowerErrorIndices = null;
        Integer[] mUpperErrorIndices = null;
        Integer[] mErrorBarHolderIndices = null;
        Integer[] mTickLabelIndices = null;
        Integer[] mTickLabelHolderIndices = null;

        public boolean equals(Object object) {
            if (!(object instanceof SXYMultipleDataProperties)) {
                return false;
            }
            SXYMultipleDataProperties sXYMultipleDataProperties = (SXYMultipleDataProperties)object;
            if (!SGUtility.equals(this.mXIndices, sXYMultipleDataProperties.mXIndices)) {
                return false;
            }
            if (!SGUtility.equals(this.mYIndices, sXYMultipleDataProperties.mYIndices)) {
                return false;
            }
            if (!SGUtility.equals(this.mLowerErrorIndices, sXYMultipleDataProperties.mLowerErrorIndices)) {
                return false;
            }
            if (!SGUtility.equals(this.mUpperErrorIndices, sXYMultipleDataProperties.mUpperErrorIndices)) {
                return false;
            }
            if (!SGUtility.equals(this.mErrorBarHolderIndices, sXYMultipleDataProperties.mErrorBarHolderIndices)) {
                return false;
            }
            if (!SGUtility.equals(this.mTickLabelIndices, sXYMultipleDataProperties.mTickLabelIndices)) {
                return false;
            }
            return SGUtility.equals(this.mTickLabelHolderIndices, sXYMultipleDataProperties.mTickLabelHolderIndices);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            stringBuffer.append("XIndices={");
            this.printIndices(stringBuffer, this.mXIndices);
            stringBuffer.append("}, YIndices={");
            this.printIndices(stringBuffer, this.mYIndices);
            stringBuffer.append("}, LowerErrorIndices={");
            this.printIndices(stringBuffer, this.mLowerErrorIndices);
            stringBuffer.append("}, UpperErrorIndices={");
            this.printIndices(stringBuffer, this.mUpperErrorIndices);
            stringBuffer.append("}, ErrorBarHolderIndices={");
            this.printIndices(stringBuffer, this.mErrorBarHolderIndices);
            stringBuffer.append("}, TickLabelIndices={");
            this.printIndices(stringBuffer, this.mTickLabelIndices);
            stringBuffer.append("}, TickLabelHolderIndices={");
            this.printIndices(stringBuffer, this.mTickLabelHolderIndices);
            stringBuffer.append("}]");
            return stringBuffer.toString();
        }

        private void printIndices(StringBuffer stringBuffer, Integer[] integerArray) {
            if (integerArray != null) {
                for (int i = 0; i < integerArray.length; ++i) {
                    stringBuffer.append(integerArray[i]);
                    if (i == integerArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
            }
        }

        public Object copy() {
            Object object = super.copy();
            SXYMultipleDataProperties sXYMultipleDataProperties = (SXYMultipleDataProperties)object;
            if (this.mXIndices != null) {
                sXYMultipleDataProperties.mXIndices = (Integer[])this.mXIndices.clone();
            }
            if (this.mYIndices != null) {
                sXYMultipleDataProperties.mYIndices = (Integer[])this.mYIndices.clone();
            }
            if (this.mLowerErrorIndices != null) {
                sXYMultipleDataProperties.mLowerErrorIndices = (Integer[])this.mLowerErrorIndices.clone();
            }
            if (this.mUpperErrorIndices != null) {
                sXYMultipleDataProperties.mUpperErrorIndices = (Integer[])this.mUpperErrorIndices.clone();
            }
            if (this.mErrorBarHolderIndices != null) {
                sXYMultipleDataProperties.mErrorBarHolderIndices = (Integer[])this.mErrorBarHolderIndices.clone();
            }
            if (this.mTickLabelIndices != null) {
                sXYMultipleDataProperties.mTickLabelIndices = (Integer[])this.mTickLabelIndices.clone();
            }
            if (this.mTickLabelHolderIndices != null) {
                sXYMultipleDataProperties.mTickLabelHolderIndices = (Integer[])this.mTickLabelHolderIndices.clone();
            }
            return sXYMultipleDataProperties;
        }

        public void dispose() {
            super.dispose();
            this.mXIndices = null;
            this.mYIndices = null;
            this.mLowerErrorIndices = null;
            this.mUpperErrorIndices = null;
            this.mErrorBarHolderIndices = null;
            this.mTickLabelIndices = null;
            this.mTickLabelHolderIndices = null;
        }
    }
}

