/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.util.ArrayList;
import java.util.Map;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.base.SGValueRange;
import jp.riken.brain.ni.samuraigraph.data.SGArrayData;
import jp.riken.brain.ni.samuraigraph.data.SGDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGDataSourceObserver;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGDateDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnNameConstants;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGINumberDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGNumberDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGTextDataFile;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGSXYData
extends SGArrayData
implements SGISXYTypeData,
SGIDataColumnTypeConstants,
SGIDataColumnNameConstants,
SGIConstants {
    protected Integer mXIndex = null;
    protected Integer mYIndex = null;
    protected Integer mLowerErrorIndex = null;
    protected Integer mUpperErrorIndex = null;
    protected Integer mErrorBarHolderIndex = null;
    protected Integer mTickLabelIndex = null;
    protected Integer mTickLabelHolderIndex = null;
    protected int mDecimalPlaces = 0;
    protected int mExponent = 0;

    public SGSXYData() {
    }

    public SGSXYData(SGTextDataFile sGTextDataFile, SGDataSourceObserver sGDataSourceObserver, Integer n, Integer n2) {
        this(sGTextDataFile, sGDataSourceObserver, n, n2, null, null, null, null, null);
    }

    public SGSXYData(SGTextDataFile sGTextDataFile, SGDataSourceObserver sGDataSourceObserver, Integer n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6, Integer n7) {
        super(sGTextDataFile, sGDataSourceObserver);
        if (n == null || n2 == null) {
            throw new IllegalArgumentException("Indices for x and y values must not be null.");
        }
        if (!(n3 == null && n4 == null || n3 != null && n4 != null)) {
            throw new IllegalArgumentException("A pair of indices for the lower and upper error bars as (null, null) or (not null, not null) are permitted.");
        }
        if (n3 != null && n5 == null) {
            throw new IllegalArgumentException("Error bar holder index is null.");
        }
        if (n6 != null && n7 == null) {
            throw new IllegalArgumentException("Tick label holder index is null.");
        }
        if (!this.checkColumnIndexRange(n)) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        if (!this.checkColumnIndexRange(n2)) {
            throw new IllegalArgumentException("Index out of bounds: " + n2);
        }
        if (n3 != null && !this.checkColumnIndexRange(n3)) {
            throw new IllegalArgumentException("Index out of bounds: " + n3);
        }
        if (n4 != null && !this.checkColumnIndexRange(n4)) {
            throw new IllegalArgumentException("Index out of bounds: " + n4);
        }
        if (n5 != null) {
            if (!this.checkColumnIndexRange(n5)) {
                throw new IllegalArgumentException("Index out of bounds: " + n5);
            }
            if (!n5.equals(n) && !n5.equals(n2)) {
                throw new IllegalArgumentException("Error holder value index must be equal to x value index or y value index.");
            }
        }
        if (n6 != null && !this.checkColumnIndexRange(n6)) {
            throw new IllegalArgumentException("Index out of bounds: " + n6);
        }
        if (n7 != null && !this.checkColumnIndexRange(n7)) {
            throw new IllegalArgumentException("Index out of bounds: " + n7);
        }
        this.mXIndex = n;
        this.mYIndex = n2;
        this.mLowerErrorIndex = n3;
        this.mUpperErrorIndex = n4;
        this.mErrorBarHolderIndex = n5;
        this.mTickLabelIndex = n6;
        this.mTickLabelHolderIndex = n7;
        if (n6 != null) {
            SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
            SGDataColumn sGDataColumn = sGDataColumnArray[n6];
            if (sGDataColumn instanceof SGNumberDataColumn) {
                SGNumberDataColumn sGNumberDataColumn = (SGNumberDataColumn)sGDataColumn;
                double[] dArray = sGNumberDataColumn.getNumberArray();
                int n8 = -2147483647;
                for (int i = 0; i < dArray.length; ++i) {
                    int n9;
                    if (dArray[i] == 0.0 || Double.isNaN(dArray[i]) || (n9 = SGUtilityNumber.getOrder(Math.abs(dArray[i]))) <= n8) continue;
                    n8 = n9;
                }
                this.mExponent = n8;
                this.mDecimalPlaces = 2;
            }
        } else {
            this.setupTickLabel(n, n2);
        }
    }

    private void setupTickLabel(Integer n, Integer n2) {
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        SGDataColumn sGDataColumn = sGDataColumnArray[n];
        SGDataColumn sGDataColumn2 = sGDataColumnArray[n2];
        if (sGDataColumn instanceof SGDateDataColumn) {
            this.mTickLabelIndex = n;
            this.mTickLabelHolderIndex = n2;
        } else if (sGDataColumn2 instanceof SGDateDataColumn) {
            this.mTickLabelIndex = n2;
            this.mTickLabelHolderIndex = n;
        }
    }

    public SGSXYData(SGData sGData) {
        this.setData(sGData);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mXIndex = null;
        this.mYIndex = null;
        this.mLowerErrorIndex = null;
        this.mUpperErrorIndex = null;
        this.mErrorBarHolderIndex = null;
        this.mTickLabelIndex = null;
        this.mTickLabelHolderIndex = null;
    }

    @Override
    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGSXYData)) {
            throw new IllegalArgumentException("!(data instanceof SGSXYData)");
        }
        if (!super.setData(sGData)) {
            return false;
        }
        SGSXYData sGSXYData = (SGSXYData)sGData;
        this.mXIndex = sGSXYData.mXIndex;
        this.mYIndex = sGSXYData.mYIndex;
        this.mLowerErrorIndex = sGSXYData.mLowerErrorIndex;
        this.mUpperErrorIndex = sGSXYData.mUpperErrorIndex;
        this.mErrorBarHolderIndex = sGSXYData.mErrorBarHolderIndex;
        this.mTickLabelIndex = sGSXYData.mTickLabelIndex;
        this.mTickLabelHolderIndex = sGSXYData.mTickLabelHolderIndex;
        return true;
    }

    @Override
    public int getPointsNumber() {
        return this.getXArray().length;
    }

    @Override
    public String getDataType() {
        return "SXY";
    }

    @Override
    public SGValueRange getBoundsX() {
        return SGDataUtility.getBoundsX(this);
    }

    @Override
    public SGValueRange getBoundsY() {
        return SGDataUtility.getBoundsY(this);
    }

    @Override
    public Double getXValue(int n) {
        int n2 = this.getPointsNumber();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("given index is out of bounds: " + n);
        }
        return this.getXArray()[n];
    }

    @Override
    public Double getYValue(int n) {
        int n2 = this.getPointsNumber();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("given index is out of bounds: " + n);
        }
        return this.getYArray()[n];
    }

    @Override
    public Double getLowerErrorValue(int n) {
        int n2 = this.getPointsNumber();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("given index is out of bounds: " + n);
        }
        if (this.isErrorBarAvailable()) {
            return -Math.abs(this.getLowerErrorArray()[n]);
        }
        return null;
    }

    @Override
    public Double getUpperErrorValue(int n) {
        int n2 = this.getPointsNumber();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("given index is out of bounds: " + n);
        }
        if (this.isErrorBarAvailable()) {
            return Math.abs(this.getUpperErrorArray()[n]);
        }
        return null;
    }

    @Override
    public String getString(int n) {
        int n2 = this.getPointsNumber();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("given index is out of bounds: " + n);
        }
        if (this.isTickLabelAvailable()) {
            String[] stringArray = this.getTextArray();
            if (stringArray == null) {
                return null;
            }
            return stringArray[n];
        }
        return null;
    }

    @Override
    public double[] getXValueArray() {
        return this.getXArray();
    }

    @Override
    public double[] getYValueArray() {
        return this.getYArray();
    }

    @Override
    public double[] getLowerErrorValueArray() {
        if (this.isErrorBarAvailable()) {
            double[] dArray = SGUtility.copyDoubleArray(this.getLowerErrorArray());
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = -Math.abs(dArray[i]);
            }
            return dArray;
        }
        return null;
    }

    @Override
    public double[] getUpperErrorValueArray() {
        if (this.isErrorBarAvailable()) {
            double[] dArray = SGUtility.copyDoubleArray(this.getUpperErrorArray());
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = Math.abs(dArray[i]);
            }
            return dArray;
        }
        return null;
    }

    @Override
    public String[] getStringArray() {
        if (this.mTickLabelIndex != null) {
            SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
            SGDataColumn sGDataColumn = sGDataColumnArray[this.mTickLabelIndex];
            if (sGDataColumn instanceof SGNumberDataColumn) {
                SGNumberDataColumn sGNumberDataColumn = (SGNumberDataColumn)sGDataColumn;
                return sGNumberDataColumn.getStringArray(this.mDecimalPlaces, this.mExponent);
            }
            return sGDataColumn.getStringArray();
        }
        return null;
    }

    @Override
    public boolean isErrorBarAvailable() {
        return this.mUpperErrorIndex != null && this.mLowerErrorIndex != null;
    }

    @Override
    public boolean isTickLabelAvailable() {
        return this.mTickLabelIndex != null;
    }

    @Override
    public boolean hasEqualTickLabelResource(SGISXYTypeData sGISXYTypeData) {
        if (!(sGISXYTypeData instanceof SGSXYData)) {
            return false;
        }
        SGSXYData sGSXYData = (SGSXYData)sGISXYTypeData;
        if (this.mTickLabelIndex == null) {
            return sGSXYData.mTickLabelIndex == null;
        }
        return this.mTickLabelIndex.equals(sGSXYData.mTickLabelIndex);
    }

    public boolean isDateColumnUsed() {
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        if (sGDataColumnArray[this.mXIndex] instanceof SGDateDataColumn) {
            return true;
        }
        return sGDataColumnArray[this.mYIndex] instanceof SGDateDataColumn;
    }

    protected double[] getXArray() {
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        SGINumberDataColumn sGINumberDataColumn = (SGINumberDataColumn)((Object)sGDataColumnArray[this.mXIndex]);
        return sGINumberDataColumn.getNumberArray();
    }

    protected double[] getYArray() {
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        SGINumberDataColumn sGINumberDataColumn = (SGINumberDataColumn)((Object)sGDataColumnArray[this.mYIndex]);
        return sGINumberDataColumn.getNumberArray();
    }

    protected double[] getLowerErrorArray() {
        if (this.mLowerErrorIndex == null) {
            return null;
        }
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        SGINumberDataColumn sGINumberDataColumn = (SGINumberDataColumn)((Object)sGDataColumnArray[this.mLowerErrorIndex]);
        return sGINumberDataColumn.getNumberArray();
    }

    protected double[] getUpperErrorArray() {
        if (this.mUpperErrorIndex == null) {
            return null;
        }
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        SGINumberDataColumn sGINumberDataColumn = (SGINumberDataColumn)((Object)sGDataColumnArray[this.mUpperErrorIndex]);
        return sGINumberDataColumn.getNumberArray();
    }

    protected String[] getTextArray() {
        if (this.mTickLabelIndex == null) {
            return null;
        }
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        SGDataColumn sGDataColumn = sGDataColumnArray[this.mTickLabelIndex];
        return sGDataColumn.getStringArray();
    }

    @Override
    protected boolean writeAttributeColumnIndices(Element element) {
        return true;
    }

    @Override
    protected boolean writeSequentialColumnIndices(Element element) {
        return true;
    }

    @Override
    protected boolean writeSequentialColumnName(Element element) {
        return true;
    }

    @Override
    public boolean readProperty(Element element) {
        return true;
    }

    @Override
    public String getTitleX() {
        if (this.mXIndex == null) {
            return "";
        }
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        return sGDataColumnArray[this.mXIndex].getTitle();
    }

    @Override
    public String getTitleY() {
        if (this.mYIndex == null) {
            return "";
        }
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        return sGDataColumnArray[this.mYIndex].getTitle();
    }

    public Integer getXIndex() {
        return this.mXIndex;
    }

    public Integer getYIndex() {
        return this.mYIndex;
    }

    public Integer getLowerErrorIndex() {
        return this.mLowerErrorIndex;
    }

    public Integer getUpperErrorIndex() {
        return this.mUpperErrorIndex;
    }

    public Integer getErrorBarHolderIndex() {
        return this.mErrorBarHolderIndex;
    }

    public Integer getTickLabelIndex() {
        return this.mTickLabelIndex;
    }

    public Integer getTickLabelHolderIndex() {
        return this.mTickLabelHolderIndex;
    }

    public void setXIndex(Integer n) {
        if (n == null) {
            throw new IllegalArgumentException("index == null");
        }
        if (!this.checkColumnIndexRange(n)) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        this.mXIndex = n;
    }

    public void setYIndex(Integer n) {
        if (n == null) {
            throw new IllegalArgumentException("index == null");
        }
        if (!this.checkColumnIndexRange(n)) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        this.mYIndex = n;
    }

    public void setLowerErrorIndex(Integer n) {
        if (n != null && !this.checkColumnIndexRange(n)) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        this.mLowerErrorIndex = n;
    }

    public void setUpperErrorIndex(Integer n) {
        if (n != null && !this.checkColumnIndexRange(n)) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        this.mUpperErrorIndex = n;
    }

    public void setErrorBarHolderIndex(Integer n) {
        if (n != null && !this.checkColumnIndexRange(n)) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        this.mErrorBarHolderIndex = n;
    }

    public void setTickLabelIndex(Integer n) {
        if (n != null && !this.checkColumnIndexRange(n)) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        this.mTickLabelIndex = n;
    }

    public void setTickLabelHolderIndex(Integer n) {
        if (n != null && !this.checkColumnIndexRange(n)) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        this.mTickLabelHolderIndex = n;
    }

    @Override
    public SGProperties getProperties() {
        SXYDataProperties sXYDataProperties = new SXYDataProperties();
        if (!this.getProperties(sXYDataProperties)) {
            return null;
        }
        return sXYDataProperties;
    }

    @Override
    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SXYDataProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        SXYDataProperties sXYDataProperties = (SXYDataProperties)sGProperties;
        sXYDataProperties.mXIndex = this.getXIndex();
        sXYDataProperties.mYIndex = this.getYIndex();
        sXYDataProperties.mLowerErrorIndex = this.getLowerErrorIndex();
        sXYDataProperties.mUpperErrorIndex = this.getUpperErrorIndex();
        sXYDataProperties.mErrorBarHolderIndex = this.getErrorBarHolderIndex();
        sXYDataProperties.mTickLabelIndex = this.getTickLabelIndex();
        sXYDataProperties.mTickLabelHolderIndex = this.getTickLabelHolderIndex();
        return true;
    }

    @Override
    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SXYDataProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        SXYDataProperties sXYDataProperties = (SXYDataProperties)sGProperties;
        this.mXIndex = sXYDataProperties.mXIndex;
        this.mYIndex = sXYDataProperties.mYIndex;
        this.mLowerErrorIndex = sXYDataProperties.mLowerErrorIndex;
        this.mUpperErrorIndex = sXYDataProperties.mUpperErrorIndex;
        this.mErrorBarHolderIndex = sXYDataProperties.mErrorBarHolderIndex;
        this.mTickLabelIndex = sXYDataProperties.mTickLabelIndex;
        this.mTickLabelHolderIndex = sXYDataProperties.mTickLabelHolderIndex;
        return true;
    }

    @Override
    public boolean setColumnType(String[] stringArray) {
        String string;
        Object object;
        if (stringArray == null) {
            throw new IllegalArgumentException("columns == null");
        }
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        Integer n5 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (SGUtilityText.isEqualString("X", stringArray[i])) {
                n = i;
                continue;
            }
            if (SGUtilityText.isEqualString("Y", stringArray[i])) {
                n2 = i;
                continue;
            }
            if (SGUtilityText.startsWith(stringArray[i], "Lower Error")) {
                n3 = i;
                continue;
            }
            if (SGUtilityText.startsWith(stringArray[i], "Upper Error")) {
                n4 = i;
                continue;
            }
            if (SGUtilityText.startsWith(stringArray[i], "Lower / Upper Error")) {
                n3 = i;
                n4 = i;
                continue;
            }
            if (SGUtilityText.startsWith(stringArray[i], "Tick Label")) {
                n5 = i;
                continue;
            }
            if ("".equals(stringArray[i])) continue;
            return false;
        }
        if (n == null || n2 == null) {
            return false;
        }
        if (!(n3 == null && n4 == null || n3 != null && n4 != null)) {
            return false;
        }
        String[] stringArray2 = this.mDataFile.getTitles();
        Integer n6 = null;
        if (n3 != null) {
            object = stringArray[n3];
            string = stringArray[n4];
            Integer n7 = SGDataUtility.getAppendedColumnIndex((String)object, stringArray2);
            Integer n8 = SGDataUtility.getAppendedColumnIndex(string, stringArray2);
            if (n7 == null || n8 == null || !n7.equals(n8)) {
                return false;
            }
            n6 = n7;
        }
        object = null;
        if (n5 != null && (object = SGDataUtility.getAppendedColumnIndex(string = stringArray[n5], stringArray2)) == null) {
            return false;
        }
        this.mXIndex = n;
        this.mYIndex = n2;
        this.mLowerErrorIndex = n3;
        this.mUpperErrorIndex = n4;
        this.mErrorBarHolderIndex = n6;
        this.mTickLabelIndex = n5;
        this.mTickLabelHolderIndex = object;
        if (n5 == null && object == null) {
            this.setupTickLabel(n, n2);
        }
        return true;
    }

    @Override
    public String[] getCurrentColumnType() {
        int n;
        int n2 = this.getColNum();
        String[] stringArray = new String[n2];
        if (this.mXIndex != null) {
            stringArray[this.mXIndex.intValue()] = "X";
        }
        if (this.mYIndex != null) {
            stringArray[this.mYIndex.intValue()] = "Y";
        }
        if (this.mLowerErrorIndex != null && this.mUpperErrorIndex != null && this.mErrorBarHolderIndex != null) {
            n = this.mErrorBarHolderIndex;
            if (this.mLowerErrorIndex.equals(this.mUpperErrorIndex)) {
                stringArray[this.mLowerErrorIndex.intValue()] = SGDataUtility.appendColumnNoOrTitle("Lower / Upper Error", n, this.mDataFile.isEmptyTitle(n) || this.mDataFile.isRepeatedTitle(n), this.getTitle(n));
            } else {
                stringArray[this.mLowerErrorIndex.intValue()] = SGDataUtility.appendColumnNoOrTitle("Lower Error", n, this.mDataFile.isEmptyTitle(n) || this.mDataFile.isRepeatedTitle(n), this.getTitle(n));
                stringArray[this.mUpperErrorIndex.intValue()] = SGDataUtility.appendColumnNoOrTitle("Upper Error", n, this.mDataFile.isEmptyTitle(n) || this.mDataFile.isRepeatedTitle(n), this.getTitle(n));
            }
        }
        if (this.mTickLabelIndex != null && this.mTickLabelHolderIndex != null && !this.hasDateTickLabel()) {
            n = this.mTickLabelHolderIndex;
            stringArray[this.mTickLabelIndex.intValue()] = SGDataUtility.appendColumnNoOrTitle("Tick Label", n, this.mDataFile.isEmptyTitle(n) || this.mDataFile.isRepeatedTitle(n), this.getTitle(n));
        }
        return stringArray;
    }

    private boolean hasDateTickLabel() {
        if (this.isTickLabelAvailable()) {
            return this.mTickLabelIndex.equals(this.mXIndex) || this.mTickLabelIndex.equals(this.mYIndex);
        }
        return false;
    }

    @Override
    protected SGDataColumn[] getDataSetColumns() {
        SGDataColumn[] sGDataColumnArray;
        SGDataColumn[] sGDataColumnArray2 = this.mDataFile.mDataColumns;
        if (this.isErrorBarAvailable()) {
            if (this.isTickLabelAvailable()) {
                sGDataColumnArray = new SGDataColumn[7];
                sGDataColumnArray[5] = sGDataColumnArray2[this.mTickLabelIndex];
                sGDataColumnArray[6] = sGDataColumnArray2[this.mTickLabelHolderIndex];
            } else {
                sGDataColumnArray = new SGDataColumn[5];
            }
            sGDataColumnArray[2] = sGDataColumnArray2[this.mLowerErrorIndex];
            sGDataColumnArray[3] = sGDataColumnArray2[this.mUpperErrorIndex];
            sGDataColumnArray[4] = sGDataColumnArray2[this.mErrorBarHolderIndex];
        } else if (this.isTickLabelAvailable()) {
            sGDataColumnArray = new SGDataColumn[4];
            sGDataColumnArray[2] = sGDataColumnArray2[this.mTickLabelIndex];
            sGDataColumnArray[3] = sGDataColumnArray2[this.mTickLabelHolderIndex];
        } else {
            sGDataColumnArray = new SGDataColumn[]{sGDataColumnArray2[this.mXIndex], sGDataColumnArray2[this.mYIndex]};
        }
        return sGDataColumnArray;
    }

    @Override
    public SGDataColumn[] getUsedDataColumnsClone() {
        SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
        String[] stringArray = this.getCurrentColumnType();
        ArrayList<SGDataColumn> arrayList = new ArrayList<SGDataColumn>();
        int n = this.mXIndex;
        SGDataColumn sGDataColumn = (SGDataColumn)sGDataColumnArray[n].clone();
        sGDataColumn.setColumnType(stringArray[n]);
        arrayList.add(sGDataColumn);
        n = this.mYIndex;
        sGDataColumn = (SGDataColumn)sGDataColumnArray[n].clone();
        sGDataColumn.setColumnType(stringArray[n]);
        arrayList.add(sGDataColumn);
        if (this.isErrorBarAvailable()) {
            if (this.mLowerErrorIndex.equals(this.mUpperErrorIndex)) {
                n = this.mLowerErrorIndex;
                sGDataColumn = (SGDataColumn)sGDataColumnArray[n].clone();
                sGDataColumn.setColumnType(stringArray[n]);
                arrayList.add(sGDataColumn);
            } else {
                n = this.mLowerErrorIndex;
                sGDataColumn = (SGDataColumn)sGDataColumnArray[n].clone();
                sGDataColumn.setColumnType(stringArray[n]);
                arrayList.add(sGDataColumn);
                n = this.mUpperErrorIndex;
                sGDataColumn = (SGDataColumn)sGDataColumnArray[n].clone();
                sGDataColumn.setColumnType(stringArray[n]);
                arrayList.add(sGDataColumn);
            }
        }
        if (this.isTickLabelAvailable()) {
            n = this.mTickLabelIndex;
            sGDataColumn = (SGDataColumn)sGDataColumnArray[n].clone();
            sGDataColumn.setColumnType(stringArray[n]);
            arrayList.add(sGDataColumn);
        }
        return arrayList.toArray(new SGDataColumn[arrayList.size()]);
    }

    @Override
    protected Object[][] getDataSetValues() {
        Object object;
        boolean bl = this.isErrorBarAvailable();
        boolean bl2 = this.isTickLabelAvailable();
        int n = this.getPointsNumber();
        SGDataColumn[] sGDataColumnArray = this.getDataSetColumns();
        int n2 = sGDataColumnArray.length;
        SGNumberDataColumn sGNumberDataColumn = null;
        String[] stringArray = null;
        if (bl2) {
            object = null;
            object = bl ? sGDataColumnArray[4] : sGDataColumnArray[2];
            if (object instanceof SGNumberDataColumn) {
                sGNumberDataColumn = (SGNumberDataColumn)object;
                stringArray = sGNumberDataColumn.getStringArray(this.mDecimalPlaces, this.mExponent);
            }
        }
        object = new Object[n][];
        for (int i = 0; i < n; ++i) {
            object[i] = new Object[n2];
            for (int j = 0; j < n2; ++j) {
                SGDataColumn sGDataColumn = sGDataColumnArray[j];
                Object object2 = sGDataColumn.getExportedValue(i);
                if (bl) {
                    Double d;
                    if (j == 2) {
                        d = (Double)object2;
                        object2 = -Math.abs(d);
                    } else if (j == 3) {
                        d = (Double)object2;
                        object2 = Math.abs(d);
                    }
                }
                if (bl2 && (bl && j == 4 || !bl && j == 2) && stringArray != null) {
                    object2 = stringArray[i];
                }
                object[i][j] = object2;
            }
        }
        return object;
    }

    @Override
    public void setDecimalPlaces(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Decimal places must not be negative: " + n);
        }
        this.mDecimalPlaces = n;
    }

    @Override
    public void setExponent(int n) {
        this.mExponent = n;
    }

    @Override
    public int getDecimalPlaces() {
        return this.mDecimalPlaces;
    }

    @Override
    public int getExponent() {
        return this.mExponent;
    }

    @Override
    public Boolean isErrorBarVertical() {
        if (this.isErrorBarAvailable()) {
            return this.mYIndex.equals(this.mErrorBarHolderIndex);
        }
        return null;
    }

    @Override
    public Boolean isTickLabelHorizontal() {
        if (this.isTickLabelAvailable()) {
            return this.mYIndex.equals(this.mTickLabelHolderIndex);
        }
        if (this.isDateColumnUsed()) {
            SGDataColumn[] sGDataColumnArray = this.mDataFile.mDataColumns;
            if (sGDataColumnArray[this.mXIndex] instanceof SGDateDataColumn) {
                return Boolean.TRUE;
            }
            if (sGDataColumnArray[this.mYIndex] instanceof SGDateDataColumn) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public SGISXYTypeMultipleData toMultiple() {
        Integer[] integerArray;
        Integer[] integerArray2;
        Integer[] integerArray3;
        Integer[] integerArray4;
        Integer[] integerArray5;
        Integer[] integerArray6;
        Integer[] integerArray7;
        Integer[] integerArray8;
        Integer[] integerArray9;
        boolean bl = this.isErrorBarAvailable();
        boolean bl2 = this.isTickLabelAvailable();
        Integer[] integerArray10 = new Integer[]{this.mXIndex};
        Integer[] integerArray11 = new Integer[]{this.mYIndex};
        if (bl) {
            Integer[] integerArray12 = new Integer[1];
            integerArray9 = integerArray12;
            integerArray12[0] = this.mLowerErrorIndex;
        } else {
            integerArray9 = integerArray8 = null;
        }
        if (bl) {
            Integer[] integerArray13 = new Integer[1];
            integerArray7 = integerArray13;
            integerArray13[0] = this.mUpperErrorIndex;
        } else {
            integerArray7 = integerArray6 = null;
        }
        if (bl) {
            Integer[] integerArray14 = new Integer[1];
            integerArray5 = integerArray14;
            integerArray14[0] = this.mErrorBarHolderIndex;
        } else {
            integerArray5 = integerArray4 = null;
        }
        if (bl2) {
            Integer[] integerArray15 = new Integer[1];
            integerArray3 = integerArray15;
            integerArray15[0] = this.mTickLabelIndex;
        } else {
            integerArray3 = integerArray2 = null;
        }
        if (bl2) {
            Integer[] integerArray16 = new Integer[1];
            integerArray = integerArray16;
            integerArray16[0] = this.mTickLabelHolderIndex;
        } else {
            integerArray = null;
        }
        Integer[] integerArray17 = integerArray;
        SGSXYMultipleData sGSXYMultipleData = new SGSXYMultipleData(this.mDataFile, this.mObserver, integerArray10, integerArray11, integerArray8, integerArray6, integerArray4, integerArray2, integerArray17);
        return sGSXYMultipleData;
    }

    public SGDataColumn getXColumn() {
        return this.getColumn(this.mXIndex);
    }

    public SGDataColumn getYColumn() {
        return this.getColumn(this.mYIndex);
    }

    public SGDataColumn getLowerErrorColumn() {
        return this.getColumn(this.mLowerErrorIndex);
    }

    public SGDataColumn getUpperErrorColumn() {
        return this.getColumn(this.mUpperErrorIndex);
    }

    public SGDataColumn getErrorBarHolderColumn() {
        return this.getColumn(this.mErrorBarHolderIndex);
    }

    public SGDataColumn getTickLableColumn() {
        return this.getColumn(this.mTickLabelIndex);
    }

    public SGDataColumn getTickLabelHolderColumn() {
        return this.getColumn(this.mTickLabelHolderIndex);
    }

    @Override
    public Map<String, Object> getInfoMap() {
        Map<String, Object> map = super.getInfoMap();
        map.put("Multiple", Boolean.FALSE);
        return map;
    }

    public static class SXYDataProperties
    extends SGArrayData.ArrayDataProperties {
        Integer mXIndex = null;
        Integer mYIndex = null;
        Integer mLowerErrorIndex = null;
        Integer mUpperErrorIndex = null;
        Integer mErrorBarHolderIndex = null;
        Integer mTickLabelIndex = null;
        Integer mTickLabelHolderIndex = null;

        public boolean equals(Object object) {
            if (!(object instanceof SXYDataProperties)) {
                return false;
            }
            SXYDataProperties sXYDataProperties = (SXYDataProperties)object;
            if (!SGUtility.equals(this.mXIndex, sXYDataProperties.mXIndex)) {
                return false;
            }
            if (!SGUtility.equals(this.mYIndex, sXYDataProperties.mYIndex)) {
                return false;
            }
            if (!SGUtility.equals(this.mLowerErrorIndex, sXYDataProperties.mLowerErrorIndex)) {
                return false;
            }
            if (!SGUtility.equals(this.mUpperErrorIndex, sXYDataProperties.mUpperErrorIndex)) {
                return false;
            }
            if (!SGUtility.equals(this.mErrorBarHolderIndex, sXYDataProperties.mErrorBarHolderIndex)) {
                return false;
            }
            if (!SGUtility.equals(this.mTickLabelIndex, sXYDataProperties.mTickLabelIndex)) {
                return false;
            }
            return SGUtility.equals(this.mTickLabelHolderIndex, sXYDataProperties.mTickLabelHolderIndex);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            stringBuffer.append("XIndex=");
            stringBuffer.append(this.mXIndex);
            stringBuffer.append(", YIndex=");
            stringBuffer.append(this.mYIndex);
            stringBuffer.append(", LowerErrorIndex=");
            stringBuffer.append(this.mLowerErrorIndex);
            stringBuffer.append(", UpperErrorIndex=");
            stringBuffer.append(this.mUpperErrorIndex);
            stringBuffer.append(", ErrorBarHolderIndex=");
            stringBuffer.append(this.mErrorBarHolderIndex);
            stringBuffer.append(", TickLabelIndex=");
            stringBuffer.append(this.mTickLabelIndex);
            stringBuffer.append(", TickLabelHolderIndex=");
            stringBuffer.append(this.mTickLabelHolderIndex);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        public void dispose() {
            super.dispose();
            this.mXIndex = null;
            this.mYIndex = null;
            this.mLowerErrorIndex = null;
            this.mUpperErrorIndex = null;
            this.mErrorBarHolderIndex = null;
            this.mTickLabelIndex = null;
            this.mTickLabelHolderIndex = null;
        }
    }
}

