/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGINumberDataColumn;

public class SGNumberDataColumn
extends SGDataColumn
implements SGINumberDataColumn {
    protected double[] mArray = null;

    protected SGNumberDataColumn() {
    }

    public SGNumberDataColumn(String string, double[] dArray) {
        super(string);
        if (dArray == null) {
            throw new IllegalArgumentException("array == null");
        }
        this.mArray = SGUtility.copyDoubleArray(dArray);
    }

    public SGNumberDataColumn(String string, String[] stringArray) {
        super(string);
        if (stringArray == null) {
            throw new IllegalArgumentException("array == null");
        }
        int n = stringArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            Double d = SGUtilityText.getDouble(stringArray[i]);
            if (d == null) {
                throw new IllegalArgumentException("strArray[" + i + "] is not a number: " + stringArray[i]);
            }
            dArray[i] = d;
        }
        this.mArray = SGUtility.copyDoubleArray(dArray);
    }

    public int getLength() {
        return this.mArray.length;
    }

    public String getValueType() {
        return "Number";
    }

    public void dispose() {
        super.dispose();
        this.mArray = null;
    }

    public double[] getNumberArray() {
        return this.mArray;
    }

    public Object getValue(int n) {
        if (n > this.mArray.length) {
            throw new IllegalArgumentException("Index out of bounds: " + n + " > " + this.mArray.length);
        }
        return this.mArray[n];
    }

    protected Object getExportedValue(int n) {
        return this.getValue(n);
    }

    public String[] getStringArray() {
        return this.getStringArray(0, 0);
    }

    public String[] getStringArray(int n, int n2) {
        return SGUtilityNumber.getStringArray(this.mArray, n, n2);
    }
}

