/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfoSet;
import jp.riken.brain.ni.samuraigraph.data.SGDataSetupDialog;
import jp.riken.brain.ni.samuraigraph.data.SGIDataSetupTableHolder;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFDataSetupPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGNetCDFDataSetupDialog
extends SGDataSetupDialog
implements DocumentListener {
    private static final long serialVersionUID = -874015069620292227L;
    public static final String TITLE = "Setup netCDF data";
    private JPanel mButtonPanel;
    private SGButton mCancelButton;
    private SGNetCDFDataSetupPanel mNetCDFDataSetupPanel;
    private SGButton mOKButton;

    public SGNetCDFDataSetupDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    public SGNetCDFDataSetupDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mNetCDFDataSetupPanel = new SGNetCDFDataSetupPanel();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new SGButton();
        this.mCancelButton = new SGButton();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.mNetCDFDataSetupPanel, new GridBagConstraints());
        this.mOKButton.setText("OK");
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mCancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    private void initProperty() {
        this.setTitle(TITLE);
        this.getOKButton().addActionListener(this);
        this.getCancelButton().addActionListener(this);
        this.mNetCDFDataSetupPanel.getRestoreButton().addActionListener(this);
        this.mNetCDFDataSetupPanel.getClearButton().addActionListener(this);
        this.mNetCDFDataSetupPanel.getComplementButton().addActionListener(this);
        this.mNetCDFDataSetupPanel.getTable().addPropertyChangeListener(this);
        this.mNetCDFDataSetupPanel.getMultipleDimensionStartField().getDocument().addDocumentListener(this);
        this.mNetCDFDataSetupPanel.getMultipleDimensionEndField().getDocument().addDocumentListener(this);
        this.mNetCDFDataSetupPanel.getMultipleDimensionStepField().getDocument().addDocumentListener(this);
        this.mNetCDFDataSetupPanel.setPopupDialogOwner(this);
    }

    @Override
    protected JButton getOKButton() {
        return this.mOKButton;
    }

    @Override
    protected JButton getCancelButton() {
        return this.mCancelButton;
    }

    @Override
    protected SGIDataSetupTableHolder getTableHolder() {
        return this.mNetCDFDataSetupPanel;
    }

    public boolean setData(SGNetCDFData sGNetCDFData, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map, boolean bl) {
        return this.mNetCDFDataSetupPanel.setData(sGNetCDFData, sGDataColumnInfoSet, map, bl);
    }

    public Integer getMultipleDimensionStart() {
        return this.mNetCDFDataSetupPanel.getMultipleDimensionStart();
    }

    public Integer getMultipleDimensionEnd() {
        return this.mNetCDFDataSetupPanel.getMultipleDimensionEnd();
    }

    public Integer getMultipleDimensionStep() {
        return this.mNetCDFDataSetupPanel.getMultipleDimensionStep();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        SwingUtilities.invokeLater(new SGDataSetupDialog.InputObserver());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        SwingUtilities.invokeLater(new SGDataSetupDialog.InputObserver());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        SwingUtilities.invokeLater(new SGDataSetupDialog.InputObserver());
    }
}

