/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnNameConstants;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFFile;
import jp.riken.brain.ni.samuraigraph.data.SGTextVariable;
import jp.riken.brain.ni.samuraigraph.data.SGVariable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import ucar.nc2.Dimension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGDefaultColumnTypeUtility
implements SGIDataColumnTypeConstants,
SGIDataColumnNameConstants {
    public static DefaultColumnTypeResult getDefaultColumnTypes(String string, List<SGDataColumnInfo> list, Map<String, Object> map) {
        boolean bl;
        if (string == null || list == null || map == null) {
            throw new IllegalArgumentException("Null input value.");
        }
        SGDataColumnInfo[] sGDataColumnInfoArray = new SGDataColumnInfo[list.size()];
        for (bl = false; bl < sGDataColumnInfoArray.length; bl += 1) {
            sGDataColumnInfoArray[bl] = (SGDataColumnInfo)list.get(bl ? 1 : 0).clone();
        }
        bl = SGDefaultColumnTypeUtility.getDefaultColumnTypesSub(string, list, map, sGDataColumnInfoArray);
        String[] stringArray = new String[sGDataColumnInfoArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = sGDataColumnInfoArray[i].getColumnType();
        }
        DefaultColumnTypeResult defaultColumnTypeResult = new DefaultColumnTypeResult(stringArray, bl);
        return defaultColumnTypeResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean getDefaultColumnTypesSub(String string, List<SGDataColumnInfo> list, Map<String, Object> map, SGDataColumnInfo[] sGDataColumnInfoArray) {
        boolean bl = true;
        int n = list.size();
        NamedNodeMap namedNodeMap = (NamedNodeMap)map.get("NodeMap");
        String string2 = (String)map.get("GroupName");
        if (SGDataUtility.isArrayData(string)) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
            for (int i = 0; i < n; ++i) {
                SGDataColumnInfo sGDataColumnInfo = list.get(i);
                String string3 = sGDataColumnInfo.getValueType();
                if ("Number".equals(string3)) {
                    arrayList.add(i);
                    continue;
                }
                if ("Text".equals(string3)) {
                    arrayList2.add(i);
                    continue;
                }
                if ("Date".equals(string3)) {
                    arrayList3.add(i);
                    continue;
                }
                if (!"Sampling Rate".equals(string3)) continue;
                arrayList4.add(i);
            }
            if (SGDataUtility.isSXYTypeData(string) || "SXY_SAMPLING".equals(string)) {
                if (namedNodeMap != null) {
                    if (!SGDefaultColumnTypeUtility.getDefaultColumnTypesForSXYTypeArrayData(list, map, namedNodeMap, string2, sGDataColumnInfoArray)) {
                        bl = false;
                    }
                    if (bl && !SGDataUtility.checkDataColumns(string, sGDataColumnInfoArray, map)) {
                        bl = false;
                    }
                }
                if (namedNodeMap != null && bl || SGDefaultColumnTypeUtility.getDefaultColumnTypesForSXYTypeArrayData(list, n, map, arrayList, arrayList2, arrayList3, arrayList4, sGDataColumnInfoArray)) return true;
                return false;
            }
            if ("SXYZ".equals(string)) {
                if (namedNodeMap != null) {
                    if (!SGDefaultColumnTypeUtility.getDefaultColumnTypesForSXYZTypeArrayData(list, map, namedNodeMap, string2, sGDataColumnInfoArray)) {
                        bl = false;
                    }
                    if (bl && !SGDataUtility.checkDataColumns(string, sGDataColumnInfoArray, map)) {
                        bl = false;
                    }
                }
                if (namedNodeMap != null && bl || SGDefaultColumnTypeUtility.getDefaultColumnTypesForSXYZTypeArrayData(list, n, map, arrayList, arrayList2, arrayList3, arrayList4, sGDataColumnInfoArray)) return true;
                return false;
            }
            if (!"VXY".equals(string)) throw new Error("Invalid data type: " + string);
            if (namedNodeMap != null) {
                if (!SGDefaultColumnTypeUtility.getDefaultColumnTypesForVXYTypeArrayData(list, map, namedNodeMap, string2, sGDataColumnInfoArray)) {
                    bl = false;
                }
                if (bl && !SGDataUtility.checkDataColumns(string, sGDataColumnInfoArray, map)) {
                    bl = false;
                }
            }
            if (namedNodeMap != null && bl || SGDefaultColumnTypeUtility.getDefaultColumnTypesForVXYTypeArrayData(list, n, map, arrayList, arrayList2, arrayList3, arrayList4, sGDataColumnInfoArray)) return true;
            return false;
        }
        SGNetCDFFile sGNetCDFFile = (SGNetCDFFile)map.get("Data Source");
        List<SGVariable> list2 = sGNetCDFFile.getVariables();
        int n2 = list2.size();
        if (SGDataUtility.isSXYTypeData(string)) {
            if (namedNodeMap != null) {
                if (!SGDefaultColumnTypeUtility.getDefaultColumnTypesForSXYTypeNetCDFData(list, map, namedNodeMap, string2, sGDataColumnInfoArray)) {
                    bl = false;
                }
                if (bl && !SGDataUtility.checkDataColumns(string, sGDataColumnInfoArray, map)) {
                    bl = false;
                }
            }
            if (namedNodeMap != null && bl || SGDefaultColumnTypeUtility.getDefaultColumnTypesForSXYTypeNetCDFData(map, list2, n2, sGDataColumnInfoArray)) return true;
            return false;
        }
        if ("VXY_NETCDF".equals(string)) {
            if (namedNodeMap != null) {
                if (!SGDefaultColumnTypeUtility.getDefaultColumnTypesForVXYTypeNetCDFData(list, map, namedNodeMap, string2, sGDataColumnInfoArray)) {
                    bl = false;
                }
                if (bl && !SGDataUtility.checkDataColumns(string, sGDataColumnInfoArray, map)) {
                    bl = false;
                }
            }
            if (namedNodeMap != null && bl || SGDefaultColumnTypeUtility.getDefaultColumnTypesForVXYTypeNetCDFData(map, list2, n2, sGDataColumnInfoArray)) return true;
            return false;
        }
        if (!"SXYZ_NETCDF".equals(string)) throw new Error("Invalid data type: " + string);
        if (namedNodeMap != null) {
            if (!SGDefaultColumnTypeUtility.getDefaultColumnTypesForSXYZTypeNetCDFData(list, map, namedNodeMap, string2, sGDataColumnInfoArray)) {
                bl = false;
            }
            if (bl && !SGDataUtility.checkDataColumns(string, sGDataColumnInfoArray, map)) {
                bl = false;
            }
        }
        if (namedNodeMap != null && bl || SGDefaultColumnTypeUtility.getDefaultColumnTypesForSXYZTypeNetCDFData(map, list2, n2, sGDataColumnInfoArray)) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean getDefaultColumnTypesForSXYTypeArrayData(List<SGDataColumnInfo> list, int n, Map<String, Object> map, List<Integer> list2, List<Integer> list3, List<Integer> list4, List<Integer> list5, SGDataColumnInfo[] sGDataColumnInfoArray) {
        Object object;
        Object object2;
        int n2;
        String[] stringArray = new String[sGDataColumnInfoArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "";
        }
        if (list5.size() > 1) {
            return false;
        }
        Double d = (Double)map.get("Sampling rate");
        Boolean bl = (Boolean)map.get("Multiple");
        if (bl == null) {
            return false;
        }
        boolean bl2 = false;
        for (n2 = 0; n2 < n; ++n2) {
            object2 = list.get(n2);
            object = ((SGDataColumnInfo)object2).getValueType();
            if (!"Date".equals(object)) continue;
            bl2 = true;
            break;
        }
        if (bl.booleanValue()) {
            if (d != null) {
                if (list2.size() < 1) return false;
                for (n2 = 0; n2 < list2.size(); ++n2) {
                    object2 = list2.get(n2);
                    stringArray[((Integer)object2).intValue()] = "Y";
                }
                if (list5.size() == 1) {
                    Integer n3 = list5.get(0);
                    stringArray[n3.intValue()] = "X";
                }
            } else if (bl2) {
                if (list2.size() < 1) return false;
                for (n2 = 0; n2 < list2.size(); ++n2) {
                    object2 = list2.get(n2);
                    stringArray[((Integer)object2).intValue()] = "Y";
                }
                Integer n4 = list4.get(0);
                stringArray[n4.intValue()] = "X";
            } else {
                if (list2.size() < 2) return false;
                Integer n5 = list2.get(0);
                stringArray[n5.intValue()] = "X";
                for (int i = 1; i < list2.size(); ++i) {
                    object = list2.get(i);
                    stringArray[((Integer)object).intValue()] = "Y";
                }
            }
        } else {
            Integer n6;
            Object object3;
            Object object4;
            int n7;
            n2 = d != null ? 1 : (bl2 ? 1 : 2);
            int n8 = n2 - 1;
            int n9 = -1;
            int n10 = 0;
            for (n7 = 0; n7 < n; ++n7) {
                object4 = list.get(n7);
                object3 = ((SGDataColumnInfo)object4).getValueType();
                if (!"Number".equals(object3)) continue;
                if (n10 == n8) {
                    n9 = n7;
                    break;
                }
                ++n10;
            }
            if (n9 == -1) {
                return false;
            }
            if (list2.size() < n2) return false;
            n7 = 0;
            if (d != null) {
                if (list5.size() == 1) {
                    object4 = list5.get(0);
                    stringArray[((Integer)object4).intValue()] = "X";
                }
            } else if (list4.size() != 0 && bl2) {
                object4 = list4.get(0);
                stringArray[((Integer)object4).intValue()] = "X";
                n7 = 1;
            } else {
                object4 = list2.get(0);
                stringArray[((Integer)object4).intValue()] = "X";
            }
            object4 = list2.get(n8);
            stringArray[((Integer)object4).intValue()] = "Y";
            object3 = SGDataUtility.isEmptyOrRepeatedColumnTitle(list.toArray(new SGDataColumnInfo[n]));
            if (list2.size() >= n2 + 2) {
                n6 = list2.get(n8 + 1);
                Integer n11 = list2.get(n8 + 2);
                stringArray[n6.intValue()] = SGDataUtility.appendColumnNoOrTitle("Lower Error", n9, (boolean)object3[n9], list.get(n9).getTitle());
                stringArray[n11.intValue()] = SGDataUtility.appendColumnNoOrTitle("Upper Error", n9, (boolean)object3[n9], list.get(n9).getTitle());
            }
            if (list3.size() > 0) {
                n6 = list3.get(0);
                stringArray[n6.intValue()] = SGDataUtility.appendColumnNoOrTitle("Tick Label", n9, (boolean)object3[n9], list.get(n9).getTitle());
            } else if (list4.size() > 0 && n7 == 0) {
                n6 = list4.get(0);
                stringArray[n6.intValue()] = SGDataUtility.appendColumnNoOrTitle("Tick Label", n9, (boolean)object3[n9], list.get(n9).getTitle());
            }
        }
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            sGDataColumnInfoArray[i].setColumnType(stringArray[i]);
        }
        return true;
    }

    private static boolean getDefaultColumnTypesForSXYTypeArrayData(List<SGDataColumnInfo> list, Map<String, Object> map, NamedNodeMap namedNodeMap, String string, SGDataColumnInfo[] sGDataColumnInfoArray) {
        int n;
        String[] stringArray = new String[sGDataColumnInfoArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "";
        }
        Integer[] integerArray = SGDefaultColumnTypeUtility.getIndices(namedNodeMap, "XValueIndices");
        if (integerArray == null) {
            return false;
        }
        if (integerArray.length == 0) {
            return false;
        }
        if (!SGDefaultColumnTypeUtility.checkIndices(integerArray, stringArray)) {
            return false;
        }
        Integer[] integerArray2 = SGDefaultColumnTypeUtility.getIndices(namedNodeMap, "YValueIndices");
        if (integerArray2 == null) {
            return false;
        }
        if (integerArray2.length == 0) {
            return false;
        }
        if (!SGDefaultColumnTypeUtility.checkIndices(integerArray2, stringArray)) {
            return false;
        }
        if (integerArray.length > 1 && integerArray2.length > 1) {
            return false;
        }
        for (n = 0; n < integerArray.length; ++n) {
            stringArray[integerArray[n].intValue()] = "X";
        }
        for (n = 0; n < integerArray2.length; ++n) {
            stringArray[integerArray2[n].intValue()] = "Y";
        }
        SGDefaultColumnTypeUtility.getDefaultColumnTypesForSXYTypeArrayDataErrorBar(list, map, namedNodeMap, string, stringArray);
        SGDefaultColumnTypeUtility.getDefaultColumnTypesForSXYTypeArrayDataTickLabel(list, map, namedNodeMap, string, stringArray);
        for (n = 0; n < sGDataColumnInfoArray.length; ++n) {
            sGDataColumnInfoArray[n].setColumnType(stringArray[n]);
        }
        return true;
    }

    private static boolean getDefaultColumnTypesForSXYTypeArrayDataErrorBar(List<SGDataColumnInfo> list, Map<String, Object> map, NamedNodeMap namedNodeMap, String string, String[] stringArray) {
        Integer[] integerArray = SGDefaultColumnTypeUtility.getIndices(namedNodeMap, "LowerErrorBarIndices");
        Integer[] integerArray2 = SGDefaultColumnTypeUtility.getIndices(namedNodeMap, "UpperErrorBarIndices");
        Integer[] integerArray3 = SGDefaultColumnTypeUtility.getIndices(namedNodeMap, "ErrorBarHolderIndices");
        if (integerArray != null && integerArray2 != null && integerArray3 != null) {
            if (!SGDefaultColumnTypeUtility.checkIndices(integerArray, stringArray)) {
                return false;
            }
            if (!SGDefaultColumnTypeUtility.checkIndices(integerArray2, stringArray)) {
                return false;
            }
            if (!SGDefaultColumnTypeUtility.checkIndices(integerArray3, stringArray)) {
                return false;
            }
            if (integerArray3.length != integerArray.length || integerArray3.length != integerArray2.length) {
                return false;
            }
            for (int i = 0; i < integerArray3.length; ++i) {
                int n = integerArray3[i];
                SGDataColumnInfo sGDataColumnInfo = list.get(n);
                boolean bl = SGDefaultColumnTypeUtility.isEmptyTitle(list, n) || SGDefaultColumnTypeUtility.isRepeatedTitle(list, n);
                String string2 = sGDataColumnInfo.getTitle();
                if (integerArray[i] == integerArray2[i]) {
                    stringArray[integerArray[i].intValue()] = SGDataUtility.appendColumnNoOrTitle("Lower / Upper Error", n, bl, string2);
                    continue;
                }
                stringArray[integerArray[i].intValue()] = SGDataUtility.appendColumnNoOrTitle("Lower Error", n, bl, string2);
                stringArray[integerArray2[i].intValue()] = SGDataUtility.appendColumnNoOrTitle("Upper Error", n, bl, string2);
            }
        }
        return true;
    }

    private static boolean getDefaultColumnTypesForSXYTypeArrayDataTickLabel(List<SGDataColumnInfo> list, Map<String, Object> map, NamedNodeMap namedNodeMap, String string, String[] stringArray) {
        Integer[] integerArray = SGDefaultColumnTypeUtility.getIndices(namedNodeMap, "TickLabelIndices");
        Integer[] integerArray2 = SGDefaultColumnTypeUtility.getIndices(namedNodeMap, "TickLabelHolderIndices");
        if (integerArray != null && integerArray2 != null) {
            if (!SGDefaultColumnTypeUtility.checkIndices(integerArray, stringArray)) {
                return false;
            }
            if (!SGDefaultColumnTypeUtility.checkIndices(integerArray2, stringArray)) {
                return false;
            }
            if (integerArray.length != integerArray2.length) {
                return false;
            }
            for (int i = 0; i < integerArray2.length; ++i) {
                int n = integerArray2[i];
                SGDataColumnInfo sGDataColumnInfo = list.get(n);
                boolean bl = SGDefaultColumnTypeUtility.isEmptyTitle(list, n) || SGDefaultColumnTypeUtility.isRepeatedTitle(list, n);
                String string2 = sGDataColumnInfo.getTitle();
                stringArray[integerArray[i].intValue()] = SGDataUtility.appendColumnNoOrTitle("Tick Label", n, bl, string2);
            }
        }
        return true;
    }

    private static boolean getDefaultColumnTypesForVXYTypeArrayData(List<SGDataColumnInfo> list, int n, Map<String, Object> map, List<Integer> list2, List<Integer> list3, List<Integer> list4, List<Integer> list5, SGDataColumnInfo[] sGDataColumnInfoArray) {
        String[] stringArray = new String[sGDataColumnInfoArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "";
        }
        if (list2.size() >= 4) {
            Integer n2 = list2.get(0);
            Integer n3 = list2.get(1);
            Integer n4 = list2.get(2);
            Integer n5 = list2.get(3);
            stringArray[n2.intValue()] = "X-Coordinate";
            stringArray[n3.intValue()] = "Y-Coordinate";
            if (SGDataUtility.isPolar(map)) {
                stringArray[n4.intValue()] = "Magnitude";
                stringArray[n5.intValue()] = "Angle";
            } else {
                stringArray[n4.intValue()] = "X-Component";
                stringArray[n5.intValue()] = "Y-Component";
            }
        } else {
            return false;
        }
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            sGDataColumnInfoArray[i].setColumnType(stringArray[i]);
        }
        return true;
    }

    private static boolean getDefaultColumnTypesForVXYTypeArrayData(List<SGDataColumnInfo> list, Map<String, Object> map, NamedNodeMap namedNodeMap, String string, SGDataColumnInfo[] sGDataColumnInfoArray) {
        int n;
        String string2;
        String string3;
        int n2;
        String[] stringArray = new String[sGDataColumnInfoArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "";
        }
        Integer[] integerArray = SGDefaultColumnTypeUtility.getIndices(namedNodeMap, "XCoordinateIndex");
        if (integerArray == null) {
            return false;
        }
        if (integerArray.length != 1) {
            return false;
        }
        if (!SGDefaultColumnTypeUtility.checkIndices(integerArray, stringArray)) {
            return false;
        }
        Integer[] integerArray2 = SGDefaultColumnTypeUtility.getIndices(namedNodeMap, "YCoordinateIndex");
        if (integerArray2 == null) {
            return false;
        }
        if (integerArray2.length != 1) {
            return false;
        }
        if (!SGDefaultColumnTypeUtility.checkIndices(integerArray2, stringArray)) {
            return false;
        }
        Integer[] integerArray3 = SGDefaultColumnTypeUtility.getIndices(namedNodeMap, "ComponentIndex1");
        if (integerArray3 == null) {
            return false;
        }
        if (integerArray3.length != 1) {
            return false;
        }
        if (!SGDefaultColumnTypeUtility.checkIndices(integerArray3, stringArray)) {
            return false;
        }
        Integer[] integerArray4 = SGDefaultColumnTypeUtility.getIndices(namedNodeMap, "ComponentIndex2");
        if (integerArray4 == null) {
            return false;
        }
        if (integerArray4.length != 1) {
            return false;
        }
        if (!SGDefaultColumnTypeUtility.checkIndices(integerArray4, stringArray)) {
            return false;
        }
        for (n2 = 0; n2 < integerArray.length; ++n2) {
            stringArray[integerArray[n2].intValue()] = "X-Coordinate";
        }
        for (n2 = 0; n2 < integerArray2.length; ++n2) {
            stringArray[integerArray2[n2].intValue()] = "Y-Coordinate";
        }
        if (SGDataUtility.isPolar(map)) {
            string3 = "Magnitude";
            string2 = "Angle";
        } else {
            string3 = "X-Component";
            string2 = "Y-Component";
        }
        for (n = 0; n < integerArray3.length; ++n) {
            stringArray[integerArray3[n].intValue()] = string3;
        }
        for (n = 0; n < integerArray4.length; ++n) {
            stringArray[integerArray4[n].intValue()] = string2;
        }
        for (n = 0; n < sGDataColumnInfoArray.length; ++n) {
            sGDataColumnInfoArray[n].setColumnType(stringArray[n]);
        }
        return true;
    }

    private static boolean getDefaultColumnTypesForSXYZTypeArrayData(List<SGDataColumnInfo> list, int n, Map<String, Object> map, List<Integer> list2, List<Integer> list3, List<Integer> list4, List<Integer> list5, SGDataColumnInfo[] sGDataColumnInfoArray) {
        String[] stringArray = new String[sGDataColumnInfoArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "";
        }
        if (list2.size() < 3) {
            return false;
        }
        Integer n2 = list2.get(0);
        Integer n3 = list2.get(1);
        Integer n4 = list2.get(2);
        stringArray[n2.intValue()] = "X";
        stringArray[n3.intValue()] = "Y";
        stringArray[n4.intValue()] = "Z";
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            sGDataColumnInfoArray[i].setColumnType(stringArray[i]);
        }
        return true;
    }

    private static boolean getDefaultColumnTypesForSXYZTypeArrayData(List<SGDataColumnInfo> list, Map<String, Object> map, NamedNodeMap namedNodeMap, String string, SGDataColumnInfo[] sGDataColumnInfoArray) {
        int n;
        String[] stringArray = new String[sGDataColumnInfoArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "";
        }
        Integer[] integerArray = SGDefaultColumnTypeUtility.getIndices(namedNodeMap, "XValueIndex");
        if (integerArray == null) {
            return false;
        }
        if (integerArray.length != 1) {
            return false;
        }
        if (!SGDefaultColumnTypeUtility.checkIndices(integerArray, stringArray)) {
            return false;
        }
        Integer[] integerArray2 = SGDefaultColumnTypeUtility.getIndices(namedNodeMap, "YValueIndex");
        if (integerArray2 == null) {
            return false;
        }
        if (integerArray2.length != 1) {
            return false;
        }
        if (!SGDefaultColumnTypeUtility.checkIndices(integerArray2, stringArray)) {
            return false;
        }
        Integer[] integerArray3 = SGDefaultColumnTypeUtility.getIndices(namedNodeMap, "ZValueIndex");
        if (integerArray3 == null) {
            return false;
        }
        if (integerArray3.length != 1) {
            return false;
        }
        if (!SGDefaultColumnTypeUtility.checkIndices(integerArray3, stringArray)) {
            return false;
        }
        for (n = 0; n < integerArray.length; ++n) {
            stringArray[integerArray[n].intValue()] = "X";
        }
        for (n = 0; n < integerArray2.length; ++n) {
            stringArray[integerArray2[n].intValue()] = "Y";
        }
        for (n = 0; n < integerArray3.length; ++n) {
            stringArray[integerArray3[n].intValue()] = "Z";
        }
        for (n = 0; n < sGDataColumnInfoArray.length; ++n) {
            sGDataColumnInfoArray[n].setColumnType(stringArray[n]);
        }
        return true;
    }

    private static boolean isEmptyTitle(List<SGDataColumnInfo> list, int n) {
        SGDataColumnInfo sGDataColumnInfo = list.get(n);
        String string = sGDataColumnInfo.getTitle();
        return string == null || "".equals(string);
    }

    private static boolean isRepeatedTitle(List<SGDataColumnInfo> list, int n) {
        int n2;
        String[] stringArray = new String[list.size()];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            SGDataColumnInfo sGDataColumnInfo = list.get(n2);
            stringArray[n2] = sGDataColumnInfo.getTitle();
        }
        if (null == stringArray[n]) {
            return true;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (n == n2 || !stringArray[n].equals(stringArray[n2])) continue;
            return true;
        }
        return false;
    }

    private static Integer[] getIndices(NamedNodeMap namedNodeMap, String string) {
        Node node = namedNodeMap.getNamedItem(string);
        if (node == null) {
            return null;
        }
        String string2 = node.getNodeValue();
        if (string2 == null) {
            return null;
        }
        Integer[] integerArray = SGUtilityText.parseIndices(string2);
        return integerArray;
    }

    private static boolean checkIndices(Integer[] integerArray, String[] stringArray) {
        for (int i = 0; i < integerArray.length; ++i) {
            int n = integerArray[i];
            if (n >= 0 && n < stringArray.length) continue;
            return false;
        }
        return true;
    }

    private static boolean getDefaultColumnTypesForSXYTypeNetCDFData(Map<String, Object> map, List<SGVariable> list, int n, SGDataColumnInfo[] sGDataColumnInfoArray) {
        Object object;
        int n2;
        Object object2;
        int n3;
        int n4;
        String[] stringArray = new String[sGDataColumnInfoArray.length];
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            stringArray[n4] = "";
        }
        n4 = -1;
        Object object3 = null;
        for (n3 = 0; n3 < n; ++n3) {
            object2 = list.get(n3);
            if (!((SGVariable)object2).isUnlimited() || !((SGVariable)object2).isCoordinateVariable()) continue;
            n4 = n3;
            object3 = object2;
            break;
        }
        if (object3 == null) {
            for (n3 = 0; n3 < n; ++n3) {
                object2 = list.get(n3);
                if (!((SGVariable)object2).isCoordinateVariable()) continue;
                n4 = n3;
                object3 = object2;
                break;
            }
        }
        if (n4 == -1) {
            return false;
        }
        Boolean bl = (Boolean)map.get("Multiple");
        if (bl == null) {
            return false;
        }
        object2 = (Boolean)map.get("Graphs for multiple variables");
        if (object2 == null) {
            return false;
        }
        Integer[] integerArray = null;
        Dimension dimension = ((SGVariable)object3).getDimension(0);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n2 = 0; n2 < n; ++n2) {
            SGVariable sGVariable = list.get(n2);
            if (sGVariable.isCoordinateVariable() || !(object = sGVariable.getDimensions()).contains(dimension)) continue;
            arrayList.add(n2);
        }
        if (arrayList.size() == 0) {
            return false;
        }
        integerArray = new Integer[arrayList.size()];
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            integerArray[n2] = (Integer)arrayList.get(n2);
        }
        if (((Boolean)object2).booleanValue()) {
            stringArray[n4] = "X";
            if (bl.booleanValue()) {
                Integer[] integerArray2 = integerArray;
                int n5 = integerArray2.length;
                for (int i = 0; i < n5; ++i) {
                    int n6 = integerArray2[i];
                    stringArray[n6] = "Y";
                }
            } else {
                for (n2 = 0; n2 < integerArray.length; ++n2) {
                    int n7 = integerArray[n2];
                    object = list.get(n7);
                    if (object instanceof SGTextVariable) continue;
                    stringArray[n7] = "Y";
                    break;
                }
            }
        } else {
            n2 = integerArray[0];
            stringArray[n4] = "X";
            stringArray[n2] = "Y";
            int n8 = -1;
            object = list.get(n2);
            List<Dimension> list2 = ((SGVariable)object).getDimensions();
            for (int i = 0; i < list.size(); ++i) {
                Dimension dimension2;
                SGVariable sGVariable = list.get(i);
                if (!sGVariable.isCoordinateVariable() || dimension.equals((Object)(dimension2 = sGVariable.getDimension(0))) || !list2.contains(dimension2)) continue;
                n8 = i;
                break;
            }
            if (n8 != -1) {
                stringArray[n8] = "Pickup";
            } else {
                return false;
            }
        }
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            sGDataColumnInfoArray[i].setColumnType(stringArray[i]);
        }
        return true;
    }

    private static boolean getDefaultColumnTypesForSXYTypeNetCDFData(List<SGDataColumnInfo> list, Map<String, Object> map, NamedNodeMap namedNodeMap, String string, SGDataColumnInfo[] sGDataColumnInfoArray) {
        String[] stringArray;
        Boolean bl;
        String[] stringArray2;
        int n;
        String[] stringArray3;
        int n2;
        String[] stringArray4 = new String[sGDataColumnInfoArray.length];
        for (n2 = 0; n2 < stringArray4.length; ++n2) {
            stringArray4[n2] = "";
        }
        String[] stringArray5 = SGDefaultColumnTypeUtility.getNames(namedNodeMap, "SerialNumberVariableName", string);
        if (stringArray5 != null) {
            if (stringArray5.length != 1) {
                return false;
            }
            n2 = SGDefaultColumnTypeUtility.setNetCDFColumnType(list, stringArray4, stringArray5[0], "SerialNumbers");
            if (n2 == -1) {
                return false;
            }
        }
        if ((stringArray3 = SGDefaultColumnTypeUtility.getNames(namedNodeMap, new String[]{"XValueName", "XValueIndex"}, string)) == null && (stringArray3 = SGDefaultColumnTypeUtility.getNames(namedNodeMap, new String[]{"XValueNames", "XValueIndices"}, string)) == null) {
            return false;
        }
        if (stringArray3.length == 0) {
            return false;
        }
        String[] stringArray6 = SGDefaultColumnTypeUtility.getNames(namedNodeMap, new String[]{"YValueName", "YValueIndex"}, string);
        if (stringArray6 == null && (stringArray6 = SGDefaultColumnTypeUtility.getNames(namedNodeMap, new String[]{"YValueNames", "YValueIndices"}, string)) == null) {
            return false;
        }
        if (stringArray6.length == 0) {
            return false;
        }
        if (stringArray3.length > 1 && stringArray6.length > 1) {
            return false;
        }
        for (n = 0; n < stringArray3.length; ++n) {
            n2 = SGDefaultColumnTypeUtility.setNetCDFColumnType(list, stringArray4, stringArray3[n], "X");
            if (n2 != -1) continue;
            return false;
        }
        for (n = 0; n < stringArray6.length; ++n) {
            n2 = SGDefaultColumnTypeUtility.setNetCDFColumnType(list, stringArray4, stringArray6[n], "Y");
            if (n2 != -1) continue;
            return false;
        }
        String[] stringArray7 = SGDefaultColumnTypeUtility.getNames(namedNodeMap, new String[]{"LowerErrorValueNames", "LowerErrorBarIndices"}, string);
        String[] stringArray8 = SGDefaultColumnTypeUtility.getNames(namedNodeMap, new String[]{"UpperErrorValueNames", "UpperErrorBarIndices"}, string);
        String[] stringArray9 = SGDefaultColumnTypeUtility.getNames(namedNodeMap, new String[]{"ErrorBarHolderNames", "ErrorBarHolderIndices"}, string);
        if (stringArray7 != null && stringArray8 != null && stringArray9 != null) {
            int n3;
            if (stringArray9.length != stringArray7.length || stringArray9.length != stringArray8.length) {
                return false;
            }
            for (n3 = 0; n3 < stringArray9.length; ++n3) {
                n2 = SGDefaultColumnTypeUtility.findNetCDFColumnInfo(list, stringArray9[n3]);
                if (n2 != -1) continue;
                return false;
            }
            for (n3 = 0; n3 < stringArray9.length; ++n3) {
                n2 = SGDefaultColumnTypeUtility.setNetCDFColumnType(list, stringArray4, stringArray7[n3], stringArray9[n3], "Lower Error");
                if (n2 != -1) continue;
                return false;
            }
            for (n3 = 0; n3 < stringArray9.length; ++n3) {
                n2 = SGDefaultColumnTypeUtility.setNetCDFColumnType(list, stringArray4, stringArray8[n3], stringArray9[n3], "Upper Error");
                if (n2 != -1) continue;
                return false;
            }
        }
        String[] stringArray10 = SGDefaultColumnTypeUtility.getNames(namedNodeMap, new String[]{"TickLabelNames", "TickLabelIndices"}, string);
        String[] stringArray11 = SGDefaultColumnTypeUtility.getNames(namedNodeMap, new String[]{"TickLabelHolderNames", "TickLabelHolderIndices"}, string);
        if (stringArray10 != null && stringArray11 != null) {
            int n4;
            if (stringArray10.length != stringArray11.length) {
                return false;
            }
            for (n4 = 0; n4 < stringArray11.length; ++n4) {
                n2 = SGDefaultColumnTypeUtility.findNetCDFColumnInfo(list, stringArray11[n4]);
                if (n2 != -1) continue;
                return false;
            }
            for (n4 = 0; n4 < stringArray11.length; ++n4) {
                n2 = SGDefaultColumnTypeUtility.setNetCDFColumnType(list, stringArray4, stringArray10[n4], stringArray11[n4], "Tick Label");
                if (n2 != -1) continue;
                return false;
            }
        }
        if ((stringArray2 = SGDefaultColumnTypeUtility.getNames(namedNodeMap, "TimeVariableName", string)) != null) {
            if (stringArray2.length != 1) {
                return false;
            }
            n2 = SGDefaultColumnTypeUtility.setNetCDFColumnType(list, stringArray4, stringArray2[0], "Time");
            if (n2 == -1) {
                return false;
            }
        }
        if ((bl = (Boolean)map.get("Graphs for multiple variables")) != null && !bl.booleanValue() && (stringArray = SGDefaultColumnTypeUtility.getNames(namedNodeMap, "PickupDimensionName", string)) != null) {
            if (stringArray.length != 1) {
                return false;
            }
            n2 = SGDefaultColumnTypeUtility.setNetCDFColumnType(list, stringArray4, stringArray[0], "Pickup");
            if (n2 == -1) {
                return false;
            }
        }
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            sGDataColumnInfoArray[i].setColumnType(stringArray4[i]);
        }
        return true;
    }

    private static boolean getDefaultColumnTypesForVXYTypeNetCDFData(Map<String, Object> map, List<SGVariable> list, int n, SGDataColumnInfo[] sGDataColumnInfoArray) {
        Dimension dimension;
        Object object;
        int n2;
        int n3;
        String[] stringArray = new String[sGDataColumnInfoArray.length];
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            stringArray[n3] = "";
        }
        n3 = -1;
        int n4 = -1;
        int n5 = -1;
        SGVariable sGVariable = null;
        SGVariable sGVariable2 = null;
        int n6 = 0;
        int n7 = -1;
        int n8 = -1;
        List<Dimension> list2 = null;
        List<Dimension> list3 = null;
        for (n2 = 0; n2 < list.size() - 3; ++n2) {
            List<Dimension> list4;
            SGVariable sGVariable3;
            int n9;
            object = SGDefaultColumnTypeUtility.getNetCDFCoordinateVariableXYIndex(list, n6);
            if (object == null) {
                ++n6;
                continue;
            }
            n3 = object[0];
            n4 = object[1];
            sGVariable = list.get(n3);
            sGVariable2 = list.get(n4);
            dimension = sGVariable.getDimension(0);
            Dimension dimension2 = sGVariable2.getDimension(0);
            for (n9 = 0; n9 < n; ++n9) {
                sGVariable3 = list.get(n9);
                if (sGVariable3.isCoordinateVariable() || !(list4 = sGVariable3.getDimensions()).contains(dimension) || !list4.contains(dimension2)) continue;
                n7 = n9;
                list2 = list4;
                break;
            }
            if (n7 == -1 || n7 == n - 1) {
                ++n6;
                continue;
            }
            for (n9 = n7 + 1; n9 < n; ++n9) {
                sGVariable3 = list.get(n9);
                if (sGVariable3.isCoordinateVariable() || !(list4 = sGVariable3.getDimensions()).contains(dimension) || !list4.contains(dimension2)) continue;
                n8 = n9;
                list3 = list4;
                break;
            }
            if (n8 != -1) break;
            ++n6;
        }
        if (n7 == -1 || n8 == -1) {
            return false;
        }
        list2 = list.get(n7).getDimensions();
        list3 = list.get(n8).getDimensions();
        for (n2 = 0; n2 < n; ++n2) {
            if (n2 == n3 || n2 == n4 || n2 == n7 || n2 == n8 || !(object = (Object)list.get(n2)).isUnlimited() || !object.isCoordinateVariable()) continue;
            dimension = object.getDimension(0);
            if (!list2.contains(dimension) || !list3.contains(dimension)) break;
            n5 = n2;
            break;
        }
        stringArray[n3] = "X-Coordinate";
        stringArray[n4] = "Y-Coordinate";
        if (SGDataUtility.isPolar(map)) {
            stringArray[n7] = "Magnitude";
            stringArray[n8] = "Angle";
        } else {
            stringArray[n7] = "X-Component";
            stringArray[n8] = "Y-Component";
        }
        if (n5 != -1) {
            stringArray[n5] = "Time";
        }
        for (n2 = 0; n2 < sGDataColumnInfoArray.length; ++n2) {
            sGDataColumnInfoArray[n2].setColumnType(stringArray[n2]);
        }
        return true;
    }

    private static boolean getDefaultColumnTypesForVXYTypeNetCDFData(List<SGDataColumnInfo> list, Map<String, Object> map, NamedNodeMap namedNodeMap, String string, SGDataColumnInfo[] sGDataColumnInfoArray) {
        String string2;
        String string3;
        String[] stringArray;
        int n;
        String[] stringArray2 = new String[sGDataColumnInfoArray.length];
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray2[n] = "";
        }
        String[] stringArray3 = SGDefaultColumnTypeUtility.getNames(namedNodeMap, "SerialNumberVariableName", string);
        if (stringArray3 != null) {
            if (stringArray3.length != 1) {
                return false;
            }
            n = SGDefaultColumnTypeUtility.setNetCDFColumnType(list, stringArray2, stringArray3[0], "SerialNumbers");
            if (n == -1) {
                return false;
            }
        }
        if ((stringArray = SGDefaultColumnTypeUtility.getNames(namedNodeMap, new String[]{"XCoordinateVariableName", "XCoordinateIndex"}, string)) == null) {
            return false;
        }
        if (stringArray.length != 1) {
            return false;
        }
        n = SGDefaultColumnTypeUtility.setNetCDFColumnType(list, stringArray2, stringArray[0], "X-Coordinate");
        if (n == -1) {
            return false;
        }
        String[] stringArray4 = SGDefaultColumnTypeUtility.getNames(namedNodeMap, new String[]{"YCoordinateVariableName", "YCoordinateIndex"}, string);
        if (stringArray4 == null) {
            return false;
        }
        if (stringArray4.length != 1) {
            return false;
        }
        n = SGDefaultColumnTypeUtility.setNetCDFColumnType(list, stringArray2, stringArray4[0], "Y-Coordinate");
        if (n == -1) {
            return false;
        }
        boolean bl = SGDataUtility.isPolar(map);
        if (bl) {
            string3 = "Magnitude";
            string2 = "Angle";
        } else {
            string3 = "X-Component";
            string2 = "Y-Component";
        }
        String[] stringArray5 = SGDefaultColumnTypeUtility.getNames(namedNodeMap, new String[]{"FirstComponentVariableName", "ComponentIndex1"}, string);
        if (stringArray5 == null) {
            return false;
        }
        if (stringArray5.length != 1) {
            return false;
        }
        n = SGDefaultColumnTypeUtility.setNetCDFColumnType(list, stringArray2, stringArray5[0], string3);
        if (n == -1) {
            return false;
        }
        String[] stringArray6 = SGDefaultColumnTypeUtility.getNames(namedNodeMap, new String[]{"SecondComponentVariableName", "ComponentIndex2"}, string);
        if (stringArray6 == null) {
            return false;
        }
        if (stringArray6.length != 1) {
            return false;
        }
        n = SGDefaultColumnTypeUtility.setNetCDFColumnType(list, stringArray2, stringArray6[0], string2);
        if (n == -1) {
            return false;
        }
        String[] stringArray7 = SGDefaultColumnTypeUtility.getNames(namedNodeMap, "TimeVariableName", string);
        if (stringArray7 != null) {
            if (stringArray7.length != 1) {
                return false;
            }
            n = SGDefaultColumnTypeUtility.setNetCDFColumnType(list, stringArray2, stringArray7[0], "Time");
            if (n == -1) {
                return false;
            }
        }
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            sGDataColumnInfoArray[i].setColumnType(stringArray2[i]);
        }
        return true;
    }

    private static boolean getDefaultColumnTypesForSXYZTypeNetCDFData(Map<String, Object> map, List<SGVariable> list, int n, SGDataColumnInfo[] sGDataColumnInfoArray) {
        Dimension dimension;
        Object object;
        int n2;
        int n3;
        String[] stringArray = new String[sGDataColumnInfoArray.length];
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            stringArray[n3] = "";
        }
        n3 = -1;
        int n4 = -1;
        int n5 = -1;
        SGVariable sGVariable = null;
        SGVariable sGVariable2 = null;
        int n6 = 0;
        int n7 = -1;
        List<Dimension> list2 = null;
        for (n2 = 0; n2 < list.size() - 2; ++n2) {
            object = SGDefaultColumnTypeUtility.getNetCDFCoordinateVariableXYIndex(list, n6);
            if (object == null) {
                ++n6;
                continue;
            }
            n3 = object[0];
            n4 = object[1];
            sGVariable = list.get(n3);
            sGVariable2 = list.get(n4);
            dimension = sGVariable.getDimension(0);
            Dimension dimension2 = sGVariable2.getDimension(0);
            for (int i = 0; i < n; ++i) {
                List<Dimension> list3;
                SGVariable sGVariable3 = list.get(i);
                if (sGVariable3.isCoordinateVariable() || !(list3 = sGVariable3.getDimensions()).contains(dimension) || !list3.contains(dimension2)) continue;
                n7 = i;
                break;
            }
            if (n7 != -1) break;
            ++n6;
        }
        if (n7 == -1) {
            return false;
        }
        list2 = list.get(n7).getDimensions();
        for (n2 = 0; n2 < n; ++n2) {
            if (n2 == n3 || n2 == n4 || n2 == n7 || !(object = (Object)list.get(n2)).isUnlimited() || !object.isCoordinateVariable()) continue;
            dimension = object.getDimension(0);
            if (!list2.contains(dimension)) break;
            n5 = n2;
            break;
        }
        stringArray[n3] = "X";
        stringArray[n4] = "Y";
        stringArray[n7] = "Z";
        if (n5 != -1) {
            stringArray[n5] = "Time";
        }
        for (n2 = 0; n2 < sGDataColumnInfoArray.length; ++n2) {
            sGDataColumnInfoArray[n2].setColumnType(stringArray[n2]);
        }
        return true;
    }

    private static boolean getDefaultColumnTypesForSXYZTypeNetCDFData(List<SGDataColumnInfo> list, Map<String, Object> map, NamedNodeMap namedNodeMap, String string, SGDataColumnInfo[] sGDataColumnInfoArray) {
        String[] stringArray;
        int n;
        String[] stringArray2 = new String[sGDataColumnInfoArray.length];
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray2[n] = "";
        }
        String[] stringArray3 = SGDefaultColumnTypeUtility.getNames(namedNodeMap, "SerialNumberVariableName", string);
        if (stringArray3 != null) {
            if (stringArray3.length != 1) {
                return false;
            }
            n = SGDefaultColumnTypeUtility.setNetCDFColumnType(list, stringArray2, stringArray3[0], "SerialNumbers");
            if (n == -1) {
                return false;
            }
        }
        if ((stringArray = SGDefaultColumnTypeUtility.getNames(namedNodeMap, new String[]{"XValueName", "XValueIndex"}, string)) == null) {
            return false;
        }
        if (stringArray.length != 1) {
            return false;
        }
        n = SGDefaultColumnTypeUtility.setNetCDFColumnType(list, stringArray2, stringArray[0], "X");
        if (n == -1) {
            return false;
        }
        String[] stringArray4 = SGDefaultColumnTypeUtility.getNames(namedNodeMap, new String[]{"YValueName", "YValueIndex"}, string);
        if (stringArray4 == null) {
            return false;
        }
        if (stringArray4.length != 1) {
            return false;
        }
        n = SGDefaultColumnTypeUtility.setNetCDFColumnType(list, stringArray2, stringArray4[0], "Y");
        if (n == -1) {
            return false;
        }
        String[] stringArray5 = SGDefaultColumnTypeUtility.getNames(namedNodeMap, new String[]{"ZValueName", "ZValueIndex"}, string);
        if (stringArray5 == null) {
            return false;
        }
        if (stringArray5.length != 1) {
            return false;
        }
        n = SGDefaultColumnTypeUtility.setNetCDFColumnType(list, stringArray2, stringArray5[0], "Z");
        if (n == -1) {
            return false;
        }
        String[] stringArray6 = SGDefaultColumnTypeUtility.getNames(namedNodeMap, "TimeVariableName", string);
        if (stringArray6 != null) {
            if (stringArray6.length != 1) {
                return false;
            }
            n = SGDefaultColumnTypeUtility.setNetCDFColumnType(list, stringArray2, stringArray6[0], "Time");
            if (n == -1) {
                return false;
            }
        }
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            sGDataColumnInfoArray[i].setColumnType(stringArray2[i]);
        }
        return true;
    }

    private static int[] getNetCDFCoordinateVariableXYIndex(List<SGVariable> list, int n) {
        int n2 = list.size();
        int n3 = -1;
        int n4 = -1;
        n3 = SGDefaultColumnTypeUtility.getNetCDFCoordinateVariableIndexWithoutUnlimited(list, n);
        if (n3 == -1 || n3 == n2 - 1) {
            n3 = SGDefaultColumnTypeUtility.getNetCDFCoordinateVariableIndex(list, n);
        }
        if (n3 == -1 || n3 == n2 - 1) {
            return null;
        }
        n4 = SGDefaultColumnTypeUtility.getNetCDFCoordinateVariableIndexWithoutUnlimited(list, n3 + 1);
        if (n4 == -1) {
            n4 = SGDefaultColumnTypeUtility.getNetCDFCoordinateVariableIndex(list, n3 + 1);
        }
        if (n4 == -1) {
            return null;
        }
        return new int[]{n3, n4};
    }

    private static int getNetCDFCoordinateVariableIndex(List<SGVariable> list, int n) {
        int n2 = list.size();
        int n3 = -1;
        for (int i = n; i < n2; ++i) {
            SGVariable sGVariable = list.get(i);
            if (!sGVariable.isCoordinateVariable()) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    private static int setNetCDFColumnType(List<SGDataColumnInfo> list, String[] stringArray, String string, String string2) {
        int n = SGDefaultColumnTypeUtility.findNetCDFColumnInfo(list, string);
        if (n != -1) {
            if (n < 0 || n >= stringArray.length) {
                return -1;
            }
            stringArray[n] = string2;
        }
        return n;
    }

    private static int setNetCDFColumnType(List<SGDataColumnInfo> list, String[] stringArray, String string, String string2, String string3) {
        int n = SGDefaultColumnTypeUtility.findNetCDFColumnInfo(list, string);
        if (n != -1) {
            if (n < 0 || n >= stringArray.length) {
                return -1;
            }
            stringArray[n] = SGDataUtility.appendColumnTitle(string3, string2);
        }
        return n;
    }

    private static int findNetCDFColumnInfo(List<SGDataColumnInfo> list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            SGNetCDFDataColumnInfo sGNetCDFDataColumnInfo = (SGNetCDFDataColumnInfo)list.get(i);
            if (!sGNetCDFDataColumnInfo.getVariableName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    private static int getNetCDFCoordinateVariableIndexWithoutUnlimited(List<SGVariable> list, int n) {
        int n2 = list.size();
        int n3 = -1;
        for (int i = n; i < n2; ++i) {
            SGVariable sGVariable = list.get(i);
            if (!sGVariable.isCoordinateVariable() || sGVariable.isUnlimited()) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    private static String[] getNames(NamedNodeMap namedNodeMap, String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = SGDefaultColumnTypeUtility.getNames(namedNodeMap, stringArray[i], string);
            if (stringArray2 == null) continue;
            return stringArray2;
        }
        return null;
    }

    private static String[] getNames(NamedNodeMap namedNodeMap, String string, String string2) {
        String string3 = SGDefaultColumnTypeUtility.getString(namedNodeMap, string);
        if (string3 == null) {
            return null;
        }
        String[] stringArray = SGUtilityText.parseStrings(string3);
        if (string2 != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = SGDataUtility.appendGroupName(stringArray[i], string2);
            }
        }
        return stringArray;
    }

    private static String getString(NamedNodeMap namedNodeMap, String string) {
        Node node = namedNodeMap.getNamedItem(string);
        if (node == null) {
            return null;
        }
        String string2 = node.getNodeValue();
        if (string2 == null) {
            return null;
        }
        return string2;
    }

    public static Map<String, Integer> getOriginMap(NamedNodeMap namedNodeMap) {
        String string;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (namedNodeMap != null && (string = SGDefaultColumnTypeUtility.getString(namedNodeMap, "Origin")) != null) {
            String[][] stringArray = SGUtilityText.readStringMaps(string);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i][0];
                String string3 = stringArray[i][1];
                Integer n = SGUtilityText.getInteger(string3);
                if (n == null) {
                    return new HashMap<String, Integer>();
                }
                hashMap.put(string2, n);
            }
        }
        return hashMap;
    }

    public static class DefaultColumnTypeResult {
        private boolean mSucceeded = false;
        private String[] mColumnTypes = null;

        public DefaultColumnTypeResult(String[] stringArray, boolean bl) {
            if (stringArray == null) {
                throw new IllegalArgumentException("columnTypes == null");
            }
            this.mColumnTypes = stringArray;
            this.mSucceeded = bl;
        }

        public String[] getDefaultColumnTypes() {
            return (String[])this.mColumnTypes.clone();
        }

        public boolean isSucceeded() {
            return this.mSucceeded;
        }
    }
}

