/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGDate;
import jp.riken.brain.ni.samuraigraph.data.SGVariable;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGDateVariable
extends SGVariable {
    private SGDate[] mDate = null;

    public SGDateVariable(Variable variable, String[] stringArray) {
        super(variable);
        if (stringArray == null) {
            throw new IllegalArgumentException("stringArray == null");
        }
        try {
            this.mDate = new SGDate[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.mDate[i] = new SGDate(stringArray[i].trim());
            }
        }
        catch (ParseException parseException) {
            this.mDate = null;
        }
    }

    public SGDate[] getDate() {
        if (this.mDate == null) {
            return null;
        }
        return (SGDate[])this.mDate.clone();
    }

    public double[] getNumberArray() {
        if (this.mDate == null) {
            return null;
        }
        return SGDataUtility.getDateValueArray(this.mDate);
    }

    public String[] getStringArray() {
        if (this.mDate == null) {
            return null;
        }
        String[] stringArray = new String[this.mDate.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.mDate[i].toString();
        }
        return stringArray;
    }

    @Override
    public String getValueType() {
        return "Date";
    }

    @Override
    public List<Dimension> getDimensions() {
        List<Dimension> list = super.getDimensions();
        return new ArrayList<Dimension>(list.subList(0, 1));
    }

    @Override
    public Dimension getDimension(int n) {
        if (n > 0) {
            return null;
        }
        return this.mVariable.getDimension(n);
    }

    @Override
    public Array read(int[] nArray, int[] nArray2) throws InvalidRangeException, IOException {
        return null;
    }
}

