/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import jp.riken.brain.ni.samuraigraph.data.SGDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGDate;
import jp.riken.brain.ni.samuraigraph.data.SGINumberDataColumn;

public class SGDateDataColumn
extends SGDataColumn
implements SGINumberDataColumn {
    protected SGDate[] mArray = null;
    private String[] mStringArray = null;

    public SGDateDataColumn(String string, SGDate[] sGDateArray) {
        super(string);
        if (sGDateArray == null) {
            throw new IllegalArgumentException("array == null");
        }
        SGDate[] sGDateArray2 = new SGDate[sGDateArray.length];
        System.arraycopy(sGDateArray, 0, sGDateArray2, 0, sGDateArray.length);
        this.mArray = sGDateArray2;
    }

    public int getLength() {
        return this.mArray.length;
    }

    public String getValueType() {
        return "Date";
    }

    public void dispose() {
        super.dispose();
        this.mArray = null;
        this.mStringArray = null;
    }

    SGDate[] getDateArray() {
        return this.mArray;
    }

    public Object getValue(int n) {
        if (n > this.mArray.length) {
            throw new IllegalArgumentException("Index out of bounds: " + n + " > " + this.mArray.length);
        }
        return this.mArray[n];
    }

    public String[] getStringArray() {
        if (this.mStringArray == null) {
            String[] stringArray = new String[this.mArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.mArray[i].toString();
            }
            this.mStringArray = stringArray;
        }
        return (String[])this.mStringArray.clone();
    }

    public Object clone() {
        SGDateDataColumn sGDateDataColumn = (SGDateDataColumn)super.clone();
        sGDateDataColumn.mStringArray = null;
        return sGDateDataColumn;
    }

    protected Object getExportedValue(int n) {
        Object object = this.getValue(n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        stringBuffer.append(object.toString());
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public double[] getNumberArray() {
        SGDate[] sGDateArray = this.getDateArray();
        return SGDataUtility.getDateValueArray(sGDateArray);
    }
}

