/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfoSet;
import jp.riken.brain.ni.samuraigraph.data.SGDataTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGDefaultColumnTypeUtility;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGIDataSetupTableHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SGDataColumnSelectionPanel
extends JPanel
implements SGIDataColumnTypeConstants,
MouseWheelListener,
ActionListener,
PropertyChangeListener,
SGIDataSetupTableHolder {
    private static final long serialVersionUID = 4393429488857680488L;
    private JPanel mButtonPanel;
    private SGButton mClearButton;
    private SGButton mComplementButton;
    private JLabel mDataTypeLabel;
    private JPanel mDataTypePanel;
    private SGButton mRestoreButton;
    protected JTable mTable;
    private JScrollPane mTableScrollPane;
    public static final int ROW_HEIGHT = 20;
    protected static final int SCROLL_BAR_UNIT_INCREMENT = 20;
    protected static final int SCROLL_BAR_BLOCK_INCREMENT = 80;
    protected static final int COLUMN_TYPE_COMBOX_MIN_WIDTH = 200;
    protected DataColumnTableModel mTableModel = null;
    public static final String COLUMN_NAME_NUMBER = "No.";
    public static final String COLUMN_NAME_TITLE = "Title";
    public static final String COLUMN_NAME_VALUE_TYPE = "Value Type";
    public static final String COLUMN_NAME_COLUMN_TYPE = "Column Type";
    protected String mDataType = null;
    protected List<SGDataColumnInfo> mColumnInfoList = new ArrayList<SGDataColumnInfo>();
    protected Map<String, Object> mDataInfoMap = null;
    protected boolean mShowDefaultFlag = false;
    protected JComboBox mRendererComboBox = null;
    protected JComboBox mEditorComboBox = null;

    public SGDataColumnSelectionPanel() {
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mTableScrollPane = new JScrollPane();
        this.mTable = this.createTableInstance();
        this.mButtonPanel = new JPanel();
        this.mComplementButton = new SGButton();
        this.mRestoreButton = new SGButton();
        this.mClearButton = new SGButton();
        this.mDataTypePanel = new JPanel();
        this.mDataTypeLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.mTableScrollPane.setBorder(null);
        this.mTableScrollPane.setHorizontalScrollBarPolicy(31);
        this.mTableScrollPane.setFont(new Font("Dialog", 0, 11));
        this.mTableScrollPane.setPreferredSize(new Dimension(434, 120));
        this.mTable.setFont(new Font("Dialog", 0, 11));
        this.mTableScrollPane.setViewportView(this.mTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.mTableScrollPane, gridBagConstraints);
        this.mComplementButton.setText("Complement");
        this.mComplementButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mComplementButton);
        this.mRestoreButton.setText("Restore");
        this.mRestoreButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mRestoreButton);
        this.mClearButton.setText("Clear");
        this.mClearButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mClearButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.add((Component)this.mButtonPanel, gridBagConstraints);
        this.mDataTypePanel.setBorder(BorderFactory.createTitledBorder(null, "Data Type", 0, 0, new Font("Dialog", 1, 12)));
        this.mDataTypePanel.setLayout(new GridBagLayout());
        this.mDataTypeLabel.setFont(new Font("Dialog", 0, 12));
        this.mDataTypeLabel.setHorizontalAlignment(0);
        this.mDataTypeLabel.setText("                ");
        this.mDataTypeLabel.setPreferredSize(new Dimension(120, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        this.mDataTypePanel.add((Component)this.mDataTypeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.mDataTypePanel, gridBagConstraints);
    }

    protected abstract String[] getColumnNameArray();

    protected abstract int[] getPreferredColumnWidthArray();

    protected abstract DataColumnTableModel createTableModel();

    protected void initTableModel() {
        this.mTableModel = this.createTableModel();
        this.mTableModel.setColumnIdentifiers(this.getColumnNameArray());
        this.mTable.setModel(this.mTableModel);
    }

    @Override
    public JTable getTable() {
        return this.mTable;
    }

    private JComboBox createComboBoxInstance() {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setBorder(BorderFactory.createEmptyBorder());
        return jComboBox;
    }

    private void initProperty() {
        this.mRestoreButton.setEnabled(false);
        this.mClearButton.setEnabled(false);
        this.mComplementButton.setEnabled(false);
        this.initTableModel();
        this.mTable.setRowHeight(20);
        this.mEditorComboBox = this.createComboBoxInstance();
        this.mRendererComboBox = this.createComboBoxInstance();
        ComboBoxWidthAdjuster comboBoxWidthAdjuster = new ComboBoxWidthAdjuster(200);
        this.mEditorComboBox.addPopupMenuListener(comboBoxWidthAdjuster);
        this.mRendererComboBox.addPopupMenuListener(comboBoxWidthAdjuster);
        this.mEditorComboBox.setMaximumRowCount(12);
        this.mRendererComboBox.setMaximumRowCount(12);
        this.mTable.addMouseWheelListener(this);
        this.mClearButton.addActionListener(this);
        this.mRestoreButton.addActionListener(this);
        this.mComplementButton.addActionListener(this);
        this.mTable.addPropertyChangeListener(this);
        JScrollBar jScrollBar = this.mTableScrollPane.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(20);
        jScrollBar.setBlockIncrement(80);
    }

    @Override
    public void clear() {
        this.mDataType = null;
        this.mDataTypeLabel.setText("");
        this.mColumnInfoList.clear();
        this.mDataInfoMap = null;
        this.initTableModel();
        this.updateTable();
    }

    @Override
    public void updateTable() {
        this.setPreferredColumnWidth();
    }

    private void setPreferredColumnWidth() {
        String[] stringArray = this.getColumnNameArray();
        int[] nArray = this.getPreferredColumnWidthArray();
        for (int i = 0; i < stringArray.length; ++i) {
            TableColumn tableColumn = this.mTable.getColumn(stringArray[i]);
            tableColumn.setPreferredWidth(nArray[i]);
        }
    }

    @Override
    public void setDataType(String string) {
        if (string == null) {
            throw new IllegalArgumentException("dataType == null");
        }
        this.mDataType = string;
        String string2 = SGDataTypeConstants.getLongDataTypeConstant(string);
        this.mDataTypeLabel.setText(string2);
        this.mDataTypeLabel.setToolTipText(string2);
    }

    protected abstract String[] getDataTypeArray();

    public boolean setData(String string, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map, boolean bl) {
        Object object;
        int n;
        if (string == null || sGDataColumnInfoSet == null) {
            throw new IllegalArgumentException("dataType == null || colInfoSet == null");
        }
        String[] stringArray = this.getDataTypeArray();
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            throw new IllegalArgumentException("Data type is not supported: " + string);
        }
        this.clear();
        this.setDataType(string);
        SGDataColumnInfo[] sGDataColumnInfoArray = sGDataColumnInfoSet.getDataColumnInfoArray();
        this.mColumnInfoList.clear();
        for (n = 0; n < sGDataColumnInfoArray.length; ++n) {
            object = (SGDataColumnInfo)sGDataColumnInfoArray[n].clone();
            this.mColumnInfoList.add((SGDataColumnInfo)object);
        }
        this.mDataInfoMap = map;
        this.mShowDefaultFlag = bl;
        n = this.getColumnIndex(COLUMN_NAME_COLUMN_TYPE);
        object = this.mTable.getColumnModel().getColumn(n);
        ((TableColumn)object).setCellEditor(new DataColumnCellEditor(this.mEditorComboBox));
        ((TableColumn)object).setCellRenderer(new DataColumnCellRenderer());
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            SGDataColumnInfo sGDataColumnInfo = this.mColumnInfoList.get(i);
            this.mTableModel.addData(i, sGDataColumnInfo);
        }
        if (bl && !this.setDefaultColumnType()) {
            return false;
        }
        this.mRestoreButton.setEnabled(true);
        this.mClearButton.setEnabled(true);
        this.mComplementButton.setEnabled(true);
        if (!map.containsKey("DataType")) {
            map.put("DataType", string);
        }
        this.mComplementButton.setVisible(false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SGDataColumnSelectionPanel.this.mTableScrollPane.getVerticalScrollBar().setValue(0);
            }
        });
        return true;
    }

    protected List<SGDataColumnInfo> getColumnInfoList() {
        ArrayList<SGDataColumnInfo> arrayList = new ArrayList<SGDataColumnInfo>(this.mColumnInfoList);
        return arrayList;
    }

    protected boolean setDefaultColumnType() {
        int n;
        int n2 = this.getColumnIndex(COLUMN_NAME_COLUMN_TYPE);
        SGDefaultColumnTypeUtility.DefaultColumnTypeResult defaultColumnTypeResult = SGDefaultColumnTypeUtility.getDefaultColumnTypes(this.mDataType, this.getColumnInfoList(), this.mDataInfoMap);
        String[] stringArray = defaultColumnTypeResult.getDefaultColumnTypes();
        for (n = 0; n < stringArray.length; ++n) {
            this.mTable.setValueAt(stringArray[n], n, n2);
        }
        for (n = 0; n < this.mColumnInfoList.size(); ++n) {
            SGDataColumnInfo sGDataColumnInfo = this.mColumnInfoList.get(n);
            sGDataColumnInfo.setColumnType(stringArray[n]);
        }
        return defaultColumnTypeResult.isSucceeded();
    }

    @Override
    public abstract boolean checkSelectedItems();

    public boolean updateSelectedItems() {
        int n = this.getColumnInfoList().size();
        int n2 = this.getColumnIndex(COLUMN_NAME_COLUMN_TYPE);
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)this.mTable.getValueAt(i, n2);
        }
        String[] stringArray2 = SGDataUtility.updateDataColumns(this.mDataType, this.mColumnInfoList.toArray(new SGDataColumnInfo[this.mColumnInfoList.size()]), stringArray);
        if (stringArray2 == null) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            this.mTable.setValueAt(stringArray2[i], i, n2);
        }
        return true;
    }

    public int getColumnIndex(String string) {
        return this.mTable.getColumnModel().getColumnIndex(string);
    }

    @Override
    public void setVisible(boolean bl) {
        if (!bl) {
            if (this.mEditorComboBox != null) {
                this.mEditorComboBox.removeAllItems();
            }
            if (this.mRendererComboBox != null) {
                this.mRendererComboBox.removeAllItems();
            }
        }
        super.setVisible(bl);
    }

    public SGDataColumnInfo[] getDataColumnTypes() {
        SGDataColumnInfoSet sGDataColumnInfoSet = this.getDataColumnInfoSet();
        return sGDataColumnInfoSet.getDataColumnInfoArray();
    }

    @Override
    public SGDataColumnInfoSet getDataColumnInfoSet() {
        int n = this.getColumnIndex(COLUMN_NAME_COLUMN_TYPE);
        SGDataColumnInfo[] sGDataColumnInfoArray = new SGDataColumnInfo[this.mColumnInfoList.size()];
        for (int i = 0; i < this.mColumnInfoList.size(); ++i) {
            SGDataColumnInfo sGDataColumnInfo = this.mColumnInfoList.get(i);
            String string = (String)this.mTable.getValueAt(i, n);
            sGDataColumnInfoArray[i] = (SGDataColumnInfo)sGDataColumnInfo.clone();
            sGDataColumnInfoArray[i].setColumnType(string);
        }
        SGDataColumnInfoSet sGDataColumnInfoSet = new SGDataColumnInfoSet(sGDataColumnInfoArray);
        return sGDataColumnInfoSet;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getScrollAmount() * mouseWheelEvent.getWheelRotation();
        JScrollBar jScrollBar = this.mTableScrollPane.getVerticalScrollBar();
        int n2 = jScrollBar.getValue() + n * 6;
        jScrollBar.setValue(n2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.mClearButton)) {
            int n = this.getColumnIndex(COLUMN_NAME_COLUMN_TYPE);
            int n2 = this.mTable.getRowCount();
            for (int i = 0; i < n2; ++i) {
                this.mTable.setValueAt("", i, n);
            }
            this.mEditorComboBox.setSelectedItem("");
            this.mRendererComboBox.setSelectedItem("");
            this.updateComponentsEnabled();
        } else if (object.equals(this.mRestoreButton)) {
            Object object2;
            int n;
            int n3 = this.getColumnIndex(COLUMN_NAME_COLUMN_TYPE);
            if (this.mShowDefaultFlag) {
                this.setDefaultColumnType();
            } else {
                n = this.mTable.getRowCount();
                object2 = this.getColumnInfoList();
                for (int i = 0; i < n; ++i) {
                    SGDataColumnInfo sGDataColumnInfo = object2.get(i);
                    this.mTable.setValueAt(sGDataColumnInfo.getColumnType(), i, n3);
                }
            }
            n = this.mTable.getEditingRow();
            if (n != -1) {
                object2 = this.mTable.getValueAt(n, n3);
                this.mEditorComboBox.setSelectedItem(object2);
                this.mRendererComboBox.setSelectedItem(object2);
            }
            this.updateComponentsEnabled();
        } else if (object.equals(this.mComplementButton)) {
            int n = this.getColumnIndex(COLUMN_NAME_COLUMN_TYPE);
            int n4 = this.mTable.getRowCount();
            String[] stringArray = new String[n4];
            for (int i = 0; i < n4; ++i) {
                Object object3 = this.mTable.getValueAt(i, n);
                stringArray[i] = object3 == null ? "" : object3.toString();
            }
            String[] stringArray2 = SGDataUtility.getComplementedColumnType(this.mDataInfoMap, stringArray, this.getColumnInfoList());
            for (int i = 0; i < n4; ++i) {
                this.mTable.setValueAt(stringArray2[i], i, n);
            }
            this.updateComponentsEnabled();
        }
    }

    @Override
    public SGButton getRestoreButton() {
        return this.mRestoreButton;
    }

    @Override
    public SGButton getClearButton() {
        return this.mClearButton;
    }

    @Override
    public SGButton getComplementButton() {
        return this.mComplementButton;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        Object object = propertyChangeEvent.getSource();
        if (object.equals(this.getTable()) && "tableCellEditor".equals(string = propertyChangeEvent.getPropertyName())) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SGDataColumnSelectionPanel.this.updateComponentsEnabled();
                }
            });
        }
    }

    private void updateComponentsEnabled() {
        boolean bl;
        SGDataColumnInfoSet sGDataColumnInfoSet = this.getDataColumnInfoSet();
        SGDataColumnInfo[] sGDataColumnInfoArray = sGDataColumnInfoSet.getDataColumnInfoArray();
        String[] stringArray = new String[sGDataColumnInfoArray.length];
        for (bl = false; bl < stringArray.length; bl += 1) {
            stringArray[bl] = sGDataColumnInfoArray[bl].getColumnType();
        }
        bl = SGDataUtility.isComplementedButtonEnabled(this.mDataInfoMap, stringArray, this.mColumnInfoList);
        this.getComplementButton().setEnabled(bl);
    }

    protected abstract JTable createTableInstance();

    protected static class ComboBoxWidthAdjuster
    implements PopupMenuListener {
        private int mMinWidth = 0;
        private boolean mAdjustingFlag = false;

        public ComboBoxWidthAdjuster(int n) {
            this.setMinWidth(n);
        }

        public void setMinWidth(int n) {
            if (n < 0) {
                n = 0;
            }
            this.mMinWidth = n;
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            JComboBox jComboBox = (JComboBox)popupMenuEvent.getSource();
            Dimension dimension = jComboBox.getSize();
            if (dimension.width >= this.mMinWidth) {
                return;
            }
            if (!this.mAdjustingFlag) {
                this.mAdjustingFlag = true;
                jComboBox.setSize(this.mMinWidth, dimension.height);
                jComboBox.showPopup();
            }
            jComboBox.setSize(dimension);
            this.mAdjustingFlag = false;
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }

    protected class DataColumnCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 4333550774377195466L;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color;
            Color color2;
            SGDataColumnSelectionPanel.this.mRendererComboBox.removeAllItems();
            SGDataColumnSelectionPanel.this.mRendererComboBox.addItem(object);
            if (bl) {
                color2 = jTable.getSelectionBackground();
                color = jTable.getSelectionForeground();
            } else {
                color2 = jTable.getBackground();
                color = jTable.getForeground();
            }
            SGDataColumnSelectionPanel.this.mRendererComboBox.setBackground(color2);
            SGDataColumnSelectionPanel.this.mRendererComboBox.setForeground(color);
            String string = object == null || "".equals(object) ? null : object.toString();
            SGDataColumnSelectionPanel.this.mRendererComboBox.setToolTipText(string);
            return SGDataColumnSelectionPanel.this.mRendererComboBox;
        }
    }

    protected class DataColumnCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1310814500603128330L;

        public DataColumnCellEditor(JComboBox jComboBox) {
            super(jComboBox);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            SGDataColumnInfo sGDataColumnInfo = SGDataColumnSelectionPanel.this.getColumnInfoList().get(n);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(SGDataColumnSelectionPanel.this.mDataInfoMap);
            hashMap.put("Current Row Index", n);
            String string = sGDataColumnInfo.getValueType();
            Map<String, Object> map = SGDataUtility.updateInfoMap(SGDataColumnSelectionPanel.this.mDataType, SGDataColumnSelectionPanel.this.getDataColumnTypes(), hashMap);
            String[] stringArray = SGDataUtility.getColumnTypeCandidates(SGDataColumnSelectionPanel.this.mDataType, map, string);
            JComboBox jComboBox = (JComboBox)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            jComboBox.removeAllItems();
            for (int i = 0; i < stringArray.length; ++i) {
                jComboBox.addItem(stringArray[i]);
            }
            jComboBox.setSelectedItem(object);
            return jComboBox;
        }
    }

    protected abstract class DataColumnTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 2213043296565029421L;

        public boolean isCellEditable(int n, int n2) {
            return SGDataColumnSelectionPanel.COLUMN_NAME_COLUMN_TYPE.equals(this.getColumnName(n2));
        }

        protected abstract void addData(int var1, SGDataColumnInfo var2);

        public int getColumnCount() {
            return SGDataColumnSelectionPanel.this.getColumnNameArray().length;
        }

        public String getColumnName(int n) {
            return SGDataColumnSelectionPanel.this.getColumnNameArray()[n];
        }
    }
}

