/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.riken.brain.ni.samuraigraph.base.SGAnimationThread;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGCheckBox;
import jp.riken.brain.ni.samuraigraph.base.SGComboBox;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;
import jp.riken.brain.ni.samuraigraph.base.SGIAnimationConstants;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.data.SGDataAnimationThread;
import jp.riken.brain.ni.samuraigraph.data.SGIDataAnimation;

public class SGDataAnimationConfigurationDialog
extends SGDialog
implements SGIAnimationConstants,
ItemListener,
ChangeListener,
SGAnimationThread.AnimationThreadObserver,
MouseListener {
    private static final long serialVersionUID = -422924558519688171L;
    public static final String TITLE = "Setup the Animation";
    private SGButton mBeginningButton;
    private JPanel mButtonPanel;
    private SGButton mCloseButton;
    private SGButton mEndingButton;
    private JLabel mEqualLabel;
    private SGCheckBox mLoopPlaybackCheckBox;
    private JLabel mNameLabel;
    private SGButton mNextButton;
    private SGButton mPauseButton;
    private SGButton mPlayButton;
    private JPanel mPlayerButtonPanel;
    private SGButton mPreviousButton;
    private SGButton mRestoreButton;
    private JLabel mSecondLabel;
    private JSlider mSlider;
    private SGButton mStopButton;
    private SGComboBox mTimeIntervalComboBox;
    private JLabel mTimeIntervalLabel;
    private JLabel mUnitLabel;
    private SGTextField mValueTextField;
    private JPanel mVariablePanel;
    private SGDataAnimationThread mAnimationThread = null;
    private static int mTimeInterval = ANIMATION_TIME_INTERVALS[2];
    private static boolean mLoopPlaybackFlag = false;
    private int mInitFrameIndex = -1;
    private boolean mTempPlaying = false;

    public SGDataAnimationConfigurationDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mLoopPlaybackCheckBox = new SGCheckBox();
        this.mTimeIntervalLabel = new JLabel();
        this.mSlider = new JSlider();
        this.mPlayerButtonPanel = new JPanel();
        this.mPlayButton = new SGButton();
        this.mStopButton = new SGButton();
        this.mPauseButton = new SGButton();
        this.mPreviousButton = new SGButton();
        this.mNextButton = new SGButton();
        this.mBeginningButton = new SGButton();
        this.mEndingButton = new SGButton();
        this.mButtonPanel = new JPanel();
        this.mRestoreButton = new SGButton();
        this.mCloseButton = new SGButton();
        this.mTimeIntervalComboBox = new SGComboBox();
        this.mVariablePanel = new JPanel();
        this.mNameLabel = new JLabel();
        this.mValueTextField = new SGTextField();
        this.mUnitLabel = new JLabel();
        this.mEqualLabel = new JLabel();
        this.mSecondLabel = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mLoopPlaybackCheckBox.setText("Loop Playback");
        this.mLoopPlaybackCheckBox.setFont(new Font("Dialog", 0, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mLoopPlaybackCheckBox, gridBagConstraints);
        this.mTimeIntervalLabel.setFont(new Font("Dialog", 0, 12));
        this.mTimeIntervalLabel.setText("Time Interval");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.getContentPane().add((Component)this.mTimeIntervalLabel, gridBagConstraints);
        this.mSlider.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mSlider, gridBagConstraints);
        this.mPlayerButtonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.mPlayerButtonPanel.setLayout(new GridBagLayout());
        this.mPlayButton.setPreferredSize(new Dimension(24, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 1);
        this.mPlayerButtonPanel.add((Component)this.mPlayButton, gridBagConstraints);
        this.mStopButton.setPreferredSize(new Dimension(24, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 1, 5, 5);
        this.mPlayerButtonPanel.add((Component)this.mStopButton, gridBagConstraints);
        this.mPauseButton.setPreferredSize(new Dimension(24, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 1, 5, 1);
        this.mPlayerButtonPanel.add((Component)this.mPauseButton, gridBagConstraints);
        this.mPreviousButton.setPreferredSize(new Dimension(24, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 1, 5, 1);
        this.mPlayerButtonPanel.add((Component)this.mPreviousButton, gridBagConstraints);
        this.mNextButton.setPreferredSize(new Dimension(24, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 1, 5, 1);
        this.mPlayerButtonPanel.add((Component)this.mNextButton, gridBagConstraints);
        this.mBeginningButton.setPreferredSize(new Dimension(24, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 1);
        this.mPlayerButtonPanel.add((Component)this.mBeginningButton, gridBagConstraints);
        this.mEndingButton.setPreferredSize(new Dimension(24, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 1, 5, 5);
        this.mPlayerButtonPanel.add((Component)this.mEndingButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mPlayerButtonPanel, gridBagConstraints);
        this.mRestoreButton.setText("Restore");
        this.mRestoreButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mRestoreButton);
        this.mCloseButton.setText("Close");
        this.mCloseButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mCloseButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mTimeIntervalComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mTimeIntervalComboBox, gridBagConstraints);
        this.mVariablePanel.setLayout(new GridBagLayout());
        this.mNameLabel.setFont(new Font("Dialog", 0, 12));
        this.mNameLabel.setText("Name");
        this.mNameLabel.setPreferredSize(new Dimension(40, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.mVariablePanel.add((Component)this.mNameLabel, gridBagConstraints);
        this.mValueTextField.setColumns(6);
        this.mValueTextField.setEditable(false);
        this.mValueTextField.setText("Value");
        this.mValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 2, 5, 0);
        this.mVariablePanel.add((Component)this.mValueTextField, gridBagConstraints);
        this.mUnitLabel.setFont(new Font("Dialog", 0, 12));
        this.mUnitLabel.setText("Unit");
        this.mUnitLabel.setPreferredSize(new Dimension(200, 13));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mVariablePanel.add((Component)this.mUnitLabel, gridBagConstraints);
        this.mEqualLabel.setFont(new Font("Dialog", 0, 12));
        this.mEqualLabel.setText(" = ");
        this.mEqualLabel.setPreferredSize(new Dimension(16, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.mVariablePanel.add((Component)this.mEqualLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mVariablePanel, gridBagConstraints);
        this.mSecondLabel.setFont(new Font("Dialog", 0, 12));
        this.mSecondLabel.setText("[sec]");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.getContentPane().add((Component)this.mSecondLabel, gridBagConstraints);
        this.pack();
    }

    private void initProperty() {
        this.setTitle(TITLE);
        for (int i = 0; i < ANIMATION_TIME_INTERVALS.length; ++i) {
            this.mTimeIntervalComboBox.addItem(ANIMATION_TIME_INTERVALS[i]);
        }
        this.mTimeIntervalComboBox.setRenderer(new TimeIntervalComboBoxRenderer());
        this.mTimeIntervalComboBox.addItemListener(this);
        this.mLoopPlaybackCheckBox.addActionListener(this);
        this.mPlayButton.addActionListener(this);
        this.mPauseButton.addActionListener(this);
        this.mStopButton.addActionListener(this);
        this.mBeginningButton.addActionListener(this);
        this.mPreviousButton.addActionListener(this);
        this.mNextButton.addActionListener(this);
        this.mEndingButton.addActionListener(this);
        this.mSlider.addChangeListener(this);
        this.mRestoreButton.addActionListener(this);
        this.mCloseButton.addActionListener(this);
        this.mSlider.addMouseListener(this);
        this.mPlayButton.setIcon(this.createIcon("Play.png"));
        this.mPauseButton.setIcon(this.createIcon("Pause.png"));
        this.mStopButton.setIcon(this.createIcon("Stop.png"));
        this.mBeginningButton.setIcon(this.createIcon("Beginning.png"));
        this.mPreviousButton.setIcon(this.createIcon("Previous.png"));
        this.mNextButton.setIcon(this.createIcon("Next.png"));
        this.mEndingButton.setIcon(this.createIcon("Ending.png"));
        this.mPlayButton.setToolTipText("Play");
        this.mPauseButton.setToolTipText("Pause");
        this.mStopButton.setToolTipText("Stop");
        this.mBeginningButton.setToolTipText("Head");
        this.mPreviousButton.setToolTipText("Prev");
        this.mNextButton.setToolTipText("Next");
        this.mEndingButton.setToolTipText("End");
    }

    private ImageIcon createIcon(String string) {
        URL uRL = this.getClass().getResource("/resources/" + string);
        ImageIcon imageIcon = new ImageIcon(uRL);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(imageIcon.getImage(), 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return imageIcon;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.mRestoreButton)) {
            this.mAnimationThread.setPlaying(false);
            this.setIndex(this.mInitFrameIndex);
        } else if (object.equals(this.mCloseButton)) {
            this.saveAndClose();
        } else if (this.mAnimationThread != null) {
            if (object.equals(this.mPlayButton)) {
                this.startAnimation();
            } else if (object.equals(this.mStopButton)) {
                this.mAnimationThread.setPlaying(false);
                this.setIndex(0);
            } else if (object.equals(this.mPauseButton)) {
                this.pauseAnimation();
            } else if (object.equals(this.mBeginningButton)) {
                this.setIndex(0);
            } else if (object.equals(this.mPreviousButton)) {
                int n = this.mAnimationThread.getCurrentFrameIndex() - 1;
                this.setIndex(n);
            } else if (object.equals(this.mNextButton)) {
                int n = this.mAnimationThread.getCurrentFrameIndex() + 1;
                this.setIndex(n);
            } else if (object.equals(this.mEndingButton)) {
                int n = this.mAnimationThread.getFrameNumber() - 1;
                this.setIndex(n);
            } else if (object.equals(this.mLoopPlaybackCheckBox)) {
                boolean bl;
                mLoopPlaybackFlag = bl = this.mLoopPlaybackCheckBox.isSelected();
                this.mAnimationThread.setLoopPlaybackEnabled(bl);
            }
        }
    }

    private void startAnimation() {
        this.mAnimationThread = new SGDataAnimationThread(this.mAnimationThread);
        this.mAnimationThread.setPlaying(true);
        this.mAnimationThread.start();
    }

    private void pauseAnimation() {
        this.mAnimationThread.setPlaying(false);
    }

    private void setIndex(int n) {
        int n2 = this.mAnimationThread.getFrameNumber();
        if (n < 0 || n >= n2) {
            return;
        }
        this.mSlider.setValue(n);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.mTimeIntervalComboBox)) {
            int n;
            Integer n2 = (Integer)this.mTimeIntervalComboBox.getSelectedItem();
            mTimeInterval = n = n2.intValue();
            this.mAnimationThread.setTimeInterval(n);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object.equals(this.mSlider)) {
            int n = this.mSlider.getValue();
            this.mAnimationThread.setCurrentFrameIndex(n);
            this.setCurrentValue();
        }
    }

    protected void onEscKeyTyped() {
        this.cancelAndClose();
    }

    private void saveAndClose() {
        this.mAnimationThread.setPlaying(false);
        this.mAnimationThread.saveChanges();
        this.close();
    }

    private void cancelAndClose() {
        this.mAnimationThread.setPlaying(false);
        this.mAnimationThread.cancelChanges();
        this.close();
    }

    private void close() {
        this.setVisible(false);
    }

    public void setAnimation(SGIDataAnimation sGIDataAnimation) {
        String string;
        String string2;
        Serializable serializable;
        String string3;
        if (sGIDataAnimation == null) {
            throw new IllegalArgumentException("animation == null");
        }
        this.mAnimationThread = new SGDataAnimationThread(sGIDataAnimation);
        this.mAnimationThread.addAnimationThreadObserver(this);
        String string4 = sGIDataAnimation.getDataSourceName();
        if (string4 != null) {
            this.mNameLabel.setText(string4);
            this.mNameLabel.setToolTipText(string4);
        }
        if ((string3 = sGIDataAnimation.getDataSourceUnitString()) != null) {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append('[');
            ((StringBuffer)serializable).append(string3);
            ((StringBuffer)serializable).append(']');
            string2 = ((StringBuffer)serializable).toString();
            string = string3;
        } else {
            string2 = "";
            string = null;
        }
        this.mUnitLabel.setText(string2);
        this.mUnitLabel.setToolTipText(string);
        serializable = sGIDataAnimation.getCurrentValue();
        if (serializable != null) {
            this.setCurrentValue();
        }
        int n = sGIDataAnimation.getCurrentFrameIndex();
        DefaultBoundedRangeModel defaultBoundedRangeModel = new DefaultBoundedRangeModel();
        defaultBoundedRangeModel.setMinimum(0);
        defaultBoundedRangeModel.setMaximum(sGIDataAnimation.getFrameNumber() - 1);
        defaultBoundedRangeModel.setExtent(0);
        defaultBoundedRangeModel.setValue(n);
        this.mSlider.setModel(defaultBoundedRangeModel);
        this.mAnimationThread.setTimeInterval(mTimeInterval);
        this.mAnimationThread.setLoopPlaybackEnabled(mLoopPlaybackFlag);
        this.mTimeIntervalComboBox.setSelectedItem(mTimeInterval);
        this.mLoopPlaybackCheckBox.setSelected(mLoopPlaybackFlag);
        this.mInitFrameIndex = n;
    }

    public void updated(final SGAnimationThread sGAnimationThread) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = sGAnimationThread.getCurrentFrameIndex();
                SGDataAnimationConfigurationDialog.this.setIndex(n);
            }
        });
    }

    private void setCurrentValue() {
        SGIDataAnimation sGIDataAnimation = (SGIDataAnimation)this.mAnimationThread.getAnimation();
        Number number = sGIDataAnimation.getCurrentValue();
        String string = number.toString();
        this.mValueTextField.setText(string);
        this.mValueTextField.setToolTipText(string);
        int n = sGIDataAnimation.getFrameNumber() - 1;
        int n2 = sGIDataAnimation.getCurrentFrameIndex();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n2);
        stringBuffer.append('/');
        stringBuffer.append(n);
        this.mSlider.setToolTipText(stringBuffer.toString());
        this.mValueTextField.setCaretPosition(0);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object.equals(this.mSlider)) {
            this.mTempPlaying = this.mAnimationThread.isPlaying();
            this.pauseAnimation();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object.equals(this.mSlider) && this.mTempPlaying) {
            this.startAnimation();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        super.windowClosing(windowEvent);
        this.cancelAndClose();
    }

    protected static class TimeIntervalComboBoxRenderer
    extends DefaultListCellRenderer
    implements ListCellRenderer {
        private static final long serialVersionUID = 2127680422351963884L;

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Integer n2 = (Integer)object;
            float f = n2.floatValue() / 1000.0f;
            this.setText(Float.toString(f));
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }
}

