/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.data.SGAbstractAttributeDialog;
import jp.riken.brain.ni.samuraigraph.data.SGAttributePanel;
import jp.riken.brain.ni.samuraigraph.data.SGVariable;
import ucar.nc2.Attribute;

public class SGAttributeDialog
extends SGAbstractAttributeDialog {
    private static final long serialVersionUID = 3411696104268952430L;
    public static final String TITLE = "Attributes of a Variable";
    private SGAttributePanel mAttributePanel;
    private SGButton mCloseButton;
    private JPanel mDimensionPanel;
    private JLabel mDimensionsLabel;
    private JScrollPane mScrollPane;
    private JTextArea mTextArea;
    private JLabel mVariableNameLabel;
    private JPanel mVariableNamePanel;

    public SGAttributeDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    public SGAttributeDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mAttributePanel = new SGAttributePanel();
        this.mCloseButton = new SGButton();
        this.mVariableNamePanel = new JPanel();
        this.mVariableNameLabel = new JLabel();
        this.mScrollPane = new JScrollPane();
        this.mTextArea = new JTextArea();
        this.mDimensionPanel = new JPanel();
        this.mDimensionsLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.mAttributePanel.setPreferredSize(new Dimension(360, 120));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.mAttributePanel, gridBagConstraints);
        this.mCloseButton.setText("Close");
        this.mCloseButton.setFont(new Font("Dialog", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.mCloseButton, gridBagConstraints);
        this.mVariableNamePanel.setBorder(BorderFactory.createTitledBorder(null, "Variable Name", 0, 0, new Font("Dialog", 1, 12)));
        this.mVariableNamePanel.setLayout(new GridBagLayout());
        this.mVariableNameLabel.setFont(new Font("Dialog", 0, 12));
        this.mVariableNameLabel.setHorizontalAlignment(0);
        this.mVariableNameLabel.setText("                ");
        this.mVariableNameLabel.setPreferredSize(new Dimension(160, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        this.mVariableNamePanel.add((Component)this.mVariableNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.mVariableNamePanel, gridBagConstraints);
        this.mTextArea.setColumns(20);
        this.mTextArea.setRows(5);
        this.mScrollPane.setViewportView(this.mTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.mScrollPane, gridBagConstraints);
        this.mDimensionPanel.setBorder(BorderFactory.createTitledBorder(null, "Dimensions", 0, 0, new Font("Dialog", 1, 12)));
        this.mDimensionPanel.setLayout(new GridBagLayout());
        this.mDimensionsLabel.setFont(new Font("Dialog", 0, 12));
        this.mDimensionsLabel.setHorizontalAlignment(0);
        this.mDimensionsLabel.setText("                ");
        this.mDimensionsLabel.setPreferredSize(new Dimension(160, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        this.mDimensionPanel.add((Component)this.mDimensionsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.mDimensionPanel, gridBagConstraints);
        this.pack();
    }

    private void initProperty() {
        this.setTitle(TITLE);
        this.mTextArea.setLineWrap(true);
        this.mCloseButton.addActionListener(this);
        this.mAttributePanel.getTable().addMouseListener(this);
    }

    protected JButton getCloseButton() {
        return this.mCloseButton;
    }

    protected JTextArea getTextArea() {
        return this.mTextArea;
    }

    protected SGAttributePanel getAttributePanel() {
        return this.mAttributePanel;
    }

    public void setVariable(SGVariable sGVariable) {
        Object object;
        String string = sGVariable.getVariableName();
        this.mVariableNameLabel.setText(string);
        this.mVariableNameLabel.setToolTipText(string);
        List<ucar.nc2.Dimension> list = sGVariable.getDimensions();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            stringBuffer.append(object.getName());
            if (i == list.size() - 1) continue;
            stringBuffer.append(", ");
        }
        String string2 = stringBuffer.toString();
        this.mDimensionsLabel.setText(string2);
        this.mDimensionsLabel.setToolTipText(string2);
        object = sGVariable.getAttributes();
        this.mAttributePanel.setAttributes((List<Attribute>)object);
    }
}

