/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfoSet;
import jp.riken.brain.ni.samuraigraph.data.SGArrayDataColumnSelectionPanel;
import jp.riken.brain.ni.samuraigraph.data.SGDataSetupDialog;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGIDataSetupTableHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGArrayDataColumnSelectionDialog
extends SGDataSetupDialog
implements SGIDataColumnTypeConstants {
    private static final long serialVersionUID = -6874865640705737852L;
    public static final String TITLE = "Select the Data Columns";
    private JPanel mButtonPanel;
    private SGButton mCancelButton;
    private SGArrayDataColumnSelectionPanel mDataColumnSelectionPanel;
    private SGButton mOKButton;

    public SGArrayDataColumnSelectionDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    public SGArrayDataColumnSelectionDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mButtonPanel = new JPanel();
        this.mOKButton = new SGButton();
        this.mCancelButton = new SGButton();
        this.mDataColumnSelectionPanel = new SGArrayDataColumnSelectionPanel();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.mOKButton.setText("OK");
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mCancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.mDataColumnSelectionPanel, new GridBagConstraints());
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.getOKButton().addActionListener(this);
        this.getCancelButton().addActionListener(this);
        this.mDataColumnSelectionPanel.getRestoreButton().addActionListener(this);
        this.mDataColumnSelectionPanel.getClearButton().addActionListener(this);
        this.mDataColumnSelectionPanel.getComplementButton().addActionListener(this);
        this.mDataColumnSelectionPanel.getTable().addPropertyChangeListener(this);
        return true;
    }

    @Override
    protected JButton getOKButton() {
        return this.mOKButton;
    }

    @Override
    protected JButton getCancelButton() {
        return this.mCancelButton;
    }

    @Override
    protected SGIDataSetupTableHolder getTableHolder() {
        return this.mDataColumnSelectionPanel;
    }

    public boolean setData(String string, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map, boolean bl) {
        return this.mDataColumnSelectionPanel.setData(string, sGDataColumnInfoSet, map, bl);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        super.propertyChange(propertyChangeEvent);
        Object object = propertyChangeEvent.getSource();
        if (object.equals(this.getTableHolder().getTable()) && "tableCellEditor".equals(string = propertyChangeEvent.getPropertyName())) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SGArrayDataColumnSelectionDialog.this.mDataColumnSelectionPanel.updateSelectedItems();
                }
            });
        }
    }
}

