/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGCheckBox;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGComponentGroup;
import jp.riken.brain.ni.samuraigraph.base.SGComponentGroupElement;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGIRootObjectConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIWindowDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;

public class SGWindowDialog
extends SGPropertyDialog
implements SGIRootObjectConstants,
PropertyChangeListener {
    private static final long serialVersionUID = -4062469276075732615L;
    public static final String TITLE = "Window Properties";
    public static final String ERRMSG_INVALID_SCALING_FACTOR = "Scaling factor is invalid.";
    private SGColorSelectionButton mBackgroundColorButton;
    private JLabel mBackgroundColorLabel1;
    private JLabel mBottomLabel;
    private JPanel mButtonPanel;
    private SGButton mCancelButton;
    private JLabel mColorLabel;
    private JSeparator mColorSeparator;
    private SGCheckBox mFixSizeRatioCheckBox;
    private JLabel mGridLabel;
    private SGColorSelectionButton mGridLinesColorButton;
    private JLabel mGridLinesColorLabel;
    private SGSpinner mGridLinesIntervalSpinner;
    private SGSpinner mGridLinesWidthSpinner;
    private JSeparator mGridSeparator;
    private SGCheckBox mGridVisibleCheckBox;
    private JLabel mHeightLabel;
    private SGSpinner mHeightSpinner;
    private JLabel mImageHeightLabel;
    private SGSpinner mImageHeightSpinner;
    private JLabel mImageLabel;
    private JLabel mImageScaleLabel;
    private SGTextField mImageScaleTextField;
    private JSeparator mImageSeparator;
    private JLabel mImageWidthLabel;
    private SGSpinner mImageWidthSpinner;
    private JLabel mImageXLabel;
    private SGSpinner mImageXSpinner;
    private JLabel mImageYLabel;
    private SGSpinner mImageYSpinner;
    private JLabel mIntervalLabel;
    private JLabel mLeftSpaceLabel;
    private SGButton mOKButton;
    private SGButton mPreviewButton;
    private JLabel mRightSpaceLabel;
    private JLabel mSizeLabel;
    private JSeparator mSizeSeparator;
    private JLabel mWidthLabel;
    private SGSpinner mWidthSpinner;
    private JPanel mWindowPanel;
    private SGComponentGroup mGridVisibleComponentGroup = new SGComponentGroup();
    private boolean mFixSizeRatioFlag = true;
    private double mImageSizeRatio = 1.0;
    private double mImageWidth;
    private double mImageHeight;

    public SGWindowDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
        this.initialize();
    }

    private void initComponents() {
        this.mImageWidthLabel = new JLabel();
        this.mImageWidthSpinner = new SGSpinner();
        this.mImageHeightLabel = new JLabel();
        this.mImageHeightSpinner = new SGSpinner();
        this.mFixSizeRatioCheckBox = new SGCheckBox();
        this.mWindowPanel = new JPanel();
        this.mWidthLabel = new JLabel();
        this.mHeightLabel = new JLabel();
        this.mWidthSpinner = new SGSpinner();
        this.mHeightSpinner = new SGSpinner();
        this.mSizeLabel = new JLabel();
        this.mColorLabel = new JLabel();
        this.mIntervalLabel = new JLabel();
        this.mGridLinesIntervalSpinner = new SGSpinner();
        this.mBottomLabel = new JLabel();
        this.mGridLinesWidthSpinner = new SGSpinner();
        this.mGridLabel = new JLabel();
        this.mGridLinesColorButton = new SGColorSelectionButton();
        this.mBackgroundColorLabel1 = new JLabel();
        this.mGridLinesColorLabel = new JLabel();
        this.mBackgroundColorButton = new SGColorSelectionButton();
        this.mSizeSeparator = new JSeparator();
        this.mGridSeparator = new JSeparator();
        this.mColorSeparator = new JSeparator();
        this.mLeftSpaceLabel = new JLabel();
        this.mRightSpaceLabel = new JLabel();
        this.mGridVisibleCheckBox = new SGCheckBox();
        this.mImageLabel = new JLabel();
        this.mImageSeparator = new JSeparator();
        this.mImageXLabel = new JLabel();
        this.mImageXSpinner = new SGSpinner();
        this.mImageYLabel = new JLabel();
        this.mImageYSpinner = new SGSpinner();
        this.mImageScaleLabel = new JLabel();
        this.mImageScaleTextField = new SGTextField();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new SGButton();
        this.mCancelButton = new SGButton();
        this.mPreviewButton = new SGButton();
        this.mImageWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mImageWidthLabel.setText("Width");
        this.mImageWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mImageWidthSpinner.setPreferredSize(new Dimension(75, 22));
        this.mImageHeightLabel.setFont(new Font("Dialog", 0, 12));
        this.mImageHeightLabel.setText("Height");
        this.mImageHeightSpinner.setFont(new Font("Dialog", 0, 12));
        this.mImageHeightSpinner.setPreferredSize(new Dimension(75, 22));
        this.mFixSizeRatioCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mFixSizeRatioCheckBox.setText("Fixed Ratio");
        this.getContentPane().setLayout(new GridBagLayout());
        this.mWindowPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.mWindowPanel.setLayout(new GridBagLayout());
        this.mWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mWidthLabel.setText("Width");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mWindowPanel.add((Component)this.mWidthLabel, gridBagConstraints);
        this.mHeightLabel.setFont(new Font("Dialog", 0, 12));
        this.mHeightLabel.setText("Height");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mWindowPanel.add((Component)this.mHeightLabel, gridBagConstraints);
        this.mWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mWidthSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mWindowPanel.add((Component)this.mWidthSpinner, gridBagConstraints);
        this.mHeightSpinner.setFont(new Font("Dialog", 0, 12));
        this.mHeightSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mWindowPanel.add((Component)this.mHeightSpinner, gridBagConstraints);
        this.mSizeLabel.setFont(new Font("Dialog", 3, 12));
        this.mSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        this.mWindowPanel.add((Component)this.mSizeLabel, gridBagConstraints);
        this.mColorLabel.setFont(new Font("Dialog", 3, 12));
        this.mColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.mWindowPanel.add((Component)this.mColorLabel, gridBagConstraints);
        this.mIntervalLabel.setFont(new Font("Dialog", 0, 12));
        this.mIntervalLabel.setText("Interval");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mWindowPanel.add((Component)this.mIntervalLabel, gridBagConstraints);
        this.mGridLinesIntervalSpinner.setFont(new Font("Dialog", 0, 12));
        this.mGridLinesIntervalSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mWindowPanel.add((Component)this.mGridLinesIntervalSpinner, gridBagConstraints);
        this.mBottomLabel.setFont(new Font("Dialog", 0, 12));
        this.mBottomLabel.setText("Line width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mWindowPanel.add((Component)this.mBottomLabel, gridBagConstraints);
        this.mGridLinesWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mGridLinesWidthSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mWindowPanel.add((Component)this.mGridLinesWidthSpinner, gridBagConstraints);
        this.mGridLabel.setFont(new Font("Dialog", 3, 12));
        this.mGridLabel.setText("Grid");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.mWindowPanel.add((Component)this.mGridLabel, gridBagConstraints);
        this.mGridLinesColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mWindowPanel.add((Component)this.mGridLinesColorButton, gridBagConstraints);
        this.mBackgroundColorLabel1.setFont(new Font("Dialog", 0, 12));
        this.mBackgroundColorLabel1.setText("Background");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mWindowPanel.add((Component)this.mBackgroundColorLabel1, gridBagConstraints);
        this.mGridLinesColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mGridLinesColorLabel.setText("Grid");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mWindowPanel.add((Component)this.mGridLinesColorLabel, gridBagConstraints);
        this.mBackgroundColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mWindowPanel.add((Component)this.mBackgroundColorButton, gridBagConstraints);
        this.mSizeSeparator.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 35, 0, 0);
        this.mWindowPanel.add((Component)this.mSizeSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 35, 0, 0);
        this.mWindowPanel.add((Component)this.mGridSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 42, 0, 0);
        this.mWindowPanel.add((Component)this.mColorSeparator, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mWindowPanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mWindowPanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mGridVisibleCheckBox.setText("Visible");
        this.mGridVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mWindowPanel.add((Component)this.mGridVisibleCheckBox, gridBagConstraints);
        this.mImageLabel.setFont(new Font("Dialog", 3, 12));
        this.mImageLabel.setText("Image");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.mWindowPanel.add((Component)this.mImageLabel, gridBagConstraints);
        this.mImageSeparator.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.mWindowPanel.add((Component)this.mImageSeparator, gridBagConstraints);
        this.mImageXLabel.setFont(new Font("Dialog", 0, 12));
        this.mImageXLabel.setText("X ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 7, 5);
        this.mWindowPanel.add((Component)this.mImageXLabel, gridBagConstraints);
        this.mImageXSpinner.setFont(new Font("Dialog", 0, 12));
        this.mImageXSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 7, 5);
        this.mWindowPanel.add((Component)this.mImageXSpinner, gridBagConstraints);
        this.mImageYLabel.setFont(new Font("Dialog", 0, 12));
        this.mImageYLabel.setText("Y ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 7, 5);
        this.mWindowPanel.add((Component)this.mImageYLabel, gridBagConstraints);
        this.mImageYSpinner.setFont(new Font("Dialog", 0, 12));
        this.mImageYSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(5, 5, 7, 5);
        this.mWindowPanel.add((Component)this.mImageYSpinner, gridBagConstraints);
        this.mImageScaleLabel.setFont(new Font("Dialog", 0, 12));
        this.mImageScaleLabel.setText("Scale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 15, 15, 5);
        this.mWindowPanel.add((Component)this.mImageScaleLabel, gridBagConstraints);
        this.mImageScaleTextField.setColumns(6);
        this.mImageScaleTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 15, 5);
        this.mWindowPanel.add((Component)this.mImageScaleTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mWindowPanel, gridBagConstraints);
        this.mOKButton.setText("OK");
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SGWindowDialog.this.mOKButtonActionPerformed(actionEvent);
            }
        });
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    private void mOKButtonActionPerformed(ActionEvent actionEvent) {
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.mWidthSpinner.initProperties(new SpinnerNumberModel(0.1, 0.1, 99.0, 1.0), "cm", 1, 1);
        this.mHeightSpinner.initProperties(new SpinnerNumberModel(0.1, 0.1, 99.0, 1.0), "cm", 1, 1);
        this.mGridLinesIntervalSpinner.initProperties(new SpinnerNumberModel(0.1, 0.1, 10.0, 0.1), "cm", 1, 1);
        this.mGridLinesWidthSpinner.initProperties(SGWindowDialog.getLineWidthSpinnerNumberModel(), "pt", 1, 2);
        this.mImageXSpinner.initProperties(new SpinnerNumberModel(-50.0, -50.0, 150.0, 1.0), "cm", 1, 1);
        this.mImageYSpinner.initProperties(new SpinnerNumberModel(-50.0, -50.0, 150.0, 1.0), "cm", 1, 1);
        this.mGridVisibleCheckBox.addActionListener(this);
        this.mFixSizeRatioCheckBox.addActionListener(this);
        this.mWidthSpinner.setDescription("Size-> Width");
        this.mHeightSpinner.setDescription("Size-> Height");
        this.mGridLinesIntervalSpinner.setDescription("Grid-> Interval");
        this.mGridLinesWidthSpinner.setDescription("Grid-> Line Width");
        this.mImageXSpinner.setDescription("Image-> X");
        this.mImageYSpinner.setDescription("Image-> Y");
        this.mImageScaleTextField.setDescription("Image-> Scale");
        SGComponentGroupElement[] sGComponentGroupElementArray = new SGComponentGroupElement[]{new SGComponentGroupElement(this.mIntervalLabel), new SGComponentGroupElement(this.mGridLinesIntervalSpinner), new SGComponentGroupElement(this.mBottomLabel), new SGComponentGroupElement(this.mGridLinesWidthSpinner), new SGComponentGroupElement(this.mGridLinesColorLabel), new SGComponentGroupElement(this.mGridLinesColorButton)};
        this.mGridVisibleComponentGroup.addElement(sGComponentGroupElementArray);
        return true;
    }

    public Number getPaperWidth() {
        return this.mWidthSpinner.getNumber();
    }

    public Number getPaperHeight() {
        return this.mHeightSpinner.getNumber();
    }

    public Color getPaperColor() {
        return this.mBackgroundColorButton.getColor();
    }

    public Color getGridLineColor() {
        return this.mGridLinesColorButton.getColor();
    }

    public Boolean isGridVisible() {
        return this.mGridVisibleCheckBox.getSelected();
    }

    public Number getGridLineInterval() {
        return this.mGridLinesIntervalSpinner.getNumber();
    }

    public Number getGridLineWidth() {
        return this.mGridLinesWidthSpinner.getNumber();
    }

    public Number getImageLocationX() {
        return this.mImageXSpinner.getNumber();
    }

    public Number getImageLocationY() {
        return this.mImageYSpinner.getNumber();
    }

    public Number getImageWidth() {
        return this.mImageWidthSpinner.getNumber();
    }

    public Number getImageHeight() {
        return this.mImageHeightSpinner.getNumber();
    }

    public Number getImageScalingFactor() {
        return this.getNumber(this.mImageScaleTextField);
    }

    public boolean setPaperWidth(Object object) {
        return this.setValue(this.mWidthSpinner, object);
    }

    public boolean setPaperHeight(Object object) {
        return this.setValue(this.mHeightSpinner, object);
    }

    public boolean setGridVisible(Boolean bl) {
        this.mGridVisibleCheckBox.setSelected(bl);
        this.setGridComponentEnabled(bl);
        return true;
    }

    public boolean setGridLineInterval(Object object) {
        return this.setValue(this.mGridLinesIntervalSpinner, object);
    }

    public boolean setGridLineWidth(Object object) {
        return this.setValue(this.mGridLinesWidthSpinner, object);
    }

    public boolean setPaperColor(Color color) {
        this.mBackgroundColorButton.setColor(color);
        return true;
    }

    public boolean setGridLineColor(Color color) {
        this.mGridLinesColorButton.setColor(color);
        return true;
    }

    public boolean setImageLocationX(Object object) {
        return this.setValue(this.mImageXSpinner, object);
    }

    public boolean setImageLocationY(Object object) {
        return this.setValue(this.mImageYSpinner, object);
    }

    public boolean setImageWidth(Object object) {
        return this.setValue(this.mImageWidthSpinner, object);
    }

    public boolean setImageHeight(Object object) {
        return this.setValue(this.mImageHeightSpinner, object);
    }

    public boolean setImageScalingFactor(Object object) {
        return this.setValue(this.mImageScaleTextField, object);
    }

    public List getColorSelectionButtonsList() {
        ArrayList<SGColorSelectionButton> arrayList = new ArrayList<SGColorSelectionButton>();
        arrayList.add(this.mBackgroundColorButton);
        arrayList.add(this.mGridLinesColorButton);
        return arrayList;
    }

    public List getTextFieldComponentsList() {
        List list = this.getFormattedTextFieldsListFromSpinners();
        list.addAll(this.getNumberTextFieldList());
        return list;
    }

    public List getNumberTextFieldList() {
        ArrayList<SGTextField> arrayList = new ArrayList<SGTextField>();
        arrayList.add(this.mImageScaleTextField);
        return arrayList;
    }

    public List getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mWidthSpinner);
        arrayList.add(this.mHeightSpinner);
        arrayList.add(this.mGridLinesIntervalSpinner);
        arrayList.add(this.mGridLinesWidthSpinner);
        arrayList.add(this.mImageXSpinner);
        arrayList.add(this.mImageYSpinner);
        return arrayList;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.mGridVisibleCheckBox)) {
            this.setGridVisible(this.isGridVisible());
        } else if (object.equals(this.mFixSizeRatioCheckBox)) {
            this.mFixSizeRatioFlag = this.mFixSizeRatioCheckBox.isSelected();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object.equals(this.mImageWidthSpinner) || object.equals(this.mImageHeightSpinner)) {
            if (this.mFixSizeRatioFlag) {
                this.updateImageSizeSpinnerValues((SGSpinner)object);
            } else {
                this.updateImageSizeRatio();
            }
        }
    }

    private boolean updateImageSizeRatio() {
        Number number = this.mImageWidthSpinner.getNumber();
        Number number2 = this.mImageHeightSpinner.getNumber();
        if (number == null || number2 == null) {
            return false;
        }
        double d = number.doubleValue();
        double d2 = number2.doubleValue();
        if (d == 0.0 || d2 == 0.0) {
            return false;
        }
        this.mImageSizeRatio = d / d2;
        return true;
    }

    private boolean updateImageSizeSpinnerValues(SGSpinner sGSpinner) {
        Number number = this.mImageWidthSpinner.getNumber();
        Number number2 = this.mImageHeightSpinner.getNumber();
        if (number == null || number2 == null) {
            return false;
        }
        double d = number.doubleValue();
        double d2 = number2.doubleValue();
        if (d == 0.0 || d2 == 0.0) {
            return false;
        }
        double d3 = this.mImageSizeRatio;
        Number number3 = sGSpinner.getNumber();
        double d4 = number3.doubleValue();
        if (sGSpinner.equals(this.mImageWidthSpinner)) {
            this.mImageWidth = d4;
            this.mImageHeight = d4 / d3;
            this.setImageHeight(this.mImageHeight);
        } else if (sGSpinner.equals(this.mImageHeightSpinner)) {
            this.mImageHeight = d4;
            this.mImageWidth = d4 * d3;
            this.setImageWidth(this.mImageWidth);
        }
        return true;
    }

    private boolean setGridComponentEnabled(Boolean bl) {
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        this.setGridComponentEnabled(bl2);
        return true;
    }

    private boolean setGridComponentEnabled(boolean bl) {
        this.mGridVisibleComponentGroup.setEnabled(bl);
        return true;
    }

    public boolean setDialogProperty() {
        List list = this.mPropertyDialogObserverList;
        SGIWindowDialogObserver sGIWindowDialogObserver = (SGIWindowDialogObserver)list.get(0);
        float f = sGIWindowDialogObserver.getPaperWidth("cm");
        float f2 = sGIWindowDialogObserver.getPaperHeight("cm");
        float f3 = sGIWindowDialogObserver.getGridLineInterval("cm");
        float f4 = sGIWindowDialogObserver.getGridLineWidth("pt");
        boolean bl = sGIWindowDialogObserver.isGridLineVisible();
        Color color = sGIWindowDialogObserver.getPaperColor();
        Color color2 = sGIWindowDialogObserver.getGridLineColor();
        float f5 = sGIWindowDialogObserver.getImageLocationX("cm");
        float f6 = sGIWindowDialogObserver.getImageLocationY("cm");
        float f7 = sGIWindowDialogObserver.getImageWidth("cm");
        float f8 = sGIWindowDialogObserver.getImageHeight("cm");
        float f9 = sGIWindowDialogObserver.getImageScalingFactor();
        Float f10 = Float.valueOf(f);
        Float f11 = Float.valueOf(f2);
        Float f12 = Float.valueOf(f3);
        Float f13 = Float.valueOf(f4);
        Boolean bl2 = bl;
        Color color3 = color;
        Color color4 = color2;
        Float f14 = Float.valueOf(f5);
        Float f15 = Float.valueOf(f6);
        Float f16 = Float.valueOf(f9);
        if (list.size() > 1) {
            float f17;
            float f18;
            float f19;
            SGIWindowDialogObserver sGIWindowDialogObserver2;
            int n;
            for (n = 1; n < list.size(); ++n) {
                sGIWindowDialogObserver2 = (SGIWindowDialogObserver)list.get(n);
                f19 = sGIWindowDialogObserver2.getPaperWidth("cm");
                if (f == f19) continue;
                f10 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                sGIWindowDialogObserver2 = (SGIWindowDialogObserver)list.get(n);
                f19 = sGIWindowDialogObserver2.getPaperHeight("cm");
                if (f2 == f19) continue;
                f11 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                sGIWindowDialogObserver2 = (SGIWindowDialogObserver)list.get(n);
                f19 = sGIWindowDialogObserver2.getGridLineInterval("cm");
                if (f3 == f19) continue;
                f12 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                sGIWindowDialogObserver2 = (SGIWindowDialogObserver)list.get(n);
                f19 = sGIWindowDialogObserver2.getGridLineWidth("pt");
                if (f4 == f19) continue;
                f13 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                sGIWindowDialogObserver2 = (SGIWindowDialogObserver)list.get(n);
                boolean bl3 = sGIWindowDialogObserver2.isGridLineVisible();
                if (bl == bl3) continue;
                bl2 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                sGIWindowDialogObserver2 = (SGIWindowDialogObserver)list.get(n);
                Color color5 = sGIWindowDialogObserver2.getPaperColor();
                if (color.equals(color5)) continue;
                color3 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                sGIWindowDialogObserver2 = (SGIWindowDialogObserver)list.get(n);
                Color color6 = sGIWindowDialogObserver2.getGridLineColor();
                if (color2.equals(color6)) continue;
                color4 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                sGIWindowDialogObserver2 = (SGIWindowDialogObserver)list.get(n);
                float f20 = sGIWindowDialogObserver2.getImageLocationX("cm");
                if (f5 == f20) continue;
                f14 = null;
                break;
            }
            for (n = 1; n < list.size(); ++n) {
                sGIWindowDialogObserver2 = (SGIWindowDialogObserver)list.get(n);
                float f21 = sGIWindowDialogObserver2.getImageLocationY("cm");
                if (f6 == f21) continue;
                f15 = null;
                break;
            }
            for (n = 1; n < list.size() && f7 == (f18 = (sGIWindowDialogObserver2 = (SGIWindowDialogObserver)list.get(n)).getImageWidth("cm")); ++n) {
            }
            for (n = 1; n < list.size() && f8 == (f17 = (sGIWindowDialogObserver2 = (SGIWindowDialogObserver)list.get(n)).getImageHeight("cm")); ++n) {
            }
            for (n = 1; n < list.size(); ++n) {
                sGIWindowDialogObserver2 = (SGIWindowDialogObserver)list.get(n);
                float f22 = sGIWindowDialogObserver2.getImageScalingFactor();
                if (f9 == f22) continue;
                f16 = null;
                break;
            }
        }
        this.setPaperWidth(f10);
        this.setPaperHeight(f11);
        this.setGridLineInterval(f12);
        this.setGridLineWidth(f13);
        this.setGridVisible(bl2);
        this.setPaperColor(color3);
        this.setGridLineColor(color4);
        this.setImageLocationX(f14);
        this.setImageLocationY(f15);
        this.setImageScalingFactor(f16);
        return true;
    }

    public boolean setPropertiesToListeners(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        Number number;
        Number number2;
        Number number3;
        Color color;
        Color color2;
        Boolean bl;
        Number number4;
        Number number5;
        Number number6;
        SGIWindowDialogObserver sGIWindowDialogObserver = (SGIWindowDialogObserver)sGIPropertyDialogObserver;
        Number number7 = this.getPaperWidth();
        if (number7 != null) {
            sGIWindowDialogObserver.setPaperWidth(number7.floatValue(), "cm");
        }
        if ((number6 = this.getPaperHeight()) != null) {
            sGIWindowDialogObserver.setPaperHeight(number6.floatValue(), "cm");
        }
        if ((number5 = this.getGridLineInterval()) != null) {
            sGIWindowDialogObserver.setGridLineInterval(number5.floatValue(), "cm");
        }
        if ((number4 = this.getGridLineWidth()) != null) {
            sGIWindowDialogObserver.setGridLineWidth(number4.floatValue(), "pt");
        }
        if ((bl = this.isGridVisible()) != null) {
            sGIWindowDialogObserver.setGridLineVisible(bl);
        }
        if ((color2 = this.getPaperColor()) != null) {
            sGIWindowDialogObserver.setPaperColor(color2);
        }
        if ((color = this.getGridLineColor()) != null) {
            sGIWindowDialogObserver.setGridLineColor(color);
        }
        if ((number3 = this.getImageLocationX()) != null) {
            sGIWindowDialogObserver.setImageLocationX(number3.floatValue(), "cm");
        }
        if ((number2 = this.getImageLocationY()) != null) {
            sGIWindowDialogObserver.setImageLocationY(number2.floatValue(), "cm");
        }
        if ((number = this.getImageScalingFactor()) != null) {
            sGIWindowDialogObserver.setImageScalingFactor(number.floatValue());
        }
        return true;
    }

    protected boolean hasValidInputValues() {
        boolean bl = true;
        if (!super.hasValidInputValues()) {
            bl = false;
        }
        if (!this.hasValidNumber(this.mImageScaleTextField, 0.01, 100.0)) {
            bl = false;
        }
        return bl;
    }

    protected JButton getOKButton() {
        return this.mOKButton;
    }

    protected JButton getCancelButton() {
        return this.mCancelButton;
    }

    protected JButton getPreviewButton() {
        return this.mPreviewButton;
    }
}

