/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGUtilityNumber
implements SGIConstants {
    public static int getOrder(double d) {
        if (d == 0.0) {
            throw new IllegalArgumentException("d == 0.0");
        }
        if (Double.isInfinite(d)) {
            throw new IllegalArgumentException("d is infinite value");
        }
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("d is not a number");
        }
        double d2 = Math.abs(d);
        double d3 = Math.log10(d2);
        int n = (int)Math.floor(d3);
        return n;
    }

    public static double getPowersOfTen(int n) {
        BigDecimal bigDecimal = SGUtilityNumber.getBigDecimalPowersOfTen(n);
        return bigDecimal.doubleValue();
    }

    public static BigDecimal getBigDecimalPowersOfTen(int n) {
        BigDecimal bigDecimal = new BigDecimal(1.0);
        bigDecimal = bigDecimal.movePointRight(n);
        return bigDecimal;
    }

    public static double truncateNumber(double d, int n) {
        return SGUtilityNumber.truncateNumber(Double.toString(d), n);
    }

    public static double truncateNumber(String string, int n) {
        BigDecimal bigDecimal = new BigDecimal(string);
        bigDecimal = bigDecimal.movePointLeft(n);
        int n2 = (int)bigDecimal.doubleValue();
        bigDecimal = new BigDecimal(n2);
        bigDecimal = bigDecimal.movePointRight(n);
        return bigDecimal.doubleValue();
    }

    public static double roundOffNumber(double d, int n) {
        return SGUtilityNumber.roundOffNumber(Double.toString(d), n);
    }

    public static double roundOffNumber(String string, int n) {
        BigDecimal bigDecimal = new BigDecimal(string);
        double d = bigDecimal.doubleValue() >= 0.0 ? 1.0 : -1.0;
        bigDecimal = bigDecimal.movePointLeft(n + 1);
        double d2 = d * (double)((int)(Math.abs(bigDecimal.doubleValue()) + 0.5));
        bigDecimal = new BigDecimal(d2);
        bigDecimal = bigDecimal.movePointRight(n + 1);
        return bigDecimal.doubleValue();
    }

    public static double roundOutNumber(double d, int n) {
        return SGUtilityNumber.roundOutNumber(Double.toString(d), n);
    }

    public static double roundOutNumber(String string, int n) {
        BigDecimal bigDecimal = new BigDecimal(string);
        bigDecimal = bigDecimal.movePointLeft(n + 1);
        double d = Math.ceil(bigDecimal.doubleValue());
        bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.movePointRight(n + 1);
        return bigDecimal.doubleValue();
    }

    public static boolean isOverlapping(double d, double d2, double d3, double d4) {
        double d5 = SGUtilityNumber.getOverlap(d, d2, d3, d4);
        return d5 != 0.0;
    }

    public static double getOverlap(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = d < d2 ? d : d2;
        double d7 = d < d2 ? d2 : d;
        double d8 = d3 < d4 ? d3 : d4;
        double d9 = d5 = d3 < d4 ? d4 : d3;
        if (!(d6 < d5) && !(d8 < d7)) {
            return 0.0;
        }
        double d10 = d6 < d8 ? d7 - d8 : d5 - d6;
        return d10;
    }

    public static boolean contains(double d, double d2, double d3) {
        double d4;
        double d5;
        if (d <= d2) {
            d5 = d;
            d4 = d2;
        } else {
            d5 = d2;
            d4 = d;
        }
        return d5 <= d3 && d3 <= d4;
    }

    public static boolean contains(double d, double d2, double d3, double d4) {
        double d5 = d < d2 ? d : d2;
        double d6 = d < d2 ? d2 : d;
        double d7 = d3 < d4 ? d3 : d4;
        double d8 = d3 < d4 ? d4 : d3;
        return d5 <= d7 && d8 <= d6;
    }

    public static double stepValue(boolean bl, double d, double d2, double d3, double d4, double d5) {
        int n = (int)Math.rint(d / d4);
        double d6 = (double)n * d4;
        int n2 = Math.abs(d - d6) < d5 ? (bl ? n + 1 : n - 1) : (bl ? (int)Math.floor(d / d4) + 1 : (int)Math.floor(d / d4));
        double d7 = (double)n2 * d4;
        return d7;
    }

    public static double getNumberInNumberOrder(double d, double d2, int n, int n2) {
        int n3 = SGUtilityNumber.getOrder(d2) - n + 1;
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.movePointLeft(n3);
        bigDecimal = bigDecimal.setScale(0, n2);
        bigDecimal = bigDecimal.movePointRight(n3);
        return bigDecimal.doubleValue();
    }

    public static double getNumberInRangeOrder(double d, double d2, double d3, int n, int n2) {
        return SGUtilityNumber.getNumberInNumberOrder(d, d3 - d2, n, n2);
    }

    public static double min(double[] dArray) {
        boolean bl = false;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i]) || Double.isInfinite(dArray[i]) || !(dArray[i] < d)) continue;
            d = dArray[i];
            bl = true;
        }
        if (!bl) {
            return Double.NaN;
        }
        return d;
    }

    public static float min(float[] fArray) {
        boolean bl = false;
        float f = Float.MAX_VALUE;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i]) || Float.isInfinite(fArray[i]) || !(fArray[i] < f)) continue;
            f = fArray[i];
            bl = true;
        }
        if (!bl) {
            return Float.NaN;
        }
        return f;
    }

    public static SGTuple2f min(SGTuple2f[] sGTuple2fArray) {
        float[] fArray = new float[sGTuple2fArray.length];
        for (int i = 0; i < sGTuple2fArray.length; ++i) {
            fArray[i] = sGTuple2fArray[i].x;
        }
        float[] fArray2 = new float[sGTuple2fArray.length];
        for (int i = 0; i < sGTuple2fArray.length; ++i) {
            fArray2[i] = sGTuple2fArray[i].y;
        }
        float f = SGUtilityNumber.min(fArray);
        float f2 = SGUtilityNumber.min(fArray2);
        return new SGTuple2f(f, f2);
    }

    public static double max(double[] dArray) {
        boolean bl = false;
        double d = -1.7976931348623157E308;
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i]) || Double.isInfinite(dArray[i]) || !(dArray[i] > d)) continue;
            d = dArray[i];
            bl = true;
        }
        if (!bl) {
            return Double.NaN;
        }
        return d;
    }

    public static float max(float[] fArray) {
        boolean bl = false;
        float f = -3.4028235E38f;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i]) || Float.isInfinite(fArray[i]) || !(fArray[i] > f)) continue;
            f = fArray[i];
            bl = true;
        }
        if (!bl) {
            return Float.NaN;
        }
        return f;
    }

    public static SGTuple2f max(SGTuple2f[] sGTuple2fArray) {
        float[] fArray = new float[sGTuple2fArray.length];
        for (int i = 0; i < sGTuple2fArray.length; ++i) {
            fArray[i] = sGTuple2fArray[i].x;
        }
        float[] fArray2 = new float[sGTuple2fArray.length];
        for (int i = 0; i < sGTuple2fArray.length; ++i) {
            fArray2[i] = sGTuple2fArray[i].y;
        }
        float f = SGUtilityNumber.max(fArray);
        float f2 = SGUtilityNumber.max(fArray2);
        return new SGTuple2f(f, f2);
    }

    public static Set<Number> calcStepValue(double d, double d2, double d3, double d4, int n) {
        HashSet<Number> hashSet = new HashSet<Number>();
        if (d3 < d) {
            double d5 = d3 + (double)((int)((d - d3) / d4)) * d4;
            d5 = SGUtilityNumber.getNumberInRangeOrder(d5, d, d2, n, 4);
            hashSet.add(d5);
            while (true) {
                double d6 = d5 + d4;
                if ((d6 = SGUtilityNumber.getNumberInRangeOrder(d6, d, d2, n, 4)) == d5) break;
                d5 = d6;
                if (d5 >= d && d5 <= d2) {
                    hashSet.add(d5);
                    continue;
                }
                if (d5 > d2) break;
            }
            hashSet.add(d5);
        } else if (d3 > d2) {
            double d7 = d3 - (double)((int)((d3 - d2) / d4)) * d4;
            d7 = SGUtilityNumber.getNumberInRangeOrder(d7, d, d2, n, 4);
            hashSet.add(d7);
            while (true) {
                double d8 = d7 - d4;
                if ((d8 = SGUtilityNumber.getNumberInRangeOrder(d8, d, d2, n, 4)) == d7) break;
                d7 = d8;
                if (d7 >= d && d7 <= d2) {
                    hashSet.add(d7);
                    continue;
                }
                if (d7 < d) break;
            }
            hashSet.add(d7);
        } else {
            double d9;
            hashSet.add(d3);
            double d10 = d3;
            while (true) {
                d9 = d10 + d4;
                if ((d9 = SGUtilityNumber.getNumberInRangeOrder(d9, d, d2, n, 4)) == d10) break;
                d10 = d9;
                if (d10 >= d && d10 <= d2) {
                    hashSet.add(d10);
                    continue;
                }
                if (d10 > d2) break;
            }
            hashSet.add(d10);
            d10 = d3;
            while (true) {
                d9 = d10 - d4;
                if ((d9 = SGUtilityNumber.getNumberInRangeOrder(d9, d, d2, n, 4)) == d10) break;
                d10 = d9;
                if (d10 >= d && d10 <= d2) {
                    hashSet.add(d10);
                    continue;
                }
                if (d10 < d) break;
            }
            hashSet.add(d10);
        }
        return hashSet;
    }

    public static double[] calcStepValueSorted(double d, double d2, double d3, double d4, int n) {
        Set<Number> set = SGUtilityNumber.calcStepValue(d, d2, d3, d4, n);
        ArrayList<Number> arrayList = new ArrayList<Number>(set);
        double[] dArray = new double[arrayList.size()];
        for (int i = 0; i < dArray.length; ++i) {
            Number number = (Number)arrayList.get(i);
            dArray[i] = number.doubleValue();
        }
        Arrays.sort(dArray);
        return dArray;
    }

    public static double[] toArray(List<Double> list) {
        double[] dArray = new double[list.size()];
        for (int i = 0; i < dArray.length; ++i) {
            Double d = list.get(i);
            dArray[i] = d;
        }
        return dArray;
    }

    public static double getNumberInRangeOrder(double d, SGAxis sGAxis, int n, int n2) {
        int n3 = sGAxis.getScaleType();
        if (n3 == 0) {
            return SGUtilityNumber.getNumberInRangeOrder(d, sGAxis.getMinValue(), sGAxis.getMaxValue(), n, n2);
        }
        if (n3 == 1) {
            if (d == 0.0) {
                return 0.0;
            }
            int n4 = SGUtilityNumber.getOrder(d);
            double d2 = SGUtilityNumber.getPowersOfTen(n4);
            double d3 = d2 * 10.0;
            return SGUtilityNumber.getNumberInRangeOrder(d, d2, d3, n, n2);
        }
        throw new IllegalArgumentException("scale type is invalid");
    }

    public static String[] getStringArray(double[] dArray, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Decimal places must not be negatie: " + n);
        }
        NumberFormat numberFormat = SGUtilityNumber.createNumberFormat(n);
        int n3 = dArray.length;
        String[] stringArray = new String[n3];
        for (int i = 0; i < n3; ++i) {
            stringArray[i] = SGUtilityNumber.createExponentialString(dArray[i], numberFormat, n2);
        }
        return stringArray;
    }

    private static NumberFormat createNumberFormat(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('0');
        if (n > 0) {
            stringBuffer.append('.');
            for (int i = 0; i < n; ++i) {
                stringBuffer.append('0');
            }
        }
        String string = stringBuffer.toString();
        DecimalFormat decimalFormat = new DecimalFormat(string);
        return decimalFormat;
    }

    private static String createExponentialString(double d, NumberFormat numberFormat, int n) {
        if (Double.isNaN(d)) {
            return "";
        }
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.movePointLeft(n);
        StringBuffer stringBuffer = new StringBuffer();
        String string = numberFormat.format(bigDecimal.doubleValue());
        stringBuffer.append(string);
        if (n != 0) {
            stringBuffer.append('E');
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        double d = SGUtilityNumber.getNumberInNumberOrder(1.0459, 10.0, 5, 4);
        System.out.println(d);
    }
}

