/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIVisible;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGUtility
implements SGIConstants,
SGIDrawingElementConstants {
    private static boolean mMessageDialogWasVisible = false;

    public static void main(String[] stringArray) {
        System.out.println("*** START ***");
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        for (int i = 0; i < fontArray.length; ++i) {
            Font font = fontArray[i];
            System.out.println("-- " + font + " --");
            System.out.println("Name:     " + font.getName());
            System.out.println("FontName: " + font.getFontName());
            System.out.println("Family:   " + font.getFamily());
            System.out.println();
        }
        System.out.println();
        System.out.println("*** END ***");
    }

    public static String[] getAvailableFontFamilyNames() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    public static String findFontFamilyName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name == null");
        }
        String string2 = null;
        String[] stringArray = SGUtility.getAvailableFontFamilyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!SGUtilityText.isEqualString(stringArray[i], string)) continue;
            string2 = stringArray[i];
            break;
        }
        return string2;
    }

    public static String getCanonicalPath(String string) {
        File file = new File(string);
        String string2 = null;
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
        return string2;
    }

    public static Rectangle2D createUnion(ArrayList arrayList) {
        if (arrayList == null) {
            throw new IllegalArgumentException("rectList==null");
        }
        Rectangle2D rectangle2D = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            Rectangle2D rectangle2D2 = (Rectangle2D)arrayList.get(i);
            if (rectangle2D2 == null) {
                throw new IllegalArgumentException("rect==null");
            }
            rectangle2D = rectangle2D == null ? rectangle2D2 : rectangle2D2.createUnion(rectangle2D);
        }
        return rectangle2D;
    }

    public static double getRectStart(Rectangle2D rectangle2D, boolean bl) {
        if (bl) {
            return rectangle2D.getX();
        }
        return rectangle2D.getY();
    }

    public static double getRectSize(Rectangle2D rectangle2D, boolean bl) {
        if (bl) {
            return rectangle2D.getWidth();
        }
        return rectangle2D.getHeight();
    }

    public static double getRectEnd(Rectangle2D rectangle2D, boolean bl) {
        return SGUtility.getRectStart(rectangle2D, bl) + SGUtility.getRectSize(rectangle2D, bl);
    }

    public static boolean setRectStart(Rectangle2D rectangle2D, double d, boolean bl) {
        if (bl) {
            rectangle2D.setRect(d, rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), d, rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        return true;
    }

    public static boolean setRectEnd(Rectangle2D rectangle2D, double d, boolean bl) {
        if (bl) {
            rectangle2D.setRect(d - rectangle2D.getWidth(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), d - rectangle2D.getHeight(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        return true;
    }

    public static boolean setRectSize(Rectangle2D rectangle2D, double d, boolean bl) {
        if (bl) {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), d, rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), d);
        }
        return true;
    }

    public static boolean isRectContains(Rectangle2D rectangle2D, double d, boolean bl) {
        return SGUtilityNumber.contains(SGUtility.getRectStart(rectangle2D, bl), SGUtility.getRectEnd(rectangle2D, bl), d);
    }

    public static boolean isRectContains(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        return SGUtilityNumber.contains(SGUtility.getRectStart(rectangle2D, bl), SGUtility.getRectEnd(rectangle2D, bl), SGUtility.getRectStart(rectangle2D2, bl), SGUtility.getRectEnd(rectangle2D2, bl));
    }

    public static double getOverlapping(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        return SGUtilityNumber.getOverlap(SGUtility.getRectStart(rectangle2D, bl), SGUtility.getRectEnd(rectangle2D, bl), SGUtility.getRectStart(rectangle2D2, bl), SGUtility.getRectEnd(rectangle2D2, bl));
    }

    public static void clearMessageDialogVisible() {
        mMessageDialogWasVisible = false;
    }

    public static void setMessageDialogWasVisible() {
        mMessageDialogWasVisible = true;
    }

    public static boolean wasMessageDialogVisible() {
        return mMessageDialogWasVisible;
    }

    public static boolean showMessageDialog(Component component, Object object, String string, int n) {
        JOptionPane.showMessageDialog(component, object, string, n);
        SGUtility.setMessageDialogWasVisible();
        return true;
    }

    public static boolean showErrorMessageDialog(Component component, String string, String string2) {
        Toolkit.getDefaultToolkit().beep();
        SGUtility.showMessageDialog(component, string, string2, 0);
        return true;
    }

    public static boolean showIllegalInputErrorMessageDialog(Component component) {
        return SGUtility.showIllegalInputErrorMessageDialog(component, "The input value is illegal.");
    }

    public static boolean showIllegalInputErrorMessageDialog(Component component, String string) {
        return SGUtility.showErrorMessageDialog(component, string, "Illegal input");
    }

    public static boolean showFileNotFoundMessageDialog(Component component) {
        SGUtility.showMessageDialog(component, "Failed to open the file denoted by a specified pathname.", "File not found", 0);
        return true;
    }

    public static void setCenter(Window window, Window window2) {
        Dimension dimension = window2.getSize();
        int n = window.getWidth();
        int n2 = window.getHeight();
        int n3 = window2.getX() + (dimension.width - n) / 2;
        int n4 = window2.getY() + (dimension.height - n2) / 2;
        window.setLocation(n3, n4);
    }

    public static boolean copyObjects(List list, List list2) {
        if (list == null || list2 == null) {
            throw new IllegalArgumentException("list1==null || list2==null");
        }
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (!(e instanceof SGICopiable)) {
                throw new IllegalArgumentException("Not copiable objects are included.");
            }
            SGICopiable sGICopiable = (SGICopiable)e;
            list2.add((SGICopiable)sGICopiable.copy());
        }
        return true;
    }

    public static JMenuItem addItem(JPopupMenu jPopupMenu, ActionListener actionListener, String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    public static JMenuItem addItem(JPopupMenu jPopupMenu, ActionListener actionListener, String string, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
        jMenuItem.setEnabled(bl);
        return jMenuItem;
    }

    public static JCheckBoxMenuItem addCheckBoxItem(JPopupMenu jPopupMenu, ActionListener actionListener, String string) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        jPopupMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.addActionListener(actionListener);
        return jCheckBoxMenuItem;
    }

    public static boolean identifyOS(String string) {
        if (string == null) {
            throw new IllegalArgumentException("prefix==null");
        }
        return OS_NAME.toLowerCase().startsWith(string);
    }

    public static String getLookAndFeelID() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel != null) {
            return lookAndFeel.getID();
        }
        return null;
    }

    public static String[] copyStringArray(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    public static String[][] copyStringArray(String[][] stringArray) {
        String[][] stringArray2 = new String[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = SGUtility.copyStringArray(stringArray[i]);
        }
        return stringArray2;
    }

    public static int[] copyIntegerArray(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static Integer[] copyIntegerArray(Integer[] integerArray) {
        Integer[] integerArray2 = new Integer[integerArray.length];
        System.arraycopy(integerArray, 0, integerArray2, 0, integerArray.length);
        return integerArray2;
    }

    public static double[] copyDoubleArray(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        return dArray2;
    }

    public static double[][] copyDoubleArray(double[][] dArray) {
        double[][] dArrayArray = new double[dArray.length][];
        for (int i = 0; i < dArray.length; ++i) {
            dArrayArray[i] = SGUtility.copyDoubleArray(dArray[i]);
        }
        return dArrayArray;
    }

    public static boolean setValue(SGTextField sGTextField, Object object) {
        if (object == null) {
            sGTextField.setText(null);
        } else {
            String string = object.toString().trim();
            Double d = SGUtilityText.getDouble(string);
            if (d == null) {
                return false;
            }
            sGTextField.setText(string);
        }
        return true;
    }

    public static boolean setIntValue(SGTextField sGTextField, Object object) {
        if (object == null) {
            sGTextField.setText(null);
        } else {
            String string = object.toString().trim();
            Integer n = SGUtilityText.getInteger(string);
            if (n == null) {
                return false;
            }
            sGTextField.setText(string);
        }
        return true;
    }

    public static boolean setValue(SGSpinner sGSpinner, Object object) {
        if (object == null) {
            sGSpinner.setText("");
            return false;
        }
        String string = object.toString().trim();
        Double d = SGUtilityText.getDouble(string);
        if (d == null) {
            return false;
        }
        sGSpinner.setText(string);
        sGSpinner.setValue(d);
        try {
            sGSpinner.commitEditByDefault();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return true;
    }

    public static boolean setIntValue(SGSpinner sGSpinner, Object object) {
        if (object == null) {
            sGSpinner.setText("");
            return false;
        }
        String string = object.toString().trim();
        Integer n = SGUtilityText.getInteger(string);
        if (n == null) {
            return false;
        }
        sGSpinner.setText(string);
        sGSpinner.setValue(n.doubleValue());
        try {
            sGSpinner.commitEditByDefault();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return true;
    }

    public static int getMouseLocation(Rectangle2D rectangle2D, int n, int n2, float f) {
        boolean bl = Math.abs((double)n - rectangle2D.getMinX()) < (double)f;
        boolean bl2 = Math.abs((double)n - rectangle2D.getCenterX()) < (double)f;
        boolean bl3 = Math.abs((double)n - rectangle2D.getMaxX()) < (double)f;
        boolean bl4 = Math.abs((double)n2 - rectangle2D.getMinY()) < (double)f;
        boolean bl5 = Math.abs((double)n2 - rectangle2D.getCenterY()) < (double)f;
        boolean bl6 = Math.abs((double)n2 - rectangle2D.getMaxY()) < (double)f;
        int n3 = 0;
        if (bl) {
            if (bl4) {
                n3 = 5;
            } else if (bl5) {
                n3 = 3;
            } else if (bl6) {
                n3 = 7;
            }
        } else if (bl3) {
            if (bl4) {
                n3 = 6;
            } else if (bl5) {
                n3 = 4;
            } else if (bl6) {
                n3 = 8;
            }
        } else if (bl2) {
            if (bl4) {
                n3 = 1;
            } else if (bl6) {
                n3 = 2;
            }
        }
        return n3;
    }

    public static void resizeRectangle(Rectangle2D rectangle2D, Point point, MouseEvent mouseEvent, int n) {
        boolean bl = (mouseEvent.getModifiers() & 1) != 0;
        int n2 = mouseEvent.getX() - point.x;
        int n3 = mouseEvent.getY() - point.y;
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        float f5 = f3;
        float f6 = f4;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = f;
        float f10 = f2;
        float f11 = f3;
        float f12 = f4;
        if (n == 1) {
            point.setLocation(point.getX(), point.getY() + (double)n3);
            f8 = f6 - (float)n3;
            f10 = f2 + f6 - f8;
            f12 = f8;
        } else if (n == 2) {
            point.setLocation(point.getX(), point.getY() + (double)n3);
            f12 = f8 = f6 + (float)n3;
        } else if (n == 3) {
            point.setLocation(point.getX() + (double)n2, point.getY() + (double)n3);
            f7 = f5 - (float)n2;
            f9 = f + f5 - f7;
            f11 = f7;
        } else if (n == 4) {
            point.setLocation(point.getX() + (double)n2, point.getY());
            f11 = f7 = f5 + (float)n2;
        } else if (n == 5) {
            point.setLocation(point.getX() + (double)n2, point.getY() + (double)n3);
            f7 = f5 - (float)n2;
            f8 = bl ? f7 * (f6 / f5) : f6 - (float)n3;
            f9 = f + f5 - f7;
            f10 = f2 + f6 - f8;
            f11 = f7;
            f12 = f8;
        } else if (n == 6) {
            if (!bl) {
                point.setLocation(point.getX() + (double)n2, point.getY() + (double)n3);
                f7 = f5 + (float)n2;
                f8 = f6 - (float)n3;
                f10 = f2 + f6 - f8;
                f11 = f7;
                f12 = f8;
            } else {
                point.setLocation(point.getX(), point.getY() + (double)n3);
                f8 = f6 - (float)n3;
                f7 = f8 * (f5 / f6);
                f10 = f2 + f6 - f8;
                f11 = f7;
                f12 = f8;
            }
        } else if (n == 7) {
            if (!bl) {
                point.setLocation(point.getX() + (double)n2, point.getY() + (double)n3);
                f7 = f5 - (float)n2;
                f8 = f6 + (float)n3;
                f9 = f + f5 - f7;
                f11 = f7;
                f12 = f8;
            } else {
                point.setLocation(point.getX() + (double)n2, point.getY() + (double)n3);
                f7 = f5 - (float)n2;
                f8 = f7 * (f6 / f5);
                f9 = f + f5 - f7;
                f11 = f7;
                f12 = f8;
            }
        } else if (n == 8) {
            if (!bl) {
                point.setLocation(point.getX() + (double)n2, point.getY() + (double)n3);
                f7 = f5 + (float)n2;
                f8 = f6 + (float)n3;
                f11 = f7;
                f12 = f8;
            } else {
                point.setLocation(point.getX() + (double)n2, point.getY());
                f7 = f5 + (float)n2;
                f8 = f7 * (f6 / f5);
                f11 = f7;
                f12 = f8;
            }
        }
        rectangle2D.setRect(f9, f10, f11, f12);
    }

    public static boolean moveObjectToTail(Object object, List list) {
        return SGUtility.moveObjectTo(object, list, list.size() - 1);
    }

    public static boolean moveObjectToNext(Object object, List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        return SGUtility.moveObject(arrayList, list, 1);
    }

    public static boolean moveObjectToPrevious(Object object, List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        return SGUtility.moveObject(arrayList, list, -1);
    }

    public static boolean moveObjectToHead(Object object, List list) {
        return SGUtility.moveObjectTo(object, list, 0);
    }

    public static boolean moveObjectTo(Object object, List list, int n) {
        if (list == null) {
            throw new IllegalArgumentException("list==null");
        }
        if (n < 0 || n >= list.size()) {
            throw new IllegalArgumentException("index < 0 || index >= list.size() : " + n);
        }
        if (!list.remove(object)) {
            return false;
        }
        list.add(n, object);
        return true;
    }

    public static boolean moveObject(List list, List list2, int n) {
        if (n > 0) {
            for (int i = list.size() - 1; i >= 0; --i) {
                Object e = list.get(i);
                int n2 = list2.indexOf(e);
                if (n2 == -1) {
                    return false;
                }
                int n3 = n2 + n;
                if (n3 > list2.size() - 1 || SGUtility.moveObjectTo(e, list2, n3)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                int n4 = list2.indexOf(e);
                if (n4 == -1) {
                    return false;
                }
                int n5 = n4 + n;
                if (n5 < 0 || SGUtility.moveObjectTo(e, list2, n5)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean setVisibleList(List list, List list2) {
        int n;
        ArrayList<SGIVisible> arrayList = new ArrayList<SGIVisible>();
        for (n = 0; n < list.size(); ++n) {
            SGIVisible sGIVisible = (SGIVisible)list.get(n);
            boolean bl = list2.contains(sGIVisible);
            sGIVisible.setVisible(bl);
            if (bl) continue;
            arrayList.add(sGIVisible);
        }
        list.clear();
        for (n = 0; n < list2.size(); ++n) {
            list.add(list2.get(n));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            list.add(arrayList.get(n));
        }
        return true;
    }

    public static String getFileName(String string) {
        String string2 = FILE_SEPARATOR;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (string3 == null) {
            string3 = string;
        }
        stringTokenizer = new StringTokenizer(string3, "/");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        return string3;
    }

    public static String getSimpleFileName(String string) {
        String string2 = SGUtility.getFileName(string);
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, Character.toString('.'));
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public static String createDataNameBase(String string) {
        if (!SGUtilityText.isValidString(string)) {
            return null;
        }
        String string2 = SGUtility.getSimpleFileName(string);
        String string3 = SGUtility.addEscapeChar(string2);
        return string3;
    }

    public static String addEscapeChar(String string) {
        int n;
        char[] cArray = string.toCharArray();
        ArrayList<Character> arrayList = new ArrayList<Character>();
        for (int i = 0; i < cArray.length; ++i) {
            n = cArray[i];
            if (n == 95 || n == 94) {
                arrayList.add(Character.valueOf('\\'));
            }
            arrayList.add(Character.valueOf((char)n));
        }
        char[] cArray2 = new char[arrayList.size()];
        for (n = 0; n < cArray2.length; ++n) {
            cArray2[n] = ((Character)arrayList.get(n)).charValue();
        }
        String string2 = new String(cArray2);
        return string2;
    }

    public static String removeEscapeChar(String string) {
        int n;
        char[] cArray = string.toCharArray();
        ArrayList<Character> arrayList = new ArrayList<Character>();
        for (int i = 0; i < cArray.length; ++i) {
            n = cArray[i];
            if (n == 92) continue;
            arrayList.add(Character.valueOf((char)n));
        }
        char[] cArray2 = new char[arrayList.size()];
        for (n = 0; n < cArray2.length; ++n) {
            cArray2[n] = ((Character)arrayList.get(n)).charValue();
        }
        String string2 = new String(cArray2);
        return string2;
    }

    public static boolean equals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray != null) {
            if (objectArray2 == null) {
                return false;
            }
            if (objectArray.length != objectArray2.length) {
                return false;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] != null ? !objectArray[i].equals(objectArray2[i]) : objectArray2 != null)) continue;
                return false;
            }
        } else if (objectArray2 != null) {
            return false;
        }
        return true;
    }

    public static boolean equals(Object object, Object object2) {
        if (object != null) {
            return object.equals(object2);
        }
        return object2 == null;
    }

    public static boolean isValidPropertyValue(float f) {
        return !Float.isNaN(f) && !Float.isInfinite(f);
    }

    public static boolean isValidPropertyValue(double d) {
        return !Double.isNaN(d) && !Double.isInfinite(d);
    }

    public static Float calcPropertyValue(float f, String string, String string2, double d, double d2, int n) {
        double d3;
        if (!SGUtility.isValidPropertyValue(f)) {
            return null;
        }
        if (string == null || string2 == null) {
            if ((double)f < d) {
                return null;
            }
            if ((double)f > d2) {
                return null;
            }
            d3 = f;
        } else {
            double d4 = SGUtilityText.convert(f, string, string2);
            if (d4 < d) {
                return null;
            }
            if (d4 > d2) {
                return null;
            }
            d3 = d4;
        }
        int n2 = n - 1;
        double d5 = SGUtilityNumber.roundOffNumber(d3, n2);
        float f2 = string2 == null ? (float)d5 : (float)SGUtilityText.convertToPoint(d5, string2);
        return Float.valueOf(f2);
    }

    public static final Float getLineWidth(float f, String string) {
        return SGUtility.calcPropertyValue(f, string, "pt", 0.25, 6.0, -2);
    }

    public static final Float getFontSize(float f, String string) {
        return SGUtility.calcPropertyValue(f, string, "pt", 6.0, 96.0, -2);
    }

    public static int getAxisLocation(String string) {
        int n = -1;
        if (SGUtilityText.isEqualString("Bottom", string)) {
            n = 0;
        } else if (SGUtilityText.isEqualString("Top", string)) {
            n = 1;
        } else if (SGUtilityText.isEqualString("Left", string)) {
            n = 2;
        } else if (SGUtilityText.isEqualString("Right", string)) {
            n = 3;
        }
        return n;
    }

    public static String getLocationName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "Bottom";
                break;
            }
            case 1: {
                string = "Top";
                break;
            }
            case 2: {
                string = "Left";
                break;
            }
            case 3: {
                string = "Right";
                break;
            }
            case 4: {
                string = "ColorBar";
            }
        }
        return string;
    }

    public static int getLocationInPlane(String string) {
        int n = -1;
        if (SGUtilityText.isEqualString("Bottom", string)) {
            n = 0;
        } else if (SGUtilityText.isEqualString("Top", string)) {
            n = 1;
        } else if (SGUtilityText.isEqualString("Left", string)) {
            n = 2;
        } else if (SGUtilityText.isEqualString("Right", string)) {
            n = 3;
        } else if (SGUtilityText.isEqualString("ColorBar", string)) {
            n = 4;
        }
        return n;
    }

    public static int assignIdNumber(List<Integer> list) {
        int n;
        if (list.size() == 0) {
            return 1;
        }
        Object[] objectArray = new Integer[list.size()];
        objectArray = list.toArray(objectArray);
        Arrays.sort(objectArray);
        int n2 = (Integer)objectArray[objectArray.length - 1];
        if (n2 == Integer.MAX_VALUE) {
            if (objectArray.length == Integer.MAX_VALUE) {
                throw new Error("Failed to assign new ID number.");
            }
            n = 1;
            for (int i = 0; i < objectArray.length; ++i) {
                int n3 = i + 1;
                if ((Integer)objectArray[i] == n3) continue;
                n = n3;
                break;
            }
        } else {
            n = n2 + 1;
        }
        return n;
    }

    public static boolean containsNullIgnored(Object[] objectArray, Object object) {
        if (objectArray == null) {
            throw new IllegalArgumentException("array == null");
        }
        if (object == null) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || !objectArray[i].equals(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNullIgnored(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null || objectArray2 == null) {
            throw new IllegalArgumentException("a1 == null || a2 == null");
        }
        for (int i = 0; i < objectArray2.length; ++i) {
            if (!SGUtility.containsNullIgnored(objectArray, objectArray2[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Object[] objectArray, Object object) {
        if (objectArray == null) {
            throw new IllegalArgumentException("array == null");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!SGUtility.equals(objectArray[i], object)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null || objectArray2 == null) {
            throw new IllegalArgumentException("a1 == null || a2 == null");
        }
        for (int i = 0; i < objectArray2.length; ++i) {
            if (!SGUtility.contains(objectArray, objectArray2[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(List list, List list2) {
        if (list == null || list2 == null) {
            throw new IllegalArgumentException("a1 == null || a2 == null");
        }
        for (int i = 0; i < list2.size(); ++i) {
            if (!list.contains(list2.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(List list, List list2) {
        if (list == null || list2 == null) {
            throw new IllegalArgumentException("a1 == null || a2 == null");
        }
        for (int i = 0; i < list2.size(); ++i) {
            if (list.contains(list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static Integer[] readIndices(Element element, String string) {
        String string2 = element.getAttribute(string);
        return SGUtilityText.parseIndices(string2);
    }

    public static String getNumberName(double d) {
        String string;
        boolean bl = d < 0.0;
        if ((d = Math.abs(d)) == 0.0) {
            return "0";
        }
        if (d > 10000.0) {
            double d2 = d;
            int n = 0;
            while (d2 >= 1.0) {
                d2 /= 10.0;
                ++n;
            }
            d2 = d / Math.pow(10.0, n - 1);
            string = String.format("%.2f", d2);
            string = SGUtility.removeLastZero(string);
            string = string + String.format("e%d", n - 1);
        } else if (d > 100.0) {
            string = String.format("%.0f", d);
        } else if (d > 1.0) {
            string = String.format("%.2f", d);
            string = SGUtility.removeLastZero(string);
        } else if (d > 1.0E-4) {
            string = String.format("%.4f", d);
            string = SGUtility.removeLastZero(string);
        } else {
            double d3 = d;
            int n = 0;
            while (d3 < 10.0) {
                d3 *= 10.0;
                ++n;
            }
            d3 = d * Math.pow(10.0, n - 1);
            string = String.format("%.2f", d3);
            string = SGUtility.removeLastZero(string);
            string = string + String.format("e-%d", n - 1);
        }
        if (bl) {
            return "-" + string;
        }
        return string;
    }

    private static String removeLastZero(String string) {
        while (string.substring(string.length() - 1).equals("0")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.substring(string.length() - 1).equals(".")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

