/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGIPaint;

public abstract class SGTransparentPaint
implements SGIPaint {
    public static final float MIN_TRANSPARENCY = 0.0f;
    public static final float MAX_TRANSPARENCY = 1.0f;
    public static final float OPAQUE_THRESHOLD_VALUE = 0.98f;
    public static final int ALL_TRANSPARENT_VALUE = 100;
    public static final int ALL_OPAQUE_VALUE = 0;
    protected float mAlpha = 1.0f;
    protected float mMagnification = 1.0f;

    public float getAlpha() {
        return this.mAlpha;
    }

    public boolean setAlpha(float f) {
        if (f < 0.0f || f > 1.0f) {
            return false;
        }
        this.mAlpha = f;
        return true;
    }

    public int getTransparencyPercent() {
        return Math.round((1.0f - this.mAlpha) * 100.0f);
    }

    public boolean setTransparency(int n) {
        return this.setAlpha((float)(100 - n) * 0.01f);
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public boolean setMagnification(float f) {
        if (f <= 0.0f) {
            return false;
        }
        this.mMagnification = f;
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        SGTransparentPaint sGTransparentPaint = (SGTransparentPaint)super.clone();
        return sGTransparentPaint;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SGTransparentPaint)) {
            return false;
        }
        SGTransparentPaint sGTransparentPaint = (SGTransparentPaint)object;
        if (sGTransparentPaint.mAlpha != this.mAlpha) {
            return false;
        }
        return sGTransparentPaint.mMagnification == this.mMagnification;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + Float.floatToIntBits(this.mAlpha);
        n = 37 * n + Float.floatToIntBits(this.mMagnification);
        return n;
    }

    public Color getTransparentedColor(Color color) {
        if (this.mAlpha > 0.98f) {
            return color;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0f * this.mAlpha));
    }

    public static Color getOpaqueColor(Color color) {
        return new Color(color.getRGB());
    }
}

