/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

public class SGSpinner
extends JSpinner
implements SGIConstants,
FocusListener,
KeyListener,
MouseListener {
    private static final long serialVersionUID = -107749809547053625L;
    private static final String SUFFIX_CM = " cm";
    private static final String SUFFIX_MM = " mm";
    private static final String SUFFIX_PT = " pt";
    private static final String SUFFIX_INCH = " inch";
    private static final String SUFFIX_DEGREE = degree;
    private static final String SUFFIX_PERCENT = " %";
    private static final int MODE_DEFAULT = 0;
    private static final int MODE_ON_STEP = 1;
    private String mDescription = "";
    private Number mBaselineValue = 0.0;
    private double[] mStepArray = null;
    private String mTempString = null;
    private Point mPressedPoint = null;

    public SGSpinner() {
    }

    public SGSpinner(SpinnerNumberModel spinnerNumberModel, String string, int n, int n2) {
        this.initProperties(spinnerNumberModel, string, n, n2);
    }

    public void initProperties(SpinnerNumberModel spinnerNumberModel, String string, int n, int n2) {
        Object object;
        if (spinnerNumberModel == null) {
            throw new IllegalArgumentException("model == null");
        }
        if (spinnerNumberModel.getStepSize().doubleValue() < Double.MIN_VALUE) {
            throw new IllegalArgumentException("too small step value");
        }
        int n3 = -(n2 + 1);
        double d = SGUtilityNumber.roundOffNumber(((Number)((Object)spinnerNumberModel.getMinimum())).doubleValue(), n3);
        double d2 = SGUtilityNumber.roundOffNumber(((Number)((Object)spinnerNumberModel.getMaximum())).doubleValue(), n3);
        spinnerNumberModel.setMinimum(Double.valueOf(d));
        spinnerNumberModel.setMaximum(Double.valueOf(d2));
        this.setModel(spinnerNumberModel);
        this.setEditor(new JSpinner.NumberEditor((JSpinner)this, "0"));
        if (string != null) {
            object = SGSpinner.getSuffix(string);
            DecimalFormat decimalFormat = this.getDecimalFormat();
            decimalFormat.setPositiveSuffix((String)object);
            decimalFormat.setNegativeSuffix((String)object);
        }
        object = this.getFormattedTextField();
        ((JFormattedTextField)object).setFocusLostBehavior(3);
        ((JTextField)object).setHorizontalAlignment(2);
        ((Component)object).addFocusListener(this);
        ((Component)object).addKeyListener(this);
        ((Component)object).addMouseListener(this);
        this.setMinimumFractionDigits(n);
        this.setMaximumFractionDigits(n2);
        this.mStepArray = SGUtilityNumber.calcStepValueSorted(this.getMinimumValue().doubleValue(), this.getMaximumValue().doubleValue(), this.mBaselineValue.doubleValue(), this.getStepValue().doubleValue(), n2 + 1);
    }

    public void setDescription(String string) {
        if (string == null) {
            throw new IllegalArgumentException("str == null");
        }
        this.mDescription = string;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public boolean isEditable() {
        return this.getFormattedTextField().isEditable();
    }

    public void setEditable(boolean bl) {
        this.getFormattedTextField().setEditable(bl);
    }

    public JFormattedTextField getFormattedTextField() {
        JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)this.getEditor();
        JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
        return jFormattedTextField;
    }

    public String getText() {
        return this.getFormattedTextField().getText();
    }

    public void setText(String string) {
        this.getFormattedTextField().setText(string);
    }

    public DecimalFormat getDecimalFormat() {
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)this.getEditor();
        return numberEditor.getFormat();
    }

    private static String getSuffix(String string) {
        String string2 = null;
        if (string.equals("cm")) {
            string2 = SUFFIX_CM;
        } else if ("mm".equals(string)) {
            string2 = SUFFIX_MM;
        } else if ("pt".equals(string)) {
            string2 = SUFFIX_PT;
        } else if ("inch".equals(string)) {
            string2 = SUFFIX_INCH;
        } else if (SGIConstants.degree.equals(string)) {
            string2 = SUFFIX_DEGREE;
        } else if ("%".equals(string)) {
            string2 = SUFFIX_PERCENT;
        }
        return string2;
    }

    public String getUnit() {
        String string = this.getSuffix();
        String string2 = null;
        if (SUFFIX_CM.equals(string)) {
            string2 = "cm";
        } else if (SUFFIX_MM.equals(string)) {
            string2 = "mm";
        } else if (SUFFIX_INCH.equals(string)) {
            string2 = "inch";
        } else if (SUFFIX_PT.equals(string)) {
            string2 = "pt";
        } else if (SUFFIX_DEGREE.equals(string)) {
            string2 = SGIConstants.degree;
        } else if (SUFFIX_PERCENT.equals(string)) {
            string2 = "%";
        }
        return string2;
    }

    private String getSuffix() {
        return this.getDecimalFormat().getPositiveSuffix();
    }

    public int getMinimumFractionDigits() {
        return this.getDecimalFormat().getMinimumFractionDigits();
    }

    public int getMaximumFractionDigits() {
        return this.getDecimalFormat().getMaximumFractionDigits();
    }

    private void setMinimumFractionDigits(int n) {
        this.getDecimalFormat().setMinimumFractionDigits(n);
    }

    private void setMaximumFractionDigits(int n) {
        this.getDecimalFormat().setMaximumFractionDigits(n);
    }

    private int getDigitForRoundingOut() {
        return -this.getMaximumFractionDigits() - 1;
    }

    private boolean isInteger() {
        int n = this.getMinimumFractionDigits();
        int n2 = this.getMaximumFractionDigits();
        return n == 0 && n2 == 0;
    }

    private SpinnerNumberModel getSpinnerNumberModel() {
        return (SpinnerNumberModel)this.getModel();
    }

    public Number getMinimumValue() {
        return (Number)((Object)this.getSpinnerNumberModel().getMinimum());
    }

    public Number getMaximumValue() {
        return (Number)((Object)this.getSpinnerNumberModel().getMaximum());
    }

    public Number getStepValue() {
        return this.getSpinnerNumberModel().getStepSize();
    }

    public Number getBaselineValue() {
        return this.mBaselineValue;
    }

    private Number getValueOnStepInside(double d, double d2) {
        double d3;
        double d4;
        if (d < d2) {
            d4 = d;
            d3 = d2;
        } else if (d2 < d) {
            d4 = d2;
            d3 = d;
        } else {
            return null;
        }
        for (int i = 0; i < this.mStepArray.length; ++i) {
            double d5 = this.mStepArray[i];
            if (!(d4 < d5) || !(d5 < d3)) continue;
            return d5;
        }
        return null;
    }

    public void commitEdit() throws ParseException {
        this.commit(1);
        super.commitEdit();
        this.mTempString = this.getText();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                String string = SGSpinner.this.getText();
                if (SGSpinner.this.mTempString != null && !string.equals(SGSpinner.this.mTempString)) {
                    String string2 = SGSpinner.this.getUnit();
                    if (!SGSpinner.this.isInteger()) {
                        String string3 = SGUtilityText.removeSuffix(SGSpinner.this.mTempString, string2);
                        String string4 = SGUtilityText.removeSuffix(string, string2);
                        Double d = Double.valueOf(string3);
                        Double d2 = Double.valueOf(string4);
                        Number number = SGSpinner.this.getValueOnStepInside(d, d2);
                        if (number == null) {
                            number = d2;
                        }
                        SGSpinner.this.setValue(number);
                    }
                }
                SGSpinner.this.mTempString = null;
                EventQueue.invokeLater(new CaretPositionAdjuster());
            }
        });
    }

    public boolean hasValidValue() {
        String string;
        Number number = this.getNumber();
        return number != null || "".equals(string = this.getText());
    }

    void clearTemporaryValues() {
        this.mTempString = null;
    }

    public Number getNumber() {
        try {
            this.commitEditByDefault();
        }
        catch (Exception exception) {
            return null;
        }
        Object object = this.getValue();
        return (Number)object;
    }

    public void commitEditByDefault() throws ParseException {
        this.commit(0);
        super.commitEdit();
    }

    private void commit(int n) throws ParseException {
        JFormattedTextField jFormattedTextField = this.getFormattedTextField();
        String string = this.parseString(jFormattedTextField.getText(), n);
        if (string != null) {
            jFormattedTextField.setText(string);
            jFormattedTextField.commitEdit();
        } else {
            throw new ParseException("parse failed", 0);
        }
    }

    private String parseString(String string, int n) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        String string2 = this.getUnit();
        if (string2 == null) {
            Double d = SGUtilityText.getDouble(string);
            if (d == null) {
                return null;
            }
            if (this.isInteger()) {
                double d2 = d;
                int n2 = (int)Math.rint(d2);
                int n3 = this.getMinimumValue().intValue();
                int n4 = this.getMaximumValue().intValue();
                if (n2 < n3) {
                    n2 = n3;
                }
                if (n2 > n4) {
                    n2 = n4;
                }
                String string3 = Integer.toString(n2);
                return string3;
            }
            return ((Object)d).toString();
        }
        String string4 = null;
        Object object = null;
        object = this.isInteger() ? (Number)SGUtilityText.getInteger(string) : (Number)SGUtilityText.getDouble(string);
        string4 = object != null ? object.toString() + SGSpinner.getSuffix(string2) : string;
        object = null;
        object = SGUtilityText.isLengthUnit(string2) ? SGUtilityText.convertString(string4, string2) : SGUtilityText.removeSuffix(string4, string2);
        if (object == null) {
            return null;
        }
        if (this.isInteger()) {
            int n5 = Integer.valueOf(((String)object).trim());
            int n6 = this.getMinimumValue().intValue();
            int n7 = this.getMaximumValue().intValue();
            if (n5 < n6) {
                n5 = n6;
            }
            if (n5 > n7) {
                n5 = n7;
            }
            String string5 = Integer.toString(n5) + SGSpinner.getSuffix(string2);
            return string5;
        }
        double d = SGUtilityText.getDouble((String)object);
        double d3 = this.getMinimumValue().doubleValue();
        double d4 = this.getMaximumValue().doubleValue();
        if (d < d3) {
            d = d3;
        }
        if (d > d4) {
            d = d4;
        }
        double d5 = 0.0;
        switch (n) {
            case 0: {
                d5 = SGUtilityNumber.roundOffNumber(d, this.getDigitForRoundingOut());
                break;
            }
            case 1: {
                d5 = d;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        String string6 = Double.valueOf(d5).toString() + SGSpinner.getSuffix(string2);
        return string6;
    }

    private String getTextSuffix() {
        String string = this.getText();
        String string2 = null;
        String[] stringArray = new String[]{"cm", "mm", "pt", "inch", SGIConstants.degree};
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            if (!string.endsWith(stringArray[i])) continue;
            string2 = stringArray[i];
            int n2 = string.length() - string2.length() - 1;
            if (n2 <= 0) break;
            int n3 = 0;
            for (int j = n2; j >= 0 && (n = string.charAt(j)) == 32; --j) {
                ++n3;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < n3; ++n) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string2);
            string2 = stringBuffer.toString();
            break;
        }
        return string2;
    }

    public void focusGained(FocusEvent focusEvent) {
        EventQueue.invokeLater(new CaretPositionAdjuster());
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\n') {
            JFormattedTextField jFormattedTextField = this.getFormattedTextField();
            ActionEvent actionEvent = new ActionEvent(jFormattedTextField, 0, "Enter");
            ActionListener[] actionListenerArray = jFormattedTextField.getActionListeners();
            for (int i = 0; i < actionListenerArray.length; ++i) {
                actionListenerArray[i].actionPerformed(actionEvent);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mPressedPoint = mouseEvent.getPoint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    class CaretPositionAdjuster
    implements Runnable {
        CaretPositionAdjuster() {
        }

        public void run() {
            int n;
            JFormattedTextField jFormattedTextField = SGSpinner.this.getFormattedTextField();
            String string = jFormattedTextField.getText();
            if (string.length() == 0) {
                return;
            }
            if (SGSpinner.this.mPressedPoint != null) {
                Font font = SGSpinner.this.getFont();
                FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
                TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
                TextHitInfo textHitInfo = textLayout.hitTestChar(((SGSpinner)SGSpinner.this).mPressedPoint.x, ((SGSpinner)SGSpinner.this).mPressedPoint.y);
                n = textHitInfo.getInsertionIndex();
                SGSpinner.this.mPressedPoint = null;
            } else {
                String string2 = SGSpinner.this.getTextSuffix();
                int n2 = 0;
                if (string2 != null) {
                    n2 = string2.length();
                }
                n = string.length() - n2;
            }
            jFormattedTextField.setCaretPosition(n);
        }
    }
}

