/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import jp.riken.brain.ni.samuraigraph.base.SGFillPaint;
import jp.riken.brain.ni.samuraigraph.base.SGGradationPaint;
import jp.riken.brain.ni.samuraigraph.base.SGNullPaint;
import jp.riken.brain.ni.samuraigraph.base.SGPatternPaint;
import jp.riken.brain.ni.samuraigraph.base.SGTransparentPaint;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

public class SGSelectablePaint
extends SGTransparentPaint {
    public static final String NAME_UNKNOWN = "UNKNOWN";
    public static final String STYLE_NAME_FILL = "Fill";
    public static final String STYLE_NAME_PATTERN = "Pattern";
    public static final String STYLE_NAME_GRADATION = "Gradation";
    public static final int STYLE_INDEX_FILL = 0;
    public static final int STYLE_INDEX_PATTERN = 1;
    public static final int STYLE_INDEX_GRADATION = 2;
    public static final int[] STYLE_INDEXES = new int[]{0, 1, 2};
    public static final String[] STYLE_NAMES = new String[]{"Fill", "Pattern", "Gradation"};
    protected SGFillPaint mFillPaint = new SGFillPaint();
    protected SGPatternPaint mPatternPaint = new SGPatternPaint();
    protected SGGradationPaint mGradationPaint = new SGGradationPaint();
    protected int mPaintStyleIndex;

    public SGSelectablePaint() {
        this.init();
    }

    protected void init() {
        this.mPaintStyleIndex = 0;
    }

    public Paint getPaint(Rectangle2D rectangle2D) {
        Paint paint = null;
        switch (this.mPaintStyleIndex) {
            case 0: {
                paint = this.mFillPaint.getPaint(rectangle2D);
                break;
            }
            case 1: {
                paint = this.mPatternPaint.getPaint(rectangle2D);
                break;
            }
            case 2: {
                paint = this.mGradationPaint.getPaint(rectangle2D);
                break;
            }
        }
        if (null == paint) {
            return new SGNullPaint().getPaint(rectangle2D);
        }
        return paint;
    }

    public boolean setAlpha(float f) {
        if (super.setAlpha(f)) {
            this.mFillPaint.setAlpha(f);
            this.mPatternPaint.setAlpha(f);
            this.mGradationPaint.setAlpha(f);
            return true;
        }
        return false;
    }

    public boolean setMagnification(float f) {
        if (super.setMagnification(f)) {
            this.mFillPaint.setMagnification(f);
            this.mPatternPaint.setMagnification(f);
            this.mGradationPaint.setMagnification(f);
            return true;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        SGSelectablePaint sGSelectablePaint = (SGSelectablePaint)super.clone();
        sGSelectablePaint.mFillPaint = (SGFillPaint)this.mFillPaint.clone();
        sGSelectablePaint.mPatternPaint = (SGPatternPaint)this.mPatternPaint.clone();
        sGSelectablePaint.mGradationPaint = (SGGradationPaint)this.mGradationPaint.clone();
        return sGSelectablePaint;
    }

    public Color getFillColor() {
        return (Color)this.mFillPaint.getPaint(null);
    }

    public Color getPatternColor() {
        return this.mPatternPaint.getColor();
    }

    public Integer getPatternIndex() {
        return this.mPatternPaint.getTypeIndex();
    }

    public SGPatternPaint getPatternPaint() {
        try {
            return (SGPatternPaint)this.mPatternPaint.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    public SGGradationPaint getGradationPaint() {
        try {
            return (SGGradationPaint)this.mGradationPaint.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    public Integer getSelectedStyle() {
        return this.mPaintStyleIndex;
    }

    public boolean setFillColor(Color color) {
        return this.mFillPaint.setColor(color);
    }

    public boolean setPatternPaint(SGPatternPaint sGPatternPaint) {
        if (null == sGPatternPaint) {
            return false;
        }
        try {
            this.mPatternPaint = (SGPatternPaint)sGPatternPaint.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
        return true;
    }

    public boolean setPatternColor(Color color) {
        return this.mPatternPaint.setColor(color);
    }

    public boolean setPatternIndex(int n) {
        return this.mPatternPaint.setTypeIndex(n);
    }

    public boolean setGradationPaint(SGGradationPaint sGGradationPaint) {
        if (null == sGGradationPaint) {
            return false;
        }
        this.mGradationPaint.setColors(sGGradationPaint.getColors());
        this.mGradationPaint.setDirection(sGGradationPaint.getDirectionIndex());
        this.mGradationPaint.setOrder(sGGradationPaint.getOrderIndex());
        return true;
    }

    public boolean setGradationColor1(Color color) {
        if (null == color) {
            return false;
        }
        return this.mGradationPaint.setColor1(color);
    }

    public boolean setGradationColor2(Color color) {
        if (null == color) {
            return false;
        }
        return this.mGradationPaint.setColor2(color);
    }

    public boolean setGradationDirection(int n) {
        return this.mGradationPaint.setDirection(n);
    }

    public boolean setGradationOrder(int n) {
        return this.mGradationPaint.setOrder(n);
    }

    public boolean setSelectedPaintStyle(int n) {
        if (!SGSelectablePaint.isValidStyle(n)) {
            return false;
        }
        this.mPaintStyleIndex = n;
        return true;
    }

    public static boolean isValidStyle(int n) {
        int[] nArray = STYLE_INDEXES;
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public static String getStyleName(int n) {
        if (!SGSelectablePaint.isValidStyle(n)) {
            return NAME_UNKNOWN;
        }
        switch (n) {
            case 0: {
                return STYLE_NAME_FILL;
            }
            case 1: {
                return STYLE_NAME_PATTERN;
            }
            case 2: {
                return STYLE_NAME_GRADATION;
            }
        }
        return NAME_UNKNOWN;
    }

    public static Integer getStyleIndex(String string) {
        for (int i = 0; i < STYLE_NAMES.length; ++i) {
            if (!SGUtilityText.isEqualString(string, STYLE_NAMES[i])) continue;
            return STYLE_INDEXES[i];
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SGSelectablePaint)) {
            return false;
        }
        SGSelectablePaint sGSelectablePaint = (SGSelectablePaint)object;
        if (!super.equals(sGSelectablePaint)) {
            return false;
        }
        if (sGSelectablePaint.mPaintStyleIndex != this.mPaintStyleIndex) {
            return false;
        }
        if (!sGSelectablePaint.mFillPaint.equals(this.mFillPaint)) {
            return false;
        }
        if (!sGSelectablePaint.mPatternPaint.equals(this.mPatternPaint)) {
            return false;
        }
        return sGSelectablePaint.mGradationPaint.equals(this.mGradationPaint);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 37 * n + this.mFillPaint.hashCode();
        n = 37 * n + this.mPatternPaint.hashCode();
        n = 37 * n + this.mGradationPaint.hashCode();
        n = 37 * n + this.mPaintStyleIndex;
        return n;
    }
}

