/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.riken.brain.ni.samuraigraph.base.SGColorDialog;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGGradationPaint;
import jp.riken.brain.ni.samuraigraph.base.SGGradationPaintSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGRadioButton;

public class SGGradationPaintDialog
extends JDialog
implements ActionListener,
FocusListener,
ChangeListener {
    private static final long serialVersionUID = 3040335379897961866L;
    protected SGGradationPaint mGradationPaint = null;
    private JPanel mColorSelectionPanel = null;
    private JLabel mColorSelectionLabel1 = null;
    private JLabel mColorSelectionLabel2 = null;
    private SGColorSelectionButton mColorSelectionButton1 = null;
    private SGColorSelectionButton mColorSelectionButton2 = null;
    private JPanel mDirectionPanel = null;
    private SGRadioButton mDirectionVerticalRadioButton = null;
    private SGRadioButton mDirectionHorizontalRadioButton = null;
    private SGRadioButton mDirectionUpperRightRadioButton = null;
    private SGRadioButton mDirectionLowerRigthRadioButton = null;
    private JPanel mOrderPanel = null;
    private SGGradationPaintSelectionButton mOrderButtonPanel1 = null;
    private SGGradationPaintSelectionButton mOrderButtonPanel2 = null;
    private SGGradationPaintSelectionButton mOrderButtonPanel3 = null;
    private SGGradationPaintSelectionButton mOrderButtonPanel4 = null;
    protected SGColorDialog mColorDialog = null;
    protected SGColorSelectionButton mCurrentColorSetButton = null;
    protected SGGradationPaintSelectionButton mCurrentOrderSetButton = null;
    private Icon mColorSelectionButtonEmphasisIcon = null;
    private List<ChangeListener> _listener = new ArrayList<ChangeListener>();
    private ChangeEvent _changeEvent = null;

    public SGGradationPaintDialog(JDialog jDialog, String string, boolean bl) {
        super(jDialog, string, bl);
        this.mGradationPaint = new SGGradationPaint();
        this.initComponents();
        this.initProperty();
        this.initialize();
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mColorSelectionPanel = new JPanel();
        this.mColorSelectionLabel1 = new JLabel();
        this.mColorSelectionLabel2 = new JLabel();
        this.mColorSelectionButton1 = new SGColorSelectionButton();
        this.mColorSelectionButton2 = new SGColorSelectionButton();
        this.mDirectionPanel = new JPanel();
        this.mDirectionVerticalRadioButton = new SGRadioButton();
        this.mDirectionHorizontalRadioButton = new SGRadioButton();
        this.mDirectionUpperRightRadioButton = new SGRadioButton();
        this.mDirectionLowerRigthRadioButton = new SGRadioButton();
        this.mOrderPanel = new JPanel();
        this.mOrderButtonPanel1 = new SGGradationPaintSelectionButton();
        this.mOrderButtonPanel2 = new SGGradationPaintSelectionButton();
        this.mOrderButtonPanel3 = new SGGradationPaintSelectionButton();
        this.mOrderButtonPanel4 = new SGGradationPaintSelectionButton();
        this.mColorSelectionPanel.setLayout(new GridBagLayout());
        this.mColorSelectionPanel.setBorder(BorderFactory.createTitledBorder("Color"));
        this.mColorSelectionLabel1.setText("Color1");
        this.mColorSelectionLabel1.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mColorSelectionPanel.add((Component)this.mColorSelectionLabel1, gridBagConstraints);
        this.mColorSelectionLabel2.setText("Color2");
        this.mColorSelectionLabel2.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mColorSelectionPanel.add((Component)this.mColorSelectionLabel2, gridBagConstraints);
        this.mColorSelectionButton1.setFont(new Font("Dialog", 0, 11));
        this.mColorSelectionButton1.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mColorSelectionPanel.add((Component)this.mColorSelectionButton1, gridBagConstraints);
        this.mColorSelectionButton2.setFont(new Font("Dialog", 0, 11));
        this.mColorSelectionButton2.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mColorSelectionPanel.add((Component)this.mColorSelectionButton2, gridBagConstraints);
        this.mDirectionPanel.setLayout(new GridBagLayout());
        this.mDirectionPanel.setBorder(BorderFactory.createTitledBorder("Direction"));
        this.mDirectionVerticalRadioButton.setText("Vertical");
        this.mDirectionVerticalRadioButton.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mDirectionPanel.add((Component)this.mDirectionVerticalRadioButton, gridBagConstraints);
        this.mDirectionHorizontalRadioButton.setText("Horizontal");
        this.mDirectionHorizontalRadioButton.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mDirectionPanel.add((Component)this.mDirectionHorizontalRadioButton, gridBagConstraints);
        this.mDirectionUpperRightRadioButton.setText("Diagonal (upper right)");
        this.mDirectionUpperRightRadioButton.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mDirectionPanel.add((Component)this.mDirectionUpperRightRadioButton, gridBagConstraints);
        this.mDirectionLowerRigthRadioButton.setText("Diagonal (lower right)");
        this.mDirectionLowerRigthRadioButton.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mDirectionPanel.add((Component)this.mDirectionLowerRigthRadioButton, gridBagConstraints);
        this.mOrderPanel.setLayout(new GridBagLayout());
        this.mOrderPanel.setBorder(BorderFactory.createTitledBorder("Order"));
        this.mOrderButtonPanel1.setFont(new Font("Dialog", 0, 11));
        this.mOrderButtonPanel1.setPreferredSize(new Dimension(50, 50));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mOrderPanel.add((Component)this.mOrderButtonPanel1, gridBagConstraints);
        this.mOrderButtonPanel2.setFont(new Font("Dialog", 0, 11));
        this.mOrderButtonPanel2.setPreferredSize(new Dimension(50, 50));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mOrderPanel.add((Component)this.mOrderButtonPanel2, gridBagConstraints);
        this.mOrderButtonPanel3.setFont(new Font("Dialog", 0, 11));
        this.mOrderButtonPanel3.setPreferredSize(new Dimension(50, 50));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mOrderPanel.add((Component)this.mOrderButtonPanel3, gridBagConstraints);
        this.mOrderButtonPanel4.setFont(new Font("Dialog", 0, 11));
        this.mOrderButtonPanel4.setPreferredSize(new Dimension(50, 50));
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mOrderPanel.add((Component)this.mOrderButtonPanel4, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.add((Component)this.mColorSelectionPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.add((Component)this.mDirectionPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.add((Component)this.mOrderPanel, gridBagConstraints);
    }

    private boolean initProperty() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mDirectionVerticalRadioButton);
        buttonGroup.add(this.mDirectionHorizontalRadioButton);
        buttonGroup.add(this.mDirectionUpperRightRadioButton);
        buttonGroup.add(this.mDirectionLowerRigthRadioButton);
        return true;
    }

    protected boolean initialize() {
        this.mColorSelectionButton1.addActionListener(this);
        this.mColorSelectionButton2.addActionListener(this);
        this.mColorSelectionButton1.addFocusListener(this);
        this.mColorSelectionButton2.addFocusListener(this);
        this.mColorDialog = new SGColorDialog(this, "Color Dialog", false);
        this.mColorDialog.pack();
        this.mColorDialog.setResizable(false);
        JColorChooser jColorChooser = this.mColorDialog.getColorChooser();
        ColorSelectionModel colorSelectionModel = jColorChooser.getSelectionModel();
        colorSelectionModel.addChangeListener(this);
        this.mColorSelectionButtonEmphasisIcon = this.createIcon("/resources/Lines.gif");
        this.mDirectionHorizontalRadioButton.addActionListener(this);
        this.mDirectionVerticalRadioButton.addActionListener(this);
        this.mDirectionUpperRightRadioButton.addActionListener(this);
        this.mDirectionLowerRigthRadioButton.addActionListener(this);
        this.mOrderButtonPanel1.addActionListener(this);
        this.mOrderButtonPanel2.addActionListener(this);
        this.mOrderButtonPanel3.addActionListener(this);
        this.mOrderButtonPanel4.addActionListener(this);
        this.mOrderButtonPanel1.addFocusListener(this);
        this.mOrderButtonPanel2.addFocusListener(this);
        this.mOrderButtonPanel3.addFocusListener(this);
        this.mOrderButtonPanel4.addFocusListener(this);
        this.mColorSelectionButton1.setColor(Color.BLACK);
        this.mColorSelectionButton2.setColor(Color.WHITE);
        this.mDirectionVerticalRadioButton.setSelected(true);
        this.mCurrentOrderSetButton = this.mOrderButtonPanel1;
        this.mCurrentOrderSetButton.setBorder(this.getFocusedBorder());
        return true;
    }

    public void dispose() {
        super.dispose();
        this.mGradationPaint = null;
        this.mColorSelectionButton1 = null;
        this.mColorSelectionButton2 = null;
        this.mDirectionVerticalRadioButton = null;
        this.mDirectionHorizontalRadioButton = null;
        this.mDirectionUpperRightRadioButton = null;
        this.mDirectionLowerRigthRadioButton = null;
        this.mOrderButtonPanel1 = null;
        this.mOrderButtonPanel2 = null;
        this.mOrderButtonPanel3 = null;
        this.mOrderButtonPanel4 = null;
        this.mColorDialog.dispose();
        this.mCurrentColorSetButton = null;
        this.mCurrentOrderSetButton = null;
        this.mColorSelectionButtonEmphasisIcon = null;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (this.mCurrentColorSetButton != null && object instanceof ColorSelectionModel) {
            Color color = this.mColorDialog.getSelectedColor();
            this.mCurrentColorSetButton.setColor(color);
            this.updateOrderButtonPanel();
            this.fireGradationModelChanged();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mColorSelectionButton1 || object == this.mColorSelectionButton2) {
            if (this.mCurrentColorSetButton != null) {
                this.mCurrentColorSetButton.setBorder(this.getUnfocusedBorder());
            }
            this.mCurrentColorSetButton = (SGColorSelectionButton)object;
            this.mCurrentColorSetButton.setBorder(this.getFocusedBorder());
            if (!this.mColorDialog.isVisible()) {
                this.mColorDialog.setSelectedColor(this.mCurrentColorSetButton.getColor());
                this.mColorDialog.setLocation(this.getX() + 20, this.getY() + 20);
                this.mColorDialog.setVisible(true);
            }
        } else if (object == this.mOrderButtonPanel1 || object == this.mOrderButtonPanel2 || object == this.mOrderButtonPanel3 || object == this.mOrderButtonPanel4) {
            this.setCurrentOrderSetButton((SGGradationPaintSelectionButton)object);
            this.fireGradationModelChanged();
        } else if (object == this.mDirectionHorizontalRadioButton || object == this.mDirectionVerticalRadioButton || object == this.mDirectionUpperRightRadioButton || object == this.mDirectionLowerRigthRadioButton) {
            this.updateOrderButtonPanel();
            this.fireGradationModelChanged();
        }
    }

    private boolean updateOrderButtonPanel() {
        SGGradationPaint sGGradationPaint = new SGGradationPaint();
        Color color = this.mColorSelectionButton1.getColor();
        Color color2 = this.mColorSelectionButton2.getColor();
        int n = -1;
        if (this.mDirectionHorizontalRadioButton.isSelected()) {
            n = 0;
        } else if (this.mDirectionVerticalRadioButton.isSelected()) {
            n = 1;
        } else if (this.mDirectionUpperRightRadioButton.isSelected()) {
            n = 2;
        } else if (this.mDirectionLowerRigthRadioButton.isSelected()) {
            n = 3;
        } else {
            return false;
        }
        sGGradationPaint.setColors(new Color[]{color, color2});
        sGGradationPaint.setDirection(n);
        sGGradationPaint.setOrder(0);
        this.mOrderButtonPanel1.setGradationPaint(sGGradationPaint);
        sGGradationPaint.setOrder(1);
        this.mOrderButtonPanel2.setGradationPaint(sGGradationPaint);
        sGGradationPaint.setOrder(2);
        this.mOrderButtonPanel3.setGradationPaint(sGGradationPaint);
        sGGradationPaint.setOrder(3);
        this.mOrderButtonPanel4.setGradationPaint(sGGradationPaint);
        return true;
    }

    private void setCurrentOrderSetButton(SGGradationPaintSelectionButton sGGradationPaintSelectionButton) {
        if (null != this.mCurrentOrderSetButton) {
            this.mCurrentOrderSetButton.setBorder(this.getUnfocusedBorder());
        }
        this.mCurrentOrderSetButton = sGGradationPaintSelectionButton;
        this.mCurrentOrderSetButton.setBorder(this.getFocusedBorder());
    }

    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof SGColorSelectionButton) {
            SGColorSelectionButton sGColorSelectionButton = (SGColorSelectionButton)object;
            sGColorSelectionButton.setBorder(this.getFocusedBorder());
            this.mCurrentColorSetButton = sGColorSelectionButton;
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof SGColorSelectionButton) {
            SGColorSelectionButton sGColorSelectionButton = (SGColorSelectionButton)object;
            Component component = focusEvent.getOppositeComponent();
            if (component == null) {
                return;
            }
            boolean bl = this.isColorChooserComponent(component);
            if (!bl) {
                sGColorSelectionButton.setBorder(this.getUnfocusedBorder());
                this.mCurrentColorSetButton = null;
            }
        }
    }

    private boolean isColorChooserComponent(Component component) {
        Container container = component.getParent();
        if (container == null) {
            return false;
        }
        if (this.mColorDialog.equals(container)) {
            return true;
        }
        return this.isColorChooserComponent(container);
    }

    private Border getFocusedBorder() {
        return new MatteBorder(this.mColorSelectionButtonEmphasisIcon);
    }

    private ImageIcon createIcon(String string) {
        if (string == null) {
            return null;
        }
        Class<?> clazz = this.getClass();
        URL uRL = clazz.getResource(string);
        ImageIcon imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon(string);
        return imageIcon;
    }

    private Border getUnfocusedBorder() {
        return new LineBorder(Color.BLACK, 1);
    }

    public void setSelectedGradationPaint(SGGradationPaint sGGradationPaint) {
        if (sGGradationPaint == null) {
            return;
        }
        if (!this.mGradationPaint.equals(sGGradationPaint)) {
            try {
                this.mGradationPaint = (SGGradationPaint)sGGradationPaint.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }
        Color[] colorArray = sGGradationPaint.getColors();
        int n = sGGradationPaint.getDirectionIndex();
        int n2 = sGGradationPaint.getOrderIndex();
        this.mColorSelectionButton1.setColor(colorArray[0]);
        this.mColorSelectionButton2.setColor(colorArray[1]);
        switch (n) {
            case 0: {
                this.mDirectionHorizontalRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.mDirectionVerticalRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.mDirectionUpperRightRadioButton.setSelected(true);
                break;
            }
            case 3: {
                this.mDirectionLowerRigthRadioButton.setSelected(true);
                break;
            }
        }
        switch (n2) {
            case 0: {
                this.setCurrentOrderSetButton(this.mOrderButtonPanel1);
                break;
            }
            case 1: {
                this.setCurrentOrderSetButton(this.mOrderButtonPanel2);
                break;
            }
            case 2: {
                this.setCurrentOrderSetButton(this.mOrderButtonPanel3);
                break;
            }
            case 3: {
                this.setCurrentOrderSetButton(this.mOrderButtonPanel4);
                break;
            }
        }
        this.updateOrderButtonPanel();
    }

    public SGGradationPaint getGradationPaint() {
        SGGradationPaint sGGradationPaint = new SGGradationPaint();
        Color color = this.mColorSelectionButton1.getColor();
        Color color2 = this.mColorSelectionButton2.getColor();
        int n = -1;
        if (this.mDirectionHorizontalRadioButton.isSelected()) {
            n = 0;
        } else if (this.mDirectionVerticalRadioButton.isSelected()) {
            n = 1;
        } else if (this.mDirectionUpperRightRadioButton.isSelected()) {
            n = 2;
        } else if (this.mDirectionLowerRigthRadioButton.isSelected()) {
            n = 3;
        } else {
            return null;
        }
        int n2 = -1;
        if (this.mCurrentOrderSetButton == this.mOrderButtonPanel1) {
            n2 = 0;
        } else if (this.mCurrentOrderSetButton == this.mOrderButtonPanel2) {
            n2 = 1;
        } else if (this.mCurrentOrderSetButton == this.mOrderButtonPanel3) {
            n2 = 2;
        } else if (this.mCurrentOrderSetButton == this.mOrderButtonPanel4) {
            n2 = 3;
        } else {
            return null;
        }
        sGGradationPaint.setColors(new Color[]{color, color2});
        sGGradationPaint.setDirection(n);
        sGGradationPaint.setOrder(n2);
        return sGGradationPaint;
    }

    public void addModelChangeListener(ChangeListener changeListener) {
        if (!this._listener.contains(changeListener)) {
            this._listener.add(changeListener);
        }
    }

    protected void fireGradationModelChanged() {
        if (null == this._changeEvent) {
            this._changeEvent = new ChangeEvent(this);
        }
        for (ChangeListener changeListener : this._listener) {
            changeListener.stateChanged(this._changeEvent);
        }
    }
}

