/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGTransparentPaint;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

public class SGGradationPaint
extends SGTransparentPaint
implements SGIDisposable {
    public static final String NAME_UNKNOWN = "UNKNOWN";
    public static final int INDEX_DIRECTION_HORIZONTAL = 0;
    public static final int INDEX_DIRECTION_VERTICAL = 1;
    public static final int INDEX_DIRECTION_DIAGONAL_UP_RIGHT = 2;
    public static final int INDEX_DIRECTION_DIAGONAL_LOW_RIGHT = 3;
    public static final String NAME_DIRECTION_HORIZONTAL = "Horizontal";
    public static final String NAME_DIRECTION_VERTICAL = "Vertical";
    public static final String NAME_DIRECTION_DIAGONAL_UP_RIGHT = "Diagonal upper right";
    public static final String NAME_DIRECTION_DIAGONAL_LOW_RIGHT = "Diagonal lower right";
    public static final String[] DIRECTION_NAMES = new String[]{"Horizontal", "Vertical", "Diagonal upper right", "Diagonal lower right"};
    public static final int[] DIRECTION_INDEX = new int[]{0, 1, 2, 3};
    public static final int INDEX_ORDER_COLOR_1_2 = 0;
    public static final int INDEX_ORDER_COLOR_2_1 = 1;
    public static final int INDEX_ORDER_COLOR_1_2_1 = 2;
    public static final int INDEX_ORDER_COLOR_2_1_2 = 3;
    public static final String NAME_ORDER_COLOR_1_2 = "Color 1_2";
    public static final String NAME_ORDER_COLOR_2_1 = "Color 2_1";
    public static final String NAME_ORDER_COLOR_1_2_1 = "Color 1_2_1";
    public static final String NAME_ORDER_COLOR_2_1_2 = "Color 2_1_2";
    public static final String[] ORDER_NAMES = new String[]{"Color 1_2", "Color 2_1", "Color 1_2_1", "Color 2_1_2"};
    public static final int[] ORDER_INDEX = new int[]{0, 1, 2, 3};
    protected int mDirectionIndex;
    protected int mOrderIndex;
    protected Color[] mColors = null;
    private boolean mDisposed = false;

    public SGGradationPaint() {
        this.init();
    }

    private void init() {
        this.mDirectionIndex = 0;
        this.mOrderIndex = 0;
        this.mColors = new Color[]{Color.BLACK, Color.WHITE};
    }

    public Paint getPaint(Rectangle2D rectangle2D) {
        return SGGradationPaint.getLinearGradientPaint(rectangle2D, this.getTransparentedColor(this.mColors[0]), this.getTransparentedColor(this.mColors[1]), this.mDirectionIndex, this.mOrderIndex);
    }

    public Paint getOpaquePaint(Rectangle2D rectangle2D) {
        return SGGradationPaint.getLinearGradientPaint(rectangle2D, SGGradationPaint.getOpaqueColor(this.mColors[0]), SGGradationPaint.getOpaqueColor(this.mColors[1]), this.mDirectionIndex, this.mOrderIndex);
    }

    public void dispose() {
        this.mDisposed = true;
        this.mColors = null;
    }

    public Object clone() throws CloneNotSupportedException {
        SGGradationPaint sGGradationPaint = (SGGradationPaint)super.clone();
        sGGradationPaint.mDirectionIndex = this.mDirectionIndex;
        sGGradationPaint.mOrderIndex = this.mOrderIndex;
        sGGradationPaint.mColors = (Color[])this.mColors.clone();
        return sGGradationPaint;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SGGradationPaint)) {
            return false;
        }
        SGGradationPaint sGGradationPaint = (SGGradationPaint)object;
        if (!super.equals(sGGradationPaint)) {
            return false;
        }
        if (sGGradationPaint.mDirectionIndex != this.mDirectionIndex) {
            return false;
        }
        if (sGGradationPaint.mOrderIndex != this.mOrderIndex) {
            return false;
        }
        if (sGGradationPaint.mColors.length != this.mColors.length) {
            return false;
        }
        for (int i = 0; i < this.mColors.length; ++i) {
            if (sGGradationPaint.mColors[i].equals(this.mColors[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 37 * n + this.mDirectionIndex;
        n = 37 * n + this.mOrderIndex;
        for (int i = 0; i < this.mColors.length; ++i) {
            n = 37 * n + this.mColors[i].hashCode();
        }
        return n;
    }

    public int getDirectionIndex() {
        return this.mDirectionIndex;
    }

    public int getOrderIndex() {
        return this.mOrderIndex;
    }

    public Color[] getColors() {
        return (Color[])this.mColors.clone();
    }

    public boolean setDirection(int n) {
        if (!SGGradationPaint.isValidDirection(n)) {
            return false;
        }
        this.mDirectionIndex = n;
        return true;
    }

    public boolean setOrder(int n) {
        if (!SGGradationPaint.isValidOrder(n)) {
            return false;
        }
        this.mOrderIndex = n;
        return true;
    }

    public boolean setColors(Color[] colorArray) {
        if (null == colorArray) {
            return false;
        }
        this.mColors = (Color[])colorArray.clone();
        return true;
    }

    public boolean setColor1(Color color) {
        if (null == color) {
            return false;
        }
        if (null == this.mColors || this.mColors.length != 2) {
            return false;
        }
        this.mColors[0] = color;
        return true;
    }

    public boolean setColor2(Color color) {
        if (null == color) {
            return false;
        }
        if (null == this.mColors || this.mColors.length != 2) {
            return false;
        }
        this.mColors[1] = color;
        return true;
    }

    public static boolean isValidDirection(int n) {
        for (int i = 0; i < DIRECTION_INDEX.length; ++i) {
            if (n != DIRECTION_INDEX[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidOrder(int n) {
        for (int i = 0; i < ORDER_INDEX.length; ++i) {
            if (n != ORDER_INDEX[i]) continue;
            return true;
        }
        return false;
    }

    public static String getDirectionName(int n) {
        if (!SGGradationPaint.isValidDirection(n)) {
            return NAME_UNKNOWN;
        }
        return DIRECTION_NAMES[n];
    }

    public static String getOrderName(int n) {
        if (!SGGradationPaint.isValidOrder(n)) {
            return NAME_UNKNOWN;
        }
        return ORDER_NAMES[n];
    }

    public static Integer getDirectionIndex(String string) {
        for (int i = 0; i < DIRECTION_NAMES.length; ++i) {
            if (!SGUtilityText.isEqualString(string, DIRECTION_NAMES[i])) continue;
            return DIRECTION_INDEX[i];
        }
        return null;
    }

    public static Integer getOrderIndex(String string) {
        for (int i = 0; i < ORDER_NAMES.length; ++i) {
            if (!SGUtilityText.isEqualString(string, ORDER_NAMES[i])) continue;
            return ORDER_INDEX[i];
        }
        return null;
    }

    private static Paint getLinearGradientPaint(Rectangle2D rectangle2D, Color color, Color color2, int n, int n2) {
        Point2D.Double double_;
        Point2D.Double double_2;
        Color[] colorArray;
        float[] fArray;
        switch (n2) {
            case 0: {
                fArray = new float[]{0.0f, 1.0f};
                colorArray = new Color[]{color, color2};
                break;
            }
            case 1: {
                fArray = new float[]{0.0f, 1.0f};
                colorArray = new Color[]{color2, color};
                break;
            }
            case 2: {
                fArray = new float[]{0.0f, 0.5f, 1.0f};
                colorArray = new Color[]{color, color2, color};
                break;
            }
            case 3: {
                fArray = new float[]{0.0f, 0.5f, 1.0f};
                colorArray = new Color[]{color2, color, color2};
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal orderIndex = " + n2);
            }
        }
        switch (n) {
            case 0: {
                double_2 = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
                double_ = new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getY());
                break;
            }
            case 1: {
                double_2 = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
                double_ = new Point2D.Double(rectangle2D.getX(), rectangle2D.getMaxY());
                break;
            }
            case 2: {
                double_2 = new Point2D.Double(rectangle2D.getX(), rectangle2D.getMaxY());
                double_ = new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getY());
                break;
            }
            case 3: {
                double_2 = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
                double_ = new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getMaxY());
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal directionIndex = " + n);
            }
        }
        if (!double_2.equals(double_)) {
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_, fArray, colorArray);
            return linearGradientPaint;
        }
        return null;
    }

    public boolean isDisposed() {
        return this.mDisposed;
    }
}

