/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGClientPanel;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGIAnchored;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxisBreak;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementLegend;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementShape;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementSignificantDifference;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementString;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementTimingLine;
import jp.riken.brain.ni.samuraigraph.base.SGIMovable;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGIPaintable;
import jp.riken.brain.ni.samuraigraph.base.SGIProgressControl;
import jp.riken.brain.ni.samuraigraph.base.SGIRootObjectConstants;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGIVisible;
import jp.riken.brain.ni.samuraigraph.base.SGPluginsQueryMessage;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyMap;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyResults;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUndoManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SGFigure
implements ActionListener,
SGIConstants,
SGIUndoable,
SGIMovable,
SGISelectable,
SGIPaintable,
SGIFigureDialogObserver,
SGINode,
SGIRootObjectConstants,
SGIVisible,
SGIDisposable,
SGIFigureConstants {
    private int mID;
    protected SGDrawingWindow mWnd = null;
    protected List<SGData> mDataList = new ArrayList<SGData>();
    protected float mGraphRectX = 0.0f;
    protected float mGraphRectY = 0.0f;
    protected float mGraphRectWidth = 0.0f;
    protected float mGraphRectHeight = 0.0f;
    protected float mMagnification = 1.0f;
    protected JPopupMenu mPopupMenu = null;
    protected SGPropertyDialog mPropertyDialog = null;
    private SGIFigureElement mPressedElement = null;
    private Point mPressedPoint = new Point();
    private final Rectangle2D mTempFigureRect = new Rectangle2D.Float();
    private Color mBackgroundColor;
    private final Rectangle2D mDraggingRect = new Rectangle2D.Float();
    private static boolean mSnapToGridFlag = true;
    private final Rectangle2D mRubberBandRect = new Rectangle2D.Float();
    static boolean mRubberBandFlag = true;
    static boolean mRubberBandVisibleFlag = false;
    private int mMouseLocation = 0;
    protected static final float MIN_WIDTH = 50.0f;
    protected static final float MAX_WIDTH = 50.0f;
    private static boolean mBoundingBoxVisibleFlag = false;
    protected SGProperties mTemporaryProperties = null;
    private boolean mTransparentFlag = false;
    public static final String MENUCMD_SHOW_BOUNDING_BOX = "Show Bounding Box";
    public static final String MENUCMD_LEGEND_VISIBLE = "Legend Visible";
    public static final String MENUCMD_COLOR_BAR_VISIBLE = "Color Bar Visible";
    private boolean mVisibleFlag = true;
    private JComponent mComponent = null;
    private final Map<Integer, SGIFigureElement> mFigureElementMap = new TreeMap<Integer, SGIFigureElement>();
    private boolean mSelectionSymbolsVisibleFlag = true;
    private boolean mSelectedFlag = false;
    public static final int DRAW_BACK_MARGIN = 2;
    public static final String MENUCMD_RUBBER_BANDING = "Rubber Banding";
    public static final String MENUCMD_SAVE_PROPERTY = "Save Property";
    public static final String MENUCMD_PROPERTY = "Property";
    public static final String MENUCMD_GRID_VISIBLE = "Grid Visible";
    public static final String MENUCMD_GRID_PROPERTY = "Grid Property";
    private SGUndoManager mUndoManager = new SGUndoManager(this);
    public static final int MARGIN_TOP = 5;
    public static final int MARGIN_BOTTOM = 5;
    public static final int MARGIN_LEFT = 5;
    public static final int MARGIN_RIGHT = 5;
    private static final float DUPLICATION_OFFSET = 20.0f;
    private String mClassType = null;
    private int mMode = 1;
    public static final float EXTRA_REGION_WIDTH_IN_CM_UNIT = 1.0f;
    private boolean mMouseInExtraRegionFlag = false;
    private static final Color EXTRA_REGION_COLOR = new Color(127, 127, 127, 95);
    private boolean mDisposed = false;

    public SGFigure(SGDrawingWindow sGDrawingWindow) {
        this.mWnd = sGDrawingWindow;
        this.mComponent = sGDrawingWindow.getFigurePanel();
        this.create();
    }

    public String toString() {
        return "SGFigure:" + this.getID();
    }

    private boolean create() {
        this.setBackgroundColor(DEFAULT_FIGURE_BACKGROUND_COLOR);
        this.setVisible(true);
        return true;
    }

    @Override
    public boolean isVisible() {
        return this.mVisibleFlag;
    }

    @Override
    public void setVisible(boolean bl) {
        this.mVisibleFlag = bl;
    }

    public JComponent getComponent() {
        return this.mComponent;
    }

    public void repaint() {
        this.mComponent.repaint();
    }

    public int getWidth() {
        return this.mComponent.getWidth();
    }

    public int getHeight() {
        return this.mComponent.getHeight();
    }

    public int getID() {
        return this.mID;
    }

    public boolean setID(int n) {
        this.mID = n;
        return true;
    }

    @Override
    public boolean setBackgroundColor(Color color) {
        this.mBackgroundColor = color;
        return true;
    }

    public boolean setBackgroundColor(String string) {
        Color color = SGUtilityText.getColor(string);
        if (color == null) {
            return false;
        }
        return this.setBackgroundColor(color);
    }

    public boolean setBackgroundColor(String string, String string2, String string3) {
        Color color = SGUtilityText.getColor(string, string2, string3);
        if (color == null) {
            return false;
        }
        return this.setBackgroundColor(color);
    }

    @Override
    public Color getBackgroundColor() {
        return this.mBackgroundColor;
    }

    @Override
    public boolean isTransparent() {
        return this.mTransparentFlag;
    }

    public SGDrawingWindow getWindow() {
        return this.mWnd;
    }

    public float getSpaceAxisLineAndNumber() {
        return this.getAxisElement().getSpaceAxisLineAndNumber();
    }

    @Override
    public float getSpaceAxisLineAndNumber(String string) {
        float f = this.getSpaceAxisLineAndNumber();
        return (float)SGUtilityText.convertFromPoint(f, string);
    }

    public float getSpaceNumberAndTitle() {
        return this.getAxisElement().getSpaceNumberAndTitle();
    }

    @Override
    public float getSpaceNumberAndTitle(String string) {
        float f = this.getSpaceNumberAndTitle();
        return (float)SGUtilityText.convertFromPoint(f, string);
    }

    public boolean setSpaceAxisLineAndNumber(float f) {
        SGIFigureElementAxis sGIFigureElementAxis = this.getAxisElement();
        float f2 = sGIFigureElementAxis.getSpaceAxisLineAndNumber();
        if (f != f2) {
            sGIFigureElementAxis.setSpaceAxisLineAndNumber(f);
            sGIFigureElementAxis.setChanged(true);
            this.updateGraphRect();
        }
        return true;
    }

    @Override
    public boolean setSpaceAxisLineAndNumber(float f, String string) {
        Float f2 = this.calcFigureScale(f, string, "cm", 0.0, 5.0);
        if (f2 == null) {
            return false;
        }
        if (this.equalLength(this.getSpaceAxisLineAndNumber(), f2.floatValue())) {
            return true;
        }
        return this.setSpaceAxisLineAndNumber(f2.floatValue());
    }

    public boolean setSpaceNumberAndTitle(float f) {
        SGIFigureElementAxis sGIFigureElementAxis = this.getAxisElement();
        float f2 = sGIFigureElementAxis.getSpaceNumberAndTitle();
        if (f != f2) {
            sGIFigureElementAxis.setSpaceNumberAndTitle(f);
            sGIFigureElementAxis.setChanged(true);
            this.updateGraphRect();
        }
        return true;
    }

    @Override
    public boolean setSpaceNumberAndTitle(float f, String string) {
        Float f2 = this.calcFigureScale(f, string, "cm", 0.0, 5.0);
        if (f2 == null) {
            return false;
        }
        if (this.equalLength(this.getSpaceNumberAndTitle(), f2.floatValue())) {
            return true;
        }
        return this.setSpaceNumberAndTitle(f2.floatValue());
    }

    @Override
    public boolean setLegendVisible(boolean bl) {
        SGIFigureElementLegend sGIFigureElementLegend = this.getLegendElement();
        boolean bl2 = sGIFigureElementLegend.isLegendVisible();
        if (bl2 != bl) {
            sGIFigureElementLegend.setLegendVisible(bl);
            sGIFigureElementLegend.setChanged(true);
        }
        return true;
    }

    @Override
    public boolean setTransparent(boolean bl) {
        this.mTransparentFlag = bl;
        return true;
    }

    public SGIFigureElement[] getIFigureElementArray() {
        ArrayList<SGIFigureElement> arrayList = new ArrayList<SGIFigureElement>(this.mFigureElementMap.values());
        SGIFigureElement[] sGIFigureElementArray = arrayList.toArray(new SGIFigureElement[0]);
        return sGIFigureElementArray;
    }

    @Override
    public ArrayList<SGINode> getChildNodes() {
        ArrayList<SGINode> arrayList = new ArrayList<SGINode>();
        arrayList.addAll(this.mFigureElementMap.values());
        if (this.getAxisElement().isColorBarAvailable()) {
            arrayList.add(this.getAxisElement().getColorBar());
        }
        return arrayList;
    }

    @Override
    public String getClassDescription() {
        return "Figure: " + this.getID();
    }

    @Override
    public String getInstanceDescription() {
        float f = (float)SGUtilityNumber.roundOffNumber(this.mGraphRectX * 0.035277776f, -2);
        float f2 = (float)SGUtilityNumber.roundOffNumber(this.mGraphRectY * 0.035277776f, -2);
        String string = this.getClassDescription();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(" ( X=");
        stringBuffer.append(f);
        stringBuffer.append("cm, Y=");
        stringBuffer.append(f2);
        stringBuffer.append("cm )");
        return stringBuffer.toString();
    }

    public SGIFigureElement getIFigureElement(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("");
        }
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (!clazz.isAssignableFrom(sGIFigureElementArray[i].getClass())) continue;
            return sGIFigureElementArray[i];
        }
        return null;
    }

    public SGIFigureElementAxis getAxisElement() {
        return (SGIFigureElementAxis)this.getIFigureElement(SGIFigureElementAxis.class);
    }

    public SGIFigureElementGraph getGraphElement() {
        return (SGIFigureElementGraph)this.getIFigureElement(SGIFigureElementGraph.class);
    }

    public SGIFigureElementLegend getLegendElement() {
        return (SGIFigureElementLegend)this.getIFigureElement(SGIFigureElementLegend.class);
    }

    public void setIFigureElement(int n, SGIFigureElement sGIFigureElement) {
        if (sGIFigureElement == null) {
            throw new IllegalArgumentException("");
        }
        Class<?> clazz = sGIFigureElement.getClass();
        for (SGIFigureElement sGIFigureElement2 : this.mFigureElementMap.values()) {
            if (!sGIFigureElement2.getClass().equals(clazz)) continue;
            throw new IllegalArgumentException("");
        }
        this.mFigureElementMap.put(n, sGIFigureElement);
    }

    void clearFocusedObjects(SGIFigureElement sGIFigureElement) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].clearFocusedObjects(sGIFigureElement);
        }
        this.setSelected(false);
    }

    public Rectangle2D getGraphRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.getGraphRectX(), this.getGraphRectY(), this.getGraphRectWidth(), this.getGraphRectHeight());
        return float_;
    }

    public Rectangle2D getGraphRectInClientRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.mGraphRectX, this.mGraphRectY, this.mGraphRectWidth, this.mGraphRectHeight);
        return float_;
    }

    public float getGraphRectX() {
        Rectangle2D rectangle2D = this.mWnd.getPaperRect();
        return (float)rectangle2D.getX() + this.mMagnification * this.mGraphRectX;
    }

    public float getGraphRectY() {
        Rectangle2D rectangle2D = this.mWnd.getPaperRect();
        return (float)rectangle2D.getY() + this.mMagnification * this.mGraphRectY;
    }

    public float getGraphRectWidth() {
        return this.mMagnification * this.mGraphRectWidth;
    }

    public float getGraphRectHeight() {
        return this.mMagnification * this.mGraphRectHeight;
    }

    public float getFigureX() {
        return this.mGraphRectX;
    }

    @Override
    public float getFigureX(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getFigureX(), string);
    }

    public float getFigureY() {
        return this.mGraphRectY;
    }

    @Override
    public float getFigureY(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getFigureY(), string);
    }

    public float getFigureWidth() {
        return this.mGraphRectWidth;
    }

    @Override
    public float getFigureWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getFigureWidth(), string);
    }

    public float getFigureHeight() {
        return this.mGraphRectHeight;
    }

    @Override
    public float getFigureHeight(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getFigureHeight(), string);
    }

    @Override
    public boolean setFigureX(float f, String string) {
        Float f2 = this.calcFigureScale(f, string, "cm", -50.0, 150.0);
        if (f2 == null) {
            return false;
        }
        if (this.equalLength(this.mGraphRectX, f2.floatValue())) {
            return true;
        }
        this.mGraphRectX = f2.floatValue();
        this.updateGraphRect();
        return true;
    }

    @Override
    public boolean setFigureY(float f, String string) {
        Float f2 = this.calcFigureScale(f, string, "cm", -50.0, 150.0);
        if (f2 == null) {
            return false;
        }
        if (this.equalLength(this.mGraphRectY, f2.floatValue())) {
            return true;
        }
        this.mGraphRectY = f2.floatValue();
        this.updateGraphRect();
        return true;
    }

    @Override
    public boolean setFigureWidth(float f, String string) {
        Float f2 = this.calcFigureScale(f, string, "cm", 0.1, 50.0);
        if (f2 == null) {
            return false;
        }
        if (this.equalLength(this.mGraphRectWidth, f2.floatValue())) {
            return true;
        }
        this.mGraphRectWidth = f2.floatValue();
        this.updateGraphRect();
        return true;
    }

    @Override
    public boolean setFigureHeight(float f, String string) {
        Float f2 = this.calcFigureScale(f, string, "cm", 0.1, 50.0);
        if (f2 == null) {
            return false;
        }
        if (this.equalLength(this.mGraphRectHeight, f2.floatValue())) {
            return true;
        }
        this.mGraphRectHeight = f2.floatValue();
        this.updateGraphRect();
        return true;
    }

    private Float calcFigureScale(float f, String string, String string2, double d, double d2) {
        return SGUtility.calcPropertyValue(f, string, string2, d, d2, -1);
    }

    private boolean equalLength(float f, float f2) {
        double d;
        float f3 = Math.abs(f - f2);
        double d2 = SGUtilityText.convert(f3, "pt", "cm");
        return d2 < (d = SGUtilityNumber.getPowersOfTen(-2));
    }

    public boolean setGraphRectLocation(float f, float f2) {
        this.setGraphRectLocationAttributes(f, f2);
        this.updateGraphRect();
        return true;
    }

    private boolean setGraphRectLocationAttributes(float f, float f2) {
        Rectangle2D rectangle2D = this.mWnd.getPaperRect();
        this.mGraphRectX = (f - (float)rectangle2D.getX()) / this.mMagnification;
        this.mGraphRectY = (f2 - (float)rectangle2D.getY()) / this.mMagnification;
        return true;
    }

    protected boolean setGraphRectLocationRoundingOut(float f, float f2) {
        Rectangle2D rectangle2D = this.mWnd.getPaperRect();
        float f3 = (f - (float)rectangle2D.getX()) * 0.035277776f / this.mMagnification;
        float f4 = (f2 - (float)rectangle2D.getY()) * 0.035277776f / this.mMagnification;
        float f5 = (float)SGUtilityNumber.roundOutNumber(f3, -2);
        float f6 = (float)SGUtilityNumber.roundOutNumber(f4, -2);
        float f7 = f5 / 0.035277776f;
        float f8 = f6 / 0.035277776f;
        this.mGraphRectX = f7;
        this.mGraphRectY = f8;
        this.updateGraphRect();
        return true;
    }

    public boolean setGraphRectSize(float f, float f2) {
        this.setGraphRectSizeAttributes(f, f2);
        this.updateGraphRect();
        return true;
    }

    private boolean setGraphRectSizeAttributes(float f, float f2) {
        this.mGraphRectWidth = f / this.mMagnification;
        this.mGraphRectHeight = f2 / this.mMagnification;
        return true;
    }

    protected boolean setGraphRectSizeRoundingOut(float f, float f2) {
        float f3 = f * 0.035277776f / this.mMagnification;
        float f4 = f2 * 0.035277776f / this.mMagnification;
        float f5 = (float)SGUtilityNumber.roundOutNumber(f3, -2);
        float f6 = (float)SGUtilityNumber.roundOutNumber(f4, -2);
        float f7 = f5 / 0.035277776f;
        float f8 = f6 / 0.035277776f;
        this.mGraphRectWidth = f7;
        this.mGraphRectHeight = f8;
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        this.setGraphRectLocationAttributes(f, f2);
        this.setGraphRectSizeAttributes(f3, f4);
        this.updateGraphRect();
        return true;
    }

    @Override
    public boolean isLegendVisible() {
        return this.getLegendElement().isLegendVisible();
    }

    @Override
    public boolean isColorBarVisible() {
        return this.getAxisElement().isColorBarVisible();
    }

    @Override
    public boolean setColorBarVisible(boolean bl) {
        SGIFigureElementAxis sGIFigureElementAxis = this.getAxisElement();
        boolean bl2 = sGIFigureElementAxis.isColorBarVisible();
        if (bl2 != bl) {
            sGIFigureElementAxis.setColorBarVisible(bl);
            sGIFigureElementAxis.getColorBar().setChanged(true);
        }
        return true;
    }

    public boolean addData(SGData[] sGDataArray, Integer[] integerArray, String[] stringArray, SGIProgressControl sGIProgressControl, float f, float f2, Map<String, Object> map) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        ArrayList<SGIFigureElement> arrayList = new ArrayList<SGIFigureElement>(Arrays.asList(sGIFigureElementArray));
        SGIFigureElementAxis sGIFigureElementAxis = this.getAxisElement();
        arrayList.remove(sGIFigureElementAxis);
        arrayList.add(0, sGIFigureElementAxis);
        for (int i = 0; i < sGDataArray.length; ++i) {
            this.addToList(sGDataArray[i]);
        }
        String[] stringArray2 = new String[sGDataArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this.getNewDataName(stringArray[i]);
        }
        int[] nArray = null;
        if (integerArray != null) {
            nArray = new int[integerArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = integerArray[i];
            }
        }
        SGIFigureElement[] sGIFigureElementArray2 = arrayList.toArray(new SGIFigureElement[0]);
        float f3 = (f2 - f) / (float)sGDataArray.length;
        for (int i = 0; i < sGIFigureElementArray2.length; ++i) {
            sGIProgressControl.setProgressValue(f3 * (float)i + f);
            if (!(integerArray != null ? !sGIFigureElementArray2[i].addData(sGDataArray, stringArray2, nArray, map) : !sGIFigureElementArray2[i].addData(sGDataArray, stringArray2, map))) continue;
            return false;
        }
        return true;
    }

    public boolean addData(SGData sGData, String string, Map<Class<? extends SGIFigureElement>, SGProperties> map) {
        this.addToList(sGData);
        String string2 = this.getNewDataName(string);
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            SGProperties sGProperties = map.get(sGIFigureElementArray[i].getClass());
            SGProperties sGProperties2 = sGProperties;
            if (sGIFigureElementArray[i].addData(sGData, string2, sGProperties2)) continue;
            return false;
        }
        return true;
    }

    public String getNewDataName(String string) {
        List<SGData> list = this.getVisibleDataList();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            SGData sGData = list.get(i);
            String string2 = this.getDataName(sGData);
            arrayList.add(string2);
        }
        String string3 = SGUtilityText.getSerialName(arrayList, string);
        return string3;
    }

    private void addToList(SGData sGData) {
        this.mDataList.add(sGData);
    }

    protected boolean setViewBounds() {
        Rectangle2D rectangle2D = this.mWnd.getViewportBounds();
        this.setViewBounds(rectangle2D);
        return true;
    }

    protected boolean setViewBounds(Rectangle2D rectangle2D) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].setViewBounds(rectangle2D);
        }
        return true;
    }

    public boolean resize(float f, float f2) {
        this.mGraphRectX *= f;
        this.mGraphRectY *= f2;
        this.mGraphRectWidth *= f;
        this.mGraphRectHeight *= f2;
        this.updateGraphRect();
        this.setViewBounds();
        return true;
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public boolean setMagnification(float f) {
        this.mMagnification = f;
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].setMagnification(f)) continue;
            return false;
        }
        this.updateGraphRect();
        return true;
    }

    protected void setSelectionSymbolsVisible(boolean bl) {
        this.mSelectionSymbolsVisibleFlag = bl;
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].setSymbolsVisibleAroundFocusedObjects(bl);
        }
    }

    protected boolean isSelectionSymbolsVisible() {
        return this.mSelectionSymbolsVisibleFlag;
    }

    protected boolean onMouseMoved(MouseEvent mouseEvent) {
        SGIFigureElementTimingLine sGIFigureElementTimingLine;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (!this.mWnd.isInsertFlagSelected()) {
            Cursor cursor = this.setMouseCursor(n, n2);
            if (!Cursor.getDefaultCursor().equals(cursor)) {
                return true;
            }
        } else if (this.mWnd.getTimingLineInsertionFlag() && (sGIFigureElementTimingLine = (SGIFigureElementTimingLine)this.getIFigureElement(SGIFigureElementTimingLine.class)) != null) {
            sGIFigureElementTimingLine.guideToAdd(n, n2);
        }
        return this.mMouseInExtraRegionFlag;
    }

    boolean checkExtraRegion(int n, int n2) {
        Rectangle2D rectangle2D = this.getExtraRegionBounds();
        this.mMouseInExtraRegionFlag = rectangle2D.contains(n, n2);
        return this.mMouseInExtraRegionFlag;
    }

    void setExtraRegionFlag(boolean bl) {
        this.mMouseInExtraRegionFlag = bl;
    }

    public boolean addString(int n, int n2) {
        SGIFigureElementString sGIFigureElementString = (SGIFigureElementString)this.getIFigureElement(SGIFigureElementString.class);
        if (sGIFigureElementString != null) {
            return sGIFigureElementString.addString(n, n2);
        }
        return false;
    }

    public boolean addString(int n, String string, double d, double d2) {
        SGIFigureElementString sGIFigureElementString = (SGIFigureElementString)this.getIFigureElement(SGIFigureElementString.class);
        if (sGIFigureElementString != null) {
            return sGIFigureElementString.addString(n, string, d, d2);
        }
        return false;
    }

    public boolean addString(int n, String string, double d, double d2, String string2, String string3) {
        SGIFigureElementString sGIFigureElementString = (SGIFigureElementString)this.getIFigureElement(SGIFigureElementString.class);
        if (sGIFigureElementString != null) {
            return sGIFigureElementString.addString(n, string, d, d2, string2, string3);
        }
        return false;
    }

    public boolean addTimingLine(int n, int n2) {
        SGIFigureElementTimingLine sGIFigureElementTimingLine = (SGIFigureElementTimingLine)this.getIFigureElement(SGIFigureElementTimingLine.class);
        if (sGIFigureElementTimingLine != null) {
            return sGIFigureElementTimingLine.addTimingLine(n, n2);
        }
        return false;
    }

    public boolean addAxisBreakSymbol(int n, int n2) {
        SGIFigureElementAxisBreak sGIFigureElementAxisBreak = (SGIFigureElementAxisBreak)this.getIFigureElement(SGIFigureElementAxisBreak.class);
        if (sGIFigureElementAxisBreak != null) {
            return sGIFigureElementAxisBreak.addAxisBreakSymbol(n, n2);
        }
        return false;
    }

    public boolean addAxisBreakSymbol(int n, double d, double d2) {
        SGIFigureElementAxisBreak sGIFigureElementAxisBreak = (SGIFigureElementAxisBreak)this.getIFigureElement(SGIFigureElementAxisBreak.class);
        if (sGIFigureElementAxisBreak != null) {
            return sGIFigureElementAxisBreak.addAxisBreakSymbol(n, d, d2);
        }
        return false;
    }

    public boolean addAxisBreakSymbol(int n, double d, double d2, String string, String string2) {
        SGIFigureElementAxisBreak sGIFigureElementAxisBreak = (SGIFigureElementAxisBreak)this.getIFigureElement(SGIFigureElementAxisBreak.class);
        if (sGIFigureElementAxisBreak != null) {
            return sGIFigureElementAxisBreak.addAxisBreakSymbol(n, d, d2, string, string2);
        }
        return false;
    }

    public boolean addSignificantDifferenceSymbol(int n, int n2) {
        SGIFigureElementSignificantDifference sGIFigureElementSignificantDifference = (SGIFigureElementSignificantDifference)this.getIFigureElement(SGIFigureElementSignificantDifference.class);
        if (sGIFigureElementSignificantDifference != null) {
            return sGIFigureElementSignificantDifference.addSignificantDifferenceSymbol(n, n2);
        }
        return false;
    }

    public boolean addSignificantDifferenceSymbol(int n, double d, double d2) {
        SGIFigureElementSignificantDifference sGIFigureElementSignificantDifference = (SGIFigureElementSignificantDifference)this.getIFigureElement(SGIFigureElementSignificantDifference.class);
        if (sGIFigureElementSignificantDifference != null) {
            return sGIFigureElementSignificantDifference.addSignificantDifferenceSymbol(n, d, d2);
        }
        return false;
    }

    public boolean addSignificantDifferenceSymbol(int n, double d, double d2, String string, String string2) {
        SGIFigureElementSignificantDifference sGIFigureElementSignificantDifference = (SGIFigureElementSignificantDifference)this.getIFigureElement(SGIFigureElementSignificantDifference.class);
        if (sGIFigureElementSignificantDifference != null) {
            return sGIFigureElementSignificantDifference.addSignificantDifferenceSymbol(n, d, d2, string, string2);
        }
        return false;
    }

    public boolean addShape(int n, int n2, int n3) {
        SGIFigureElementShape sGIFigureElementShape = (SGIFigureElementShape)this.getIFigureElement(SGIFigureElementShape.class);
        if (sGIFigureElementShape != null) {
            return sGIFigureElementShape.addShape(n, n2, n3);
        }
        return false;
    }

    public boolean addShape(int n, int n2, double d, double d2) {
        SGIFigureElementShape sGIFigureElementShape = (SGIFigureElementShape)this.getIFigureElement(SGIFigureElementShape.class);
        if (sGIFigureElementShape != null) {
            return sGIFigureElementShape.addShape(n, n2, d, d2);
        }
        return false;
    }

    public boolean addShape(int n, int n2, double d, double d2, String string, String string2) {
        SGIFigureElementShape sGIFigureElementShape = (SGIFigureElementShape)this.getIFigureElement(SGIFigureElementShape.class);
        if (sGIFigureElementShape != null) {
            return sGIFigureElementShape.addShape(n, n2, d, d2, string, string2);
        }
        return false;
    }

    protected boolean onFigureElementsKeyPressed(KeyEvent keyEvent) {
        boolean bl = false;
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = sGIFigureElementArray.length - 1; i >= 0; --i) {
            if (!sGIFigureElementArray[i].onKeyPressed(keyEvent)) continue;
            bl = true;
        }
        return bl;
    }

    protected boolean onKeyPressed(KeyEvent keyEvent) {
        boolean bl = false;
        bl = this.onFigureElementsKeyPressed(keyEvent);
        if (!this.isSelected()) {
            return bl;
        }
        int n = keyEvent.getKeyCode();
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 38: {
                n3 = -1;
                break;
            }
            case 40: {
                n3 = 1;
                break;
            }
            case 37: {
                n2 = -1;
                break;
            }
            case 39: {
                n2 = 1;
            }
        }
        if (n2 != 0 || n3 != 0) {
            Rectangle2D rectangle2D = this.getGraphRect();
            float f = this.mMagnification;
            f = SGFigure.isSnappingToGrid() ? (f *= this.mWnd.getGridLineInterval()) : (f *= 2.8346457f);
            if (n2 != 0) {
                rectangle2D.setRect(rectangle2D.getX() + (double)(f * (float)n2), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            }
            if (n3 != 0) {
                rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY() + (double)(f * (float)n3), rectangle2D.getWidth(), rectangle2D.getHeight());
            }
            this.setDraggingRect(rectangle2D);
            this.snapToLines(0);
            this.setGraphRectOnDragging();
            bl = true;
        }
        return bl;
    }

    protected boolean onMouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getClickCount();
        SGIFigureElement sGIFigureElement = this.onFigureElementClicked(mouseEvent);
        if (sGIFigureElement != null) {
            this.mWnd.setFocusedFigure(this, false);
            this.afterClicked(mouseEvent);
            return true;
        }
        if (this.getExtraRegionBounds().contains(mouseEvent.getPoint())) {
            this.updateFocusedFigureList(mouseEvent);
            this.afterClicked(mouseEvent);
            if (SwingUtilities.isRightMouseButton(mouseEvent) && n == 1) {
                this.getPopupMenu().show(this.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && n == 2) {
                this.mWnd.showPropertyDialogForSelectedFigures();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isSelected() {
        return this.mSelectedFlag;
    }

    @Override
    public void setSelected(boolean bl) {
        this.mSelectedFlag = bl;
    }

    public boolean hideSelectedObjects() {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].hideSelectedObjects()) continue;
            return false;
        }
        return true;
    }

    public boolean hideData(int[] nArray) {
        SGIFigureElement[] sGIFigureElementArray;
        boolean bl = false;
        this.getGraphElement().clearFocusedObjects();
        for (int i = 0; i < nArray.length; ++i) {
            sGIFigureElementArray = this.getData(nArray[i]);
            if (sGIFigureElementArray == null) continue;
            this.getGraphElement().setDataFocused((SGData)sGIFigureElementArray, true);
        }
        SGIFigureElementString sGIFigureElementString = (SGIFigureElementString)this.getIFigureElement(SGIFigureElementString.class);
        this.getGraphElement().hideNetCDFLabelsOfFocusedObjects(sGIFigureElementString);
        sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (!sGIFigureElementArray[i].hideData(nArray)) continue;
            bl = true;
        }
        return bl;
    }

    protected void setSymbolsAroundAllObjectsVisible(boolean bl) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].setSymbolsAroundAllObjectsVisible(bl);
        }
    }

    private boolean afterClicked(MouseEvent mouseEvent) {
        this.repaint();
        return true;
    }

    private SGIFigureElement onFigureElementClicked(MouseEvent mouseEvent) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = sGIFigureElementArray.length - 1; i >= 0; --i) {
            if (!sGIFigureElementArray[i].onMouseClicked(mouseEvent)) continue;
            return sGIFigureElementArray[i];
        }
        return null;
    }

    protected boolean onMousePressed(MouseEvent mouseEvent) {
        if (this.isSelected() && this.pressWithMouseLocation(mouseEvent)) {
            return true;
        }
        if (this.pressFigureElement(mouseEvent)) {
            return true;
        }
        if (this.getExtraRegionBounds().contains(mouseEvent.getPoint())) {
            return this.pressed(mouseEvent);
        }
        return false;
    }

    private boolean pressFigureElement(MouseEvent mouseEvent) {
        SGIFigureElement sGIFigureElement = this.onFigureElementPressed(mouseEvent);
        if (sGIFigureElement != null) {
            this.afterPressed(mouseEvent);
            return true;
        }
        return false;
    }

    private boolean pressWithMouseLocation(MouseEvent mouseEvent) {
        if (this.mMouseLocation != 0) {
            return this.pressed(mouseEvent);
        }
        return false;
    }

    private boolean pressed(MouseEvent mouseEvent) {
        this.clearFocusedObjects();
        this.afterPressed(mouseEvent);
        return true;
    }

    private boolean afterPressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            mRubberBandVisibleFlag = true;
            if (this.mPressedElement == null && this.mWnd.getCursor().equals(Cursor.getDefaultCursor())) {
                this.changeCursor();
                if (this.mMouseLocation == 0) {
                    this.mWnd.setCursor(new Cursor(13));
                }
            }
        }
        this.mPressedPoint.setLocation(mouseEvent.getPoint());
        this.recordFigureRect();
        return true;
    }

    protected boolean updateFocusedFigureList(MouseEvent mouseEvent) {
        SGDrawingWindow sGDrawingWindow = this.getWindow();
        List<SGFigure> list = sGDrawingWindow.getFocusedFigureList();
        int n = mouseEvent.getModifiers();
        if ((n & 2) == 0 && (n & 1) == 0) {
            if (!list.contains(this)) {
                sGDrawingWindow.clearAllFocusedObjectsInFigures();
                sGDrawingWindow.setFocusedFigure(this, true);
            }
        } else if (list.contains(this)) {
            int n2 = this.mMouseLocation;
            if (n2 != 5 && n2 != 6 && n2 != 8 && n2 != 7 && this.mPressedElement == null) {
                sGDrawingWindow.setFocusedFigure(this, !this.isSelected());
            }
        } else {
            sGDrawingWindow.setFocusedFigure(this, !this.isSelected());
        }
        return true;
    }

    boolean recordFigureRect() {
        this.mTempFigureRect.setRect(this.getGraphRectInClientRect());
        return true;
    }

    private SGIFigureElement onFigureElementPressed(MouseEvent mouseEvent) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = sGIFigureElementArray.length - 1; i >= 0; --i) {
            if (!sGIFigureElementArray[i].setTemporaryPropertiesOfFocusedObjects()) {
                return null;
            }
            if (!sGIFigureElementArray[i].onMousePressed(mouseEvent)) continue;
            this.mPressedElement = sGIFigureElementArray[i];
            return sGIFigureElementArray[i];
        }
        return null;
    }

    protected boolean onMouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.mPressedElement != null) {
            ArrayList arrayList = this.mPressedElement.getFocusedObjectsList();
            if (!this.mPressedElement.onMouseDragged(mouseEvent)) {
                return false;
            }
            if (arrayList.size() != 0) {
                this.mWnd.moveFocusedObjects(n, n2);
            }
            this.setCursorToWindow(this.mPressedElement);
            return true;
        }
        if (!this.isSelected()) {
            return false;
        }
        int n3 = this.mMouseLocation;
        if (n3 == 0) {
            Rectangle2D rectangle2D = this.getExtraRegionBounds();
            if (this.mWnd.mMousePressLocation != null && !rectangle2D.contains(this.mWnd.mMousePressLocation)) {
                return false;
            }
            this.mWnd.moveFocusedObjects(n, n2);
            return true;
        }
        this.recordFigureRect();
        Point point = new Point(this.mPressedPoint);
        Rectangle2D rectangle2D = this.getDraggingRect();
        SGUtility.resizeRectangle(rectangle2D, point, mouseEvent, n3);
        if (rectangle2D.getWidth() < 50.0 || rectangle2D.getHeight() < 50.0) {
            return true;
        }
        this.mPressedPoint.setLocation(point);
        this.setDraggingRect(rectangle2D);
        this.snapToLines(n3);
        if (!mRubberBandFlag) {
            this.setGraphRectOnDragging();
        }
        return false;
    }

    @Override
    public void translate(float f, float f2) {
        Rectangle2D rectangle2D = this.getDraggingRect();
        this.setDraggingRect((float)rectangle2D.getX() + f, (float)rectangle2D.getY() + f2, (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
        this.snapToLines(0);
        if (!mRubberBandFlag) {
            this.mPressedPoint.setLocation((float)this.mPressedPoint.x + f, (float)this.mPressedPoint.y + f2);
            this.setGraphRectOnDragging();
        }
    }

    public void translateSelectedObjects(int n, int n2) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].equals(this.mPressedElement)) continue;
            sGIFigureElementArray[i].translateFocusedObjects(n, n2);
        }
    }

    Rectangle2D getRubberBandRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        ((Rectangle2D)float_).setRect(this.mRubberBandRect);
        return float_;
    }

    Rectangle2D getDraggingRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        ((Rectangle2D)float_).setRect(this.mDraggingRect);
        return float_;
    }

    void setRubberBandRect(float f, float f2, float f3, float f4) {
        this.mRubberBandRect.setRect(f, f2, f3, f4);
    }

    void setDraggingRect(float f, float f2, float f3, float f4) {
        this.mDraggingRect.setRect(f, f2, f3, f4);
    }

    void setDraggingRect(Rectangle2D rectangle2D) {
        this.mDraggingRect.setRect(rectangle2D);
    }

    protected boolean setGraphRectOnDragging() {
        Rectangle2D rectangle2D = this.getRubberBandRect();
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        Rectangle rectangle = this.getGraphRect().getBounds();
        if (rectangle.equals(rectangle2D.getBounds())) {
            return true;
        }
        this.setGraphRectLocationAttributes(f, f2);
        this.setGraphRectSizeAttributes(f3, f4);
        this.updateGraphRect();
        return true;
    }

    void snapToLines(int n) {
        if (SGFigure.isSnappingToGrid()) {
            this.snapToGrid(n);
        } else {
            this.snapToUnitCell(n);
        }
    }

    private void snapToUnitCell(int n) {
        float f = (float)SGUtilityNumber.getPowersOfTen(-1);
        float f2 = this.mMagnification * f / 0.035277776f;
        this.snap(f2, n);
    }

    private void snapToGrid(int n) {
        float f = this.mMagnification * this.mWnd.getGridLineInterval();
        this.snap(f, n);
    }

    private void snap(float f, int n) {
        float f2;
        float f3;
        float f4;
        int n2;
        float f5;
        int n3;
        float f6;
        float f7;
        float f8 = this.mWnd.getPaperX();
        float f9 = this.mWnd.getPaperY();
        Rectangle2D rectangle2D = this.getDraggingRect();
        float f10 = (float)rectangle2D.getMinX();
        float f11 = (float)rectangle2D.getMaxX();
        float f12 = (float)rectangle2D.getMinY();
        float f13 = (float)rectangle2D.getMaxY();
        float f14 = f10;
        float f15 = f13;
        float f16 = f14 - f8;
        float f17 = f15 - f9;
        int n4 = (int)(f16 / f);
        int n5 = (int)(f17 / f);
        float f18 = f * (float)n4;
        float f19 = f * (float)n5;
        int n6 = n4;
        int n7 = n5;
        if (f16 - f18 > f / 2.0f) {
            ++n6;
        }
        if (f17 - f19 > f / 2.0f) {
            ++n7;
        }
        float f20 = f8 + (float)n6 * f;
        float f21 = f9 + (float)n7 * f;
        if (n == 3 || n == 7 || n == 5) {
            f7 = f20;
            f6 = f11 - f7;
        } else if (n == 4 || n == 8 || n == 6) {
            f7 = f10;
            n3 = (int)((f11 - f8) / f);
            f5 = f * (float)n3;
            n2 = n3;
            if (f11 - f8 - f5 > f / 2.0f) {
                ++n2;
            }
            f4 = f8 + (float)n2 * f;
            f6 = f4 - f10;
        } else if (n == 0) {
            f7 = f20;
            f6 = (float)rectangle2D.getWidth();
        } else {
            f7 = f10;
            f6 = (float)rectangle2D.getWidth();
        }
        if (n == 2 || n == 7 || n == 8) {
            f3 = f12;
            f2 = f21 - f12;
        } else if (n == 1 || n == 6 || n == 5) {
            n3 = (int)((f12 - f9) / f);
            f5 = f * (float)n3;
            n2 = n3;
            if (f12 - f9 - f5 > f / 2.0f) {
                ++n2;
            }
            f4 = f9 + (float)n2 * f;
            f2 = f13 - f4;
            f3 = f4;
        } else if (n == 0) {
            f2 = (float)rectangle2D.getHeight();
            f3 = f21 - f2;
        } else {
            f3 = f12;
            f2 = (float)rectangle2D.getHeight();
        }
        this.setRubberBandRect(f7, f3, f6, f2);
    }

    protected boolean onMouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (!this.mWnd.isInsertFlagSelected()) {
            this.setMouseCursor(n, n2);
        }
        if (mRubberBandFlag && this.mPressedElement == null) {
            this.setGraphRectOnDragging();
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            mRubberBandVisibleFlag = false;
        }
        if (this.mPressedElement != null) {
            this.mPressedElement.onMouseReleased(mouseEvent);
        }
        this.mPressedElement = null;
        return true;
    }

    protected boolean isFigureMoved() {
        Rectangle rectangle;
        Rectangle rectangle2 = this.mTempFigureRect.getBounds();
        boolean bl = !rectangle2.equals(rectangle = this.getGraphRectInClientRect().getBounds());
        return bl;
    }

    public boolean drawbackFigure() {
        Rectangle2D rectangle2D = this.mWnd.getClientRect();
        Rectangle2D rectangle2D2 = this.getBoundingBox();
        Rectangle2D rectangle2D3 = this.mWnd.getPaperRect();
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        ((Rectangle2D)float_).setRect(rectangle2D2);
        if (rectangle2D2.getX() < rectangle2D.getX()) {
            ((Rectangle2D)float_).setRect(2.0, ((RectangularShape)float_).getY() + 2.0, ((RectangularShape)float_).getWidth(), ((RectangularShape)float_).getHeight());
        }
        if (rectangle2D2.getY() < rectangle2D.getY()) {
            ((Rectangle2D)float_).setRect(((RectangularShape)float_).getX() + 2.0, 2.0, ((RectangularShape)float_).getWidth(), ((RectangularShape)float_).getHeight());
        }
        if (rectangle2D2.getX() + rectangle2D2.getWidth() > rectangle2D3.getX() + rectangle2D3.getWidth()) {
            ((Rectangle2D)float_).setRect(rectangle2D3.getX() + rectangle2D3.getWidth() - rectangle2D2.getWidth() - 2.0, ((RectangularShape)float_).getY() + 2.0, ((RectangularShape)float_).getWidth(), ((RectangularShape)float_).getHeight());
        }
        if (rectangle2D2.getY() + rectangle2D2.getHeight() > rectangle2D3.getY() + rectangle2D3.getHeight()) {
            ((Rectangle2D)float_).setRect(((RectangularShape)float_).getX() + 2.0, rectangle2D3.getY() + rectangle2D3.getHeight() - rectangle2D2.getHeight() - 2.0, ((RectangularShape)float_).getWidth(), ((RectangularShape)float_).getHeight());
        }
        if (!this.setBoundingBox(float_)) {
            return false;
        }
        this.snapToLines(0);
        this.setGraphRectOnDragging();
        return true;
    }

    public boolean clearFocusedObjects() {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].clearFocusedObjects()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean setMementoBackward() {
        if (!this.mUndoManager.setMementoBackward()) {
            return false;
        }
        this.updateGraphRect();
        return true;
    }

    @Override
    public boolean setMementoForward() {
        if (!this.mUndoManager.setMementoForward()) {
            return false;
        }
        this.updateGraphRect();
        return true;
    }

    void updateGraphRect() {
        float f = this.getGraphRectX();
        float f2 = this.getGraphRectY();
        float f3 = this.getGraphRectWidth();
        float f4 = this.getGraphRectHeight();
        this.setRubberBandRect(f, f2, f3, f4);
        this.setDraggingRect(f, f2, f3, f4);
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        if (sGIFigureElementArray != null) {
            for (int i = 0; i < sGIFigureElementArray.length; ++i) {
                sGIFigureElementArray[i].setGraphRect(f, f2, f3, f4);
            }
        }
        this.repaint();
    }

    @Override
    public void notifyToRoot() {
        this.mWnd.notifyToRoot();
    }

    @Override
    public boolean isChanged() {
        return this.mUndoManager.isChanged();
    }

    @Override
    public boolean isChangedRoot() {
        if (this.isChanged()) {
            return true;
        }
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (!sGIFigureElementArray[i].isChangedRoot()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setChanged(boolean bl) {
        this.mUndoManager.setChanged(bl);
    }

    private Cursor setMouseCursor(int n, int n2) {
        this.setMouseLocation(n, n2);
        if (this.mMouseLocation == 0) {
            if (!this.onDrawingElement(n, n2)) {
                return this.setMouseCursor();
            }
        } else {
            return this.setMouseCursor();
        }
        return null;
    }

    private Cursor setMouseCursor() {
        if (!this.isSelected()) {
            Cursor cursor = Cursor.getDefaultCursor();
            this.setMouseCursor(cursor);
            return cursor;
        }
        return this.changeCursor();
    }

    private void setMouseLocation(int n, int n2) {
        float f = 1.5f * SGClientPanel.getAnchorSize();
        Rectangle2D rectangle2D = this.getRubberBandRect();
        this.mMouseLocation = SGUtility.getMouseLocation(rectangle2D, n, n2, f);
    }

    private Cursor changeCursor() {
        Cursor cursor = null;
        switch (this.mMouseLocation) {
            case 3: {
                cursor = new Cursor(10);
                break;
            }
            case 4: {
                cursor = new Cursor(11);
                break;
            }
            case 1: {
                cursor = new Cursor(8);
                break;
            }
            case 2: {
                cursor = new Cursor(9);
                break;
            }
            case 5: {
                cursor = new Cursor(6);
                break;
            }
            case 8: {
                cursor = new Cursor(5);
                break;
            }
            case 6: {
                cursor = new Cursor(7);
                break;
            }
            case 7: {
                cursor = new Cursor(4);
                break;
            }
            default: {
                cursor = Cursor.getDefaultCursor();
            }
        }
        this.setMouseCursor(cursor);
        return cursor;
    }

    private void setMouseCursor(Cursor cursor) {
        this.mWnd.setCursor(cursor);
    }

    private boolean onDrawingElement(int n, int n2) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = sGIFigureElementArray.length - 1; i >= 0; --i) {
            if (!sGIFigureElementArray[i].onDrawingElement(n, n2)) continue;
            this.setCursorToWindow(sGIFigureElementArray[i]);
            return true;
        }
        this.setMouseCursor(Cursor.getDefaultCursor());
        return false;
    }

    protected boolean setCursorToWindow(SGIFigureElement sGIFigureElement) {
        Cursor cursor = sGIFigureElement.getFigureElementCursor();
        if (cursor != null) {
            this.mWnd.setCursor(cursor);
        }
        return true;
    }

    public JPopupMenu getPopupMenu() {
        String string;
        JMenuItem jMenuItem;
        int n;
        JPopupMenu jPopupMenu = null;
        if (this.mPopupMenu != null) {
            jPopupMenu = this.mPopupMenu;
        } else {
            this.mPopupMenu = jPopupMenu = this.createPopupMenu();
        }
        Component[] componentArray = jPopupMenu.getComponents();
        for (n = 0; n < componentArray.length; ++n) {
            if (!(componentArray[n] instanceof JCheckBoxMenuItem)) continue;
            jMenuItem = (JCheckBoxMenuItem)componentArray[n];
            string = jMenuItem.getActionCommand();
            if (string.equals(MENUCMD_RUBBER_BANDING)) {
                jMenuItem.setSelected(mRubberBandFlag);
                continue;
            }
            if (string.equals(MENUCMD_SHOW_BOUNDING_BOX)) {
                jMenuItem.setSelected(mBoundingBoxVisibleFlag);
                continue;
            }
            if (string.equals("Snap to Grid")) {
                jMenuItem.setSelected(SGFigure.isSnappingToGrid());
                continue;
            }
            if (string.equals(MENUCMD_LEGEND_VISIBLE)) {
                jMenuItem.setSelected(this.isLegendVisible());
                continue;
            }
            if (!string.equals(MENUCMD_COLOR_BAR_VISIBLE)) continue;
            jMenuItem.setSelected(this.isColorBarVisible());
        }
        for (n = 0; n < componentArray.length; ++n) {
            boolean bl;
            if (!(componentArray[n] instanceof JMenuItem)) continue;
            jMenuItem = (JMenuItem)componentArray[n];
            string = jMenuItem.getActionCommand();
            if (MENUCMD_LEGEND_VISIBLE.equals(string)) {
                bl = this.isLegendAvailable();
                jMenuItem.setEnabled(bl);
                continue;
            }
            if (MENUCMD_COLOR_BAR_VISIBLE.equals(string)) {
                bl = this.isColorBarAvailable();
                jMenuItem.setEnabled(bl);
                continue;
            }
            if (!"Align Bars".equals(string)) continue;
            bl = this.isAlignmentBarsAvailable();
            jMenuItem.setEnabled(bl);
        }
        return jPopupMenu;
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.setBounds(0, 0, 100, 100);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  -- Figure: ");
        stringBuffer.append(this.getID());
        stringBuffer.append(" --");
        jPopupMenu.add(new JLabel(stringBuffer.toString()));
        jPopupMenu.addSeparator();
        SGUtility.addCheckBoxItem(jPopupMenu, this, MENUCMD_RUBBER_BANDING);
        SGUtility.addCheckBoxItem(jPopupMenu, this, "Snap to Grid");
        SGUtility.addCheckBoxItem(jPopupMenu, this, MENUCMD_SHOW_BOUNDING_BOX);
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, MENUCMD_SAVE_PROPERTY);
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, "Bring to Front");
        SGUtility.addItem(jPopupMenu, this, "Bring Forward");
        SGUtility.addItem(jPopupMenu, this, "Send Backward");
        SGUtility.addItem(jPopupMenu, this, "Send to Back");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, "Cut");
        SGUtility.addItem(jPopupMenu, this, "Copy");
        SGUtility.addItem(jPopupMenu, this, "Paste");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, "Delete");
        SGUtility.addItem(jPopupMenu, this, "Duplicate");
        jPopupMenu.addSeparator();
        SGUtility.addCheckBoxItem(jPopupMenu, this, MENUCMD_LEGEND_VISIBLE);
        SGUtility.addCheckBoxItem(jPopupMenu, this, MENUCMD_COLOR_BAR_VISIBLE);
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, "Fit axes");
        SGUtility.addItem(jPopupMenu, this, "Align Bars");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, MENUCMD_PROPERTY);
        return jPopupMenu;
    }

    @Override
    public boolean prepare() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    public SGProperties getProperties() {
        FigureProperties figureProperties = new FigureProperties();
        this.getProperties(figureProperties);
        return figureProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof FigureProperties)) {
            return false;
        }
        FigureProperties figureProperties = (FigureProperties)sGProperties;
        figureProperties.setX(this.mGraphRectX);
        figureProperties.setY(this.mGraphRectY);
        figureProperties.setWidth(this.mGraphRectWidth);
        figureProperties.setHeight(this.mGraphRectHeight);
        figureProperties.setSpaceLineAndNumber(this.getAxisElement().getSpaceAxisLineAndNumber());
        figureProperties.setSpaceNumberAndTitle(this.getAxisElement().getSpaceNumberAndTitle());
        figureProperties.setBackgroundColor(this.mBackgroundColor);
        figureProperties.setTransparent(this.mTransparentFlag);
        figureProperties.setLegendVisible(this.getLegendElement().isLegendVisible());
        figureProperties.mColorBarVisibleFlag = this.getAxisElement().isColorBarVisible();
        return true;
    }

    @Override
    public abstract SGPropertyDialog getPropertyDialog();

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        MenuElement[] menuElementArray;
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (string.equals(MENUCMD_SHOW_BOUNDING_BOX)) {
            mBoundingBoxVisibleFlag = !mBoundingBoxVisibleFlag;
            this.repaint();
            return;
        }
        if (string.equals(MENUCMD_RUBBER_BANDING)) {
            mRubberBandFlag = !mRubberBandFlag;
            this.repaint();
            return;
        }
        if (string.equals("Snap to Grid")) {
            SGFigure.setSnappingToGrid(!SGFigure.isSnappingToGrid());
            this.mWnd.updateSnapToGridItems();
            return;
        }
        if (string.equals(MENUCMD_SAVE_PROPERTY)) {
            this.mWnd.createPropertyFileFromFocusedFigures();
        } else if (string.equals(MENUCMD_PROPERTY)) {
            this.mWnd.showPropertyDialogForSelectedFigures();
        } else if (string.equals("Bring to Front")) {
            this.mWnd.bringFocusedObjectsToFront();
        } else if (string.equals("Bring Forward")) {
            this.mWnd.bringFocusedObjectsForward();
        } else if (string.equals("Send Backward")) {
            this.mWnd.sendFocusedObjectsBackward();
        } else if (string.equals("Send to Back")) {
            this.mWnd.sendFocusedObjectsToBack();
        } else if (string.equals("Cut")) {
            this.mWnd.doCut();
        } else if (string.equals("Copy")) {
            this.mWnd.doCopy();
        } else if (string.equals("Paste")) {
            this.mWnd.doPaste();
        } else if (string.equals("Delete")) {
            this.mWnd.doDelete();
        } else if (string.equals("Duplicate")) {
            this.mWnd.doDuplicate();
        } else if (string.equals(MENUCMD_LEGEND_VISIBLE)) {
            this.setLegendVisible(!this.isLegendVisible());
            this.notifyToRoot();
            this.repaint();
        } else if (string.equals(MENUCMD_COLOR_BAR_VISIBLE)) {
            this.setColorBarVisible(!this.isColorBarVisible());
            this.notifyToRoot();
            this.repaint();
        } else {
            boolean bl;
            if (string.equals("Insert Label of Fixed Values")) {
                this.mWnd.doInserNetCDFLabel();
                this.notifyToRoot();
                return;
            }
            if (string.equals("Play Animation")) {
                this.mMouseInExtraRegionFlag = false;
                this.clearFocusedObjects();
            } else if (string.equals("Fit axes")) {
                bl = false;
                if (null != this.mPopupMenu) {
                    menuElementArray = this.mPopupMenu.getSubElements();
                    for (int i = 0; i < menuElementArray.length; ++i) {
                        if (!menuElementArray[i].equals(object)) continue;
                        bl = true;
                    }
                }
                if (bl) {
                    this.mWnd.doFitAxisRangeToVisibleData();
                } else {
                    this.mWnd.doFitAxisRangeToData();
                }
            } else if (string.equals("Align Bars")) {
                this.mWnd.doAlignBars();
            } else if (string.equals("Split")) {
                this.mWnd.doSplitMultipleData();
            } else if (string.equals("Transform")) {
                this.mWnd.doTransformData();
            } else if (string.equals("Anchored")) {
                bl = ((JCheckBoxMenuItem)actionEvent.getSource()).isSelected();
                this.setAnchoredToFocusedObjects(bl);
            } else if (string.equals("OutputToFileIsEnabled")) {
                if (object instanceof SGPluginsQueryMessage) {
                    List<SGData> list = this.getGraphElement().getFocusedDataList();
                    if (list.size() != 1) {
                        ((SGPluginsQueryMessage)object).set(Boolean.FALSE);
                    } else {
                        this.mWnd.notifyToListener("Output to File", object);
                    }
                    return;
                }
            } else if (string.equals("Notify unknown data error occurred")) {
                this.hideData(new int[]{(Integer)object});
                this.getWindow().clearUndoBuffer();
                return;
            }
        }
        if (object instanceof SGIFigureElement) {
            SGIFigureElement sGIFigureElement = (SGIFigureElement)actionEvent.getSource();
            if (string.equals("Set properties of selected objects")) {
                this.mWnd.showPropertyDialogForSelectedObjects(this, sGIFigureElement);
            } else if (string.equals("Clear focused objects")) {
                this.mWnd.clearAllFocusedObjectsInFigures();
            } else if (string.equals("Notify the change to root")) {
                this.notifyToRoot();
            } else if (string.equals("Notify the change of cursor")) {
                this.setCursorToWindow(sGIFigureElement);
            } else if (string.equals("Notify the conversion of data")) {
                if (sGIFigureElement instanceof SGIFigureElementGraph && ((SGIFigureElementGraph)sGIFigureElement).convertData(this)) {
                    this.notifyToRoot();
                }
            } else if (string.equals("Notify undoing the conversion of data")) {
                this.mWnd.doUndoAndDeleteForward();
            } else if (string.equals("Merge")) {
                this.mWnd.doMergeMultipleData();
            } else if (string.equals("Output to File")) {
                menuElementArray = this.getGraphElement().getFocusedDataList();
                if (menuElementArray.size() >= 1) {
                    this.mWnd.doOutputDataToFile(menuElementArray.get(0));
                }
            } else {
                this.broadcast(sGIFigureElement, string);
                this.updateNetCDFLabel(sGIFigureElement);
            }
        }
    }

    @Override
    public boolean initPropertiesHistory() {
        return this.mUndoManager.initPropertiesHistory();
    }

    @Override
    public boolean undo() {
        return this.mUndoManager.undo();
    }

    @Override
    public boolean redo() {
        return this.mUndoManager.redo();
    }

    @Override
    public boolean commit() {
        SGProperties sGProperties = this.mTemporaryProperties;
        SGProperties sGProperties2 = this.getProperties();
        if (!sGProperties.equals(sGProperties2)) {
            this.mUndoManager.setChanged(true);
        }
        this.mTemporaryProperties = null;
        this.updateGraphRect();
        return true;
    }

    @Override
    public boolean preview() {
        this.updateGraphRect();
        return true;
    }

    @Override
    public boolean cancel() {
        this.setProperties(this.mTemporaryProperties);
        this.updateGraphRect();
        this.mTemporaryProperties = null;
        return true;
    }

    @Override
    public SGProperties getMemento() {
        return this.getProperties();
    }

    @Override
    public boolean setMemento(SGProperties sGProperties) {
        return this.setProperties(sGProperties);
    }

    @Override
    public boolean updateHistory() {
        ArrayList<SGIFigureElement> arrayList = new ArrayList<SGIFigureElement>();
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            SGIFigureElement sGIFigureElement = sGIFigureElementArray[i];
            arrayList.add(sGIFigureElement);
        }
        return this.mUndoManager.updateHistory(arrayList);
    }

    @Override
    public void initUndoBuffer() {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].initUndoBuffer();
        }
        this.mUndoManager.initUndoBuffer();
        if (!this.deleteUselessData()) {
            throw new Error("Failed to initialize undo buffer.");
        }
    }

    @Override
    public boolean isUndoable() {
        return this.mUndoManager.isUndoable();
    }

    @Override
    public boolean isRedoable() {
        return this.mUndoManager.isRedoable();
    }

    @Override
    public void clearChanged() {
        this.setChanged(false);
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].clearChanged();
        }
    }

    @Override
    public boolean deleteForwardHistory() {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].deleteForwardHistory()) continue;
            return false;
        }
        if (!this.mUndoManager.deleteForwardHistory()) {
            return false;
        }
        return this.deleteUselessData();
    }

    protected boolean deleteUselessData() {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        HashSet<SGData> hashSet = new HashSet<SGData>();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            List<SGData> object = sGIFigureElementArray[i].getUselessDataList();
            hashSet.addAll(object);
        }
        for (SGData sGData : hashSet) {
            this.deleteData(sGData);
        }
        return true;
    }

    private void deleteData(SGData sGData) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        this.mDataList.remove(sGData);
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].removeData(sGData);
        }
        sGData.dispose();
    }

    public boolean initGraphAreaLocation() {
        float f;
        SGTuple2f sGTuple2f = new SGTuple2f();
        SGTuple2f sGTuple2f2 = new SGTuple2f();
        if (!this.calcMargin(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        float f2 = sGTuple2f.x;
        this.mGraphRectX = f = sGTuple2f2.x;
        this.mGraphRectY = f2;
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].setGraphRectLocation(this.mGraphRectX, this.mGraphRectY);
            sGIFigureElementArray[i].setGraphRectSize(this.mGraphRectWidth, this.mGraphRectHeight);
        }
        return true;
    }

    public boolean calcMargin(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[sGIFigureElementArray.length];
        SGTuple2f[] sGTuple2fArray2 = new SGTuple2f[sGIFigureElementArray.length];
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGTuple2fArray[i] = new SGTuple2f();
            sGTuple2fArray2[i] = new SGTuple2f();
            boolean bl = sGIFigureElementArray[i].getMarginAroundGraphRect(sGTuple2fArray[i], sGTuple2fArray2[i]);
            if (bl) continue;
            return false;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            float f5 = sGTuple2fArray[i].x;
            float f6 = sGTuple2fArray[i].y;
            float f7 = sGTuple2fArray2[i].x;
            float f8 = sGTuple2fArray2[i].y;
            if (f5 > f) {
                f = f5;
            }
            if (f6 > f2) {
                f2 = f6;
            }
            if (f7 > f3) {
                f3 = f7;
            }
            if (!(f8 > f4)) continue;
            f4 = f8;
        }
        float f9 = this.mMagnification;
        sGTuple2f.x = f + f9 * 5.0f;
        sGTuple2f.y = f2 + f9 * 5.0f;
        sGTuple2f2.x = f3 + f9 * 5.0f;
        sGTuple2f2.y = f4 + f9 * 5.0f;
        return true;
    }

    public Rectangle2D getBoundingBox() {
        Rectangle2D rectangle2D = this.getGraphRect();
        SGTuple2f sGTuple2f = new SGTuple2f();
        SGTuple2f sGTuple2f2 = new SGTuple2f();
        if (!this.calcMargin(sGTuple2f, sGTuple2f2)) {
            return null;
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float((float)rectangle2D.getX() - sGTuple2f2.x, (float)rectangle2D.getY() - sGTuple2f.x, (float)rectangle2D.getWidth() + sGTuple2f2.x + sGTuple2f2.y, (float)rectangle2D.getHeight() + sGTuple2f.x + sGTuple2f.y);
        return float_;
    }

    public boolean setBoundingBox(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return false;
        }
        SGTuple2f sGTuple2f = new SGTuple2f();
        SGTuple2f sGTuple2f2 = new SGTuple2f();
        if (!this.calcMargin(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        float f = (float)rectangle2D.getX() + sGTuple2f2.x;
        float f2 = (float)rectangle2D.getY() + sGTuple2f.x;
        float f3 = (float)rectangle2D.getWidth() - (sGTuple2f2.x + sGTuple2f2.y);
        float f4 = (float)rectangle2D.getHeight() - (sGTuple2f.x + sGTuple2f.y);
        this.setGraphRect(f, f2, f3, f4);
        return true;
    }

    public boolean setCenter(float f, float f2) {
        float f3;
        float f4;
        Rectangle2D rectangle2D = this.getBoundingBox();
        float f5 = (float)rectangle2D.getWidth();
        float f6 = f - f5 / 2.0f;
        Rectangle2D.Float float_ = new Rectangle2D.Float(f6, f4 = f2 - (f3 = (float)rectangle2D.getHeight()) / 2.0f, f5, f3);
        return this.setBoundingBox(float_);
    }

    public boolean setGraphRectLocationByLeftBottom(float f, float f2) {
        Rectangle2D rectangle2D = this.getGraphRect();
        this.setGraphRectLocation(f, f2 - (float)rectangle2D.getHeight());
        return true;
    }

    private boolean broadcast(SGIFigureElement sGIFigureElement, String string) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].synchronize(sGIFigureElement, string);
        }
        return true;
    }

    public List getDataList() {
        return new ArrayList<SGData>(this.mDataList);
    }

    public List<SGData> getVisibleDataList() {
        return this.getGraphElement().getVisibleDataList();
    }

    @Override
    public void paint(Graphics graphics, boolean bl) {
        if (this.isDisposed()) {
            return;
        }
        this.paintGraphics((Graphics2D)graphics, bl);
    }

    private void paintGraphics(Graphics2D graphics2D, boolean bl) {
        Object object;
        if (this.mMouseInExtraRegionFlag) {
            object = this.getExtraRegionBounds();
            graphics2D.setPaint(EXTRA_REGION_COLOR);
            graphics2D.fill((Shape)object);
        }
        if (!this.mTransparentFlag) {
            object = this.getGraphRect();
            graphics2D.setPaint(this.mBackgroundColor);
            graphics2D.fill((Shape)object);
        }
        if (mBoundingBoxVisibleFlag && this.mSelectionSymbolsVisibleFlag && (object = this.getBoundingBox()) != null) {
            graphics2D.setPaint(Color.BLUE);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.draw((Shape)object);
        }
        object = this.getIFigureElementArray();
        for (int i = 0; i < ((SGIFigureElement[])object).length; ++i) {
            object[i].paint(graphics2D, bl);
        }
    }

    public Element createElement(Document document, int n) {
        Element element = document.createElement("Figure");
        if (!this.writeProperty(element)) {
            return null;
        }
        if (!this.createElementLower(document, element, n)) {
            return null;
        }
        return element;
    }

    public Element createElementForFocusedInBoundingBox(Document document, int n) {
        Element element = document.createElement("Figure");
        if (!this.writePropertyOnFocusedInBoundingBox(element)) {
            return null;
        }
        if (!this.createElementLower(document, element, n)) {
            return null;
        }
        return element;
    }

    public Element createElementForFocusedForDuplication(Document document, int n) {
        Element element = document.createElement("Figure");
        if (!this.writePropertyForDuplication(element)) {
            return null;
        }
        if (!this.createElementLower(document, element, n)) {
            return null;
        }
        return element;
    }

    private boolean createElementLower(Document document, Element element, int n) {
        Element element2;
        int n2;
        Element[] elementArray;
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i] instanceof SGIFigureElementGraph) continue;
            elementArray = sGIFigureElementArray[i].createElement(document);
            if (elementArray == null) {
                return false;
            }
            for (int j = 0; j < elementArray.length; ++j) {
                element.appendChild(elementArray[j]);
            }
        }
        ArrayList arrayList = new ArrayList();
        elementArray = new ArrayList();
        if (!this.getGraphElement().createElementOfData(document, arrayList, (List)elementArray, n)) {
            return false;
        }
        SGIFigureElementLegend sGIFigureElementLegend = this.getLegendElement();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            element2 = (Element)arrayList.get(n2);
            SGData sGData = (SGData)elementArray.get(n2);
            int n3 = sGIFigureElementLegend.getIndex(sGData);
            if (n3 < 0) {
                return false;
            }
            element2.setAttribute("IndexInLegend", Integer.toString(n3));
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            element2 = (Element)arrayList.get(n2);
            element.appendChild(element2);
        }
        return true;
    }

    public boolean writeProperty(Element element) {
        float f = this.mGraphRectX;
        float f2 = this.mGraphRectY;
        return this.writePropertySub(element, f, f2);
    }

    public boolean writePropertyOnFocusedInBoundingBox(Element element) {
        SGDrawingWindow sGDrawingWindow = this.getWindow();
        Rectangle2D rectangle2D = sGDrawingWindow.getBoundingBoxOfFigures(sGDrawingWindow.getFocusedFigureList());
        Rectangle2D rectangle2D2 = sGDrawingWindow.getPaperRect();
        float f = this.mGraphRectX - (float)(rectangle2D.getX() - rectangle2D2.getX()) / this.mMagnification;
        float f2 = this.mGraphRectY - (float)(rectangle2D.getY() - rectangle2D2.getY()) / this.mMagnification;
        return this.writePropertySub(element, f, f2);
    }

    public boolean writePropertyForDuplication(Element element) {
        float f = 20.0f * this.mMagnification;
        float f2 = this.mGraphRectX + f;
        float f3 = this.mGraphRectY + f;
        return this.writePropertySub(element, f2, f3);
    }

    public String getClassType() {
        return this.mClassType;
    }

    public void setClassType(String string) {
        this.mClassType = string;
    }

    private boolean writePropertySub(Element element, float f, float f2) {
        element.setAttribute("Type", this.getClassType());
        float f3 = (float)SGUtilityNumber.roundOffNumber(f * 0.035277776f, -2);
        float f4 = (float)SGUtilityNumber.roundOffNumber(f2 * 0.035277776f, -2);
        element.setAttribute("X", Float.toString(f3) + "cm");
        element.setAttribute("Y", Float.toString(f4) + "cm");
        float f5 = (float)SGUtilityNumber.roundOffNumber(this.mGraphRectWidth * 0.035277776f, -2);
        float f6 = (float)SGUtilityNumber.roundOffNumber(this.mGraphRectHeight * 0.035277776f, -2);
        element.setAttribute("Width", Float.toString(f5) + "cm");
        element.setAttribute("Height", Float.toString(f6) + "cm");
        float f7 = (float)SGUtilityNumber.roundOffNumber(this.getSpaceAxisLineAndNumber() * 0.035277776f, -3);
        float f8 = (float)SGUtilityNumber.roundOffNumber(this.getSpaceNumberAndTitle() * 0.035277776f, -3);
        element.setAttribute("SpaceAxisLineAndNumber", Float.toString(f7) + "cm");
        element.setAttribute("SpaceNumberAndTitle", Float.toString(f8) + "cm");
        element.setAttribute("BackgroundColor", SGUtilityText.getColorString(this.mBackgroundColor));
        element.setAttribute("BackgroundTransparent", Boolean.toString(this.mTransparentFlag));
        return true;
    }

    public boolean readProperty(Element element) {
        float f;
        StringBuffer stringBuffer;
        String string = null;
        Number number = null;
        Boolean bl = null;
        Color color = null;
        string = element.getAttribute("X");
        if (string.length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setFigureX(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("Y")).length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setFigureY(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("Width")).length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setFigureWidth(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("Height")).length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setFigureHeight(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("BackgroundColor")).length() != 0) {
            color = SGUtilityText.parseColor(string);
            if (color == null) {
                return false;
            }
            if (!this.setBackgroundColor(color)) {
                return false;
            }
        }
        if ((string = element.getAttribute("BackgroundTransparent")).length() != 0) {
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            boolean bl2 = bl;
            if (!this.setTransparent(bl2)) {
                return false;
            }
        }
        return true;
    }

    public boolean createDataObjectFromPropertyFile(Element element, SGData sGData, boolean bl) {
        this.mDataList.add(sGData);
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].createDataObject(element, sGData, bl)) continue;
            return false;
        }
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof FigureProperties)) {
            return false;
        }
        FigureProperties figureProperties = (FigureProperties)sGProperties;
        this.mGraphRectX = figureProperties.mX;
        this.mGraphRectY = figureProperties.mY;
        this.mGraphRectWidth = figureProperties.mWidth;
        this.mGraphRectHeight = figureProperties.mHeight;
        this.setBackgroundColor(figureProperties.mBackgroundColor);
        this.setTransparent(figureProperties.mTransparentFlag);
        this.setSpaceAxisLineAndNumber(figureProperties.mSpaceLineAndNumber);
        this.setSpaceNumberAndTitle(figureProperties.mSpaceNumberAndTitle);
        this.setColorBarVisible(figureProperties.mColorBarVisibleFlag);
        this.setLegendVisible(figureProperties.mLegendVisibleFlag);
        return true;
    }

    protected boolean duplicateFocusedObjects() {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].duplicateFocusedObjects()) continue;
            return false;
        }
        return true;
    }

    protected List<SGICopiable> createCopiedObjects() {
        ArrayList<SGICopiable> arrayList = new ArrayList<SGICopiable>();
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            arrayList.addAll(sGIFigureElementArray[i].getCopiedObjectsList());
        }
        return arrayList;
    }

    protected List<SGICopiable> cutFocusedObjects() {
        ArrayList<SGICopiable> arrayList = new ArrayList<SGICopiable>();
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            arrayList.addAll(sGIFigureElementArray[i].cutFocusedObjects());
        }
        return arrayList;
    }

    boolean createCopiedDataObjects(List<SGData> list, List<String> list2, List<Map<Class, SGProperties>> list3) {
        List<SGData> list4 = this.getGraphElement().getFocusedDataList();
        List<SGData> list5 = this.getLegendElement().getFocusedDataList();
        return this.cutOrCopyFocusedDataObjects(true, list4, list5, list, list2, list3);
    }

    boolean cutFocusedDataObjects(List<SGData> list, List<String> list2, List<Map<Class, SGProperties>> list3) {
        List<SGData> list4 = this.getGraphElement().cutFocusedData();
        List<SGData> list5 = this.getLegendElement().cutFocusedData();
        return this.cutOrCopyFocusedDataObjects(true, list4, list5, list, list2, list3);
    }

    private boolean cutOrCopyFocusedDataObjects(boolean bl, List<SGData> list, List<SGData> list2, List<SGData> list3, List<String> list4, List<Map<Class, SGProperties>> list5) {
        SGData sGData;
        int n;
        ArrayList<SGData> arrayList = new ArrayList<SGData>();
        arrayList.addAll(list);
        for (n = 0; n < list2.size(); ++n) {
            sGData = list2.get(n);
            if (list.contains(sGData)) continue;
            arrayList.add(sGData);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            sGData = (SGData)arrayList.get(n);
            list3.add((SGData)sGData.copy());
            String string = this.getDataName(sGData);
            list4.add(string);
            Map<Class, SGProperties> map = this.getDataPropertiesMap(sGData);
            list5.add(map);
        }
        return true;
    }

    public SGData getData(int n) {
        return this.getGraphElement().getData(n);
    }

    public boolean isDataVisible(int n) {
        SGData sGData = this.getData(n);
        if (sGData == null) {
            return false;
        }
        return this.getGraphElement().isDataVisible(sGData);
    }

    public String getDataName(SGData sGData) {
        return this.getGraphElement().getDataName(sGData);
    }

    public boolean setDataName(String string, SGData sGData) {
        return this.getGraphElement().setDataName(string, sGData);
    }

    public Map<Class, SGProperties> getDataPropertiesMap(SGData sGData) {
        HashMap<Class, SGProperties> hashMap = new HashMap<Class, SGProperties>();
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            SGProperties sGProperties = sGIFigureElementArray[i].getDataProperties(sGData);
            hashMap.put(sGIFigureElementArray[i].getClass(), sGProperties);
        }
        return hashMap;
    }

    public boolean paste(List<SGICopiable> list) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].paste(list)) continue;
            return false;
        }
        return true;
    }

    public boolean moveFocusedObjects(boolean bl) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].moveFocusedObjects(bl)) continue;
            return false;
        }
        return true;
    }

    public boolean moveFocusedObjects(int n) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].moveFocusedObjects(n)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        this.mDisposed = true;
        if (this.mPropertyDialog != null) {
            this.mPropertyDialog.dispose();
            this.mPropertyDialog = null;
        }
        this.mPopupMenu = null;
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < this.mDataList.size(); ++i) {
            SGData sGIDisposable = this.mDataList.get(i);
            for (int j = 0; j < sGIFigureElementArray.length; ++j) {
                sGIFigureElementArray[j].removeData(sGIDisposable);
            }
            sGIDisposable.dispose();
        }
        this.mDataList.clear();
        for (SGIFigureElement sGIFigureElement : this.mFigureElementMap.values()) {
            sGIFigureElement.dispose();
        }
        this.mFigureElementMap.clear();
        this.mComponent = null;
        this.mWnd = null;
    }

    public void setMode(int n) {
        this.mMode = n;
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].setMode(n);
        }
    }

    public int getMode() {
        return this.mMode;
    }

    public static boolean isSnappingToGrid() {
        return mSnapToGridFlag;
    }

    public static void setSnappingToGrid(boolean bl) {
        mSnapToGridFlag = bl;
    }

    boolean insertNetCDFLabel() {
        SGIFigureElementString sGIFigureElementString = (SGIFigureElementString)this.getIFigureElement(SGIFigureElementString.class);
        SGIFigureElementGraph sGIFigureElementGraph = (SGIFigureElementGraph)this.getIFigureElement(SGIFigureElementGraph.class);
        return null == sGIFigureElementGraph.showNetCDFLabels(sGIFigureElementString);
    }

    public boolean insertNetCDFLabels(int[] nArray) {
        SGIDisposable sGIDisposable;
        ArrayList<SGData> arrayList = new ArrayList<SGData>();
        for (int i = 0; i < nArray.length; ++i) {
            sGIDisposable = this.getData(nArray[i]);
            if (sGIDisposable == null) {
                return false;
            }
            arrayList.add((SGData)sGIDisposable);
        }
        SGIFigureElementString sGIFigureElementString = (SGIFigureElementString)this.getIFigureElement(SGIFigureElementString.class);
        sGIDisposable = (SGIFigureElementGraph)this.getIFigureElement(SGIFigureElementGraph.class);
        return null == sGIDisposable.showNetCDFLabels(sGIFigureElementString, arrayList);
    }

    void updateNetCDFLabel(SGIFigureElement sGIFigureElement) {
        SGIFigureElementString sGIFigureElementString = (SGIFigureElementString)this.getIFigureElement(SGIFigureElementString.class);
        SGIFigureElementGraph sGIFigureElementGraph = (SGIFigureElementGraph)this.getIFigureElement(SGIFigureElementGraph.class);
        sGIFigureElementGraph.updateNetCDFLabels(sGIFigureElementString);
    }

    void onMenuSelected() {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].onMenuSelected();
        }
    }

    Rectangle2D getExtraRegionBounds() {
        Rectangle2D rectangle2D = this.getGraphRect();
        float f = this.mMagnification * 1.0f / 0.035277776f;
        double d = rectangle2D.getX() - (double)f;
        double d2 = rectangle2D.getY() - (double)f;
        double d3 = rectangle2D.getWidth() + 2.0 * (double)f;
        double d4 = rectangle2D.getHeight() + 2.0 * (double)f;
        rectangle2D.setRect(d, d2, d3, d4);
        return rectangle2D;
    }

    void beforeExport() {
        this.mMouseInExtraRegionFlag = false;
        this.setSelectionSymbolsVisible(false);
        this.setSymbolsAroundAllObjectsVisible(false);
    }

    void afterExport() {
        this.setVisible(true);
        this.setSelectionSymbolsVisible(true);
        if (this.isSelected()) {
            this.setSymbolsAroundAllObjectsVisible(true);
        }
        this.setMode(1);
    }

    @Override
    public boolean isLegendAvailable() {
        return this.getGraphElement().getVisibleDataList().size() != 0;
    }

    @Override
    public boolean isColorBarAvailable() {
        SGIFigureElementAxis sGIFigureElementAxis = this.getAxisElement();
        return sGIFigureElementAxis.isColorBarAvailable();
    }

    public boolean fitAxisRangeToFocusedData() {
        SGIFigureElementGraph sGIFigureElementGraph = this.getGraphElement();
        SGIFigureElementAxis sGIFigureElementAxis = this.getAxisElement();
        return sGIFigureElementAxis.fitAxisRangeToFocusedData(sGIFigureElementGraph);
    }

    public boolean fitAxisRangeToData(int[] nArray) {
        SGIDisposable sGIDisposable;
        ArrayList<SGData> arrayList = new ArrayList<SGData>();
        for (int i = 0; i < nArray.length; ++i) {
            sGIDisposable = this.getData(nArray[i]);
            if (sGIDisposable == null) {
                return false;
            }
            arrayList.add((SGData)sGIDisposable);
        }
        SGIFigureElementGraph sGIFigureElementGraph = this.getGraphElement();
        sGIDisposable = this.getAxisElement();
        if (!sGIDisposable.fitAxisRangeToData(sGIFigureElementGraph, arrayList)) {
            return false;
        }
        if (this.isChangedRoot()) {
            this.notifyToRoot();
        }
        this.repaint();
        return true;
    }

    public boolean fitAxisRangeToVisibleData() {
        List<SGData> list;
        SGIFigureElementGraph sGIFigureElementGraph = this.getGraphElement();
        SGIFigureElementAxis sGIFigureElementAxis = this.getAxisElement();
        if (!sGIFigureElementAxis.fitAxisRangeToData(sGIFigureElementGraph, list = sGIFigureElementGraph.getVisibleDataList())) {
            return false;
        }
        if (this.isChangedRoot()) {
            this.notifyToRoot();
        }
        this.repaint();
        return true;
    }

    private boolean isAlignmentBarsAvailable() {
        return this.getGraphElement().isBarVisible();
    }

    public boolean alignVisibleBars() {
        SGIFigureElementGraph sGIFigureElementGraph = this.getGraphElement();
        if (!sGIFigureElementGraph.alignVisibleBars()) {
            return false;
        }
        if (this.isChangedRoot()) {
            this.notifyToRoot();
        }
        this.repaint();
        return true;
    }

    void setAnchoredToFocusedObjects(boolean bl) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            ArrayList arrayList = sGIFigureElementArray[i].getFocusedObjectsList();
            for (int j = 0; j < arrayList.size(); ++j) {
                SGIAnchored sGIAnchored;
                Object e = arrayList.get(j);
                if (!(e instanceof SGIAnchored) || (sGIAnchored = (SGIAnchored)e).isAnchored() == bl) continue;
                sGIAnchored.setAnchored(bl);
                if (!(sGIAnchored instanceof SGIUndoable)) continue;
                ((SGIUndoable)((Object)sGIAnchored)).setChanged(true);
            }
        }
        this.repaint();
        this.notifyToRoot();
    }

    public SGPropertyResults setProperties(SGPropertyMap sGPropertyMap) {
        SGPropertyResults sGPropertyResults = new SGPropertyResults();
        if (!this.prepare()) {
            return null;
        }
        if ((sGPropertyResults = this.setProperties(sGPropertyMap, sGPropertyResults)) == null) {
            return null;
        }
        if (!this.commit()) {
            return null;
        }
        this.notifyToRoot();
        this.repaint();
        return sGPropertyResults;
    }

    protected SGPropertyResults setProperties(SGPropertyMap sGPropertyMap, SGPropertyResults sGPropertyResults) {
        SGPropertyResults sGPropertyResults2 = (SGPropertyResults)sGPropertyResults.clone();
        Iterator<String> iterator = sGPropertyMap.getKeyIterator();
        while (iterator.hasNext()) {
            Number number;
            Serializable serializable;
            String string = iterator.next();
            String string2 = sGPropertyMap.getValueString(string);
            if ("X".equalsIgnoreCase(string)) {
                serializable = new StringBuffer();
                number = SGUtilityText.getNumber(string2, (StringBuffer)serializable);
                if (number == null) {
                    sGPropertyResults2.putResult("X", 1);
                    continue;
                }
                if (!this.setFigureX(number.floatValue(), ((StringBuffer)serializable).toString())) {
                    sGPropertyResults2.putResult("X", 1);
                    continue;
                }
                sGPropertyResults2.putResult("X", 0);
                continue;
            }
            if ("Y".equalsIgnoreCase(string)) {
                serializable = new StringBuffer();
                number = SGUtilityText.getNumber(string2, (StringBuffer)serializable);
                if (number == null) {
                    sGPropertyResults2.putResult("Y", 1);
                    continue;
                }
                if (!this.setFigureY(number.floatValue(), ((StringBuffer)serializable).toString())) {
                    sGPropertyResults2.putResult("Y", 1);
                    continue;
                }
                sGPropertyResults2.putResult("Y", 0);
                continue;
            }
            if ("Width".equalsIgnoreCase(string)) {
                serializable = new StringBuffer();
                number = SGUtilityText.getNumber(string2, (StringBuffer)serializable);
                if (number == null) {
                    sGPropertyResults2.putResult("Width", 1);
                    continue;
                }
                if (!this.setFigureWidth(number.floatValue(), ((StringBuffer)serializable).toString())) {
                    sGPropertyResults2.putResult("Width", 1);
                    continue;
                }
                sGPropertyResults2.putResult("Width", 0);
                continue;
            }
            if ("Height".equalsIgnoreCase(string)) {
                serializable = new StringBuffer();
                number = SGUtilityText.getNumber(string2, (StringBuffer)serializable);
                if (number == null) {
                    sGPropertyResults2.putResult("Height", 1);
                    continue;
                }
                if (!this.setFigureHeight(number.floatValue(), ((StringBuffer)serializable).toString())) {
                    sGPropertyResults2.putResult("Height", 1);
                    continue;
                }
                sGPropertyResults2.putResult("Height", 0);
                continue;
            }
            if ("SpaceToScale".equalsIgnoreCase(string)) {
                serializable = new StringBuffer();
                number = SGUtilityText.getNumber(string2, (StringBuffer)serializable);
                if (number == null) {
                    sGPropertyResults2.putResult("SpaceToScale", 1);
                    continue;
                }
                if (!this.setSpaceAxisLineAndNumber(number.floatValue(), ((StringBuffer)serializable).toString())) {
                    sGPropertyResults2.putResult("SpaceToScale", 1);
                    continue;
                }
                sGPropertyResults2.putResult("SpaceToScale", 0);
                continue;
            }
            if ("SpaceToTitle".equalsIgnoreCase(string)) {
                serializable = new StringBuffer();
                number = SGUtilityText.getNumber(string2, (StringBuffer)serializable);
                if (number == null) {
                    sGPropertyResults2.putResult("SpaceToTitle", 1);
                    continue;
                }
                if (!this.setSpaceNumberAndTitle(number.floatValue(), ((StringBuffer)serializable).toString())) {
                    sGPropertyResults2.putResult("SpaceToTitle", 1);
                    continue;
                }
                sGPropertyResults2.putResult("SpaceToTitle", 0);
                continue;
            }
            if ("BackgroundColor".equalsIgnoreCase(string)) {
                serializable = SGUtilityText.getColor(string2);
                if (serializable != null) {
                    if (!this.setBackgroundColor((Color)serializable)) {
                        sGPropertyResults2.putResult("BackgroundColor", 1);
                        continue;
                    }
                } else {
                    serializable = SGUtilityText.parseColor(string2);
                    if (serializable == null) {
                        sGPropertyResults2.putResult("BackgroundColor", 1);
                        continue;
                    }
                    if (!this.setBackgroundColor((Color)serializable)) {
                        sGPropertyResults2.putResult("BackgroundColor", 1);
                        continue;
                    }
                }
                sGPropertyResults2.putResult("BackgroundColor", 0);
                continue;
            }
            if (!"BackgroundTransparent".equalsIgnoreCase(string)) continue;
            serializable = SGUtilityText.getBoolean(string2);
            if (serializable == null) {
                sGPropertyResults2.putResult("BackgroundTransparent", 1);
                continue;
            }
            if (!this.setTransparent((Boolean)serializable)) {
                sGPropertyResults2.putResult("BackgroundTransparent", 1);
                continue;
            }
            sGPropertyResults2.putResult("BackgroundTransparent", 0);
        }
        return sGPropertyResults2;
    }

    public boolean closeTextField() {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].closeTextField()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDisposed() {
        return this.mDisposed;
    }

    public static class FigureProperties
    extends SGProperties {
        private float mX;
        private float mY;
        private float mWidth;
        private float mHeight;
        private float mSpaceLineAndNumber;
        private float mSpaceNumberAndTitle;
        private Color mBackgroundColor;
        private boolean mTransparentFlag;
        private boolean mLegendVisibleFlag;
        private boolean mColorBarVisibleFlag;

        public void dispose() {
            super.dispose();
            this.mBackgroundColor = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof FigureProperties)) {
                return false;
            }
            FigureProperties figureProperties = (FigureProperties)object;
            if (figureProperties.mX != this.mX) {
                return false;
            }
            if (figureProperties.mY != this.mY) {
                return false;
            }
            if (figureProperties.mWidth != this.mWidth) {
                return false;
            }
            if (figureProperties.mHeight != this.mHeight) {
                return false;
            }
            if (figureProperties.mSpaceLineAndNumber != this.mSpaceLineAndNumber) {
                return false;
            }
            if (figureProperties.mSpaceNumberAndTitle != this.mSpaceNumberAndTitle) {
                return false;
            }
            if (!figureProperties.mBackgroundColor.equals(this.mBackgroundColor)) {
                return false;
            }
            if (figureProperties.mTransparentFlag != this.mTransparentFlag) {
                return false;
            }
            if (figureProperties.mLegendVisibleFlag != this.mLegendVisibleFlag) {
                return false;
            }
            return figureProperties.mColorBarVisibleFlag == this.mColorBarVisibleFlag;
        }

        public void setX(float f) {
            this.mX = f;
        }

        public void setY(float f) {
            this.mY = f;
        }

        public void setWidth(float f) {
            this.mWidth = f;
        }

        public void setHeight(float f) {
            this.mHeight = f;
        }

        public void setSpaceLineAndNumber(float f) {
            this.mSpaceLineAndNumber = f;
        }

        public void setSpaceNumberAndTitle(float f) {
            this.mSpaceNumberAndTitle = f;
        }

        public void setBackgroundColor(Color color) {
            this.mBackgroundColor = color;
        }

        public void setTransparent(boolean bl) {
            this.mTransparentFlag = bl;
        }

        public void setLegendVisible(boolean bl) {
            this.mLegendVisibleFlag = bl;
        }

        public float getX() {
            return this.mX;
        }

        public float getY() {
            return this.mY;
        }

        public float getWidth() {
            return this.mWidth;
        }

        public float getHeight() {
            return this.mHeight;
        }

        public float getSpaceLineAndNumber() {
            return this.mSpaceLineAndNumber;
        }

        public float getSpaceNumberAndTitle() {
            return this.mSpaceNumberAndTitle;
        }

        public Color getBackgroundColor() {
            return this.mBackgroundColor;
        }

        public boolean isTransparent() {
            return this.mTransparentFlag;
        }

        public boolean isLegendVisible() {
            return this.mLegendVisibleFlag;
        }
    }
}

