/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.print.attribute.standard.MediaSize;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jp.riken.brain.ni.samuraigraph.base.SGClientPanel;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIImageExportManager;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGIProgressControl;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGIRootObject;
import jp.riken.brain.ni.samuraigraph.base.SGIRootObjectConstants;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGIWindowDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGImage;
import jp.riken.brain.ni.samuraigraph.base.SGMenuBar;
import jp.riken.brain.ni.samuraigraph.base.SGPluginsQueryMessage;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyMap;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyResults;
import jp.riken.brain.ni.samuraigraph.base.SGStatusBar;
import jp.riken.brain.ni.samuraigraph.base.SGToolBar;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUndoManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.base.SGWindowDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGDrawingWindow
extends JFrame
implements ComponentListener,
PropertyChangeListener,
MenuListener,
ActionListener,
SGIDisposable,
SGIUndoable,
SGINode,
SGIRootObject,
SGIWindowDialogObserver,
SGIProgressControl {
    private static final long serialVersionUID = -7587763518020468378L;
    private int mID;
    private float mMagnification = 1.0f;
    private boolean mAutoZoomFlag = false;
    private SGClientPanel mClientPanel;
    private SGWindowDialog mPropertyDialog = null;
    private SGIImageExportManager mImageExportManager;
    private final SGTuple2f mTemporaryViewportSize = new SGTuple2f();
    private SGToolBar mToolBar;
    private SGStatusBar mStatusBar;
    private boolean mLockFigureFlag = false;
    private int mMode = 1;
    private SGProperties mTemporaryProperties = null;
    private final SGTuple2f mPaperOrigin = new SGTuple2f();
    private Rectangle2D mClientRect = null;
    private List<SGFigure> mCopiedFiguresList = new ArrayList<SGFigure>();
    private List<SGICopiable> mCopiedObjectsList = new ArrayList<SGICopiable>();
    private List<SGData> mCopiedDataObjectsList = new ArrayList<SGData>();
    private List<String> mCopiedDataNameList = new ArrayList<String>();
    private List<Map<Class, SGProperties>> mCopiedDataPropertiesMapList = new ArrayList<Map<Class, SGProperties>>();
    private BackgroundImage mBackgroundImage = null;
    private boolean mDisposed = false;
    private static final String[] IMAGE_FILENAMES_ARRAY = new String[]{"Samurai.gif"};
    private final List<SGFigure> mFigureList = new ArrayList<SGFigure>();
    public static final float PAPER_MARGIN = 56.692917f;
    protected final Point mTempMouseLocation = new Point();
    protected Point mMousePressLocation = null;
    private ArrayList mActionListenerList = new ArrayList();
    private Map mInsertFlagMap;
    private ArrayList mPasteTargetList = new ArrayList();
    private final Rectangle2D mTempPaperRect = new Rectangle2D.Float();
    private static final float BOUNDING_BOX_MARGIN;
    private SGUndoManager mUndoManager = new SGUndoManager(this);
    private SGMenuBar mMenuBar = null;
    private InfoForExport mExportInfo = null;
    private ExportPanel mExportTarget = null;
    private int mPropertyFileCreationModeOfFigures;
    private boolean mModalDialogShownFlag = false;
    private int mSavedListIndex = -1;

    public SGDrawingWindow() {
        this.create();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SGDrawingWindow.this.mPropertyDialog = new SGWindowDialog((Frame)SGDrawingWindow.this, true);
            }
        });
    }

    @Override
    public void dispose() {
        Object object;
        int n;
        this.mDisposed = true;
        if (this.mPropertyDialog != null) {
            this.mPropertyDialog.dispose();
            this.mPropertyDialog = null;
        }
        this.removeAllFigures();
        for (n = 0; n < this.mCopiedDataObjectsList.size(); ++n) {
            object = this.mCopiedDataObjectsList.get(n);
            ((SGData)object).dispose();
        }
        for (n = 0; n < this.mCopiedDataPropertiesMapList.size(); ++n) {
            object = this.mCopiedDataPropertiesMapList.get(n);
            object.clear();
        }
        for (n = 0; n < this.mCopiedObjectsList.size(); ++n) {
            object = this.mCopiedObjectsList.get(n);
            if (!(object instanceof SGIDisposable)) continue;
            SGIDisposable sGIDisposable = (SGIDisposable)object;
            sGIDisposable.dispose();
        }
        this.clearCopiedObjectsList();
        if (this.mTemporaryProperties != null) {
            this.mTemporaryProperties.dispose();
        }
        this.mTemporaryProperties = null;
        this.mClientRect = null;
        this.mBackgroundImage = null;
        super.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.mDisposed;
    }

    @Override
    public String toString() {
        return "SGDrawingWindow:" + this.getID();
    }

    private Map<String, ImageIcon> loadImages() {
        String[] stringArray = IMAGE_FILENAMES_ARRAY;
        int n = stringArray.length;
        ImageIcon[] imageIconArray = new ImageIcon[n];
        for (int i = 0; i < n; ++i) {
            imageIconArray[i] = this.createIcon(stringArray[i]);
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        HashMap<String, ImageIcon> hashMap = new HashMap<String, ImageIcon>();
        for (int i = 0; i < n; ++i) {
            hashMap.put(stringArray[i], imageIconArray[i]);
            mediaTracker.addImage(imageIconArray[i].getImage(), i);
        }
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return hashMap;
    }

    private boolean create() {
        Map<String, ImageIcon> map = this.loadImages();
        SwingUtilities.updateComponentTreeUI(this);
        ImageIcon imageIcon = map.get("Samurai.gif");
        this.setIconImage(imageIcon.getImage());
        this.createMenuBar();
        this.createToolBar();
        this.createStatusBar();
        this.createClientPanel();
        this.pack();
        this.initInsertFlagMap();
        this.updateItemsByFigureNumbers();
        this.updateGridItems();
        this.updateUndoItems();
        this.updateFocusedObjectItem();
        this.updateZoomItems();
        this.updateSnapToGridItems();
        this.updateModeMenuItems();
        this.setSaved(false);
        return true;
    }

    public void updateItemsByFigureNumbers() {
        boolean bl = this.getVisibleFigureList().size() != 0;
        SGToolBar sGToolBar = this.mToolBar;
        sGToolBar.setButtonEnabled("Export as Image", bl);
        sGToolBar.setButtonEnabled("Save Property", bl);
        sGToolBar.setButtonEnabled("Print", bl);
        sGToolBar.setButtonEnabled("Bounding Box", bl);
        sGToolBar.setInsertToggleButtonsEnabled(bl);
        SGMenuBar sGMenuBar = this.mMenuBar;
        sGMenuBar.setMenuItemEnabled("File", "Export as Image", bl);
        sGMenuBar.setMenuItemEnabled("File", "Save Property", bl);
        sGMenuBar.setMenuItemEnabled("File", "Save Data Set", bl);
        sGMenuBar.setMenuItemEnabled("File", "Print", bl);
        sGMenuBar.setMenuItemEnabled("Layout", "Bounding Box", bl);
        sGMenuBar.setMenuItemEnabled("Layout", "Snap to Grid", bl);
        sGMenuBar.setMenuItemEnabled("Arrange", "Auto Arrangement", bl);
        sGMenuBar.setInsertToggleButtonsEnabled(bl);
    }

    private void updateInsertItems() {
        String[] stringArray = INSERT_MENUBARCMD_ARRAY;
        for (int i = 0; i < stringArray.length; ++i) {
            this.updateInsertItems(stringArray[i]);
        }
    }

    private void updateInsertItems(String string) {
        SGToolBar sGToolBar;
        boolean bl = this.getInsertFlag(string);
        SGMenuBar sGMenuBar = this.mMenuBar;
        if (sGMenuBar.hasMenuItem(string)) {
            sGMenuBar.setInsertToggleItemSelected(string, bl);
        }
        if ((sGToolBar = this.mToolBar).hasButton(string)) {
            sGToolBar.setInsertTogglebuttonSelected(string, bl);
        }
    }

    public boolean init() {
        float f = 566.92914f;
        float f2 = f / SGIConstants.GOLDEN_RATIO;
        this.setViewportSize(f, f2);
        this.mToolBar.setPreferredSize(new Dimension((int)f, this.mToolBar.getHeight()));
        this.mTemporaryViewportSize.setValues(f, f2);
        this.setComponentBounds();
        this.mClientRect = new Rectangle2D.Float();
        this.setPaperOrigin(0.0f, 0.0f);
        float f3 = SGIRootObjectConstants.DEFAULT_PAPER_WIDTH;
        float f4 = SGIRootObjectConstants.DEFAULT_PAPER_HEIGHT;
        this.mClientPanel.setPaperSizeRoundingOff(f3, f4);
        this.updateClientRect();
        return true;
    }

    public void repaintContentPane() {
        this.getContentPane().repaint();
    }

    private ImageIcon createIcon(String string) {
        URL uRL = this.getClass().getResource("/resources/" + string);
        ImageIcon imageIcon = new ImageIcon(uRL);
        return imageIcon;
    }

    private void createClientPanel() {
        SGClientPanel sGClientPanel = new SGClientPanel(this);
        this.getContentPane().add((Component)sGClientPanel, "Center");
        this.mClientPanel = sGClientPanel;
    }

    private void createStatusBar() {
        SGStatusBar sGStatusBar = new SGStatusBar(this);
        this.getContentPane().add((Component)sGStatusBar, "South");
        this.mStatusBar = sGStatusBar;
    }

    private boolean createToolBar() {
        SGToolBar sGToolBar;
        this.mToolBar = sGToolBar = new SGToolBar();
        sGToolBar.setRoot(this);
        sGToolBar.addActionListener(this);
        sGToolBar.addPropertyChangeListener(this);
        this.addComponentListener(sGToolBar);
        sGToolBar.addComponentListener(this);
        this.addComponentListener(this);
        this.setToolBar();
        return true;
    }

    private boolean setToolBar() {
        this.getContentPane().remove(this.mToolBar);
        int n = this.mToolBar.getOrientation();
        if (n == 0) {
            this.getContentPane().add((Component)this.mToolBar, "North");
        } else if (n == 1) {
            this.getContentPane().add((Component)this.mToolBar, "West");
        }
        this.validate();
        return true;
    }

    private int getToolBarHeight() {
        int n = 0;
        if (this.mToolBar.isVisible()) {
            n = this.mToolBar.getHeight();
        }
        return n;
    }

    private int getToolBarWidth() {
        int n = 0;
        if (this.mToolBar.isVisible()) {
            n = this.mToolBar.getWidth();
        }
        return n;
    }

    public String[] getToolBarPattern() {
        String[] stringArray = this.mToolBar.getToolBarPattern();
        return stringArray;
    }

    public void setToolBarPattern(String[] stringArray) {
        this.mToolBar.setToolBarPattern(stringArray);
        this.updateToolBarVisibleMenuItems();
        this.updateToolBarVisibleItems();
    }

    public int getID() {
        return this.mID;
    }

    public boolean setID(int n) {
        this.mID = n;
        return true;
    }

    public int assignFigureId() {
        int n;
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n = 0; n < arrayList.size(); ++n) {
            SGFigure sGFigure = (SGFigure)arrayList.get(n);
            arrayList2.add(sGFigure.getID());
        }
        n = SGUtility.assignIdNumber(arrayList2);
        return n;
    }

    public int getTopWidth() {
        Insets insets = this.getInsets();
        int n = insets.top;
        JMenuBar jMenuBar = this.getJMenuBar();
        int n2 = jMenuBar.getHeight();
        int n3 = 0;
        if (this.mToolBar.getOrientation() == 0) {
            n3 = this.getToolBarHeight();
        }
        int n4 = n + n2 + n3;
        return n4;
    }

    public int getBottomWidth() {
        Insets insets = this.getInsets();
        int n = insets.bottom;
        return n;
    }

    public int getLeftWidth() {
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = 0;
        if (this.mToolBar.getOrientation() == 1) {
            n2 = this.getToolBarWidth();
        }
        return n + n2;
    }

    public int getRightWidth() {
        Insets insets = this.getInsets();
        int n = insets.right;
        return n;
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public float getMagnificationPercent() {
        return this.mMagnification * 100.0f;
    }

    public void setImageFileCreator(SGIImageExportManager sGIImageExportManager) {
        this.mImageExportManager = sGIImageExportManager;
    }

    public SGFigure getFigure(int n) {
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (sGFigure.getID() != n) continue;
            return sGFigure;
        }
        return null;
    }

    public ArrayList<SGFigure> getFigureList() {
        return new ArrayList<SGFigure>(this.mFigureList);
    }

    public SGFigure[] getFigureArray() {
        return this.getFigureList().toArray(new SGFigure[0]);
    }

    public ArrayList<SGFigure> getVisibleFigureList() {
        ArrayList<SGFigure> arrayList = new ArrayList<SGFigure>();
        for (int i = 0; i < this.mFigureList.size(); ++i) {
            SGFigure sGFigure = this.mFigureList.get(i);
            if (!sGFigure.isVisible()) continue;
            arrayList.add(sGFigure);
        }
        return arrayList;
    }

    public int[] getVisibleFigureIDArray() {
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            arrayList2.add(sGFigure.getID());
        }
        int[] nArray = new int[arrayList2.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList2.get(i);
        }
        Arrays.sort(nArray);
        return nArray;
    }

    private boolean hideFigure(SGFigure sGFigure) {
        sGFigure.setVisible(false);
        sGFigure.setChanged(true);
        return true;
    }

    public void removeAllFigures() {
        for (int i = 0; i < this.mFigureList.size(); ++i) {
            SGFigure sGFigure = this.mFigureList.get(i);
            sGFigure.dispose();
        }
        this.mFigureList.clear();
        this.updateClientRect();
    }

    public boolean addFigure(SGFigure sGFigure, Point point) {
        if (!this.addFigure(sGFigure)) {
            return false;
        }
        if (point != null) {
            Point2D point2D = this.getLocationInPane(point.x, point.y);
            sGFigure.setGraphRectLocation((float)point2D.getX(), (float)point2D.getY());
        }
        sGFigure.snapToLines(0);
        sGFigure.setGraphRectOnDragging();
        return true;
    }

    public boolean addFigure(SGFigure sGFigure) {
        this.mFigureList.add(sGFigure);
        sGFigure.setViewBounds();
        sGFigure.setMagnification(this.getMagnification());
        this.updateItemsByFigureNumbers();
        return true;
    }

    public boolean needsConfirmationBeforeDiscard() {
        return this.getVisibleFigureList().size() != 0 && !this.isSaved();
    }

    private boolean setImage(Image image, boolean bl) {
        boolean bl2 = false;
        if (bl) {
            if (image != null) {
                if (!image.equals(this.getImage())) {
                    bl2 = true;
                }
            } else if (this.getImage() != null) {
                bl2 = true;
            }
        }
        if (!this.mClientPanel.setImage(image)) {
            return false;
        }
        if (bl) {
            this.updateBackgroundImageItems();
            this.setChanged(bl2);
            this.notifyToRoot();
        }
        this.repaintContentPane();
        return true;
    }

    private void setMediaTracker(Image image) {
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean setImage(byte[] byArray, String string, boolean bl) {
        if (byArray == null || string == null) {
            throw new IllegalArgumentException("b == null || ext == null");
        }
        Image image = Toolkit.getDefaultToolkit().createImage(byArray);
        this.setMediaTracker(image);
        if (image == null) {
            return false;
        }
        if (!this.setImage(image, bl)) {
            return false;
        }
        this.mBackgroundImage = new BackgroundImage(string, byArray);
        return true;
    }

    public boolean deleteImage() {
        this.mBackgroundImage = null;
        return this.setImage(null, true);
    }

    public boolean setImageLocation(int n, int n2) {
        return this.mClientPanel.setImageLocation(n, n2);
    }

    public boolean setImageSize(int n, int n2) {
        return this.mClientPanel.setImageSize(n, n2);
    }

    public Image getImage() {
        return this.mClientPanel.getImage();
    }

    public boolean drawBackAllVisibleFigures() {
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = arrayList.get(i);
            if (sGFigure.drawbackFigure()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ArrayList getChildNodes() {
        return this.getVisibleFigureList();
    }

    public boolean clearFocusedObjects() {
        List<SGISelectable> list = this.getFocusedObjectsList();
        for (int i = 0; i < list.size(); ++i) {
            SGISelectable sGISelectable = list.get(i);
            sGISelectable.setSelected(false);
        }
        return true;
    }

    public List<SGISelectable> getFocusedObjectsList() {
        ArrayList<SGISelectable> arrayList = new ArrayList<SGISelectable>();
        arrayList.addAll(this.getFocusedFigureList());
        return arrayList;
    }

    public List<SGFigure> getFocusedFigureList() {
        ArrayList<SGFigure> arrayList = new ArrayList<SGFigure>();
        ArrayList<SGFigure> arrayList2 = this.getVisibleFigureList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList2.get(i);
            if (!sGFigure.isSelected()) continue;
            arrayList.add(sGFigure);
        }
        return arrayList;
    }

    public boolean getFocusedObjectsList(List<SGISelectable> list) {
        list.addAll(this.getFocusedFigureList());
        return true;
    }

    public List<SGFigure> getCopiedFiguresList() {
        return new ArrayList<SGFigure>(this.mCopiedFiguresList);
    }

    public boolean hideSelectedObjects() {
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = arrayList.get(i);
            if (sGFigure.isSelected()) {
                this.hideFigure(sGFigure);
                continue;
            }
            if (sGFigure.hideSelectedObjects()) continue;
            return false;
        }
        if (arrayList.size() != 0) {
            this.setChanged(true);
            this.clearFocusedObjects();
            this.updateItemsByFigureNumbers();
        }
        return true;
    }

    protected void setSelectionSymbolsVisible(boolean bl) {
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = arrayList.get(i);
            sGFigure.setSelectionSymbolsVisible(bl);
        }
    }

    protected void setSymbolsAroundAllObjectsVisible(boolean bl) {
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = arrayList.get(i);
            sGFigure.setSymbolsAroundAllObjectsVisible(bl);
        }
    }

    public boolean clearAllFocusedObjectsInFigures() {
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = arrayList.get(i);
            if (sGFigure.clearFocusedObjects()) continue;
            return false;
        }
        return this.clearFocusedFigures();
    }

    public boolean clearFocusedFigures() {
        List<SGFigure> list = this.getFocusedFigureList();
        for (int i = list.size() - 1; i >= 0; --i) {
            SGFigure sGFigure = list.get(i);
            this.setFocusedFigure(sGFigure, false);
        }
        return true;
    }

    public boolean setFocusedFigure(SGFigure sGFigure, boolean bl) {
        sGFigure.setSelected(bl);
        sGFigure.setSymbolsAroundAllObjectsVisible(bl);
        return true;
    }

    public SGTuple2f getViewportSize() {
        SGTuple2f sGTuple2f = this.getPaneSize();
        int n = this.mClientPanel.getRulerWidth();
        sGTuple2f.x -= (float)n;
        sGTuple2f.y -= (float)n;
        return sGTuple2f;
    }

    public SGTuple2f getPaneOrigin() {
        Rectangle2D rectangle2D = this.getPaneBounds();
        SGTuple2f sGTuple2f = new SGTuple2f((float)rectangle2D.getX(), (float)rectangle2D.getY());
        return sGTuple2f;
    }

    public SGTuple2f getPaneSize() {
        Rectangle2D rectangle2D = this.getPaneBounds();
        SGTuple2f sGTuple2f = new SGTuple2f((float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
        return sGTuple2f;
    }

    public Rectangle2D getPaneBounds() {
        Insets insets = this.getInsets();
        int n = insets.top;
        int n2 = insets.bottom;
        int n3 = insets.left;
        int n4 = insets.right;
        JMenuBar jMenuBar = this.getJMenuBar();
        int n5 = jMenuBar.getHeight();
        int n6 = this.getToolBarHeight();
        int n7 = this.mStatusBar.getHeight();
        float f = this.getWidth() - (n3 + n4);
        float f2 = this.getHeight() - (n + n2 + n5 + n6 + n7);
        float f3 = n3;
        float f4 = n + n5 + n6;
        Rectangle2D.Float float_ = new Rectangle2D.Float(f3, f4, f, f2);
        return float_;
    }

    public boolean setPaperSize(float f, float f2) {
        return this.mClientPanel.setPaperSize(f, f2);
    }

    public JComponent getFigurePanel() {
        return this.mClientPanel.getFigurePanel();
    }

    public float getGridLineInterval() {
        return this.mClientPanel.getGridLineInterval();
    }

    public boolean setPaperOrigin(float f, float f2) {
        Rectangle2D rectangle2D = this.getClientRect();
        float f3 = this.mMagnification;
        float f4 = (f - (float)rectangle2D.getX()) / f3;
        float f5 = (f2 - (float)rectangle2D.getY()) / f3;
        this.mPaperOrigin.setValues(f4, f5);
        return true;
    }

    public SGTuple2f getPaperSize() {
        return new SGTuple2f(this.mClientPanel.getPaperWidth(), this.mClientPanel.getPaperHeight());
    }

    public float getPaperX() {
        Rectangle2D rectangle2D = this.getClientRect();
        return (float)rectangle2D.getX() + this.mMagnification * this.mPaperOrigin.x;
    }

    public float getPaperY() {
        Rectangle2D rectangle2D = this.getClientRect();
        return (float)rectangle2D.getY() + this.mMagnification * this.mPaperOrigin.y;
    }

    public Rectangle2D getPaperRect() {
        float f = this.getMagnification();
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.getPaperX(), this.getPaperY(), f * this.mClientPanel.getPaperWidth(), f * this.mClientPanel.getPaperHeight());
        return float_;
    }

    public Rectangle2D getBoundingBox() {
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        float f = this.mMagnification * 56.692917f;
        Rectangle2D rectangle2D = this.getPaperRect();
        ((Rectangle2D)float_).setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + (double)f, rectangle2D.getHeight() + (double)f);
        return float_;
    }

    public boolean setViewportSize(float f, float f2) {
        this.mTemporaryViewportSize.setValues(f, f2);
        Insets insets = this.getInsets();
        int n = insets.top;
        int n2 = insets.bottom;
        int n3 = insets.left;
        int n4 = insets.right;
        JMenuBar jMenuBar = this.getJMenuBar();
        int n5 = jMenuBar.getHeight();
        int n6 = this.getToolBarHeight();
        int n7 = this.mClientPanel.getRulerWidth();
        float f3 = f + (float)n3 + (float)n4 + (float)n7;
        float f4 = f2 + (float)n + (float)n2 + (float)n5 + (float)n6 + (float)n7 + (float)this.mStatusBar.getHeight();
        this.setSize((int)f3, (int)f4);
        return true;
    }

    protected boolean setComponentBounds() {
        Rectangle2D rectangle2D = this.getPaneBounds();
        int n = (int)rectangle2D.getWidth();
        int n2 = (int)rectangle2D.getHeight();
        this.mClientPanel.setSize(n, n2);
        this.validate();
        return true;
    }

    private boolean onResized() {
        if (this.getClientRect() == null) {
            return false;
        }
        this.setComponentBounds();
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f = sGTuple2f.x / this.mTemporaryViewportSize.x;
        float f2 = sGTuple2f.y / this.mTemporaryViewportSize.y;
        this.updateClientRect();
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = arrayList.get(i);
            sGFigure.recordFigureRect();
            sGFigure.setViewBounds();
        }
        if (this.isLocked()) {
            Rectangle2D rectangle2D = this.getPaperRect();
            float f3 = f * (float)rectangle2D.getWidth() / this.mMagnification;
            float f4 = f2 * (float)rectangle2D.getHeight() / this.mMagnification;
            this.mClientPanel.setPaperSizeRoundingOff(f3, f4);
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = arrayList.get(i);
                sGFigure.recordFigureRect();
                sGFigure.resize(f, f2);
                sGFigure.setChanged(true);
            }
            this.updateClientRect();
            if (!this.mTemporaryViewportSize.equals(sGTuple2f)) {
                this.setChanged(true);
                this.notifyToRoot();
            }
        }
        this.mTemporaryViewportSize.setValues(sGTuple2f);
        this.doAutoZoom();
        return true;
    }

    @Override
    public boolean zoom(float f) {
        this.mMagnification = f;
        SGFigure[] sGFigureArray = this.getFigureArray();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            if (sGFigureArray[i].setMagnification(f)) continue;
            throw new Error();
        }
        this.mClientPanel.setMagnification(f);
        this.updateClientRect();
        this.repaintContentPane();
        return true;
    }

    @Override
    public void setAutoZoom(boolean bl) {
        this.mAutoZoomFlag = bl;
        this.mMenuBar.setMenuItemSelected("Layout", "Auto Zoom", bl);
        this.doAutoZoom();
    }

    public boolean isAutoZoom() {
        return this.mAutoZoomFlag;
    }

    private void doAutoZoom() {
        if (this.isAutoZoom()) {
            this.zoomWayOut();
        }
        this.updateZoomItems();
    }

    private boolean zoomWayOut() {
        float f;
        Rectangle2D rectangle2D = this.getBoundingBox();
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f2 = (float)((double)sGTuple2f.x / (rectangle2D.getWidth() / (double)this.mMagnification));
        float f3 = f2 < (f = (float)((double)sGTuple2f.y / (rectangle2D.getHeight() / (double)this.mMagnification))) ? f2 : f;
        int n = (int)Math.floor(f3 * 100.0f);
        this.setZoomValue(n);
        return true;
    }

    public boolean setZoomValue(Number number) {
        this.mToolBar.setZoomValue(number);
        this.zoom(number.floatValue() / 100.0f);
        this.updateZoomItems();
        return true;
    }

    private boolean setDefaultZoom() {
        return this.setZoomValue(100);
    }

    public boolean setFigureBoundingBox(int n) {
        Object object;
        if (n != 0 && n != 1 && n != 2) {
            return false;
        }
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        ArrayList<SGFigure> arrayList2 = this.getVisibleFigureList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            object = arrayList2.get(i);
            arrayList.add(((SGFigure)object).getBoundingBox());
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        if (rectangle2D == null) {
            return false;
        }
        object = this.getClientRect();
        Rectangle2D rectangle2D2 = this.getPaperRect();
        float f = (float)rectangle2D2.getWidth();
        float f2 = (float)rectangle2D2.getHeight();
        float f3 = this.mMagnification;
        if (n == 0 || n == 1) {
            f = BOUNDING_BOX_MARGIN + (float)(-((RectangularShape)object).getX() + rectangle2D.getX() + rectangle2D.getWidth()) / f3;
        }
        if (n == 0 || n == 2) {
            f2 = BOUNDING_BOX_MARGIN + (float)(-((RectangularShape)object).getY() + rectangle2D.getY() + rectangle2D.getHeight()) / f3;
        }
        this.mClientPanel.setPaperSizeRoundingOut(f, f2);
        this.updateClientRect();
        return true;
    }

    public Rectangle2D getBoundingBoxOfFigures(List<SGFigure> list) {
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return new Rectangle2D.Float();
        }
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        for (int i = 0; i < list.size(); ++i) {
            SGFigure sGFigure = list.get(i);
            if (sGFigure == null) continue;
            Rectangle2D rectangle2D = sGFigure.getBoundingBox();
            if (rectangle2D == null) {
                return null;
            }
            arrayList.add(rectangle2D);
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        return rectangle2D;
    }

    public Object getComponent(int n, int n2) {
        SGIUndoable sGIUndoable = this;
        SGFigure[] sGFigureArray = this.getFigureArray();
        for (int i = sGFigureArray.length - 1; i >= 0; --i) {
            Point2D point2D;
            Rectangle2D rectangle2D;
            if (!sGFigureArray[i].isVisible() || !(rectangle2D = sGFigureArray[i].getGraphRect()).contains(point2D = this.getLocationInPane(n, n2))) continue;
            sGIUndoable = sGFigureArray[i];
            break;
        }
        return sGIUndoable;
    }

    public SGPropertyResults setProperties(SGPropertyMap sGPropertyMap) {
        SGPropertyResults sGPropertyResults = new SGPropertyResults();
        if (!this.prepare()) {
            return null;
        }
        Iterator<String> iterator = sGPropertyMap.getKeyIterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            String string = iterator.next();
            String string2 = sGPropertyMap.getValueString(string);
            if ("PaperWidth".equalsIgnoreCase(string)) {
                object2 = new StringBuffer();
                object = SGUtilityText.getNumber(string2, (StringBuffer)object2);
                if (object == null) {
                    sGPropertyResults.putResult("PaperWidth", 1);
                    continue;
                }
                if (!this.mClientPanel.setPaperWidth(((Number)object).floatValue(), ((StringBuffer)object2).toString())) {
                    sGPropertyResults.putResult("PaperWidth", 1);
                    continue;
                }
                sGPropertyResults.putResult("PaperWidth", 0);
                continue;
            }
            if ("PaperHeight".equalsIgnoreCase(string)) {
                object2 = new StringBuffer();
                object = SGUtilityText.getNumber(string2, (StringBuffer)object2);
                if (object == null) {
                    sGPropertyResults.putResult("PaperHeight", 1);
                    continue;
                }
                if (!this.mClientPanel.setPaperHeight(((Number)object).floatValue(), ((StringBuffer)object2).toString())) {
                    sGPropertyResults.putResult("PaperHeight", 1);
                    continue;
                }
                sGPropertyResults.putResult("PaperHeight", 0);
                continue;
            }
            if ("PaperSize".equalsIgnoreCase(string)) {
                object2 = SGUtilityText.getStringsInBracket(string2);
                if (object2 == null) {
                    sGPropertyResults.putResult("PaperSize", 1);
                    continue;
                }
                if (((String[])object2).length != 2) {
                    sGPropertyResults.putResult("PaperSize", 1);
                    continue;
                }
                object = object2[0];
                String string3 = object2[1];
                MediaSize mediaSize = SGUtilityText.getMediaSize((String)object);
                if (mediaSize == null) {
                    sGPropertyResults.putResult("PaperSize", 1);
                    continue;
                }
                Boolean bl = SGUtilityText.isPortrait(string3);
                if (bl == null) {
                    sGPropertyResults.putResult("PaperSize", 1);
                    continue;
                }
                if (!this.mClientPanel.setPaperSize(mediaSize, bl)) {
                    sGPropertyResults.putResult("PaperSize", 1);
                    continue;
                }
                sGPropertyResults.putResult("PaperSize", 0);
                continue;
            }
            if ("BackgroundColor".equalsIgnoreCase(string)) {
                object2 = SGUtilityText.getColor(string2);
                if (object2 != null) {
                    if (!this.mClientPanel.setPaperColor((Color)object2)) {
                        sGPropertyResults.putResult("BackgroundColor", 1);
                        continue;
                    }
                } else {
                    object2 = SGUtilityText.parseColor(string2);
                    if (object2 == null) {
                        sGPropertyResults.putResult("BackgroundColor", 1);
                        continue;
                    }
                    if (!this.mClientPanel.setPaperColor((Color)object2)) {
                        sGPropertyResults.putResult("BackgroundColor", 1);
                        continue;
                    }
                }
                sGPropertyResults.putResult("BackgroundColor", 0);
                continue;
            }
            if ("GridVisible".equalsIgnoreCase(string)) {
                object2 = SGUtilityText.getBoolean(string2);
                if (object2 == null) {
                    sGPropertyResults.putResult("GridVisible", 1);
                    continue;
                }
                if (!this.mClientPanel.setGridLineVisible((Boolean)object2)) {
                    sGPropertyResults.putResult("GridVisible", 1);
                    continue;
                }
                sGPropertyResults.putResult("GridVisible", 0);
                continue;
            }
            if ("GridInterval".equalsIgnoreCase(string)) {
                object2 = new StringBuffer();
                object = SGUtilityText.getNumber(string2, (StringBuffer)object2);
                if (object == null) {
                    sGPropertyResults.putResult("GridInterval", 1);
                    continue;
                }
                if (!this.mClientPanel.setGridLineInterval(((Number)object).floatValue(), ((StringBuffer)object2).toString())) {
                    sGPropertyResults.putResult("GridInterval", 1);
                    continue;
                }
                sGPropertyResults.putResult("GridInterval", 0);
                continue;
            }
            if ("GridLineWidth".equalsIgnoreCase(string)) {
                object2 = new StringBuffer();
                object = SGUtilityText.getNumber(string2, (StringBuffer)object2);
                if (object == null) {
                    sGPropertyResults.putResult("GridLineWidth", 1);
                    continue;
                }
                if (!this.mClientPanel.setGridLineWidth(((Number)object).floatValue(), ((StringBuffer)object2).toString())) {
                    sGPropertyResults.putResult("GridLineWidth", 1);
                    continue;
                }
                sGPropertyResults.putResult("GridLineWidth", 0);
                continue;
            }
            if ("GridColor".equalsIgnoreCase(string)) {
                object2 = SGUtilityText.getColor(string2);
                if (object2 != null) {
                    if (!this.mClientPanel.setGridLineColor((Color)object2)) {
                        sGPropertyResults.putResult("GridColor", 1);
                        continue;
                    }
                } else {
                    object2 = SGUtilityText.parseColor(string2);
                    if (object2 == null) {
                        sGPropertyResults.putResult("GridColor", 1);
                        continue;
                    }
                    if (!this.mClientPanel.setGridLineColor((Color)object2)) {
                        sGPropertyResults.putResult("GridColor", 1);
                        continue;
                    }
                }
                sGPropertyResults.putResult("GridColor", 0);
                continue;
            }
            if ("ImageX".equalsIgnoreCase(string)) {
                object2 = new StringBuffer();
                object = SGUtilityText.getNumber(string2, (StringBuffer)object2);
                if (object == null) {
                    sGPropertyResults.putResult("ImageX", 1);
                    continue;
                }
                if (!this.mClientPanel.setImageLocationX(((Number)object).floatValue(), ((StringBuffer)object2).toString())) {
                    sGPropertyResults.putResult("ImageX", 1);
                    continue;
                }
                sGPropertyResults.putResult("ImageX", 0);
                continue;
            }
            if ("ImageY".equalsIgnoreCase(string)) {
                object2 = new StringBuffer();
                object = SGUtilityText.getNumber(string2, (StringBuffer)object2);
                if (object == null) {
                    sGPropertyResults.putResult("ImageY", 1);
                    continue;
                }
                if (!this.mClientPanel.setImageLocationY(((Number)object).floatValue(), ((StringBuffer)object2).toString())) {
                    sGPropertyResults.putResult("ImageY", 1);
                    continue;
                }
                sGPropertyResults.putResult("ImageY", 0);
                continue;
            }
            if (!"ImageScalingFactor".equalsIgnoreCase(string)) continue;
            object2 = SGUtilityText.getFloat(string2);
            if (object2 == null) {
                sGPropertyResults.putResult("ImageScalingFactor", 1);
                continue;
            }
            if (!SGUtility.isValidPropertyValue(((Number)object2).floatValue())) {
                sGPropertyResults.putResult("ImageScalingFactor", 1);
                continue;
            }
            if (!this.mClientPanel.setImageScalingFactor(((Number)object2).floatValue())) {
                sGPropertyResults.putResult("ImageScalingFactor", 1);
                continue;
            }
            sGPropertyResults.putResult("ImageScalingFactor", 0);
        }
        if (!this.commit()) {
            return null;
        }
        this.notifyToRoot();
        this.repaintContentPane();
        return sGPropertyResults;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        this.onResized();
        if (object.equals(this.mToolBar)) {
            this.updateToolBarVisibleMenuItems();
            this.firePropertyChange("Tool Bar", null, null);
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        Object object;
        Object object2 = menuEvent.getSource();
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (SGFigure)arrayList.get(i);
            ((SGFigure)object).onMenuSelected();
        }
        JMenu jMenu = (JMenu)object2;
        object = jMenu.getText();
        if ("Properties".equals(object)) {
            this.createPropertyMenuBarItem();
        }
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.onResized();
    }

    boolean showPropertyDialog() {
        SGWindowDialog sGWindowDialog = (SGWindowDialog)this.getPropertyDialog();
        String string = "Window Properties : " + this.getID();
        sGWindowDialog.setTitle(string);
        this.prepare();
        ArrayList<SGIPropertyDialogObserver> arrayList = new ArrayList<SGIPropertyDialogObserver>();
        arrayList.add(this);
        this.showPropertyDialog((SGPropertyDialog)sGWindowDialog, arrayList);
        return true;
    }

    protected boolean insertSymbol(SGFigure sGFigure, int n, int n2) {
        boolean bl = false;
        if (this.getLabelInsertionFlag()) {
            bl = sGFigure.addString(n, n2);
        }
        if (this.getTimingLineInsertionFlag()) {
            bl = sGFigure.addTimingLine(n, n2);
        }
        if (this.getAxisBreakSymbolInsertionFlag()) {
            bl = sGFigure.addAxisBreakSymbol(n, n2);
        }
        if (this.getSignificantDifferenceSymbolInsertionFlag()) {
            bl = sGFigure.addSignificantDifferenceSymbol(n, n2);
        }
        if (this.getRectangleInsertionFlag()) {
            bl = sGFigure.addShape(0, n, n2);
        }
        if (this.getEllipseInsertionFlag()) {
            bl = sGFigure.addShape(1, n, n2);
        }
        if (this.getArrowInsertionFlag()) {
            bl = sGFigure.addShape(2, n, n2);
        }
        if (this.getLineInsertionFlag()) {
            bl = sGFigure.addShape(3, n, n2);
        }
        return bl;
    }

    void clearFocusedFiguresOtherThan(SGFigure sGFigure) {
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure2 = arrayList.get(i);
            if (sGFigure2.equals(sGFigure)) continue;
            sGFigure2.setSelected(false);
        }
    }

    public boolean translateFocusedObjects(int n, int n2) {
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = arrayList.get(i);
            if (sGFigure.isSelected()) {
                sGFigure.translate(n, n2);
                continue;
            }
            sGFigure.translateSelectedObjects(n, n2);
        }
        return true;
    }

    protected boolean moveFocusedObjects(int n, int n2) {
        int n3 = n - this.mTempMouseLocation.x;
        int n4 = n2 - this.mTempMouseLocation.y;
        this.translateFocusedObjects(n3, n4);
        this.mTempMouseLocation.setLocation(this.mTempMouseLocation.x + n3, this.mTempMouseLocation.y + n4);
        return true;
    }

    private Point2D getLocationInPane(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        Insets insets = this.getInsets();
        int n5 = insets.top;
        int n6 = insets.left;
        n3 -= n6;
        n4 -= n5;
        JMenuBar jMenuBar = this.getJMenuBar();
        double d = jMenuBar.getHeight();
        n4 = (int)((double)n4 - d);
        n4 -= this.getToolBarHeight();
        double d2 = this.mClientPanel.getRulerWidth();
        n3 = (int)((double)n3 - d2);
        n4 = (int)((double)n4 - d2);
        return new Point2D.Float(n3, n4);
    }

    public boolean setPositionLabel(int n, int n2) {
        Rectangle2D rectangle2D = this.getClientRect();
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = 0.035277776f / this.mMagnification;
        float f4 = (-f + (float)n) * f3;
        float f5 = (-f2 + (float)n2) * f3;
        this.mStatusBar.drawPosition(f4, f5);
        return true;
    }

    public void addActionListener(ActionListener actionListener) {
        ArrayList arrayList = this.mActionListenerList;
        for (int i = 0; i < arrayList.size(); ++i) {
            ActionListener actionListener2 = (ActionListener)arrayList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            return;
        }
        arrayList.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        ArrayList arrayList = this.mActionListenerList;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            ActionListener actionListener2 = (ActionListener)arrayList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            this.mActionListenerList.remove(actionListener);
        }
    }

    public void notifyToListener(String string) {
        ArrayList arrayList = this.mActionListenerList;
        for (int i = 0; i < arrayList.size(); ++i) {
            ActionListener actionListener = (ActionListener)arrayList.get(i);
            actionListener.actionPerformed(this.getActionEvent(string));
        }
    }

    private ActionEvent getActionEvent(String string) {
        return new ActionEvent(this, 0, string);
    }

    public void notifyToListener(String string, Object object) {
        ArrayList arrayList = this.mActionListenerList;
        for (int i = 0; i < arrayList.size(); ++i) {
            ActionListener actionListener = (ActionListener)arrayList.get(i);
            actionListener.actionPerformed(new ActionEvent(object, 0, string));
        }
    }

    @Override
    public boolean prepare() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    protected void setInsertToggleItemsUnselected() {
        this.mMenuBar.setInsertToggleItemsUnSelected();
        this.mToolBar.setInsertToggleItemsUnSelected();
        Map map = this.mInsertFlagMap;
        Boolean bl = Boolean.FALSE;
        String[] stringArray = INSERT_MENUBARCMD_ARRAY;
        for (int i = 0; i < stringArray.length; ++i) {
            map.put(stringArray[i], bl);
        }
        this.updateInsertItems();
    }

    private void initInsertFlagMap() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        Boolean bl = Boolean.FALSE;
        String[] stringArray = INSERT_MENUBARCMD_ARRAY;
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], bl);
        }
        this.mInsertFlagMap = hashMap;
    }

    public boolean isInsertFlagSelected() {
        Map map = this.mInsertFlagMap;
        for (Boolean bl : map.values()) {
            if (!bl.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean getInsertFlag(String string) {
        Object v = this.mInsertFlagMap.get(string);
        if (v == null) {
            throw new IllegalArgumentException();
        }
        Boolean bl = (Boolean)v;
        return bl;
    }

    public void setInsertFlag(String string, boolean bl) {
        this.mInsertFlagMap.put(string, bl);
    }

    public boolean getLabelInsertionFlag() {
        return this.getInsertFlag("Label");
    }

    public boolean getTimingLineInsertionFlag() {
        return this.getInsertFlag("Timing Line");
    }

    public boolean getAxisBreakSymbolInsertionFlag() {
        return this.getInsertFlag("Axis Break");
    }

    public boolean getSignificantDifferenceSymbolInsertionFlag() {
        return this.getInsertFlag("Significant Difference");
    }

    public boolean getRectangleInsertionFlag() {
        return this.getInsertFlag("Rectangle");
    }

    public boolean getEllipseInsertionFlag() {
        return this.getInsertFlag("Ellipse");
    }

    public boolean getArrowInsertionFlag() {
        return this.getInsertFlag("Arrow");
    }

    public boolean getLineInsertionFlag() {
        return this.getInsertFlag("Line");
    }

    public void pasteToFigures(List<SGICopiable> list, List<SGData> list2, List<String> list3, List<Map<Class, SGProperties>> list4) {
        List<SGFigure> list5 = this.getFocusedFigureList();
        if (list5.size() == 0) {
            return;
        }
        for (int i = 0; i < list5.size(); ++i) {
            SGFigure sGFigure = list5.get(i);
            sGFigure.paste(list);
            for (int j = 0; j < list3.size(); ++j) {
                SGData sGData = list2.get(j);
                String string = list3.get(j);
                Map<Class<? extends SGIFigureElement>, SGProperties> map = list4.get(j);
                SGData sGData2 = (SGData)sGData.copy();
                if (sGFigure.addData(sGData2, string, map)) continue;
                throw new Error("Failed to add data.");
            }
        }
        this.repaintContentPane();
        this.notifyToRoot();
    }

    protected void updateDataItem() {
        this.updateFocusedObjectItem();
    }

    protected void updateFocusedObjectItem() {
        ActionListener actionListener;
        boolean bl = false;
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            actionListener = arrayList.get(i);
            if (((SGFigure)actionListener).isSelected()) {
                bl = true;
                break;
            }
            SGIFigureElement[] sGIFigureElementArray = ((SGFigure)actionListener).getIFigureElementArray();
            for (int j = 0; j < sGIFigureElementArray.length; ++j) {
                if (sGIFigureElementArray[j].getFocusedObjectsList().size() == 0) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        SGMenuBar sGMenuBar = this.mMenuBar;
        sGMenuBar.setMenuItemEnabled("Edit", "Cut", bl);
        sGMenuBar.setMenuItemEnabled("Edit", "Copy", bl);
        sGMenuBar.setMenuItemEnabled("Edit", "Delete", bl);
        sGMenuBar.setMenuItemEnabled("Edit", "Duplicate", bl);
        sGMenuBar.setMenuItemEnabled("Arrange", "Bring to Front", bl);
        sGMenuBar.setMenuItemEnabled("Arrange", "Bring Forward", bl);
        sGMenuBar.setMenuItemEnabled("Arrange", "Send Backward", bl);
        sGMenuBar.setMenuItemEnabled("Arrange", "Send to Back", bl);
        actionListener = this.mToolBar;
        ((SGToolBar)actionListener).setButtonEnabled("Cut", bl);
        ((SGToolBar)actionListener).setButtonEnabled("Copy", bl);
    }

    public void setPasteMenuEnabled(boolean bl) {
        this.mMenuBar.setMenuItemEnabled("Edit", "Paste", bl);
        this.mToolBar.setButtonEnabled("Paste", bl);
        this.mClientPanel.setPopupMenuEnabled("Paste", bl);
    }

    private void updateGridItems() {
        boolean bl = this.mClientPanel.isGridLineVisible();
        boolean bl2 = false;
        boolean bl3 = false;
        if (bl) {
            double d = this.mClientPanel.getGridLineInterval() * 0.035277776f;
            int n = (int)Math.ceil(d / 0.1);
            int n2 = (int)Math.floor(d / 0.1);
            int n3 = (int)Math.rint(1.0);
            int n4 = (int)Math.rint(100.0);
            if (n3 < n2) {
                bl3 = true;
            }
            if (n < n4) {
                bl2 = true;
            }
        }
        SGMenuBar sGMenuBar = this.mMenuBar;
        sGMenuBar.setMenuItemSelected("Layout", "Visible", bl);
        sGMenuBar.setMenuItemEnabled("Layout", "Plus", bl2);
        sGMenuBar.setMenuItemEnabled("Layout", "Minus", bl3);
    }

    private void updateModeMenuItems() {
    }

    void updateSnapToGridItems() {
        this.mMenuBar.setMenuItemSelected("Layout", "Snap to Grid", SGFigure.isSnappingToGrid());
    }

    private void updateZoomItems() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        int[] nArray = SGIRootObjectConstants.MAGNIFICATION_ARRAY;
        int n = nArray[0];
        int n2 = nArray[nArray.length - 1];
        int n3 = (int)this.getMagnificationPercent();
        if (this.isAutoZoom()) {
            bl4 = false;
            bl3 = false;
            bl2 = false;
            bl = false;
        } else {
            bl4 = n3 != n;
            bl3 = n3 != n2;
            bl2 = n3 != 100;
            bl = true;
        }
        SGMenuBar sGMenuBar = this.mMenuBar;
        sGMenuBar.setMenuItemEnabled("Layout", "Zoom In", bl4);
        sGMenuBar.setMenuItemEnabled("Layout", "Zoom Out", bl3);
        sGMenuBar.setMenuItemEnabled("Layout", "Default Zoom", bl2);
        sGMenuBar.setMenuItemEnabled("Layout", "Zoom Way Out", bl);
    }

    private void updateToolBarVisibleItems() {
        String[] stringArray = TOOLBAR_MENUCMD_ARRAY;
        SGToolBar sGToolBar = this.mToolBar;
        SGMenuBar sGMenuBar = this.mMenuBar;
        for (int i = 0; i < stringArray.length; ++i) {
            sGToolBar.setToolBarVisible(stringArray[i], sGMenuBar.isToolBarMenuSelected(stringArray[i]));
        }
    }

    private void updateToolBarVisibleMenuItems() {
        String[] stringArray = TOOLBAR_MENUCMD_ARRAY;
        SGToolBar sGToolBar = this.mToolBar;
        SGMenuBar sGMenuBar = this.mMenuBar;
        for (int i = 0; i < stringArray.length; ++i) {
            sGMenuBar.setToolBarMenuItemSelected(stringArray[i], sGToolBar.isToolBarVisible(stringArray[i]));
        }
    }

    private void updateBackgroundImageItems() {
        boolean bl = this.getImage() != null;
        this.mMenuBar.setMenuItemEnabled("Edit", "Delete Background Image", bl);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        String string = actionEvent.getActionCommand();
        Object object2 = actionEvent.getSource();
        if (string.equals("Exit")) {
            this.notifyToListener("Exit");
        } else if (string.equals("Create New Window")) {
            this.notifyToListener("Create New Window");
        } else if (string.equals("Close Window")) {
            this.notifyToListener("Close Window");
        } else if (string.equals("Draw Graph")) {
            this.notifyToListener("Draw Graph");
        } else if (string.equals("Load Property")) {
            this.notifyToListener("Load Property");
        } else if (string.equals("Save Property")) {
            this.mPropertyFileCreationModeOfFigures = 0;
            this.notifyToListener("Save Property");
        } else if (string.equals("Load Data Set")) {
            this.notifyToListener("Load Data Set");
        } else if (string.equals("Save Data Set")) {
            this.mPropertyFileCreationModeOfFigures = 0;
            this.notifyToListener("Save Data Set");
        } else if (string.equals("Load Background Image")) {
            this.notifyToListener("Load Background Image");
        } else if (string.equals("Export as Image")) {
            this.notifyToListener("Export as Image");
        } else if (string.equals("Print")) {
            this.notifyToListener("Print");
        } else if (string.equals("Delete")) {
            this.deleteFocusedObjects();
        } else if (string.equals("Cut")) {
            this.cutFocusedObjects();
        } else if (string.equals("Copy")) {
            this.copyFocusedObjects();
        } else if (string.equals("Paste")) {
            this.pasteCopiedObjects();
        } else if (string.equals("Duplicate")) {
            this.duplicateFocusedObjects();
        } else if (string.equals("Delete Background Image")) {
            this.deleteImage();
        } else if (string.equals("Bring to Front")) {
            this.bringFocusedObjectsToFront();
        } else if (string.equals("Bring Forward")) {
            this.bringFocusedObjectsForward();
        } else if (string.equals("Send Backward")) {
            this.sendFocusedObjectsBackward();
        } else if (string.equals("Send to Back")) {
            this.sendFocusedObjectsToBack();
        } else if (string.equals("Undo")) {
            this.undo();
            this.repaintContentPane();
        } else if (string.equals("Redo")) {
            this.redo();
            this.repaintContentPane();
        } else if (string.equals("Clear Undo Buffer")) {
            this.clearUndoBuffer();
        } else if (string.equals("A4 Portrait")) {
            this.setPaperSizeDirectly(MediaSize.ISO.A4, true);
        } else if (string.equals("B5 Portrait")) {
            this.setPaperSizeDirectly(MediaSize.ISO.B5, true);
        } else if (string.equals("US Letter Portrait")) {
            this.setPaperSizeDirectly(MediaSize.NA.LETTER, true);
        } else if (string.equals("A4 Landscape")) {
            this.setPaperSizeDirectly(MediaSize.ISO.A4, false);
        } else if (string.equals("B5 Landscape")) {
            this.setPaperSizeDirectly(MediaSize.ISO.B5, false);
        } else if (string.equals("US Letter Landscape")) {
            this.setPaperSizeDirectly(MediaSize.NA.LETTER, false);
        } else if (string.equals("Bounding Box")) {
            this.setBoundingBox();
        } else if (string.equals("User Customize")) {
            this.showPropertyDialog();
        } else if (string.equals("Mode")) {
            int n = this.getMode() == 0 ? 1 : 0;
            this.setMode(n);
            this.updateModeMenuItems();
        } else if (string.equals("Auto Arrangement")) {
            this.alignFigures();
        } else if (string.equals("Visible")) {
            this.mClientPanel.setGridLineVisible(!this.mClientPanel.isGridLineVisible());
            this.updateGridItems();
            this.setChanged(true);
            this.notifyToRoot();
            this.repaintContentPane();
        } else if (string.equals("Plus")) {
            int n;
            double d = this.mClientPanel.getGridLineInterval() * 0.035277776f;
            double d2 = SGUtilityNumber.stepValue(true, d, 0.1, 10.0, 0.1, 0.001f);
            int n2 = (int)Math.rint(d2 / 0.1);
            if (n2 != (n = (int)Math.rint(100.0)) + 1) {
                if (d2 > 10.0) {
                    d2 = 10.0;
                }
                this.mClientPanel.setGridLineInterval((float)d2 / 0.035277776f);
                this.updateGridItems();
                this.repaintContentPane();
                this.setChanged(true);
                this.notifyToRoot();
            }
        } else if (string.equals("Minus")) {
            int n;
            double d = this.mClientPanel.getGridLineInterval() * 0.035277776f;
            double d3 = SGUtilityNumber.stepValue(false, d, 0.1, 10.0, 0.1, 0.001f);
            int n3 = (int)Math.rint(d3 / 0.1);
            if (n3 != (n = (int)Math.rint(1.0)) - 1) {
                if (d3 < 0.1) {
                    d3 = 0.1;
                }
                this.mClientPanel.setGridLineInterval((float)d3 / 0.035277776f);
                this.updateGridItems();
                this.repaintContentPane();
                this.setChanged(true);
                this.notifyToRoot();
            }
        } else if (string.equals("Snap to Grid")) {
            SGFigure.setSnappingToGrid(!SGFigure.isSnappingToGrid());
            this.updateSnapToGridItems();
        } else if (string.equals("Zoom In")) {
            int n6 = (int)this.getMagnificationPercent();
            object = SGIRootObjectConstants.MAGNIFICATION_ARRAY;
            for (int i = ((Object)object).length - 1; i >= 0; --i) {
                if (object[i] <= n6) continue;
                this.setZoomValue((int)object[i]);
                break;
            }
        } else if (string.equals("Zoom Out")) {
            int n7 = (int)this.getMagnificationPercent();
            object = SGIRootObjectConstants.MAGNIFICATION_ARRAY;
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (object[i] >= n7) continue;
                this.setZoomValue((int)object[i]);
                break;
            }
        } else if (string.equals("Default Zoom")) {
            this.setDefaultZoom();
        } else if (string.equals("Zoom Way Out")) {
            this.zoomWayOut();
        } else if (string.equals("Auto Zoom")) {
            this.setAutoZoom(!this.isAutoZoom());
        } else if (string.equals("Lock")) {
            this.setLocked(!this.isLocked());
        } else if (string.equals("Window")) {
            this.createPropertyMenuBarItem();
        } else if (string.equals("Upgrade")) {
            this.notifyToListener("Upgrade");
        } else if (string.equals("Change Log")) {
            this.notifyToListener("Change Log");
        } else if (string.equals("Proxy")) {
            this.notifyToListener("Proxy");
        } else if (string.equals("Memory Info")) {
            this.notifyToListener("Memory Info");
        } else if (string.equals("About")) {
            this.notifyToListener("About");
        }
        if (Arrays.asList(INSERT_MENUBARCMD_ARRAY).contains(string)) {
            void var4_11;
            if (object2.equals(this.mMenuBar)) {
                boolean bl = this.mMenuBar.isInsertToggleItemSelected(string);
            } else if (object2.equals(this.mToolBar)) {
                boolean bl = this.mToolBar.isInsertTogglebuttonSelected(string);
            } else {
                return;
            }
            this.setInsertToggleItemsUnselected();
            this.setInsertFlag(string, (boolean)var4_11);
            this.updateInsertItems();
            if (var4_11 != false) {
                object = new Cursor(1);
                this.setCursor((Cursor)object);
            } else {
                this.setCursor(null);
            }
        }
        if (Arrays.asList(TOOLBAR_MENUCMD_ARRAY).contains(string)) {
            if (object2.equals(this.mMenuBar)) {
                this.updateToolBarVisibleItems();
            } else if (object2.equals(this.mToolBar)) {
                this.updateToolBarVisibleMenuItems();
            }
            this.firePropertyChange("Tool Bar", null, null);
        }
    }

    public void setMode(int n) {
        this.mMode = n;
        SGFigure[] sGFigureArray = this.getFigureArray();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            sGFigureArray[i].setMode(n);
        }
    }

    public int getMode() {
        return this.mMode;
    }

    public SGPropertyResults exportAsImage(SGPropertyMap sGPropertyMap, String string, String string2, boolean bl) {
        if (!this.startExport(bl)) {
            return null;
        }
        Component component = this.getExportTarget();
        SGPropertyResults sGPropertyResults = this.mImageExportManager.export(component, string, string2, sGPropertyMap);
        if (sGPropertyResults == null) {
            this.endExport(bl);
            return null;
        }
        if (!this.endExport(bl)) {
            return null;
        }
        return sGPropertyResults;
    }

    void bringFocusedObjectsToFront() {
        this.moveFocusedObjects(true);
    }

    void sendFocusedObjectsToBack() {
        this.moveFocusedObjects(false);
    }

    private boolean moveFocusedObjects(boolean bl) {
        int n;
        SGIFigureElement[] sGIFigureElementArray;
        Object object;
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        boolean bl2 = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            object = arrayList.get(i);
            if (!((SGFigure)object).moveFocusedObjects(bl)) {
                return false;
            }
            sGIFigureElementArray = ((SGFigure)object).getIFigureElementArray();
            for (n = 0; n < sGIFigureElementArray.length; ++n) {
                if (!sGIFigureElementArray[n].isChanged()) continue;
                bl2 = true;
            }
        }
        List<SGISelectable> list = this.getFocusedObjectsList();
        object = this.mFigureList;
        sGIFigureElementArray = new ArrayList(object);
        if (bl) {
            for (n = 0; n < list.size(); ++n) {
                SGISelectable sGISelectable = list.get(n);
                if (SGUtility.moveObjectTo(sGISelectable, (List)object, object.size() - 1)) continue;
                return false;
            }
        } else {
            for (n = list.size() - 1; n >= 0; --n) {
                SGISelectable sGISelectable = list.get(n);
                if (SGUtility.moveObjectTo(sGISelectable, (List)object, 0)) continue;
                return false;
            }
        }
        if (!object.equals(sGIFigureElementArray)) {
            this.setChanged(true);
            bl2 = true;
        }
        if (bl2) {
            this.notifyToRoot();
            this.updateDataItem();
        }
        this.repaintContentPane();
        return true;
    }

    void bringFocusedObjectsForward() {
        this.moveFocusedObjects(1);
    }

    void sendFocusedObjectsBackward() {
        this.moveFocusedObjects(-1);
    }

    private boolean moveFocusedObjects(int n) {
        SGIFigureElement[] sGIFigureElementArray;
        Object object;
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            object = arrayList.get(i);
            if (!((SGFigure)object).moveFocusedObjects(n)) {
                return false;
            }
            sGIFigureElementArray = ((SGFigure)object).getIFigureElementArray();
            for (int j = 0; j < sGIFigureElementArray.length; ++j) {
                if (!sGIFigureElementArray[j].isChanged()) continue;
                bl = true;
            }
        }
        List<SGISelectable> list = this.getFocusedObjectsList();
        object = this.mFigureList;
        sGIFigureElementArray = new ArrayList(object);
        if (!SGUtility.moveObject(list, (List)object, n)) {
            return false;
        }
        if (!object.equals(sGIFigureElementArray)) {
            this.setChanged(true);
            bl = true;
        }
        if (bl) {
            this.notifyToRoot();
            this.updateDataItem();
        }
        this.repaintContentPane();
        return true;
    }

    public boolean moveFigureToEnd(int n, boolean bl) {
        boolean bl2;
        SGFigure sGFigure = this.getFigure(n);
        if (sGFigure == null) {
            return false;
        }
        if (!sGFigure.isVisible()) {
            return false;
        }
        List<SGFigure> list = this.mFigureList;
        ArrayList<SGFigure> arrayList = new ArrayList<SGFigure>(list);
        if (bl ? !SGUtility.moveObjectToTail(sGFigure, list) : !SGUtility.moveObjectToHead(sGFigure, list)) {
            return false;
        }
        boolean bl3 = bl2 = !((Object)this.mFigureList).equals(arrayList);
        if (bl2) {
            this.setChanged(true);
            this.notifyToRoot();
            this.updateDataItem();
            this.repaintContentPane();
        }
        return true;
    }

    public boolean moveFigure(int n, boolean bl) {
        boolean bl2;
        SGFigure sGFigure = this.getFigure(n);
        if (sGFigure == null) {
            return false;
        }
        if (!sGFigure.isVisible()) {
            return false;
        }
        List<SGFigure> list = this.mFigureList;
        ArrayList<SGFigure> arrayList = new ArrayList<SGFigure>(list);
        if (bl ? !SGUtility.moveObjectToNext(sGFigure, list) : !SGUtility.moveObjectToPrevious(sGFigure, list)) {
            return false;
        }
        boolean bl3 = bl2 = !((Object)this.mFigureList).equals(arrayList);
        if (bl2) {
            this.setChanged(true);
            this.notifyToRoot();
            this.updateDataItem();
            this.repaintContentPane();
        }
        return true;
    }

    public void doCopy() {
        this.copyFocusedObjects();
    }

    void copyFocusedObjects() {
        this.copyAllObjectsInVisibleFigures();
        this.notifyToListener("Copy");
        this.updateFocusedObjectItem();
    }

    public void doCut() {
        this.cutFocusedObjects();
    }

    private void cutFocusedObjects() {
        this.cutAllObjectsInVisibleFigures();
        this.notifyToListener("Cut");
        this.notifyToRoot();
        this.updateFocusedObjectItem();
        this.repaintContentPane();
    }

    public boolean cutOrCopyFigure(int n, boolean bl) {
        SGFigure sGFigure = this.getFigure(n);
        if (sGFigure == null) {
            return false;
        }
        if (!sGFigure.isVisible()) {
            return false;
        }
        this.mCopiedFiguresList.add(sGFigure);
        if (!bl) {
            this.hideFigure(sGFigure);
        }
        if (bl) {
            this.notifyToListener("Copy");
        } else {
            this.notifyToListener("Cut");
        }
        this.notifyToRoot();
        this.updateFocusedObjectItem();
        this.repaintContentPane();
        return true;
    }

    public void doPaste() {
        this.pasteCopiedObjects();
    }

    private void pasteCopiedObjects() {
        this.notifyToListener("Paste");
        this.notifyToRoot();
    }

    public void doDuplicate() {
        this.duplicateFocusedObjects();
    }

    void duplicateFocusedObjects() {
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = arrayList.get(i);
            if (sGFigure.duplicateFocusedObjects()) continue;
            return;
        }
        this.repaintContentPane();
        this.notifyToListener("Duplicate");
        List<SGFigure> list = this.getFocusedFigureList();
        for (int i = 0; i < list.size(); ++i) {
            SGFigure sGFigure = list.get(i);
            this.setFocusedFigure(sGFigure, false);
        }
        ArrayList<SGFigure> arrayList2 = this.getVisibleFigureList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList2.get(i);
            if (arrayList.contains(sGFigure)) continue;
            this.setFocusedFigure(sGFigure, true);
        }
        this.notifyToRoot();
    }

    public void doDelete() {
        this.deleteFocusedObjects();
    }

    private void deleteFocusedObjects() {
        this.hideSelectedObjects();
        this.notifyToRoot();
        this.updateDataItem();
        this.repaintContentPane();
    }

    public boolean hideFigure(int n) {
        SGFigure sGFigure = this.getFigure(n);
        if (sGFigure == null) {
            return false;
        }
        if (!this.hideFigure(sGFigure)) {
            return false;
        }
        this.clearFocusedObjects();
        this.setChanged(true);
        this.notifyToRoot();
        this.updateItemsByFigureNumbers();
        this.repaintContentPane();
        return true;
    }

    private void cutAllObjectsInVisibleFigures() {
        this.cutOrCopyAllObjectsInVisibleFigures(false);
    }

    private void copyAllObjectsInVisibleFigures() {
        this.cutOrCopyAllObjectsInVisibleFigures(true);
    }

    private void cutOrCopyAllObjectsInVisibleFigures(boolean bl) {
        SGFigure sGFigure;
        int n;
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        ArrayList<SGICopiable> arrayList2 = new ArrayList<SGICopiable>();
        ArrayList<SGData> arrayList3 = new ArrayList<SGData>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<Map<Class, SGProperties>> arrayList5 = new ArrayList<Map<Class, SGProperties>>();
        if (bl) {
            for (n = 0; n < arrayList.size(); ++n) {
                sGFigure = (SGFigure)arrayList.get(n);
                arrayList2.addAll(sGFigure.createCopiedObjects());
                sGFigure.createCopiedDataObjects(arrayList3, arrayList4, arrayList5);
            }
        } else {
            for (n = 0; n < arrayList.size(); ++n) {
                sGFigure = (SGFigure)arrayList.get(n);
                arrayList2.addAll(sGFigure.cutFocusedObjects());
                sGFigure.cutFocusedDataObjects(arrayList3, arrayList4, arrayList5);
            }
        }
        this.clearCopiedObjectsList();
        this.mCopiedObjectsList.addAll(arrayList2);
        this.mCopiedDataObjectsList.addAll(arrayList3);
        this.mCopiedDataNameList.addAll(arrayList4);
        this.mCopiedDataPropertiesMapList.addAll(arrayList5);
        List<SGFigure> list = this.getFocusedFigureList();
        for (int i = 0; i < list.size(); ++i) {
            this.mCopiedFiguresList.add(list.get(i));
        }
    }

    public List<SGICopiable> getCopiedObjectsList() {
        ArrayList<SGICopiable> arrayList = new ArrayList<SGICopiable>();
        SGUtility.copyObjects(this.mCopiedObjectsList, arrayList);
        return arrayList;
    }

    public List<SGData> getCopiedObjectsDataList() {
        ArrayList<SGData> arrayList = new ArrayList<SGData>();
        SGUtility.copyObjects(this.mCopiedDataObjectsList, arrayList);
        return arrayList;
    }

    public List<String> getCopiedDataNameList() {
        ArrayList<String> arrayList = new ArrayList<String>(this.mCopiedDataNameList);
        return arrayList;
    }

    public List<Map<Class, SGProperties>> getCopiedDataPropertiesMapList() {
        ArrayList<Map<Class, SGProperties>> arrayList = new ArrayList<Map<Class, SGProperties>>();
        for (int i = 0; i < this.mCopiedDataPropertiesMapList.size(); ++i) {
            Map<Class, SGProperties> map = this.mCopiedDataPropertiesMapList.get(i);
            arrayList.add(new HashMap<Class, SGProperties>(map));
        }
        return arrayList;
    }

    public void clearCopiedObjectsList() {
        for (SGICopiable sGICopiable : this.mCopiedObjectsList) {
            if (!(sGICopiable instanceof SGIDisposable)) continue;
            SGIDisposable sGIDisposable = (SGIDisposable)((Object)sGICopiable);
            sGIDisposable.dispose();
        }
        this.mCopiedObjectsList.clear();
        for (SGData sGData : this.mCopiedDataObjectsList) {
            sGData.dispose();
        }
        this.mCopiedDataObjectsList.clear();
        this.mCopiedDataNameList.clear();
        this.mCopiedDataPropertiesMapList.clear();
        this.mCopiedFiguresList.clear();
    }

    void notifyPasteToFocusedFigures() {
        this.mPasteTargetList.clear();
        this.mPasteTargetList.addAll(this.getFocusedObjectsList());
        this.notifyToListener("Paste");
    }

    void doInserNetCDFLabel() {
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.insertNetCDFLabel();
        }
        this.repaintContentPane();
    }

    void doFitAxisRangeToData() {
        boolean bl = false;
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.fitAxisRangeToFocusedData();
            if (!sGFigure.isChangedRoot()) continue;
            bl = true;
        }
        if (bl) {
            this.notifyToRoot();
        }
        this.repaintContentPane();
    }

    void doFitAxisRangeToVisibleData() {
        boolean bl = false;
        List<SGFigure> list = this.getFocusedFigureList();
        for (int i = 0; i < list.size(); ++i) {
            SGFigure sGFigure = list.get(i);
            sGFigure.fitAxisRangeToVisibleData();
            if (!sGFigure.isChangedRoot()) continue;
            bl = true;
        }
        if (bl) {
            this.notifyToRoot();
        }
        this.repaintContentPane();
    }

    void doAlignBars() {
        boolean bl = false;
        List<SGFigure> list = this.getFocusedFigureList();
        for (int i = 0; i < list.size(); ++i) {
            SGFigure sGFigure = list.get(i);
            sGFigure.alignVisibleBars();
            if (!sGFigure.isChangedRoot()) continue;
            bl = true;
        }
        if (bl) {
            this.notifyToRoot();
        }
        this.repaintContentPane();
    }

    public boolean isLocked() {
        return this.mLockFigureFlag;
    }

    public boolean setLocked(boolean bl) {
        this.mLockFigureFlag = bl;
        this.updateLockItems();
        return true;
    }

    private void updateLockItems() {
        boolean bl = this.isLocked();
        this.mToolBar.setButtonSelected("Lock", bl);
        this.mMenuBar.setMenuItemSelected("Layout", "Lock", bl);
    }

    public void clearUndoBuffer() {
        boolean bl = this.isSaved();
        this.initUndoBuffer();
        if (bl) {
            this.mSavedListIndex = 0;
            this.updateStatusBarSavedFlag();
        } else {
            this.initSavedHistory();
        }
        this.updateUndoItems();
        this.notifyToRoot();
    }

    public boolean setSelectedFigure(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            SGFigure sGFigure = this.getFigure(nArray[i]);
            sGFigure.setSelected(true);
        }
        this.updateFocusedObjectItem();
        this.repaintContentPane();
        return true;
    }

    @Override
    public String getClassDescription() {
        return this.getInstanceDescription();
    }

    @Override
    public String getInstanceDescription() {
        return "Window: " + this.mID;
    }

    private void createPropertyMenuBarItem() {
        TreeMenuItemListener treeMenuItemListener = new TreeMenuItemListener();
        this.mMenuBar.createPropertyMenuBarItem(this, treeMenuItemListener);
    }

    public boolean createTree(StringBuffer stringBuffer) {
        this.createTree(this, stringBuffer, 0);
        return true;
    }

    private void createTree(SGINode sGINode, StringBuffer stringBuffer, int n) {
        ArrayList arrayList = sGINode.getChildNodes();
        String string = sGINode.getClassDescription();
        String string2 = sGINode.getInstanceDescription();
        boolean bl = sGINode instanceof SGIPropertyDialogObserver;
        if (arrayList.size() != 0) {
            if (string != null && string2 != null) {
                this.append(stringBuffer, string2, n);
                int n2 = n + 1;
                for (int i = 0; i < arrayList.size(); ++i) {
                    SGINode sGINode2 = (SGINode)arrayList.get(i);
                    this.createTree(sGINode2, stringBuffer, n2);
                }
            }
        } else if (string2 != null && bl) {
            this.append(stringBuffer, string2, n);
        }
    }

    private void append(StringBuffer stringBuffer, String string, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        stringBuffer.append(string);
        stringBuffer.append(SGIConstants.LINE_SEPARATOR);
    }

    @Override
    public boolean startProgress() {
        return this.mStatusBar.startProgress();
    }

    @Override
    public boolean endProgress() {
        return this.mStatusBar.endProgress();
    }

    @Override
    public void setProgressValue(float f) {
        this.mStatusBar.setProgressValue(f);
    }

    @Override
    public void setIndeterminateProgress(boolean bl) {
        this.mStatusBar.setIndeterminateProgress(bl);
    }

    @Override
    public void setProgressMessage(String string) {
        this.mStatusBar.setProgressMessage(string);
    }

    private Rectangle2D getPaperRectInClientRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.mPaperOrigin.x, this.mPaperOrigin.y, this.mClientPanel.getPaperWidth(), this.mClientPanel.getPaperHeight());
        return float_;
    }

    boolean recordPaperRect() {
        this.mTempPaperRect.setRect(this.getPaperRectInClientRect());
        return true;
    }

    public boolean isPaperBoundsChanged() {
        Rectangle rectangle;
        Rectangle rectangle2 = this.mTempPaperRect.getBounds();
        return !rectangle2.equals(rectangle = this.getPaperRectInClientRect().getBounds());
    }

    public boolean alignFigures() {
        SGFigure sGFigure;
        int n;
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        for (n = 0; n < arrayList.size(); ++n) {
            sGFigure = arrayList.get(n);
            sGFigure.recordFigureRect();
        }
        this.recordPaperRect();
        if (!this.alignFiguresByGraphAreaNew()) {
            return false;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            sGFigure = arrayList.get(n);
            if (!sGFigure.isFigureMoved()) continue;
            sGFigure.setChanged(true);
        }
        if (this.isPaperBoundsChanged()) {
            this.setChanged(true);
        }
        this.notifyToRoot();
        return true;
    }

    public boolean setPaperSizeDirectly(MediaSize mediaSize, boolean bl) {
        Rectangle rectangle = this.getPaperRect().getBounds();
        this.mClientPanel.setPaperSize(mediaSize, bl);
        Rectangle rectangle2 = this.getPaperRect().getBounds();
        if (rectangle.equals(rectangle2)) {
            return true;
        }
        this.updateClientRect();
        this.setChanged(true);
        this.notifyToRoot();
        this.doAutoZoom();
        this.repaintContentPane();
        return true;
    }

    public boolean setBoundingBox() {
        Rectangle2D rectangle2D = this.getClientRect();
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        if (arrayList.size() != 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = arrayList.get(i);
                sGFigure.recordFigureRect();
            }
            this.recordPaperRect();
            Rectangle2D rectangle2D2 = this.getBoundingBoxOfFigures(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = arrayList.get(i);
                float f = BOUNDING_BOX_MARGIN + (float)(rectangle2D.getX() + (double)sGFigure.getGraphRectX() - rectangle2D2.getX());
                float f2 = BOUNDING_BOX_MARGIN + (float)(rectangle2D.getY() + (double)sGFigure.getGraphRectY() - rectangle2D2.getY());
                sGFigure.setGraphRectLocationRoundingOut(f, f2);
                if (!sGFigure.isFigureMoved()) continue;
                sGFigure.setChanged(true);
            }
            this.setFigureBoundingBox(0);
            if (this.isPaperBoundsChanged()) {
                this.setChanged(true);
            }
            this.notifyToRoot();
        } else {
            SGUtility.showMessageDialog(this, "There is no figure.", "Failed to get the Bounding box.", 2);
        }
        return true;
    }

    @Override
    public boolean initPropertiesHistory() {
        return this.mUndoManager.initPropertiesHistory();
    }

    @Override
    public boolean commit() {
        this.updateClientRect();
        this.doAutoZoom();
        this.updateGridItems();
        SGProperties sGProperties = this.mTemporaryProperties;
        SGProperties sGProperties2 = this.getProperties();
        if (!sGProperties.equals(sGProperties2)) {
            this.setChanged(true);
        }
        this.mTemporaryProperties = null;
        this.repaintContentPane();
        return true;
    }

    @Override
    public boolean updateHistory() {
        this.updateSavedListIndex();
        if (!this.mUndoManager.updateHistory(this.getVisibleFigureList())) {
            return false;
        }
        this.updateUndoItems();
        this.updateStatusBarSavedFlag();
        return true;
    }

    private void updateSavedListIndex() {
        int n;
        boolean bl = false;
        if (this.isChanged()) {
            bl = true;
        } else {
            ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = arrayList.get(i);
                if (!sGFigure.isChanged()) continue;
                bl = true;
                break;
            }
        }
        if (bl && (n = this.mUndoManager.getChangedObjectListIndex()) < this.mSavedListIndex) {
            this.initSavedHistory();
        }
    }

    private void updateStatusBarSavedFlag() {
        boolean bl = false;
        if (this.getVisibleFigureList().size() != 0) {
            int n = this.mUndoManager.getChangedObjectListIndex();
            bl = n != this.mSavedListIndex;
        }
        this.mStatusBar.setSaved(bl);
    }

    public void initSavedHistory() {
        this.mSavedListIndex = -1;
        this.updateStatusBarSavedFlag();
    }

    protected Set getAvailableChildSet() {
        HashSet hashSet = new HashSet();
        List list = this.mUndoManager.getMementoList();
        for (int i = 0; i < list.size(); ++i) {
            WindowProperties windowProperties = (WindowProperties)list.get(i);
            hashSet.addAll(windowProperties.mVisibleFigureList);
        }
        return hashSet;
    }

    @Override
    public void initUndoBuffer() {
        for (int i = 0; i < this.mFigureList.size(); ++i) {
            SGFigure sGFigure = this.mFigureList.get(i);
            sGFigure.initUndoBuffer();
        }
        this.mUndoManager.initUndoBuffer();
        if (!this.deleteUselessFigures()) {
            throw new Error("Failed to initialize undo buffer.");
        }
    }

    @Override
    public boolean isUndoable() {
        return this.mUndoManager.isUndoable();
    }

    @Override
    public boolean isRedoable() {
        return this.mUndoManager.isRedoable();
    }

    @Override
    public void clearChanged() {
        this.setChanged(false);
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.clearChanged();
        }
    }

    @Override
    public boolean cancel() {
        if (!this.setProperties(this.mTemporaryProperties)) {
            return false;
        }
        this.mTemporaryProperties = null;
        this.updateClientRect();
        this.repaintContentPane();
        return true;
    }

    @Override
    public boolean preview() {
        this.updateClientRect();
        this.doAutoZoom();
        this.updateGridItems();
        this.repaintContentPane();
        return true;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    public void setWaitCursor(boolean bl) {
        Cursor cursor = bl ? new Cursor(3) : new Cursor(0);
        RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)this.getRootPane().getTopLevelAncestor());
        rootPaneContainer.getGlassPane().setCursor(cursor);
        rootPaneContainer.getGlassPane().setVisible(bl);
        if (bl) {
            rootPaneContainer.getGlassPane().addMouseListener(new MouseAdapter(){});
        }
    }

    @Override
    public SGPropertyDialog getPropertyDialog() {
        if (this.mPropertyDialog == null) {
            this.mPropertyDialog = new SGWindowDialog((Frame)this, true);
        }
        return this.mPropertyDialog;
    }

    public boolean updateClientRect() {
        this.updateClientRectOld();
        return true;
    }

    private boolean updateClientRectOld() {
        double d;
        boolean bl;
        boolean bl2;
        Rectangle2D rectangle2D;
        Rectangle2D rectangle2D2;
        this.fitRect(this.mClientRect, this.getBoundingBox(), true);
        if (SGUtility.isRectContains(this.getViewportBounds(), this.getBoundingBox(), true)) {
            this.fitRect(this.mClientRect, this.getViewportBounds(), true);
        }
        if (!SGUtility.isRectContains(this.getClientRect(), this.getViewportBounds(), true)) {
            rectangle2D2 = this.getClientRect();
            rectangle2D = this.getViewportBounds();
            bl2 = SGUtility.isRectContains(rectangle2D2, rectangle2D.getX(), true);
            bl = SGUtility.isRectContains(rectangle2D2, rectangle2D.getX() + rectangle2D.getWidth(), true);
            d = 0.0;
            if (!bl2 && bl) {
                d = rectangle2D.getX() - rectangle2D2.getX();
            } else if (bl2 && !bl) {
                d = rectangle2D.getX() + rectangle2D.getWidth() - (rectangle2D2.getX() + rectangle2D2.getWidth());
            } else if (!bl2 && !bl) {
                d = rectangle2D2.getX() < rectangle2D.getX() ? rectangle2D.getX() + rectangle2D.getWidth() - (rectangle2D2.getX() + rectangle2D2.getWidth()) : rectangle2D.getX() - rectangle2D2.getX();
            }
            this.setClientRect((float)(rectangle2D2.getX() + d), (float)rectangle2D2.getY(), (float)rectangle2D2.getWidth(), (float)rectangle2D2.getHeight());
        }
        this.fitRect(this.mClientRect, this.getBoundingBox(), false);
        if (SGUtility.isRectContains(this.getViewportBounds(), this.getBoundingBox(), false)) {
            this.fitRect(this.mClientRect, this.getViewportBounds(), false);
        }
        if (!SGUtility.isRectContains(this.getClientRect(), this.getViewportBounds(), false)) {
            rectangle2D2 = this.getClientRect();
            rectangle2D = this.getViewportBounds();
            bl2 = SGUtility.isRectContains(rectangle2D2, rectangle2D.getY(), false);
            bl = SGUtility.isRectContains(rectangle2D2, rectangle2D.getY() + rectangle2D.getHeight(), false);
            d = 0.0;
            if (!bl2 && bl) {
                d = rectangle2D.getY() - rectangle2D2.getY();
            } else if (bl2 && !bl) {
                d = rectangle2D.getY() + rectangle2D.getHeight() - (rectangle2D2.getY() + rectangle2D2.getHeight());
            } else if (!bl2 && !bl) {
                d = rectangle2D2.getY() < rectangle2D.getY() ? rectangle2D.getY() + rectangle2D.getHeight() - (rectangle2D2.getY() + rectangle2D2.getHeight()) : rectangle2D.getY() - rectangle2D2.getY();
            }
            this.setClientRect((float)rectangle2D2.getX(), (float)(rectangle2D2.getY() + d), (float)rectangle2D2.getWidth(), (float)rectangle2D2.getHeight());
        }
        rectangle2D2 = this.getBoundingBox();
        rectangle2D = this.getViewportBounds();
        Rectangle2D rectangle2D3 = this.getClientRect();
        this.mClientPanel.setScrollBarValue(rectangle2D3, rectangle2D);
        this.mClientPanel.setEnableScrollBars(rectangle2D, rectangle2D2);
        if (SGUtility.isRectContains(rectangle2D, rectangle2D2, true)) {
            this.fitRect(this.mClientRect, rectangle2D, true);
        }
        if (SGUtility.isRectContains(rectangle2D, rectangle2D2, false)) {
            this.fitRect(this.mClientRect, rectangle2D, false);
        }
        this.mClientPanel.setScrollBarValue(rectangle2D3, rectangle2D);
        return true;
    }

    private void fitRect(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        if (bl) {
            rectangle2D.setRect(rectangle2D2.getX(), rectangle2D.getY(), rectangle2D2.getWidth(), rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D2.getY(), rectangle2D.getWidth(), rectangle2D2.getHeight());
        }
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof WindowProperties)) {
            return false;
        }
        WindowProperties windowProperties = (WindowProperties)sGProperties;
        Float f = windowProperties.getPaperWidth();
        Float f2 = windowProperties.getPaperHeight();
        if (f == null || f2 == null) {
            return false;
        }
        this.mClientPanel.setPaperSize(f.floatValue(), f2.floatValue());
        Color color = windowProperties.getBackgroundColor();
        if (color == null) {
            return false;
        }
        this.mClientPanel.setPaperColor(color);
        Color color2 = windowProperties.getGridColor();
        if (color2 == null) {
            return false;
        }
        this.mClientPanel.setGridLineColor(color2);
        Boolean bl = windowProperties.getGridVisible();
        if (bl == null) {
            return false;
        }
        this.mClientPanel.setGridLineVisible(bl);
        Float f3 = windowProperties.getGridInterval();
        if (f3 == null) {
            return false;
        }
        this.mClientPanel.setGridLineInterval(f3.floatValue());
        Float f4 = windowProperties.getGridLineWidth();
        if (f4 == null) {
            return false;
        }
        this.mClientPanel.setGridLineWidth(f4.floatValue());
        Float f5 = windowProperties.getImageLocationX();
        if (f5 == null) {
            return false;
        }
        this.mClientPanel.setImageLocationX(f5.floatValue());
        Float f6 = windowProperties.getImageLocationY();
        if (f6 == null) {
            return false;
        }
        this.mClientPanel.setImageLocationY(f6.floatValue());
        Float f7 = windowProperties.getImageScalingFactor();
        if (f7 == null) {
            return false;
        }
        this.mClientPanel.setImageScalingFactor(f7.floatValue());
        Image image = windowProperties.getImage();
        this.mClientPanel.setImage(image);
        if (image == null) {
            this.mBackgroundImage = null;
        }
        this.setVisibleFigure(windowProperties.getVisibleFigureList());
        return true;
    }

    public SGProperties getProperties() {
        WindowProperties windowProperties = new WindowProperties();
        windowProperties.setPaperWidth(this.mClientPanel.getPaperWidth());
        windowProperties.setPaperHeight(this.mClientPanel.getPaperHeight());
        windowProperties.setBackGroundColor(this.mClientPanel.getPaperColor());
        windowProperties.setGridColor(this.mClientPanel.getGridLineColor());
        windowProperties.setGridVisible(this.mClientPanel.isGridLineVisible());
        windowProperties.setGridInterval(this.mClientPanel.getGridLineInterval());
        windowProperties.setGridLineWidth(this.mClientPanel.getGridLineWidth());
        windowProperties.setVisibleFigureList(this.getVisibleFigureList());
        windowProperties.setImageLocationX(this.getImageLocationX());
        windowProperties.setImageLocationY(this.getImageLocationY());
        windowProperties.setImageScalingFactor(this.getImageScalingFactor());
        windowProperties.setImage(this.getImage());
        return windowProperties;
    }

    protected boolean setVisibleFigure(List list) {
        return SGUtility.setVisibleList(this.mFigureList, list);
    }

    public Rectangle2D getClientRect() {
        if (this.mClientRect == null) {
            return null;
        }
        return (Rectangle2D)this.mClientRect.clone();
    }

    public boolean setClientRect(float f, float f2, float f3, float f4) {
        this.mClientRect.setRect(f, f2, f3, f4);
        return true;
    }

    public boolean setClientRect(Rectangle2D rectangle2D) {
        this.mClientRect.setRect(rectangle2D);
        return true;
    }

    public Rectangle2D getViewportBounds() {
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f = sGTuple2f.x;
        float f2 = sGTuple2f.y;
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, f, f2);
        return float_;
    }

    public Rectangle2D getViewportBoundsInLayeredPane() {
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f = sGTuple2f.x;
        float f2 = sGTuple2f.y;
        int n = this.mClientPanel.getRulerWidth();
        Rectangle2D.Float float_ = new Rectangle2D.Float(n, n, f, f2);
        return float_;
    }

    public Rectangle2D getViewportBoundsInComponent() {
        int n = this.getTopWidth();
        int n2 = this.getLeftWidth();
        int n3 = this.mClientPanel.getRulerWidth();
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f = sGTuple2f.x + (float)n3;
        float f2 = sGTuple2f.y + (float)n3;
        Rectangle2D.Float float_ = new Rectangle2D.Float(n2, n, f, f2);
        return float_;
    }

    protected SGFigure[][] getOrderedFigureArray() {
        int n;
        int n2;
        int n3;
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        int n4 = arrayList.size();
        if (n4 == 0) {
            return new SGFigure[0][0];
        }
        int n5 = 0;
        for (n3 = 1; n3 <= 16; ++n3) {
            n2 = (n3 - 1) * (n3 - 1);
            n = n3 * n3;
            if (n2 >= n4 || n4 > n) continue;
            n5 = n3;
            break;
        }
        n3 = n5;
        n2 = n4 / n3;
        n = n4 % n3 == 0 ? n2 : n2 + 1;
        SGFigure[][] sGFigureArray = new SGFigure[n][n3];
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n6 = i * n3 + j;
                if (n6 >= arrayList.size()) {
                    bl = false;
                    break;
                }
                sGFigureArray[i][j] = arrayList.get(n6);
            }
            if (!bl) break;
        }
        return sGFigureArray;
    }

    private ArrayList[][] getFigureListArray() {
        int n;
        int n2;
        int n3;
        int n4;
        Rectangle2D rectangle2D;
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        if (arrayList.size() == 0) {
            return null;
        }
        float f = Float.MAX_VALUE;
        float f2 = Float.MAX_VALUE;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = arrayList.get(i);
            rectangle2D = sGFigure.getGraphRect();
            if (rectangle2D.getWidth() < (double)f) {
                f = (float)rectangle2D.getWidth();
            }
            if (!(rectangle2D.getHeight() < (double)f2)) continue;
            f2 = (float)rectangle2D.getHeight();
        }
        float f3 = f;
        float f4 = f2;
        rectangle2D = this.getBoundingBoxOfFigures(arrayList);
        int n5 = (int)((float)rectangle2D.getWidth() / f3) + 1;
        int n6 = (int)((float)rectangle2D.getHeight() / f4) + 1;
        ArrayList[][] arrayListArray = new ArrayList[n5][n6];
        for (n4 = 0; n4 < n5; ++n4) {
            for (int i = 0; i < n6; ++i) {
                arrayListArray[n4][i] = new ArrayList();
            }
        }
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            SGFigure sGFigure = arrayList.get(n4);
            Rectangle2D rectangle2D2 = sGFigure.getGraphRect();
            n3 = (int)((rectangle2D2.getCenterX() - rectangle2D.getX()) / (double)f3);
            n2 = (int)((rectangle2D2.getCenterY() - rectangle2D.getY()) / (double)f4);
            arrayListArray[n3][n2].add(sGFigure);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < n5; ++i) {
            boolean bl = false;
            for (n3 = 0; n3 < n6; ++n3) {
                if (arrayListArray[i][n3].size() == 0) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            arrayList2.add(i);
        }
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (n = 0; n < n6; ++n) {
            n3 = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                if (arrayListArray[n2][n].size() == 0) continue;
                n3 = 1;
                break;
            }
            if (n3 == 0) continue;
            arrayList3.add(n);
        }
        n = arrayList2.size();
        n3 = arrayList3.size();
        ArrayList[][] arrayListArray2 = new ArrayList[n][n3];
        for (int i = 0; i < n; ++i) {
            int n7 = (Integer)arrayList2.get(i);
            for (int j = 0; j < n3; ++j) {
                int n8 = (Integer)arrayList3.get(j);
                arrayListArray2[i][j] = arrayListArray[n7][n8];
            }
        }
        return arrayListArray2;
    }

    private boolean alignFiguresLeftAndBottom(ArrayList[][] arrayListArray) {
        int n;
        float f;
        float f2;
        float f3;
        float f4;
        int n2;
        int n3 = arrayListArray.length;
        int n4 = arrayListArray[0].length;
        float[][] fArray = new float[n3][n4];
        float[][] fArray2 = new float[n3][n4];
        float[][] fArray3 = new float[n3][n4];
        float[][] fArray4 = new float[n3][n4];
        for (int i = 0; i < n3; ++i) {
            for (n2 = 0; n2 < n4; ++n2) {
                ArrayList arrayList = arrayListArray[i][n2];
                float f5 = 0.0f;
                f4 = 0.0f;
                f3 = 0.0f;
                f2 = 0.0f;
                for (int j = 0; j < arrayList.size(); ++j) {
                    SGFigure sGFigure = (SGFigure)arrayList.get(j);
                    Rectangle2D rectangle2D = sGFigure.getGraphRect();
                    f = (float)rectangle2D.getWidth();
                    float f6 = (float)rectangle2D.getHeight();
                    SGTuple2f sGTuple2f = new SGTuple2f();
                    SGTuple2f sGTuple2f2 = new SGTuple2f();
                    sGFigure.calcMargin(sGTuple2f, sGTuple2f2);
                    float f7 = sGTuple2f.x;
                    float f8 = sGTuple2f.y;
                    float f9 = sGTuple2f2.x;
                    float f10 = sGTuple2f2.y;
                    if (f7 + f6 > f5) {
                        f5 = f7 + f6;
                    }
                    if (f8 > f4) {
                        f4 = f8;
                    }
                    if (f9 > f3) {
                        f3 = f9;
                    }
                    if (!(f10 + f > f2)) continue;
                    f2 = f10 + f;
                }
                fArray[i][n2] = f5;
                fArray2[i][n2] = f4;
                fArray3[i][n2] = f3;
                fArray4[i][n2] = f2;
            }
        }
        float[] fArray5 = new float[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            float f11 = 0.0f;
            for (int i = 0; i < n4; ++i) {
                f4 = fArray3[n2][i] + fArray4[n2][i];
                if (!(f4 > f11)) continue;
                f11 = f4;
            }
            fArray5[n2] = f11;
        }
        float[] fArray6 = new float[n4];
        for (int i = 0; i < n4; ++i) {
            float f12 = 0.0f;
            for (int j = 0; j < n3; ++j) {
                f3 = fArray[j][i] + fArray2[j][i];
                if (!(f3 > f12)) continue;
                f12 = f3;
            }
            fArray6[i] = f12;
        }
        float[] fArray7 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            float f13 = 0.0f;
            for (int j = 0; j < n4; ++j) {
                f2 = fArray3[i][j];
                if (!(f2 > f13)) continue;
                f13 = f2;
            }
            fArray7[i] = f13;
        }
        float[] fArray8 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            float f14 = 0.0f;
            for (int j = 0; j < n4; ++j) {
                float f15 = fArray4[i][j];
                if (!(f15 > f14)) continue;
                f14 = f15;
            }
            fArray8[i] = f14;
        }
        float[] fArray9 = new float[n4];
        for (int i = 0; i < n4; ++i) {
            float f16 = 0.0f;
            for (int j = 0; j < n3; ++j) {
                float f17 = fArray2[j][i];
                if (!(f17 > f16)) continue;
                f16 = f17;
            }
            fArray9[i] = f16;
        }
        float f18 = this.getMagnification() * this.mClientPanel.getGridLineInterval();
        Rectangle2D rectangle2D = this.getPaperRect();
        float f19 = (float)rectangle2D.getX();
        float f20 = (float)rectangle2D.getY();
        float f21 = f19;
        f = f20;
        float[] fArray10 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            float f22 = f21 + fArray7[i];
            int n5 = (int)((f22 - f19) / f18) + 1;
            fArray10[i] = f19 + (float)n5 * f18;
            f21 = fArray10[i] + fArray8[i];
        }
        float[] fArray11 = new float[n4];
        for (n = 0; n < n4; ++n) {
            float f23 = f + fArray6[n] - fArray9[n];
            int n6 = (int)((f23 - f20) / f18) + 1;
            fArray11[n] = f20 + (float)n6 * f18;
            f = fArray11[n] + fArray9[n];
        }
        n = 1;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                ArrayList arrayList = arrayListArray[j][i];
                for (int k = 0; k < arrayList.size(); ++k) {
                    SGFigure sGFigure = (SGFigure)arrayList.get(k);
                    if (sGFigure == null) {
                        n = 0;
                        break;
                    }
                    if (sGFigure.setGraphRectLocationByLeftBottom(fArray10[j], fArray11[i])) continue;
                    return false;
                }
                if (n == 0) break;
            }
            if (n == 0) break;
        }
        return true;
    }

    public boolean alignFiguresByGraphArea() {
        int n;
        Cloneable cloneable;
        float f;
        float f2;
        float f3;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Rectangle2D rectangle2D;
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        if (arrayList.size() == 0) {
            return true;
        }
        Rectangle2D rectangle2D2 = this.mClientRect;
        float f4 = Float.MAX_VALUE;
        float f5 = Float.MAX_VALUE;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = arrayList.get(i);
            rectangle2D = sGFigure.getGraphRect();
            if (rectangle2D.getWidth() < (double)f4) {
                f4 = (float)rectangle2D.getWidth();
            }
            if (!(rectangle2D.getHeight() < (double)f5)) continue;
            f5 = (float)rectangle2D.getHeight();
        }
        float f6 = f4;
        float f7 = f5;
        rectangle2D = this.getBoundingBoxOfFigures(arrayList);
        int n7 = (int)((float)rectangle2D.getWidth() / f6) + 1;
        int n8 = (int)((float)rectangle2D.getHeight() / f7) + 1;
        ArrayList[][] arrayListArray = new ArrayList[n7][n8];
        for (n6 = 0; n6 < n7; ++n6) {
            for (int i = 0; i < n8; ++i) {
                arrayListArray[n6][i] = new ArrayList();
            }
        }
        for (n6 = 0; n6 < arrayList.size(); ++n6) {
            SGFigure sGFigure = arrayList.get(n6);
            Rectangle2D rectangle2D3 = sGFigure.getGraphRect();
            n5 = (int)((rectangle2D3.getCenterX() - rectangle2D.getX()) / (double)f6);
            n4 = (int)((rectangle2D3.getCenterY() - rectangle2D.getY()) / (double)f7);
            arrayListArray[n5][n4].add(sGFigure);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < n7; ++i) {
            boolean bl = false;
            for (n5 = 0; n5 < n8; ++n5) {
                if (arrayListArray[i][n5].size() == 0) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            arrayList2.add(i);
        }
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (n3 = 0; n3 < n8; ++n3) {
            n5 = 0;
            for (n4 = 0; n4 < n7; ++n4) {
                if (arrayListArray[n4][n3].size() == 0) continue;
                n5 = 1;
                break;
            }
            if (n5 == 0) continue;
            arrayList3.add(n3);
        }
        n3 = arrayList2.size();
        n5 = arrayList3.size();
        ArrayList[][] arrayListArray2 = new ArrayList[n3][n5];
        for (int i = 0; i < n3; ++i) {
            int n9 = (Integer)arrayList2.get(i);
            for (int j = 0; j < n5; ++j) {
                int n10 = (Integer)arrayList3.get(j);
                arrayListArray2[i][j] = arrayListArray[n9][n10];
            }
        }
        float[][] fArray = new float[n3][n5];
        float[][] fArray2 = new float[n3][n5];
        float[][] fArray3 = new float[n3][n5];
        float[][] fArray4 = new float[n3][n5];
        for (int i = 0; i < n3; ++i) {
            for (n2 = 0; n2 < n5; ++n2) {
                if (arrayListArray2[i][n2] == null) continue;
                ArrayList arrayList4 = arrayListArray2[i][n2];
                float f8 = 0.0f;
                f3 = 0.0f;
                f2 = 0.0f;
                f = 0.0f;
                for (int j = 0; j < arrayList4.size(); ++j) {
                    SGFigure sGFigure = (SGFigure)arrayList4.get(j);
                    Rectangle2D rectangle2D4 = sGFigure.getGraphRect();
                    SGTuple2f sGTuple2f = new SGTuple2f();
                    cloneable = new SGTuple2f();
                    sGFigure.calcMargin(sGTuple2f, (SGTuple2f)cloneable);
                    if (sGTuple2f.x + (float)rectangle2D4.getHeight() > f8) {
                        f8 = sGTuple2f.x + (float)rectangle2D4.getHeight();
                    }
                    if (sGTuple2f.y > f3) {
                        f3 = sGTuple2f.y;
                    }
                    if (((SGTuple2f)cloneable).x > f2) {
                        f2 = ((SGTuple2f)cloneable).x;
                    }
                    if (!(((SGTuple2f)cloneable).y + (float)rectangle2D4.getWidth() > f)) continue;
                    f = ((SGTuple2f)cloneable).y + (float)rectangle2D4.getWidth();
                }
                fArray[i][n2] = f8;
                fArray2[i][n2] = f3;
                fArray3[i][n2] = f2;
                fArray4[i][n2] = f;
            }
        }
        float[] fArray5 = new float[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            float f9 = 0.0f;
            for (int i = 0; i < n5; ++i) {
                f3 = fArray3[n2][i] + fArray4[n2][i];
                if (!(f3 > f9)) continue;
                f9 = f3;
            }
            fArray5[n2] = f9;
        }
        float[] fArray6 = new float[n5];
        for (int i = 0; i < n5; ++i) {
            float f10 = 0.0f;
            for (int j = 0; j < n3; ++j) {
                f2 = fArray[j][i] + fArray2[j][i];
                if (!(f2 > f10)) continue;
                f10 = f2;
            }
            fArray6[i] = f10;
        }
        float[] fArray7 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            float f11 = 0.0f;
            for (int j = 0; j < n5; ++j) {
                f = fArray3[i][j];
                if (!(f > f11)) continue;
                f11 = f;
            }
            fArray7[i] = f11;
        }
        float[] fArray8 = new float[n5];
        for (int i = 0; i < n5; ++i) {
            float f12 = 0.0f;
            for (int j = 0; j < n3; ++j) {
                float f13 = fArray2[j][i];
                if (!(f13 > f12)) continue;
                f12 = f13;
            }
            fArray8[i] = f12;
        }
        float[] fArray9 = new float[n3];
        float f14 = (float)rectangle2D2.getX();
        for (int i = 0; i < n3; ++i) {
            fArray9[i] = f14 + fArray7[i];
            f14 += fArray5[i];
        }
        float[] fArray10 = new float[n5];
        float f15 = (float)rectangle2D2.getY();
        for (n = 0; n < n5; ++n) {
            fArray10[n] = f15 + fArray6[n] - fArray8[n];
            f15 += fArray6[n];
        }
        n = 1;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n3; ++j) {
                cloneable = arrayListArray2[j][i];
                for (int k = 0; k < ((ArrayList)cloneable).size(); ++k) {
                    SGFigure sGFigure = (SGFigure)((ArrayList)cloneable).get(k);
                    if (sGFigure == null) {
                        n = 0;
                        break;
                    }
                    if (sGFigure.setGraphRectLocationByLeftBottom(fArray9[j], fArray10[i])) continue;
                    return false;
                }
                if (n == 0) break;
            }
            if (n == 0) break;
        }
        return this.setFigureBoundingBox(0);
    }

    private boolean alignFiguresByGraphAreaNew() {
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        if (arrayList.size() == 0) {
            return true;
        }
        ArrayList[][] arrayListArray = this.getFigureListArray();
        if (arrayListArray == null) {
            return false;
        }
        if (arrayListArray.length == 0) {
            return false;
        }
        if (!this.alignFiguresLeftAndBottom(arrayListArray)) {
            return false;
        }
        return this.setFigureBoundingBox(0);
    }

    public boolean alignFiguresByBoundingBox() {
        boolean bl;
        int n;
        int n2;
        float f;
        int n3;
        SGFigure[][] sGFigureArray = this.getOrderedFigureArray();
        if (sGFigureArray == null) {
            return false;
        }
        if (sGFigureArray.length == 0) {
            return true;
        }
        int n4 = sGFigureArray.length;
        int n5 = sGFigureArray[0].length;
        Rectangle2D[][] rectangle2DArray = new Rectangle2D[n4][n5];
        boolean bl2 = true;
        for (int i = 0; i < n4; ++i) {
            for (n3 = 0; n3 < n5; ++n3) {
                if (sGFigureArray[i][n3] == null) {
                    bl2 = false;
                    break;
                }
                rectangle2DArray[i][n3] = sGFigureArray[i][n3].getBoundingBox();
            }
            if (!bl2) break;
        }
        float[] fArray = new float[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            Rectangle2D rectangle2D;
            float f2 = 0.0f;
            for (int i = 0; i < n4 && (rectangle2D = rectangle2DArray[i][n3]) != null; ++i) {
                float f3 = (float)rectangle2DArray[i][n3].getWidth();
                if (!(f3 > f2)) continue;
                f2 = f3;
            }
            fArray[n3] = f2;
        }
        float[] fArray2 = new float[n4];
        for (int i = 0; i < n4; ++i) {
            Rectangle2D rectangle2D;
            float f4 = 0.0f;
            for (int j = 0; j < n5 && (rectangle2D = rectangle2DArray[i][j]) != null; ++j) {
                f = (float)rectangle2DArray[i][j].getHeight();
                if (!(f > f4)) continue;
                f4 = f;
            }
            fArray2[i] = f4;
        }
        Rectangle2D rectangle2D = this.getClientRect();
        float[] fArray3 = new float[n5];
        float f5 = (float)rectangle2D.getX();
        for (int i = 0; i < n5; ++i) {
            fArray3[i] = f5 + fArray[i] / 2.0f;
            f5 += fArray[i];
        }
        float[] fArray4 = new float[n4];
        f = (float)rectangle2D.getY();
        for (n2 = 0; n2 < n4; ++n2) {
            fArray4[n2] = f + fArray2[n2] / 2.0f;
            f += fArray2[n2];
        }
        bl2 = true;
        for (n2 = 0; n2 < n4; ++n2) {
            for (int i = 0; i < n5; ++i) {
                SGFigure sGFigure = sGFigureArray[n2][i];
                if (sGFigure == null) {
                    bl2 = false;
                    break;
                }
                if (sGFigure.setCenter(fArray3[i], fArray4[n2])) continue;
                return false;
            }
            if (!bl2) break;
        }
        n2 = -1;
        float f6 = 0.0f;
        float f7 = 0.0f;
        for (n = 0; n < fArray.length; ++n) {
            f6 += fArray[n];
        }
        for (n = 0; n < fArray2.length; ++n) {
            f7 += fArray2[n];
        }
        Rectangle2D rectangle2D2 = this.getPaperRect();
        boolean bl3 = rectangle2D2.getWidth() < (double)f6;
        boolean bl4 = bl = rectangle2D2.getHeight() < (double)f7;
        if (bl3 && bl) {
            n2 = 0;
        } else if (bl3) {
            n2 = 1;
        } else if (bl) {
            n2 = 2;
        }
        return n2 == -1 || this.setFigureBoundingBox(n2);
    }

    @Override
    public SGProperties getMemento() {
        return this.getProperties();
    }

    @Override
    public boolean setMemento(SGProperties sGProperties) {
        return this.setProperties(sGProperties);
    }

    @Override
    public boolean setMementoBackward() {
        return this.mUndoManager.setMementoBackward();
    }

    @Override
    public boolean setMementoForward() {
        return this.mUndoManager.setMementoForward();
    }

    boolean updateGraphRectOfAllFigures() {
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = arrayList.get(i);
            sGFigure.updateGraphRect();
        }
        return true;
    }

    private boolean updateOnUndo() {
        this.clearAllFocusedObjectsInFigures();
        this.updateClientRect();
        this.updateGraphRectOfAllFigures();
        this.updateUndoItems();
        this.updateItemsByFigureNumbers();
        this.updateDataItem();
        this.updateGridItems();
        this.updateBackgroundImageItems();
        return true;
    }

    @Override
    public boolean undo() {
        if (!this.mUndoManager.undo()) {
            return false;
        }
        this.updateOnUndo();
        this.updateStatusBarSavedFlag();
        return true;
    }

    @Override
    public boolean redo() {
        if (!this.mUndoManager.redo()) {
            return false;
        }
        this.updateOnUndo();
        this.updateStatusBarSavedFlag();
        return true;
    }

    @Override
    public boolean isChanged() {
        return this.mUndoManager.isChanged();
    }

    @Override
    public boolean isChangedRoot() {
        if (this.isChanged()) {
            return true;
        }
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            if (!sGIUndoable.isChangedRoot()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setChanged(boolean bl) {
        this.mUndoManager.setChanged(bl);
    }

    private void updateUndoItems() {
        boolean bl = this.mUndoManager.isUndoable();
        boolean bl2 = this.mUndoManager.isRedoable();
        SGMenuBar sGMenuBar = this.mMenuBar;
        sGMenuBar.setMenuItemEnabled("Edit", "Undo", bl);
        sGMenuBar.setMenuItemEnabled("Edit", "Redo", bl2);
        sGMenuBar.setMenuItemEnabled("Edit", "Clear Undo Buffer", bl || bl2);
        SGToolBar sGToolBar = this.mToolBar;
        sGToolBar.setButtonEnabled("Undo", bl);
        sGToolBar.setButtonEnabled("Redo", bl2);
    }

    @Override
    public void notifyToRoot() {
        if (!this.updateHistoryTree()) {
            throw new Error("Failed to update the history.");
        }
    }

    private boolean updateHistoryTree() {
        if (!this.updateHistory()) {
            return false;
        }
        if (this.isChangedRoot() && !this.deleteForwardHistory()) {
            return false;
        }
        this.clearChanged();
        this.updateUndoItems();
        return true;
    }

    @Override
    public boolean deleteForwardHistory() {
        for (int i = 0; i < this.mFigureList.size(); ++i) {
            SGFigure sGFigure = this.mFigureList.get(i);
            if (sGFigure.deleteForwardHistory()) continue;
            return false;
        }
        if (!this.mUndoManager.deleteForwardHistory()) {
            return false;
        }
        return this.deleteUselessFigures();
    }

    private boolean deleteUselessFigures() {
        Set set = this.getAvailableChildSet();
        boolean bl = false;
        ArrayList<SGFigure> arrayList = new ArrayList<SGFigure>(this.mFigureList);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Object e = arrayList.get(i);
            if (!set.contains(e)) {
                SGFigure sGFigure = (SGFigure)e;
                this.deleteFigure(sGFigure);
                bl = true;
            }
            e = null;
        }
        if (bl) {
            arrayList.clear();
            set.clear();
        }
        return true;
    }

    private void deleteFigure(SGFigure sGFigure) {
        this.mFigureList.remove(sGFigure);
        sGFigure.dispose();
    }

    private boolean createMenuBar() {
        this.mMenuBar = new SGMenuBar();
        this.setJMenuBar(this.mMenuBar);
        this.mMenuBar.addActionListener(this);
        this.mMenuBar.addMenuListener(this);
        return true;
    }

    public boolean exportAsImage(boolean bl) {
        return this.toImage(1, bl);
    }

    public boolean startExport(boolean bl) {
        int n = (int)this.mClientPanel.getPaperWidth();
        int n2 = (int)this.mClientPanel.getPaperHeight();
        InfoForExport infoForExport = new InfoForExport();
        ExportPanel exportPanel = new ExportPanel();
        exportPanel.setOpaque(true);
        exportPanel.setBackground(this.mClientPanel.getPaperColor());
        exportPanel.setPreferredSize(new Dimension(n, n2));
        this.beforeExport(exportPanel, infoForExport, bl);
        this.mExportTarget = exportPanel;
        this.mExportInfo = infoForExport;
        return true;
    }

    public boolean endExport(boolean bl) {
        this.afterExport(this.mExportTarget, this.mExportInfo, bl);
        this.mExportTarget = null;
        this.mExportInfo = null;
        return true;
    }

    public Component getExportTarget() {
        return this.mExportTarget;
    }

    public boolean printImage(boolean bl) {
        return this.toImage(2, bl);
    }

    private boolean toImage(int n, boolean bl) {
        boolean bl2;
        int n2 = (int)this.mClientPanel.getPaperWidth();
        int n3 = (int)this.mClientPanel.getPaperHeight();
        InfoForExport infoForExport = new InfoForExport();
        ExportPanel exportPanel = new ExportPanel();
        exportPanel.setOpaque(true);
        exportPanel.setBackground(this.mClientPanel.getPaperColor());
        exportPanel.setPreferredSize(new Dimension(n2, n3));
        this.beforeExport(exportPanel, infoForExport, bl);
        SGIImageExportManager sGIImageExportManager = this.mImageExportManager;
        switch (n) {
            case 1: {
                bl2 = sGIImageExportManager.export(exportPanel, this, n2, n3, bl);
                break;
            }
            case 2: {
                bl2 = sGIImageExportManager.print(exportPanel, this, n2, n3, bl);
                break;
            }
            default: {
                bl2 = false;
            }
        }
        this.afterExport(exportPanel, infoForExport, bl);
        return bl2;
    }

    private boolean beforeExport(ExportPanel exportPanel, InfoForExport infoForExport, boolean bl) {
        int n;
        Object object;
        Object object2;
        Rectangle2D rectangle2D;
        SGFigure sGFigure;
        int n2;
        Object object3;
        int n3;
        float f = this.mMagnification;
        SGTuple2f sGTuple2f = this.mClientPanel.getScrollRatio();
        float f2 = sGTuple2f.x;
        float f3 = sGTuple2f.y;
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        if (!bl) {
            n3 = 1;
            object3 = this.getPaperRect().getBounds();
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                sGFigure = arrayList.get(n2);
                rectangle2D = sGFigure.getBoundingBox().getBounds();
                if (((Rectangle)object3).contains((Rectangle)rectangle2D)) continue;
                n3 = 0;
                break;
            }
            if (n3 == 0) {
                SGUtility.showMessageDialog(this, "Some figures run off the edge of paper.", "Warning", 2);
            }
        }
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            object3 = arrayList.get(n3);
            ((SGFigure)object3).beforeExport();
        }
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure2 = arrayList.get(i);
            sGTuple2fArray[i] = new SGTuple2f(sGFigure2.mGraphRectX, sGFigure2.mGraphRectY);
        }
        this.zoom(1.0f);
        Rectangle2D rectangle2D2 = this.getClientRect();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            sGFigure = arrayList.get(n2);
            sGFigure.setGraphRectLocation(sGFigure.getGraphRectX() - (float)rectangle2D2.getX(), sGFigure.getGraphRectY() - (float)rectangle2D2.getY());
        }
        float f4 = this.mClientPanel.getPaperWidth();
        float f5 = this.mClientPanel.getPaperHeight();
        exportPanel.setOpaque(false);
        exportPanel.setLocation(0, 0);
        exportPanel.setSize((int)f4, (int)f5);
        rectangle2D = new Rectangle2D.Float(0.0f, 0.0f, f4, f5);
        for (int i = 0; i < arrayList.size(); ++i) {
            object2 = arrayList.get(i);
            exportPanel.add((SGFigure)object2);
            ((SGFigure)object2).setViewBounds(rectangle2D);
        }
        Image image = this.mClientPanel.getImage();
        if (image != null) {
            object2 = this.mClientPanel.getImageLocation();
            object = this.mClientPanel.getImageSize();
            float f6 = this.mClientPanel.getImageScalingFactor();
            exportPanel.setImage(image, ((SGTuple2f)object2).x, ((SGTuple2f)object2).y, ((SGTuple2f)object).x, ((SGTuple2f)object).y, f6);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = arrayList.get(n);
            ((SGFigure)object).setVisible(false);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = arrayList.get(n);
            ((SGFigure)object).setMode(0);
        }
        infoForExport.mag = f;
        infoForExport.hValue = f2;
        infoForExport.vValue = f3;
        infoForExport.locationArray = sGTuple2fArray;
        infoForExport.visibleList = arrayList;
        return true;
    }

    private boolean afterExport(ExportPanel exportPanel, InfoForExport infoForExport, boolean bl) {
        SGFigure sGFigure;
        int n;
        float f = infoForExport.mag;
        float f2 = infoForExport.hValue;
        float f3 = infoForExport.vValue;
        SGTuple2f[] sGTuple2fArray = infoForExport.locationArray;
        ArrayList arrayList = infoForExport.visibleList;
        this.zoom(f);
        this.mClientPanel.setScrollRatio(f3, f2);
        for (n = 0; n < arrayList.size(); ++n) {
            sGFigure = (SGFigure)arrayList.get(n);
            sGFigure.mGraphRectX = sGTuple2fArray[n].x;
            sGFigure.mGraphRectY = sGTuple2fArray[n].y;
            sGFigure.updateGraphRect();
            sGFigure.setViewBounds();
        }
        for (n = 0; n < arrayList.size(); ++n) {
            sGFigure = (SGFigure)arrayList.get(n);
            sGFigure.afterExport();
        }
        this.repaintContentPane();
        return true;
    }

    public Element createElement(Document document) {
        Element element = document.createElement("Window");
        if (!this.writeProperty(element)) {
            return null;
        }
        return element;
    }

    public Element createElementForFocusedFiguresInBoundingBox(Document document) {
        Element element = document.createElement("Window");
        if (!this.writePropertyForFocusedFiguresInBoundingBox(element)) {
            return null;
        }
        return element;
    }

    public boolean createDOMTree(Document document, int n) {
        boolean bl;
        switch (this.mPropertyFileCreationModeOfFigures) {
            case 0: {
                bl = this.createDOMTreeForAllFigures(document, n);
                break;
            }
            case 1: {
                bl = this.createDOMTreeForFocusedFiguresForDuplication(document, n);
                break;
            }
            case 2: {
                bl = this.createDOMTreeForFocusedFiguresInBoundingBox(document, n);
                break;
            }
            case 3: {
                bl = this.createDOMTreeForFocusedFiguresForDuplication(document, n);
                break;
            }
            default: {
                throw new Error();
            }
        }
        return bl;
    }

    public boolean createDOMTree(Document document, int n, int n2) {
        this.mPropertyFileCreationModeOfFigures = n;
        return this.createDOMTree(document, n2);
    }

    private boolean createDOMTreeForAllFigures(Document document, int n) {
        Element element = document.getDocumentElement();
        Element element2 = this.createElement(document);
        if (element2 == null) {
            return false;
        }
        element.appendChild(element2);
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = arrayList.get(i);
            Element element3 = sGFigure.createElement(document, n);
            if (element3 == null) {
                return false;
            }
            element2.appendChild(element3);
        }
        return true;
    }

    boolean createPropertyFileFromFocusedFigures() {
        this.mPropertyFileCreationModeOfFigures = 2;
        this.notifyToListener("Save Property");
        return true;
    }

    private boolean createDOMTreeForFocusedFiguresInBoundingBox(Document document, int n) {
        Element element = document.getDocumentElement();
        Element element2 = this.createElementForFocusedFiguresInBoundingBox(document);
        if (element2 == null) {
            return false;
        }
        element.appendChild(element2);
        List<SGFigure> list = this.getFocusedFigureList();
        for (int i = 0; i < list.size(); ++i) {
            SGFigure sGFigure = list.get(i);
            Element element3 = sGFigure.createElementForFocusedInBoundingBox(document, n);
            if (element3 == null) {
                return false;
            }
            element2.appendChild(element3);
        }
        return true;
    }

    private boolean createDOMTreeForFocusedFiguresForDuplication(Document document, int n) {
        Element element = document.getDocumentElement();
        Element element2 = this.createElement(document);
        if (element2 == null) {
            return false;
        }
        element.appendChild(element2);
        List<SGFigure> list = this.getFocusedFigureList();
        for (int i = 0; i < list.size(); ++i) {
            SGFigure sGFigure = list.get(i);
            Element element3 = sGFigure.createElementForFocusedForDuplication(document, n);
            if (element3 == null) {
                return false;
            }
            element2.appendChild(element3);
        }
        return true;
    }

    public boolean writePropertyForFocusedFiguresInBoundingBox(Element element) {
        Rectangle2D rectangle2D = this.getBoundingBoxOfFigures(this.getFocusedFigureList());
        float f = (float)rectangle2D.getWidth() * 0.035277776f / this.mMagnification;
        float f2 = (float)rectangle2D.getHeight() * 0.035277776f / this.mMagnification;
        element.setAttribute("PaperWidth", Float.toString(f) + "cm");
        element.setAttribute("PaperHeight", Float.toString(f2) + "cm");
        this.writePropertySub(element);
        return true;
    }

    public boolean writeProperty(Element element) {
        float f = (float)SGUtilityNumber.roundOffNumber(this.mClientPanel.getPaperWidth() * 0.035277776f, -2);
        float f2 = (float)SGUtilityNumber.roundOffNumber(this.mClientPanel.getPaperHeight() * 0.035277776f, -2);
        element.setAttribute("PaperWidth", Float.toString(f) + "cm");
        element.setAttribute("PaperHeight", Float.toString(f2) + "cm");
        this.writePropertySub(element);
        return true;
    }

    private boolean writePropertySub(Element element) {
        float f = (float)SGUtilityNumber.roundOffNumber(this.mClientPanel.getGridLineInterval() * 0.035277776f, -2);
        float f2 = (float)SGUtilityNumber.roundOffNumber(this.mClientPanel.getGridLineWidth(), -3);
        element.setAttribute("GridVisible", Boolean.toString(this.mClientPanel.isGridLineVisible()));
        element.setAttribute("GridInterval", Float.toString(f) + "cm");
        element.setAttribute("GridLineWidth", Float.toString(f2) + "pt");
        element.setAttribute("BackgroundColor", SGUtilityText.getColorString(this.mClientPanel.getPaperColor()));
        element.setAttribute("GridLineColor", SGUtilityText.getColorString(this.mClientPanel.getGridLineColor()));
        float f3 = (float)SGUtilityNumber.roundOffNumber(this.mClientPanel.getImageLocationX() * 0.035277776f, -2);
        float f4 = (float)SGUtilityNumber.roundOffNumber(this.mClientPanel.getImageLocationY() * 0.035277776f, -2);
        float f5 = (float)SGUtilityNumber.roundOffNumber(this.mClientPanel.getImageScalingFactor(), -3);
        element.setAttribute("ImageX", Float.toString(f3) + "cm");
        element.setAttribute("ImageY", Float.toString(f4) + "cm");
        element.setAttribute("ImageScale", Float.toString(f5));
        return true;
    }

    public boolean readProperty(Element element, float f, float f2) {
        float f3;
        StringBuffer stringBuffer;
        String string = null;
        Number number = null;
        Boolean bl = null;
        Color color = null;
        float f4 = (f2 - f) / 9.0f;
        SGDrawingWindow sGDrawingWindow = this;
        sGDrawingWindow.setProgressValue(f);
        string = element.getAttribute("PaperWidth");
        if (string.length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f3 = number.floatValue();
            if (!this.mClientPanel.setPaperWidth(f3, stringBuffer.toString())) {
                return false;
            }
        }
        sGDrawingWindow.setProgressValue(f + f4 * 1.0f);
        string = element.getAttribute("PaperHeight");
        if (string.length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f3 = number.floatValue();
            if (!this.mClientPanel.setPaperHeight(f3, stringBuffer.toString())) {
                return false;
            }
        }
        sGDrawingWindow.setProgressValue(f + f4 * 2.0f);
        string = element.getAttribute("GridVisible");
        if (string.length() != 0) {
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            boolean bl2 = bl;
            if (!this.mClientPanel.setGridLineVisible(bl2)) {
                return false;
            }
        }
        sGDrawingWindow.setProgressValue(f + f4 * 3.0f);
        string = element.getAttribute("GridInterval");
        if (string.length() != 0) {
            StringBuffer stringBuffer2 = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer2);
            if (number == null) {
                return false;
            }
            f3 = number.floatValue();
            if (!this.mClientPanel.setGridLineInterval(f3, stringBuffer2.toString())) {
                return false;
            }
        }
        sGDrawingWindow.setProgressValue(f + f4 * 4.0f);
        string = element.getAttribute("GridLineWidth");
        if (string.length() != 0) {
            StringBuffer stringBuffer3 = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer3);
            if (number == null) {
                return false;
            }
            f3 = number.floatValue();
            if (!this.mClientPanel.setGridLineWidth(f3, stringBuffer3.toString())) {
                return false;
            }
        }
        sGDrawingWindow.setProgressValue(f + f4 * 5.0f);
        string = element.getAttribute("BackgroundColor");
        if (string.length() != 0) {
            color = SGUtilityText.parseColor(string);
            if (color == null) {
                return false;
            }
            Color color2 = color;
            if (!this.mClientPanel.setPaperColor(color2)) {
                return false;
            }
        }
        sGDrawingWindow.setProgressValue(f + f4 * 6.0f);
        string = element.getAttribute("GridLineColor");
        if (string.length() != 0) {
            color = SGUtilityText.parseColor(string);
            if (color == null) {
                return false;
            }
            Color color3 = color;
            if (!this.mClientPanel.setGridLineColor(color3)) {
                return false;
            }
        }
        sGDrawingWindow.setProgressValue(f + f4 * 7.0f);
        string = element.getAttribute("ImageX");
        if (string.length() != 0) {
            StringBuffer stringBuffer4 = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer4);
            if (number == null) {
                return false;
            }
            f3 = number.floatValue();
            if (!this.mClientPanel.setImageLocationX(f3, stringBuffer4.toString())) {
                return false;
            }
        }
        sGDrawingWindow.setProgressValue(f + f4 * 8.0f);
        string = element.getAttribute("ImageY");
        if (string.length() != 0) {
            StringBuffer stringBuffer5 = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer5);
            if (number == null) {
                return false;
            }
            f3 = number.floatValue();
            if (!this.mClientPanel.setImageLocationY(f3, stringBuffer5.toString())) {
                return false;
            }
        }
        sGDrawingWindow.setProgressValue(f2);
        string = element.getAttribute("ImageScale");
        if (string.length() != 0) {
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return false;
            }
            float f5 = number.floatValue();
            if (!this.mClientPanel.setImageScalingFactor(f5)) {
                return false;
            }
        }
        return true;
    }

    boolean showPropertyDialogForSelectedFigures() {
        Object object;
        List<SGFigure> list = this.getFocusedFigureList();
        ArrayList<SGPropertyDialog> arrayList = new ArrayList<SGPropertyDialog>();
        for (int i = 0; i < list.size(); ++i) {
            SGFigure sGFigure = list.get(i);
            object = sGFigure.getPropertyDialog();
            if (object == null) continue;
            arrayList.add((SGPropertyDialog)object);
        }
        List<SGFigure> list2 = this.mFigureList;
        for (int i = 0; i < list2.size(); ++i) {
            object = list2.get(i);
            ((SGFigure)object).clearFocusedObjects();
        }
        SGPropertyDialog sGPropertyDialog = (SGPropertyDialog)arrayList.get(0);
        object = new ArrayList();
        object.addAll(list);
        this.showPropertyDialog(sGPropertyDialog, (List<SGIPropertyDialogObserver>)object);
        return true;
    }

    boolean showPropertyDialogForSelectedObjects(SGFigure sGFigure, SGIFigureElement sGIFigureElement) {
        ArrayList arrayList;
        SGIDrawingElementConstants sGIDrawingElementConstants;
        SGIPropertyDialogObserver sGIPropertyDialogObserver;
        int n;
        Object object;
        ArrayList<SGFigure> arrayList2 = this.getVisibleFigureList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            object = arrayList2.get(i);
            ((SGFigure)object).clearFocusedObjects(sGIFigureElement);
            if (object.equals(sGFigure)) continue;
            ((SGFigure)object).setSelected(false);
        }
        this.repaintContentPane();
        ArrayList<SGIPropertyDialogObserver> arrayList3 = new ArrayList<SGIPropertyDialogObserver>();
        object = new ArrayList();
        Class<?> clazz = sGIFigureElement.getClass();
        for (n = 0; n < arrayList2.size(); ++n) {
            sGIPropertyDialogObserver = arrayList2.get(n);
            sGIDrawingElementConstants = ((SGFigure)sGIPropertyDialogObserver).getIFigureElement(clazz);
            if (sGIDrawingElementConstants == null || (arrayList = sGIDrawingElementConstants.getPropertyDialogObserverList()).size() == 0) continue;
            arrayList3.addAll(arrayList);
        }
        if (arrayList3.size() == 0) {
            return false;
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            sGIPropertyDialogObserver = (SGIPropertyDialogObserver)arrayList3.get(n);
            sGIDrawingElementConstants = sGIPropertyDialogObserver.getPropertyDialog();
            ((ArrayList)object).add(sGIDrawingElementConstants);
        }
        if (((ArrayList)object).size() == 0) {
            return false;
        }
        for (n = 0; n < ((ArrayList)object).size() - 1; ++n) {
            sGIPropertyDialogObserver = ((ArrayList)object).get(n);
            for (int i = n; i < ((ArrayList)object).size(); ++i) {
                arrayList = ((ArrayList)object).get(i);
                if (sGIPropertyDialogObserver.getClass().equals(arrayList.getClass())) continue;
                SGUtility.showMessageDialog(this, "Data type is different.", "Failed to show the property dialog.", 2);
                return false;
            }
        }
        SGPropertyDialog sGPropertyDialog = (SGPropertyDialog)((ArrayList)object).get(0);
        this.showPropertyDialog(sGPropertyDialog, arrayList3);
        return true;
    }

    private void showPropertyDialog(SGPropertyDialog sGPropertyDialog, SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        ArrayList<SGIPropertyDialogObserver> arrayList = new ArrayList<SGIPropertyDialogObserver>();
        arrayList.add(sGIPropertyDialogObserver);
        this.showPropertyDialog(sGPropertyDialog, arrayList);
    }

    public boolean isModalDialogShown() {
        return this.mModalDialogShownFlag;
    }

    public void setModalDialogShown(boolean bl) {
        this.mModalDialogShownFlag = bl;
    }

    public boolean closeTextField() {
        ArrayList<SGFigure> arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (sGFigure.closeTextField()) continue;
            return false;
        }
        return true;
    }

    private void showPropertyDialog(SGPropertyDialog sGPropertyDialog, List<SGIPropertyDialogObserver> list) {
        int n;
        for (n = 0; n < list.size(); ++n) {
            SGIPropertyDialogObserver sGIPropertyDialogObserver = list.get(n);
            sGPropertyDialog.addPropertyDialogObserver(sGIPropertyDialogObserver);
            sGIPropertyDialogObserver.prepare();
        }
        sGPropertyDialog.setDialogProperty();
        sGPropertyDialog.setLocation(this.getLocation());
        sGPropertyDialog.setVisible(true);
        sGPropertyDialog.removeAllPropertyDialogObserver();
        n = sGPropertyDialog.getCloseOption();
        if (n == 0) {
            this.notifyToRoot();
        }
    }

    public void setSaved(boolean bl) {
        if (bl) {
            this.mSavedListIndex = this.mUndoManager.getChangedObjectListIndex();
        }
        this.updateStatusBarSavedFlag();
    }

    public boolean isSaved() {
        return this.mSavedListIndex == this.mUndoManager.getChangedObjectListIndex();
    }

    @Override
    public float getPaperWidth(String string) {
        return this.mClientPanel.getPaperWidth(string);
    }

    @Override
    public float getPaperHeight(String string) {
        return this.mClientPanel.getPaperHeight(string);
    }

    @Override
    public float getGridLineInterval(String string) {
        return this.mClientPanel.getGridLineInterval(string);
    }

    @Override
    public float getGridLineWidth(String string) {
        return this.mClientPanel.getGridLineWidth(string);
    }

    @Override
    public boolean isGridLineVisible() {
        return this.mClientPanel.isGridLineVisible();
    }

    @Override
    public Color getPaperColor() {
        return this.mClientPanel.getPaperColor();
    }

    @Override
    public Color getGridLineColor() {
        return this.mClientPanel.getGridLineColor();
    }

    public float getImageLocationX() {
        return this.mClientPanel.getImageLocationX();
    }

    @Override
    public float getImageLocationX(String string) {
        return this.mClientPanel.getImageLocationX(string);
    }

    public float getImageLocationY() {
        return this.mClientPanel.getImageLocationY();
    }

    @Override
    public float getImageLocationY(String string) {
        return this.mClientPanel.getImageLocationY(string);
    }

    public float getImageWidth() {
        return this.mClientPanel.getImageWidth();
    }

    @Override
    public float getImageWidth(String string) {
        return this.mClientPanel.getImageWidth(string);
    }

    public float getImageHeight() {
        return this.mClientPanel.getImageHeight();
    }

    @Override
    public float getImageHeight(String string) {
        return this.mClientPanel.getImageHeight(string);
    }

    @Override
    public float getImageScalingFactor() {
        return this.mClientPanel.getImageScalingFactor();
    }

    @Override
    public boolean setPaperWidth(float f, String string) {
        return this.mClientPanel.setPaperWidth(f, string);
    }

    @Override
    public boolean setPaperHeight(float f, String string) {
        return this.mClientPanel.setPaperHeight(f, string);
    }

    @Override
    public boolean setGridLineInterval(float f, String string) {
        return this.mClientPanel.setGridLineInterval(f, string);
    }

    @Override
    public boolean setGridLineWidth(float f, String string) {
        return this.mClientPanel.setGridLineWidth(f, string);
    }

    @Override
    public boolean setGridLineVisible(boolean bl) {
        return this.mClientPanel.setGridLineVisible(bl);
    }

    @Override
    public boolean setPaperColor(Color color) {
        return this.mClientPanel.setPaperColor(color);
    }

    @Override
    public boolean setGridLineColor(Color color) {
        return this.mClientPanel.setGridLineColor(color);
    }

    @Override
    public boolean setImageLocationX(float f, String string) {
        return this.mClientPanel.setImageLocationX(f, string);
    }

    @Override
    public boolean setImageLocationY(float f, String string) {
        return this.mClientPanel.setImageLocationY(f, string);
    }

    @Override
    public boolean setImageScalingFactor(float f) {
        return this.mClientPanel.setImageScalingFactor(f);
    }

    public void doSplitMultipleData() {
        this.notifyToListener("Split");
        this.notifyToRoot();
        this.updateFocusedObjectItem();
        this.repaintContentPane();
    }

    public void doTransformData() {
        this.notifyToListener("Transform");
        this.notifyToRoot();
        this.updateFocusedObjectItem();
        this.repaintContentPane();
    }

    public void doMergeMultipleData() {
        this.notifyToListener("Merge");
        this.notifyToRoot();
        this.updateFocusedObjectItem();
        this.repaintContentPane();
    }

    void doOutputDataToFile(SGData sGData) {
        SGPluginsQueryMessage sGPluginsQueryMessage = new SGPluginsQueryMessage("ExecOutputToFile");
        sGPluginsQueryMessage.set(sGData);
        this.notifyToListener("ExecOutputToFile", sGPluginsQueryMessage);
    }

    void doUndoAndDeleteForward() {
        this.undo();
        this.deleteForwardHistory();
        this.updateUndoItems();
        this.repaintContentPane();
    }

    public BackgroundImage getBackgroundImage() {
        return this.mBackgroundImage;
    }

    static {
        float f = (float)SGUtilityNumber.getPowersOfTen(-1);
        BOUNDING_BOX_MARGIN = f / 0.035277776f;
    }

    public static class BackgroundImage {
        private String mExtension = null;
        private byte[] mByteArray = null;

        public BackgroundImage(String string, byte[] byArray) {
            if (string == null || byArray == null) {
                throw new IllegalArgumentException("ext == null || b == null");
            }
            this.mExtension = string;
            this.mByteArray = Arrays.copyOf(byArray, byArray.length);
        }

        public String getExtension() {
            return this.mExtension;
        }

        public byte[] getByteArray() {
            return this.mByteArray;
        }
    }

    public static class WindowProperties
    extends SGProperties {
        private ArrayList mVisibleFigureList = new ArrayList();
        private float mPaperWidth;
        private float mPaperHeight;
        private Color mBackgroundColor;
        private boolean mGridVisible;
        private Color mGridColor;
        private float mGridInverval;
        private float mGridLineWidth;
        private float mImageLocationX;
        private float mImageLocationY;
        private float mImageScalingFactor;
        private Image mImage;

        public void dispose() {
            super.dispose();
            this.mVisibleFigureList.clear();
            this.mVisibleFigureList = null;
            this.mBackgroundColor = null;
            this.mGridColor = null;
            this.mImage = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof WindowProperties)) {
                return false;
            }
            WindowProperties windowProperties = (WindowProperties)object;
            if (!windowProperties.mVisibleFigureList.equals(this.mVisibleFigureList)) {
                return false;
            }
            if (windowProperties.mPaperWidth != this.mPaperWidth) {
                return false;
            }
            if (windowProperties.mPaperHeight != this.mPaperHeight) {
                return false;
            }
            if (!windowProperties.mBackgroundColor.equals(this.mBackgroundColor)) {
                return false;
            }
            if (windowProperties.mGridVisible != this.mGridVisible) {
                return false;
            }
            if (!windowProperties.mGridColor.equals(this.mGridColor)) {
                return false;
            }
            if (windowProperties.mGridInverval != this.mGridInverval) {
                return false;
            }
            if (windowProperties.mGridLineWidth != this.mGridLineWidth) {
                return false;
            }
            if (windowProperties.mImageLocationX != this.mImageLocationX) {
                return false;
            }
            if (windowProperties.mImageLocationY != this.mImageLocationY) {
                return false;
            }
            if (windowProperties.mImageScalingFactor != this.mImageScalingFactor) {
                return false;
            }
            return !(windowProperties.mImage != null ? !windowProperties.mImage.equals(this.mImage) : this.mImage != null);
        }

        public List getVisibleFigureList() {
            ArrayList arrayList = new ArrayList(this.mVisibleFigureList);
            return arrayList;
        }

        public Float getPaperWidth() {
            return Float.valueOf(this.mPaperWidth);
        }

        public Float getPaperHeight() {
            return Float.valueOf(this.mPaperHeight);
        }

        public Color getBackgroundColor() {
            return this.mBackgroundColor;
        }

        public Color getGridColor() {
            return this.mGridColor;
        }

        public Boolean getGridVisible() {
            return this.mGridVisible;
        }

        public Float getGridInterval() {
            return Float.valueOf(this.mGridInverval);
        }

        public Float getGridLineWidth() {
            return Float.valueOf(this.mGridLineWidth);
        }

        public Float getImageLocationX() {
            return Float.valueOf(this.mImageLocationX);
        }

        public Float getImageLocationY() {
            return Float.valueOf(this.mImageLocationY);
        }

        public Float getImageScalingFactor() {
            return Float.valueOf(this.mImageScalingFactor);
        }

        public Image getImage() {
            return this.mImage;
        }

        public void setVisibleFigureList(List list) {
            if (list == null) {
                throw new IllegalArgumentException("list==null");
            }
            this.mVisibleFigureList = new ArrayList(list);
        }

        public void setPaperWidth(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("w<0.0f");
            }
            this.mPaperWidth = f;
        }

        public void setPaperHeight(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("h<0.0f");
            }
            this.mPaperHeight = f;
        }

        public void setBackGroundColor(Color color) {
            if (color == null) {
                throw new IllegalArgumentException("cl==null");
            }
            this.mBackgroundColor = color;
        }

        public void setGridColor(Color color) {
            if (color == null) {
                throw new IllegalArgumentException("cl==null");
            }
            this.mGridColor = color;
        }

        public void setGridVisible(boolean bl) {
            this.mGridVisible = bl;
        }

        public void setGridInterval(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("num<0.0f");
            }
            this.mGridInverval = f;
        }

        public void setGridLineWidth(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("num<0.0f");
            }
            this.mGridLineWidth = f;
        }

        public boolean setImageLocationX(float f) {
            this.mImageLocationX = f;
            return true;
        }

        public boolean setImageLocationY(float f) {
            this.mImageLocationY = f;
            return true;
        }

        public boolean setImageScalingFactor(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("num<0.0f");
            }
            this.mImageScalingFactor = f;
            return true;
        }

        public boolean setImage(Image image) {
            this.mImage = image;
            return true;
        }
    }

    public static class ExportPanel
    extends JPanel {
        private static final long serialVersionUID = 6760038313006131448L;
        private ArrayList mFigureList = new ArrayList();
        private boolean mClipFlag = true;
        private SGImage mImage = null;

        private ExportPanel() {
        }

        private void add(SGFigure sGFigure) {
            ArrayList arrayList = this.mFigureList;
            arrayList.add(sGFigure);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.mImage != null) {
                this.mImage.drawImage(graphics);
            }
            ArrayList arrayList = this.mFigureList;
            boolean bl = this.getClipFlag();
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                sGFigure.paint(graphics, bl);
            }
        }

        public boolean getClipFlag() {
            return this.mClipFlag;
        }

        public void setClipFlag(boolean bl) {
            this.mClipFlag = bl;
        }

        public SGImage getImage() {
            return this.mImage;
        }

        public SGTuple2f getImageSize() {
            return this.mImage.getImageSize();
        }

        public SGTuple2f getImageLocation() {
            return this.mImage.getImageLocation();
        }

        public boolean setImage(Image image, float f, float f2, float f3, float f4, float f5) {
            this.mImage = new SGImage(image, this, f, f2, f3, f4);
            this.mImage.setScalingFactor(f5);
            return true;
        }
    }

    private static class InfoForExport {
        float mag;
        float hValue;
        float vValue;
        SGTuple2f[] locationArray;
        ArrayList visibleList;

        private InfoForExport() {
        }
    }

    static class NodeMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 8728676638490853269L;
        SGINode node;

        NodeMenuItem(String string) {
            super(string);
        }

        SGINode getNode() {
            return this.node;
        }

        void setNode(SGINode sGINode) {
            this.node = sGINode;
        }
    }

    private class TreeMenuItemListener
    implements ActionListener {
        private TreeMenuItemListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            NodeMenuItem nodeMenuItem = (NodeMenuItem)object;
            SGINode sGINode = nodeMenuItem.node;
            SGIPropertyDialogObserver sGIPropertyDialogObserver = (SGIPropertyDialogObserver)((Object)sGINode);
            SGPropertyDialog sGPropertyDialog = sGIPropertyDialogObserver.getPropertyDialog();
            SGDrawingWindow.this.showPropertyDialog(sGPropertyDialog, sGIPropertyDialogObserver);
        }
    }
}

