/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;

public abstract class SGColorBarModel
implements Cloneable,
SGIDisposable {
    protected SGAxis mAxis = null;
    protected Color[] mColors = null;
    protected boolean mReversedOrderFlag = false;
    private boolean mDisposed = false;

    public SGColorBarModel() {
        this.init();
    }

    public SGColorBarModel(Color[] colorArray) {
        if (colorArray == null) {
            throw new IllegalArgumentException("Color array is null.");
        }
        if (colorArray.length == 0) {
            throw new IllegalArgumentException("Length of a given color array is zero.");
        }
        for (int i = 0; i < colorArray.length; ++i) {
            if (colorArray[i] != null) continue;
            throw new IllegalArgumentException("Null value is included in a given array: " + i);
        }
        this.mColors = (Color[])colorArray.clone();
        this.init();
    }

    private void init() {
        this.mReversedOrderFlag = false;
        this.mAxis = new SGAxis(0.0, 1.0);
    }

    public void dispose() {
        this.mDisposed = true;
        this.mColors = null;
    }

    public boolean isDisposed() {
        return this.mDisposed;
    }

    public final Object clone() {
        try {
            SGColorBarModel sGColorBarModel = (SGColorBarModel)super.clone();
            sGColorBarModel.mAxis = (SGAxis)this.mAxis.clone();
            if (this.mColors != null) {
                sGColorBarModel.mColors = (Color[])this.mColors.clone();
            }
            return sGColorBarModel;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public SGAxis getAxis() {
        return this.mAxis;
    }

    public double getMinValue() {
        return this.mAxis.getMinValue();
    }

    public double getMaxValue() {
        return this.mAxis.getMaxValue();
    }

    public int getScaleType() {
        return this.mAxis.getScaleType();
    }

    public boolean isInvertCoordinates() {
        return this.mAxis.isInvertCoordinates();
    }

    public void setValueRange(double d, double d2) {
        this.setValueRange(d, d2, this.mAxis.getScaleType());
    }

    public void setValueRange(double d, double d2, int n) {
        this.mAxis.setScale(d, d2, n);
    }

    public void setInvertCoordinates(boolean bl) {
        this.mAxis.setInvertCoordinates(bl);
    }

    public Color[] getColors() {
        if (this.mColors != null) {
            return (Color[])this.mColors.clone();
        }
        return null;
    }

    public boolean isReversedOrder() {
        return this.mReversedOrderFlag;
    }

    public void setReversedOrder(boolean bl) {
        this.mReversedOrderFlag = bl;
    }

    public Color evaluate(double d) {
        int n = this.getScaleType();
        return this.evaluate(d, n);
    }

    public Color evaluate(double d, int n) {
        double d2;
        double d3;
        double d4;
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new IllegalArgumentException("Invalid input value: " + d);
        }
        double d5 = this.getMinValue();
        double d6 = this.getMaxValue();
        switch (n) {
            case 0: {
                d4 = d;
                d3 = d5;
                d2 = d6;
                break;
            }
            case 1: {
                if (d <= 0.0) {
                    throw new IllegalArgumentException("Not positive value for log scale: " + d);
                }
                d4 = Math.log10(d);
                d3 = Math.log10(d5);
                d2 = Math.log10(d6);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scale type: " + n);
            }
        }
        double d7 = (d4 - d3) / (d2 - d3);
        return this.eval(d7);
    }

    protected Color getColor(int n) {
        if (this.mReversedOrderFlag) {
            return this.mColors[this.mColors.length - 1 - n];
        }
        return this.mColors[n];
    }

    public abstract Color eval(double var1);
}

