/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import jp.riken.brain.ni.samuraigraph.base.SGITextDataConstants;

public class SGCSVTokenizer
implements Enumeration,
SGITextDataConstants {
    private String record;
    private int currentIndex;
    private boolean is_csv_mode = false;
    private boolean is_comment_line = false;
    private static List<Character> mWhiteSpaceList;
    private static final String[] COMMENT_HEADER_CONSTANTS;
    private static final String[] mCommentHeaders;

    public SGCSVTokenizer(String string, boolean bl) {
        int n;
        int n2;
        this.record = string.trim();
        this.currentIndex = 0;
        if (bl && this.record.startsWith("#")) {
            this.is_comment_line = true;
            for (n2 = 0; n2 < mCommentHeaders.length; ++n2) {
                this.record = this.record.substring("#".length());
                n = mCommentHeaders[n2].length();
                if (!this.record.startsWith(mCommentHeaders[n2]) || this.record.length() == n) continue;
                this.is_comment_line = false;
                this.record = this.record.substring(n);
                break;
            }
        }
        n = 0;
        for (int i = 0; i < this.record.length(); ++i) {
            n2 = this.record.charAt(i);
            if (n != 0) {
                if (n2 != 34) continue;
                n = 0;
                continue;
            }
            if (n2 == 34) {
                n = 1;
                continue;
            }
            if (n2 != 44) continue;
            this.is_csv_mode = true;
        }
    }

    public boolean hasMoreTokens() {
        if (this.is_comment_line) {
            return false;
        }
        return this.currentIndex >= 0;
    }

    public Token nextToken() throws NoSuchElementException, IllegalArgumentException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        boolean bl = false;
        if (!this.hasMoreTokens()) {
            throw new NoSuchElementException();
        }
        if (this.record.startsWith("\"", this.currentIndex)) {
            int n;
            String string2 = this.record.substring(this.currentIndex + 1);
            bl = true;
            while (true) {
                if ((n = string2.indexOf("\"")) < 0) {
                    throw new IllegalArgumentException("Illegal format");
                }
                if (!string2.startsWith("\"", n + 1)) break;
                stringBuffer.append(string2.substring(0, n + 1));
                string2 = string2.substring(n + 2);
                ++this.currentIndex;
            }
            stringBuffer.append(string2.substring(0, n));
            this.currentIndex += stringBuffer.length() + 2;
            if (this.is_csv_mode) {
                this.currentIndex = this.nextTokenIndexOf(this.currentIndex);
            }
            ++this.currentIndex;
            this.currentIndex = this.nextTokenIndexOf(this.currentIndex);
            if (this.currentIndex >= this.record.length()) {
                this.currentIndex = -1;
            }
            string = stringBuffer.toString();
        } else {
            int n = this.currentIndex;
            int n2 = this.is_csv_mode ? this.record.indexOf(",", this.currentIndex) : this.nextSeparatorIndexOf(this.currentIndex);
            if (n2 >= 0) {
                stringBuffer.append(this.record.substring(n, n2));
                int n3 = this.is_csv_mode ? 1 : 0;
                this.currentIndex = this.nextTokenIndexOf(n2 + n3);
                if (this.currentIndex == this.record.length()) {
                    boolean bl2 = true;
                    if (this.is_csv_mode && this.record.charAt(this.currentIndex - 1) == ',') {
                        bl2 = false;
                    }
                    if (bl2) {
                        this.currentIndex = -1;
                    }
                }
            } else {
                if (this.currentIndex != this.record.length()) {
                    stringBuffer.append(this.record.substring(n));
                }
                this.currentIndex = -1;
            }
            string = stringBuffer.toString();
            string = string.trim();
        }
        return new Token(string, bl);
    }

    private int nextSeparatorIndexOf(int n) {
        char c;
        int n2;
        int n3 = 0;
        int n4 = this.record.length();
        if (n4 == n) {
            return -1;
        }
        for (n2 = n; n2 < n4 && !mWhiteSpaceList.contains(Character.valueOf(c = this.record.charAt(n2))); ++n2) {
            ++n3;
        }
        if (n2 == n4) {
            return -1;
        }
        return n3 + n;
    }

    private int nextTokenIndexOf(int n) {
        char c;
        int n2 = 0;
        int n3 = this.record.length();
        for (int i = n; i < n3 && mWhiteSpaceList.contains(Character.valueOf(c = this.record.charAt(i))); ++i) {
            ++n2;
        }
        return n2 + n;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public static void main(String[] stringArray) {
        String string = "   \"  \"\"  aa a\"\" \"  ,  \" \"\"bb\"\"b  \"\"  \" ,  \" \"\" c c ,c\"\" \"  ";
        System.out.println("#" + string + "#");
        SGCSVTokenizer sGCSVTokenizer = new SGCSVTokenizer(string, true);
        while (sGCSVTokenizer.hasMoreTokens()) {
            Token token = sGCSVTokenizer.nextToken();
            System.out.println("*" + token.getString() + "*");
        }
    }

    static {
        int n;
        mWhiteSpaceList = new ArrayList<Character>();
        COMMENT_HEADER_CONSTANTS = new String[]{"NAC"};
        for (n = 0; n < " \t\n\r\f".length(); ++n) {
            mWhiteSpaceList.add(Character.valueOf(" \t\n\r\f".charAt(n)));
        }
        mCommentHeaders = new String[COMMENT_HEADER_CONSTANTS.length];
        for (n = 0; n < COMMENT_HEADER_CONSTANTS.length; ++n) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<");
            stringBuffer.append(COMMENT_HEADER_CONSTANTS[n]);
            stringBuffer.append(">");
            SGCSVTokenizer.mCommentHeaders[n] = stringBuffer.toString();
        }
    }

    public static class Token {
        private String string;
        private boolean doubleQuoted;

        public Token(String string, boolean bl) {
            this.string = string;
            this.doubleQuoted = bl;
        }

        public String toString() {
            return this.getString();
        }

        public String getString() {
            return this.string;
        }

        public boolean isDoubleQuoted() {
            return this.doubleQuoted;
        }
    }
}

