/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;

public class SGAxis
implements Cloneable {
    public static final int LINEAR_SCALE = 0;
    public static final int LOG_SCALE = 1;
    private int mScaleType = 0;
    private double mMinValue;
    private double mMaxValue;
    private boolean mInvertCoordinates = false;

    public SGAxis(double d, double d2) {
        this(d, d2, 0);
    }

    public SGAxis(double d, double d2, int n) {
        this.setScale(d, d2, n);
    }

    public SGAxis(SGTuple2d sGTuple2d) {
        this(sGTuple2d, 0);
    }

    public SGAxis(SGTuple2d sGTuple2d, int n) {
        this.setScale(sGTuple2d.x, sGTuple2d.y, n);
    }

    public boolean setInvertCoordinates(boolean bl) {
        this.mInvertCoordinates = bl;
        return true;
    }

    public boolean setScale(double d, double d2) {
        return this.setScale(d, d2, this.getScaleType());
    }

    public boolean setScale(SGTuple2d sGTuple2d) {
        if (sGTuple2d == null) {
            throw new IllegalArgumentException("range == null");
        }
        return this.setScale(sGTuple2d.x, sGTuple2d.y, this.getScaleType());
    }

    public boolean setScale(SGTuple2d sGTuple2d, int n) {
        if (sGTuple2d == null) {
            throw new IllegalArgumentException("range == null");
        }
        return this.setScale(sGTuple2d.x, sGTuple2d.y, n);
    }

    public boolean setScale(double d, double d2, int n) {
        if (!SGAxis.isValidScaleType(n)) {
            throw new IllegalArgumentException("Invalid scale type: " + n);
        }
        if (d >= d2) {
            throw new IllegalArgumentException("minValue >= maxValue: " + d + " >= " + d2);
        }
        if (!SGAxis.isValidValue(d, n) || !SGAxis.isValidValue(d2, n)) {
            throw new IllegalArgumentException("Input values are invalid in a given scale type.");
        }
        this.mScaleType = n;
        this.mMinValue = d;
        this.mMaxValue = d2;
        return true;
    }

    public double getMinValue() {
        return this.mMinValue;
    }

    public double getMaxValue() {
        return this.mMaxValue;
    }

    public boolean isInvertCoordinates() {
        return this.mInvertCoordinates;
    }

    public SGTuple2d getRange() {
        return new SGTuple2d(this.mMinValue, this.mMaxValue);
    }

    public int getScaleType() {
        return this.mScaleType;
    }

    public boolean insideRange(double d) {
        return this.mMinValue <= d && d <= this.mMaxValue;
    }

    public boolean isValidValue(double d) {
        return SGAxis.isValidValue(d, this.getScaleType());
    }

    public static boolean isValidValue(double d, int n) {
        return n != 1 || !(d <= 0.0);
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static boolean isValidScaleType(int n) {
        return 0 == n || 1 == n;
    }
}

