/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;

public abstract class SGWizardDialog
extends SGDialog {
    private static final long serialVersionUID = -3377714626195028234L;
    private SGWizardDialog mPreviousWizardDialog = null;
    private SGWizardDialog mNextWizardDialog = null;

    public SGWizardDialog() {
        this.init();
    }

    public SGWizardDialog(Frame frame) {
        super(frame);
        this.init();
    }

    public SGWizardDialog(Frame frame, String string) {
        super(frame, string);
        this.init();
    }

    public SGWizardDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.init();
    }

    public SGWizardDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.init();
    }

    public SGWizardDialog(Dialog dialog) {
        super(dialog);
        this.init();
    }

    public SGWizardDialog(Dialog dialog, String string) {
        super(dialog, string);
        this.init();
    }

    public SGWizardDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.init();
    }

    public SGWizardDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
        this.init();
    }

    private void init() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SGWizardDialog.this.getPreviousButton().addActionListener(SGWizardDialog.this);
                SGWizardDialog.this.getNextButton().addActionListener(SGWizardDialog.this);
                SGWizardDialog.this.getOKButton().addActionListener(SGWizardDialog.this);
                SGWizardDialog.this.getCancelButton().addActionListener(SGWizardDialog.this);
            }
        });
    }

    protected void onEscKeyTyped() {
        this.onCanceled();
    }

    public SGWizardDialog getPrevious() {
        return this.mPreviousWizardDialog;
    }

    public SGWizardDialog getNext() {
        return this.mNextWizardDialog;
    }

    public boolean setPrevious(SGWizardDialog sGWizardDialog) {
        this.mPreviousWizardDialog = sGWizardDialog;
        boolean bl = sGWizardDialog != null;
        this.getPreviousButton().setVisible(bl);
        return true;
    }

    public boolean setNext(SGWizardDialog sGWizardDialog) {
        this.mNextWizardDialog = sGWizardDialog;
        boolean bl = sGWizardDialog != null;
        this.getNextButton().setVisible(bl);
        return true;
    }

    public void windowClosing(WindowEvent windowEvent) {
        super.windowClosing(windowEvent);
        this.close(windowEvent);
    }

    protected void close(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object.equals(this)) {
            this.onCanceled();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.getOKButton())) {
            this.onOK();
        } else if (object.equals(this.getCancelButton())) {
            this.onCanceled();
        } else if (object.equals(this.getPreviousButton())) {
            this.onPrevious();
        } else if (object.equals(this.getNextButton())) {
            this.onNext();
        }
    }

    protected boolean onOK() {
        this.setCloseOption(0);
        this.setVisible(false);
        this.notifyToListener("OK");
        return true;
    }

    protected boolean onCanceled() {
        this.setCloseOption(1);
        this.setVisible(false);
        this.notifyToListener("Cancel");
        return true;
    }

    protected boolean onPrevious() {
        this.notifyToListener("<Prev");
        return true;
    }

    protected boolean onNext() {
        this.notifyToListener("Next>");
        return true;
    }

    public void showNext() {
        SGWizardDialog sGWizardDialog = this.getNext();
        if (sGWizardDialog != null) {
            this.setVisible(false);
            sGWizardDialog.setCenter(this);
            sGWizardDialog.setVisible(true);
        }
    }

    public void showPrevious() {
        SGWizardDialog sGWizardDialog = this.getPrevious();
        if (sGWizardDialog != null) {
            this.setVisible(false);
            sGWizardDialog.setCenter(this);
            sGWizardDialog.setVisible(true);
        }
    }

    public void setVisible(boolean bl) {
        Window window;
        if (bl && (window = this.getOwner()) == null) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = (dimension.width - n) / 2;
            int n4 = (dimension.height - n2) / 2;
            this.setLocation(n3, n4);
        }
        super.setVisible(bl);
    }

    protected abstract JButton getPreviousButton();

    protected abstract JButton getNextButton();

    protected abstract JButton getOKButton();

    protected abstract JButton getCancelButton();
}

