/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import jp.riken.brain.ni.samuraigraph.application.SGNetCDFDataFileChooserPanel;
import jp.riken.brain.ni.samuraigraph.application.SGSingleFileChooserWizardDialog;
import jp.riken.brain.ni.samuraigraph.base.SGButton;

public class SGSingleDataFileChooserWizardDialog
extends SGSingleFileChooserWizardDialog
implements SGNetCDFDataFileChooserPanel.AcceptListener {
    private static final long serialVersionUID = -2452728212046081393L;
    public static final String TITLE = "Select the Data File";
    private JPanel mButtonPanel;
    private SGButton mCancelButton;
    private SGNetCDFDataFileChooserPanel mNetCDFDataFileChooserPanel;
    private SGButton mNextButton;
    private SGButton mOKButton;
    private SGButton mPreviousButton;

    public SGSingleDataFileChooserWizardDialog() {
        this.initComponents();
        this.initProperty();
    }

    public SGSingleDataFileChooserWizardDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mButtonPanel = new JPanel();
        this.mPreviousButton = new SGButton();
        this.mNextButton = new SGButton();
        this.mOKButton = new SGButton();
        this.mCancelButton = new SGButton();
        this.mNetCDFDataFileChooserPanel = new SGNetCDFDataFileChooserPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mPreviousButton.setText("<Prev");
        this.mPreviousButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mPreviousButton);
        this.mNextButton.setText("Next>");
        this.mNextButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mNextButton);
        this.mOKButton.setText("OK");
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mCancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.getContentPane().add((Component)this.mNetCDFDataFileChooserPanel, gridBagConstraints);
        this.pack();
    }

    private void initProperty() {
        this.setTitle(TITLE);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                SGSingleDataFileChooserWizardDialog.this.mNetCDFDataFileChooserPanel.focusedToLocalFileTextField();
            }
        });
        this.mNetCDFDataFileChooserPanel.addAcceptListener(this);
        this.mNetCDFDataFileChooserPanel.setLocalFileSelected(true);
        this.mOKButton.setVisible(false);
    }

    protected JButton getPreviousButton() {
        return this.mPreviousButton;
    }

    protected JButton getNextButton() {
        return this.mNextButton;
    }

    protected JButton getOKButton() {
        return this.mOKButton;
    }

    protected JButton getCancelButton() {
        return this.mCancelButton;
    }

    protected JTextComponent getFileNameTextComponent() {
        return this.mNetCDFDataFileChooserPanel.getLocalFileNameTextComponent();
    }

    protected JButton getFileChooserButton() {
        return this.mNetCDFDataFileChooserPanel.getLocalFileChooserButton();
    }

    protected String getFileName() {
        return this.mNetCDFDataFileChooserPanel.getFileName();
    }

    protected void setFileName(String string) {
        this.mNetCDFDataFileChooserPanel.setFileName(string);
    }

    public boolean isLocalFileSelected() {
        return this.mNetCDFDataFileChooserPanel.isLocalFileSelected();
    }

    protected boolean isAcceptable(String string) {
        if (this.mNetCDFDataFileChooserPanel.isLocalFileSelected()) {
            File file = new File(string);
            return super.isAcceptable(file);
        }
        return this.mNetCDFDataFileChooserPanel.isNetCDFUrlAcceptable();
    }

    public void checkLocalFileTextField() {
        this.onEdited(null);
    }

    public void checkNetCDFURLTextField() {
        this.onNext();
    }

    public void acceptNetCDFUrl(boolean bl) {
        super.acceptFile(bl);
    }

    protected boolean onNext() {
        if (!this.mNetCDFDataFileChooserPanel.isLocalFileSelected() && !this.mNetCDFDataFileChooserPanel.isValidUrlLocation(true)) {
            return false;
        }
        return super.onNext();
    }

    public void setVisibleUrlOfNetCDF(boolean bl) {
        this.mNetCDFDataFileChooserPanel.setEnabledUrlOfNetCDFPanel(bl);
    }
}

