/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import foxtrot.Task;
import foxtrot.Worker;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationTextConstants;
import jp.riken.brain.ni.samuraigraph.application.SGMainFunctions;
import jp.riken.brain.ni.samuraigraph.application.SGPropertyDataFileChooserWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGPropertyFileChooserWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGPropertyFileCreator;
import jp.riken.brain.ni.samuraigraph.application.SGPropertyFileData;
import jp.riken.brain.ni.samuraigraph.application.SGWizardDialog;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGExtensionFileFilter;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyFileConstants;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SGPropertyFileManager
implements ActionListener,
SGIConstants,
SGIApplicationConstants,
SGIApplicationTextConstants,
SGIPropertyFileConstants {
    private Document mPropertyFileDocument = null;
    private SGPropertyFileCreator mPropertyFileCreator = null;
    private SGPropertyFileChooserWizardDialog mPropertyFileChooserWizardDilaog = null;
    private SGPropertyDataFileChooserWizardDialog mMultiDataFileChooserWizardDialog = null;
    private SGPropertyDataFileChooserWizardDialog mMultiDataFileChooserWizardDialogDD = null;
    private SGMainFunctions mMain = null;
    private String mVersionNumber = null;

    SGPropertyFileManager(SGMainFunctions sGMainFunctions) {
        this.mMain = sGMainFunctions;
        this.mPropertyFileCreator = new SGPropertyFileCreator();
        this.mPropertyFileChooserWizardDilaog = null;
        this.mMultiDataFileChooserWizardDialog = null;
    }

    public int saveProperties(SGDrawingWindow sGDrawingWindow, String string, int n) {
        String string2 = this.mMain.mAppProp.getVersionString();
        return this.mPropertyFileCreator.create(sGDrawingWindow, new File(string), n, string2);
    }

    public int savePropertiesByDialog(SGDrawingWindow sGDrawingWindow) {
        return this._savePropertiesByDialog(sGDrawingWindow, this.mMain.getCurrentFileDirectory(), this.mMain.mCurrentPropertyFileName);
    }

    private int _savePropertiesByDialog(SGDrawingWindow sGDrawingWindow, String string, String string2) {
        this.mPropertyFileCreator.setFile(string, string2);
        String string3 = this.mMain.mAppProp.getVersionString();
        int n = this.mPropertyFileCreator.create(sGDrawingWindow, 1, string3);
        if (n != 0) {
            return n;
        }
        File file = this.mPropertyFileCreator.getSelectedFile();
        if (file != null) {
            this.mMain.updateCurrentFile(file, 1);
        }
        return 0;
    }

    boolean loadPropertyFromDialog(SGDrawingWindow sGDrawingWindow) {
        this.createAllWizardDialogsToLoadPropertyFromToolBar(sGDrawingWindow);
        this.mPropertyFileChooserWizardDilaog.setCenter(sGDrawingWindow);
        this.mPropertyFileChooserWizardDilaog.setVisible(true);
        File file = this.mPropertyFileChooserWizardDilaog.getSelectedFile();
        String string = this.mMultiDataFileChooserWizardDialog.getSelectedFilepath();
        long l = this.mPropertyFileChooserWizardDilaog.lastUsed();
        long l2 = this.mMultiDataFileChooserWizardDialog.lastUsed();
        if (file != null && string != null && !string.trim().equals("")) {
            if (l < l2) {
                this.mMain.updateCurrentFile(string, 0);
            } else {
                this.mMain.updateCurrentFile(file, 1);
            }
        } else if (file != null) {
            this.mMain.updateCurrentFile(file, 1);
        } else if (string != null && !string.trim().equals("")) {
            this.mMain.updateCurrentFile(string, 0);
        }
        return true;
    }

    private boolean loadProperty(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
        if (object instanceof SGPropertyFileChooserWizardDialog ? !this.fromPropertyFileChooserDialog(actionEvent, sGWizardDialog) : object instanceof SGPropertyDataFileChooserWizardDialog && !this.fromMultiDataFileChooser(actionEvent)) {
            return false;
        }
        if (string.equals("Cancel")) {
            sGWizardDialog.setVisible(false);
            this.mVersionNumber = null;
        } else if (string.equals("<Prev")) {
            sGWizardDialog.showPrevious();
        }
        return true;
    }

    boolean setPropertyFile(SGDrawingWindow sGDrawingWindow, Document document, SGMainFunctions.WrappedData[] wrappedDataArray, boolean bl, String string, int n) {
        int n2;
        Element element = this.getWindowElement(document);
        sGDrawingWindow.startProgress();
        sGDrawingWindow.setProgressMessage("Read Property");
        boolean bl2 = sGDrawingWindow.readProperty(element, 0.0f, 1.0f);
        sGDrawingWindow.endProgress();
        if (!bl2) {
            n2 = 1;
        } else {
            n2 = this.mMain.createFiguresFromPropertyFile(element, sGDrawingWindow, wrappedDataArray, bl, string, n);
            if (n2 == 0) {
                sGDrawingWindow.initPropertiesHistory();
                sGDrawingWindow.initSavedHistory();
                sGDrawingWindow.setSaved(true);
            }
        }
        String string2 = null;
        switch (n2) {
            case 0: {
                string2 = "Successful completion.";
                break;
            }
            case 3: {
                string2 = "Data number shortage.";
                break;
            }
            case 4: {
                string2 = "Data number excess.";
                break;
            }
            case 5: {
                string2 = "Cannot open the selected file.";
                break;
            }
            case 1: {
                string2 = "The property file is invalid.";
                break;
            }
            case 2: {
                string2 = "The data file is invalid.";
                break;
            }
            default: {
                string2 = "Unknown error occured";
            }
        }
        if (string2 != "Successful completion.") {
            SGUtility.showMessageDialog(null, string2, "Property file", 0);
            return false;
        }
        return true;
    }

    private boolean setPropertyFileFromEventDispatchThread(final SGDrawingWindow sGDrawingWindow, final Document document, final SGMainFunctions.WrappedData[] wrappedDataArray) {
        Element element = document.getDocumentElement();
        final String string = element.getAttribute("Version");
        sGDrawingWindow.setWaitCursor(true);
        Boolean bl = Boolean.FALSE;
        if (!SGMainFunctions.USE_FOXTROT) {
            if (this.setPropertyFile(sGDrawingWindow, document, wrappedDataArray, false, string, 1)) {
                bl = Boolean.TRUE;
            }
        } else {
            try {
                bl = (Boolean)Worker.post(new Task(){

                    public Object run() throws Exception {
                        if (!SGPropertyFileManager.this.setPropertyFile(sGDrawingWindow, document, wrappedDataArray, false, string, 1)) {
                            return Boolean.FALSE;
                        }
                        return Boolean.TRUE;
                    }
                });
            }
            catch (Exception exception) {
                bl = Boolean.FALSE;
                exception.printStackTrace();
            }
        }
        sGDrawingWindow.setWaitCursor(false);
        return bl;
    }

    Element getWindowElement(Document document) {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("Window");
        if (nodeList.getLength() == 0) {
            return null;
        }
        Element element2 = (Element)nodeList.item(0);
        return element2;
    }

    private boolean getInfoFromPropertyFile(File file, Component component, List<SGPropertyFileData> list) {
        String string;
        String string2 = SGUtility.getCanonicalPath(file.getPath());
        if (string2 == null) {
            SGUtility.showMessageDialog(component, "Cannot open the selected file.", "File open failure", 0);
            return false;
        }
        URL uRL = null;
        try {
            uRL = file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        Document document = SGUtilityText.getDocument(uRL);
        if (document == null) {
            SGUtility.showMessageDialog(component, "The property file is invalid.", "File open failure", 0);
            return false;
        }
        this.mPropertyFileDocument = document;
        Element element = document.getDocumentElement();
        this.mVersionNumber = string = element.getAttribute("Version");
        NodeList nodeList = element.getElementsByTagName("Window");
        if (nodeList.getLength() == 0) {
            return false;
        }
        NodeList nodeList2 = document.getElementsByTagName("Figure");
        if (nodeList2.getLength() == 0) {
            SGUtility.showMessageDialog(component, "The property file is invalid.", "File open failure", 0);
            return false;
        }
        int n = nodeList2.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList2.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            NodeList nodeList3 = element2.getElementsByTagName("Data");
            int n2 = i + 1;
            int n3 = nodeList3.getLength();
            if (n3 == 0) {
                SGPropertyFileData sGPropertyFileData = new SGPropertyFileData(n2, null, null, null);
                list.add(sGPropertyFileData);
                continue;
            }
            for (int j = 0; j < n3; ++j) {
                Node node2 = nodeList3.item(j);
                if (!(node2 instanceof Element)) continue;
                Element element3 = (Element)node2;
                String string3 = element3.getAttribute("Name");
                String string4 = element3.getAttribute("Type");
                Map<String, Object> map = this.mMain.createInfoMap(string4, element3);
                SGPropertyFileData sGPropertyFileData = new SGPropertyFileData(n2, string4, string3, map);
                list.add(sGPropertyFileData);
            }
        }
        return true;
    }

    private boolean fromPropertyFileChooserDialog(ActionEvent actionEvent, SGWizardDialog sGWizardDialog) {
        String string = actionEvent.getActionCommand();
        SGWizardDialog sGWizardDialog2 = sGWizardDialog.getNext();
        if (!(sGWizardDialog instanceof SGPropertyFileChooserWizardDialog)) {
            return false;
        }
        if (!(sGWizardDialog2 instanceof SGPropertyDataFileChooserWizardDialog)) {
            return false;
        }
        SGPropertyFileChooserWizardDialog sGPropertyFileChooserWizardDialog = (SGPropertyFileChooserWizardDialog)sGWizardDialog;
        SGPropertyDataFileChooserWizardDialog sGPropertyDataFileChooserWizardDialog = (SGPropertyDataFileChooserWizardDialog)sGWizardDialog2;
        return !string.equals("Next>") || this.fromPropertyFileChooserDialogNext(sGPropertyFileChooserWizardDialog, sGPropertyDataFileChooserWizardDialog);
    }

    private boolean fromMultiDataFileChooser(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
        String string = actionEvent.getActionCommand();
        SGPropertyDataFileChooserWizardDialog sGPropertyDataFileChooserWizardDialog = (SGPropertyDataFileChooserWizardDialog)sGWizardDialog;
        SGDrawingWindow sGDrawingWindow = sGWizardDialog.getOwnerWindow();
        if (string.equals("OK")) {
            sGDrawingWindow.deleteImage();
            sGDrawingWindow.clearUndoBuffer();
            sGDrawingWindow.removeAllFigures();
            SGPropertyFileData[] sGPropertyFileDataArray = sGPropertyDataFileChooserWizardDialog.getPropertyFileDataArray();
            SGMainFunctions.WrappedData[] wrappedDataArray = new SGMainFunctions.WrappedData[sGPropertyFileDataArray.length];
            for (int i = 0; i < wrappedDataArray.length; ++i) {
                wrappedDataArray[i] = new SGMainFunctions.WrappedData(sGPropertyFileDataArray[i]);
            }
            if (!this.setPropertyFileFromEventDispatchThread(sGDrawingWindow, this.mPropertyFileDocument, wrappedDataArray)) {
                return false;
            }
            sGDrawingWindow.updateClientRect();
            sGWizardDialog.setVisible(false);
        } else if (string.equals("Cancel")) {
            sGWizardDialog.setVisible(false);
        }
        return true;
    }

    private boolean fromPropertyFileChooserDialogNext(SGPropertyFileChooserWizardDialog sGPropertyFileChooserWizardDialog, SGPropertyDataFileChooserWizardDialog sGPropertyDataFileChooserWizardDialog) {
        File file = new File(sGPropertyFileChooserWizardDialog.getFileName());
        if (!file.exists()) {
            SGUtility.showFileNotFoundMessageDialog(sGPropertyFileChooserWizardDialog);
            return false;
        }
        sGPropertyFileChooserWizardDialog.setSelectedFile(file);
        ArrayList<SGPropertyFileData> arrayList = new ArrayList<SGPropertyFileData>();
        if (!this.getInfoFromPropertyFile(file, sGPropertyFileChooserWizardDialog, arrayList)) {
            return false;
        }
        sGPropertyDataFileChooserWizardDialog.setData(arrayList, this.mVersionNumber);
        sGPropertyFileChooserWizardDialog.showNext();
        return true;
    }

    private void createAllWizardDialogsToLoadPropertyFromToolBar(SGDrawingWindow sGDrawingWindow) {
        Object object;
        if (this.mPropertyFileChooserWizardDilaog != null && (object = this.mPropertyFileChooserWizardDilaog.getOwnerWindow()).equals(sGDrawingWindow)) {
            return;
        }
        this.mPropertyFileChooserWizardDilaog = new SGPropertyFileChooserWizardDialog((Frame)sGDrawingWindow, true);
        this.mPropertyFileChooserWizardDilaog.getPreviousButton().setVisible(false);
        this.mPropertyFileChooserWizardDilaog.getOKButton().setVisible(false);
        this.mPropertyFileChooserWizardDilaog.pack();
        this.mMultiDataFileChooserWizardDialog = new SGPropertyDataFileChooserWizardDialog((Frame)sGDrawingWindow, true);
        this.mMultiDataFileChooserWizardDialog.getNextButton().setVisible(false);
        this.mMultiDataFileChooserWizardDialog.pack();
        object = new SGExtensionFileFilter();
        ((SGExtensionFileFilter)object).setDescription("Samurai Graph Property File");
        ((SGExtensionFileFilter)object).addExtension("sgp");
        this.mPropertyFileChooserWizardDilaog.setFileFilter((FileFilter)object);
        String string = this.mMain.getCurrentFileDirectory();
        this.mPropertyFileChooserWizardDilaog.setSelectedFile(string, this.mMain.mCurrentPropertyFileName);
        this.mMultiDataFileChooserWizardDialog.setSelectedFile(string, this.mMain.mCurrentDataFileName);
        this.mPropertyFileChooserWizardDilaog.setNext(this.mMultiDataFileChooserWizardDialog);
        this.mMultiDataFileChooserWizardDialog.setPrevious(this.mPropertyFileChooserWizardDilaog);
        this.mPropertyFileChooserWizardDilaog.addActionListener(this);
        this.mMultiDataFileChooserWizardDialog.addActionListener(this);
    }

    boolean showMultiDataFileChooserDialog(File file, Frame frame) {
        Serializable serializable;
        if (!file.exists()) {
            SGUtility.showErrorMessageDialog(frame, "Cannot open the selected file.", "File open failure");
            return false;
        }
        boolean bl = false;
        if (this.mMultiDataFileChooserWizardDialogDD == null) {
            bl = true;
        } else if (!this.mMultiDataFileChooserWizardDialogDD.getOwner().equals(frame)) {
            bl = true;
        }
        if (bl) {
            this.mMultiDataFileChooserWizardDialogDD = new SGPropertyDataFileChooserWizardDialog(frame, true);
            serializable = this.mMultiDataFileChooserWizardDialogDD;
            ((SGPropertyDataFileChooserWizardDialog)serializable).getPreviousButton().setVisible(false);
            ((SGPropertyDataFileChooserWizardDialog)serializable).getNextButton().setVisible(false);
            ((Window)serializable).pack();
            ((SGDialog)serializable).addActionListener(this);
            this.mMultiDataFileChooserWizardDialogDD.setSelectedFile(this.mMain.getCurrentFileDirectory(), this.mMain.mCurrentDataFileName);
        }
        if (!this.getInfoFromPropertyFile(file, frame, (List<SGPropertyFileData>)((Object)(serializable = new ArrayList<SGPropertyFileData>())))) {
            return false;
        }
        this.mMultiDataFileChooserWizardDialogDD.setData((List<SGPropertyFileData>)((Object)serializable), this.mVersionNumber);
        if (frame != null) {
            this.mMultiDataFileChooserWizardDialogDD.setCenter(frame);
        } else {
            this.mMultiDataFileChooserWizardDialogDD.setLocationRelativeTo(null);
        }
        this.mMultiDataFileChooserWizardDialogDD.setVisible(true);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.mPropertyFileChooserWizardDilaog) || object.equals(this.mMultiDataFileChooserWizardDialog) || object.equals(this.mMultiDataFileChooserWizardDialogDD)) {
            this.loadProperty(actionEvent);
        }
    }
}

