/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationUtility;
import jp.riken.brain.ni.samuraigraph.application.SGDataCreator;
import jp.riken.brain.ni.samuraigraph.application.SGSingleFileChooserWizardDialog;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfoSet;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.data.SGArrayDataColumnSelectionPanel;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGIDataSetupTableHolder;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFDataSetupPanel;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFFile;
import jp.riken.brain.ni.samuraigraph.data.SGVariable;
import ucar.nc2.NetcdfFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SGPropertyFileDataDialog
extends SGSingleFileChooserWizardDialog
implements PropertyChangeListener,
SGIDataColumnTypeConstants {
    public static final String TITLE = "Setup the Data";
    private SGButton mPreviousButton;
    private SGButton mNextButton;
    protected String mDataType = null;
    protected Map<String, Object> mInfoMap = null;
    protected SGDataColumnInfoSet mDataColumnInfoSet = null;
    protected String mVersionNumber = null;

    public SGPropertyFileDataDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initProperty();
    }

    public SGPropertyFileDataDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.initProperty();
    }

    protected abstract SGIDataSetupTableHolder getDataSetupTableHolder();

    private void initProperty() {
        this.setTitle(TITLE);
        this.mPreviousButton = new SGButton("<Prev");
        this.mNextButton = new SGButton("Next>");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SGPropertyFileDataDialog.this.getDataSetupTableHolder().getRestoreButton().addActionListener(SGPropertyFileDataDialog.this);
                SGPropertyFileDataDialog.this.getDataSetupTableHolder().getClearButton().addActionListener(SGPropertyFileDataDialog.this);
                SGPropertyFileDataDialog.this.getDataSetupTableHolder().getComplementButton().addActionListener(SGPropertyFileDataDialog.this);
                SGPropertyFileDataDialog.this.getDataSetupTableHolder().getTable().addPropertyChangeListener(SGPropertyFileDataDialog.this);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.getFileChooserButton())) {
            String string = this.getFileName();
            if (this.isAcceptable(string) && this.getDataSetupTableHolder().checkSelectedItems()) {
                this.acceptFile(true);
            }
        } else if (object.equals(this.getOKButton())) {
            this.mDataColumnInfoSet = this.getDataSetupTableHolder().getDataColumnInfoSet();
        } else if (object.equals(this.getDataSetupTableHolder().getClearButton())) {
            this.getOKButton().setEnabled(false);
        } else if (object.equals(this.getDataSetupTableHolder().getRestoreButton())) {
            this.getOKButton().setEnabled(true);
        } else if (object.equals(this.getDataSetupTableHolder().getComplementButton())) {
            this.getOKButton().setEnabled(true);
        }
        super.actionPerformed(actionEvent);
    }

    @Override
    protected JButton getPreviousButton() {
        return this.mPreviousButton;
    }

    @Override
    protected JButton getNextButton() {
        return this.mNextButton;
    }

    public void clear() {
        this.getDataSetupTableHolder().clear();
        this.setFileName("");
    }

    public void setDataType(String string, Map<String, Object> map) {
        if (string == null || map == null) {
            throw new IllegalArgumentException("dataType == null || infoMap == null");
        }
        this.mDataType = string;
        this.mInfoMap = new HashMap<String, Object>(map);
        this.getDataSetupTableHolder().setDataType(string);
    }

    @Override
    protected void acceptFile(boolean bl) {
        this.getOKButton().setEnabled(bl);
    }

    public SGDataColumnInfoSet getDataColumnInfoSet() {
        if (this.mDataColumnInfoSet == null) {
            return null;
        }
        return (SGDataColumnInfoSet)this.mDataColumnInfoSet.clone();
    }

    @Override
    protected void onEdited(DocumentEvent documentEvent) {
        super.onEdited(documentEvent);
        Document document = documentEvent.getDocument();
        String string = "";
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        boolean bl = true;
        if (this.isAcceptable(string)) {
            Object object;
            SGIDataSetupTableHolder sGIDataSetupTableHolder = this.getDataSetupTableHolder();
            boolean bl2 = true;
            SGDataCreator.FileColumn[] fileColumnArray = null;
            NetcdfFile netcdfFile = null;
            if (sGIDataSetupTableHolder instanceof SGArrayDataColumnSelectionPanel) {
                object = new SGDataCreator();
                try {
                    fileColumnArray = ((SGDataCreator)object).parseFileComlumnType(string, this.mDataType, true, this.mVersionNumber);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    SGApplicationUtility.showDataFileInvalidMessageDialog(this);
                    bl2 = false;
                }
                if (bl2 && fileColumnArray == null) {
                    SGUtility.showMessageDialog(this, "Data File is invalid.", "Error", 0);
                    bl2 = false;
                }
            } else {
                try {
                    netcdfFile = NetcdfFile.open((String)string);
                }
                catch (IOException iOException) {
                    SGUtility.showMessageDialog(this, "Failed to open the data file.", "Error", 2);
                    bl2 = false;
                }
            }
            if (bl2) {
                if (sGIDataSetupTableHolder instanceof SGArrayDataColumnSelectionPanel) {
                    object = SGApplicationUtility.getArrayDataColInfoSet(fileColumnArray, this.mDataType, this.mInfoMap);
                    SGArrayDataColumnSelectionPanel sGArrayDataColumnSelectionPanel = (SGArrayDataColumnSelectionPanel)sGIDataSetupTableHolder;
                    String string2 = SGApplicationUtility.getArrayDataType(this.mDataType);
                    if (!sGArrayDataColumnSelectionPanel.setData(string2, (SGDataColumnInfoSet)object, this.mInfoMap, true)) {
                        bl = false;
                    }
                } else if (sGIDataSetupTableHolder instanceof SGNetCDFDataSetupPanel) {
                    Object object2;
                    object = new SGNetCDFFile(netcdfFile);
                    List<SGVariable> list = ((SGNetCDFFile)object).getVariables();
                    int n = list.size();
                    SGDataColumnInfo[] sGDataColumnInfoArray = new SGNetCDFDataColumnInfo[n];
                    for (int i = 0; i < n; ++i) {
                        object2 = list.get(i);
                        sGDataColumnInfoArray[i] = new SGNetCDFDataColumnInfo((SGVariable)object2, ((SGVariable)object2).getNameInPriorityOrder(), ((SGVariable)object2).getValueType());
                    }
                    object2 = (SGNetCDFDataSetupPanel)sGIDataSetupTableHolder;
                    SGDataColumnInfoSet sGDataColumnInfoSet = new SGDataColumnInfoSet(sGDataColumnInfoArray);
                    if (!((SGNetCDFDataSetupPanel)object2).setData((SGNetCDFFile)object, this.mDataType, sGDataColumnInfoSet, this.mInfoMap, true)) {
                        bl = false;
                    }
                }
            } else {
                bl = false;
                this.getDataSetupTableHolder().clear();
            }
        } else {
            bl = false;
            this.getDataSetupTableHolder().clear();
        }
        if (!bl) {
            this.getDataSetupTableHolder().setDataType(this.mDataType);
        }
        this.getOKButton().setEnabled(bl);
        this.getDataSetupTableHolder().getClearButton().setEnabled(bl);
        this.getDataSetupTableHolder().getRestoreButton().setEnabled(bl);
        this.getDataSetupTableHolder().getComplementButton().setEnabled(bl);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        super.componentResized(componentEvent);
        this.updateTable();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        super.componentShown(componentEvent);
        this.updateTable();
    }

    private void updateTable() {
        this.getDataSetupTableHolder().updateTable();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        Object object = propertyChangeEvent.getSource();
        if (object.equals(this.getDataSetupTableHolder().getTable()) && "tableCellEditor".equals(string = propertyChangeEvent.getPropertyName())) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    boolean bl = SGPropertyFileDataDialog.this.getDataSetupTableHolder().checkSelectedItems();
                    SGPropertyFileDataDialog.this.getOKButton().setEnabled(bl);
                }
            });
        }
    }
}

