/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationTextConstants;
import jp.riken.brain.ni.samuraigraph.application.SGWizardDialog;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfoSet;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFDataSetupPanel;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGNetCDFDataSetupWizardDialog
extends SGWizardDialog
implements PropertyChangeListener,
DocumentListener,
SGIDataColumnTypeConstants,
SGIApplicationTextConstants {
    private static final long serialVersionUID = 9030133791210821567L;
    public static final String TITLE = "Setup netCDF data";
    private JPanel mButtonPanel;
    private SGButton mCancelButton;
    private JLabel mDataNameLabel;
    private JPanel mDataNamePanel;
    private SGTextField mDataNameTextField;
    private SGNetCDFDataSetupPanel mNetCDFDataSetupPanel;
    private SGButton mNextButton;
    private SGButton mOKButton;
    private SGButton mPreviousButton;

    public SGNetCDFDataSetupWizardDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    public SGNetCDFDataSetupWizardDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mButtonPanel = new JPanel();
        this.mPreviousButton = new SGButton();
        this.mNextButton = new SGButton();
        this.mOKButton = new SGButton();
        this.mCancelButton = new SGButton();
        this.mNetCDFDataSetupPanel = new SGNetCDFDataSetupPanel();
        this.mDataNamePanel = new JPanel();
        this.mDataNameLabel = new JLabel();
        this.mDataNameTextField = new SGTextField();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.mPreviousButton.setText("<Prev");
        this.mPreviousButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mPreviousButton);
        this.mNextButton.setText("Next>");
        this.mNextButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mNextButton);
        this.mOKButton.setText("OK");
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mCancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.mNetCDFDataSetupPanel, gridBagConstraints);
        this.mDataNamePanel.setLayout(new GridBagLayout());
        this.mDataNameLabel.setFont(new Font("Dialog", 1, 12));
        this.mDataNameLabel.setText("Data Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mDataNamePanel.add((Component)this.mDataNameLabel, gridBagConstraints);
        this.mDataNameTextField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mDataNamePanel.add((Component)this.mDataNameTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.mDataNamePanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.mNetCDFDataSetupPanel.getClearButton().addActionListener(this);
        this.mNetCDFDataSetupPanel.getRestoreButton().addActionListener(this);
        this.mNetCDFDataSetupPanel.getComplementButton().addActionListener(this);
        this.mNetCDFDataSetupPanel.getTable().addPropertyChangeListener(this);
        this.mDataNameTextField.addActionListener(this);
        this.mNetCDFDataSetupPanel.getMultipleDimensionStartField().getDocument().addDocumentListener(this);
        this.mNetCDFDataSetupPanel.getMultipleDimensionEndField().getDocument().addDocumentListener(this);
        this.mNetCDFDataSetupPanel.getMultipleDimensionStepField().getDocument().addDocumentListener(this);
        this.mNetCDFDataSetupPanel.setPopupDialogOwner(this);
        return true;
    }

    @Override
    protected JButton getCancelButton() {
        return this.mCancelButton;
    }

    @Override
    protected JButton getNextButton() {
        return this.mNextButton;
    }

    @Override
    protected JButton getOKButton() {
        return this.mOKButton;
    }

    @Override
    protected JButton getPreviousButton() {
        return this.mPreviousButton;
    }

    public void clear() {
        this.mNetCDFDataSetupPanel.clear();
    }

    public SGDataColumnInfoSet getDataColumnInfoSet() {
        return this.mNetCDFDataSetupPanel.getDataColumnInfoSet();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        super.componentResized(componentEvent);
        this.updateTable();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        super.componentShown(componentEvent);
        this.updateTable();
    }

    private void updateTable() {
        this.mNetCDFDataSetupPanel.updateTable();
    }

    public boolean setData(SGNetCDFFile sGNetCDFFile, String string, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map, boolean bl) {
        if (!this.mNetCDFDataSetupPanel.setData(sGNetCDFFile, string, sGDataColumnInfoSet, map, bl)) {
            return false;
        }
        String string2 = (String)map.get("Data Name");
        this.setDataName(string2);
        if (SGDataUtility.isSXYTypeData(string)) {
            this.getNextButton().setVisible(true);
        } else {
            this.getNextButton().setVisible(false);
        }
        this.getOKButton().setEnabled(true);
        this.getNextButton().setEnabled(true);
        return true;
    }

    public boolean setData(SGNetCDFData sGNetCDFData, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map, boolean bl) {
        if (!this.mNetCDFDataSetupPanel.setData(sGNetCDFData, sGDataColumnInfoSet, map, bl)) {
            return false;
        }
        String string = (String)map.get("Data Name");
        this.setDataName(string);
        this.getOKButton().setEnabled(true);
        this.getNextButton().setEnabled(true);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.mNetCDFDataSetupPanel.getClearButton())) {
            this.getOKButton().setEnabled(false);
            this.getNextButton().setEnabled(false);
        } else if (object.equals(this.mNetCDFDataSetupPanel.getRestoreButton())) {
            this.getOKButton().setEnabled(true);
            this.getNextButton().setEnabled(true);
        } else if (object.equals(this.mNetCDFDataSetupPanel.getComplementButton())) {
            this.getOKButton().setEnabled(true);
            this.getNextButton().setEnabled(true);
        } else if (object.equals(this.mDataNameTextField)) {
            this.onOK();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        Object object = propertyChangeEvent.getSource();
        if (object.equals(this.mNetCDFDataSetupPanel.getTable()) && "tableCellEditor".equals(string = propertyChangeEvent.getPropertyName())) {
            SwingUtilities.invokeLater(new InputObserver());
        }
    }

    public String getDataName() {
        return this.mDataNameTextField.getText();
    }

    public void setDataName(String string) {
        this.mDataNameTextField.setText(string);
    }

    @Override
    protected boolean onOK() {
        boolean bl = true;
        String string = this.getDataName();
        if (!SGUtilityText.isValidString(string)) {
            bl = false;
        }
        if (!bl) {
            SGUtility.showMessageDialog(this, "Input value is invalid.", "Error", 0);
            return false;
        }
        return super.onOK();
    }

    public Integer getMultipleDimensionStart() {
        return this.mNetCDFDataSetupPanel.getMultipleDimensionStart();
    }

    public Integer getMultipleDimensionEnd() {
        return this.mNetCDFDataSetupPanel.getMultipleDimensionEnd();
    }

    public Integer getMultipleDimensionStep() {
        return this.mNetCDFDataSetupPanel.getMultipleDimensionStep();
    }

    public Boolean isVariableDataType() {
        return this.mNetCDFDataSetupPanel.isVariableDataType();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        SwingUtilities.invokeLater(new InputObserver());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        SwingUtilities.invokeLater(new InputObserver());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        SwingUtilities.invokeLater(new InputObserver());
    }

    class InputObserver
    extends Thread {
        InputObserver() {
        }

        public void run() {
            boolean bl = SGNetCDFDataSetupWizardDialog.this.mNetCDFDataSetupPanel.checkSelectedItems();
            SGNetCDFDataSetupWizardDialog.this.getOKButton().setEnabled(bl);
            SGNetCDFDataSetupWizardDialog.this.getNextButton().setEnabled(bl);
        }
    }
}

