/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import ucar.nc2.NetcdfFile;

public class SGNetCDFDataFileChooserPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 7028556477430131723L;
    private SGTextField mDataFileNameTextField;
    private JPanel mLocalFilePanel;
    private SGButton mNetCDFURLCheckValidButton;
    private JPanel mNetCDFURLPanel;
    private JLabel mNetCDFURLSpacerLabel;
    private SGTextField mNetCDFURLTextField;
    private SGButton mShowFileChooserButton;
    private JTabbedPane mTabbedPane;
    private String validUrlLocationInputted = "";
    private List<AcceptListener> listeners = new ArrayList<AcceptListener>();
    public static final String PREFIX_HTTP_PROTOCOL = "http";
    public static final String PREFIX_FILE_PROTOCOL = "file:";
    public static final String PREFIX_NODODS_PROTOCOL = "nodods:";
    public static final String PREFIX_SLURP_PROTOCOL = "slurp:";

    public SGNetCDFDataFileChooserPanel() {
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mTabbedPane = new JTabbedPane();
        this.mLocalFilePanel = new JPanel();
        this.mDataFileNameTextField = new SGTextField();
        this.mShowFileChooserButton = new SGButton();
        this.mNetCDFURLPanel = new JPanel();
        this.mNetCDFURLTextField = new SGTextField();
        this.mNetCDFURLCheckValidButton = new SGButton();
        this.mNetCDFURLSpacerLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.mTabbedPane.setFont(new Font("Dialog", 1, 12));
        this.mLocalFilePanel.setLayout(new GridBagLayout());
        this.mDataFileNameTextField.setFont(new Font("Dialog", 0, 12));
        this.mDataFileNameTextField.setMinimumSize(new Dimension(250, 22));
        this.mDataFileNameTextField.setPreferredSize(new Dimension(250, 22));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 20, 20, 5);
        this.mLocalFilePanel.add((Component)this.mDataFileNameTextField, gridBagConstraints);
        this.mShowFileChooserButton.setText("Browse");
        this.mShowFileChooserButton.setFont(new Font("Dialog", 1, 12));
        this.mShowFileChooserButton.setMaximumSize(new Dimension(80, 25));
        this.mShowFileChooserButton.setMinimumSize(new Dimension(80, 25));
        this.mShowFileChooserButton.setPreferredSize(new Dimension(80, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(20, 5, 20, 20);
        this.mLocalFilePanel.add((Component)this.mShowFileChooserButton, gridBagConstraints);
        this.mTabbedPane.addTab("Local File", this.mLocalFilePanel);
        this.mNetCDFURLPanel.setFont(new Font("Dialog", 1, 12));
        this.mNetCDFURLPanel.setLayout(new GridBagLayout());
        this.mNetCDFURLTextField.setFont(new Font("Dialog", 0, 12));
        this.mNetCDFURLTextField.setMinimumSize(new Dimension(250, 22));
        this.mNetCDFURLTextField.setPreferredSize(new Dimension(250, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 20, 20, 5);
        this.mNetCDFURLPanel.add((Component)this.mNetCDFURLTextField, gridBagConstraints);
        this.mNetCDFURLCheckValidButton.setText("Open");
        this.mNetCDFURLCheckValidButton.setFont(new Font("Dialog", 1, 12));
        this.mNetCDFURLCheckValidButton.setMaximumSize(new Dimension(80, 25));
        this.mNetCDFURLCheckValidButton.setMinimumSize(new Dimension(80, 25));
        this.mNetCDFURLCheckValidButton.setPreferredSize(new Dimension(80, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(20, 5, 20, 20);
        this.mNetCDFURLPanel.add((Component)this.mNetCDFURLCheckValidButton, gridBagConstraints);
        this.mNetCDFURLSpacerLabel.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 15);
        this.mNetCDFURLPanel.add((Component)this.mNetCDFURLSpacerLabel, gridBagConstraints);
        this.mTabbedPane.addTab("URL of netCDF", this.mNetCDFURLPanel);
        this.add((Component)this.mTabbedPane, new GridBagConstraints());
    }

    private void initProperty() {
        this.mNetCDFURLCheckValidButton.addActionListener(this);
        this.mNetCDFURLTextField.addActionListener(this);
        this.mTabbedPane.addChangeListener(this);
        this.mTabbedPane.setSelectedIndex(0);
        this.mNetCDFURLCheckValidButton.setVisible(false);
        this.mNetCDFURLTextField.setPreferredSize(new Dimension(340, 22));
    }

    protected JTextComponent getLocalFileNameTextComponent() {
        return this.mDataFileNameTextField;
    }

    protected JTextComponent getNetCDFUrlTextComponent() {
        return this.mNetCDFURLTextField;
    }

    protected JButton getLocalFileChooserButton() {
        return this.mShowFileChooserButton;
    }

    public void focusedToLocalFileTextField() {
        this.mDataFileNameTextField.requestFocusInWindow();
    }

    public void setVisibleOfNetCDFURLCheckButton(boolean bl) {
        this.mNetCDFURLCheckValidButton.setVisible(bl);
        if (bl) {
            this.mNetCDFURLTextField.setPreferredSize(new Dimension(250, 22));
        } else {
            this.mNetCDFURLTextField.setPreferredSize(new Dimension(340, 22));
        }
    }

    protected String getFileName() {
        if (this.mTabbedPane.getSelectedComponent().equals(this.mLocalFilePanel)) {
            return this.mDataFileNameTextField.getText().trim();
        }
        if (!this.mNetCDFURLCheckValidButton.isVisible()) {
            return this.mNetCDFURLTextField.getText().trim();
        }
        return this.validUrlLocationInputted;
    }

    protected void setFileName(String string) {
        if (SGNetCDFDataFileChooserPanel.isNetcdfUrl(string)) {
            this.mNetCDFURLTextField.setText(string);
            this.mTabbedPane.setSelectedComponent(this.mNetCDFURLPanel);
            this.checkValidationOfNetCDFURLAndFireResult(false);
        } else {
            this.mDataFileNameTextField.setText(string);
            this.mTabbedPane.setSelectedComponent(this.mLocalFilePanel);
        }
    }

    public boolean isLocalFileSelected() {
        return this.mTabbedPane.getSelectedComponent().equals(this.mLocalFilePanel);
    }

    public void setLocalFileSelected(boolean bl) {
        if (bl) {
            this.mTabbedPane.setSelectedComponent(this.mLocalFilePanel);
        } else {
            this.mTabbedPane.setSelectedComponent(this.mNetCDFURLPanel);
        }
    }

    public boolean isNetCDFUrlAcceptable() {
        if (this.mTabbedPane.getSelectedComponent().equals(this.mNetCDFURLPanel)) {
            if (!this.mNetCDFURLCheckValidButton.isVisible()) {
                return true;
            }
            return this.isValidUrlLocationNotChanged();
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mNetCDFURLCheckValidButton) {
            this.checkValidationOfNetCDFURLAndFireResult(true);
        } else if (object == this.mNetCDFURLTextField) {
            if (this.mNetCDFURLCheckValidButton.isVisible()) {
                this.checkValidationOfNetCDFURLAndFireResult(true);
            } else {
                this.fireCheckNetCDFURLTextField();
            }
        }
    }

    protected void checkValidationOfNetCDFURLAndFireResult(boolean bl) {
        if (this.isValidUrlLocation(bl)) {
            this.fireAcceptNetCDFUrl(true);
        } else {
            this.fireAcceptNetCDFUrl(false);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.mTabbedPane) {
            if (this.mTabbedPane.getSelectedComponent().equals(this.mLocalFilePanel)) {
                this.mDataFileNameTextField.requestFocusInWindow();
                this.fireCheckLocalFileTextField();
            } else {
                this.mNetCDFURLTextField.requestFocusInWindow();
                if (!this.mNetCDFURLCheckValidButton.isVisible()) {
                    this.fireAcceptNetCDFUrl(true);
                } else if (this.isValidUrlLocationNotChanged()) {
                    this.fireAcceptNetCDFUrl(true);
                } else {
                    this.fireAcceptNetCDFUrl(false);
                }
            }
        }
    }

    private boolean isValidUrlLocationNotChanged() {
        if (null == this.validUrlLocationInputted || this.validUrlLocationInputted.equals("")) {
            return false;
        }
        return this.mNetCDFURLTextField.getText().trim().equals(this.validUrlLocationInputted);
    }

    public boolean isValidUrlLocation(boolean bl) {
        boolean bl2 = SGNetCDFDataFileChooserPanel.isValidUrlLocationOfNetCDF(this.mNetCDFURLTextField.getText().trim(), this.mNetCDFURLTextField, bl);
        if (!bl2) {
            this.mNetCDFURLTextField.requestFocusInWindow();
            return false;
        }
        this.validUrlLocationInputted = this.mNetCDFURLTextField.getText().trim();
        return true;
    }

    public static boolean isValidUrlLocationOfNetCDF(String string, Component component, boolean bl) {
        try {
            if (NetcdfFile.canOpen((String)string)) {
                return true;
            }
            if (bl) {
                SGUtility.showErrorMessageDialog(component, "Failed to open the netcdf file.", "Failed to open netCDF URL");
            }
            return false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (bl) {
                SGUtility.showErrorMessageDialog(component, "java.lang.NoClassDefFoundError : " + noClassDefFoundError.getMessage(), "Java class not found");
            }
            return false;
        }
        catch (Exception exception) {
            if (bl) {
                SGUtility.showErrorMessageDialog(component, "Failed to open the netcdf file.", "Failed to open netCDF URL");
            }
            return false;
        }
    }

    public void addAcceptListener(AcceptListener acceptListener) {
        this.listeners.add(acceptListener);
    }

    protected void fireAcceptNetCDFUrl(boolean bl) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).acceptNetCDFUrl(bl);
        }
    }

    protected void fireCheckNetCDFURLTextField() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).checkNetCDFURLTextField();
        }
    }

    protected void fireCheckLocalFileTextField() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).checkLocalFileTextField();
        }
    }

    public static boolean isNetcdfUrl(String string) {
        return string.startsWith(PREFIX_HTTP_PROTOCOL) || string.startsWith(PREFIX_FILE_PROTOCOL) || string.startsWith(PREFIX_NODODS_PROTOCOL) || string.startsWith(PREFIX_SLURP_PROTOCOL);
    }

    public void setEnabledUrlOfNetCDFPanel(boolean bl) {
        this.mTabbedPane.setEnabledAt(this.mTabbedPane.indexOfComponent(this.mNetCDFURLPanel), bl);
        this.mTabbedPane.setSelectedComponent(this.mLocalFilePanel);
    }

    public static interface AcceptListener {
        public void acceptNetCDFUrl(boolean var1);

        public void checkNetCDFURLTextField();

        public void checkLocalFileTextField();
    }
}

