/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.riken.brain.ni.samuraigraph.application.SGArrayDataColumnSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGArrayDataTypeSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGDataCreator;
import jp.riken.brain.ni.samuraigraph.application.SGDataTypeSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGMainFunctions;
import jp.riken.brain.ni.samuraigraph.application.SGNetCDFDataSetupWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGNetCDFDataTypeSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGPlotTypeSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGWizardDialog;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfoSet;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGArrayData;
import jp.riken.brain.ni.samuraigraph.data.SGDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFFile;
import jp.riken.brain.ni.samuraigraph.data.SGSamplingDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGTextDataFile;
import jp.riken.brain.ni.samuraigraph.data.SGVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SGMainFunctionsTransform {
    private final SGMainFunctions mMain;
    private final SGArrayDataTypeSelectionWizardDialog mArrayDataTypeSelectionWizardDialog;
    private final SGArrayDataColumnSelectionWizardDialog mDataColumnSelectionWizardDialog;
    private final SGNetCDFDataTypeSelectionWizardDialog mNetCDFDataTypeSelectionWizardDialog;
    private final SGNetCDFDataSetupWizardDialog mNetCDFSetupWizardDialog;
    private final SGPlotTypeSelectionWizardDialog mPlotTypeSelectionWizardDialog;
    private final SGMainFunctions.TransformedData mTransformedData;

    SGMainFunctionsTransform(SGMainFunctions sGMainFunctions, SGArrayDataTypeSelectionWizardDialog sGArrayDataTypeSelectionWizardDialog, SGArrayDataColumnSelectionWizardDialog sGArrayDataColumnSelectionWizardDialog, SGNetCDFDataTypeSelectionWizardDialog sGNetCDFDataTypeSelectionWizardDialog, SGNetCDFDataSetupWizardDialog sGNetCDFDataSetupWizardDialog, SGPlotTypeSelectionWizardDialog sGPlotTypeSelectionWizardDialog, SGMainFunctions.TransformedData transformedData) {
        this.mMain = sGMainFunctions;
        this.mArrayDataTypeSelectionWizardDialog = sGArrayDataTypeSelectionWizardDialog;
        this.mDataColumnSelectionWizardDialog = sGArrayDataColumnSelectionWizardDialog;
        this.mNetCDFDataTypeSelectionWizardDialog = sGNetCDFDataTypeSelectionWizardDialog;
        this.mNetCDFSetupWizardDialog = sGNetCDFDataSetupWizardDialog;
        this.mPlotTypeSelectionWizardDialog = sGPlotTypeSelectionWizardDialog;
        this.mTransformedData = transformedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addDataByDataTransformation(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
        String string = actionEvent.getActionCommand();
        if (string.equals("Cancel")) {
            sGWizardDialog.setVisible(false);
            this.mMain.clearTemporaryData();
        } else if (string.equals("<Prev")) {
            sGWizardDialog.showPrevious();
        } else if (string.equals("Next>")) {
            if (sGWizardDialog instanceof SGDataTypeSelectionWizardDialog) {
                SGDataTypeSelectionWizardDialog sGDataTypeSelectionWizardDialog = (SGDataTypeSelectionWizardDialog)sGWizardDialog;
                sGDataTypeSelectionWizardDialog.setVisible(false);
                String string2 = sGDataTypeSelectionWizardDialog.getSelectedDataType();
                if (string2 == null) {
                    SGDrawingWindow sGDrawingWindow = sGDataTypeSelectionWizardDialog.getOwnerWindow();
                    SGUtility.showErrorMessageDialog(sGDrawingWindow, "Failed to get the data type.", "Error");
                    return false;
                }
                Map<String, Object> map = SGMainFunctions.createInfoMap(string2, sGDataTypeSelectionWizardDialog);
                String string3 = this.mTransformedData.name;
                map.put("Data Name", string3);
                if (sGWizardDialog.equals(this.mArrayDataTypeSelectionWizardDialog)) {
                    this.mMain.setupPlotTypeSelectionWizardDialogConnection(0, string2);
                    SGArrayData sGArrayData = (SGArrayData)this.mTransformedData.data;
                    map.put("Data Source", sGArrayData.getDataSource());
                    if (!this.makeTransition(this.mArrayDataTypeSelectionWizardDialog, this.mDataColumnSelectionWizardDialog, (SGArrayData)this.mTransformedData.data, string2, map)) {
                        return false;
                    }
                } else if (sGWizardDialog.equals(this.mNetCDFDataTypeSelectionWizardDialog)) {
                    this.mMain.setupPlotTypeSelectionWizardDialogConnection(4, string2);
                    SGNetCDFData sGNetCDFData = (SGNetCDFData)this.mTransformedData.data;
                    map.put("Data Source", sGNetCDFData.getDataSource());
                    if (!this.makeTransition(this.mNetCDFDataTypeSelectionWizardDialog, this.mNetCDFSetupWizardDialog, (SGNetCDFData)this.mTransformedData.data, string2, map)) {
                        return false;
                    }
                }
            } else if (sGWizardDialog.equals(this.mDataColumnSelectionWizardDialog)) {
                sGWizardDialog.showNext();
            } else if (sGWizardDialog.equals(this.mNetCDFSetupWizardDialog)) {
                sGWizardDialog.showNext();
            }
        } else if (string.equals("OK")) {
            try {
                if (!this.addDataByTransformation(sGWizardDialog)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.mMain.clearTemporaryData();
            }
        }
        return true;
    }

    private boolean makeTransition(SGArrayDataTypeSelectionWizardDialog sGArrayDataTypeSelectionWizardDialog, SGArrayDataColumnSelectionWizardDialog sGArrayDataColumnSelectionWizardDialog, SGArrayData sGArrayData, String string, Map<String, Object> map) {
        SGDataColumnInfoSet sGDataColumnInfoSet = this.createColumnInfoList(sGArrayData.getDataFile(), string, map);
        if (null == sGDataColumnInfoSet) {
            return false;
        }
        if (!sGArrayDataColumnSelectionWizardDialog.setData(string, sGDataColumnInfoSet, map, false)) {
            return false;
        }
        sGArrayDataColumnSelectionWizardDialog.setCenter(sGArrayDataTypeSelectionWizardDialog.getOwner());
        sGArrayDataColumnSelectionWizardDialog.setVisible(true);
        return true;
    }

    private boolean makeTransition(SGNetCDFDataTypeSelectionWizardDialog sGNetCDFDataTypeSelectionWizardDialog, SGNetCDFDataSetupWizardDialog sGNetCDFDataSetupWizardDialog, SGNetCDFData sGNetCDFData, String string, Map<String, Object> map) {
        SGDataColumnInfoSet sGDataColumnInfoSet = this.createColumnInfoList(sGNetCDFData, string, map);
        if (null == sGDataColumnInfoSet) {
            return false;
        }
        SGNetCDFFile sGNetCDFFile = (SGNetCDFFile)map.get("Data Source");
        if (!sGNetCDFDataSetupWizardDialog.setData(sGNetCDFFile, string, sGDataColumnInfoSet, map, false)) {
            return false;
        }
        sGNetCDFDataSetupWizardDialog.pack();
        sGNetCDFDataSetupWizardDialog.setCenter(sGNetCDFDataTypeSelectionWizardDialog.getOwner());
        sGNetCDFDataSetupWizardDialog.setVisible(true);
        return true;
    }

    private SGDataColumnInfo[] removeAdditionalColumnInfo(SGDataColumnInfo[] sGDataColumnInfoArray) {
        ArrayList<SGDataColumnInfo> arrayList = new ArrayList<SGDataColumnInfo>();
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            if ("Sampling Rate".equals(sGDataColumnInfoArray[i].getValueType())) continue;
            arrayList.add(sGDataColumnInfoArray[i]);
        }
        return arrayList.toArray(new SGDataColumnInfo[arrayList.size()]);
    }

    private boolean isContainedAdditionalColumnInfo(SGDataColumnInfo[] sGDataColumnInfoArray) {
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            if (!"Sampling Rate".equals(sGDataColumnInfoArray[i].getValueType())) continue;
            return true;
        }
        return false;
    }

    private SGDataColumnInfoSet createColumnInfoList(SGTextDataFile sGTextDataFile, String string, Map<String, Object> map) {
        SGDataColumn[] sGDataColumnArray = sGTextDataFile.getDataColumns();
        SGDataColumnInfo[] sGDataColumnInfoArray = new SGDataColumnInfo[sGDataColumnArray.length];
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            sGDataColumnInfoArray[i] = new SGDataColumnInfo(sGDataColumnArray[i].getTitle(), sGDataColumnArray[i].getValueType());
        }
        sGDataColumnInfoArray = this.removeAdditionalColumnInfo(sGDataColumnInfoArray);
        return this.mMain.createColumnInfoSet(string, map, sGDataColumnInfoArray);
    }

    private SGDataColumnInfoSet createColumnInfoList(SGNetCDFData sGNetCDFData, String string, Map<String, Object> map) {
        SGNetCDFFile sGNetCDFFile = sGNetCDFData.getNetcdfFile();
        List<SGVariable> list = sGNetCDFFile.getVariables();
        SGDataColumnInfo[] sGDataColumnInfoArray = new SGNetCDFDataColumnInfo[list.size()];
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            SGVariable sGVariable = list.get(i);
            int n = 0;
            if (sGVariable.isCoordinateVariable()) {
                n = sGNetCDFData.getOrigin(sGVariable.getName());
            }
            sGDataColumnInfoArray[i] = new SGNetCDFDataColumnInfo(sGVariable, sGVariable.getNameInPriorityOrder(), sGVariable.getValueType(), n);
        }
        return this.mMain.createColumnInfoSet(string, map, sGDataColumnInfoArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addDataByTransformation(SGWizardDialog sGWizardDialog) {
        SGDrawingWindow sGDrawingWindow = sGWizardDialog.getOwnerWindow();
        int n = this.mTransformedData.figureId;
        SGFigure sGFigure = sGDrawingWindow.getFigure(n);
        SGData sGData = this.mTransformedData.data;
        if (sGWizardDialog.equals(this.mArrayDataTypeSelectionWizardDialog) || sGWizardDialog.equals(this.mDataColumnSelectionWizardDialog)) {
            if (!this.addArrayDataByTransformation(sGDrawingWindow, n, sGFigure, sGData, sGWizardDialog)) {
                return false;
            }
        } else if (sGWizardDialog.equals(this.mNetCDFSetupWizardDialog) || sGWizardDialog.equals(this.mNetCDFDataTypeSelectionWizardDialog)) {
            if (!this.addNetCDFDataByTransformation(sGDrawingWindow, n, sGFigure, sGData, sGWizardDialog)) {
                return false;
            }
        } else if (sGWizardDialog.equals(this.mPlotTypeSelectionWizardDialog)) {
            if (sGWizardDialog.getPrevious().equals(this.mDataColumnSelectionWizardDialog)) {
                if (!this.addArrayDataByTransformation(sGDrawingWindow, n, sGFigure, sGData, sGWizardDialog)) {
                    return false;
                }
            } else {
                if (!sGWizardDialog.getPrevious().equals(this.mNetCDFSetupWizardDialog)) throw new InternalError("dg.getPrevious() equals null.");
                if (!this.addNetCDFDataByTransformation(sGDrawingWindow, n, sGFigure, sGData, sGWizardDialog)) {
                    return false;
                }
            }
        } else {
            SGUtility.showErrorMessageDialog(sGDrawingWindow, "Failed to draw the graph.", "Error");
            return false;
        }
        sGDrawingWindow.notifyToRoot();
        return true;
    }

    private boolean addArrayDataByTransformation(SGDrawingWindow sGDrawingWindow, int n, SGFigure sGFigure, SGData sGData, SGWizardDialog sGWizardDialog) {
        SGDataCreator.CreatedDataSet createdDataSet;
        Map<String, Object> map = null;
        SGArrayData sGArrayData = (SGArrayData)sGData;
        SGTextDataFile sGTextDataFile = sGArrayData.getDataFile();
        String string = this.mArrayDataTypeSelectionWizardDialog.getSelectedDataType();
        if (string == null) {
            SGUtility.showErrorMessageDialog(sGDrawingWindow, "Failed to get the data type.", "Error");
            return false;
        }
        map = SGMainFunctions.createInfoMap(string, this.mArrayDataTypeSelectionWizardDialog);
        map.put("Data Source", sGData.getDataSource());
        SGDataColumnInfoSet sGDataColumnInfoSet = null;
        String string2 = this.mTransformedData.name;
        if (sGWizardDialog.equals(this.mArrayDataTypeSelectionWizardDialog)) {
            sGDataColumnInfoSet = this.createColumnInfoList(sGTextDataFile, string, map);
            string2 = this.mTransformedData.name;
            map.put("Data Name", string2);
        } else if (sGWizardDialog.equals(this.mDataColumnSelectionWizardDialog)) {
            sGDataColumnInfoSet = this.mDataColumnSelectionWizardDialog.getDataColumnInfoSet();
            string2 = this.mDataColumnSelectionWizardDialog.getDataName();
            map.put("Data Name", string2);
        } else if (sGWizardDialog.equals(this.mPlotTypeSelectionWizardDialog)) {
            sGDataColumnInfoSet = this.mDataColumnSelectionWizardDialog.getDataColumnInfoSet();
            string2 = this.mDataColumnSelectionWizardDialog.getDataName();
            map.put("Data Name", string2);
            SGMainFunctions.addPlotTypeSelectionValuesToInfoMap(map, this.mPlotTypeSelectionWizardDialog);
        }
        if (sGDataColumnInfoSet == null) {
            SGUtility.showErrorMessageDialog(sGDrawingWindow, "Failed to draw the graph.", "Error");
            return false;
        }
        SGDataColumn[] sGDataColumnArray = sGTextDataFile.getDataColumns();
        int n2 = sGDataColumnArray[0].getLength();
        SGDataColumnInfo[] sGDataColumnInfoArray = sGDataColumnInfoSet.getDataColumnInfoArray();
        if (sGDataColumnInfoArray.length != sGDataColumnArray.length) {
            SGDataColumn[] sGDataColumnArray2 = new SGDataColumn[sGDataColumnInfoArray.length];
            for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
                String string3 = sGDataColumnInfoArray[i].getValueType();
                if (!SGUtilityText.isEqualString("Sampling Rate", string3)) {
                    sGDataColumnArray2[i] = sGDataColumnArray[i];
                    continue;
                }
                Object object = map.get("Sampling rate");
                if (null != object && object instanceof Number) {
                    double d = ((Number)object).doubleValue();
                    sGDataColumnArray2[i] = new SGSamplingDataColumn(d, n2);
                    continue;
                }
                return false;
            }
            sGTextDataFile.setDataColumns(sGDataColumnArray2);
        }
        if ((createdDataSet = this.mMain.mDataCreator.create(sGTextDataFile, sGDataColumnInfoSet, map, sGDrawingWindow)) == null) {
            SGUtility.showErrorMessageDialog(sGDrawingWindow, "Failed to draw the graph.", "Error");
            return false;
        }
        if (!sGDrawingWindow.hideSelectedObjects()) {
            return false;
        }
        return this.mMain.addDataToDrawGraph(sGDrawingWindow, n, null, true, map, null, sGFigure, createdDataSet, string2, true);
    }

    private boolean addNetCDFDataByTransformation(SGDrawingWindow sGDrawingWindow, int n, SGFigure sGFigure, SGData sGData, SGWizardDialog sGWizardDialog) {
        Map<String, Object> map = null;
        String string = this.mNetCDFDataTypeSelectionWizardDialog.getSelectedDataType();
        if (string == null) {
            SGUtility.showErrorMessageDialog(sGDrawingWindow, "Failed to get the data type.", "Error");
            return false;
        }
        map = SGMainFunctions.createInfoMap(string, this.mNetCDFDataTypeSelectionWizardDialog);
        map.put("Data Source", sGData.getDataSource());
        SGDataColumnInfoSet sGDataColumnInfoSet = null;
        String string2 = "";
        if (sGWizardDialog.equals(this.mNetCDFDataTypeSelectionWizardDialog)) {
            SGNetCDFFile sGNetCDFFile = (SGNetCDFFile)map.get("Data Source");
            sGDataColumnInfoSet = this.mMain.getNetCDFDefaultDataColumnInfo(sGNetCDFFile, string, map);
            string2 = this.mTransformedData.name;
            map.put("Data Name", string2);
        } else if (sGWizardDialog.equals(this.mNetCDFSetupWizardDialog)) {
            sGDataColumnInfoSet = this.mNetCDFSetupWizardDialog.getDataColumnInfoSet();
            string2 = this.mNetCDFSetupWizardDialog.getDataName();
            map.put("Data Name", string2);
        } else if (sGWizardDialog.equals(this.mPlotTypeSelectionWizardDialog)) {
            sGDataColumnInfoSet = this.mNetCDFSetupWizardDialog.getDataColumnInfoSet();
            string2 = this.mNetCDFSetupWizardDialog.getDataName();
            map.put("Data Name", string2);
            SGMainFunctions.addPlotTypeSelectionValuesToInfoMap(map, this.mPlotTypeSelectionWizardDialog);
        }
        if (sGDataColumnInfoSet == null) {
            SGUtility.showErrorMessageDialog(sGDrawingWindow, "Data file is incomplete.", "Error");
            return false;
        }
        if (sGWizardDialog.equals(this.mNetCDFDataTypeSelectionWizardDialog) ? !this.mMain.setupDefaultDimensionValues(string, map) : sGWizardDialog.equals(this.mNetCDFSetupWizardDialog) && !SGMainFunctions.addDimensionValuesToInfoMap(map, this.mNetCDFSetupWizardDialog)) {
            return false;
        }
        SGDataCreator.CreatedDataSet createdDataSet = this.mMain.mDataCreator.create(sGData.getDataSource(), sGDataColumnInfoSet, map, sGDrawingWindow);
        if (createdDataSet == null) {
            SGUtility.showErrorMessageDialog(sGDrawingWindow, "Failed to draw the graph.", "Error");
            return false;
        }
        if (!sGDrawingWindow.hideSelectedObjects()) {
            return false;
        }
        return this.mMain.addDataToDrawGraph(sGDrawingWindow, n, null, true, map, null, sGFigure, createdDataSet, string2, true);
    }
}

