/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import foxtrot.Task;
import foxtrot.Worker;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.application.SGAboutDialog;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationProperties;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationUtility;
import jp.riken.brain.ni.samuraigraph.application.SGArrayDataColumnSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGArrayDataTypeSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGChangeLogDialog;
import jp.riken.brain.ni.samuraigraph.application.SGClipBoardManager;
import jp.riken.brain.ni.samuraigraph.application.SGCloseWindowConfirmPanel;
import jp.riken.brain.ni.samuraigraph.application.SGCommandManager;
import jp.riken.brain.ni.samuraigraph.application.SGDataCreator;
import jp.riken.brain.ni.samuraigraph.application.SGDataSetManager;
import jp.riken.brain.ni.samuraigraph.application.SGDataTypeSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGFigureCreator;
import jp.riken.brain.ni.samuraigraph.application.SGFigureIDSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationCommandConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationTextConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIArchiveFileConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIImageConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIPreferencesConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIUpgradeConstants;
import jp.riken.brain.ni.samuraigraph.application.SGMainFunctionsSplitMerge;
import jp.riken.brain.ni.samuraigraph.application.SGMainFunctionsTransform;
import jp.riken.brain.ni.samuraigraph.application.SGNetCDFDataSetManager;
import jp.riken.brain.ni.samuraigraph.application.SGNetCDFDataSetupWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGNetCDFDataTypeSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGPlotTypeSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGPluginManager;
import jp.riken.brain.ni.samuraigraph.application.SGPropertyFileData;
import jp.riken.brain.ni.samuraigraph.application.SGPropertyFileManager;
import jp.riken.brain.ni.samuraigraph.application.SGProxyManager;
import jp.riken.brain.ni.samuraigraph.application.SGSingleDataFileChooserWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGSplashWindow;
import jp.riken.brain.ni.samuraigraph.application.SGUpgradeManager;
import jp.riken.brain.ni.samuraigraph.application.SGWindowManager;
import jp.riken.brain.ni.samuraigraph.application.SGWizardDialog;
import jp.riken.brain.ni.samuraigraph.base.SGBufferedFileReader;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfoSet;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementLegend;
import jp.riken.brain.ni.samuraigraph.base.SGIProgressControl;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyFileConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIRootObjectConstants;
import jp.riken.brain.ni.samuraigraph.base.SGPluginsQueryMessage;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyMap;
import jp.riken.brain.ni.samuraigraph.base.SGUserProperties;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGArrayData;
import jp.riken.brain.ni.samuraigraph.data.SGArrayDataDuplicationDialog;
import jp.riken.brain.ni.samuraigraph.data.SGDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGDataDuplicationDialog;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGDefaultColumnTypeUtility;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYZTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGIVXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFDataDuplicationDialog;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFFile;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleDimensionNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleVariableNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYZData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYZNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGTextDataFile;
import jp.riken.brain.ni.samuraigraph.data.SGVXYData;
import jp.riken.brain.ni.samuraigraph.data.SGVXYNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGVariable;
import jp.riken.brain.ni.samuraigraph.figure.SGXYFigure;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SGMainFunctions
implements ActionListener,
SGIConstants,
SGIUpgradeConstants,
SGIApplicationCommandConstants,
SGIApplicationConstants,
SGIPropertyFileConstants,
SGIPreferencesConstants,
SGIApplicationTextConstants,
SGIRootObjectConstants,
SGIImageConstants,
SGIArchiveFileConstants,
SGIDataColumnTypeConstants,
WindowListener {
    static boolean USE_FOXTROT = true;
    SGApplicationProperties mAppProp = null;
    SGDataSetManager mDataSetManager;
    SGProxyManager mProxyManager;
    SGUpgradeManager mUpgradeManager;
    SGDataCreator mDataCreator;
    SGWindowManager mWindowManager = null;
    SGClipBoardManager mClipBoardManager = null;
    SGCommandManager mPropertyManager = null;
    SGPropertyFileManager mPropertyFileManager = null;
    SGFigureCreator mFigureCreator = null;
    SGPluginManager mPluginManager = null;
    private Initializer mInit = null;
    private BufferedWriter mStdoutWriter = null;
    private BufferedReader mStdinReader = null;
    private static final int DATA_ADDITION_TOOL_BAR = 0;
    private static final int DATA_ADDITION_DRAG_AND_DROP = 1;
    static final String KEY_FILE_TYPE = "fileType";
    static final String KEY_FILE_NAME = "fileName";
    static final String KEY_COMMAND_MODE_FLAG = "commandMode";
    static final String KEY_DEVELOPER_MODE_FLAG = "developerMode";
    private SGFigureIDSelectionWizardDialog mFigureIDSelectionWizardDialog = null;
    private SGSingleDataFileChooserWizardDialog mSingleDataFileChooserWizardDilaog = null;
    private SGArrayDataTypeSelectionWizardDialog mArrayDataTypeSelectionWizardDialog = null;
    private SGArrayDataColumnSelectionWizardDialog mDataColumnSelectionWizardDialog = null;
    private SGNetCDFDataTypeSelectionWizardDialog mNetCDFDataTypeSelectionWizardDialog = null;
    private SGNetCDFDataSetupWizardDialog mNetCDFSetupWizardDialog = null;
    private SGPlotTypeSelectionWizardDialog mPlotTypeSelectionWizardDialog = null;
    String mCurrentDataFileName = null;
    String mCurrentPropertyFileName = null;
    String mCurrentImageFileName = null;
    String mCurrentArchiveFileName = null;
    String mCurrentNetCDFFileName = null;
    String mCurrentOutputDataFileName = null;
    public static final String ERRMSG_TO_GET_DATA_TYPE = "Failed to get the data type.";
    public static final String ERRMSG_TO_DRAW_GRAPH = "Failed to draw the graph.";
    public static final String ERRMSG_TO_LOAD_DATASET = "Failed to load dataset file.";
    private static final String ERRMSG_SCRIPT_START = "To use Samurai Graph script, the application must be started in the command mode.";
    private static final String ERRMSG_NETCDF_DATA_ADDITION = "Failed to add netCDF data.\nValid data was not obtained with input values.";
    private static final String ERRMSG_URL_OF_NETCDF = "Failed to add netCDF file from inputted URL.";
    private DroppedData mDroppedFile = null;
    private static final String PROMPT = "$ ";
    private static final String FILE_INPUT = "<<";
    private static final int FILE_RECURSION_DEPTH_MAX = 10;
    private static final String COMMENT_HEADER = "#";
    private static final String COMMENT_HEADER_2 = "//";
    private static final String BLOCK_COMMENT_START = "/*";
    private static final String BLOCK_COMMENT_END = "*/";
    private boolean mBlockComment = false;
    private TransformedData mTransformedData = null;

    public SGMainFunctions(SGApplicationProperties sGApplicationProperties, Map<String, Object> map) {
        this.mAppProp = sGApplicationProperties;
        this.mInit = new Initializer(map);
        this.mInit.start();
    }

    public boolean waitInit() {
        try {
            this.mInit.join();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        this.mInit = null;
        return true;
    }

    public boolean closeWindowWithoutConfirmation(int n) {
        return this.mWindowManager.closeWindowWithoutConfirmation(n);
    }

    public int exec(String string) {
        return this.mPropertyManager.exec(string);
    }

    boolean isDialogOpen() {
        List<SGDrawingWindow> list = this.mWindowManager.getWindowList();
        for (SGDrawingWindow sGDrawingWindow : list) {
            if (!sGDrawingWindow.isModalDialogShown()) continue;
            return true;
        }
        return false;
    }

    boolean closeTextField() {
        List<SGDrawingWindow> list = this.mWindowManager.getWindowList();
        for (SGDrawingWindow sGDrawingWindow : list) {
            if (sGDrawingWindow.closeTextField()) continue;
            return false;
        }
        return true;
    }

    private void createDataAdditionWizardDialogs(SGDrawingWindow sGDrawingWindow) {
        Object object;
        if (this.mFigureIDSelectionWizardDialog != null && (object = this.mFigureIDSelectionWizardDialog.getOwnerWindow()).equals(sGDrawingWindow)) {
            return;
        }
        this.mFigureIDSelectionWizardDialog = new SGFigureIDSelectionWizardDialog((Frame)sGDrawingWindow, true);
        this.mSingleDataFileChooserWizardDilaog = new SGSingleDataFileChooserWizardDialog((Frame)sGDrawingWindow, true);
        this.mArrayDataTypeSelectionWizardDialog = new SGArrayDataTypeSelectionWizardDialog((Frame)sGDrawingWindow, true);
        this.mDataColumnSelectionWizardDialog = new SGArrayDataColumnSelectionWizardDialog((Frame)sGDrawingWindow, true);
        this.mNetCDFDataTypeSelectionWizardDialog = new SGNetCDFDataTypeSelectionWizardDialog((Frame)sGDrawingWindow, true);
        this.mNetCDFSetupWizardDialog = new SGNetCDFDataSetupWizardDialog((Frame)sGDrawingWindow, true);
        this.mPlotTypeSelectionWizardDialog = new SGPlotTypeSelectionWizardDialog((Frame)sGDrawingWindow, true);
        this.mFigureIDSelectionWizardDialog.setPrevious(null);
        this.mFigureIDSelectionWizardDialog.setNext(this.mSingleDataFileChooserWizardDilaog);
        this.mSingleDataFileChooserWizardDilaog.setPrevious(this.mFigureIDSelectionWizardDialog);
        this.mArrayDataTypeSelectionWizardDialog.setNext(this.mDataColumnSelectionWizardDialog);
        this.mDataColumnSelectionWizardDialog.setPrevious(this.mArrayDataTypeSelectionWizardDialog);
        this.mNetCDFDataTypeSelectionWizardDialog.setNext(this.mNetCDFSetupWizardDialog);
        this.mNetCDFSetupWizardDialog.setPrevious(this.mNetCDFDataTypeSelectionWizardDialog);
        object = this.getCurrentFileDirectory();
        this.mSingleDataFileChooserWizardDilaog.setSelectedFile((String)object, this.mCurrentDataFileName);
        this.mFigureIDSelectionWizardDialog.addActionListener(this);
        this.mSingleDataFileChooserWizardDilaog.addActionListener(this);
        this.mArrayDataTypeSelectionWizardDialog.addActionListener(this);
        this.mDataColumnSelectionWizardDialog.addActionListener(this);
        this.mNetCDFDataTypeSelectionWizardDialog.addActionListener(this);
        this.mNetCDFSetupWizardDialog.addActionListener(this);
        this.mPlotTypeSelectionWizardDialog.addActionListener(this);
        this.mFigureIDSelectionWizardDialog.addWindowListener(this);
        this.mSingleDataFileChooserWizardDilaog.addWindowListener(this);
        this.mArrayDataTypeSelectionWizardDialog.addWindowListener(this);
        this.mDataColumnSelectionWizardDialog.addWindowListener(this);
        this.mNetCDFDataTypeSelectionWizardDialog.addWindowListener(this);
        this.mNetCDFSetupWizardDialog.addWindowListener(this);
        this.mPlotTypeSelectionWizardDialog.addWindowListener(this);
        this.mFigureIDSelectionWizardDialog.pack();
        this.mSingleDataFileChooserWizardDilaog.pack();
    }

    private void setupDataTypeSelectionWizardDialogConnection(int n, int n2) {
        SGDataTypeSelectionWizardDialog sGDataTypeSelectionWizardDialog;
        switch (n) {
            case 0: {
                sGDataTypeSelectionWizardDialog = this.mArrayDataTypeSelectionWizardDialog;
                break;
            }
            case 4: {
                sGDataTypeSelectionWizardDialog = this.mNetCDFDataTypeSelectionWizardDialog;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type for data file: " + n);
            }
        }
        switch (n2) {
            case 0: {
                this.mSingleDataFileChooserWizardDilaog.setNext(sGDataTypeSelectionWizardDialog);
                sGDataTypeSelectionWizardDialog.setPrevious(this.mSingleDataFileChooserWizardDilaog);
                this.mSingleDataFileChooserWizardDilaog.pack();
                sGDataTypeSelectionWizardDialog.pack();
                break;
            }
            case 1: {
                sGDataTypeSelectionWizardDialog.setPrevious(null);
                this.mSingleDataFileChooserWizardDilaog.pack();
                sGDataTypeSelectionWizardDialog.pack();
                break;
            }
            default: {
                throw new IllegalArgumentException("data file type is invalid: " + n);
            }
        }
    }

    void setupPlotTypeSelectionWizardDialogConnection(int n, String string) {
        SGWizardDialog sGWizardDialog;
        switch (n) {
            case 0: {
                sGWizardDialog = this.mDataColumnSelectionWizardDialog;
                break;
            }
            case 4: {
                sGWizardDialog = this.mNetCDFSetupWizardDialog;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type for data file: " + n);
            }
        }
        if (SGDataUtility.isSXYTypeData(string)) {
            sGWizardDialog.setNext(this.mPlotTypeSelectionWizardDialog);
            this.mPlotTypeSelectionWizardDialog.setPrevious(sGWizardDialog);
            this.mPlotTypeSelectionWizardDialog.setNext(null);
            sGWizardDialog.pack();
            this.mPlotTypeSelectionWizardDialog.pack();
        } else {
            sGWizardDialog.setNext(null);
            sGWizardDialog.pack();
        }
    }

    String getCurrentFileDirectory() {
        Comparable<File> comparable;
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        String string = preferences.get("Current Directory", null);
        boolean bl = false;
        if (string == null) {
            bl = true;
        } else {
            comparable = new File(string);
            if (!((File)comparable).exists()) {
                bl = true;
            }
        }
        if (bl) {
            comparable = new StringBuffer();
            ((StringBuffer)comparable).append(USER_HOME);
            if (SGUtility.identifyOS("windows")) {
                ((StringBuffer)comparable).append(FILE_SEPARATOR);
                ((StringBuffer)comparable).append("My Documents");
            }
            String string2 = ((StringBuffer)comparable).toString();
            this.setCurrentFileDirectory(string2);
            string = string2;
        }
        return string;
    }

    void setCurrentFileDirectory(String string) {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        preferences.put("Current Directory", string);
    }

    public boolean showAboutDialog(SGDrawingWindow sGDrawingWindow) {
        if (sGDrawingWindow == null) {
            sGDrawingWindow = this.mWindowManager.getCurrentWindow();
        }
        if (sGDrawingWindow == null) {
            return false;
        }
        SGAboutDialog sGAboutDialog = new SGAboutDialog((Frame)sGDrawingWindow, true, this.mAppProp.getVersionString());
        int n = sGAboutDialog.getWidth();
        int n2 = sGAboutDialog.getHeight();
        int n3 = sGDrawingWindow.getX() + sGDrawingWindow.getWidth() / 2 - n / 2;
        int n4 = sGDrawingWindow.getY() + sGDrawingWindow.getHeight() / 2 - n2 / 2;
        sGAboutDialog.setLocation(n3, n4);
        sGAboutDialog.setVisible(true);
        sGAboutDialog.dispose();
        return true;
    }

    boolean duplicateFocusedData(SGDrawingWindow sGDrawingWindow) {
        ArrayList<SGFigure> arrayList = sGDrawingWindow.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
            SGIFigureElementGraph sGIFigureElementGraph = sGFigure.getGraphElement();
            List<SGData> list = sGIFigureElementGraph.getFocusedDataList();
            ArrayList<SGData> arrayList2 = new ArrayList<SGData>();
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            for (int j = 0; j < list.size(); ++j) {
                Object object;
                Object object2;
                SGData sGData = list.get(j);
                String string = sGData.getDataType();
                String string2 = sGIFigureElementGraph.getDataName(sGData);
                SGDataColumnInfo[] sGDataColumnInfoArray = sGIFigureElementGraph.getDataColumnInfoArray(sGData);
                Map<String, Object> map = sGIFigureElementGraph.getInfoMap(sGData);
                SGDataColumnInfoSet sGDataColumnInfoSet = new SGDataColumnInfoSet(sGDataColumnInfoArray);
                String string3 = sGFigure.getNewDataName(string2);
                Object object3 = null;
                if (sGData instanceof SGArrayData) {
                    object2 = new SGArrayDataDuplicationDialog((Frame)sGDrawingWindow, true);
                    if (!((SGArrayDataDuplicationDialog)object2).setData(string3, string, sGDataColumnInfoSet, map)) {
                        return false;
                    }
                    object3 = object2;
                } else if (sGData instanceof SGNetCDFData) {
                    object = new SGNetCDFDataDuplicationDialog((Frame)sGDrawingWindow, true);
                    object2 = (SGNetCDFData)sGData;
                    if (!object.setData(string3, (SGNetCDFData)object2, sGDataColumnInfoSet, map)) {
                        return false;
                    }
                    object3 = object;
                } else {
                    throw new Error("Invalid data type: " + sGData.getDataType());
                }
                ((Window)object3).setLocation(sGDrawingWindow.getX() + 20, sGDrawingWindow.getY() + 20);
                ((SGDialog)object3).setVisible(true);
                object2 = null;
                if (((SGDialog)object3).getCloseOption() != 0) continue;
                object = ((SGDataDuplicationDialog)object3).getDataColumnTypes();
                object2 = (SGData)sGData.copy();
                if (!((SGData)object2).setColumnInfo((SGDataColumnInfo[])object)) {
                    return false;
                }
                object = ((SGDataDuplicationDialog)object3).getDataName();
                SGProperties sGProperties = ((SGData)object2).getProperties();
                HashMap<Class<? extends SGIFigureElement>, SGProperties> hashMap = new HashMap<Class<? extends SGIFigureElement>, SGProperties>();
                for (int k = 0; k < sGIFigureElementArray.length; ++k) {
                    SGProperties sGProperties2 = sGIFigureElementArray[k].getDataProperties(sGData);
                    SGProperties sGProperties3 = sGIFigureElementArray[k].synchronizeDataProperties(sGProperties2, sGProperties);
                    if (sGProperties3 == null) continue;
                    hashMap.put(sGIFigureElementArray[k].getClass(), sGProperties3);
                }
                if (!sGFigure.addData((SGData)object2, (String)object, hashMap)) {
                    return false;
                }
                arrayList2.add(sGData);
                arrayList3.add(object2);
            }
            for (SGData sGData : arrayList2) {
                sGIFigureElementGraph.setDataFocused(sGData, false);
            }
            for (SGData sGData : arrayList3) {
                sGIFigureElementGraph.setDataFocused(sGData, true);
            }
        }
        return true;
    }

    boolean duplicateFocusedFigures(SGDrawingWindow sGDrawingWindow) {
        Object object;
        Object object2;
        Object object3;
        DOMImplementation dOMImplementation = SGApplicationUtility.getDOMImplementation();
        if (dOMImplementation == null) {
            return false;
        }
        Document document = dOMImplementation.createDocument("", "FocusedFigures", null);
        if (!sGDrawingWindow.createDOMTree(document, 3, 3)) {
            return false;
        }
        ArrayList<WrappedData> arrayList = new ArrayList<WrappedData>();
        List<SGFigure> list = sGDrawingWindow.getFocusedFigureList();
        for (int i = 0; i < list.size(); ++i) {
            object3 = list.get(i);
            object2 = new ArrayList<SGData>(((SGFigure)object3).getVisibleDataList());
            for (int j = 0; j < object2.size(); ++j) {
                object = (SGData)object2.get(j);
                FigureData figureData = new FigureData((SGData)object, i);
                WrappedData wrappedData = new WrappedData(figureData);
                arrayList.add(wrappedData);
            }
        }
        WrappedData[] wrappedDataArray = new WrappedData[arrayList.size()];
        arrayList.toArray(wrappedDataArray);
        object3 = document.getDocumentElement();
        object2 = object3.getAttribute("Version");
        NodeList nodeList = object3.getElementsByTagName("Window");
        if (nodeList.getLength() == 0) {
            return false;
        }
        object = (Element)nodeList.item(0);
        int n = sGDrawingWindow.getFigureList().size();
        int n2 = this.createFiguresFromPropertyFile((Element)object, sGDrawingWindow, wrappedDataArray, true, (String)object2, 3);
        if (n2 != 0) {
            return false;
        }
        int n3 = sGDrawingWindow.getFigureList().size();
        sGDrawingWindow.setChanged(n != n3);
        return true;
    }

    int beforeDiscard(SGDrawingWindow sGDrawingWindow) {
        int n = this.confirmBeforeDiscard(sGDrawingWindow);
        if (n != 0) {
            if (n == 1 || n == -1) {
                return 1;
            }
            if (n == 2) {
                int n2 = this.mPropertyFileManager.savePropertiesByDialog(sGDrawingWindow);
                return n2;
            }
        }
        return 0;
    }

    int confirmBeforeClosing(SGDrawingWindow sGDrawingWindow) {
        Object[] objectArray = new Object[]{"Close without saving", "Cancel", "Save"};
        return this.showConfirmationDialog(sGDrawingWindow, objectArray, new SGCloseWindowConfirmPanel());
    }

    int confirmBeforeDiscard(SGDrawingWindow sGDrawingWindow) {
        Object[] objectArray = new Object[]{"Close without saving", "Cancel", "Save"};
        return this.showConfirmationDialog(sGDrawingWindow, objectArray, new SGCloseWindowConfirmPanel());
    }

    private int showConfirmationDialog(Component component, Object[] objectArray, Object object) {
        Toolkit.getDefaultToolkit().beep();
        int n = JOptionPane.showOptionDialog(component, object, "Confirmation", 1, 2, null, objectArray, objectArray[2]);
        return n;
    }

    boolean showChangeLogDialog(Frame frame) {
        SGChangeLogDialog sGChangeLogDialog = new SGChangeLogDialog(frame, true);
        sGChangeLogDialog.addActionListener(this);
        sGChangeLogDialog.setCenter(frame);
        String string = "Change Log of Samurai Graph.";
        sGChangeLogDialog.setMessage(string);
        Class<?> clazz = this.getClass();
        URL uRL = clazz.getResource("/resources/ChangeLog.html");
        if (uRL == null) {
            JOptionPane.showMessageDialog(frame, "Failed to get log information.");
            return false;
        }
        sGChangeLogDialog.setPage(uRL);
        sGChangeLogDialog.pack();
        sGChangeLogDialog.setVisible(true);
        sGChangeLogDialog.dispose();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addDataByDragAndDrop(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
        String string = actionEvent.getActionCommand();
        if (string.equals("Cancel")) {
            sGWizardDialog.setVisible(false);
            this.clearTemporaryData();
        } else if (string.equals("<Prev")) {
            sGWizardDialog.showPrevious();
        } else if (string.equals("Next>")) {
            if (sGWizardDialog.equals(this.mArrayDataTypeSelectionWizardDialog)) {
                if (!this.makeTransition(this.mArrayDataTypeSelectionWizardDialog, this.mDataColumnSelectionWizardDialog, this.mDroppedFile.file)) {
                    return false;
                }
            } else if (sGWizardDialog.equals(this.mNetCDFDataTypeSelectionWizardDialog)) {
                if (!this.makeTransition(this.mNetCDFDataTypeSelectionWizardDialog, this.mNetCDFSetupWizardDialog, this.mDroppedFile.file.getPath())) {
                    return false;
                }
            } else if (sGWizardDialog.equals(this.mDataColumnSelectionWizardDialog)) {
                String string2 = this.mArrayDataTypeSelectionWizardDialog.getSelectedDataType();
                this.setupPlotTypeSelectionWizardDialogConnection(0, string2);
                sGWizardDialog.showNext();
            } else if (sGWizardDialog.equals(this.mNetCDFSetupWizardDialog)) {
                String string3 = this.mNetCDFDataTypeSelectionWizardDialog.getSelectedDataType();
                this.setupPlotTypeSelectionWizardDialogConnection(4, string3);
                sGWizardDialog.showNext();
            }
        } else if (string.equals("OK")) {
            try {
                if (!this.addDataByDragAndDropOK(sGWizardDialog)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.clearTemporaryData();
            }
        }
        return true;
    }

    private boolean addDataByDragAndDropOK(SGWizardDialog sGWizardDialog) {
        Point point;
        int n;
        SGDrawingWindow sGDrawingWindow = sGWizardDialog.getOwnerWindow();
        String string = this.mDroppedFile.file.getAbsolutePath();
        Object object = this.mDroppedFile.pos != null ? sGDrawingWindow.getComponent(this.mDroppedFile.pos.x, this.mDroppedFile.pos.y) : sGDrawingWindow;
        if (object instanceof SGDrawingWindow) {
            n = sGDrawingWindow.assignFigureId();
            point = this.mDroppedFile.pos;
        } else {
            SGFigure sGFigure = (SGFigure)object;
            n = sGFigure.getID();
            point = null;
        }
        if (sGWizardDialog.equals(this.mArrayDataTypeSelectionWizardDialog) || sGWizardDialog.equals(this.mDataColumnSelectionWizardDialog) ? !this.drawNewGraphOfArrayDataByDadOrToolbar(sGDrawingWindow, sGWizardDialog, string, n, point) : (sGWizardDialog.equals(this.mNetCDFSetupWizardDialog) || sGWizardDialog.equals(this.mNetCDFDataTypeSelectionWizardDialog) ? !this.drawNewGraphOfNetcdfDataByDadOrToolbar(sGDrawingWindow, sGWizardDialog, string, n, point) : sGWizardDialog.equals(this.mPlotTypeSelectionWizardDialog) && (sGWizardDialog.getPrevious().equals(this.mDataColumnSelectionWizardDialog) ? !this.drawNewGraphOfArrayDataByDadOrToolbar(sGDrawingWindow, sGWizardDialog, string, n, point) : !this.drawNewGraphOfNetcdfDataByDadOrToolbar(sGDrawingWindow, sGWizardDialog, string, n, point)))) {
            return false;
        }
        sGDrawingWindow.notifyToRoot();
        return true;
    }

    private boolean drawNewGraphOfArrayDataByDadOrToolbar(SGDrawingWindow sGDrawingWindow, SGWizardDialog sGWizardDialog, String string, int n, Point point) {
        String string2 = this.mArrayDataTypeSelectionWizardDialog.getSelectedDataType();
        if (string2 == null) {
            SGUtility.showErrorMessageDialog(sGDrawingWindow, ERRMSG_TO_GET_DATA_TYPE, "Error");
            return false;
        }
        Map<String, Object> map = SGMainFunctions.createInfoMap(string2, this.mArrayDataTypeSelectionWizardDialog);
        SGDataColumnInfoSet sGDataColumnInfoSet = null;
        if (sGWizardDialog.equals(this.mArrayDataTypeSelectionWizardDialog)) {
            sGDataColumnInfoSet = this.getDefaultDataColumnInfo(string, string2, map, false, null);
        } else if (sGWizardDialog.equals(this.mDataColumnSelectionWizardDialog)) {
            sGDataColumnInfoSet = this.mDataColumnSelectionWizardDialog.getDataColumnInfoSet();
            map.put("Data Name", this.mDataColumnSelectionWizardDialog.getDataName());
        } else if (sGWizardDialog.equals(this.mPlotTypeSelectionWizardDialog)) {
            sGDataColumnInfoSet = this.mDataColumnSelectionWizardDialog.getDataColumnInfoSet();
            map.put("Data Name", this.mDataColumnSelectionWizardDialog.getDataName());
            SGMainFunctions.addPlotTypeSelectionValuesToInfoMap(map, this.mPlotTypeSelectionWizardDialog);
        }
        if (sGDataColumnInfoSet == null) {
            SGUtility.showErrorMessageDialog(sGDrawingWindow, ERRMSG_TO_DRAW_GRAPH, "Error");
            return false;
        }
        return this.drawGraph(sGDrawingWindow, n, sGDataColumnInfoSet, map, string, null, true, point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean drawNewGraphOfNetcdfDataByDadOrToolbar(SGDrawingWindow sGDrawingWindow, SGWizardDialog sGWizardDialog, String string, int n, Point point) {
        String string2 = this.mNetCDFDataTypeSelectionWizardDialog.getSelectedDataType();
        if (string2 == null) {
            SGUtility.showErrorMessageDialog(sGDrawingWindow, ERRMSG_TO_GET_DATA_TYPE, "Error");
            return false;
        }
        Map<String, Object> map = SGMainFunctions.createInfoMap(string2, this.mNetCDFDataTypeSelectionWizardDialog);
        NetcdfFile netcdfFile = null;
        SGDataColumnInfoSet sGDataColumnInfoSet = null;
        try {
            try {
                netcdfFile = NetcdfFile.open((String)string);
                SGNetCDFFile sGNetCDFFile = new SGNetCDFFile(netcdfFile);
                map.put("Data Source", sGNetCDFFile);
                if (sGWizardDialog.equals(this.mNetCDFDataTypeSelectionWizardDialog)) {
                    sGDataColumnInfoSet = this.getNetCDFDefaultDataColumnInfo(sGNetCDFFile, string2, map);
                    String string3 = SGUtility.createDataNameBase(string);
                    map.put("Data Name", string3);
                } else if (sGWizardDialog.equals(this.mNetCDFSetupWizardDialog)) {
                    sGDataColumnInfoSet = this.mNetCDFSetupWizardDialog.getDataColumnInfoSet();
                    map.put("Data Name", this.mNetCDFSetupWizardDialog.getDataName());
                    SGMainFunctions.addDimensionValuesToInfoMap(map, this.mNetCDFSetupWizardDialog);
                } else if (sGWizardDialog.equals(this.mPlotTypeSelectionWizardDialog)) {
                    sGDataColumnInfoSet = this.mNetCDFSetupWizardDialog.getDataColumnInfoSet();
                    map.put("Data Name", this.mNetCDFSetupWizardDialog.getDataName());
                    SGMainFunctions.addDimensionValuesToInfoMap(map, this.mNetCDFSetupWizardDialog);
                    SGMainFunctions.addPlotTypeSelectionValuesToInfoMap(map, this.mPlotTypeSelectionWizardDialog);
                }
            }
            finally {
                netcdfFile.close();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        if (sGDataColumnInfoSet == null) {
            SGUtility.showErrorMessageDialog(sGDrawingWindow, "Data file is incomplete.", "Error");
            return false;
        }
        if (sGWizardDialog.equals(this.mNetCDFDataTypeSelectionWizardDialog) ? !this.setupDefaultDimensionValues(string2, map) : (sGWizardDialog.equals(this.mNetCDFSetupWizardDialog) || sGWizardDialog.equals(this.mPlotTypeSelectionWizardDialog)) && !SGMainFunctions.addDimensionValuesToInfoMap(map, this.mNetCDFSetupWizardDialog)) {
            return false;
        }
        if (!this.drawGraph(sGDrawingWindow, n, sGDataColumnInfoSet, map, string, null, false, point)) {
            SGUtility.showErrorMessageDialog(sGDrawingWindow, ERRMSG_NETCDF_DATA_ADDITION, "Error");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addDataByToolBar(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
        String string = actionEvent.getActionCommand();
        if (string.equals("Cancel")) {
            sGWizardDialog.setVisible(false);
            this.clearTemporaryData();
        } else if (string.equals("<Prev")) {
            sGWizardDialog.showPrevious();
        } else if (string.equals("Next>")) {
            if (sGWizardDialog.equals(this.mFigureIDSelectionWizardDialog)) {
                sGWizardDialog.showNext();
            } else if (sGWizardDialog.equals(this.mSingleDataFileChooserWizardDilaog)) {
                String string2 = this.mSingleDataFileChooserWizardDilaog.getFileName();
                if (this.mSingleDataFileChooserWizardDilaog.isLocalFileSelected()) {
                    File file = new File(string2);
                    String string3 = file.getAbsolutePath();
                    if (SGApplicationUtility.isNetCDFFile(string3)) {
                        this.setupDataTypeSelectionWizardDialogConnection(4, 0);
                        if (!this.toDataTypeDialog((Window)this.mSingleDataFileChooserWizardDilaog, this.mNetCDFDataTypeSelectionWizardDialog, file)) {
                            return false;
                        }
                    } else {
                        this.setupDataTypeSelectionWizardDialogConnection(0, 0);
                        if (!this.toDataTypeDialog((Window)this.mSingleDataFileChooserWizardDilaog, this.mArrayDataTypeSelectionWizardDialog, file)) {
                            return false;
                        }
                    }
                    this.mSingleDataFileChooserWizardDilaog.setSelectedFile(file);
                } else {
                    this.setupDataTypeSelectionWizardDialogConnection(4, 0);
                }
                sGWizardDialog.showNext();
            } else if (sGWizardDialog.equals(this.mArrayDataTypeSelectionWizardDialog)) {
                File file = this.mSingleDataFileChooserWizardDilaog.getSelectedFile();
                if (!this.makeTransition(this.mArrayDataTypeSelectionWizardDialog, this.mDataColumnSelectionWizardDialog, file)) {
                    return false;
                }
            } else if (sGWizardDialog.equals(this.mNetCDFDataTypeSelectionWizardDialog)) {
                String string4 = this.mSingleDataFileChooserWizardDilaog.getFileName();
                if (this.mSingleDataFileChooserWizardDilaog.isLocalFileSelected()) {
                    if (!this.makeTransition(this.mNetCDFDataTypeSelectionWizardDialog, this.mNetCDFSetupWizardDialog, string4)) {
                        return false;
                    }
                } else if (SGApplicationUtility.isNetCDFFile(string4)) {
                    if (!this.makeTransition(this.mNetCDFDataTypeSelectionWizardDialog, this.mNetCDFSetupWizardDialog, string4)) {
                        return false;
                    }
                } else if (SGUtility.showErrorMessageDialog(sGWizardDialog, ERRMSG_URL_OF_NETCDF, "Error")) {
                    this.mNetCDFDataTypeSelectionWizardDialog.setVisible(false);
                    this.mSingleDataFileChooserWizardDilaog.setVisible(true);
                }
            } else if (sGWizardDialog.equals(this.mDataColumnSelectionWizardDialog)) {
                String string5 = this.mArrayDataTypeSelectionWizardDialog.getSelectedDataType();
                this.setupPlotTypeSelectionWizardDialogConnection(0, string5);
                sGWizardDialog.showNext();
            } else if (sGWizardDialog.equals(this.mNetCDFSetupWizardDialog)) {
                String string6 = this.mNetCDFDataTypeSelectionWizardDialog.getSelectedDataType();
                this.setupPlotTypeSelectionWizardDialogConnection(4, string6);
                sGWizardDialog.showNext();
            }
        } else if (string.equals("OK")) {
            try {
                if (!this.addDataByToolBar(sGWizardDialog)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.clearTemporaryData();
            }
        }
        return true;
    }

    private boolean addDataByToolBar(SGWizardDialog sGWizardDialog) {
        String string;
        sGWizardDialog.setVisible(false);
        SGDrawingWindow sGDrawingWindow = sGWizardDialog.getOwnerWindow();
        int n = this.mFigureIDSelectionWizardDialog.getFigureID();
        String string2 = string = this.mSingleDataFileChooserWizardDilaog.getFileName();
        if (this.mSingleDataFileChooserWizardDilaog.isLocalFileSelected()) {
            File file = this.mSingleDataFileChooserWizardDilaog.getSelectedFile();
            string2 = file.getPath();
        }
        if (sGWizardDialog.equals(this.mArrayDataTypeSelectionWizardDialog) || sGWizardDialog.equals(this.mDataColumnSelectionWizardDialog) ? !this.drawNewGraphOfArrayDataByDadOrToolbar(sGDrawingWindow, sGWizardDialog, string2, n, null) : (sGWizardDialog.equals(this.mNetCDFDataTypeSelectionWizardDialog) || sGWizardDialog.equals(this.mNetCDFSetupWizardDialog) ? !this.drawNewGraphOfNetcdfDataByDadOrToolbar(sGDrawingWindow, sGWizardDialog, string2, n, null) : sGWizardDialog.equals(this.mPlotTypeSelectionWizardDialog) && (sGWizardDialog.getPrevious().equals(this.mDataColumnSelectionWizardDialog) ? !this.drawNewGraphOfArrayDataByDadOrToolbar(sGDrawingWindow, sGWizardDialog, string2, n, null) : !this.drawNewGraphOfNetcdfDataByDadOrToolbar(sGDrawingWindow, sGWizardDialog, string2, n, null)))) {
            return false;
        }
        sGDrawingWindow.notifyToRoot();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setupDefaultDimensionValues(String string, Map<String, Object> map) {
        map.put("Graphs for multiple variables", true);
        SGNetCDFFile sGNetCDFFile = (SGNetCDFFile)map.get("Data Source");
        NetcdfFile netcdfFile = null;
        try {
            netcdfFile = NetcdfFile.open((String)sGNetCDFFile.getNetcdfFile().getLocation());
            SGNetCDFFile sGNetCDFFile2 = new SGNetCDFFile(netcdfFile);
            if (!this.setupNetCDFDataSetupDialog(sGNetCDFFile2, string, map, this.mNetCDFSetupWizardDialog)) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                netcdfFile.close();
            }
            catch (IOException iOException) {}
        }
        map.put("Multiple dimension start", this.mNetCDFSetupWizardDialog.getMultipleDimensionStart());
        map.put("Multiple dimension end", this.mNetCDFSetupWizardDialog.getMultipleDimensionEnd());
        map.put("Multiple dimension step", this.mNetCDFSetupWizardDialog.getMultipleDimensionStep());
        return true;
    }

    private boolean toDataTypeDialog(Window window, SGArrayDataTypeSelectionWizardDialog sGArrayDataTypeSelectionWizardDialog, File file) {
        if (!file.exists()) {
            SGUtility.showFileNotFoundMessageDialog(window);
            return false;
        }
        String string = file.getPath();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (!this.mDataCreator.getDataTypeCandidateList(string, arrayList)) {
                SGApplicationUtility.showDataFileInvalidMessageDialog(window);
                return false;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            SGUtility.showFileNotFoundMessageDialog(window);
            return false;
        }
        if (arrayList.size() == 0) {
            SGApplicationUtility.showDataFileInvalidMessageDialog(window);
            return false;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList2.add(SGApplicationUtility.getArrayDataType((String)arrayList.get(i)));
        }
        if (!sGArrayDataTypeSelectionWizardDialog.setAvailableDataType(arrayList2)) {
            SGApplicationUtility.showDataFileInvalidMessageDialog(window);
            return false;
        }
        return true;
    }

    private boolean toDataTypeDialog(Window window, SGNetCDFDataTypeSelectionWizardDialog sGNetCDFDataTypeSelectionWizardDialog, File file) {
        if (!file.exists()) {
            SGUtility.showFileNotFoundMessageDialog(window);
            return false;
        }
        return true;
    }

    private boolean makeTransition(SGArrayDataTypeSelectionWizardDialog sGArrayDataTypeSelectionWizardDialog, SGArrayDataColumnSelectionWizardDialog sGArrayDataColumnSelectionWizardDialog, File file) {
        SGDrawingWindow sGDrawingWindow = sGArrayDataTypeSelectionWizardDialog.getOwnerWindow();
        sGArrayDataTypeSelectionWizardDialog.setVisible(false);
        String string = sGArrayDataTypeSelectionWizardDialog.getSelectedDataType();
        if (string == null) {
            SGUtility.showErrorMessageDialog(sGDrawingWindow, ERRMSG_TO_GET_DATA_TYPE, "Error");
            return false;
        }
        Map<String, Object> map = SGMainFunctions.createInfoMap(string, sGArrayDataTypeSelectionWizardDialog);
        String string2 = file.getPath();
        SGDataColumnInfoSet sGDataColumnInfoSet = this.getDefaultDataColumnInfo(string2, string, map, false, null);
        if (sGDataColumnInfoSet == null) {
            SGApplicationUtility.showDataFileInvalidMessageDialog(sGDrawingWindow);
            return false;
        }
        String string3 = SGUtility.createDataNameBase(string2);
        map.put("Data Name", string3);
        sGArrayDataColumnSelectionWizardDialog.setData(string, sGDataColumnInfoSet, map, false);
        sGArrayDataColumnSelectionWizardDialog.setCenter(sGDrawingWindow);
        sGArrayDataColumnSelectionWizardDialog.setVisible(true);
        return true;
    }

    private boolean makeTransition(SGNetCDFDataTypeSelectionWizardDialog sGNetCDFDataTypeSelectionWizardDialog, SGNetCDFDataSetupWizardDialog sGNetCDFDataSetupWizardDialog, String string) {
        Window window = sGNetCDFDataTypeSelectionWizardDialog.getOwner();
        sGNetCDFDataTypeSelectionWizardDialog.setVisible(false);
        String string2 = sGNetCDFDataTypeSelectionWizardDialog.getSelectedDataType();
        if (string2 == null) {
            SGUtility.showErrorMessageDialog(window, ERRMSG_TO_GET_DATA_TYPE, "Error");
            return false;
        }
        Map<String, Object> map = SGMainFunctions.createInfoMap(string2, sGNetCDFDataTypeSelectionWizardDialog);
        String string3 = SGUtility.createDataNameBase(string);
        map.put("Data Name", string3);
        NetcdfFile netcdfFile = null;
        try {
            netcdfFile = NetcdfFile.open((String)string);
        }
        catch (IOException iOException) {
            return false;
        }
        SGNetCDFFile sGNetCDFFile = new SGNetCDFFile(netcdfFile);
        if (!this.setupNetCDFDataSetupDialog(sGNetCDFFile, string2, map, sGNetCDFDataSetupWizardDialog)) {
            return false;
        }
        try {
            netcdfFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        sGNetCDFDataSetupWizardDialog.setCenter(window);
        sGNetCDFDataSetupWizardDialog.setVisible(true);
        return true;
    }

    SGDataColumnInfoSet getDefaultDataColumnInfo(String string, String string2, Map<String, Object> map, boolean bl, String string3) {
        SGDataCreator.FileColumn[] fileColumnArray = null;
        try {
            fileColumnArray = this.mDataCreator.parseFileComlumnType(string, string2, bl, string3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        if (fileColumnArray == null) {
            return null;
        }
        SGDataColumnInfo[] sGDataColumnInfoArray = new SGDataColumnInfo[fileColumnArray.length];
        for (int i = 0; i < fileColumnArray.length; ++i) {
            sGDataColumnInfoArray[i] = new SGDataColumnInfo(fileColumnArray[i].title, fileColumnArray[i].valueType);
        }
        return this.createColumnInfoSet(string2, map, sGDataColumnInfoArray);
    }

    SGDataColumnInfoSet getDefaultDataColumnInfo(SGTextDataFile sGTextDataFile, String string, Map<String, Object> map) {
        SGDataColumn[] sGDataColumnArray = sGTextDataFile.getDataColumns();
        SGDataColumnInfo[] sGDataColumnInfoArray = new SGDataColumnInfo[sGDataColumnArray.length];
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            sGDataColumnInfoArray[i] = new SGDataColumnInfo(sGDataColumnArray[i].getTitle(), sGDataColumnArray[i].getValueType());
        }
        return this.createColumnInfoSet(string, map, sGDataColumnInfoArray);
    }

    SGDataColumnInfoSet getNetCDFDefaultDataColumnInfo(SGNetCDFFile sGNetCDFFile, String string, Map<String, Object> map) {
        List<SGVariable> list = sGNetCDFFile.getVariables();
        SGDataColumnInfo[] sGDataColumnInfoArray = SGDataUtility.getNetCDFDataColumnInfo(list, map);
        return this.createColumnInfoSet(string, map, sGDataColumnInfoArray);
    }

    public static Map<String, Object> createInfoMap(String string, SGDataTypeSelectionWizardDialog sGDataTypeSelectionWizardDialog) {
        SGArrayDataTypeSelectionWizardDialog sGArrayDataTypeSelectionWizardDialog;
        Double d;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("DataType", string);
        if (SGDataUtility.isVXYTypeData(string)) {
            boolean bl = sGDataTypeSelectionWizardDialog.isPolarSelected();
            hashMap.put("Polar selected", bl);
        }
        Boolean bl = sGDataTypeSelectionWizardDialog.isMultipleSelected();
        hashMap.put("Multiple", bl);
        if (SGDataUtility.isNetCDFData(string)) {
            hashMap.put("Graphs for multiple variables", true);
        } else if (SGDataUtility.isArrayData(string) && SGDataUtility.isSXYTypeData(string) && (d = (sGArrayDataTypeSelectionWizardDialog = (SGArrayDataTypeSelectionWizardDialog)sGDataTypeSelectionWizardDialog).getSamplingRate()) != null) {
            SGMainFunctions.putSamplingRate(hashMap, d);
        }
        return hashMap;
    }

    Map<String, Object> createInfoMap(String string, Element element) {
        Object object;
        Object object2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("DataType", string);
        if (SGDataUtility.isVXYTypeData(string)) {
            String string2 = element.getAttribute("Polar");
            if (string2.length() == 0) {
                return null;
            }
            object2 = SGUtilityText.getBoolean(string2);
            if (object2 == null) {
                return null;
            }
            hashMap.put("Polar selected", object2);
        }
        boolean bl = SGDataUtility.isMultipleData(string);
        hashMap.put("Multiple", bl);
        if (SGDataUtility.isNetCDFData(string)) {
            if (SGDataUtility.isNetCDFDimensionData(string)) {
                hashMap.put("Graphs for multiple variables", Boolean.FALSE);
            } else {
                hashMap.put("Graphs for multiple variables", Boolean.TRUE);
            }
            object2 = element.getAttribute("PickupDimensionName");
            if (null != object2 && ((String)object2).length() != 0) {
                hashMap.put("Graphs for multiple variables", Boolean.FALSE);
            }
            if (null != (object2 = element.getAttribute("PickupStart")) && ((String)object2).length() != 0) {
                object = SGUtilityText.getInteger(((String)object2).trim());
                hashMap.put("Multiple dimension start", object);
            }
            if (null != (object2 = element.getAttribute("PickupEnd")) && ((String)object2).length() != 0) {
                object = SGUtilityText.getInteger(((String)object2).trim());
                hashMap.put("Multiple dimension end", object);
            }
            if (null != (object2 = element.getAttribute("PickupStep")) && ((String)object2).length() != 0) {
                object = SGUtilityText.getInteger(((String)object2).trim());
                hashMap.put("Multiple dimension step", object);
            }
        }
        if (((String)(object2 = element.getAttribute("SamplingRate"))).length() != 0) {
            SGMainFunctions.putSamplingRate(hashMap, (String)object2);
        }
        object = element.getAttributes();
        hashMap.put("NodeMap", object);
        return hashMap;
    }

    Map<String, Object> createInfoMap(String string, SGPropertyMap sGPropertyMap) {
        Object object;
        Object object2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("DataType", string);
        if (SGDataUtility.isVXYTypeData(string)) {
            String string2 = null;
            object2 = sGPropertyMap.getKeyIterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (!"Polar".equalsIgnoreCase((String)object)) continue;
                string2 = sGPropertyMap.getValueString((String)object);
                break;
            }
            if (string2 == null) {
                return null;
            }
            object = SGUtilityText.getBoolean(string2);
            if (object == null) {
                return null;
            }
            hashMap.put("Polar selected", object);
        }
        boolean bl = SGDataUtility.isMultipleData(string);
        hashMap.put("Multiple", bl);
        if (SGDataUtility.isNetCDFData(string)) {
            if (SGDataUtility.isNetCDFDimensionData(string)) {
                hashMap.put("Graphs for multiple variables", Boolean.FALSE);
            } else {
                hashMap.put("Graphs for multiple variables", Boolean.TRUE);
            }
        }
        if (string.equalsIgnoreCase("SXY_SAMPLING") || string.equalsIgnoreCase("SXY_MULTIPLE")) {
            object2 = null;
            object = sGPropertyMap.getKeyIterator();
            while (object.hasNext()) {
                String string3 = object.next();
                if (!"SamplingRate".equalsIgnoreCase(string3)) continue;
                object2 = sGPropertyMap.getValueString(string3);
                break;
            }
            if (object2 != null) {
                if (!SGMainFunctions.putSamplingRate(hashMap, object2)) {
                    return null;
                }
                if (string.equalsIgnoreCase("SXY_SAMPLING")) {
                    hashMap.put("DataType", "SXY_MULTIPLE");
                    hashMap.put("Multiple", false);
                }
            }
        }
        return hashMap;
    }

    private static boolean putSamplingRate(Map<String, Object> map, String string) {
        Double d = SGUtilityText.getDouble(string);
        if (d == null) {
            return false;
        }
        return SGMainFunctions.putSamplingRate(map, d);
    }

    private static boolean putSamplingRate(Map<String, Object> map, Double d) {
        if (d <= 0.0) {
            return false;
        }
        map.put("Sampling rate", d);
        return true;
    }

    boolean drawGraphFromDialog(SGDrawingWindow sGDrawingWindow) {
        this.createDataAdditionWizardDialogs(sGDrawingWindow);
        int[] nArray = sGDrawingWindow.getVisibleFigureIDArray();
        this.mFigureIDSelectionWizardDialog.setIDNumbers(nArray);
        this.mFigureIDSelectionWizardDialog.setCenter(sGDrawingWindow);
        this.mFigureIDSelectionWizardDialog.setVisible(true);
        File file = this.mSingleDataFileChooserWizardDilaog.getSelectedFile();
        if (file == null) {
            return false;
        }
        this.updateCurrentFile(file, 0);
        return true;
    }

    private Boolean drawGraphSub(SGDrawingWindow sGDrawingWindow, int n, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map, String string, Integer[] integerArray, boolean bl, Point point) {
        if (sGDrawingWindow == null || map == null || string == null) {
            return Boolean.FALSE;
        }
        if (map.size() == 0) {
            return Boolean.FALSE;
        }
        String string2 = null;
        Object object = map.get("Data Name");
        if (object != null) {
            string2 = (String)object;
        } else {
            string2 = SGUtility.createDataNameBase(string);
            if (string2 == null) {
                return Boolean.FALSE;
            }
        }
        SGFigure sGFigure = sGDrawingWindow.getFigure(n);
        SGDataCreator.CreatedDataSet createdDataSet = null;
        try {
            createdDataSet = this.mDataCreator.create(string, sGDataColumnInfoSet, map, sGDrawingWindow, null, -1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (bl) {
                SGUtility.showFileNotFoundMessageDialog(sGDrawingWindow);
            }
            return Boolean.FALSE;
        }
        if (createdDataSet == null) {
            return Boolean.FALSE;
        }
        return this.addDataToDrawGraph(sGDrawingWindow, n, integerArray, bl, map, point, sGFigure, createdDataSet, string2, false);
    }

    boolean addDataToDrawGraph(SGDrawingWindow sGDrawingWindow, int n, Integer[] integerArray, boolean bl, Map<String, Object> map, Point point, SGFigure sGFigure, SGDataCreator.CreatedDataSet createdDataSet, String string, boolean bl2) {
        int n2 = createdDataSet.getDataLength();
        if (n2 == 0) {
            if (bl) {
                SGApplicationUtility.showDataFileInvalidMessageDialog(sGDrawingWindow);
            }
            return Boolean.FALSE;
        }
        String[] stringArray = new String[n2];
        SGData[] sGDataArray = new SGData[n2];
        for (int i = 0; i < n2; ++i) {
            SGDataCreator.CreatedData createdData = createdDataSet.getData(i);
            sGDataArray[i] = createdData.getData();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            String string2 = createdData.getTitle();
            if (string2 != null) {
                stringBuffer.append(createdDataSet.getMiddleString());
                stringBuffer.append(string2);
            }
            stringArray[i] = stringBuffer.toString();
        }
        if (!this.addData(sGDrawingWindow, n, integerArray, bl, point, sGFigure, sGDataArray, stringArray, map)) {
            return Boolean.FALSE;
        }
        if (bl2) {
            SGIFigureElementGraph sGIFigureElementGraph = sGFigure.getGraphElement();
            for (int i = 0; i < sGDataArray.length; ++i) {
                sGIFigureElementGraph.setDataFocused(sGDataArray[i], true);
            }
            sGFigure.fitAxisRangeToFocusedData();
        }
        return Boolean.TRUE;
    }

    private boolean addData(SGDrawingWindow sGDrawingWindow, int n, Integer[] integerArray, boolean bl, Point point, SGFigure sGFigure, SGData[] sGDataArray, String[] stringArray, Map<String, Object> map) {
        boolean bl2;
        boolean bl3 = bl2 = sGFigure == null;
        if (sGFigure != null && !sGFigure.isVisible()) {
            bl2 = true;
        }
        if (bl2) {
            if (!this.mFigureCreator.createNewFigure(sGDrawingWindow, n, point, integerArray, sGDataArray, stringArray, map)) {
                return Boolean.FALSE;
            }
            Object object = map.get("PlotTypeBar");
            if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
                SGFigure sGFigure2 = sGDrawingWindow.getFigure(n);
                sGFigure2.fitAxisRangeToVisibleData();
            }
        } else {
            SGDrawingWindow sGDrawingWindow2 = sGDrawingWindow;
            sGDrawingWindow2.endProgress();
            sGDrawingWindow2.startProgress();
            sGDrawingWindow2.setProgressMessage("Add Data");
            if (!sGFigure.addData(sGDataArray, integerArray, stringArray, sGDrawingWindow2, 0.0f, 1.0f, map)) {
                sGDrawingWindow2.endProgress();
                if (bl) {
                    SGApplicationUtility.showDataFileInvalidMessageDialog(sGDrawingWindow);
                }
            }
            if (sGFigure.getClassType() == null || sGFigure.getClassType().equals("")) {
                String string = "";
                SGData sGData = sGDataArray[0];
                if (sGData instanceof SGISXYTypeData || sGData instanceof SGISXYTypeMultipleData) {
                    string = "SXY";
                } else if (sGData instanceof SGIVXYTypeData) {
                    string = "VXY";
                } else if (sGData instanceof SGISXYZTypeData) {
                    string = "SXY";
                }
                sGFigure.setClassType(string);
            }
            sGDrawingWindow2.endProgress();
        }
        return true;
    }

    boolean drawGraph(final SGDrawingWindow sGDrawingWindow, final int n, final SGDataColumnInfoSet sGDataColumnInfoSet, final Map<String, Object> map, final String string, final Integer[] integerArray, final boolean bl, final Point point) {
        Boolean bl2 = null;
        sGDrawingWindow.setWaitCursor(true);
        if (!USE_FOXTROT) {
            bl2 = this.drawGraphSub(sGDrawingWindow, n, sGDataColumnInfoSet, map, string, integerArray, bl, point);
        } else {
            try {
                bl2 = (Boolean)Worker.post(new Task(){

                    public Object run() throws Exception {
                        return SGMainFunctions.this.drawGraphSub(sGDrawingWindow, n, sGDataColumnInfoSet, map, string, integerArray, bl, point);
                    }
                });
            }
            catch (Exception exception) {
                bl2 = Boolean.FALSE;
                exception.printStackTrace();
            }
        }
        sGDrawingWindow.setWaitCursor(false);
        return bl2;
    }

    void updateCurrentFile(File file, int n) {
        String string = file.getParent();
        if (string != null) {
            this.setCurrentFileDirectory(string);
            String string2 = file.getPath();
            String string3 = string2.substring(string.length() + 1);
            this.updateCurrentFile(string3, n);
        }
    }

    void updateCurrentFile(String string, int n) {
        if (n == 0) {
            this.mCurrentDataFileName = string;
        } else if (n == 1) {
            this.mCurrentPropertyFileName = string;
        } else if (n == 3) {
            this.mCurrentImageFileName = string;
        } else if (n == 2) {
            this.mCurrentArchiveFileName = string;
        } else if (n == 4) {
            this.mCurrentNetCDFFileName = string;
        } else if (n == 6) {
            this.mCurrentOutputDataFileName = string;
        }
    }

    private boolean isDataAdditionDialog(Object object) {
        return object.equals(this.mFigureIDSelectionWizardDialog) || object.equals(this.mSingleDataFileChooserWizardDilaog) || object.equals(this.mArrayDataTypeSelectionWizardDialog) || object.equals(this.mDataColumnSelectionWizardDialog) || object.equals(this.mNetCDFDataTypeSelectionWizardDialog) || object.equals(this.mNetCDFSetupWizardDialog) || object.equals(this.mPlotTypeSelectionWizardDialog);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.isDataAdditionDialog(object)) {
            if (this.mDroppedFile != null) {
                this.addDataByDragAndDrop(actionEvent);
            } else if (this.mTransformedData != null) {
                this.addDataByDataTransformation(actionEvent);
            } else {
                this.addDataByToolBar(actionEvent);
            }
        }
    }

    public void exit() {
        this.mWindowManager.closeAllWindow();
    }

    void exitApplication(int n) {
        if (n != 0) {
            String string = "A fatal error has occured.\nThe current application will be terminated.";
            String string2 = " Forced termination";
            SGUtility.showMessageDialog(null, string, string2, 0);
        }
        this.mClipBoardManager.dispose();
        this.mPluginManager.dispose();
        System.exit(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openFile(SGDrawingWindow sGDrawingWindow, String string) {
        block26: {
            if (sGDrawingWindow == null) {
                sGDrawingWindow = this.mWindowManager.getCurrentWindow();
            }
            if (sGDrawingWindow == null) {
                return false;
            }
            sGDrawingWindow.setWaitCursor(true);
            try {
                File file = null;
                File file2 = null;
                File file3 = null;
                File file4 = new File(string);
                String string2 = file4.getAbsolutePath();
                boolean bl = SGApplicationUtility.hasExtension(string2, "sgp");
                boolean bl2 = SGApplicationUtility.hasExtension(string2, "sga");
                boolean bl3 = SGApplicationUtility.hasExtension(string2, "sgs");
                if (bl) {
                    file = file4;
                } else if (bl2) {
                    file2 = file4;
                } else if (bl3) {
                    file3 = file4;
                } else {
                    boolean bl4 = false;
                    return bl4;
                }
                if (file != null) {
                    boolean bl5;
                    if (sGDrawingWindow.needsConfirmationBeforeDiscard() && (bl5 = this.beforeDiscard(sGDrawingWindow))) {
                        boolean bl6 = true;
                        return bl6;
                    }
                    if (!this.mPropertyFileManager.showMultiDataFileChooserDialog(file, sGDrawingWindow)) {
                        bl5 = false;
                        return bl5;
                    }
                    break block26;
                }
                if (file2 != null) {
                    boolean bl7;
                    if (sGDrawingWindow.needsConfirmationBeforeDiscard() && (bl7 = this.beforeDiscard(sGDrawingWindow))) {
                        boolean bl8 = true;
                        return bl8;
                    }
                    bl7 = this.mDataSetManager.loadDataSetFromEventDispatchThread(sGDrawingWindow, file2);
                    sGDrawingWindow.setSaved(bl7);
                    break block26;
                }
                if (file3 != null) {
                    this.mStdoutWriter = new BufferedWriter(new OutputStreamWriter(System.out));
                    this.readCommand(file3.getPath());
                    this.mStdinReader = new BufferedReader(new InputStreamReader(System.in));
                    try {
                        this.startReadingInput();
                        break block26;
                    }
                    catch (IOException iOException) {
                        boolean bl9 = false;
                        sGDrawingWindow.setWaitCursor(false);
                        return bl9;
                    }
                }
                boolean bl10 = false;
                return bl10;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                sGDrawingWindow.setWaitCursor(false);
            }
        }
        return true;
    }

    private void startReadingInput() throws IOException {
        this.readRecursively(this.mStdinReader, this.mStdoutWriter, 0, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean fromDragAndDrop(int n, int n2, SGDrawingWindow sGDrawingWindow, List<File> list) {
        sGDrawingWindow.setWaitCursor(true);
        try {
            Object object;
            int n3;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            Object object2 = null;
            Object object3 = null;
            Object object4 = null;
            Object object5 = null;
            Object object6 = null;
            for (n3 = 0; n3 < list.size(); ++n3) {
                int n4;
                object = list.get(n3);
                String string = ((File)object).getAbsolutePath();
                boolean bl = SGApplicationUtility.hasExtension(string, "sgp");
                boolean bl2 = SGApplicationUtility.hasExtension(string, "sga");
                boolean bl3 = SGApplicationUtility.hasExtension(string, "sgs");
                boolean bl4 = false;
                String[] stringArray = SGIImageConstants.DRAWABLE_IMAGE_EXTENSIONS;
                for (n4 = 0; n4 < stringArray.length; ++n4) {
                    if (!SGApplicationUtility.hasExtension(string, stringArray[n4])) continue;
                    bl4 = true;
                    break;
                }
                n4 = 0;
                boolean bl5 = false;
                if (SGApplicationUtility.isNetCDFFile(string)) {
                    if (SGNetCDFDataSetManager.isNetCDFDatasetFile(string)) {
                        n4 = 1;
                    } else {
                        bl5 = true;
                    }
                }
                if (bl) {
                    object2 = object;
                    continue;
                }
                if (bl2) {
                    object3 = object;
                    continue;
                }
                if (bl3) {
                    object5 = object;
                    continue;
                }
                if (bl4) {
                    object6 = object;
                    continue;
                }
                if (n4 != 0) {
                    object4 = object;
                    continue;
                }
                if (bl5) {
                    arrayList2.add(object);
                    continue;
                }
                arrayList.add(object);
            }
            if (object2 != null) {
                if (sGDrawingWindow.needsConfirmationBeforeDiscard() && (n3 = this.beforeDiscard(sGDrawingWindow)) == 1) {
                    boolean bl = true;
                    return bl;
                }
                if (!this.mPropertyFileManager.showMultiDataFileChooserDialog((File)object2, sGDrawingWindow)) {
                    n3 = 0;
                    return n3 != 0;
                }
            } else if (object3 != null) {
                if (sGDrawingWindow.needsConfirmationBeforeDiscard() && (n3 = this.beforeDiscard(sGDrawingWindow)) == 1) {
                    boolean bl = true;
                    return bl;
                }
                SGUtility.clearMessageDialogVisible();
                n3 = this.mDataSetManager.loadDataSetFromEventDispatchThread(sGDrawingWindow, (File)object3) ? 1 : 0;
                if (n3 == 0 && !SGUtility.wasMessageDialogVisible()) {
                    SGUtility.showErrorMessageDialog(sGDrawingWindow, ERRMSG_TO_LOAD_DATASET, "Error");
                }
                SGUtility.clearMessageDialogVisible();
                sGDrawingWindow.setSaved(n3 != 0);
            } else if (object4 != null) {
                if (sGDrawingWindow.needsConfirmationBeforeDiscard() && (n3 = this.beforeDiscard(sGDrawingWindow)) == 1) {
                    boolean bl = true;
                    return bl;
                }
                SGUtility.clearMessageDialogVisible();
                n3 = this.mDataSetManager.loadDataSetFromEventDispatchThread(sGDrawingWindow, (File)object4) ? 1 : 0;
                if (n3 == 0 && !SGUtility.wasMessageDialogVisible()) {
                    SGUtility.showErrorMessageDialog(sGDrawingWindow, ERRMSG_TO_LOAD_DATASET, "Error");
                }
                SGUtility.clearMessageDialogVisible();
                sGDrawingWindow.setSaved(n3 != 0);
            } else if (object5 != null) {
                if (this.mStdoutWriter != null && this.mStdinReader != null) {
                    this.readCommand(((File)object5).getPath());
                } else {
                    SGUtility.showErrorMessageDialog(sGDrawingWindow, ERRMSG_SCRIPT_START, "Error");
                }
            } else if (object6 != null) {
                byte[] byArray = SGApplicationUtility.toByteArray(object6);
                object = SGApplicationUtility.getExtension(object6);
                if (object == null) {
                    boolean bl = false;
                    return bl;
                }
                if (!sGDrawingWindow.setImage(byArray, (String)object, true)) {
                    boolean bl = false;
                    return bl;
                }
            } else if (arrayList2.size() != 0) {
                if (!this.onNetCDFDataFilesDropped(new Point(n, n2), sGDrawingWindow, arrayList2)) {
                    n3 = 0;
                    return n3 != 0;
                }
            } else if (!this.onTextDataFilesDropped(new Point(n, n2), sGDrawingWindow, arrayList)) {
                n3 = 0;
                return n3 != 0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            sGDrawingWindow.setWaitCursor(false);
        }
        return true;
    }

    void updateToolBarPatternInPreferences(String[] stringArray) {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i == stringArray.length - 1) continue;
            stringBuffer.append(',');
        }
        preferences.put("Tool Bar Pattern", stringBuffer.toString());
    }

    private int createSingleFigureFromPropertyFile(Element element, SGDrawingWindow sGDrawingWindow, ArrayList<WrappedData> arrayList, boolean bl, String string, int n) {
        int n2;
        SGIFigureElementAxis sGIFigureElementAxis;
        float f;
        StringBuffer stringBuffer;
        String string2 = null;
        Number number = null;
        string2 = element.getAttribute("Type");
        if (string2.length() == 0) {
            return 1;
        }
        SGXYFigure sGXYFigure = null;
        if (!("SXY".equals(string2) || "VXY".equals(string2) || "XY".equals(string2))) {
            return 1;
        }
        sGXYFigure = new SGXYFigure(sGDrawingWindow);
        sGXYFigure.setClassType(string2);
        int n3 = sGDrawingWindow.assignFigureId();
        sGXYFigure.setID(n3);
        if (!sGXYFigure.readProperty(element)) {
            return 1;
        }
        if (this.mFigureCreator.createFigureElementFromPropertyFile(sGXYFigure, element) == 1) {
            return 1;
        }
        string2 = element.getAttribute("SpaceAxisLineAndNumber");
        if (string2.length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string2, stringBuffer);
            if (number == null) {
                return 1;
            }
            f = number.floatValue();
            sGIFigureElementAxis = sGXYFigure.getAxisElement();
            sGIFigureElementAxis.setSpaceAxisLineAndNumber(f, stringBuffer.toString());
            if (!sGXYFigure.setSpaceAxisLineAndNumber(f, stringBuffer.toString())) {
                return 1;
            }
        }
        if ((string2 = element.getAttribute("SpaceNumberAndTitle")).length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string2, stringBuffer);
            if (number == null) {
                return 1;
            }
            f = number.floatValue();
            sGIFigureElementAxis = sGXYFigure.getAxisElement();
            sGIFigureElementAxis.setSpaceNumberAndTitle(f, stringBuffer.toString());
            if (!sGXYFigure.setSpaceNumberAndTitle(f, stringBuffer.toString())) {
                return 1;
            }
        }
        if ((n2 = this.createDataObjectsFromPropertyFile(element, sGXYFigure, arrayList, sGDrawingWindow, bl, string, n)) != 0) {
            return n2;
        }
        sGDrawingWindow.addFigure(sGXYFigure);
        sGXYFigure.initPropertiesHistory();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int createDataObjectsFromPropertyFile(Element element, SGFigure sGFigure, ArrayList<WrappedData> arrayList, SGIProgressControl sGIProgressControl, boolean bl, String string, int n) {
        NodeList nodeList = element.getElementsByTagName("Data");
        int n2 = nodeList.getLength();
        if (n2 != arrayList.size()) {
            return 1;
        }
        int[] nArray = new int[n2];
        SGData[] sGDataArray = new SGData[n2];
        boolean bl2 = true;
        for (int i = 0; i < n2; ++i) {
            Object object;
            Object object2;
            SGData sGData;
            Element element2;
            block55: {
                Object object3;
                Object object4;
                void var19_20;
                String string2;
                block53: {
                    block56: {
                        Node node = nodeList.item(i);
                        if (!(node instanceof Element)) continue;
                        element2 = (Element)node;
                        string2 = element2.getAttribute("Type");
                        if (string2 == null) {
                            return 1;
                        }
                        string2 = SGApplicationUtility.getArrayDataType(string2);
                        Object var19_21 = null;
                        if (!SGDataUtility.isArrayData(string2)) break block56;
                        if (SGDataUtility.isSXYTypeData(string2)) {
                            Class<SGSXYMultipleData> clazz = SGSXYMultipleData.class;
                            break block53;
                        } else if ("VXY".equals(string2)) {
                            Class<SGVXYData> clazz = SGVXYData.class;
                            break block53;
                        } else {
                            if (!"SXYZ".equals(string2)) return 1;
                            Class<SGSXYZData> clazz = SGSXYZData.class;
                        }
                        break block53;
                    }
                    if (!SGDataUtility.isNetCDFData(string2)) return 1;
                    if (SGDataUtility.isSXYTypeData(string2)) {
                        if (SGDataUtility.isNetCDFDimensionData(string2)) {
                            Class<SGSXYMultipleDimensionNetCDFData> clazz = SGSXYMultipleDimensionNetCDFData.class;
                        } else {
                            Class<SGSXYMultipleVariableNetCDFData> clazz = SGSXYMultipleVariableNetCDFData.class;
                        }
                    } else if ("VXY_NETCDF".equals(string2)) {
                        Class<SGVXYNetCDFData> clazz = SGVXYNetCDFData.class;
                    } else {
                        if (!"SXYZ_NETCDF".equals(string2)) return 1;
                        Class<SGSXYZNetCDFData> clazz = SGSXYZNetCDFData.class;
                    }
                }
                String string3 = var19_20.getName();
                if ("XY".equals(sGFigure.getClassType())) {
                    object4 = null;
                    object4 = SGDataUtility.isVXYTypeData(string2) ? "VXY" : "SXY";
                    sGFigure.setClassType((String)object4);
                }
                object4 = this.createInfoMap(string2, element2);
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(string3);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return 1;
                }
                if (clazz == null) {
                    return 1;
                }
                sGData = null;
                try {
                    object3 = clazz.newInstance();
                    if (object3 instanceof SGData) {
                        sGData = (SGData)object3;
                    }
                }
                catch (Exception exception) {
                    return 1;
                }
                if (sGData == null) {
                    return 1;
                }
                if (arrayList.size() == 0) {
                    return 3;
                }
                object3 = arrayList.get(i);
                if (!((WrappedData)object3).hasFigureData()) {
                    object2 = ((WrappedData)object3).getPropertyFileData();
                    object = ((SGPropertyFileData)object2).getFileName();
                    try {
                        Object object5;
                        Object object6;
                        Object object7;
                        SGDataColumnInfoSet sGDataColumnInfoSet = ((SGPropertyFileData)object2).getColumnInfoSet();
                        if (sGDataColumnInfoSet == null) {
                            if (SGDataUtility.isArrayData(string2)) {
                                sGDataColumnInfoSet = this.getDefaultDataColumnInfo((String)object, string2, (Map<String, Object>)object4, true, string);
                            } else {
                                if (!SGDataUtility.isNetCDFData(string2)) return 2;
                                object7 = null;
                                try {
                                    if (!NetcdfFile.canOpen((String)object)) {
                                        return 2;
                                    }
                                    object7 = NetcdfFile.open((String)object);
                                    try {
                                        object6 = new SGNetCDFFile((NetcdfFile)object7);
                                        object4.put("Data Source", object6);
                                        sGDataColumnInfoSet = this.getNetCDFDefaultDataColumnInfo((SGNetCDFFile)object6, string2, (Map<String, Object>)object4);
                                    }
                                    finally {
                                        object7.close();
                                    }
                                }
                                catch (Exception exception) {
                                    return 2;
                                }
                            }
                            if (sGDataColumnInfoSet == null) {
                                return 2;
                            }
                        }
                        if (SGDataUtility.isNetCDFDimensionData(string2)) {
                            object7 = ((SGPropertyFileData)object2).getInfoMap();
                            object6 = object7.get("Multiple dimension start");
                            object5 = object7.get("Multiple dimension end");
                            Object v = object7.get("Multiple dimension step");
                            if (object6 == null || object5 == null || v == null) {
                                SGDataColumnInfo[] sGDataColumnInfoArray = sGDataColumnInfoSet.getDataColumnInfoArray();
                                SGNetCDFDataColumnInfo[] sGNetCDFDataColumnInfoArray = new SGNetCDFDataColumnInfo[sGDataColumnInfoArray.length];
                                for (int j = 0; j < sGNetCDFDataColumnInfoArray.length; ++j) {
                                    sGNetCDFDataColumnInfoArray[j] = (SGNetCDFDataColumnInfo)sGDataColumnInfoArray[j];
                                }
                                SGDataUtility.updatePickupParameters((Map<String, Object>)object4, sGNetCDFDataColumnInfoArray);
                            }
                            if (object6 != null) {
                                object4.put("Multiple dimension start", object6);
                            }
                            if (object5 != null) {
                                object4.put("Multiple dimension end", object5);
                            }
                            if (v != null) {
                                object4.put("Multiple dimension step", v);
                            }
                        }
                        if ((object7 = this.mDataCreator.create((String)object, sGDataColumnInfoSet, (Map<String, Object>)object4, sGIProgressControl, string, n)) == null) {
                            return 2;
                        }
                        if (((SGDataCreator.CreatedDataSet)object7).getDataLength() == 0) {
                            return 2;
                        }
                        object6 = ((SGDataCreator.CreatedDataSet)object7).getData(0);
                        object5 = ((SGDataCreator.CreatedData)object6).getData();
                        try {
                            if (!sGData.setData((SGData)object5)) {
                                int n3 = 2;
                                return n3;
                            }
                            break block55;
                        }
                        finally {
                            ((SGData)object5).dispose();
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        return 5;
                    }
                }
                if (!((WrappedData)object3).hasFigureData()) return 1;
                if (!sGData.setData(((WrappedData)object3).getFigureData().getData())) {
                    return 1;
                }
            }
            if (((String)(object2 = element2.getAttribute("IndexInLegend"))).length() != 0) {
                object = SGUtilityText.getInteger((String)object2);
                if (object == null) {
                    return 1;
                }
                nArray[i] = ((Number)object).intValue();
                sGDataArray[i] = sGData;
            } else {
                bl2 = false;
            }
            if (sGFigure.createDataObjectFromPropertyFile(element2, sGData, bl)) continue;
            return 1;
        }
        if (bl2) {
            SGIFigureElementLegend sGIFigureElementLegend = sGFigure.getLegendElement();
            sGIFigureElementLegend.sortLegend(sGDataArray, nArray);
        }
        SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
        int i = 0;
        while (i < sGIFigureElementArray.length) {
            sGIFigureElementArray[i].initPropertiesHistory();
            ++i;
        }
        return 0;
    }

    int createFiguresFromPropertyFile(Element element, SGDrawingWindow sGDrawingWindow, WrappedData[] wrappedDataArray, boolean bl, String string, int n) {
        NodeList nodeList = element.getElementsByTagName("Figure");
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            int n3;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            ArrayList<WrappedData> arrayList = new ArrayList<WrappedData>();
            for (n3 = 0; n3 < wrappedDataArray.length; ++n3) {
                String string2;
                Object object;
                if (wrappedDataArray[n3].hasFigureData()) {
                    object = wrappedDataArray[n3].getFigureData();
                    if (((FigureData)object).getSerialFigureNo() != i) continue;
                    arrayList.add(wrappedDataArray[n3]);
                    continue;
                }
                object = wrappedDataArray[n3].getPropertyFileData();
                if (((SGPropertyFileData)object).getFigureId() != i + 1 || (string2 = ((SGPropertyFileData)object).getFileName()) == null || "NO_DATA".equals(string2)) continue;
                arrayList.add(wrappedDataArray[n3]);
            }
            n3 = this.createSingleFigureFromPropertyFile(element2, sGDrawingWindow, arrayList, bl, string, n);
            if (n3 == 0) continue;
            return n3;
        }
        return 0;
    }

    private boolean onTextDataFilesDropped(Point point, SGDrawingWindow sGDrawingWindow, List list) {
        this.createDataAdditionWizardDialogs(sGDrawingWindow);
        this.setupDataTypeSelectionWizardDialogConnection(0, 1);
        File file = (File)list.get(0);
        this.mDroppedFile = new DroppedData(point, file);
        if (!this.toDataTypeDialog((Window)sGDrawingWindow, this.mArrayDataTypeSelectionWizardDialog, this.mDroppedFile.file)) {
            return false;
        }
        this.mArrayDataTypeSelectionWizardDialog.setCenter(sGDrawingWindow);
        this.mArrayDataTypeSelectionWizardDialog.setVisible(true);
        return true;
    }

    private boolean onNetCDFDataFilesDropped(Point point, SGDrawingWindow sGDrawingWindow, List list) {
        int n;
        this.createDataAdditionWizardDialogs(sGDrawingWindow);
        this.setupDataTypeSelectionWizardDialogConnection(4, 1);
        File file = (File)list.get(0);
        NetcdfFile netcdfFile = null;
        try {
            netcdfFile = NetcdfFile.open((String)file.getPath());
        }
        catch (IOException iOException) {
            return false;
        }
        final Attribute attribute = netcdfFile.findGlobalAttribute("samurai_graph_command");
        if (attribute != null && (n = JOptionPane.showConfirmDialog(sGDrawingWindow, "This netCDF data has commands. Execute them?", "Confirmation", 2, 3)) == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('\"');
            stringBuffer.append(file.getPath());
            stringBuffer.append('\"');
            this.mPropertyManager.addAlias("Data", "FilePath", "\".\"", stringBuffer.toString());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Thread thread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Loose catch block
                         */
                        public void run() {
                            block10: {
                                String string = attribute.getStringValue();
                                SGMainFunctions.this.mStdoutWriter = new BufferedWriter(new OutputStreamWriter(System.out));
                                SGMainFunctions.this.mStdinReader = new BufferedReader(new StringReader(string));
                                SGMainFunctions.this.startReadingInput();
                                SGMainFunctions.this.mPropertyManager.removeAlias("\".\"");
                                try {
                                    SGMainFunctions.this.mStdinReader.close();
                                    SGMainFunctions.this.mStdinReader = new BufferedReader(new InputStreamReader(System.in));
                                    SGMainFunctions.this.startReadingInput();
                                }
                                catch (IOException iOException) {}
                                break block10;
                                catch (IOException iOException) {
                                    try {
                                        SGMainFunctions.this.mStdinReader.close();
                                        SGMainFunctions.this.mStdinReader = new BufferedReader(new InputStreamReader(System.in));
                                        SGMainFunctions.this.startReadingInput();
                                    }
                                    catch (IOException iOException2) {
                                        // empty catch block
                                    }
                                    return;
                                    catch (Throwable throwable) {
                                        try {
                                            SGMainFunctions.this.mStdinReader.close();
                                            SGMainFunctions.this.mStdinReader = new BufferedReader(new InputStreamReader(System.in));
                                            SGMainFunctions.this.startReadingInput();
                                        }
                                        catch (IOException iOException3) {
                                            // empty catch block
                                        }
                                        throw throwable;
                                    }
                                }
                            }
                        }
                    };
                    thread.start();
                }
            });
            return true;
        }
        this.mDroppedFile = new DroppedData(point, file);
        if (!this.toDataTypeDialog((Window)sGDrawingWindow, this.mNetCDFDataTypeSelectionWizardDialog, this.mDroppedFile.file)) {
            return false;
        }
        this.mNetCDFDataTypeSelectionWizardDialog.setCenter(sGDrawingWindow);
        this.mNetCDFDataTypeSelectionWizardDialog.setVisible(true);
        return true;
    }

    private boolean setupNetCDFDataSetupDialog(SGNetCDFFile sGNetCDFFile, String string, Map<String, Object> map, SGNetCDFDataSetupWizardDialog sGNetCDFDataSetupWizardDialog) {
        Window window = sGNetCDFDataSetupWizardDialog.getOwner();
        List<SGVariable> list = sGNetCDFFile.getVariables();
        int n = list.size();
        SGDataColumnInfo[] sGDataColumnInfoArray = new SGNetCDFDataColumnInfo[n];
        int n2 = 0;
        for (SGVariable sGVariable : list) {
            String string2 = sGVariable.getNameInPriorityOrder();
            sGDataColumnInfoArray[n2] = new SGNetCDFDataColumnInfo(sGVariable, string2, sGVariable.getValueType());
            ++n2;
        }
        SGDataColumnInfoSet sGDataColumnInfoSet = new SGDataColumnInfoSet(sGDataColumnInfoArray);
        if (!sGNetCDFDataSetupWizardDialog.setData(sGNetCDFFile, string, sGDataColumnInfoSet, map, true)) {
            SGUtility.showErrorMessageDialog(window, "Data file is incomplete.", "Error");
            return false;
        }
        sGNetCDFDataSetupWizardDialog.pack();
        return true;
    }

    private void readRecursively(BufferedReader bufferedReader, BufferedWriter bufferedWriter, int n, boolean bl, boolean bl2) throws IOException {
        if (++n > 10) {
            bufferedWriter.write("Recursion is too deep.\n");
            bufferedWriter.flush();
            return;
        }
        while (true) {
            int n2;
            String string;
            if (bl) {
                bufferedWriter.write(PROMPT);
                bufferedWriter.flush();
            }
            if ((string = bufferedReader.readLine()) == null) break;
            this.closeTextField();
            if (this.isDialogOpen()) {
                bufferedWriter.write("Dialog is open.\n");
                bufferedWriter.flush();
                continue;
            }
            String string2 = string.trim();
            if (string2.length() == 0 || string2.startsWith(COMMENT_HEADER) || string2.startsWith(COMMENT_HEADER_2)) continue;
            if (bl2) {
                n2 = string2.indexOf(BLOCK_COMMENT_START);
                int n3 = string2.indexOf(BLOCK_COMMENT_END);
                if (this.mBlockComment && (n2 < 0 && n3 >= 0 || n3 >= 0 && n2 > n3 + 1)) {
                    string2 = string2.substring(n3 + 2);
                    this.mBlockComment = false;
                    n2 = string2.indexOf(BLOCK_COMMENT_START);
                    n3 = string2.indexOf(BLOCK_COMMENT_END);
                }
                if (this.mBlockComment) continue;
                while (n2 >= 0 && n3 >= 1 && n2 + 1 < n3) {
                    string2 = string2.substring(0, n2) + string2.substring(n3 + 2);
                    n2 = string2.indexOf(BLOCK_COMMENT_START);
                    n3 = string2.indexOf(BLOCK_COMMENT_END);
                }
                n2 = string2.indexOf(BLOCK_COMMENT_START);
                if (n2 >= 0) {
                    this.mBlockComment = true;
                    string2 = string2.substring(0, n2);
                }
                if ((string2 = string2.trim()).length() == 0) continue;
            }
            if (string2.startsWith(FILE_INPUT)) {
                Object object;
                File file;
                String string3 = string2.substring(FILE_INPUT.length());
                if (SGUtilityText.isDoubleQuoted(string3 = string3.trim())) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                if (!(file = new File(string3)).exists()) {
                    object = this.getFileNotFoundString(file);
                    bufferedWriter.write((String)object);
                    bufferedWriter.flush();
                    continue;
                }
                object = new SGBufferedFileReader(string3);
                BufferedReader bufferedReader2 = ((SGBufferedFileReader)object).getBufferedReader();
                this.readRecursively(bufferedReader2, bufferedWriter, n, false, true);
                ((SGBufferedFileReader)object).close();
                continue;
            }
            n2 = this.exec(string2);
            StringBuffer stringBuffer = new StringBuffer();
            if (n2 == -1) {
                stringBuffer.append("failed: ");
            } else if (n2 == 1) {
                stringBuffer.append("not found: ");
            } else if (n2 == 0) {
                stringBuffer.append("succeeded: ");
            } else if (n2 == 2) {
                stringBuffer.append("partially failed: ");
            }
            stringBuffer.append(string2);
            stringBuffer.append('\n');
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.flush();
        }
    }

    private void readCommand(String string) {
        new CommandThread(string);
    }

    private String getFileNotFoundString(File file) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("file not found: ");
        stringBuffer.append(file.getPath());
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    boolean splitSXYData(final SGDrawingWindow sGDrawingWindow) {
        Boolean bl = null;
        sGDrawingWindow.setWaitCursor(true);
        if (!USE_FOXTROT) {
            bl = SGMainFunctionsSplitMerge.splitSXYDataSub(sGDrawingWindow);
        } else {
            try {
                bl = (Boolean)Worker.post(new Task(){

                    public Object run() throws Exception {
                        return SGMainFunctionsSplitMerge.splitSXYDataSub(sGDrawingWindow);
                    }
                });
            }
            catch (Exception exception) {
                bl = Boolean.FALSE;
                exception.printStackTrace();
            }
        }
        sGDrawingWindow.setWaitCursor(false);
        return bl;
    }

    boolean mergeSXYData(final SGDrawingWindow sGDrawingWindow) {
        Boolean bl = null;
        sGDrawingWindow.setWaitCursor(true);
        if (!USE_FOXTROT) {
            bl = SGMainFunctionsSplitMerge.mergeSXYDataSub(sGDrawingWindow);
        } else {
            try {
                bl = (Boolean)Worker.post(new Task(){

                    public Object run() throws Exception {
                        return SGMainFunctionsSplitMerge.mergeSXYDataSub(sGDrawingWindow);
                    }
                });
            }
            catch (Exception exception) {
                bl = Boolean.FALSE;
                exception.printStackTrace();
            }
        }
        sGDrawingWindow.setWaitCursor(false);
        return bl;
    }

    public void showMemoryInfo(SGDrawingWindow sGDrawingWindow) {
        DecimalFormat decimalFormat = new DecimalFormat("#,###KB");
        DecimalFormat decimalFormat2 = new DecimalFormat("##.#");
        long l = Runtime.getRuntime().freeMemory() / 1024L;
        long l2 = Runtime.getRuntime().totalMemory() / 1024L;
        long l3 = Runtime.getRuntime().maxMemory() / 1024L;
        long l4 = l2 - l;
        double d = (double)(l4 * 100L) / (double)l2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("total=");
        stringBuffer.append(decimalFormat.format(l2));
        stringBuffer.append(", used=");
        stringBuffer.append(decimalFormat.format(l4));
        stringBuffer.append(" (");
        stringBuffer.append(decimalFormat2.format(d));
        stringBuffer.append("%), max=");
        stringBuffer.append(decimalFormat.format(l3));
        SGUtility.showMessageDialog(sGDrawingWindow, stringBuffer.toString(), "Memory Info", 1);
    }

    boolean transformData(SGDrawingWindow sGDrawingWindow) {
        this.createDataAdditionWizardDialogs(sGDrawingWindow);
        ArrayList<SGFigure> arrayList = sGDrawingWindow.getVisibleFigureList();
        for (SGFigure sGFigure : arrayList) {
            SGIFigureElementGraph sGIFigureElementGraph = sGFigure.getGraphElement();
            List<SGData> list = sGIFigureElementGraph.getFocusedDataList();
            if (list.size() <= 0) continue;
            SGData sGData = list.get(0);
            String string = sGIFigureElementGraph.getDataName(sGData);
            this.mTransformedData = new TransformedData(sGData, string, sGFigure.getID());
            if (SGDataUtility.isArrayData(sGData)) {
                this.mArrayDataTypeSelectionWizardDialog.setCenter(sGDrawingWindow);
                this.mArrayDataTypeSelectionWizardDialog.setVisible(true);
                break;
            }
            if (SGDataUtility.isNetCDFData(sGData)) {
                this.mNetCDFDataTypeSelectionWizardDialog.setCenter(sGDrawingWindow);
                this.mNetCDFDataTypeSelectionWizardDialog.setVisible(true);
                break;
            }
            throw new Error("Unsupported data type: " + sGData.getDataType());
        }
        return true;
    }

    private boolean addDataByDataTransformation(ActionEvent actionEvent) {
        TransformedData transformedData = new TransformedData(this.mTransformedData.data, this.mTransformedData.name, this.mTransformedData.figureId);
        SGMainFunctionsTransform sGMainFunctionsTransform = new SGMainFunctionsTransform(this, this.mArrayDataTypeSelectionWizardDialog, this.mDataColumnSelectionWizardDialog, this.mNetCDFDataTypeSelectionWizardDialog, this.mNetCDFSetupWizardDialog, this.mPlotTypeSelectionWizardDialog, transformedData);
        return sGMainFunctionsTransform.addDataByDataTransformation(actionEvent);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (this.isDataAdditionDialog(object)) {
            this.clearTemporaryData();
        }
    }

    void clearTemporaryData() {
        this.mDroppedFile = null;
        this.mTransformedData = null;
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    SGDataColumnInfoSet createColumnInfoSet(String string, Map<String, Object> map, SGDataColumnInfo[] sGDataColumnInfoArray) {
        int n;
        SGDataColumnInfo[] sGDataColumnInfoArray2 = SGApplicationUtility.getAdditionalInfoArray(string, map, sGDataColumnInfoArray);
        SGDataColumnInfo[] sGDataColumnInfoArray3 = new SGDataColumnInfo[sGDataColumnInfoArray.length + sGDataColumnInfoArray2.length];
        for (n = 0; n < sGDataColumnInfoArray.length; ++n) {
            sGDataColumnInfoArray3[n] = sGDataColumnInfoArray[n];
        }
        for (n = 0; n < sGDataColumnInfoArray2.length; ++n) {
            sGDataColumnInfoArray3[n + sGDataColumnInfoArray.length] = sGDataColumnInfoArray2[n];
        }
        ArrayList<SGDataColumnInfo> arrayList = new ArrayList<SGDataColumnInfo>(Arrays.asList(sGDataColumnInfoArray3));
        SGDefaultColumnTypeUtility.DefaultColumnTypeResult defaultColumnTypeResult = SGDefaultColumnTypeUtility.getDefaultColumnTypes(string, arrayList, map);
        if (!defaultColumnTypeResult.isSucceeded()) {
            return null;
        }
        String[] stringArray = defaultColumnTypeResult.getDefaultColumnTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            sGDataColumnInfoArray3[i].setColumnType(stringArray[i]);
        }
        SGDataColumnInfoSet sGDataColumnInfoSet = new SGDataColumnInfoSet(sGDataColumnInfoArray3);
        return sGDataColumnInfoSet;
    }

    static boolean addDimensionValuesToInfoMap(Map<String, Object> map, SGNetCDFDataSetupWizardDialog sGNetCDFDataSetupWizardDialog) {
        map.put("Graphs for multiple variables", sGNetCDFDataSetupWizardDialog.isVariableDataType());
        map.put("Multiple dimension start", sGNetCDFDataSetupWizardDialog.getMultipleDimensionStart());
        map.put("Multiple dimension end", sGNetCDFDataSetupWizardDialog.getMultipleDimensionEnd());
        map.put("Multiple dimension step", sGNetCDFDataSetupWizardDialog.getMultipleDimensionStep());
        return true;
    }

    static void addPlotTypeSelectionValuesToInfoMap(Map<String, Object> map, SGPlotTypeSelectionWizardDialog sGPlotTypeSelectionWizardDialog) {
        map.put("Plot type is selected", Boolean.TRUE);
        map.put("PlotTypeLine", sGPlotTypeSelectionWizardDialog.isLineSelected());
        map.put("PlotTypeSymbol", sGPlotTypeSelectionWizardDialog.isSymbolSelected());
        map.put("PlotTypeBar", sGPlotTypeSelectionWizardDialog.isBarSelected());
        map.put("ErrorBar position is on line", sGPlotTypeSelectionWizardDialog.isErrorBarPlaceLineSymbolSelected());
    }

    void updatePluginsMessage(SGPluginsQueryMessage sGPluginsQueryMessage) {
        if ("OutputToFileIsEnabled".equals(sGPluginsQueryMessage.getMessage())) {
            sGPluginsQueryMessage.set(this.mPluginManager.hasOutputPlugins());
        } else if ("ExecOutputToFile".equals(sGPluginsQueryMessage.getMessage())) {
            SGDrawingWindow sGDrawingWindow = this.mWindowManager.getCurrentWindow();
            Object object = sGPluginsQueryMessage.get();
            if (object instanceof SGData) {
                try {
                    this.mPluginManager.doOutputToFile(sGDrawingWindow, (SGData)object);
                }
                catch (Exception exception) {
                    SGUtility.showErrorMessageDialog(sGDrawingWindow, "Failed to output data to file", "Error");
                }
            }
        }
    }

    static class TransformedData {
        SGData data = null;
        String name = null;
        int figureId = -1;

        TransformedData(SGData sGData, String string, int n) {
            this.data = sGData;
            this.name = string;
            this.figureId = n;
        }
    }

    class CommandThread
    extends Thread {
        private String mScriptFileName = null;

        CommandThread(String string) {
            this.mScriptFileName = string;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            File file = new File(this.mScriptFileName);
            SGBufferedFileReader sGBufferedFileReader = null;
            try {
                sGBufferedFileReader = new SGBufferedFileReader(this.mScriptFileName);
                BufferedReader bufferedReader = sGBufferedFileReader.getBufferedReader();
                try {
                    SGMainFunctions.this.readRecursively(bufferedReader, SGMainFunctions.this.mStdoutWriter, 0, false, true);
                    SGMainFunctions.this.mStdoutWriter.write(SGMainFunctions.PROMPT);
                    SGMainFunctions.this.mStdoutWriter.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = SGMainFunctions.this.getFileNotFoundString(file);
                try {
                    SGMainFunctions.this.mStdoutWriter.write(string);
                    SGMainFunctions.this.mStdoutWriter.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (sGBufferedFileReader != null) {
                    sGBufferedFileReader.close();
                }
            }
        }
    }

    static class FigureData {
        SGData data;
        int serialFigureNo;

        FigureData(SGData sGData, int n) {
            this.data = sGData;
            this.serialFigureNo = n;
        }

        SGData getData() {
            return this.data;
        }

        int getSerialFigureNo() {
            return this.serialFigureNo;
        }
    }

    static class WrappedData {
        FigureData figureData;
        SGPropertyFileData pfData;

        WrappedData(FigureData figureData) {
            this.figureData = figureData;
            this.pfData = null;
        }

        WrappedData(SGPropertyFileData sGPropertyFileData) {
            this.pfData = sGPropertyFileData;
            this.figureData = null;
        }

        boolean hasFigureData() {
            return this.figureData != null;
        }

        FigureData getFigureData() {
            return this.figureData;
        }

        SGPropertyFileData getPropertyFileData() {
            return this.pfData;
        }
    }

    private static class DroppedData {
        Point pos = null;
        File file = null;

        DroppedData(Point point, File file) {
            this.pos = point;
            this.file = file;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Initializer
    extends Thread {
        private boolean mCommandModeFlag = false;
        private String mStartupFilePath = null;
        private int mStartupFileType = -1;

        private Initializer(Map<String, Object> map) {
            Object object;
            Comparable<Boolean> comparable;
            Set<String> set = map.keySet();
            if (set.contains(SGMainFunctions.KEY_COMMAND_MODE_FLAG)) {
                comparable = (Boolean)map.get(SGMainFunctions.KEY_COMMAND_MODE_FLAG);
                this.mCommandModeFlag = (Boolean)comparable;
            }
            if (set.contains(SGMainFunctions.KEY_FILE_TYPE) && set.contains(SGMainFunctions.KEY_FILE_NAME)) {
                comparable = (Integer)map.get(SGMainFunctions.KEY_FILE_TYPE);
                if ((Integer)comparable != -1) {
                    this.mStartupFilePath = object = (String)map.get(SGMainFunctions.KEY_FILE_NAME);
                }
                this.mStartupFileType = (Integer)comparable;
            }
            boolean bl = false;
            if (set.contains(SGMainFunctions.KEY_DEVELOPER_MODE_FLAG)) {
                object = (Boolean)map.get(SGMainFunctions.KEY_DEVELOPER_MODE_FLAG);
                bl = (Boolean)object;
            }
            object = SGUserProperties.getInstance();
            ((SGUserProperties)object).setProperty("dev", Boolean.toString(bl));
        }

        @Override
        public void run() {
            Object object;
            SGSplashWindow sGSplashWindow = this.createSplashWindow();
            this.removeTemporaryFiles();
            if (sGSplashWindow == null) {
                SGMainFunctions.this.exitApplication(1);
            }
            sGSplashWindow.setCursor(Cursor.getPredefinedCursor(3));
            sGSplashWindow.setProgressValue(0.0f);
            sGSplashWindow.setVisible(true);
            SGMainFunctions.this.mDataCreator = new SGDataCreator();
            sGSplashWindow.setProgressValue(0.15f);
            SGMainFunctions.this.mPropertyFileManager = new SGPropertyFileManager(SGMainFunctions.this);
            SGMainFunctions.this.mDataSetManager = new SGDataSetManager(SGMainFunctions.this, sGSplashWindow, 0.15f, 0.5f);
            sGSplashWindow.setProgressValue(0.5f);
            SGMainFunctions.this.mProxyManager = new SGProxyManager();
            sGSplashWindow.setProgressValue(0.6f);
            SGMainFunctions.this.mUpgradeManager = new SGUpgradeManager(SGMainFunctions.this.mProxyManager, SGMainFunctions.this.mAppProp);
            SGMainFunctions.this.mWindowManager = new SGWindowManager(SGMainFunctions.this, sGSplashWindow, 0.6f, 0.8f);
            sGSplashWindow.setProgressValue(0.8f);
            SGMainFunctions.this.mPropertyManager = new SGCommandManager(SGMainFunctions.this);
            SGMainFunctions.this.mClipBoardManager = new SGClipBoardManager(SGMainFunctions.this);
            SGMainFunctions.this.mFigureCreator = new SGFigureCreator(true);
            if (!SGMainFunctions.this.mFigureCreator.validateClasses()) {
                SGMainFunctions.this.exitApplication(1);
            }
            sGSplashWindow.setProgressValue(0.9f);
            SGMainFunctions.this.mPluginManager = new SGPluginManager(SGMainFunctions.this);
            boolean bl = SGMainFunctions.this.mPluginManager.loadPlugins("plugins");
            if (!bl) {
                object = SGMainFunctions.this.mPluginManager.getFirstExceptionJarFilename();
                SGUtility.showErrorMessageDialog(null, "Plugins load error.\n" + (String)object, "Error");
            }
            sGSplashWindow.setProgressValue(1.0f);
            object = SGMainFunctions.this.mWindowManager.createNewWindow();
            SGMainFunctions.this.mWindowManager.setCurrentWindow((SGDrawingWindow)object);
            ((Window)object).setVisible(true);
            sGSplashWindow.setVisible(false);
            sGSplashWindow.setCursor(Cursor.getDefaultCursor());
            BasicConfigurator.configure();
            Logger logger = Logger.getRootLogger();
            logger.setLevel(Level.OFF);
            if (this.mStartupFileType == 1) {
                final File file = new File(this.mStartupFilePath);
                try {
                    SwingUtilities.invokeAndWait(new Runnable((SGDrawingWindow)object){
                        final /* synthetic */ SGDrawingWindow val$wnd;
                        {
                            this.val$wnd = sGDrawingWindow;
                        }

                        public void run() {
                            SGMainFunctions.this.mPropertyFileManager.showMultiDataFileChooserDialog(file, this.val$wnd);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            } else if (this.mStartupFileType == 2) {
                ((SGDrawingWindow)object).setWaitCursor(true);
                File file = new File(this.mStartupFilePath);
                if (file.exists()) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable((SGDrawingWindow)object, file){
                            final /* synthetic */ SGDrawingWindow val$wnd;
                            final /* synthetic */ File val$f;
                            {
                                this.val$wnd = sGDrawingWindow;
                                this.val$f = file;
                            }

                            public void run() {
                                if (!SGMainFunctions.this.mDataSetManager.loadDataSetFromEventDispatchThread(this.val$wnd, this.val$f)) {
                                    SGUtility.showErrorMessageDialog(this.val$wnd, "Failed to open the selected data set file.", "Error");
                                }
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                } else {
                    SGUtility.showErrorMessageDialog((Component)object, "Cannot open the selected file.", "File open failure");
                }
                ((SGDrawingWindow)object).setWaitCursor(false);
            } else if (this.mStartupFileType == 0) {
                File file = new File(this.mStartupFilePath);
                ArrayList<File> arrayList = new ArrayList<File>();
                arrayList.add(file);
                try {
                    SwingUtilities.invokeAndWait(new Runnable((SGDrawingWindow)object, arrayList){
                        final /* synthetic */ SGDrawingWindow val$wnd;
                        final /* synthetic */ ArrayList val$fList;
                        {
                            this.val$wnd = sGDrawingWindow;
                            this.val$fList = arrayList;
                        }

                        public void run() {
                            if (SGApplicationUtility.isNetCDFFile(Initializer.this.mStartupFilePath)) {
                                SGMainFunctions.this.onNetCDFDataFilesDropped(null, this.val$wnd, this.val$fList);
                            } else {
                                SGMainFunctions.this.onTextDataFilesDropped(null, this.val$wnd, this.val$fList);
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            } else if (this.mStartupFileType == 5) {
                SGMainFunctions.this.mStdoutWriter = new BufferedWriter(new OutputStreamWriter(System.out));
                SGMainFunctions.this.readCommand(this.mStartupFilePath);
                SGMainFunctions.this.mStdinReader = new BufferedReader(new InputStreamReader(System.in));
                try {
                    SGMainFunctions.this.startReadingInput();
                }
                catch (IOException iOException) {
                    return;
                }
            }
            if (this.mCommandModeFlag && this.mStartupFileType != 5) {
                SGMainFunctions.this.mStdoutWriter = new BufferedWriter(new OutputStreamWriter(System.out));
                SGMainFunctions.this.mStdinReader = new BufferedReader(new InputStreamReader(System.in));
                try {
                    SGMainFunctions.this.startReadingInput();
                }
                catch (IOException iOException) {
                    return;
                }
            }
            this.updatePreferences();
            SGMainFunctions.this.mUpgradeManager.upgradeWithCheckDate((Window)object);
        }

        private SGSplashWindow createSplashWindow() {
            Class<?> clazz = this.getClass();
            String string = "/resources/Splash.png";
            URL uRL = clazz.getResource(string);
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            if (image == null) {
                return null;
            }
            SGSplashWindow sGSplashWindow = new SGSplashWindow(image, SGMainFunctions.this.mAppProp.getVersionString());
            return sGSplashWindow;
        }

        private void updatePreferences() {
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            int n = preferences.getInt("Upgrade Cycle", -1);
            if (n == -1) {
                preferences.putInt("Upgrade Cycle", 3);
            }
            preferences.putLong("Date", System.currentTimeMillis());
            preferences.remove("Major Version");
            preferences.remove("Minor Version");
            preferences.remove("Micro Version");
        }

        private void removeTemporaryFiles() {
            String string = SGApplicationUtility.getPathName(SGIConstants.TMP_DIR, "SamuraiGraphTemp");
            File file = new File(string);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                return;
            }
            if (file.exists()) {
                SGApplicationUtility.deleteRecursively(file);
            }
        }
    }
}

