/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.Properties;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JComboBox;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationUtility;
import jp.riken.brain.ni.samuraigraph.application.SGPreviewDialog;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIImageExportManager;
import jp.riken.brain.ni.samuraigraph.base.SGPrintablePanel;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyMap;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyResults;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import org.freehep.graphicsio.FontConstants;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.PageConstants;
import org.freehep.graphicsio.cgm.CGMGraphics2D;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.pdf.PDFExportFileType;
import org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.freehep.graphicsio.ps.EPSExportFileType;
import org.freehep.graphicsio.ps.PSExportFileType;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.freehep.graphicsio.svg.SVGGraphics2D;
import org.freehep.graphicsio.swf.SWFGraphics2D;
import org.freehep.util.UserProperties;
import org.freehep.util.export.ExportDialog;

public class SGImageExportManager
implements SGIImageExportManager,
SGIConstants {
    private static final String DEFAULT_EXPORT_FILE_NAME = "export";
    private static final String DEFAULT_TITLE_NAME = "Export view as ...";
    private static final String PREVIEW_DIALOG_TITLE = "Export as Image";
    private static final String PREFIX = "org.freehep.graphicsio.";
    private static final String BG_SUFFIX = ".Background";
    private static final String BG_COLOR_SUFFIX = ".BackgroundColor";
    private static final String GIF = "gif";
    private static final String JPG = "jpg";
    private static final String PNG = "png";
    private static final String RAW = "raw";
    private static final String PPM = "ppm";
    private static final String[][] BG_KEY_ARRAY = new String[][]{{CGMGraphics2D.BACKGROUND, CGMGraphics2D.BACKGROUND_COLOR}, {PSGraphics2D.BACKGROUND, PSGraphics2D.BACKGROUND_COLOR}, {SWFGraphics2D.BACKGROUND, SWFGraphics2D.BACKGROUND_COLOR}, {PDFGraphics2D.BACKGROUND, PDFGraphics2D.BACKGROUND_COLOR}, {SVGGraphics2D.BACKGROUND, SVGGraphics2D.BACKGROUND_COLOR}, {EMFGraphics2D.BACKGROUND, EMFGraphics2D.BACKGROUND_COLOR}, {"org.freehep.graphicsio.gif.Background", "org.freehep.graphicsio.gif.BackgroundColor"}, {"org.freehep.graphicsio.jpg.Background", "org.freehep.graphicsio.jpg.BackgroundColor"}, {"org.freehep.graphicsio.png.Background", "org.freehep.graphicsio.png.BackgroundColor"}, {"org.freehep.graphicsio.raw.Background", "org.freehep.graphicsio.raw.BackgroundColor"}, {"org.freehep.graphicsio.ppm.Background", "org.freehep.graphicsio.ppm.BackgroundColor"}};
    private static final String TEXT_AS_SHAPES = "TextAsShapes";
    private final ExportDialog mExportDialog = new ExportDialog();
    private String mBaseDirectoryName = null;
    private String mExportFileName = "export";
    private Component mTarget = null;
    public static final int OK = 0;
    public static final int CANCEL = 1;

    public SGImageExportManager() {
        ExportDialogActionListener exportDialogActionListener = new ExportDialogActionListener();
        this.mExportDialog.addActionListener((ActionListener)exportDialogActionListener);
    }

    public boolean export(Component component, Frame frame, int n, int n2, boolean bl) {
        String string;
        Object object;
        String string2;
        Object object2;
        SGDrawingWindow sGDrawingWindow = null;
        if (frame instanceof SGDrawingWindow) {
            sGDrawingWindow = (SGDrawingWindow)frame;
        }
        this.mTarget = component;
        if (!bl && this.preview(component, frame, n, n2, n, n2, (Rectangle)(object2 = new Rectangle(0, 0, n, n2)), PREVIEW_DIALOG_TITLE, "Next>", "Cancel", bl) == 1) {
            return true;
        }
        if (this.mBaseDirectoryName == null) {
            this.mBaseDirectoryName = System.getProperty("user.dir");
        }
        object2 = this.mExportDialog;
        Color color = component.getBackground();
        Properties properties = object2.getUserProperties();
        String string3 = ExportDialog.SAVE_AS_FILE;
        String string4 = this.mBaseDirectoryName;
        String string5 = object2.getUserProperties().getProperty(string3);
        if (string5 != null) {
            string2 = SGApplicationUtility.getPathName(string4, this.mExportFileName);
            object2.setUserProperty(string3, string2);
        }
        string2 = SGApplicationUtility.getPathName(string4, this.mExportFileName);
        String[][] stringArray = BG_KEY_ARRAY;
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            UserProperties.setProperty((Properties)properties, (String)object[0], (boolean)true);
            UserProperties.setProperty((Properties)properties, (String)object[1], (Color)color);
        }
        if (sGDrawingWindow != null) {
            sGDrawingWindow.setModalDialogShown(true);
        }
        object2.showExportDialog((Component)frame, DEFAULT_TITLE_NAME, component, string2);
        if (sGDrawingWindow != null) {
            sGDrawingWindow.setModalDialogShown(false);
        }
        if ((string = properties.getProperty(string3)) != null) {
            object = new File(string).getParent();
            String string6 = string.substring(((String)object).length() + 1);
            this.setBaseDirectory((String)object);
            this.mExportFileName = string6;
        }
        return true;
    }

    private static String[] getSizeList() {
        return (String[])PageConstants.getSizeList().clone();
    }

    private static String[] getMarginList() {
        return new String[]{"No Margin", "Small", "Medium", "Large"};
    }

    private static String[] getOrientationList() {
        return (String[])PageConstants.getOrientationList().clone();
    }

    private static String[] getEmbedFontsAsList() {
        return (String[])FontConstants.getEmbedFontsAsList().clone();
    }

    public SGPropertyResults export(Component component, String string, String string2, SGPropertyMap sGPropertyMap) {
        Object object;
        if (component == null || string == null || string2 == null || sGPropertyMap == null) {
            throw new IllegalArgumentException("Null input value.");
        }
        SGPropertyResults sGPropertyResults = new SGPropertyResults();
        File file = new File(string2);
        EMFGraphics2D eMFGraphics2D = null;
        boolean bl = true;
        try {
            object = new UserProperties();
            if ("EMF".equalsIgnoreCase(string)) {
                eMFGraphics2D = new EMFGraphics2D(file, component);
                this.setBoolean(sGPropertyMap, "Transparent", (UserProperties)object, EMFGraphics2D.TRANSPARENT, sGPropertyResults);
                this.setBoolean(sGPropertyMap, "Background", (UserProperties)object, EMFGraphics2D.BACKGROUND, sGPropertyResults);
                this.setColor(sGPropertyMap, "BackgroundColor", (UserProperties)object, EMFGraphics2D.BACKGROUND_COLOR, sGPropertyResults);
                this.setBoolean(sGPropertyMap, TEXT_AS_SHAPES, (UserProperties)object, EMFGraphics2D.TEXT_AS_SHAPES, sGPropertyResults);
            } else if ("EPS".equalsIgnoreCase(string) || "PS".equalsIgnoreCase(string)) {
                eMFGraphics2D = new PSGraphics2D(file, component);
                bl = false;
                this.setBoolean(sGPropertyMap, "Background", (UserProperties)object, PSGraphics2D.BACKGROUND, sGPropertyResults);
                this.setColor(sGPropertyMap, "BackgroundColor", (UserProperties)object, PSGraphics2D.BACKGROUND_COLOR, sGPropertyResults);
                this.setString(sGPropertyMap, "PageSize", (UserProperties)object, PSGraphics2D.PAGE_SIZE, SGImageExportManager.getSizeList(), sGPropertyResults);
                this.setMargin(sGPropertyMap, "PageMargins", (UserProperties)object, PSGraphics2D.PAGE_MARGINS, sGPropertyResults);
                this.setString(sGPropertyMap, "Orientation", (UserProperties)object, PSGraphics2D.ORIENTATION, SGImageExportManager.getOrientationList(), sGPropertyResults);
                this.setBoolean(sGPropertyMap, "FitToPage", (UserProperties)object, PSGraphics2D.FIT_TO_PAGE, sGPropertyResults);
                this.setBoolean(sGPropertyMap, "EmbedFonts", (UserProperties)object, PSGraphics2D.EMBED_FONTS, sGPropertyResults);
                this.setString(sGPropertyMap, "EmbedFontsAs", (UserProperties)object, PSGraphics2D.EMBED_FONTS_AS, SGImageExportManager.getEmbedFontsAsList(), sGPropertyResults);
                this.setBoolean(sGPropertyMap, TEXT_AS_SHAPES, (UserProperties)object, PSGraphics2D.TEXT_AS_SHAPES, sGPropertyResults);
                this.setText(sGPropertyMap, "For", (UserProperties)object, PSGraphics2D.FOR, sGPropertyResults);
                this.setText(sGPropertyMap, "Title", (UserProperties)object, PSGraphics2D.TITLE, sGPropertyResults);
                this.setString(sGPropertyMap, "WriteImagesAs", (UserProperties)object, PSGraphics2D.WRITE_IMAGES_AS, new String[]{"Smallest Size", "ZLIB", "JPG"}, sGPropertyResults);
                if ("EPS".equalsIgnoreCase(string)) {
                    this.setBoolean(sGPropertyMap, "Preview", (UserProperties)object, PSGraphics2D.PREVIEW, sGPropertyResults);
                    this.setInteger(sGPropertyMap, "PreviewBits", (UserProperties)object, PSGraphics2D.PREVIEW_BITS, new int[]{1, 2, 4, 8}, sGPropertyResults);
                }
            } else if ("PDF".equalsIgnoreCase(string)) {
                eMFGraphics2D = new PDFGraphics2D(file, component);
                bl = false;
                this.setBoolean(sGPropertyMap, "Transparent", (UserProperties)object, PDFGraphics2D.TRANSPARENT, sGPropertyResults);
                this.setBoolean(sGPropertyMap, "Background", (UserProperties)object, PDFGraphics2D.BACKGROUND, sGPropertyResults);
                this.setColor(sGPropertyMap, "BackgroundColor", (UserProperties)object, PDFGraphics2D.BACKGROUND_COLOR, sGPropertyResults);
                this.setString(sGPropertyMap, "Version", (UserProperties)object, PDFGraphics2D.VERSION, new String[]{"Acrobat Reader 4.x", "Acrobat Reader 5.x"}, sGPropertyResults);
                this.setBoolean(sGPropertyMap, "Thumbnails", (UserProperties)object, PDFGraphics2D.THUMBNAILS, sGPropertyResults);
                this.setBoolean(sGPropertyMap, "Compress", (UserProperties)object, PDFGraphics2D.COMPRESS, sGPropertyResults);
                this.setString(sGPropertyMap, "PageSize", (UserProperties)object, PDFGraphics2D.PAGE_SIZE, SGImageExportManager.getSizeList(), sGPropertyResults);
                this.setMargin(sGPropertyMap, "PageMargins", (UserProperties)object, PDFGraphics2D.PAGE_MARGINS, sGPropertyResults);
                this.setString(sGPropertyMap, "Orientation", (UserProperties)object, PDFGraphics2D.ORIENTATION, SGImageExportManager.getOrientationList(), sGPropertyResults);
                this.setBoolean(sGPropertyMap, "FitToPage", (UserProperties)object, PDFGraphics2D.FIT_TO_PAGE, sGPropertyResults);
                this.setBoolean(sGPropertyMap, "EmbedFonts", (UserProperties)object, PDFGraphics2D.EMBED_FONTS, sGPropertyResults);
                this.setString(sGPropertyMap, "EmbedFontsAs", (UserProperties)object, PDFGraphics2D.EMBED_FONTS_AS, SGImageExportManager.getEmbedFontsAsList(), sGPropertyResults);
                this.setBoolean(sGPropertyMap, TEXT_AS_SHAPES, (UserProperties)object, PDFGraphics2D.TEXT_AS_SHAPES, sGPropertyResults);
                this.setString(sGPropertyMap, "WriteImagesAs", (UserProperties)object, PDFGraphics2D.WRITE_IMAGES_AS, new String[]{"Smallest Size", "ZLIB", "JPG"}, sGPropertyResults);
                this.setText(sGPropertyMap, "Author", (UserProperties)object, PDFGraphics2D.AUTHOR, sGPropertyResults);
                this.setText(sGPropertyMap, "Title", (UserProperties)object, PDFGraphics2D.TITLE, sGPropertyResults);
                this.setText(sGPropertyMap, "Subject", (UserProperties)object, PDFGraphics2D.SUBJECT, sGPropertyResults);
                this.setText(sGPropertyMap, "Keywords", (UserProperties)object, PDFGraphics2D.KEYWORDS, sGPropertyResults);
            } else if ("SVG".equalsIgnoreCase(string)) {
                eMFGraphics2D = new SVGGraphics2D(file, component);
                bl = true;
                this.setBoolean(sGPropertyMap, "Transparent", (UserProperties)object, SVGGraphics2D.TRANSPARENT, sGPropertyResults);
                this.setBoolean(sGPropertyMap, "Background", (UserProperties)object, SVGGraphics2D.BACKGROUND, sGPropertyResults);
                this.setColor(sGPropertyMap, "BackgroundColor", (UserProperties)object, SVGGraphics2D.BACKGROUND_COLOR, sGPropertyResults);
                this.setBoolean(sGPropertyMap, "Compress", (UserProperties)object, SVGGraphics2D.COMPRESS, sGPropertyResults);
                this.setBoolean(sGPropertyMap, "Stylable", (UserProperties)object, SVGGraphics2D.STYLABLE, sGPropertyResults);
                this.setDimension(sGPropertyMap, "ImageSize", (UserProperties)object, SVGGraphics2D.IMAGE_SIZE, sGPropertyResults);
                this.setBoolean(sGPropertyMap, "ExportImages", (UserProperties)object, SVGGraphics2D.EXPORT_IMAGES, sGPropertyResults);
                this.setText(sGPropertyMap, "ExportSuffix", (UserProperties)object, SVGGraphics2D.EXPORT_SUFFIX, sGPropertyResults);
                this.setString(sGPropertyMap, "WriteImagesAs", (UserProperties)object, SVGGraphics2D.WRITE_IMAGES_AS, new String[]{"Smallest Size", "PNG", "JPG"}, sGPropertyResults);
                this.setBoolean(sGPropertyMap, TEXT_AS_SHAPES, (UserProperties)object, SVGGraphics2D.TEXT_AS_SHAPES, sGPropertyResults);
                this.setText(sGPropertyMap, "Creator", (UserProperties)object, SVGGraphics2D.FOR, sGPropertyResults);
                this.setText(sGPropertyMap, "Title", (UserProperties)object, SVGGraphics2D.TITLE, sGPropertyResults);
            } else if ("CGM".equalsIgnoreCase(string)) {
                eMFGraphics2D = new CGMGraphics2D(file, component);
                bl = true;
                this.setBoolean(sGPropertyMap, "Background", (UserProperties)object, CGMGraphics2D.BACKGROUND, sGPropertyResults);
                this.setColor(sGPropertyMap, "BackgroundColor", (UserProperties)object, CGMGraphics2D.BACKGROUND_COLOR, sGPropertyResults);
                this.setBoolean(sGPropertyMap, "Binary", (UserProperties)object, CGMGraphics2D.BINARY, sGPropertyResults);
                this.setText(sGPropertyMap, "Author", (UserProperties)object, CGMGraphics2D.AUTHOR, sGPropertyResults);
                this.setText(sGPropertyMap, "Title", (UserProperties)object, CGMGraphics2D.TITLE, sGPropertyResults);
                this.setText(sGPropertyMap, "Subject", (UserProperties)object, CGMGraphics2D.SUBJECT, sGPropertyResults);
                this.setText(sGPropertyMap, "Keywords", (UserProperties)object, CGMGraphics2D.KEYWORDS, sGPropertyResults);
            } else if ("SWF".equalsIgnoreCase(string)) {
                eMFGraphics2D = new SWFGraphics2D(file, component);
                bl = true;
                this.setBoolean(sGPropertyMap, "Transparent", (UserProperties)object, SWFGraphics2D.TRANSPARENT, sGPropertyResults);
                this.setBoolean(sGPropertyMap, "Background", (UserProperties)object, SWFGraphics2D.BACKGROUND, sGPropertyResults);
                this.setColor(sGPropertyMap, "BackgroundColor", (UserProperties)object, SWFGraphics2D.BACKGROUND_COLOR, sGPropertyResults);
                this.setString(sGPropertyMap, "WriteImagesAs", (UserProperties)object, SWFGraphics2D.WRITE_IMAGES_AS, new String[]{"Smallest Size", "ZLIB", "JPG"}, sGPropertyResults);
            } else if ("JPG".equalsIgnoreCase(string) || "JPEG".equalsIgnoreCase(string) || "GIF".equalsIgnoreCase(string) || "PNG".equalsIgnoreCase(string) || "RAW".equalsIgnoreCase(string) || "PPM".equalsIgnoreCase(string)) {
                String string3 = string.toUpperCase();
                eMFGraphics2D = new ImageGraphics2D(file, component, string3);
                bl = true;
                String string4 = PREFIX + string3;
                if (ImageGraphics2D.canWriteTransparent((String)string3)) {
                    this.setBoolean(sGPropertyMap, "Transparent", (UserProperties)object, ".Transparent", sGPropertyResults);
                }
                this.setBoolean(sGPropertyMap, "Background", (UserProperties)object, string4 + BG_SUFFIX, sGPropertyResults);
                this.setColor(sGPropertyMap, "BackgroundColor", (UserProperties)object, string4 + BG_COLOR_SUFFIX, sGPropertyResults);
                this.setBoolean(sGPropertyMap, "Antialias", (UserProperties)object, string4 + ".Antialias", sGPropertyResults);
                this.setBoolean(sGPropertyMap, "AntialiasText", (UserProperties)object, string4 + ".AntialiasText", sGPropertyResults);
                this.setBoolean(sGPropertyMap, "Progressive", (UserProperties)object, ".Progressive", sGPropertyResults);
                this.setFloat(sGPropertyMap, "QualityValue", (UserProperties)object, ".CompressQuality", new SGTuple2f(0.0f, 1.0f), sGPropertyResults);
            } else {
                return null;
            }
            eMFGraphics2D.setProperties((Properties)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        if (component instanceof SGDrawingWindow.ExportPanel) {
            object = (SGDrawingWindow.ExportPanel)component;
            ((SGDrawingWindow.ExportPanel)object).setClipFlag(bl);
        }
        eMFGraphics2D.startExport();
        component.print((Graphics)eMFGraphics2D);
        eMFGraphics2D.endExport();
        return sGPropertyResults;
    }

    private boolean setString(SGPropertyMap sGPropertyMap, String string, UserProperties userProperties, String string2, SGPropertyResults sGPropertyResults) {
        String string3 = sGPropertyMap.getValue(string);
        if (string3 != null) {
            String string4 = sGPropertyMap.getValueString(string);
            userProperties.setProperty(string2, string4);
            sGPropertyResults.putResult(string, 0);
            return true;
        }
        return false;
    }

    private boolean setString(SGPropertyMap sGPropertyMap, String string, UserProperties userProperties, String string2, String[] stringArray, SGPropertyResults sGPropertyResults) {
        String string3 = sGPropertyMap.getValue(string);
        if (string3 != null) {
            String string4 = sGPropertyMap.getValueString(string);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!SGUtilityText.isEqualString(stringArray[i], string4)) continue;
                userProperties.setProperty(string2, stringArray[i]);
                sGPropertyResults.putResult(string, 0);
                return true;
            }
            sGPropertyResults.putResult(string, 1);
            return false;
        }
        return false;
    }

    private boolean setText(SGPropertyMap sGPropertyMap, String string, UserProperties userProperties, String string2, SGPropertyResults sGPropertyResults) {
        String string3 = sGPropertyMap.getValue(string);
        if (string3 != null) {
            if (!sGPropertyMap.isDoubleQuoted(string)) {
                sGPropertyResults.putResult(string, 1);
                return false;
            }
            String string4 = sGPropertyMap.getValueString(string);
            userProperties.setProperty(string2, string4);
            sGPropertyResults.putResult(string, 0);
            return true;
        }
        return false;
    }

    private boolean setBoolean(SGPropertyMap sGPropertyMap, String string, UserProperties userProperties, String string2, SGPropertyResults sGPropertyResults) {
        String string3 = sGPropertyMap.getValue(string);
        if (string3 != null) {
            Boolean bl = SGUtilityText.getBoolean(string3);
            if (bl == null) {
                sGPropertyResults.putResult(string, 1);
                return false;
            }
            userProperties.setProperty(string2, bl.booleanValue());
            sGPropertyResults.putResult(string, 0);
            return true;
        }
        return false;
    }

    private boolean setInteger(SGPropertyMap sGPropertyMap, String string, UserProperties userProperties, String string2, SGPropertyResults sGPropertyResults) {
        String string3 = sGPropertyMap.getValue(string);
        if (string3 != null) {
            Integer n = SGUtilityText.getInteger(string3);
            if (n == null) {
                sGPropertyResults.putResult(string, 1);
                return false;
            }
            userProperties.setProperty(string2, n.intValue());
            sGPropertyResults.putResult(string, 0);
            return true;
        }
        return false;
    }

    private boolean setInteger(SGPropertyMap sGPropertyMap, String string, UserProperties userProperties, String string2, int[] nArray, SGPropertyResults sGPropertyResults) {
        String string3 = sGPropertyMap.getValue(string);
        if (string3 != null) {
            Integer n = SGUtilityText.getInteger(string3);
            if (n == null) {
                sGPropertyResults.putResult(string, 1);
                return false;
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != n) continue;
                userProperties.setProperty(string2, n.intValue());
                sGPropertyResults.putResult(string, 0);
                return true;
            }
        }
        return false;
    }

    private boolean setFloat(SGPropertyMap sGPropertyMap, String string, UserProperties userProperties, String string2, SGPropertyResults sGPropertyResults) {
        String string3 = sGPropertyMap.getValue(string);
        if (string3 != null) {
            Float f = SGUtilityText.getFloat(string3);
            if (f == null) {
                sGPropertyResults.putResult(string, 1);
                return false;
            }
            userProperties.setProperty(string2, f.floatValue());
            sGPropertyResults.putResult(string, 0);
            return true;
        }
        return false;
    }

    private boolean setFloat(SGPropertyMap sGPropertyMap, String string, UserProperties userProperties, String string2, SGTuple2f sGTuple2f, SGPropertyResults sGPropertyResults) {
        String string3 = sGPropertyMap.getValue(string);
        if (string3 != null) {
            Float f = SGUtilityText.getFloat(string3);
            if (f == null) {
                sGPropertyResults.putResult(string, 1);
                return false;
            }
            if (f.floatValue() < sGTuple2f.x || sGTuple2f.y < f.floatValue()) {
                sGPropertyResults.putResult(string, 1);
                return false;
            }
            userProperties.setProperty(string2, f.floatValue());
            sGPropertyResults.putResult(string, 0);
            return true;
        }
        return false;
    }

    private boolean setColor(SGPropertyMap sGPropertyMap, String string, UserProperties userProperties, String string2, SGPropertyResults sGPropertyResults) {
        String string3 = sGPropertyMap.getValue(string);
        if (string3 != null) {
            Color color = SGUtilityText.getColor(string3);
            if (color == null && (color = SGUtilityText.parseColor(string3)) == null) {
                sGPropertyResults.putResult(string, 1);
                return false;
            }
            userProperties.setProperty(string2, color);
            sGPropertyResults.putResult(string, 0);
            return true;
        }
        return false;
    }

    private boolean setDimension(SGPropertyMap sGPropertyMap, String string, UserProperties userProperties, String string2, SGPropertyResults sGPropertyResults) {
        String string3 = sGPropertyMap.getValue(string);
        if (string3 != null) {
            Dimension dimension = SGUtilityText.getDimension(string3);
            if (dimension == null) {
                sGPropertyResults.putResult(string, 1);
                return false;
            }
            userProperties.setProperty(string2, dimension);
            sGPropertyResults.putResult(string, 0);
            return true;
        }
        return false;
    }

    private boolean setMargin(SGPropertyMap sGPropertyMap, String string, UserProperties userProperties, String string2, SGPropertyResults sGPropertyResults) {
        String string3 = sGPropertyMap.getValue(string);
        if (string3 != null) {
            String[] stringArray = SGUtilityText.getStringsInBracket(string3);
            if (stringArray != null) {
                int n;
                if (stringArray.length != 4) {
                    sGPropertyResults.putResult(string, 1);
                    return false;
                }
                int[] nArray = new int[stringArray.length];
                for (n = 0; n < nArray.length; ++n) {
                    Integer n2 = SGUtilityText.getInteger(stringArray[n]);
                    if (n2 == null) {
                        sGPropertyResults.putResult(string, 1);
                        return false;
                    }
                    nArray[n] = n2;
                }
                n = nArray[0];
                int n3 = nArray[1];
                int n4 = nArray[2];
                int n5 = nArray[3];
                Insets insets = new Insets(n, n4, n3, n5);
                userProperties.setProperty(string2, insets);
                sGPropertyResults.putResult(string, 0);
                return true;
            }
            String[] stringArray2 = SGImageExportManager.getMarginList();
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!SGUtilityText.isEqualString(stringArray2[i], string3)) continue;
                Insets insets = PageConstants.getMargins((String)stringArray2[i]);
                userProperties.setProperty(string2, insets);
                sGPropertyResults.putResult(string, 0);
                return true;
            }
            sGPropertyResults.putResult(string, 1);
            return false;
        }
        return false;
    }

    public void setBaseDirectory(String string) {
        this.mBaseDirectoryName = string;
    }

    public String getBaseDirectory() {
        return this.mBaseDirectoryName;
    }

    private int preview(Component component, Frame frame, int n, int n2, int n3, int n4, Rectangle rectangle, String string, String string2, String string3, boolean bl) {
        SGPreviewDialog sGPreviewDialog = this.createPreviewDialog(component, frame, n, n2, n3, n4, rectangle, string, !bl);
        sGPreviewDialog.setOKButtonText(string2);
        sGPreviewDialog.setCancelButtonText(string3);
        if (!bl) {
            sGPreviewDialog.setVisible(true);
        }
        int n5 = sGPreviewDialog.getCloseOption();
        sGPreviewDialog.dispose();
        if (n5 == 1) {
            return 1;
        }
        return 0;
    }

    public boolean print(Component component, Frame frame, int n, int n2, boolean bl) {
        SGPrintablePanel sGPrintablePanel = new SGPrintablePanel(component, n, n2);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        hashPrintRequestAttributeSet.add(OrientationRequested.PORTRAIT);
        hashPrintRequestAttributeSet.add(new Copies(1));
        hashPrintRequestAttributeSet.add(new JobName("Samurai Graph Printning", null));
        printerJob.setPrintable(sGPrintablePanel);
        PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
        if (printServiceArray.length <= 0) {
            if (!bl) {
                SGUtility.showMessageDialog(frame, "No printer is available.", "Error", 0);
            }
            return false;
        }
        PageFormat pageFormat = new PageFormat();
        pageFormat = printerJob.defaultPage(pageFormat);
        Rectangle rectangle = new Rectangle((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        Dimension dimension = new Dimension((int)pageFormat.getWidth(), (int)pageFormat.getHeight());
        String string = "Print as Image";
        int n3 = this.preview(sGPrintablePanel, frame, n, n2, dimension.width, dimension.height, rectangle, string, "Print", "Cancel", bl);
        if (n3 == 1) {
            return true;
        }
        if (printerJob.printDialog(hashPrintRequestAttributeSet)) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                printerException.printStackTrace();
            }
        }
        return true;
    }

    private SGPreviewDialog createPreviewDialog(Component component, Frame frame, int n, int n2, int n3, int n4, Rectangle rectangle, String string, boolean bl) {
        SGPreviewDialog sGPreviewDialog = new SGPreviewDialog(frame, string, bl);
        sGPreviewDialog.pack();
        sGPreviewDialog.setLocation(frame.getLocation());
        sGPreviewDialog.setTargetObject(component, n, n2, n3, n4, rectangle, component.getBackground());
        return sGPreviewDialog;
    }

    private class ExportDialogActionListener
    implements ActionListener {
        private ExportDialogActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)object;
                Object object2 = jComboBox.getSelectedItem();
                Component component = SGImageExportManager.this.mTarget;
                if (component instanceof SGDrawingWindow.ExportPanel) {
                    SGDrawingWindow.ExportPanel exportPanel = (SGDrawingWindow.ExportPanel)component;
                    boolean bl = object2 instanceof EPSExportFileType || object2 instanceof PSExportFileType || object2 instanceof PDFExportFileType;
                    exportPanel.setClipFlag(!bl);
                }
            }
        }
    }
}

