/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Frame;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxisBreak;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGrid;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementLegend;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementShape;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementSignificantDifference;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementString;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementTimingLine;
import jp.riken.brain.ni.samuraigraph.base.SGIProgressControl;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYZTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGIVXYTypeData;
import jp.riken.brain.ni.samuraigraph.figure.SGXYFigure;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGFigureCreator
implements SGIFigureConstants {
    private static final String CLASS_NAME_OF_AXIS_ELEMENT_2D = "jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElementAxis";
    private static final String CLASS_NAME_OF_GRAPH_ELEMENT_2D = "jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElementGraph";
    private static final String CLASS_NAME_OF_GRID_ELEMENT_2D = "jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElementGrid";
    private static final String CLASS_NAME_OF_STRING_ELEMENT_2D = "jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElementString";
    private static final String CLASS_NAME_OF_LEGEND_ELEMENT_2D = "jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElementLegend";
    private static final String CLASS_NAME_OF_AXIS_BREAK_ELEMENT_2D = "jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElementAxisBreak";
    private static final String CLASS_NAME_OF_SIGNIFICANT_DIFFERENCE_ELEMENT_2D = "jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElementSignificantDifference";
    private static final String CLASS_NAME_OF_TIMING_LINE_ELEMENT_2D = "jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElementTimingLine";
    private static final String CLASS_NAME_OF_SHAPE_ELEMENT_2D = "jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElementShape";
    private static final String CLASS_NAME_OF_AXIS_ELEMENT_3D = "jp.riken.brain.ni.samuraigraph.figure.java3d.SGFigureElementAxis";
    private static final String CLASS_NAME_OF_GRAPH_ELEMENT_3D = "jp.riken.brain.ni.samuraigraph.figure.java3d.SGFigureElementGraph";
    private static final String CLASS_NAME_OF_GRID_ELEMENT_3D = "jp.riken.brain.ni.samuraigraph.figure.java3d.SGFigureElementGrid";
    private static final String CLASS_NAME_OF_STRING_ELEMENT_3D = "jp.riken.brain.ni.samuraigraph.figure.java3d.SGFigureElementString";
    private static final String CLASS_NAME_OF_LEGEND_ELEMENT_3D = "jp.riken.brain.ni.samuraigraph.figure.java3d.SGFigureElementLegend";
    private static final String CLASS_NAME_OF_AXIS_BREAK_ELEMENT_3D = "jp.riken.brain.ni.samuraigraph.figure.java3d.SGFigureElementAxisBreak";
    private static final String CLASS_NAME_OF_SIGNIFICANT_DIFFERENCE_ELEMENT_3D = "jp.riken.brain.ni.samuraigraph.figure.java3d.SGFigureElementSignificantDifference";
    private static final String CLASS_NAME_OF_TIMING_LINE_ELEMENT_3D = "jp.riken.brain.ni.samuraigraph.figure.java3d.SGFigureElementTimingLinet";
    private static final String CLASS_NAME_OF_SHAPE_ELEMENT_3D = "jp.riken.brain.ni.samuraigraph.figure.java3d.SGFigureElementShape";
    private static final String PROPERTY_NAME_OF_AXIS_ELEMENT = "SGFigureElementAxis";
    private static final String PROPERTY_NAME_OF_GRAPH_ELEMENT = "SGFigureElementGraph";
    private static final String PROPERTY_NAME_OF_GRID_ELEMENT = "SGFigureElementGrid";
    private static final String PROPERTY_NAME_OF_STRING_ELEMENT = "SGFigureElementString";
    private static final String PROPERTY_NAME_OF_LEGEND_ELEMENT = "SGFigureElementLegend";
    private static final String PROPERTY_NAME_OF_AXIS_BREAK_ELEMENT = "SGFigureElementAxisBreak";
    private static final String PROPERTY_NAME_OF_SIGNIFICANT_DIFFERENCE_ELEMENT = "SGSignificantDifferenceElement";
    private static final String PROPERTY_NAME_OF_TIMING_LINE_ELEMENT = "SGFigureElementTimingLinet";
    private static final String PROPERTY_NAME_OF_SHAPE_ELEMENT = "SGFigureElementShape";
    private boolean mSuccess = false;
    private Class mClassOfAxisElement = null;
    private Class mClassOfGraphElement = null;
    private Class mClassOfGridElement = null;
    private Class mClassOfStringElement = null;
    private Class mClassOfLegendElement = null;
    private Class mClassOfAxisBreakElement = null;
    private Class mClassOfSignificantDifferenceElement = null;
    private Class mClassOfTimingLineElement = null;
    private Class mClassOfShapeElement = null;
    private static final int LAYER_GRID = 10;
    private static final int LAYER_GRAPH = 20;
    private static final int LAYER_AXIS = 30;
    private static final int LAYER_TIMING_LINE = 40;
    private static final int LAYER_SIGNIFICANT_DIFFERENCE = 50;
    private static final int LAYER_SHAPE = 60;
    private static final int LAYER_AXIS_BREAK = 70;
    private static final int LAYER_LEGEND = 80;
    private static final int LAYER_STRING = 90;
    public static final float FIGURE_DEFAULT_WIDTH = 10.0f;
    public static final float FIGURE_DEFAULT_HEIGHT = 10.0f;
    public static final float FIGURE_SXY_DEFAULT_WIDTH = 15.0f;
    public static final float FIGURE_SXY_DEFAULT_HEIGHT = 9.0f;
    public static final float FIGURE_VXY_DEFAULT_WIDTH = 9.0f;
    public static final float FIGURE_VXY_DEFAULT_HEIGHT = 9.0f;
    public static final float FIGURE_SXYZ_DEFAULT_WIDTH = 10.0f;
    public static final float FIGURE_SXYZ_DEFAULT_HEIGHT = 10.0f;

    public SGFigureCreator(boolean bl) {
        this.mSuccess = bl ? this.load2DClasses() : this.load3DClasses();
        if (this.mSuccess) {
            this.mSuccess = this.healthCheck();
        }
    }

    public SGFigureCreator(String string) {
        this.mSuccess = this.loadClassesFromFile(string);
        if (this.mSuccess) {
            this.mSuccess = this.healthCheck();
        }
    }

    private boolean load2DClasses() {
        try {
            this.mClassOfAxisElement = Class.forName(CLASS_NAME_OF_AXIS_ELEMENT_2D);
            this.mClassOfGraphElement = Class.forName(CLASS_NAME_OF_GRAPH_ELEMENT_2D);
            this.mClassOfGridElement = Class.forName(CLASS_NAME_OF_GRID_ELEMENT_2D);
            this.mClassOfStringElement = Class.forName(CLASS_NAME_OF_STRING_ELEMENT_2D);
            this.mClassOfLegendElement = Class.forName(CLASS_NAME_OF_LEGEND_ELEMENT_2D);
            this.mClassOfAxisBreakElement = Class.forName(CLASS_NAME_OF_AXIS_BREAK_ELEMENT_2D);
            this.mClassOfSignificantDifferenceElement = Class.forName(CLASS_NAME_OF_SIGNIFICANT_DIFFERENCE_ELEMENT_2D);
            this.mClassOfTimingLineElement = Class.forName(CLASS_NAME_OF_TIMING_LINE_ELEMENT_2D);
            this.mClassOfShapeElement = Class.forName(CLASS_NAME_OF_SHAPE_ELEMENT_2D);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    private boolean load3DClasses() {
        try {
            this.mClassOfAxisElement = Class.forName(CLASS_NAME_OF_AXIS_ELEMENT_3D);
            this.mClassOfGraphElement = Class.forName(CLASS_NAME_OF_GRAPH_ELEMENT_3D);
            this.mClassOfGridElement = Class.forName(CLASS_NAME_OF_GRID_ELEMENT_3D);
            this.mClassOfStringElement = Class.forName(CLASS_NAME_OF_STRING_ELEMENT_3D);
            this.mClassOfLegendElement = Class.forName(CLASS_NAME_OF_LEGEND_ELEMENT_3D);
            this.mClassOfAxisBreakElement = Class.forName(CLASS_NAME_OF_AXIS_BREAK_ELEMENT_3D);
            this.mClassOfSignificantDifferenceElement = Class.forName(CLASS_NAME_OF_SIGNIFICANT_DIFFERENCE_ELEMENT_3D);
            this.mClassOfTimingLineElement = Class.forName(CLASS_NAME_OF_TIMING_LINE_ELEMENT_3D);
            this.mClassOfShapeElement = Class.forName(CLASS_NAME_OF_SHAPE_ELEMENT_3D);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadClassesFromFile(String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        try {
            Properties properties = new Properties();
            properties.load(fileInputStream);
            String string2 = properties.getProperty(PROPERTY_NAME_OF_AXIS_ELEMENT);
            this.mClassOfAxisElement = string2 != null && !string2.equals("") ? Class.forName(string2) : null;
            string2 = properties.getProperty(PROPERTY_NAME_OF_GRAPH_ELEMENT);
            this.mClassOfGraphElement = string2 != null && !string2.equals("") ? Class.forName(string2) : null;
            string2 = properties.getProperty(PROPERTY_NAME_OF_GRID_ELEMENT);
            this.mClassOfGridElement = string2 != null && !string2.equals("") ? Class.forName(string2) : null;
            string2 = properties.getProperty(PROPERTY_NAME_OF_STRING_ELEMENT);
            this.mClassOfStringElement = string2 != null && !string2.equals("") ? Class.forName(string2) : null;
            string2 = properties.getProperty(PROPERTY_NAME_OF_LEGEND_ELEMENT);
            this.mClassOfLegendElement = string2 != null && !string2.equals("") ? Class.forName(string2) : null;
            string2 = properties.getProperty(PROPERTY_NAME_OF_AXIS_BREAK_ELEMENT);
            this.mClassOfAxisBreakElement = string2 != null && !string2.equals("") ? Class.forName(string2) : null;
            string2 = properties.getProperty(PROPERTY_NAME_OF_SIGNIFICANT_DIFFERENCE_ELEMENT);
            this.mClassOfSignificantDifferenceElement = string2 != null && !string2.equals("") ? Class.forName(string2) : null;
            string2 = properties.getProperty(PROPERTY_NAME_OF_TIMING_LINE_ELEMENT);
            this.mClassOfTimingLineElement = string2 != null && !string2.equals("") ? Class.forName(string2) : null;
            string2 = properties.getProperty(PROPERTY_NAME_OF_SHAPE_ELEMENT);
            this.mClassOfShapeElement = string2 != null && !string2.equals("") ? Class.forName(string2) : null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    private boolean healthCheck() {
        if (!SGIFigureElementAxis.class.isAssignableFrom(this.mClassOfAxisElement)) {
            return false;
        }
        if (!SGIFigureElementGraph.class.isAssignableFrom(this.mClassOfGraphElement)) {
            return false;
        }
        if (!SGIFigureElementGrid.class.isAssignableFrom(this.mClassOfGridElement)) {
            return false;
        }
        if (!SGIFigureElementString.class.isAssignableFrom(this.mClassOfStringElement)) {
            return false;
        }
        if (!SGIFigureElementLegend.class.isAssignableFrom(this.mClassOfLegendElement)) {
            return false;
        }
        if (!SGIFigureElementAxisBreak.class.isAssignableFrom(this.mClassOfAxisBreakElement)) {
            return false;
        }
        if (!SGIFigureElementSignificantDifference.class.isAssignableFrom(this.mClassOfSignificantDifferenceElement)) {
            return false;
        }
        if (!SGIFigureElementTimingLine.class.isAssignableFrom(this.mClassOfTimingLineElement)) {
            return false;
        }
        return SGIFigureElementShape.class.isAssignableFrom(this.mClassOfShapeElement);
    }

    public boolean validateClasses() {
        return this.mSuccess;
    }

    private void setRelationOfFigureElements(SGFigure sGFigure) {
        SGIFigureElementAxis sGIFigureElementAxis = sGFigure.getAxisElement();
        SGIFigureElementGraph sGIFigureElementGraph = sGFigure.getGraphElement();
        SGIFigureElementLegend sGIFigureElementLegend = sGFigure.getLegendElement();
        sGIFigureElementGraph.setAxisElement(sGIFigureElementAxis);
        sGIFigureElementLegend.setAxisElement(sGIFigureElementAxis);
        sGIFigureElementLegend.setGraphElement(sGIFigureElementGraph);
        if (sGFigure instanceof SGXYFigure) {
            SGXYFigure sGXYFigure = (SGXYFigure)sGFigure;
            SGIFigureElementGrid sGIFigureElementGrid = sGXYFigure.getGridElement();
            SGIFigureElementString sGIFigureElementString = (SGIFigureElementString)sGXYFigure.getSymbolElement(0);
            SGIFigureElementAxisBreak sGIFigureElementAxisBreak = (SGIFigureElementAxisBreak)sGXYFigure.getSymbolElement(1);
            SGIFigureElementSignificantDifference sGIFigureElementSignificantDifference = (SGIFigureElementSignificantDifference)sGXYFigure.getSymbolElement(2);
            SGIFigureElementTimingLine sGIFigureElementTimingLine = (SGIFigureElementTimingLine)sGXYFigure.getSymbolElement(3);
            SGIFigureElementShape sGIFigureElementShape = (SGIFigureElementShape)sGXYFigure.getSymbolElement(4);
            sGIFigureElementGrid.setAxisElement(sGIFigureElementAxis);
            sGIFigureElementAxisBreak.setAxisElement(sGIFigureElementAxis);
            sGIFigureElementSignificantDifference.setAxisElement(sGIFigureElementAxis);
            sGIFigureElementTimingLine.setAxisElement(sGIFigureElementAxis);
            sGIFigureElementString.setAxisElement(sGIFigureElementAxis);
            sGIFigureElementShape.setAxisElement(sGIFigureElementAxis);
        }
    }

    private boolean createFigureElements(SGFigure sGFigure, SGIProgressControl sGIProgressControl) {
        SGDrawingWindow sGDrawingWindow = sGFigure.getWindow();
        SGIFigureElementAxis sGIFigureElementAxis = (SGIFigureElementAxis)this.setIElement(this.mClassOfAxisElement, sGFigure, sGDrawingWindow);
        sGIProgressControl.setProgressValue(0.05f);
        SGIFigureElementGraph sGIFigureElementGraph = (SGIFigureElementGraph)this.setIElement(this.mClassOfGraphElement, sGFigure, sGDrawingWindow);
        sGIProgressControl.setProgressValue(0.1f);
        SGIFigureElementLegend sGIFigureElementLegend = (SGIFigureElementLegend)this.setIElement(this.mClassOfLegendElement, sGFigure, sGDrawingWindow);
        sGIProgressControl.setProgressValue(0.15f);
        SGIFigureElementString sGIFigureElementString = (SGIFigureElementString)this.setIElement(this.mClassOfStringElement, sGFigure, sGDrawingWindow);
        sGIProgressControl.setProgressValue(0.2f);
        SGIFigureElementAxisBreak sGIFigureElementAxisBreak = (SGIFigureElementAxisBreak)this.setIElement(this.mClassOfAxisBreakElement, sGFigure, sGDrawingWindow);
        sGIProgressControl.setProgressValue(0.25f);
        SGIFigureElementSignificantDifference sGIFigureElementSignificantDifference = (SGIFigureElementSignificantDifference)this.setIElement(this.mClassOfSignificantDifferenceElement, sGFigure, sGDrawingWindow);
        sGIProgressControl.setProgressValue(0.3f);
        SGIFigureElementTimingLine sGIFigureElementTimingLine = (SGIFigureElementTimingLine)this.setIElement(this.mClassOfTimingLineElement, sGFigure, sGDrawingWindow);
        sGIProgressControl.setProgressValue(0.35f);
        SGIFigureElementGrid sGIFigureElementGrid = (SGIFigureElementGrid)this.setIElement(this.mClassOfGridElement, sGFigure, sGDrawingWindow);
        sGIProgressControl.setProgressValue(0.5f);
        SGIFigureElementShape sGIFigureElementShape = (SGIFigureElementShape)this.setIElement(this.mClassOfShapeElement, sGFigure, sGDrawingWindow);
        sGIProgressControl.setProgressValue(0.45f);
        sGFigure.setIFigureElement(10, sGIFigureElementGrid);
        sGFigure.setIFigureElement(40, sGIFigureElementTimingLine);
        sGFigure.setIFigureElement(20, sGIFigureElementGraph);
        sGFigure.setIFigureElement(30, sGIFigureElementAxis);
        sGFigure.setIFigureElement(50, sGIFigureElementSignificantDifference);
        sGFigure.setIFigureElement(60, sGIFigureElementShape);
        sGFigure.setIFigureElement(70, sGIFigureElementAxisBreak);
        sGFigure.setIFigureElement(80, sGIFigureElementLegend);
        sGFigure.setIFigureElement(90, sGIFigureElementString);
        this.setRelationOfFigureElements(sGFigure);
        sGIProgressControl.setProgressValue(0.5f);
        return true;
    }

    private SGIFigureElement setIElement(Class clazz, SGFigure sGFigure, Frame frame) {
        Object var4_4 = null;
        try {
            var4_4 = clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        SGIFigureElement sGIFigureElement = var4_4;
        sGIFigureElement.setComponent(sGFigure.getComponent());
        sGIFigureElement.addActionListener(sGFigure);
        sGIFigureElement.setDialogOwner(frame);
        return sGIFigureElement;
    }

    public int createFigureElementFromPropertyFile(SGFigure sGFigure, Element element) {
        NodeList nodeList = null;
        Element element2 = null;
        SGIFigureElement sGIFigureElement = null;
        SGDrawingWindow sGDrawingWindow = sGFigure.getWindow();
        Rectangle2D rectangle2D = sGFigure.getGraphRect();
        sGIFigureElement = this.setIElement(this.mClassOfAxisElement, sGFigure, sGDrawingWindow);
        if (sGIFigureElement == null) {
            return 1;
        }
        sGIFigureElement.setGraphRect(rectangle2D);
        SGIFigureElementAxis sGIFigureElementAxis = (SGIFigureElementAxis)sGIFigureElement;
        sGFigure.setIFigureElement(30, sGIFigureElementAxis);
        nodeList = element.getElementsByTagName("Axes");
        element2 = (Element)nodeList.item(0);
        if (!sGIFigureElement.readProperty(element2)) {
            return 1;
        }
        sGIFigureElement = this.setIElement(this.mClassOfGraphElement, sGFigure, sGDrawingWindow);
        if (sGIFigureElement == null) {
            return 1;
        }
        sGIFigureElement.setGraphRect(rectangle2D);
        SGIFigureElementGraph sGIFigureElementGraph = (SGIFigureElementGraph)sGIFigureElement;
        sGFigure.setIFigureElement(20, sGIFigureElementGraph);
        sGIFigureElement = this.setIElement(this.mClassOfLegendElement, sGFigure, sGDrawingWindow);
        if (sGIFigureElement == null) {
            return 1;
        }
        sGIFigureElement.setGraphRect(rectangle2D);
        SGIFigureElementLegend sGIFigureElementLegend = (SGIFigureElementLegend)sGIFigureElement;
        sGFigure.setIFigureElement(80, sGIFigureElementLegend);
        sGIFigureElementLegend.setAxisElement(sGIFigureElementAxis);
        nodeList = element.getElementsByTagName("Legend");
        if (nodeList.getLength() != 0 && !sGIFigureElement.readProperty(element2 = (Element)nodeList.item(0))) {
            return 1;
        }
        sGIFigureElement = this.setIElement(this.mClassOfStringElement, sGFigure, sGDrawingWindow);
        if (sGIFigureElement == null) {
            return 1;
        }
        sGIFigureElement.setGraphRect(rectangle2D);
        SGIFigureElementString sGIFigureElementString = (SGIFigureElementString)sGIFigureElement;
        sGFigure.setIFigureElement(90, sGIFigureElementString);
        sGIFigureElementString.setAxisElement(sGIFigureElementAxis);
        nodeList = element.getElementsByTagName("Labels");
        if (nodeList.getLength() != 0 && !sGIFigureElement.readProperty(element2 = (Element)nodeList.item(0))) {
            return 1;
        }
        sGIFigureElement = this.setIElement(this.mClassOfAxisBreakElement, sGFigure, sGDrawingWindow);
        if (sGIFigureElement == null) {
            return 1;
        }
        sGIFigureElement.setGraphRect(rectangle2D);
        SGIFigureElementAxisBreak sGIFigureElementAxisBreak = (SGIFigureElementAxisBreak)sGIFigureElement;
        sGFigure.setIFigureElement(70, sGIFigureElementAxisBreak);
        sGIFigureElementAxisBreak.setAxisElement(sGIFigureElementAxis);
        nodeList = element.getElementsByTagName("AxisBreakSymbols");
        if (nodeList.getLength() != 0 && !sGIFigureElement.readProperty(element2 = (Element)nodeList.item(0))) {
            return 1;
        }
        sGIFigureElement = this.setIElement(this.mClassOfSignificantDifferenceElement, sGFigure, sGDrawingWindow);
        if (sGIFigureElement == null) {
            return 1;
        }
        sGIFigureElement.setGraphRect(rectangle2D);
        SGIFigureElementSignificantDifference sGIFigureElementSignificantDifference = (SGIFigureElementSignificantDifference)sGIFigureElement;
        sGFigure.setIFigureElement(50, sGIFigureElementSignificantDifference);
        sGIFigureElementSignificantDifference.setAxisElement(sGIFigureElementAxis);
        nodeList = element.getElementsByTagName("SignificantDifferenceSymbols");
        if (nodeList.getLength() != 0 && !sGIFigureElement.readProperty(element2 = (Element)nodeList.item(0))) {
            return 1;
        }
        sGIFigureElement = this.setIElement(this.mClassOfTimingLineElement, sGFigure, sGDrawingWindow);
        if (sGIFigureElement == null) {
            return 1;
        }
        sGIFigureElement.setGraphRect(rectangle2D);
        SGIFigureElementTimingLine sGIFigureElementTimingLine = (SGIFigureElementTimingLine)sGIFigureElement;
        sGFigure.setIFigureElement(40, sGIFigureElementTimingLine);
        sGIFigureElementTimingLine.setAxisElement(sGIFigureElementAxis);
        nodeList = element.getElementsByTagName("TimingLines");
        if (nodeList.getLength() != 0 && !sGIFigureElement.readProperty(element2 = (Element)nodeList.item(0))) {
            return 1;
        }
        sGIFigureElement = this.setIElement(this.mClassOfGridElement, sGFigure, sGDrawingWindow);
        if (sGIFigureElement == null) {
            return 1;
        }
        sGIFigureElement.setGraphRect(rectangle2D);
        SGIFigureElementGrid sGIFigureElementGrid = (SGIFigureElementGrid)sGIFigureElement;
        sGFigure.setIFigureElement(10, sGIFigureElementGrid);
        sGIFigureElementGrid.setAxisElement(sGIFigureElementAxis);
        nodeList = element.getElementsByTagName("Grid");
        if (nodeList.getLength() != 0 ? !sGIFigureElement.readProperty(element2 = (Element)nodeList.item(0)) : !sGIFigureElement.initCompatibleProperty()) {
            return 1;
        }
        sGIFigureElement = this.setIElement(this.mClassOfShapeElement, sGFigure, sGDrawingWindow);
        SGIFigureElementShape sGIFigureElementShape = (SGIFigureElementShape)sGIFigureElement;
        if (sGIFigureElement == null) {
            return 1;
        }
        sGIFigureElement.setGraphRect(rectangle2D);
        sGFigure.setIFigureElement(60, sGIFigureElementShape);
        sGIFigureElementShape.setAxisElement(sGIFigureElementAxis);
        nodeList = element.getElementsByTagName("Shape");
        if (nodeList.getLength() != 0 && !sGIFigureElement.readProperty(element2 = (Element)nodeList.item(0))) {
            return 1;
        }
        this.setRelationOfFigureElements(sGFigure);
        return 0;
    }

    private SGFigure createFigure(int n, SGDrawingWindow sGDrawingWindow, SGData[] sGDataArray) {
        float f;
        float f2;
        String string;
        SGDrawingWindow sGDrawingWindow2 = sGDrawingWindow;
        SGXYFigure sGXYFigure = null;
        SGData sGData = sGDataArray[0];
        if (sGData instanceof SGISXYTypeData || sGData instanceof SGISXYTypeMultipleData) {
            sGXYFigure = new SGXYFigure(sGDrawingWindow);
            string = "SXY";
            f2 = 15.0f;
            f = 9.0f;
        } else if (sGData instanceof SGIVXYTypeData) {
            sGXYFigure = new SGXYFigure(sGDrawingWindow);
            string = "VXY";
            f2 = 9.0f;
            f = 9.0f;
        } else if (sGData instanceof SGISXYZTypeData) {
            sGXYFigure = new SGXYFigure(sGDrawingWindow);
            string = "SXY";
            f2 = 10.0f;
            f = 10.0f;
        } else {
            return null;
        }
        sGXYFigure.setVisible(false);
        sGXYFigure.setID(n);
        sGXYFigure.setClassType(string);
        if (!this.createFigureElements(sGXYFigure, sGDrawingWindow2)) {
            return null;
        }
        sGXYFigure.setFigureWidth(f2, "cm");
        sGXYFigure.setFigureHeight(f, "cm");
        return sGXYFigure;
    }

    public SGFigure createEmptyFigure(int n, SGDrawingWindow sGDrawingWindow) {
        SGXYFigure sGXYFigure = new SGXYFigure(sGDrawingWindow);
        sGXYFigure.setVisible(false);
        sGXYFigure.setID(n);
        if (!this.createFigureElements(sGXYFigure, sGDrawingWindow)) {
            return null;
        }
        sGXYFigure.setFigureWidth(10.0f, "cm");
        sGXYFigure.setFigureHeight(10.0f, "cm");
        return sGXYFigure;
    }

    public boolean createNewFigure(SGDrawingWindow sGDrawingWindow, int n, Point point, Integer[] integerArray, SGData[] sGDataArray, String[] stringArray, Map<String, Object> map) {
        SGDrawingWindow sGDrawingWindow2 = sGDrawingWindow;
        sGDrawingWindow2.startProgress();
        sGDrawingWindow2.setProgressMessage("Create Figure");
        SGFigure sGFigure = this.createFigure(n, sGDrawingWindow, sGDataArray);
        if (sGFigure == null) {
            sGDrawingWindow2.endProgress();
            return false;
        }
        sGDrawingWindow2.setProgressValue(0.55f);
        if (!sGDrawingWindow.addFigure(sGFigure, point)) {
            sGDrawingWindow.endProgress();
            return false;
        }
        if (!sGFigure.addData(sGDataArray, integerArray, stringArray, sGDrawingWindow2, 0.6f, 0.9f, map)) {
            sGDrawingWindow.endProgress();
            return false;
        }
        sGDrawingWindow2.setProgressValue(1.0f);
        SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].initPropertiesHistory()) continue;
            sGDrawingWindow.endProgress();
            return false;
        }
        if (point != null) {
            sGFigure.drawbackFigure();
        } else {
            sGFigure.setFigureX(2.0f, "cm");
            sGFigure.setFigureY(1.0f, "cm");
        }
        sGFigure.initPropertiesHistory();
        sGFigure.setVisible(true);
        sGDrawingWindow.setVisible(true);
        sGDrawingWindow.setChanged(true);
        sGDrawingWindow.updateItemsByFigureNumbers();
        sGDrawingWindow2.setProgressValue(1.0f);
        sGDrawingWindow2.endProgress();
        return true;
    }
}

