/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationUtility;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationTextConstants;
import jp.riken.brain.ni.samuraigraph.application.SGMainFunctions;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyFileConstants;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class SGClipBoardManager
implements SGIDisposable,
SGIConstants,
SGIApplicationTextConstants,
SGIPropertyFileConstants {
    private List<SGICopiable> mCopiedObjectsBuffer = new ArrayList<SGICopiable>();
    private List<SGData> mCopiedDataObjectBuffer = new ArrayList<SGData>();
    private List<String> mCopiedDataNameBuffer = new ArrayList<String>();
    private List<Map<Class, SGProperties>> mCopiedDataPropertiesBuffer = new ArrayList<Map<Class, SGProperties>>();
    private WindowInfo mWindowInfo = null;
    private SGMainFunctions mMain = null;
    private boolean mDisposed = false;

    SGClipBoardManager(SGMainFunctions sGMainFunctions) {
        this.mMain = sGMainFunctions;
    }

    public void dispose() {
        this.mDisposed = true;
        this.clearAllLists();
    }

    public boolean isDisposed() {
        return this.mDisposed;
    }

    private void clearAllLists() {
        for (int i = 0; i < this.mCopiedDataObjectBuffer.size(); ++i) {
            SGData object = this.mCopiedDataObjectBuffer.get(i);
            object.dispose();
        }
        this.mCopiedObjectsBuffer.clear();
        this.mCopiedDataNameBuffer.clear();
        this.mCopiedDataPropertiesBuffer.clear();
        this.mCopiedDataObjectBuffer.clear();
        if (this.mWindowInfo != null) {
            for (Map.Entry entry : this.mWindowInfo.mDataListMap.entrySet()) {
                List list = (List)entry.getValue();
                for (SGData sGData : list) {
                    sGData.dispose();
                }
                list.clear();
            }
            this.mWindowInfo.mDataListMap.clear();
            this.mWindowInfo.mDocument = null;
            this.mWindowInfo = null;
        }
    }

    boolean cutAndCopy(SGDrawingWindow sGDrawingWindow, boolean bl) {
        this.clearAllLists();
        List<SGICopiable> list = sGDrawingWindow.getCopiedObjectsList();
        this.mCopiedObjectsBuffer.addAll(list);
        List<SGData> list2 = sGDrawingWindow.getCopiedObjectsDataList();
        this.mCopiedDataObjectBuffer.addAll(list2);
        List<String> list3 = sGDrawingWindow.getCopiedDataNameList();
        this.mCopiedDataNameBuffer.addAll(list3);
        List<Map<Class, SGProperties>> list4 = sGDrawingWindow.getCopiedDataPropertiesMapList();
        this.mCopiedDataPropertiesBuffer.addAll(list4);
        WindowInfo windowInfo = new WindowInfo();
        if (bl ? !this.copyFigures(sGDrawingWindow, windowInfo, 4) : !this.cutFigures(sGDrawingWindow, windowInfo)) {
            return false;
        }
        this.mWindowInfo = windowInfo;
        this.mMain.mWindowManager.setPasteMenuEnabled();
        sGDrawingWindow.clearCopiedObjectsList();
        return true;
    }

    private boolean cutFigures(SGDrawingWindow sGDrawingWindow, WindowInfo windowInfo) {
        if (!this.copyFigures(sGDrawingWindow, windowInfo, 5)) {
            return false;
        }
        if (windowInfo.mDataListMap.size() != 0) {
            sGDrawingWindow.hideSelectedObjects();
        }
        return true;
    }

    private boolean copyFigures(SGDrawingWindow sGDrawingWindow, WindowInfo windowInfo, int n) {
        DOMImplementation dOMImplementation = SGApplicationUtility.getDOMImplementation();
        if (dOMImplementation == null) {
            return false;
        }
        Document document = dOMImplementation.createDocument("", "FocusedFigures", null);
        if (!sGDrawingWindow.createDOMTree(document, 3, n)) {
            return false;
        }
        TreeMap treeMap = new TreeMap();
        List<SGFigure> list = sGDrawingWindow.getCopiedFiguresList();
        for (int i = 0; i < list.size(); ++i) {
            SGFigure sGFigure = list.get(i);
            ArrayList<SGData> arrayList = new ArrayList<SGData>(sGFigure.getVisibleDataList());
            ArrayList<SGData> arrayList2 = new ArrayList<SGData>();
            for (int j = 0; j < arrayList.size(); ++j) {
                SGData sGData = (SGData)arrayList.get(j);
                arrayList2.add((SGData)sGData.copy());
            }
            Integer n2 = sGFigure.getID();
            treeMap.put(n2, arrayList2);
        }
        windowInfo.mDocument = document;
        windowInfo.mDataListMap = treeMap;
        return true;
    }

    boolean pasteToWindow(SGDrawingWindow sGDrawingWindow) {
        List<SGISelectable> list = sGDrawingWindow.getFocusedObjectsList();
        if (list.size() != 0) {
            sGDrawingWindow.pasteToFigures(this.mCopiedObjectsBuffer, this.mCopiedDataObjectBuffer, this.mCopiedDataNameBuffer, this.mCopiedDataPropertiesBuffer);
        } else {
            Object object;
            Object object2;
            Object object3;
            SGMainFunctions.WrappedData[] wrappedDataArray;
            WindowInfo windowInfo = this.mWindowInfo;
            if (windowInfo == null) {
                return false;
            }
            Map map = windowInfo.mDataListMap;
            ArrayList<SGMainFunctions.WrappedData> arrayList = new ArrayList<SGMainFunctions.WrappedData>();
            Iterator iterator = map.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                wrappedDataArray = (SGMainFunctions.WrappedData[])iterator.next();
                object3 = (List)map.get(wrappedDataArray);
                for (int i = 0; i < object3.size(); ++i) {
                    object2 = (SGData)object3.get(i);
                    object = new SGMainFunctions.FigureData((SGData)object2, n);
                    SGMainFunctions.WrappedData wrappedData = new SGMainFunctions.WrappedData((SGMainFunctions.FigureData)object);
                    arrayList.add(wrappedData);
                }
                ++n;
            }
            wrappedDataArray = new SGMainFunctions.WrappedData[arrayList.size()];
            arrayList.toArray(wrappedDataArray);
            object3 = windowInfo.mDocument.getDocumentElement();
            String string = object3.getAttribute("Version");
            object2 = object3.getElementsByTagName("Window");
            if (object2.getLength() == 0) {
                return false;
            }
            object = (Element)object2.item(0);
            int n2 = sGDrawingWindow.getFigureList().size();
            int n3 = this.mMain.createFiguresFromPropertyFile((Element)object, sGDrawingWindow, wrappedDataArray, true, string, 4);
            if (n3 != 0) {
                return false;
            }
            int n4 = sGDrawingWindow.getFigureList().size();
            sGDrawingWindow.setChanged(n2 != n4);
        }
        return true;
    }

    boolean getPasteMenuStatus() {
        boolean bl = this.mCopiedObjectsBuffer.size() != 0;
        boolean bl2 = this.mCopiedDataObjectBuffer.size() != 0;
        boolean bl3 = false;
        if (this.mWindowInfo != null) {
            Document document = this.mWindowInfo.mDocument;
            NodeList nodeList = document.getElementsByTagName("Figure");
            int n = nodeList.getLength();
            bl3 = n != 0;
        }
        boolean bl4 = bl || bl2 || bl3;
        return bl4;
    }

    private class WindowInfo {
        private Document mDocument;
        private Map<Integer, List<SGData>> mDataListMap = new TreeMap<Integer, List<SGData>>();

        private WindowInfo() {
        }
    }
}

