/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDropEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.riken.brain.ni.samuraigraph.application.SGDataCreator;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationTextConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIImageConstants;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfoSet;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import org.w3c.dom.DOMImplementation;
import ucar.nc2.NetcdfFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGApplicationUtility
implements SGIApplicationTextConstants,
SGIDataColumnTypeConstants,
SGIImageConstants {
    public static void deleteRecursively(File file) {
        if (file.isDirectory()) {
            String string = SGIConstants.FILE_SEPARATOR;
            String[] stringArray = file.list();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(file.toString());
            stringBuffer.append(string);
            int n = stringBuffer.length();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i].toString());
                File file2 = new File(stringBuffer.toString());
                SGApplicationUtility.deleteRecursively(file2);
                stringBuffer.setLength(n);
            }
        }
        file.delete();
    }

    public static void deleteOnExitRecursively(File file) {
        if (file.isDirectory()) {
            String string = SGIConstants.FILE_SEPARATOR;
            String[] stringArray = file.list();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(file.toString());
            stringBuffer.append(string);
            int n = stringBuffer.length();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i].toString());
                File file2 = new File(stringBuffer.toString());
                SGApplicationUtility.deleteOnExitRecursively(file2);
                stringBuffer.setLength(n);
            }
        }
        file.deleteOnExit();
    }

    public static boolean copyBinaryFile(File file, File file2) throws IOException {
        int n;
        if (file == null || file2 == null) {
            return false;
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            return false;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        byte[] byArray = new byte[1024];
        while ((n = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        bufferedOutputStream.close();
        return true;
    }

    public static boolean copyBinaryFile(String string, String string2) throws IOException {
        if (string == null || string2 == null) {
            return false;
        }
        return SGApplicationUtility.copyBinaryFile(new File(string), new File(string2));
    }

    public static DOMImplementation getDOMImplementation() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        return dOMImplementation;
    }

    public static void findFiles(File file, String string, ArrayList arrayList) {
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                SGApplicationUtility.findFiles(fileArray[i], string, arrayList);
                continue;
            }
            String string2 = fileArray[i].getName();
            if (!string2.equals(string)) continue;
            arrayList.add(fileArray[i].getAbsolutePath());
        }
    }

    public static boolean compareVersionNumber(int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = n < n4 ? true : (n == n4 ? (n2 < n5 ? true : (n2 == n5 ? n3 < n6 : false)) : false);
        return bl;
    }

    public static final void showDataFileInvalidMessageDialog(Window window) {
        SGUtility.showErrorMessageDialog(window, "The data file is invalid.", "Error");
    }

    public static final void showDataTypeInvalidMessageDialog(Window window) {
        SGUtility.showErrorMessageDialog(window, "The data type is invalid.", "Error");
    }

    public static List getDroppedFileList(DropTargetDropEvent dropTargetDropEvent) {
        ArrayList<File> arrayList = new ArrayList<File>();
        dropTargetDropEvent.acceptDrop(3);
        try {
            if ((dropTargetDropEvent.getDropAction() & 3) != 0) {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    arrayList.addAll(list);
                } else if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        File file = new File(new URI(string2.trim()));
                        arrayList.add(file);
                    }
                }
            }
        }
        catch (Exception exception) {
            dropTargetDropEvent.dropComplete(false);
            return null;
        }
        dropTargetDropEvent.dropComplete(true);
        return arrayList;
    }

    public static String getPathName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(SGIConstants.FILE_SEPARATOR);
        stringBuffer.append(string2);
        String string3 = stringBuffer.toString();
        return string3;
    }

    public static String appendExtension(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append('.');
        stringBuffer.append(string2);
        String string3 = stringBuffer.toString();
        return string3;
    }

    public static boolean hasExtension(String string, String string2) {
        return string.toLowerCase().endsWith("." + string2.toLowerCase());
    }

    public static boolean isNetCDFFile(String string) {
        try {
            boolean bl = NetcdfFile.canOpen((String)string);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static SGDataColumnInfoSet getArrayDataColInfoSet(SGDataCreator.FileColumn[] fileColumnArray, String string, Map<String, Object> map) {
        int n;
        int n2 = fileColumnArray.length;
        SGDataColumnInfo[] sGDataColumnInfoArray = new SGDataColumnInfo[n2];
        for (int i = 0; i < n2; ++i) {
            sGDataColumnInfoArray[i] = new SGDataColumnInfo(fileColumnArray[i].title, fileColumnArray[i].valueType);
        }
        SGDataColumnInfo[] sGDataColumnInfoArray2 = SGApplicationUtility.getAdditionalInfoArray(string, map, sGDataColumnInfoArray);
        SGDataColumnInfo[] sGDataColumnInfoArray3 = new SGDataColumnInfo[sGDataColumnInfoArray.length + sGDataColumnInfoArray2.length];
        for (n = 0; n < sGDataColumnInfoArray.length; ++n) {
            sGDataColumnInfoArray3[n] = sGDataColumnInfoArray[n];
        }
        for (n = 0; n < sGDataColumnInfoArray2.length; ++n) {
            sGDataColumnInfoArray3[n + sGDataColumnInfoArray.length] = sGDataColumnInfoArray2[n];
        }
        SGDataColumnInfoSet sGDataColumnInfoSet = new SGDataColumnInfoSet(sGDataColumnInfoArray3);
        return sGDataColumnInfoSet;
    }

    static SGDataColumnInfo[] getAdditionalInfoArray(String string, Map<String, Object> map, SGDataColumnInfo[] sGDataColumnInfoArray) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Double d = (Double)map.get("Sampling rate");
        if (d != null) {
            object = new SGDataColumnInfo(SGDataUtility.createSamplingRateTitle(d), "Sampling Rate");
            ((SGDataColumnInfo)object).setColumnType("X");
            arrayList.add(object);
        }
        object = new SGDataColumnInfo[arrayList.size()];
        object = arrayList.toArray((T[])object);
        return object;
    }

    static String getArrayDataType(String string) {
        String string2 = string;
        if ("SXY_SAMPLING".equals(string)) {
            string2 = "SXY_MULTIPLE";
        } else if ("SXY_DATE".equals(string)) {
            string2 = "SXY";
        }
        return string2;
    }

    static String getExactTypeString(String[] stringArray, String string) {
        if (null == string) {
            return null;
        }
        if (stringArray.length == 0) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!SGUtilityText.isEqualString(stringArray[i], string)) continue;
            return stringArray[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] toByteArray(File file) {
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                byte[] byArray2 = null;
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (byteArrayOutputStream == null) return byArray2;
                try {
                    byteArrayOutputStream.close();
                    return byArray2;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return byArray2;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (IOException iOException) {
            byte[] byArray4 = null;
            return byArray4;
        }
        bufferedInputStream = new BufferedInputStream(fileInputStream);
        byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray3 = new byte[1024];
        while (true) {
            if (bufferedInputStream.read(byArray3) == -1) {
                return byteArrayOutputStream.toByteArray();
            }
            byteArrayOutputStream.write(byArray3);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getExtension(File file) {
        String string = file.getPath();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        if (n == string.length() - 1) {
            return null;
        }
        String string2 = string.substring(n + 1);
        return SGApplicationUtility.findExtension(string2);
    }

    public static String findExtension(String string) {
        for (int i = 0; i < DRAWABLE_IMAGE_EXTENSIONS.length; ++i) {
            if (!DRAWABLE_IMAGE_EXTENSIONS[i].equalsIgnoreCase(string)) continue;
            return DRAWABLE_IMAGE_EXTENSIONS[i];
        }
        return null;
    }
}

