/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationConstants;
import jp.riken.brain.ni.samuraigraph.base.SGBrowserLauncher;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;
import jp.riken.brain.ni.samuraigraph.base.SGImagePanel;

public class SGAboutDialog
extends SGDialog
implements ActionListener,
ComponentListener,
SGIApplicationConstants {
    private static final long serialVersionUID = 1528835468569338270L;
    private JPanel mButtonPanel;
    private SGImagePanel mImagePanel;
    private JLayeredPane mLayeredPanel;
    private SGButton mOKButton;
    private JLabel mVersionLabel;
    public static final String TITLE = "About Samurai Graph";
    public static final String ABOUT_IMAGE_FILE = "About.png";
    private static final Rectangle web_rect = new Rectangle(157, 200, 216, 14);
    private static final Rectangle lab_rect = new Rectangle(216, 230, 166, 14);
    private static String SAMURAI_GRAPH_URL = "http://samurai-graph.sourceforge.jp/";
    private static String NEUROINFORMATICS_LAB_URL = "http://www.ni.brain.riken.jp/";
    private static final int verpos_r = 375;
    private static final int verpos_t = 125;
    private static final int verpos_b = 155;
    private boolean is_linkcursor = false;

    public SGAboutDialog(String string) {
        this.initComponents();
        this.initProperty(string);
    }

    public SGAboutDialog(Frame frame, boolean bl, String string) {
        super(frame, bl);
        this.initComponents();
        this.initProperty(string);
    }

    private void initComponents() {
        this.mButtonPanel = new JPanel();
        this.mOKButton = new SGButton();
        this.mLayeredPanel = new JLayeredPane();
        this.mImagePanel = new SGImagePanel();
        this.mVersionLabel = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mOKButton.setText("OK");
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mOKButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mLayeredPanel.setPreferredSize(new Dimension(400, 300));
        this.mImagePanel.setPreferredSize(new Dimension(400, 300));
        this.mImagePanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SGAboutDialog.this.mImagePanelMouseClicked(mouseEvent);
            }
        });
        this.mImagePanel.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                SGAboutDialog.this.mImagePanelMouseMoved(mouseEvent);
            }
        });
        this.mImagePanel.setBounds(0, 0, 400, 300);
        this.mLayeredPanel.add((Component)this.mImagePanel, JLayeredPane.DEFAULT_LAYER);
        this.mVersionLabel.setFont(new Font("Serif", 1, 14));
        this.mVersionLabel.setText(" ");
        this.mVersionLabel.setBounds(0, 0, 90, 20);
        this.mLayeredPanel.add((Component)this.mVersionLabel, JLayeredPane.DEFAULT_LAYER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)this.mLayeredPanel, gridBagConstraints);
        this.pack();
    }

    private void mImagePanelMouseClicked(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        if (web_rect.contains(n2, n = mouseEvent.getY())) {
            try {
                SGBrowserLauncher.openURL(SAMURAI_GRAPH_URL);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (lab_rect.contains(n2, n)) {
            try {
                SGBrowserLauncher.openURL(NEUROINFORMATICS_LAB_URL);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void mImagePanelMouseMoved(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        if (web_rect.contains(n2, n = mouseEvent.getY())) {
            this.setLinkCursorForm(true);
        } else if (lab_rect.contains(n2, n)) {
            this.setLinkCursorForm(true);
        } else {
            this.setLinkCursorForm(false);
        }
    }

    private void setLinkCursorForm(boolean bl) {
        if (!this.is_linkcursor && bl) {
            Cursor cursor = new Cursor(12);
            this.setCursor(cursor);
            this.is_linkcursor = true;
        } else if (this.is_linkcursor && !bl) {
            Cursor cursor = Cursor.getDefaultCursor();
            this.setCursor(cursor);
            this.is_linkcursor = false;
        }
    }

    private boolean initProperty(String string) {
        this.setTitle(TITLE);
        this.setVisible(false);
        this.setResizable(false);
        this.mOKButton.addActionListener(this);
        this.addComponentListener(this);
        Class<?> clazz = this.getClass();
        String string2 = null;
        URL uRL = null;
        string2 = "/resources/About.png";
        uRL = clazz.getResource(string2);
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.mImagePanel.setImage(image);
        AbstractAction abstractAction = new AbstractAction(""){
            private static final long serialVersionUID = 1754746632316235426L;

            public void actionPerformed(ActionEvent actionEvent) {
                SGAboutDialog.this.setVisible(false);
            }
        };
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "close-it");
        this.getRootPane().getActionMap().put("close-it", abstractAction);
        String string3 = "Version " + string;
        this.mVersionLabel.setText(string3);
        Font font = this.mVersionLabel.getFont();
        Rectangle2D rectangle2D = font.getStringBounds(string3, new FontRenderContext(null, false, false));
        int n = (int)rectangle2D.getHeight();
        int n2 = (int)rectangle2D.getWidth();
        int n3 = (30 - n) / 2 + 125;
        int n4 = 375 - n2;
        this.mVersionLabel.setSize(n2, n);
        this.mVersionLabel.setBounds(n4, n3, n2, n);
        this.mLayeredPanel.setLayer(this.mImagePanel, 1);
        this.mLayeredPanel.setLayer(this.mVersionLabel, 2);
        this.pack();
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.mOKButton)) {
            this.setVisible(false);
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
        Window window = this.getOwner();
        if (window != null) {
            window.repaint();
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void dispose() {
        ActionListener[] actionListenerArray = this.mOKButton.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            this.mOKButton.removeActionListener(actionListenerArray[i]);
        }
        ComponentListener[] componentListenerArray = this.getComponentListeners();
        for (int i = 0; i < componentListenerArray.length; ++i) {
            this.removeComponentListener(componentListenerArray[i]);
        }
        MouseListener[] mouseListenerArray = this.mImagePanel.getMouseListeners();
        for (int i = 0; i < mouseListenerArray.length; ++i) {
            this.removeMouseListener(mouseListenerArray[i]);
        }
        MouseMotionListener[] mouseMotionListenerArray = this.mImagePanel.getMouseMotionListeners();
        for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
            this.removeMouseMotionListener(mouseMotionListenerArray[i]);
        }
        super.dispose();
    }

    protected void onEscKeyTyped() {
        this.setVisible(false);
        this.setCloseOption(1);
    }
}

