
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;

/**
 * A dialog to set the properties of two-dimensional vector type data.
 */
public class SGPropertyDialogVXYData extends SGDataDialog
{
	/**
	 * 
	 */
	private static final long serialVersionUID = -8568651377496230416L;
	/**
	 * 
	 */
	public static final String TITLE = "VXY-Data Properties";

    /** Creates new form SGPropertyDialogVXYData */
    public SGPropertyDialogVXYData( java.awt.Frame parent, boolean modal )
    {
		super( parent, modal );
		this.initComponents();
        this.initProperty();
        this.initialize();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mCommonPanel = new javax.swing.JPanel();
        mLegendVisibleCheckBox = new jp.riken.brain.ni.samuraigraph.base.SGCheckBox();
        mNameLabel = new javax.swing.JLabel();
        mNameField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mAxisPanel = new jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel();
        mMagnitudePerCMLabel = new javax.swing.JLabel();
        mMagnitudePerCMTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mDirectionInvariantRadioButton = new javax.swing.JRadioButton();
        mAmplitudeInvariantRadioButton = new javax.swing.JRadioButton();
        mInvariantModeLabel = new javax.swing.JLabel();
        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();
        mArrowPanel = new jp.riken.brain.ni.samuraigraph.figure.java2d.SGArrowPanel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        mCommonPanel.setLayout(new java.awt.GridBagLayout());

        mLegendVisibleCheckBox.setText("Legend Visible");
        mLegendVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mLegendVisibleCheckBox, gridBagConstraints);

        mNameLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mNameLabel.setText("Name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        mCommonPanel.add(mNameLabel, gridBagConstraints);

        mNameField.setColumns(16);
        mNameField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mNameField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        mCommonPanel.add(mAxisPanel, gridBagConstraints);

        mMagnitudePerCMLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mMagnitudePerCMLabel.setText("Magnitude per cm");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        mCommonPanel.add(mMagnitudePerCMLabel, gridBagConstraints);

        mMagnitudePerCMTextField.setColumns(6);
        mMagnitudePerCMTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mMagnitudePerCMTextField, gridBagConstraints);

        mDirectionInvariantRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mDirectionInvariantRadioButton.setText("Direction");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mCommonPanel.add(mDirectionInvariantRadioButton, gridBagConstraints);

        mAmplitudeInvariantRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mAmplitudeInvariantRadioButton.setText("Amplitude");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mCommonPanel.add(mAmplitudeInvariantRadioButton, gridBagConstraints);

        mInvariantModeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mInvariantModeLabel.setText("Invariant Mode");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        mCommonPanel.add(mInvariantModeLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        getContentPane().add(mCommonPanel, gridBagConstraints);

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        mArrowPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mArrowPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JRadioButton mAmplitudeInvariantRadioButton;
    private jp.riken.brain.ni.samuraigraph.figure.java2d.SGArrowPanel mArrowPanel;
    private jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel mAxisPanel;
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JPanel mCommonPanel;
    private javax.swing.JRadioButton mDirectionInvariantRadioButton;
    private javax.swing.JLabel mInvariantModeLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGCheckBox mLegendVisibleCheckBox;
    private javax.swing.JLabel mMagnitudePerCMLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mMagnitudePerCMTextField;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mNameField;
    private javax.swing.JLabel mNameLabel;
    private javax.swing.JButton mOKButton;
    private javax.swing.JButton mPreviewButton;
    // ϐ錾̏I//GEN-END:variables
    

    
    private boolean initProperty()
    {
		// set the title
		this.setTitle( SGPropertyDialogVXYData.TITLE );


		// create a button group
		ButtonGroup bg = new ButtonGroup();
		bg.add( this.mDirectionInvariantRadioButton );
		bg.add( this.mAmplitudeInvariantRadioButton );
		bg.add( this.mNoInvariantModeSelectionRadioButton );


		this.mOKButton.addActionListener(this);
		this.mCancelButton.addActionListener(this);
		this.mPreviewButton.addActionListener(this);


		// set the name
		this.mNameField.setDescription("Name");
		this.mMagnitudePerCMTextField.setDescription("Magnitude per cm");

    	return true;
    }
    
    

	/**
	 * 
	 */
	public java.util.List getColorSelectionButtonsList()
	{
		ArrayList list = new ArrayList();
		list.addAll( this.mArrowPanel.getColorSelectionButtonsList() );
		return list;
	}

	/**
	 * 
	 */
	public java.util.List getNumberTextFieldList()
	{
		ArrayList list = new ArrayList();
		return list;
	}

	/**
	 * 
	 */
	public java.util.List getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.addAll( this.mArrowPanel.getSpinnerList() );
		return list;
	}

	/**
	 * 
	 */
	public java.util.List getTextFieldComponentsList()
	{
		final List list = this.getFormattedTextFieldsListFromSpinners();
		list.addAll( this.getNumberTextFieldList() );
		list.add( this.mNameField );
		list.add( this.mMagnitudePerCMTextField );
		return list;
	}


	/**
	 * 
	 * @param l
	 * @return
	 */
	public boolean addPropertyDialogObserver(
		final SGIPropertyDialogObserver l )
	{
		super.addPropertyDialogObserver(l);
		if( l instanceof SGIArrowPanelObserver )
		{
			this.mArrowPanel.addObserver( (SGIArrowPanelObserver)l );
		}
		return true;
	}


	/**
	 * 
	 * @param l
	 * @return
	 */
	public boolean removePropertyDialogObserver(
		final SGIPropertyDialogObserver l )
	{
		super.removePropertyDialogObserver(l);
		if( l instanceof SGIArrowPanelObserver )
		{
			this.mArrowPanel.removeObserver( (SGIArrowPanelObserver)l );
		}
		return true;
	}



	/**
	 * 
	 * @return
	 */
	public boolean removeAllPropertyDialogObserver()
	{
		super.removeAllPropertyDialogObserver();
		this.mArrowPanel.removeAllObserver();
		return true;
	}


	/**
	 * 
	 * @return
	 */
	public String getDataName()
	{
		return this.mNameField.getText();
	}


	/**
	 * 
	 * @param str
	 * @return
	 */
	public boolean setDataName( final String str )
	{
		this.mNameField.setText(str);
		return true;
	}



	/**
	 * 
	 * @return
	 */
	public Boolean getLegendVisible()
	{
		return this.mLegendVisibleCheckBox.getSelected();
	}

	
	/**
	 * 
	 * @param b
	 */
	public void setLegendVisible( final Boolean b )
	{
		this.mLegendVisibleCheckBox.setSelected(b);
	}


	/**
	 * 
	 */
	public boolean setDialogProperty()
	{
		List list = this.mPropertyDialogObserverList;
//		final int len = list.size();

		// axes
		if( this.mAxisPanel.setSelected( list ) == false )
		{
			return false;
		}

		// data name
		String name = this.getDataNameFromObservers();
		this.setDataName( name );

		// visible in legend
		Boolean legendVisible = this.getLegendVisibleFromObservers();
		this.setLegendVisible( legendVisible );

		// scaling factor
		Float f = this.getScalingFactorFromObservers();
		this.setMagnitudePerCM(f);
		
		// invariance
		Boolean invariant = this.getInvarianceFromObservers();
		this.setDirectionInvariant( invariant );


		// arrow properties
		if( this.mArrowPanel.setComponentsProperty() == false )
		{
			return false;
		}

		return true;
	}


	/**
	 * 
	 * @param value
	 */
	public boolean setMagnitudePerCM( final Object obj )
	{
		return this.setValue( this.mMagnitudePerCMTextField, obj );
	}


	/**
	 * 
	 * @return
	 */
	public Number getMagnitudePerCM()
	{
		return this.getNumber( this.mMagnitudePerCMTextField );
	}


	//
	private Float getScalingFactorFromObservers()
	{
		List oList = this.mPropertyDialogObserverList;
		final int len = oList.size();
		if( len==0 )
		{
			return null;
		}

		ArrayList lList = new ArrayList( len );
		for( int ii=0; ii<len; ii++ )
		{
			SGIVXYDataDialogObserver l
				= (SGIVXYDataDialogObserver)oList.get(ii);
			lList.add( new Float( l.getMagnitudePerCM() ) );
		}

		Float m0 = (Float)lList.get(0);
		Float m = m0;
		if( len>1 )
		{
			for( int ii=1; ii<len; ii++ )
			{
				Float m1 = (Float)lList.get(ii);
				if( m0.equals( m1 ) == false )
				{
					m = null;
					break;
				}
			}
		}

		return m;
	}



	private JRadioButton mNoInvariantModeSelectionRadioButton = new JRadioButton();


	/**
	 * 
	 */
	public Boolean isDirectionInvariant()
	{
		if( this.mDirectionInvariantRadioButton.isSelected() )
		{
			return Boolean.TRUE;
		}
		else if( this.mAmplitudeInvariantRadioButton.isSelected() )
		{
			return Boolean.FALSE;
		}
		else
		{
			return null;
		}
	}


	/**
	 * 
	 */
	public boolean setDirectionInvariant( final Object obj )
	{
		if( obj==null )
		{
			this.mNoInvariantModeSelectionRadioButton.setSelected(true);
			return false;
		}

		Boolean b = (Boolean)obj;
		if( b.booleanValue() )
		{
			this.mDirectionInvariantRadioButton.setSelected(true);
		}
		else
		{
			this.mAmplitudeInvariantRadioButton.setSelected(true);
		}

		return true;
	}


	//
	private Boolean getInvarianceFromObservers()
	{
		List oList = this.mPropertyDialogObserverList;
		final int len = oList.size();
		if( len==0 )
		{
			return null;
		}

		ArrayList lList = new ArrayList( len );
		for( int ii=0; ii<len; ii++ )
		{
			SGIVXYDataDialogObserver l
				= (SGIVXYDataDialogObserver)oList.get(ii);
			lList.add( Boolean.valueOf( l.isDirectionInvariant() ) );
		}

		Boolean m0 = (Boolean)lList.get(0);
		Boolean m = m0;
		if( len>1 )
		{
			for( int ii=1; ii<len; ii++ )
			{
				Boolean m1 = (Boolean)lList.get(ii);
				if( m0.equals( m1 ) == false )
				{
					m = null;
					break;
				}
			}
		}

		return m;
	}




	/**
	 * 
	 */
	public boolean setPropertiesToListeners( SGIPropertyDialogObserver l )
	{
		SGIVXYDataDialogObserver vxy = (SGIVXYDataDialogObserver)l;
	
		final int xConfig = this.mAxisPanel.getXAxisConfiguration();
		final int yConfig = this.mAxisPanel.getYAxisConfiguration();


		// set the related axes
		if( xConfig!=-1 )
		{
			vxy.setXAxisLocation( xConfig );
		}

		if( yConfig!=-1 )
		{
			vxy.setYAxisLocation( yConfig );
		}

		// data name
		String name = this.getDataName();
		if( name!=null )
		{
			vxy.setName( name );
		}

		// visibility in legend
		Boolean legendVisible = this.getLegendVisible();
		if( legendVisible!=null )
		{
			vxy.setVisibleInLegend( legendVisible.booleanValue() );
		}

		// scaling factor
		Number factor = this.getMagnitudePerCM();
		if( factor!=null )
		{
			vxy.setMagnitudePerCM( factor.floatValue() );
		}

		// invariant mode
		Boolean invariant = this.isDirectionInvariant();
		if( invariant!=null )
		{
			vxy.setDirectionInvariant( invariant.booleanValue() );
		}


		// set with the arrow panel
		if( this.mArrowPanel.setPropertiesToListeners( vxy ) == false )
		{
			final String msg = this.mArrowPanel.getInputErrorMessage();
			if( msg!=null )
			{
				this.setInputErrorMessage( msg );
			}
			return false;
		}

		return true;
	}

}

