
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;

/**
 * An observer of the properties dialog for axes.
 */
public interface SGIAxisDialogObserver extends SGIPropertyDialogObserver
{

	/**
	 * @return
	 * @uml.property  name="fontName"
	 */
	public String getFontName();



	/**
	 *
	 */
	public float getFontSize( final String unit );



	/**
	 * @uml.property  name="fontStyle"
	 */
	public int getFontStyle();


	/**
	 * @return
	 * @uml.property  name="stringColor"
	 */
	public Color getStringColor();


	/**
	 * 
	 * @return
	 */
	public boolean isFrameLineVisible();


	/**
	 * 
	 * @return
	 */
	public float getFrameLineWidth( final String unit );


	/**
	 * @return
	 * @uml.property  name="frameLineColor"
	 */
	public Color getFrameLineColor();


	/**
	 * 
	 * @return
	 */
	public float getAxisLineWidth( final String unit );


	/**
	 * 
	 * @return
	 */
	public float getTickMarkWidth( final String unit );


	/**
	 * 
	 * @return
	 */
	public float getTickMarkLength( final String unit );


	/**
	 * @return
	 * @uml.property  name="lineColor"
	 */
	public Color getLineColor();


	/**
	 * @param name
	 * @return
	 * @uml.property  name="fontName"
	 */
	public boolean setFontName( final String name );


	/**
	 * @param style
	 * @return
	 * @uml.property  name="fontStyle"
	 */
	public boolean setFontStyle( final int style );


	/**
	 * 
	 * @param size
	 * @return
	 */
	public boolean setFontSize( final float size );


	/**
	 * @param  cl
	 * @uml.property  name="stringColor"
	 */
	public boolean setStringColor( final Color cl );


	/**
	 * 
	 * @param b
	 */
	public boolean setFrameVisible( final boolean b );


	/**
	 * 
	 * @param width
	 */
	public boolean setFrameLineWidth( final float width, final String unit );


	/**
	 * @param  cl
	 * @uml.property  name="frameLineColor"
	 */
	public boolean setFrameLineColor( final Color cl );


	/**
	 * 
	 * @param width
	 * @return
	 */
	public boolean setAxisLineWidth( final float width, final String unit );


	/**
	 * 
	 * @param width
	 * @return
	 */
	public boolean setTickMarkWidth( final float width, final String unit );


	/**
	 * 
	 * @param len
	 * @return
	 */
	public boolean setTickMarkLength( final float len, final String unit );


	/**
	 * @param cl
	 * @return
	 * @uml.property  name="lineColor"
	 */
	public boolean setLineColor( final Color cl );


	/**
	 * 
	 * @param config - configuration in plane
	 * @return
	 */
	public SGIAxisPanelObserver getAxisPanelObserverInPlane( final int config );


	/**
	 * Returns the axis configuration of the selected tab.
	 * @return
	 */
	public int getAxisLocationForSelectedTab();


}


